use v6.c;
use Test;
use Range::SetOps;

#plan 1;

my @intersections = [
    [[(1..5),(3..10)], Set([$(3..5)])],
    [[(1..3),(4..10)], Set.new()],
    [[(1..3),Set($(1..7),$(2..3))], Set([$(2..3)])],

    [[(1.1..5),(3.1..10)], Set([$(3.1..5)])],
    [[(1.1..3),(4.1..10)], Set.new()],
    [[(1.1..3),Set($(1.2..7),$(2.1..3))], Set([$(2.1..3)])],

    [[(1..5.2),(3..10.2)], Set([$(3..5.2)])],
    [[(1..3.2),(4..10.2)], Set.new()],
    [[(1..3.2),Set($(1..7.2),$(2..3.6))], Set([$(2..3.2)])],

    [[(1.1..5.2),(3.1..10.7)], Set([$(3.1..5.2)])],
    [[(1.1..3.2),(4.1..10.7)], Set.new()],
    [[(1.1..3.3),Set($(1.2..7.6),$(2.1..3.5))], Set([$(2.1..3.3)])],

    [[("a".."d"),("c".."z")], Set([$("c".."d")]) ],
];

for @intersections -> [@list, $expect] {
    my $got = [(&)] @list;
    is-deeply( $got, $expect, "[(&)] {@list.perl} == {$expect.perl}" );
    $got = [∩] @list;
    is-deeply( $got, $expect, "[∩] {@list.perl} == {$expect.perl}" );
}

done-testing;
