/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.cache;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.cache.Cache;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.cache.Entry;
import org.apache.cxf.jaxrs.client.cache.Key;

@Priority(value=4999)
public class CacheControlClientRequestFilter
implements ClientRequestFilter {
    static final String NO_CACHE_PROPERTY = "no_client_cache";
    static final String CACHED_ENTITY_PROPERTY = "client_cached_entity";
    static final String CLIENT_ACCEPTS = "client_accepts";
    static final String CLIENT_CACHE_CONTROL = "client_cache_control";
    private Cache<Key, Entry> cache;

    public CacheControlClientRequestFilter(Cache<Key, Entry> cache) {
        this.setCache(cache);
    }

    public CacheControlClientRequestFilter() {
    }

    @Override
    public void filter(ClientRequestContext request) throws IOException {
        String accepts;
        if (!"GET".equals(request.getMethod())) {
            request.setProperty(NO_CACHE_PROPERTY, "true");
            return;
        }
        URI uri = request.getUri();
        Key key = new Key(uri, accepts = request.getHeaderString("Accept"));
        Entry entry = (Entry)this.cache.get((Object)key);
        if (entry != null) {
            if (entry.isOutDated()) {
                this.cache.remove((Object)key, (Object)entry);
            } else {
                Serializable cachedEntity = entry.getData();
                Response.ResponseBuilder ok = Response.ok(cachedEntity);
                if (entry.getHeaders() != null) {
                    for (Map.Entry h : entry.getHeaders().entrySet()) {
                        for (Object instance : (List)h.getValue()) {
                            ok = ok.header((String)h.getKey(), instance);
                        }
                    }
                }
                request.setProperty(CACHED_ENTITY_PROPERTY, cachedEntity);
                request.abortWith(ok.build());
            }
        }
        request.setProperty(CLIENT_ACCEPTS, accepts);
        request.setProperty(CLIENT_CACHE_CONTROL, request.getHeaderString("Cache-Control"));
    }

    public CacheControlClientRequestFilter setCache(Cache<Key, Entry> c) {
        this.cache = c;
        return this;
    }
}

