# this file tests how bag information could be accessed
BEGIN { chdir 't' if -d 't' }

use warnings;
use utf8;
use open ':std', ':encoding(utf8)';
use Test::More tests => 15;
use Test::File;
use strict;


use lib '../lib';

use File::Spec;
use Data::Printer;
use File::Path;
use File::Copy;
use File::Temp qw(tempdir);
use File::Slurp qw( read_file write_file);

my $dir = tempdir( CLEANUP => 1);

use_ok( 'Archive::BagIt::Base' );
mkdir (File::Spec->catdir($dir, "data"));
write_file( File::Spec->catdir( $dir, "data", "1.txt"), "1");
ok( Archive::BagIt::Base->make_bag( $dir ), "make_bag()");
file_exists_ok( File::Spec->catdir($dir, "bag-info.txt") );
file_exists_ok( File::Spec->catdir($dir, "bagit.txt") );
file_exists_ok( File::Spec->catdir($dir, "data", "1.txt"));
file_exists_ok( File::Spec->catdir($dir, "manifest-md5.txt"));
file_exists_ok( File::Spec->catdir($dir, "tagmanifest-md5.txt"));
file_exists_ok( File::Spec->catdir($dir, "manifest-sha512.txt"));
file_exists_ok( File::Spec->catdir($dir, "tagmanifest-sha512.txt"));
file_contains_utf8_like( File::Spec->catdir($dir, "bagit.txt"), qr{^BagIt-Version: 1.0$}m);
file_contains_utf8_like( File::Spec->catdir($dir, "bagit.txt"), qr{^Tag-File-Character-Encoding: UTF-8$}m);
file_contains_utf8_like( File::Spec->catdir($dir, "bag-info.txt"), qr{^Bagging-Date: \d\d\d\d-\d\d-\d\d$}m);
file_contains_utf8_like( File::Spec->catdir($dir, "bag-info.txt"), qr{^Bag-Software-Agent: Archive::BagIt}m);
file_contains_utf8_like( File::Spec->catdir($dir, "bag-info.txt"), qr{^Payload-Oxum: 1\.1$}m);
file_contains_utf8_like( File::Spec->catdir($dir, "bag-info.txt"), qr{^Bag-Size: 1 B$}m);

1;