package RogueCurses::Messages::messageparser;

use Curses;

### NOTE : build in an engine (inference?) for parsing messages which
###	   are displayed then talk about surroundings

sub new {
	my $class = shift;
	my $self = { 
		words => RogueCurses::Messages::messagewords->new,
	};
	$class = ref($class) || $class;

	bless $self, $class;
}

### partial grep of parser
sub parse_speed_partial_grep {
	my ($self, $msg, $surroundings) = @_;

	### FIXME use $surroundings

	### split $msg into words
	my @listmsg = split(/( |,|, | ,| , |.|. |'| '| ' )/, $msg);
	my $p = -1; ### output probability

	my @freenature = values $self->{words}->{freenaturenouns}; 
	my @dungeon = values $self->{words}->{dungeonnouns};
	my @creatures = values $self->{words}->{creaturesnouns};

	my @values = ();

	for (my $i = 0; $i < $#listmsg; $i++) {
		push (@values, grep(@listmsg[$i], @freenature));
		push (@values,  grep(@listmsg[$i], @dungeon));
		push (@values,  grep(@listmsg[$i], @creatures));
	}

	my $lubina = RogueCurses::Messages::Lubina::lubina->new;
	$lubina->work_on_nouns(@values);
	return $lubina->{probability};	
}

1;
