use strict;
use warnings;
use Test::More tests => 68;
use Digest::Shabal qw(shabal_224 shabal_224_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::Shabal->new(224)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            shabal_224_hex($data), $digest,
            "shabal_224_hex: $len bits of $msg"
        );
        ok(
            shabal_224($data) eq pack('H*', $digest),
            "shabal_224: $len bits of $msg"
        );
    }

    my $md = Digest::Shabal->new(224)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

__DATA__
00|562B4FDBE1706247552927F814B66A3D74B465A090AF23E277BF8029
00|2EEE860CB510243889D87529E33A529D642C27657CA9873AB119DFD9
C0|3901227E235E25722E284D214B6AC7C83ADDB6BCDD800EFD36872515
C0|CAFB881825F619DDB04319038DD585E81223DCD8AB92B019EB967930
80|6ADE1D54A4148EFA43C6B36490E1A0A6BE4F20CE5DC8669D8E5E8DB2
48|878DA03E6C7411A97F55BF934793B6E4B346E4DE73B2AA203BD04A8A
50|DD2A3C19998D5B57EAECA5B98D9BD93A11872B7E521462C0A10194AB
98|BE9FBD06418B3BB56328373E13FE6D2C25B85BFE3550468331B1A869
CC|63D1743B183146AC2A75416C9A0D88C66F85A422A43E3171EF9CC923
9800|DC8D84712480AB6BC805A04886FBB7E6F491712923F356D5036977BA
9D40|86D13B6CDA9DCF513E82194CAAA51291E446DF0FEFC22E545CF2E432
AA80|A1269C411F38F0AC12655866FBD68FA7E9D930501E6EB212E35A7568
9830|DDFF012A339B4E193D7BC1EC624517A5B13E858FE049323008EF6824
5030|3A2C35F5A00EEA93E0E51169B53B72B5D595F5F6AA54D98BBE966BD4
4D24|1F8024731022B897115C7680456A9DB86A1FE703C37EF48ADA8492C9
CBDE|DD3F5BA4ECD6517D889E873C0F990BEC873BEE1C24DDFA838D2C4A84
41FB|DE6707FEB8413D0621E40CC8F2843D369647055B35580533DB660B8B
4FF400|AC03910CA561AA319A9F047907917EBBBD05B53BBAD37900808F9BE0
FD0440|BB3D93A9128EE33CE0F62D0F3A4B09471A18A5400B6C789250519794
424D00|6E7A221907556DAE70117448ACC0885FE64E247E791880D97D9D575D
3FDEE0|9778F30016AB69BB8008F6BA7ED215AEA6E319310D3D618085F98BA6
335768|8803BBB424F5BC2F898960C17A703843913E8FE6DFA0F632EAAD15F0
051E7C|A4459973FD583AD9EC402FA5ABFFC617E867F05F4B15F53E933BF85F
717F8C|324B6A3844A225F2D8C8180C8DA611A0D95FF146B07230E7D1B243FE
1F877C|95D94B88F06C521E55000BD3019E1A45668E11AC9CD4511EEA490F5D
EB35CF80|CF2D3C1A9003835283368DF304295373BE44F9D2D315F4E189C0140C
B406C480|61A1A8C164A09B49E1C2DED0890886AB5A90EB12F89B3A064642D3AE
CEE88040|EEBDC08D30DB49CDE247A51F4BA28B29B817360E117737163ECC0E80
C584DB70|47FC61D24A86C9758710A663A133C6E8F8D6E7715B23557CDC822FA6
53587BC8|9E325E6B9A4F86E8F1C20D82BBF34A0B3329DBFF6CF66F2202478E13
69A305B0|FF6C89D5A7380C064CA041EAF720397D221571A0D58C28C7834E6C50
C9375ECE|AC7C6690960EFABF2F8125ACC1E44F1397DE2875DA0FAF5B2C7F4ABB
C1ECFDFC|223FEFCC0539D29CBCFB3D5F63B94D26D0035869B228F38955919686
8D73E8A280|CF7AFAB0295EFFE8C45876572F194EC52F6987F6288AA4DF8C895B24
06F2522080|BD9F96E85C69779773FF6BEFAAF164D76828DF08C7CC6D514320828F
3EF6C36F20|3DAC0A9E087F7A68B6C6D298B6FAA43DB5F33B994C4837369899EFD0
0127A1D340|D4CA00060E24806CA5FAB92F1B3A1812F4C4D70665A19BB911F0F9F9
6A6AB6C210|54EC61E05016EC38937A886B7C647201973ED543A8AACEACC3C7F236
AF3175E160|34DC5CC679942FD2B56443D062323BC986619D5ABDF974596CB19269
B66609ED86|C8015D5AC2243E4ED51666B13E0441355CC0FFC92C357C1273E405A4
21F134AC57|2247F2859C81D1E5807AD0CBEDA7969D190B3756A6F840E99A74064C
3DC2AADFFC80|781AD4B6CE7B2D69F954B589A9A4AEF042A64309D82434B7C7D0A63A
9202736D2240|A67311E04D66B1D4EAE563BB7C37507EE8D9D75456C84E240DDC0170
F219BD629820|8CCD580EE7ACC60F99BA90BF010705B07C84BE7F8AB5BB6FFFB64AEA
F3511EE2C4B0|50B0115ACB1AD4021B5A32AA2CE5BB793DC955F6C5F76233C1380010
3ECAB6BF7720|D5EA15F22AEB552F13861B4AF291401E0E03C1150CB74C34F0B5F3FE
CD62F688F498|9821F6C44F60AD26733676DE32F286C2FD43D4604E6A880E3B27AC56
C2CBAA33A9F8|337EDB67190EAD27C39F40132A27ED60F8DD73C16E03A2B735310662
C6F50BB74E29|12DB617D00712DD51EA545C2C0B8E7819AFA29E258DEE6553F1685F8
79F1B4CCC62A00|210A90C345CDEA430919720CB75B2C2BC7EC1A27A6C4025B18EC62F5
