#!/usr/bin/perl -w

# $Id $

use strict;
use warnings;
use Test::More tests => 7;

BEGIN { use_ok('Data::Hexify'); }

my $data = chr(0) x 256;
is(Hexify(\$data),
   <<'EOD', "plain");
  0000: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
          |
  00f0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
EOD

is(Hexify(\$data, { start => 16, length => 48 }),
   <<'EOD', "start, length");
  0010: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
          |
  0030: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
EOD

is(Hexify(\$data, { start => 16, length => 48, duplicates => 1 }),
   <<'EOD', "start, length, nodups");
  0010: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
  0020: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
  0030: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
EOD

is(Hexify(\$data, { start => 21, length => 48 }),
   <<'EOD', "start, length, lead");
  0010:                00 00 00 00 00 00 00 00 00 00 00       ...........
  0020: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
          |
  0040: 00 00 00 00 00                                   .....           
EOD

is(Hexify(\$data, { start => 21, length => 48, duplicates => 1 }),
   <<'EOD', "start, length, lead, nodups");
  0010:                00 00 00 00 00 00 00 00 00 00 00       ...........
  0020: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
  0030: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
  0040: 00 00 00 00 00                                   .....           
EOD

is(Hexify(\$data, { start => 3, length => 4 }),
   <<'EOD', "short");
  0000:          00 00 00 00                                ....         
EOD

