package Net::Async::Spotify::Object::Generated::PlayerError;

use strict;
use warnings;

our $VERSION = '0.001'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Base);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Generated::PlayerError - Package representing Spotify PlayerError Object

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#objects-index
Check C<crawl-api-doc.pl> for more information.

=head1 PARAMETERS

Those are Spotify PlayerError Object attributes:

=over 4

=item message

Type:String
Description:A short description of the cause of the error.

=item reason

Type:String
Description:

=item status

Type:Integer
Description:The HTTP status code. Either 404 NOT FOUND or 403 FORBIDDEN.  Also returned in the response header.

=back

=cut

sub new {
    my ($class, %args) = @_;

    my $fields = {
        message => 'String',
        reason => 'String',
        status => 'Integer',
    };

    my $obj = next::method($class, $fields, %args);

    return $obj;
}

1;
