package HTML::Dojo::src;
1;
__DATA__
__CPAN_DIR__ src
__CPAN_FILE__ src/DeferredList.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.require("dojo.Deferred");
dojo.provide("dojo.DeferredList");
dojo.DeferredList = function (list, fireOnOneCallback, fireOnOneErrback, consumeErrors, canceller) {
	this.list = list;
	this.resultList = new Array(this.list.length);
	this.chain = [];
	this.id = this._nextId();
	this.fired = -1;
	this.paused = 0;
	this.results = [null, null];
	this.canceller = canceller;
	this.silentlyCancelled = false;
	if (this.list.length === 0 && !fireOnOneCallback) {
		this.callback(this.resultList);
	}
	this.finishedCount = 0;
	this.fireOnOneCallback = fireOnOneCallback;
	this.fireOnOneErrback = fireOnOneErrback;
	this.consumeErrors = consumeErrors;
	var index = 0;
	var _this = this;
	dojo.lang.forEach(this.list, function (d) {
		var _index = index;
		d.addCallback(function (r) {
			_this._cbDeferred(_index, true, r);
		});
		d.addErrback(function (r) {
			_this._cbDeferred(_index, false, r);
		});
		index++;
	});
};
dojo.inherits(dojo.DeferredList, dojo.Deferred);
dojo.lang.extend(dojo.DeferredList, {_cbDeferred:function (index, succeeded, result) {
	this.resultList[index] = [succeeded, result];
	this.finishedCount += 1;
	if (this.fired !== 0) {
		if (succeeded && this.fireOnOneCallback) {
			this.callback([index, result]);
		} else {
			if (!succeeded && this.fireOnOneErrback) {
				this.errback(result);
			} else {
				if (this.finishedCount == this.list.length) {
					this.callback(this.resultList);
				}
			}
		}
	}
	if (!succeeded && this.consumeErrors) {
		result = null;
	}
	return result;
}, gatherResults:function (deferredList) {
	var d = new dojo.DeferredList(deferredList, false, true, false);
	d.addCallback(function (results) {
		var ret = [];
		for (var i = 0; i < results.length; i++) {
			ret.push(results[i][1]);
		}
		return ret;
	});
	return d;
}});


__CPAN_FILE__ src/ns.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.ns"]], definePackage:function (dojo) {
	dojo.provide("dojo.ns");
	dojo.ns = {namespaces:{}, failed:{}, loading:{}, loaded:{}, register:function (name, module, resolver, noOverride) {
		if (!noOverride || !this.namespaces[name]) {
			this.namespaces[name] = new dojo.ns.Ns(name, module, resolver);
		}
	}, allow:function (name) {
		if (this.failed[name]) {
			return false;
		}
		if ((djConfig.excludeNamespace) && (dojo.lang.inArray(djConfig.excludeNamespace, name))) {
			return false;
		}
		return ((name == this.dojo) || (!djConfig.includeNamespace) || (dojo.lang.inArray(djConfig.includeNamespace, name)));
	}, get:function (name) {
		return this.namespaces[name];
	}, require:function (name) {
		var ns = this.namespaces[name];
		if ((ns) && (this.loaded[name])) {
			return ns;
		}
		if (!this.allow(name)) {
			return false;
		}
		if (this.loading[name]) {
			dojo.debug("dojo.namespace.require: re-entrant request to load namespace \"" + name + "\" must fail.");
			return false;
		}
		var req = dojo.require;
		this.loading[name] = true;
		try {
			if (name == "dojo") {
				req("dojo.namespaces.dojo");
			} else {
				if (!dojo.hostenv.moduleHasPrefix(name)) {
					dojo.registerModulePath(name, "../" + name);
				}
				req([name, "manifest"].join("."), false, true);
			}
			if (!this.namespaces[name]) {
				this.failed[name] = true;
			}
		}
		finally {
			this.loading[name] = false;
		}
		return this.namespaces[name];
	}};
	dojo.ns.Ns = function (name, module, resolver) {
		this.name = name;
		this.module = module;
		this.resolver = resolver;
		this._loaded = [];
		this._failed = [];
	};
	dojo.ns.Ns.prototype.resolve = function (name, domain, omitModuleCheck) {
		if (!this.resolver || djConfig["skipAutoRequire"]) {
			return false;
		}
		var fullName = this.resolver(name, domain);
		if ((fullName) && (!this._loaded[fullName]) && (!this._failed[fullName])) {
			var req = dojo.require;
			req(fullName, false, true);
			if (dojo.hostenv.findModule(fullName, false)) {
				this._loaded[fullName] = true;
			} else {
				if (!omitModuleCheck) {
					dojo.raise("dojo.ns.Ns.resolve: module '" + fullName + "' not found after loading via namespace '" + this.name + "'");
				}
				this._failed[fullName] = true;
			}
		}
		return Boolean(this._loaded[fullName]);
	};
	dojo.registerNamespace = function (name, module, resolver) {
		dojo.ns.register.apply(dojo.ns, arguments);
	};
	dojo.registerNamespaceResolver = function (name, resolver) {
		var n = dojo.ns.namespaces[name];
		if (n) {
			n.resolver = resolver;
		}
	};
	dojo.registerNamespaceManifest = function (module, path, name, widgetModule, resolver) {
		dojo.registerModulePath(name, path);
		dojo.registerNamespace(name, widgetModule, resolver);
	};
	dojo.registerNamespace("dojo", "dojo.widget");
}});


__CPAN_FILE__ src/ns.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.ns");
dojo.ns = {namespaces:{}, failed:{}, loading:{}, loaded:{}, register:function (name, module, resolver, noOverride) {
	if (!noOverride || !this.namespaces[name]) {
		this.namespaces[name] = new dojo.ns.Ns(name, module, resolver);
	}
}, allow:function (name) {
	if (this.failed[name]) {
		return false;
	}
	if ((djConfig.excludeNamespace) && (dojo.lang.inArray(djConfig.excludeNamespace, name))) {
		return false;
	}
	return ((name == this.dojo) || (!djConfig.includeNamespace) || (dojo.lang.inArray(djConfig.includeNamespace, name)));
}, get:function (name) {
	return this.namespaces[name];
}, require:function (name) {
	var ns = this.namespaces[name];
	if ((ns) && (this.loaded[name])) {
		return ns;
	}
	if (!this.allow(name)) {
		return false;
	}
	if (this.loading[name]) {
		dojo.debug("dojo.namespace.require: re-entrant request to load namespace \"" + name + "\" must fail.");
		return false;
	}
	var req = dojo.require;
	this.loading[name] = true;
	try {
		if (name == "dojo") {
			req("dojo.namespaces.dojo");
		} else {
			if (!dojo.hostenv.moduleHasPrefix(name)) {
				dojo.registerModulePath(name, "../" + name);
			}
			req([name, "manifest"].join("."), false, true);
		}
		if (!this.namespaces[name]) {
			this.failed[name] = true;
		}
	}
	finally {
		this.loading[name] = false;
	}
	return this.namespaces[name];
}};
dojo.ns.Ns = function (name, module, resolver) {
	this.name = name;
	this.module = module;
	this.resolver = resolver;
	this._loaded = [];
	this._failed = [];
};
dojo.ns.Ns.prototype.resolve = function (name, domain, omitModuleCheck) {
	if (!this.resolver || djConfig["skipAutoRequire"]) {
		return false;
	}
	var fullName = this.resolver(name, domain);
	if ((fullName) && (!this._loaded[fullName]) && (!this._failed[fullName])) {
		var req = dojo.require;
		req(fullName, false, true);
		if (dojo.hostenv.findModule(fullName, false)) {
			this._loaded[fullName] = true;
		} else {
			if (!omitModuleCheck) {
				dojo.raise("dojo.ns.Ns.resolve: module '" + fullName + "' not found after loading via namespace '" + this.name + "'");
			}
			this._failed[fullName] = true;
		}
	}
	return Boolean(this._loaded[fullName]);
};
dojo.registerNamespace = function (name, module, resolver) {
	dojo.ns.register.apply(dojo.ns, arguments);
};
dojo.registerNamespaceResolver = function (name, resolver) {
	var n = dojo.ns.namespaces[name];
	if (n) {
		n.resolver = resolver;
	}
};
dojo.registerNamespaceManifest = function (module, path, name, widgetModule, resolver) {
	dojo.registerModulePath(name, path);
	dojo.registerNamespace(name, widgetModule, resolver);
};
dojo.registerNamespace("dojo", "dojo.widget");


__CPAN_FILE__ src/date.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.date");
dojo.deprecated("dojo.date", "use one of the modules in dojo.date.* instead", "0.5");


__CPAN_FILE__ src/Deferred.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.Deferred");
dojo.require("dojo.lang.func");
dojo.Deferred = function (canceller) {
	this.chain = [];
	this.id = this._nextId();
	this.fired = -1;
	this.paused = 0;
	this.results = [null, null];
	this.canceller = canceller;
	this.silentlyCancelled = false;
};
dojo.lang.extend(dojo.Deferred, {getFunctionFromArgs:function () {
	var a = arguments;
	if ((a[0]) && (!a[1])) {
		if (dojo.lang.isFunction(a[0])) {
			return a[0];
		} else {
			if (dojo.lang.isString(a[0])) {
				return dj_global[a[0]];
			}
		}
	} else {
		if ((a[0]) && (a[1])) {
			return dojo.lang.hitch(a[0], a[1]);
		}
	}
	return null;
}, makeCalled:function () {
	var deferred = new dojo.Deferred();
	deferred.callback();
	return deferred;
}, repr:function () {
	var state;
	if (this.fired == -1) {
		state = "unfired";
	} else {
		if (this.fired == 0) {
			state = "success";
		} else {
			state = "error";
		}
	}
	return "Deferred(" + this.id + ", " + state + ")";
}, toString:dojo.lang.forward("repr"), _nextId:(function () {
	var n = 1;
	return function () {
		return n++;
	};
})(), cancel:function () {
	if (this.fired == -1) {
		if (this.canceller) {
			this.canceller(this);
		} else {
			this.silentlyCancelled = true;
		}
		if (this.fired == -1) {
			this.errback(new Error(this.repr()));
		}
	} else {
		if ((this.fired == 0) && (this.results[0] instanceof dojo.Deferred)) {
			this.results[0].cancel();
		}
	}
}, _pause:function () {
	this.paused++;
}, _unpause:function () {
	this.paused--;
	if ((this.paused == 0) && (this.fired >= 0)) {
		this._fire();
	}
}, _continue:function (res) {
	this._resback(res);
	this._unpause();
}, _resback:function (res) {
	this.fired = ((res instanceof Error) ? 1 : 0);
	this.results[this.fired] = res;
	this._fire();
}, _check:function () {
	if (this.fired != -1) {
		if (!this.silentlyCancelled) {
			dojo.raise("already called!");
		}
		this.silentlyCancelled = false;
		return;
	}
}, callback:function (res) {
	this._check();
	this._resback(res);
}, errback:function (res) {
	this._check();
	if (!(res instanceof Error)) {
		res = new Error(res);
	}
	this._resback(res);
}, addBoth:function (cb, cbfn) {
	var enclosed = this.getFunctionFromArgs(cb, cbfn);
	if (arguments.length > 2) {
		enclosed = dojo.lang.curryArguments(null, enclosed, arguments, 2);
	}
	return this.addCallbacks(enclosed, enclosed);
}, addCallback:function (cb, cbfn) {
	var enclosed = this.getFunctionFromArgs(cb, cbfn);
	if (arguments.length > 2) {
		enclosed = dojo.lang.curryArguments(null, enclosed, arguments, 2);
	}
	return this.addCallbacks(enclosed, null);
}, addErrback:function (cb, cbfn) {
	var enclosed = this.getFunctionFromArgs(cb, cbfn);
	if (arguments.length > 2) {
		enclosed = dojo.lang.curryArguments(null, enclosed, arguments, 2);
	}
	return this.addCallbacks(null, enclosed);
	return this.addCallbacks(null, cbfn);
}, addCallbacks:function (cb, eb) {
	this.chain.push([cb, eb]);
	if (this.fired >= 0) {
		this._fire();
	}
	return this;
}, _fire:function () {
	var chain = this.chain;
	var fired = this.fired;
	var res = this.results[fired];
	var self = this;
	var cb = null;
	while (chain.length > 0 && this.paused == 0) {
		var pair = chain.shift();
		var f = pair[fired];
		if (f == null) {
			continue;
		}
		try {
			res = f(res);
			fired = ((res instanceof Error) ? 1 : 0);
			if (res instanceof dojo.Deferred) {
				cb = function (res) {
					self._continue(res);
				};
				this._pause();
			}
		}
		catch (err) {
			fired = 1;
			res = err;
		}
	}
	this.fired = fired;
	this.results[fired] = res;
	if ((cb) && (this.paused)) {
		res.addBoth(cb);
	}
}});


__CPAN_FILE__ src/animation.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.animation");
dojo.require("dojo.animation.Animation");
dojo.deprecated("dojo.animation is slated for removal in 0.5; use dojo.lfx instead.", "0.5");


__CPAN_FILE__ src/behavior.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.behavior");
dojo.require("dojo.event.*");
dojo.require("dojo.experimental");
dojo.experimental("dojo.behavior");
dojo.behavior = new function () {
	function arrIn(obj, name) {
		if (!obj[name]) {
			obj[name] = [];
		}
		return obj[name];
	}
	function forIn(obj, scope, func) {
		var tmpObj = {};
		for (var x in obj) {
			if (typeof tmpObj[x] == "undefined") {
				if (!func) {
					scope(obj[x], x);
				} else {
					func.call(scope, obj[x], x);
				}
			}
		}
	}
	this.behaviors = {};
	this.add = function (behaviorObj) {
		var tmpObj = {};
		forIn(behaviorObj, this, function (behavior, name) {
			var tBehavior = arrIn(this.behaviors, name);
			if ((dojo.lang.isString(behavior)) || (dojo.lang.isFunction(behavior))) {
				behavior = {found:behavior};
			}
			forIn(behavior, function (rule, ruleName) {
				arrIn(tBehavior, ruleName).push(rule);
			});
		});
	};
	this.apply = function () {
		dojo.profile.start("dojo.behavior.apply");
		var r = dojo.render.html;
		var safariGoodEnough = (!r.safari);
		if (r.safari) {
			var uas = r.UA.split("AppleWebKit/")[1];
			if (parseInt(uas.match(/[0-9.]{3,}/)) >= 420) {
				safariGoodEnough = true;
			}
		}
		if ((dj_undef("behaviorFastParse", djConfig) ? (safariGoodEnough) : djConfig["behaviorFastParse"])) {
			this.applyFast();
		} else {
			this.applySlow();
		}
		dojo.profile.end("dojo.behavior.apply");
	};
	this.matchCache = {};
	this.elementsById = function (id, handleRemoved) {
		var removed = [];
		var added = [];
		arrIn(this.matchCache, id);
		if (handleRemoved) {
			var nodes = this.matchCache[id];
			for (var x = 0; x < nodes.length; x++) {
				if (nodes[x].id != "") {
					removed.push(nodes[x]);
					nodes.splice(x, 1);
					x--;
				}
			}
		}
		var tElem = dojo.byId(id);
		while (tElem) {
			if (!tElem["idcached"]) {
				added.push(tElem);
			}
			tElem.id = "";
			tElem = dojo.byId(id);
		}
		this.matchCache[id] = this.matchCache[id].concat(added);
		dojo.lang.forEach(this.matchCache[id], function (node) {
			node.id = id;
			node.idcached = true;
		});
		return {"removed":removed, "added":added, "match":this.matchCache[id]};
	};
	this.applyToNode = function (node, action, ruleSetName) {
		if (typeof action == "string") {
			dojo.event.topic.registerPublisher(action, node, ruleSetName);
		} else {
			if (typeof action == "function") {
				if (ruleSetName == "found") {
					action(node);
				} else {
					dojo.event.connect(node, ruleSetName, action);
				}
			} else {
				action.srcObj = node;
				action.srcFunc = ruleSetName;
				dojo.event.kwConnect(action);
			}
		}
	};
	this.applyFast = function () {
		dojo.profile.start("dojo.behavior.applyFast");
		forIn(this.behaviors, function (tBehavior, id) {
			var elems = dojo.behavior.elementsById(id);
			dojo.lang.forEach(elems.added, function (elem) {
				forIn(tBehavior, function (ruleSet, ruleSetName) {
					if (dojo.lang.isArray(ruleSet)) {
						dojo.lang.forEach(ruleSet, function (action) {
							dojo.behavior.applyToNode(elem, action, ruleSetName);
						});
					}
				});
			});
		});
		dojo.profile.end("dojo.behavior.applyFast");
	};
	this.applySlow = function () {
		dojo.profile.start("dojo.behavior.applySlow");
		var all = document.getElementsByTagName("*");
		var allLen = all.length;
		for (var x = 0; x < allLen; x++) {
			var elem = all[x];
			if ((elem.id) && (!elem["behaviorAdded"]) && (this.behaviors[elem.id])) {
				elem["behaviorAdded"] = true;
				forIn(this.behaviors[elem.id], function (ruleSet, ruleSetName) {
					if (dojo.lang.isArray(ruleSet)) {
						dojo.lang.forEach(ruleSet, function (action) {
							dojo.behavior.applyToNode(elem, action, ruleSetName);
						});
					}
				});
			}
		}
		dojo.profile.end("dojo.behavior.applySlow");
	};
};
dojo.addOnLoad(dojo.behavior, "apply");


__CPAN_FILE__ src/hostenv_adobesvg.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



if (typeof window == "undefined") {
	dojo.raise("attempt to use adobe svg hostenv when no window object");
}
with (dojo.render) {
	name = navigator.appName;
	ver = parseFloat(navigator.appVersion, 10);
	switch (navigator.platform) {
	  case "MacOS":
		os.osx = true;
		break;
	  case "Linux":
		os.linux = true;
		break;
	  case "Windows":
		os.win = true;
		break;
	  default:
		os.linux = true;
		break;
	}
	svg.capable = true;
	svg.support.builtin = true;
	svg.adobe = true;
}
dojo.hostenv.println = function (s) {
	try {
		var ti = document.createElement("text");
		ti.setAttribute("x", "50");
		var yPos = 25 + 15 * document.getElementsByTagName("text").length;
		ti.setAttribute("y", yPos);
		var tn = document.createTextNode(s);
		ti.appendChild(tn);
		document.documentElement.appendChild(ti);
	}
	catch (e) {
	}
};
dojo.debug = function () {
	if (!djConfig.isDebug) {
		return;
	}
	var args = arguments;
	if (typeof dojo.hostenv.println != "function") {
		dojo.raise("attempt to call dojo.debug when there is no dojo.hostenv println implementation (yet?)");
	}
	var isJUM = dj_global["jum"];
	var s = isJUM ? "" : "DEBUG: ";
	for (var i = 0; i < args.length; ++i) {
		s += args[i];
	}
	if (isJUM) {
		jum.debug(s);
	} else {
		dojo.hostenv.println(s);
	}
};
dojo.hostenv.startPackage("dojo.hostenv");
dojo.hostenv.name_ = "adobesvg";
dojo.hostenv.anonCtr = 0;
dojo.hostenv.anon = {};
dojo.hostenv.nameAnonFunc = function (anonFuncPtr, namespaceObj) {
	var ret = "_" + this.anonCtr++;
	var nso = (namespaceObj || this.anon);
	while (typeof nso[ret] != "undefined") {
		ret = "_" + this.anonCtr++;
	}
	nso[ret] = anonFuncPtr;
	return ret;
};
dojo.hostenv.modulesLoadedFired = false;
dojo.hostenv.modulesLoadedListeners = [];
dojo.hostenv.getTextStack = [];
dojo.hostenv.loadUriStack = [];
dojo.hostenv.loadedUris = [];
dojo.hostenv.modulesLoaded = function () {
	if (this.modulesLoadedFired) {
		return;
	}
	if ((this.loadUriStack.length == 0) && (this.getTextStack.length == 0)) {
		if (this.inFlightCount > 0) {
			dojo.debug("couldn't initialize, there are files still in flight");
			return;
		}
		this.modulesLoadedFired = true;
		var mll = this.modulesLoadedListeners;
		for (var x = 0; x < mll.length; x++) {
			mll[x]();
		}
	}
};
dojo.hostenv.getNewAnonFunc = function () {
	var ret = "_" + this.anonCtr++;
	while (typeof this.anon[ret] != "undefined") {
		ret = "_" + this.anonCtr++;
	}
	eval("dojo.nostenv.anon." + ret + " = function(){};");
	return [ret, this.anon[ret]];
};
dojo.hostenv.displayStack = function () {
	var oa = [];
	var stack = this.loadUriStack;
	for (var x = 0; x < stack.length; x++) {
		oa.unshift([stack[x][0], (typeof stack[x][2])]);
	}
	dojo.debug("<pre>" + oa.join("\n") + "</pre>");
};
dojo.hostenv.unwindUriStack = function () {
	var stack = this.loadUriStack;
	for (var x in dojo.hostenv.loadedUris) {
		for (var y = stack.length - 1; y >= 0; y--) {
			if (stack[y][0] == x) {
				stack.splice(y, 1);
			}
		}
	}
	var next = stack.pop();
	if ((!next) && (stack.length == 0)) {
		return;
	}
	for (var x = 0; x < stack.length; x++) {
		if ((stack[x][0] == next[0]) && (stack[x][2])) {
			next[2] == stack[x][2];
		}
	}
	var last = next;
	while (dojo.hostenv.loadedUris[next[0]]) {
		last = next;
		next = stack.pop();
	}
	while (typeof next[2] == "string") {
		try {
			dj_eval(next[2]);
			next[1](true);
		}
		catch (e) {
			dojo.debug("we got an error when loading " + next[0]);
			dojo.debug("error: " + e);
		}
		dojo.hostenv.loadedUris[next[0]] = true;
		dojo.hostenv.loadedUris.push(next[0]);
		last = next;
		next = stack.pop();
		if ((!next) && (stack.length == 0)) {
			break;
		}
		while (dojo.hostenv.loadedUris[next[0]]) {
			last = next;
			next = stack.pop();
		}
	}
	if (next) {
		stack.push(next);
		dojo.debug("### CHOKED ON: " + next[0]);
	}
};
dojo.hostenv.loadUri = function (uri, cb) {
	if (dojo.hostenv.loadedUris[uri]) {
		return;
	}
	var stack = this.loadUriStack;
	stack.push([uri, cb, null]);
	var tcb = function (contents) {
		if (contents.content) {
			contents = contents.content;
		}
		var next = stack.pop();
		if ((!next) && (stack.length == 0)) {
			dojo.hostenv.modulesLoaded();
			return;
		}
		if (typeof contents == "string") {
			stack.push(next);
			for (var x = 0; x < stack.length; x++) {
				if (stack[x][0] == uri) {
					stack[x][2] = contents;
				}
			}
			next = stack.pop();
		}
		if (dojo.hostenv.loadedUris[next[0]]) {
			dojo.hostenv.unwindUriStack();
			return;
		}
		stack.push(next);
		if (next[0] != uri) {
			if (typeof next[2] == "string") {
				dojo.hostenv.unwindUriStack();
			}
		} else {
			if (!contents) {
				next[1](false);
			} else {
				var deps = dojo.hostenv.getDepsForEval(next[2]);
				if (deps.length > 0) {
					eval(deps.join(";"));
				} else {
					dojo.hostenv.unwindUriStack();
				}
			}
		}
	};
	this.getText(uri, tcb, true);
};
dojo.hostenv.loadModule = function (modulename, exact_only, omit_module_check) {
	var module = this.findModule(modulename, 0);
	if (module) {
		return module;
	}
	if (typeof this.loading_modules_[modulename] !== "undefined") {
		dojo.debug("recursive attempt to load module '" + modulename + "'");
	} else {
		this.addedToLoadingCount.push(modulename);
	}
	this.loading_modules_[modulename] = 1;
	var relpath = modulename.replace(/\./g, "/") + ".js";
	var syms = modulename.split(".");
	var nsyms = modulename.split(".");
	if (syms[0] == "dojo") {
		syms[0] = "src";
	}
	var last = syms.pop();
	syms.push(last);
	var _this = this;
	var pfn = this.pkgFileName;
	if (last == "*") {
		modulename = (nsyms.slice(0, -1)).join(".");
		var module = this.findModule(modulename, 0);
		if (module) {
			_this.removedFromLoadingCount.push(modulename);
			return module;
		}
		var nextTry = function (lastStatus) {
			if (lastStatus) {
				module = _this.findModule(modulename, false);
				if ((!module) && (syms[syms.length - 1] != pfn)) {
					dojo.raise("Module symbol '" + modulename + "' is not defined after loading '" + relpath + "'");
				}
				if (module) {
					_this.removedFromLoadingCount.push(modulename);
					dojo.hostenv.modulesLoaded();
					return;
				}
			}
			syms.pop();
			syms.push(pfn);
			relpath = syms.join("/") + ".js";
			if (relpath.charAt(0) == "/") {
				relpath = relpath.slice(1);
			}
			_this.loadPath(relpath, ((!omit_module_check) ? modulename : null), nextTry);
		};
		nextTry();
	} else {
		relpath = syms.join("/") + ".js";
		modulename = nsyms.join(".");
		var nextTry = function (lastStatus) {
			if (lastStatus) {
				module = _this.findModule(modulename, false);
				if ((!module) && (syms[syms.length - 1] != pfn)) {
					dojo.raise("Module symbol '" + modulename + "' is not defined after loading '" + relpath + "'");
				}
				if (module) {
					_this.removedFromLoadingCount.push(modulename);
					dojo.hostenv.modulesLoaded();
					return;
				}
			}
			var setPKG = (syms[syms.length - 1] == pfn) ? false : true;
			syms.pop();
			if (setPKG) {
				syms.push(pfn);
			}
			relpath = syms.join("/") + ".js";
			if (relpath.charAt(0) == "/") {
				relpath = relpath.slice(1);
			}
			_this.loadPath(relpath, ((!omit_module_check) ? modulename : null), nextTry);
		};
		this.loadPath(relpath, ((!omit_module_check) ? modulename : null), nextTry);
	}
	return;
};
dojo.hostenv.async_cb = null;
dojo.hostenv.unWindGetTextStack = function () {
	if (dojo.hostenv.inFlightCount > 0) {
		setTimeout("dojo.hostenv.unWindGetTextStack()", 100);
		return;
	}
	dojo.hostenv.inFlightCount++;
	var next = dojo.hostenv.getTextStack.pop();
	if ((!next) && (dojo.hostenv.getTextStack.length == 0)) {
		dojo.hostenv.inFlightCount--;
		dojo.hostenv.async_cb = function () {
		};
		return;
	}
	dojo.hostenv.async_cb = next[1];
	window.getURL(next[0], function (result) {
		dojo.hostenv.inFlightCount--;
		dojo.hostenv.async_cb(result.content);
		dojo.hostenv.unWindGetTextStack();
	});
};
dojo.hostenv.getText = function (uri, async_cb, fail_ok) {
	try {
		if (async_cb) {
			dojo.hostenv.getTextStack.push([uri, async_cb, fail_ok]);
			dojo.hostenv.unWindGetTextStack();
		} else {
			return dojo.raise("No synchronous XMLHTTP implementation available, for uri " + uri);
		}
	}
	catch (e) {
		return dojo.raise("No XMLHTTP implementation available, for uri " + uri);
	}
};
dojo.hostenv.postText = function (uri, async_cb, text, fail_ok, mime_type, encoding) {
	var http = null;
	var async_callback = function (httpResponse) {
		if (!httpResponse.success) {
			dojo.raise("Request for uri '" + uri + "' resulted in " + httpResponse.status);
		}
		if (!httpResponse.content) {
			if (!fail_ok) {
				dojo.raise("Request for uri '" + uri + "' resulted in no content");
			}
			return null;
		}
		async_cb(httpResponse.content);
	};
	try {
		if (async_cb) {
			http = window.postURL(uri, text, async_callback, mimeType, encoding);
		} else {
			return dojo.raise("No synchronous XMLHTTP post implementation available, for uri " + uri);
		}
	}
	catch (e) {
		return dojo.raise("No XMLHTTP post implementation available, for uri " + uri);
	}
};
function dj_last_script_src() {
	var scripts = window.document.getElementsByTagName("script");
	if (scripts.length < 1) {
		dojo.raise("No script elements in window.document, so can't figure out my script src");
	}
	var li = scripts.length - 1;
	var xlinkNS = "http://www.w3.org/1999/xlink";
	var src = null;
	var script = null;
	while (!src) {
		script = scripts.item(li);
		src = script.getAttributeNS(xlinkNS, "href");
		li--;
		if (li < 0) {
			break;
		}
	}
	if (!src) {
		dojo.raise("Last script element (out of " + scripts.length + ") has no src");
	}
	return src;
}
if (!dojo.hostenv["library_script_uri_"]) {
	dojo.hostenv.library_script_uri_ = dj_last_script_src();
}
dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");


__CPAN_FILE__ src/debug.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.debug");
dojo.debug = function () {
	if (!djConfig.isDebug) {
		return;
	}
	var args = arguments;
	if (dj_undef("println", dojo.hostenv)) {
		dojo.raise("dojo.debug not available (yet?)");
	}
	var isJUM = dj_global["jum"] && !dj_global["jum"].isBrowser;
	var s = [(isJUM ? "" : "DEBUG: ")];
	for (var i = 0; i < args.length; ++i) {
		if (!false && args[i] && args[i] instanceof Error) {
			var msg = "[" + args[i].name + ": " + dojo.errorToString(args[i]) + (args[i].fileName ? ", file: " + args[i].fileName : "") + (args[i].lineNumber ? ", line: " + args[i].lineNumber : "") + "]";
		} else {
			try {
				var msg = String(args[i]);
			}
			catch (e) {
				if (dojo.render.html.ie) {
					var msg = "[ActiveXObject]";
				} else {
					var msg = "[unknown]";
				}
			}
		}
		s.push(msg);
	}
	dojo.hostenv.println(s.join(" "));
};
dojo.debugShallow = function (obj) {
	if (!djConfig.isDebug) {
		return;
	}
	dojo.debug("------------------------------------------------------------");
	dojo.debug("Object: " + obj);
	var props = [];
	for (var prop in obj) {
		try {
			props.push(prop + ": " + obj[prop]);
		}
		catch (E) {
			props.push(prop + ": ERROR - " + E.message);
		}
	}
	props.sort();
	for (var i = 0; i < props.length; i++) {
		dojo.debug(props[i]);
	}
	dojo.debug("------------------------------------------------------------");
};
dojo.debugDeep = function (obj) {
	if (!djConfig.isDebug) {
		return;
	}
	if (!dojo.uri || !dojo.uri.dojoUri) {
		return dojo.debug("You'll need to load dojo.uri.* for deep debugging - sorry!");
	}
	if (!window.open) {
		return dojo.debug("Deep debugging is only supported in host environments with window.open");
	}
	var idx = dojo.debugDeep.debugVars.length;
	dojo.debugDeep.debugVars.push(obj);
	var url = (djConfig["dojoDebugDeepHtmlUrl"] || new dojo.uri.Uri(location, dojo.uri.moduleUri("dojo.debug", "deep.html")).toString()) + "?var=" + idx;
	var win = window.open(url, "_blank", "width=600, height=400, resizable=yes, scrollbars=yes, status=yes");
	try {
		win.debugVar = obj;
	}
	catch (e) {
	}
};
dojo.debugDeep.debugVars = [];


__CPAN_FILE__ src/hostenv_spidermonkey.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.name_ = "spidermonkey";
dojo.hostenv.println = print;
dojo.hostenv.exit = function (exitcode) {
	quit(exitcode);
};
dojo.hostenv.getVersion = function () {
	return version();
};
if (typeof line2pc == "undefined") {
	dojo.raise("attempt to use SpiderMonkey host environment when no 'line2pc' global");
}
function dj_spidermonkey_current_file(depth) {
	var s = "";
	try {
		throw Error("whatever");
	}
	catch (e) {
		s = e.stack;
	}
	var matches = s.match(/[^@]*\.js/gi);
	if (!matches) {
		dojo.raise("could not parse stack string: '" + s + "'");
	}
	var fname = (typeof depth != "undefined" && depth) ? matches[depth + 1] : matches[matches.length - 1];
	if (!fname) {
		dojo.raise("could not find file name in stack string '" + s + "'");
	}
	return fname;
}
if (!dojo.hostenv.library_script_uri_) {
	dojo.hostenv.library_script_uri_ = dj_spidermonkey_current_file(0);
}
dojo.hostenv.loadUri = function (uri) {
	var ok = load(uri);
	return 1;
};
dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");


__CPAN_FILE__ src/hostenv_dashboard.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({definePackage:function (dojo) {
	dojo.render.name = dojo.hostenv.name_ = "dashboard";
	dojo.hostenv.println = function (message) {
		return alert(message);
	};
	dojo.hostenv.getXmlhttpObject = function (kwArgs) {
		if (widget.system && kwArgs) {
			if ((kwArgs.contentType && kwArgs.contentType.indexOf("text/") != 0) || (kwArgs.headers && kwArgs.headers["content-type"] && kwArgs.headers["content-type"].indexOf("text/") != 0)) {
				var curl = new dojo.hostenv.CurlRequest;
				curl._save = true;
				return curl;
			} else {
				if (kwArgs.method && kwArgs.method.toUpperCase() == "HEAD") {
					return new dojo.hostenv.CurlRequest;
				} else {
					if (kwArgs.headers && kwArgs.header.referer) {
						return new dojo.hostenv.CurlRequest;
					}
				}
			}
		}
		return new XMLHttpRequest;
	};
	dojo.hostenv.CurlRequest = function () {
		this.onreadystatechange = null;
		this.readyState = 0;
		this.responseText = "";
		this.responseXML = null;
		this.status = 0;
		this.statusText = "";
		this._method = "";
		this._url = "";
		this._async = true;
		this._referrer = "";
		this._headers = [];
		this._save = false;
		this._responseHeader = "";
		this._responseHeaders = {};
		this._fileName = "";
		this._username = "";
		this._password = "";
	};
	dojo.hostenv.CurlRequest.prototype.open = function (method, url, async, username, password) {
		this._method = method;
		this._url = url;
		if (async) {
			this._async = async;
		}
		if (username) {
			this._username = username;
		}
		if (password) {
			this._password = password;
		}
	};
	dojo.hostenv.CurlRequest.prototype.setRequestHeader = function (label, value) {
		switch (label) {
		  case "Referer":
			this._referrer = value;
			break;
		  case "content-type":
			break;
		  default:
			this._headers.push(label + "=" + value);
			break;
		}
	};
	dojo.hostenv.CurlRequest.prototype.getAllResponseHeaders = function () {
		return this._responseHeader;
	};
	dojo.hostenv.CurlRequest.prototype.getResponseHeader = function (headerLabel) {
		return this._responseHeaders[headerLabel];
	};
	dojo.hostenv.CurlRequest.prototype.send = function (content) {
		this.readyState = 1;
		if (this.onreadystatechange) {
			this.onreadystatechange.call(this);
		}
		var query = {sS:""};
		if (this._referrer) {
			query.e = this._referrer;
		}
		if (this._headers.length) {
			query.H = this._headers.join("&");
		}
		if (this._username) {
			if (this._password) {
				query.u = this._username + ":" + this._password;
			} else {
				query.u = this._username;
			}
		}
		if (content) {
			query.d = this.content;
			if (this._method != "POST") {
				query.G = "";
			}
		}
		if (this._method == "HEAD") {
			query.I = "";
		} else {
			if (this._save) {
				query.I = "";
			} else {
				query.i = "";
			}
		}
		var system = widget.system(dojo.hostenv.CurlRequest._formatCall(query, this._url), null);
		this.readyState = 2;
		if (this.onreadystatechange) {
			this.onreadystatechange.call(this);
		}
		if (system.errorString) {
			this.responseText = system.errorString;
			this.status = 0;
		} else {
			if (this._save) {
				this._responseHeader = system.outputString;
			} else {
				var split = system.outputString.replace(/\r/g, "").split("\n\n", 2);
				this._responseHeader = split[0];
				this.responseText = split[1];
			}
			split = this._responseHeader.split("\n");
			this.statusText = split.shift();
			this.status = this.statusText.split(" ")[1];
			for (var i = 0, header; header = split[i]; i++) {
				var header_split = header.split(": ", 2);
				this._responseHeaders[header_split[0]] = header_split[1];
			}
			if (this._save) {
				widget.system("/bin/mkdir cache", null);
				this._fileName = this._url.split("/").pop().replace(/\W/g, "");
				this._fileName += "." + this._responseHeaders["Content-Type"].replace(/[\r\n]/g, "").split("/").pop();
				delete query.I;
				query.o = "cache/" + this._fileName;
				system = widget.system(dojo.hostenv.CurlRequest._formatCall(query, this._url), null);
				if (!system.errorString) {
					this.responseText = "cache/" + this._fileName;
				}
			} else {
				if (this._method == "HEAD") {
					this.responseText = this._responseHeader;
				}
			}
		}
		this.readyState = 4;
		if (this.onreadystatechange) {
			this.onreadystatechange.call(this);
		}
	};
	dojo.hostenv.CurlRequest._formatCall = function (query, url) {
		var call = ["/usr/bin/curl"];
		for (var key in query) {
			if (query[key] != "") {
				call.push("-" + key + " '" + query[key].replace(/'/g, "'") + "'");
			} else {
				call.push("-" + key);
			}
		}
		call.push("'" + url.replace(/'/g, "'") + "'");
		return call.join(" ");
	};
	dojo.hostenv.exit = function () {
		if (widget.system) {
			widget.system("/bin/rm -rf cache/*", null);
		}
	};
}});


__CPAN_FILE__ src/validate.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.validate"], ["require", "dojo.validate.common"]], definePackage:function (dojo) {
	dojo.provide("dojo.validate");
	dojo.require("dojo.validate.common");
}});


__CPAN_FILE__ src/iCalendar.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["require", "dojo.cal.iCalendar"]], definePackage:function (dojo) {
	dojo.require("dojo.cal.iCalendar");
	dojo.deprecated("dojo.icalendar", "use dojo.cal.iCalendar isntead", "0.5");
}});


__CPAN_FILE__ src/debug.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.debug"]], definePackage:function (dojo) {
	dojo.provide("dojo.debug");
	dojo.debug = function () {
		if (!djConfig.isDebug) {
			return;
		}
		var args = arguments;
		if (dj_undef("println", dojo.hostenv)) {
			dojo.raise("dojo.debug not available (yet?)");
		}
		var isJUM = dj_global["jum"] && !dj_global["jum"].isBrowser;
		var s = [(isJUM ? "" : "DEBUG: ")];
		for (var i = 0; i < args.length; ++i) {
			if (!false && args[i] && args[i] instanceof Error) {
				var msg = "[" + args[i].name + ": " + dojo.errorToString(args[i]) + (args[i].fileName ? ", file: " + args[i].fileName : "") + (args[i].lineNumber ? ", line: " + args[i].lineNumber : "") + "]";
			} else {
				try {
					var msg = String(args[i]);
				}
				catch (e) {
					if (dojo.render.html.ie) {
						var msg = "[ActiveXObject]";
					} else {
						var msg = "[unknown]";
					}
				}
			}
			s.push(msg);
		}
		dojo.hostenv.println(s.join(" "));
	};
	dojo.debugShallow = function (obj) {
		if (!djConfig.isDebug) {
			return;
		}
		dojo.debug("------------------------------------------------------------");
		dojo.debug("Object: " + obj);
		var props = [];
		for (var prop in obj) {
			try {
				props.push(prop + ": " + obj[prop]);
			}
			catch (E) {
				props.push(prop + ": ERROR - " + E.message);
			}
		}
		props.sort();
		for (var i = 0; i < props.length; i++) {
			dojo.debug(props[i]);
		}
		dojo.debug("------------------------------------------------------------");
	};
	dojo.debugDeep = function (obj) {
		if (!djConfig.isDebug) {
			return;
		}
		if (!dojo.uri || !dojo.uri.dojoUri) {
			return dojo.debug("You'll need to load dojo.uri.* for deep debugging - sorry!");
		}
		if (!window.open) {
			return dojo.debug("Deep debugging is only supported in host environments with window.open");
		}
		var idx = dojo.debugDeep.debugVars.length;
		dojo.debugDeep.debugVars.push(obj);
		var url = (djConfig["dojoDebugDeepHtmlUrl"] || new dojo.uri.Uri(location, dojo.uri.moduleUri("dojo.debug", "deep.html")).toString()) + "?var=" + idx;
		var win = window.open(url, "_blank", "width=600, height=400, resizable=yes, scrollbars=yes, status=yes");
		try {
			win.debugVar = obj;
		}
		catch (e) {
		}
	};
	dojo.debugDeep.debugVars = [];
}});


__CPAN_FILE__ src/docs.xd.js
dojo.hostenv.packageLoaded({
depends: [["provide", "dojo.docs"],
["require", "dojo.io.*"],
["require", "dojo.event.topic"],
["require", "dojo.rpc.JotService"],
["require", "dojo.dom"],
["require", "dojo.uri.Uri"],
["require", "dojo.Deferred"],
["require", "dojo.DeferredList"]],
definePackage: function(dojo){/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.docs");
dojo.require("dojo.io.*");
dojo.require("dojo.event.topic");
dojo.require("dojo.rpc.JotService");
dojo.require("dojo.dom");
dojo.require("dojo.uri.Uri");
dojo.require("dojo.Deferred");
dojo.require("dojo.DeferredList");

/*
 * TODO:
 *
 * Package summary needs to compensate for "is"
 * Handle host environments
 * Deal with dojo.widget weirdness
 * Parse parameters
 * Limit function parameters to only the valid ones (Involves packing parameters onto meta during rewriting)
 *
 */

dojo.docs = new function() {
	this._url = dojo.uri.dojoUri("docscripts");
	this._rpc = new dojo.rpc.JotService;
	this._rpc.serviceUrl = dojo.uri.dojoUri("docscripts/jsonrpc.php");
};
dojo.lang.mixin(dojo.docs, {
	_count: 0,
	_callbacks: {function_names: []},
	_cache: {}, // Saves the JSON objects in cache
	require: function(/*String*/ require, /*bool*/ sync) {
		dojo.debug("require(): " + require);
		var parts = require.split("/");
		
		var size = parts.length;
		var deferred = new dojo.Deferred;
		var args = {
			mimetype: "text/json",
			load: function(type, data){
				dojo.debug("require(): loaded for " + require);
				
				if(parts[0] != "function_names") {
					for(var i = 0, part; part = parts[i]; i++){
						data = data[part];
					}
				}
				deferred.callback(data);
			},
			error: function(){
				deferred.errback();
			}
		};

		if(location.protocol == "file:"){
			if(size){
				if(parts[parts.length - 1] == "documentation"){
					parts[parts.length - 1] = "meta";
				}
			
				if(parts[0] == "function_names"){
					args.url = [this._url, "local_json", "function_names"].join("/");
				}else{
					var dirs = parts[0].split(".");
					args.url = [this._url, "local_json", dirs[0]].join("/");
					if(dirs.length > 1){
						args.url = [args.url, dirs[1]].join(".");
					}
				}
			}
		}
		
		dojo.io.bind(args);
		return deferred;
	},
	getFunctionNames: function(){
		return this.require("function_names"); // dojo.Deferred
	},
	unFormat: function(/*String*/ string){
		var fString = string;
		if(string.charAt(string.length - 1) == "_"){
			fString = [string.substring(0, string.length - 1), "*"].join("");
		}
		return fString;
	},
	getMeta: function(/*String*/ pkg, /*String*/ name, /*Function*/ callback, /*String?*/ id){
		// summary: Gets information about a function in regards to its meta data
		if(typeof name == "function"){
			// pId: a
			// pkg: ignore
			id = callback;
			callback = name;
			name = pkg;
			pkg = null;
			dojo.debug("getMeta(" + name + ")");
		}else{
			dojo.debug("getMeta(" + pkg + "/" + name + ")");
		}
		
		if(!id){
			id = "_";
		}
	},
	_withPkg: function(/*String*/ type, /*Object*/ data, /*Object*/ evt, /*Object*/ input, /*String*/ newType){
		dojo.debug("_withPkg(" + evt.name + ") has package: " + data[0]);
		evt.pkg = data[0];
		if("load" == type && evt.pkg){
			evt.type = newType;
		}else{
			if(evt.callbacks && evt.callbacks.length){
				evt.callbacks.shift()("error", {}, evt, evt.input);
			}
		}
	},
	_gotMeta: function(/*String*/ type, /*Object*/ data, /*Object*/ evt){
		dojo.debug("_gotMeta(" + evt.name + ")");

		var cached = dojo.docs._getCache(evt.pkg, evt.name, "meta", "functions", evt.id);
		if(cached.summary){
			data.summary = cached.summary;
		}
		if(evt.callbacks && evt.callbacks.length){
			evt.callbacks.shift()(type, data, evt, evt.input);
		}
	},
	getSrc: function(/*String*/ name, /*Function*/ callback, /*String?*/ id){
		// summary: Gets src file (created by the doc parser)
		dojo.debug("getSrc(" + name + ")");
		if(!id){
			id = "_";
		}
	},
	getDoc: function(/*String*/ name, /*Function*/ callback, /*String?*/ id){
		// summary: Gets external documentation stored on Jot for a given function
		dojo.debug("getDoc(" + name  + ")");

		if(!id){
			id = "_";
		}

		var input = {};

		input.type = "doc";
		input.name = name;
		input.callbacks = [callback];
	},
	_gotDoc: function(/*String*/ type, /*Array*/ data, /*Object*/ evt, /*Object*/ input){
		dojo.debug("_gotDoc(" + evt.type + ")");
		
		evt[evt.type] = data;
		if(evt.expects && evt.expects.doc){
			for(var i = 0, expect; expect = evt.expects.doc[i]; i++){
				if(!(expect in evt)){
					dojo.debug("_gotDoc() waiting for more data");
					return;
				}
			}
		}
		
		var cache = dojo.docs._getCache(evt.pkg, "meta", "functions", evt.name, evt.id, "meta");

		var description = evt.fn.description;
		cache.description = description;
		data = {
			returns: evt.fn.returns,
			id: evt.id,
			variables: []
		}
		if(!cache.parameters){
			cache.parameters = {};
		}
		for(var i = 0, param; param = evt.param[i]; i++){
			var fName = param["DocParamForm/name"];
			if(!cache.parameters[fName]){
				cache.parameters[fName] = {};
			}
			cache.parameters[fName].description = param["DocParamForm/desc"]
		}

		data.description = cache.description;
		data.parameters = cache.parameters;
		
		evt.type = "doc";
	
		if(evt.callbacks && evt.callbacks.length){
			evt.callbacks.shift()("load", data, evt, input);
		}
	},
	getPkgDoc: function(/*String*/ name, /*Function*/ callback){
		// summary: Gets external documentation stored on Jot for a given package
		dojo.debug("getPkgDoc(" + name + ")");
		var input = {};
	},
	getPkgInfo: function(/*String*/ name, /*Function*/ callback){
		// summary: Gets a combination of the metadata and external documentation for a given package
		dojo.debug("getPkgInfo(" + name + ")");

		var input = {
			expects: {
				pkginfo: ["pkgmeta", "pkgdoc"]
			},
			callback: callback
		};
		dojo.docs.getPkgMeta(input, name, dojo.docs._getPkgInfo);
		dojo.docs.getPkgDoc(input, name, dojo.docs._getPkgInfo);
	},
	_getPkgInfo: function(/*String*/ type, /*Object*/ data, /*Object*/ evt){
		dojo.debug("_getPkgInfo() for " + evt.type);
		var input = {};
		var results = {};
		if(typeof key == "object"){
			input = key;
			input[evt.type] = data;
			if(input.expects && input.expects.pkginfo){
				for(var i = 0, expect; expect = input.expects.pkginfo[i]; i++){
					if(!(expect in input)){
						dojo.debug("_getPkgInfo() waiting for more data");
						return;
					}
				}
			}
			results = input.pkgmeta;
			results.description = input.pkgdoc;
		}

		if(input.callback){
			input.callback("load", results, evt);
		}
	},
	getInfo: function(/*String*/ name, /*Function*/ callback){
		dojo.debug("getInfo(" + name + ")");
		var input = {
			expects: {
				"info": ["meta", "doc"]
			},
			callback: callback
		}
		dojo.docs.getMeta(input, name, dojo.docs._getInfo);
		dojo.docs.getDoc(input, name, dojo.docs._getInfo);
	},
	_getInfo: function(/*String*/ type, /*String*/ data, /*Object*/ evt, /*Object*/ input){
		dojo.debug("_getInfo(" + evt.type + ")");
		if(input && input.expects && input.expects.info){
			input[evt.type] = data;
			for(var i = 0, expect; expect = input.expects.info[i]; i++){
				if(!(expect in input)){
					dojo.debug("_getInfo() waiting for more data");
					return;
				}
			}
		}

		if(input.callback){
			input.callback("load", dojo.docs._getCache(evt.pkg, "meta", "functions", evt.name, evt.id, "meta"), evt, input);
		}
	},
	_getMainText: function(/*String*/ text){
		// summary: Grabs the innerHTML from a Jot Rech Text node
		dojo.debug("_getMainText()");
		return text.replace(/^<html[^<]*>/, "").replace(/<\/html>$/, "").replace(/<\w+\s*\/>/g, "");
	},
	getPackageMeta: function(/*Object*/ input){
		dojo.debug("getPackageMeta(): " + input.package);
		return this.require(input.package + "/meta", input.sync);
	},
	getFunctionMeta: function(/*Object*/ input){
		var package = input.package || "";
		var name = input.name;
		var id = input.id || "_";
		dojo.debug("getFunctionMeta(): " + name);

		if(!name) return;

		if(package){
			return this.require(package + "/meta/functions/" + name + "/" + id + "/meta");
		}else{
			this.getFunctionNames();
		}
	},
	getFunctionDocumentation: function(/*Object*/ input){
		var package = input.package || "";
		var name = input.name;
		var id = input.id || "_";
		dojo.debug("getFunctionDocumentation(): " + name);
		
		if(!name) return;
		
		if(package){
			return this.require(package + "/meta/functions/" + name + "/" + id + "/documentation");
		}
	},
	_onDocSearch: function(/*Object*/ input){
		var _this = this;
		var name = input.name.toLowerCase();
		if(!name) return;

		this.getFunctionNames().addCallback(function(data){
			dojo.debug("_onDocSearch(): function names loaded for " + name);

			var output = [];
			var list = [];
			var closure = function(pkg, fn) {
				return function(data){
					dojo.debug("_onDocSearch(): package meta loaded for: " + pkg);
					if(data.functions){
						var functions = data.functions;
						for(var key in functions){
							if(fn == key){
								var ids = functions[key];
								for(var id in ids){
									var fnMeta = ids[id];
									output.push({
										package: pkg,
										name: fn,
										id: id,
										summary: fnMeta.summary
									});
								}
							}
						}
					}
					return output;
				}
			}

			pkgLoop:
			for(var pkg in data){
				if(pkg.toLowerCase() == name){
					name = pkg;
					dojo.debug("_onDocSearch found a package");
					//dojo.docs._onDocSelectPackage(input);
					return;
				}
				for(var i = 0, fn; fn = data[pkg][i]; i++){
					if(fn.toLowerCase().indexOf(name) != -1){
						dojo.debug("_onDocSearch(): Search matched " + fn);
						var meta = _this.getPackageMeta({package: pkg});
						meta.addCallback(closure(pkg, fn));
						list.push(meta);

						// Build a list of all packages that need to be loaded and their loaded state.
						continue pkgLoop;
					}
				}
			}
			
			list = new dojo.DeferredList(list);
			list.addCallback(function(results){
				dojo.debug("_onDocSearch(): All packages loaded");
				_this._printFunctionResults(results[0][1]);
			});
		});
	},
	_onDocSearchFn: function(/*String*/ type, /*Array*/ data, /*Object*/ evt){
		dojo.debug("_onDocSearchFn(" + evt.name + ")");

		var name = evt.name || evt.pkg;

		dojo.debug("_onDocSearchFn found a function");

		evt.pkgs = packages;
		evt.pkg = name;
		evt.loaded = 0;
		for(var i = 0, pkg; pkg = packages[i]; i++){
			dojo.docs.getPkgMeta(evt, pkg, dojo.docs._onDocResults);
		}
	},
	_onPkgResults: function(/*String*/ type, /*Object*/ data, /*Object*/ evt, /*Object*/ input){
		dojo.debug("_onPkgResults(" + evt.type + ")");
		var description = "";
		var path = "";
		var methods = {};
		var requires = {};
		if(input){
			input[evt.type] = data;
			if(input.expects && input.expects.pkgresults){
				for(var i = 0, expect; expect = input.expects.pkgresults[i]; i++){
					if(!(expect in input)){
						dojo.debug("_onPkgResults() waiting for more data");
						return;
					}
				}
			}
			path = input.pkgdoc.path;
			description = input.pkgdoc.description;
			methods = input.pkgmeta.methods;
			requires = input.pkgmeta.requires;
		}
		var pkg = evt.name.replace("_", "*");
		var results = {
			path: path,
			description: description,
			size: 0,
			methods: [],
			pkg: pkg,
			requires: requires
		}
		var rePrivate = /_[^.]+$/;
		for(var method in methods){
			if(!rePrivate.test(method)){
				for(var pId in methods[method]){
					results.methods.push({
						pkg: pkg,
						name: method,
						id: pId,
						summary: methods[method][pId].summary
					})
				}
			}
		}
		results.size = results.methods.length;
		dojo.docs._printPkgResult(results);
	},
	_onDocResults: function(/*String*/ type, /*Object*/ data, /*Object*/ evt, /*Object*/ input){
		dojo.debug("_onDocResults(" + evt.name + "/" + input.pkg + ") " + type);
		++input.loaded;

		if(input.loaded == input.pkgs.length){
			var pkgs = input.pkgs;
			var name = input.pkg;
			var results = {methods: []};
			var rePrivate = /_[^.]+$/;
			data = dojo.docs._cache;

			for(var i = 0, pkg; pkg = pkgs[i]; i++){
				var methods = dojo.docs._getCache(pkg, "meta", "methods");
				for(var fn in methods){
					if(fn.toLowerCase().indexOf(name) == -1){
						continue;
					}
					if(fn != "requires" && !rePrivate.test(fn)){
						for(var pId in methods[fn]){
							var result = {
								pkg: pkg,
								name: fn,
								id: "_",
								summary: ""
							}
							if(methods[fn][pId].summary){
								result.summary = methods[fn][pId].summary;
							}
							results.methods.push(result);
						}
					}
				}
			}

			dojo.debug("Publishing docResults");
			dojo.docs._printFnResults(results);
		}
	},
	_printFunctionResults: function(results){
		dojo.debug("_printFnResults(): called");
		// summary: Call this function to send the /docs/function/results topic
	},
	_printPkgResult: function(results){
		dojo.debug("_printPkgResult(): called");
	},
	_onDocSelectFunction: function(/*Object*/ input){
		// summary: Get doc, meta, and src
		var name = input.name;
		var package = input.package || "";
		var id = input.id || "_";
		dojo.debug("_onDocSelectFunction(" + name + ")");
		if(!name || !package) return false;

		var pkgMeta = this.getPackageMeta({package: package});
		var meta = this.getFunctionMeta({package: package, name: name, id: id});
		var doc = this.getFunctionDocumentation({package: package, name: name, id: id});
		
		var list = new dojo.DeferredList([pkgMeta, meta, doc]);
		list.addCallback(function(results){
			dojo.debug("_onDocSelectFunction() loaded");
			for(var i = 0, result; result = results[i]; i++){
				dojo.debugShallow(result[1]);
			}
		});
		
		return list;
	},
	_onDocSelectPackage: function(/*Object*/ input){
		dojo.debug("_onDocSelectPackage(" + input.name + ")")
		input.expects = {
			"pkgresults": ["pkgmeta", "pkgdoc"]
		};
		dojo.docs.getPkgMeta(input, input.name, dojo.docs._onPkgResults);
		dojo.docs.getPkgDoc(input, input.name, dojo.docs._onPkgResults);
	},
	_onDocSelectResults: function(/*String*/ type, /*Object*/ data, /*Object*/ evt, /*Object*/ input){
		dojo.debug("_onDocSelectResults(" + evt.type + ", " + evt.name + ")");
		if(evt.type == "meta"){
			dojo.docs.getPkgMeta(input, evt.pkg, dojo.docs._onDocSelectResults);
		}
		if(input){
			input[evt.type] = data;
			if(input.expects && input.expects.docresults){
				for(var i = 0, expect; expect = input.expects.docresults[i]; i++){
					if(!(expect in input)){
						dojo.debug("_onDocSelectResults() waiting for more data");
						return;
					}
				}
			}
		}

		dojo.docs._printFunctionDetail(input);
	},
	
	_printFunctionDetail: function(results) {
		// summary: Call this function to send the /docs/function/detail topic event
	},

	selectFunction: function(/*String*/ name, /*String?*/ id){
		// summary: The combined information
	},
	savePackage: function(/*Object*/ callbackObject, /*String*/ callback, /*Object*/ parameters){
		dojo.event.kwConnect({
			srcObj: dojo.docs,
			srcFunc: "_savedPkgRpc",
			targetObj: callbackObject,
			targetFunc: callback,
			once: true
		});
		
		var props = {};
		var cache = dojo.docs._getCache(parameters.pkg, "meta");

		var i = 1;

		if(!cache.path){
			var path = "id";
			props[["pname", i].join("")] = "DocPkgForm/require";
			props[["pvalue", i++].join("")] = parameters.pkg;
		}else{
			var path = cache.path;
		}

		props.form = "//DocPkgForm";
		props.path = ["/WikiHome/DojoDotDoc/", path].join("");

		if(parameters.description){
			props[["pname", i].join("")] = "main/text";
			props[["pvalue", i++].join("")] = parameters.description;
		}
		
		dojo.docs._rpc.callRemote("saveForm",	props).addCallbacks(dojo.docs._pkgRpc, dojo.docs._pkgRpc);
	},
	_pkgRpc: function(data){
		if(data.name){
			dojo.docs._getCache(data["DocPkgForm/require"], "meta").path = data.name;
			dojo.docs._savedPkgRpc("load");
		}else{
			dojo.docs._savedPkgRpc("error");
		}
	},
	_savedPkgRpc: function(type){
	},
	functionPackages: function(/*String*/ name, /*Function*/ callback, /*Object*/ input){
		// summary: Gets the package associated with a function and stores it in the .pkg value of input
		dojo.debug("functionPackages() name: " + name);

		if(!input){
			input = {};
		}
		if(!input.callbacks){
			input.callbacks = [];
		}

		input.type = "function_names";
		input.name = name;
		input.callbacks.unshift(callback);
		input.callbacks.unshift(dojo.docs._functionPackages);
	},
	_functionPackages: function(/*String*/ type, /*Array*/ data, /*Object*/ evt){
		dojo.debug("_functionPackages() name: " + evt.name);
		evt.pkg = '';

		var results = [];
		var data = dojo.docs._cache['function_names'];
		for(var key in data){
			if(dojo.lang.inArray(data[key], evt.name)){
				dojo.debug("_functionPackages() package: " + key);
				results.push(key);
			}
		}

		if(evt.callbacks && evt.callbacks.length){
			evt.callbacks.shift()(type, results, evt, evt.input);
		}
	},
	setUserName: function(/*String*/ name){
		dojo.docs._userName = name;
		if(name && dojo.docs._password){
			dojo.docs._logIn();
		}
	},
	setPassword: function(/*String*/ password){
		dojo.docs._password = password;
		if(password && dojo.docs._userName){
			dojo.docs._logIn();
		}
	},
	_logIn: function(){
		dojo.io.bind({
			url: dojo.docs._rpc.serviceUrl.toString(),
			method: "post",
			mimetype: "text/json",
			content: {
				username: dojo.docs._userName,
				password: dojo.docs._password
			},
			load: function(type, data){
				if(data.error){
					dojo.docs.logInSuccess();
				}else{
					dojo.docs.logInFailure();
				}
			},
			error: function(){
				dojo.docs.logInFailure();
			}
		});
	},
	logInSuccess: function(){},
	logInFailure: function(){},
	_set: function(/*Object*/ base, /*String...*/ keys, /*String*/ value){
		var args = [];
		for(var i = 0, arg; arg = arguments[i]; i++){
			args.push(arg);
		}

		if(args.length < 3) return;
		base = args.shift();
		value = args.pop();
		var key = args.pop();
		for(var i = 0, arg; arg = args[i]; i++){
			if(typeof base[arg] != "object"){
				base[arg] = {};
			}
			base = base[arg];
		}
		base[key] = value;
	},
	_getCache: function(/*String...*/ keys){
		var obj = dojo.docs._cache;
		for(var i = 0; i < arguments.length; i++){
			var arg = arguments[i];
			if(!obj[arg]){
				obj[arg] = {};
			}
			obj = obj[arg];
		}
		return obj;
	}
});

dojo.event.topic.subscribe("/docs/search", dojo.docs, "_onDocSearch");
dojo.event.topic.subscribe("/docs/function/select", dojo.docs, "_onDocSelectFunction");
dojo.event.topic.subscribe("/docs/package/select", dojo.docs, "_onDocSelectPackage");

dojo.event.topic.registerPublisher("/docs/function/results", dojo.docs, "_printFunctionResults");
dojo.event.topic.registerPublisher("/docs/function/detail", dojo.docs, "_printFunctionDetail");
dojo.event.topic.registerPublisher("/docs/package/detail", dojo.docs, "_printPkgResult");

}});

__CPAN_FILE__ src/io.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.io"], ["require", "dojo.io.*"]], definePackage:function (dojo) {
	dojo.provide("dojo.io");
	dojo.require("dojo.io.*");
	dojo.deprecated("dojo.io", "replaced by dojo.io.*", "0.5");
}});


__CPAN_FILE__ src/AdapterRegistry.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.AdapterRegistry"], ["require", "dojo.lang.func"]], definePackage:function (dojo) {
	dojo.provide("dojo.AdapterRegistry");
	dojo.require("dojo.lang.func");
	dojo.AdapterRegistry = function (returnWrappers) {
		this.pairs = [];
		this.returnWrappers = returnWrappers || false;
	};
	dojo.lang.extend(dojo.AdapterRegistry, {register:function (name, check, wrap, directReturn, override) {
		var type = (override) ? "unshift" : "push";
		this.pairs[type]([name, check, wrap, directReturn]);
	}, match:function () {
		for (var i = 0; i < this.pairs.length; i++) {
			var pair = this.pairs[i];
			if (pair[1].apply(this, arguments)) {
				if ((pair[3]) || (this.returnWrappers)) {
					return pair[2];
				} else {
					return pair[2].apply(this, arguments);
				}
			}
		}
		throw new Error("No match found");
	}, unregister:function (name) {
		for (var i = 0; i < this.pairs.length; i++) {
			var pair = this.pairs[i];
			if (pair[0] == name) {
				this.pairs.splice(i, 1);
				return true;
			}
		}
		return false;
	}});
}});


__CPAN_FILE__ src/hostenv_rhino.xd.js
dojo.hostenv.packageLoaded({
depends: [["requireIf", (djConfig["isDebug"] || djConfig["debugAtAllCosts"]]],
definePackage: function(dojo){/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
* Rhino host environment
*/
// make jsc shut up (so we can use jsc for sanity checking) 
/*@cc_on
@if (@_jscript_version >= 7)
var loadClass; var print; var load; var quit; var version; var Packages; var java;
@end
@*/

dojo.hostenv.println=function(line){
	if(arguments.length > 0){
		print(arguments[0]);
		for(var i=1; i<arguments.length; i++){
			var valid=false;
			for (var p in arguments[i]){valid=true;break;}
			if(valid){
				dojo.debugShallow(arguments[i]);
			}
		}
	} else {
		print(line);
	}
}

dojo.locale = dojo.locale || java.util.Locale.getDefault().toString().replace('_','-').toLowerCase();
dojo.render.name = dojo.hostenv.name_ = 'rhino';
dojo.hostenv.getVersion = function() {return version();};

if (dj_undef("byId")) {
	dojo.byId = function(id, doc){
		if(id && (typeof id == "string" || id instanceof String)){
			if(!doc){ doc = document; }
			return doc.getElementById(id);
		}
		return id; // assume it's a node
	}
}

// see comments in spidermonkey loadUri
dojo.hostenv.loadUri = function(uri, cb){
	try{
		var local = (new java.io.File(uri)).exists();
		if(!local){
			try{
				// try it as a file first, URL second
				var stream = (new java.net.URL(uri)).openStream();
				// close the stream so we don't leak resources
				stream.close();
			}catch(e){
				// no debug output; this failure just means the uri was not found.
				return false;
			}
		}
//FIXME: Use Rhino 1.6 native readFile/readUrl if available?
		if(cb){
			var contents = (local ? readText : readUri)(uri, "UTF-8");
			cb(eval('('+contents+')'));
		}else{
			load(uri);
		}
		return true;
	}catch(e){
		dojo.debug("rhino load('" + uri + "') failed. Exception: " + e);
		return false;
	}
}

dojo.hostenv.exit = function(exitcode){ 
	quit(exitcode);
}

// Hack to determine current script...
//
// These initial attempts failed:
//   1. get an EcmaError and look at e.getSourceName(): try {eval ("static in return")} catch(e) { ...
//   Won't work because NativeGlobal.java only does a put of "name" and "message", not a wrapped reflecting object.
//   Even if the EcmaError object had the sourceName set.
//  
//   2. var e = Packages.org.mozilla.javascript.Context.getCurrentContext().reportError('');
//   Won't work because it goes directly to the errorReporter, not the return value.
//   We want context.interpreterSourceFile and context.interpreterLine, which are used in static Context.getSourcePositionFromStack
//   (set by Interpreter.java at interpretation time, if in interpreter mode).
//
//   3. var e = Packages.org.mozilla.javascript.Context.getCurrentContext().reportRuntimeError('');
//   This returns an object, but e.message still does not have source info.
//   In compiler mode, perhaps not set; in interpreter mode, perhaps not used by errorReporter?
//
// What we found works is to do basically the same hack as is done in getSourcePositionFromStack,
// making a new java.lang.Exception() and then calling printStackTrace on a string stream.
// We have to parse the string for the .js files (different from the java files).
// This only works however in compiled mode (-opt 0 or higher).
// In interpreter mode, entire stack is java.
// When compiled, printStackTrace is like:
// java.lang.Exception
//	at sun.reflect.NativeConstructorAccessorImpl.newInstance0(Native Method)
//	at sun.reflect.NativeConstructorAccessorImpl.newInstance(NativeConstructorAccessorImpl.java:39)
//	at sun.reflect.DelegatingConstructorAccessorImpl.newInstance(DelegatingConstructorAccessorImpl.java:27)
//	at java.lang.reflect.Constructor.newInstance(Constructor.java:274)
//	at org.mozilla.javascript.NativeJavaClass.constructSpecific(NativeJavaClass.java:228)
//	at org.mozilla.javascript.NativeJavaClass.construct(NativeJavaClass.java:185)
//	at org.mozilla.javascript.ScriptRuntime.newObject(ScriptRuntime.java:1269)
//	at org.mozilla.javascript.gen.c2.call(/Users/mda/Sites/burstproject/testrhino.js:27)
//    ...
//	at org.mozilla.javascript.tools.shell.Main.main(Main.java:76)
//
// Note may get different answers based on:
//    Context.setOptimizationLevel(-1)
//    Context.setGeneratingDebug(true)
//    Context.setGeneratingSource(true) 
//
// Some somewhat helpful posts:
//    http://groups.google.com/groups?hl=en&lr=&ie=UTF-8&oe=UTF-8&safe=off&selm=9v9n0g%246gr1%40ripley.netscape.com
//    http://groups.google.com/groups?hl=en&lr=&ie=UTF-8&oe=UTF-8&safe=off&selm=3BAA2DC4.6010702%40atg.com
//
// Note that Rhino1.5R5 added source name information in some exceptions.
// But this seems not to help in command-line Rhino, because Context.java has an error reporter
// so no EvaluationException is thrown.

// do it by using java java.lang.Exception
function dj_rhino_current_script_via_java(depth) {
    var optLevel = Packages.org.mozilla.javascript.Context.getCurrentContext().getOptimizationLevel();  
   // if (optLevel == -1){ dojo.unimplemented("getCurrentScriptURI (determine current script path for rhino when interpreter mode)", ''); }
    var caw = new java.io.CharArrayWriter();
    var pw = new java.io.PrintWriter(caw);
    var exc = new java.lang.Exception();
    var s = caw.toString();
    // we have to exclude the ones with or without line numbers because they put double entries in:
    //   at org.mozilla.javascript.gen.c3._c4(/Users/mda/Sites/burstproject/burst/Runtime.js:56)
    //   at org.mozilla.javascript.gen.c3.call(/Users/mda/Sites/burstproject/burst/Runtime.js)
    var matches = s.match(/[^\(]*\.js\)/gi);
    if(!matches){
		throw Error("cannot parse printStackTrace output: " + s);
	}

    // matches[0] is entire string, matches[1] is this function, matches[2] is caller, ...
    var fname = ((typeof depth != 'undefined')&&(depth)) ? matches[depth + 1] : matches[matches.length - 1];
    var fname = matches[3];
	if(!fname){ fname = matches[1]; }
    // print("got fname '" + fname + "' from stack string '" + s + "'");
    if (!fname){ throw Error("could not find js file in printStackTrace output: " + s); }
    //print("Rhino getCurrentScriptURI returning '" + fname + "' from: " + s); 
    return fname;
}

// UNUSED: leverage new support in native exception for getSourceName
/*
function dj_rhino_current_script_via_eval_exception() {
    var exc;
    // 'ReferenceError: "undefinedsymbol" is not defined.'
    try {eval ("undefinedsymbol()") } catch(e) {exc = e;}
    // 'Error: whatever'
    // try{throw Error("whatever");} catch(e) {exc = e;}
    // 'SyntaxError: identifier is a reserved word'
    // try {eval ("static in return")} catch(e) { exc = e; }
   // print("got exception: '" + exc + "' type=" + (typeof exc));
    // print("exc.stack=" + (typeof exc.stack));
    var sn = exc.rhinoException.getSourceName();
    print("SourceName=" + sn);
    return sn;
}*/

// reading a file from disk in Java is a humiliating experience by any measure.
// Lets avoid that and just get the freaking text
function readText(path, encoding){
	encoding = encoding || "utf-8";
	// NOTE: we intentionally avoid handling exceptions, since the caller will
	// want to know
	var jf = new java.io.File(path);
	var is = new java.io.FileInputStream(jf);
	return dj_readInputStream(is, encoding);
}

function readUri(uri, encoding){
	var conn = (new java.net.URL(uri)).openConnection();
	encoding = encoding || conn.getContentEncoding() || "utf-8";
	var is = conn.getInputStream();
	return dj_readInputStream(is, encoding);
}

function dj_readInputStream(is, encoding){
	var input = new java.io.BufferedReader(new java.io.InputStreamReader(is, encoding));
	try {
		var sb = new java.lang.StringBuffer();
		var line = "";
		while((line = input.readLine()) !== null){
			sb.append(line);
			sb.append(java.lang.System.getProperty("line.separator"));
		}
		return sb.toString();
	} finally {
		input.close();
	}
}

// call this now because later we may not be on the top of the stack
if(!djConfig.libraryScriptUri.length){
	try{
		djConfig.libraryScriptUri = dj_rhino_current_script_via_java(1);
	}catch(e){
		// otherwise just fake it
		if(djConfig["isDebug"]){
			print("\n");
			print("we have no idea where Dojo is located.");
			print("Please try loading rhino in a non-interpreted mode or set a");
			print("\n\tdjConfig.libraryScriptUri\n");
			print("Setting the dojo path to './'");
			print("This is probably wrong!");
			print("\n");
			print("Dojo will try to load anyway");
		}
		djConfig.libraryScriptUri = "./";
	}
}

dojo.doc = function(){
	// summary:
	//		return the document object associated with the dojo.global()
	return document;
}

dojo.body = function(){
	return document.body;	
}

function setTimeout(func, delay){
	// summary: provides timed callbacks using Java threads

	var def={
		sleepTime:delay,
		hasSlept:false,
		
		run:function(){
			if (!this.hasSlept){
				this.hasSlept=true;
				java.lang.Thread.currentThread().sleep(this.sleepTime);
			}
			try {
				func();
			} catch(e){dojo.debug("Error running setTimeout thread:" + e);}
		}
	};
	
	var runnable=new java.lang.Runnable(def);
	var thread=new java.lang.Thread(runnable);
	thread.start();
}

dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");

}});

__CPAN_FILE__ src/animation.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.animation"], ["require", "dojo.animation.Animation"]], definePackage:function (dojo) {
	dojo.provide("dojo.animation");
	dojo.require("dojo.animation.Animation");
	dojo.deprecated("dojo.animation is slated for removal in 0.5; use dojo.lfx instead.", "0.5");
}});


__CPAN_FILE__ src/math.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.math"]], definePackage:function (dojo) {
	dojo.provide("dojo.math");
	dojo.math.degToRad = function (x) {
		return (x * Math.PI) / 180;
	};
	dojo.math.radToDeg = function (x) {
		return (x * 180) / Math.PI;
	};
	dojo.math.factorial = function (n) {
		if (n < 1) {
			return 0;
		}
		var retVal = 1;
		for (var i = 1; i <= n; i++) {
			retVal *= i;
		}
		return retVal;
	};
	dojo.math.permutations = function (n, k) {
		if (n == 0 || k == 0) {
			return 1;
		}
		return (dojo.math.factorial(n) / dojo.math.factorial(n - k));
	};
	dojo.math.combinations = function (n, r) {
		if (n == 0 || r == 0) {
			return 1;
		}
		return (dojo.math.factorial(n) / (dojo.math.factorial(n - r) * dojo.math.factorial(r)));
	};
	dojo.math.bernstein = function (t, n, i) {
		return (dojo.math.combinations(n, i) * Math.pow(t, i) * Math.pow(1 - t, n - i));
	};
	dojo.math.gaussianRandom = function () {
		var k = 2;
		do {
			var i = 2 * Math.random() - 1;
			var j = 2 * Math.random() - 1;
			k = i * i + j * j;
		} while (k >= 1);
		k = Math.sqrt((-2 * Math.log(k)) / k);
		return i * k;
	};
	dojo.math.mean = function () {
		var array = dojo.lang.isArray(arguments[0]) ? arguments[0] : arguments;
		var mean = 0;
		for (var i = 0; i < array.length; i++) {
			mean += array[i];
		}
		return mean / array.length;
	};
	dojo.math.round = function (number, places) {
		if (!places) {
			var shift = 1;
		} else {
			var shift = Math.pow(10, places);
		}
		return Math.round(number * shift) / shift;
	};
	dojo.math.sd = dojo.math.standardDeviation = function () {
		var array = dojo.lang.isArray(arguments[0]) ? arguments[0] : arguments;
		return Math.sqrt(dojo.math.variance(array));
	};
	dojo.math.variance = function () {
		var array = dojo.lang.isArray(arguments[0]) ? arguments[0] : arguments;
		var mean = 0, squares = 0;
		for (var i = 0; i < array.length; i++) {
			mean += array[i];
			squares += Math.pow(array[i], 2);
		}
		return (squares / array.length) - Math.pow(mean / array.length, 2);
	};
	dojo.math.range = function (a, b, step) {
		if (arguments.length < 2) {
			b = a;
			a = 0;
		}
		if (arguments.length < 3) {
			step = 1;
		}
		var range = [];
		if (step > 0) {
			for (var i = a; i < b; i += step) {
				range.push(i);
			}
		} else {
			if (step < 0) {
				for (var i = a; i > b; i += step) {
					range.push(i);
				}
			} else {
				throw new Error("dojo.math.range: step must be non-zero");
			}
		}
		return range;
	};
}});


__CPAN_FILE__ src/loader_xd.xd.js
dojo.hostenv.packageLoaded({
depends: [["require", moduleName + ".nls" + (bestLocale ? "." + bestLocale : ""]],
definePackage: function(dojo){/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

//Cross-domain package loader.

//FIXME: How will xd loading work with debugAtAllCosts? Any bad interactions?

dojo.hostenv.resetXd = function(){
	//summary: Internal xd loader function. Resets the xd state.

	//This flag indicates where or not we have crossed into xdomain territory. Once any package says
	//it is cross domain, then the rest of the packages have to be treated as xdomain because we need
	//to evaluate packages in order. If there is a xdomain package followed by a xhr package, we can't load
	//the xhr package until the one before it finishes loading. The text of the xhr package will be converted
	//to match the format for a xd package and put in the xd load queue.
	this.isXDomain = djConfig.useXDomain || false;

	this.xdTimer = 0;
	this.xdInFlight = {};
	this.xdOrderedReqs = [];
	this.xdDepMap = {};
	this.xdContents = [];
	this.xdDefList = [];
}

//Call reset immediately to set the state.
dojo.hostenv.resetXd();

dojo.hostenv.createXdPackage = function(/*String*/contents, /*String*/resourceName, /*String=*/resourcePath){
	//summary: Internal xd loader function. Creates an xd module source given an
	//non-xd module contents.

	//Find dependencies.
	var deps = [];
    var depRegExp = /dojo.(requireLocalization|require|requireIf|requireAll|provide|requireAfterIf|requireAfter|kwCompoundRequire|conditionalRequire|hostenv\.conditionalLoadModule|.hostenv\.loadModule|hostenv\.moduleLoaded)\(([\w\W]*?)\)/mg;
    var match;
	while((match = depRegExp.exec(contents)) != null){
		if(match[1] == "requireLocalization"){
			//Need to load the local bundles asap, since they are not
			//part of the list of modules watched for loading.
			eval(match[0]);
		}else{
			deps.push("\"" + match[1] + "\", " + match[2]);
		}
	}

	//Create package object and the call to packageLoaded.
	var output = [];
	output.push("dojo.hostenv.packageLoaded({\n");

	//Add dependencies
	if(deps.length > 0){
		output.push("depends: [");
		for(var i = 0; i < deps.length; i++){
			if(i > 0){
				output.push(",\n");
			}
			output.push("[" + deps[i] + "]");
		}
		output.push("],");
	}

	//Add the contents of the file inside a function.
	//Pass in dojo as an argument to the function to help with
	//allowing multiple versions of dojo in a page.
	output.push("\ndefinePackage: function(dojo){");
	output.push(contents);
	//Add isLocal property so we know if we have to do something different
	//in debugAtAllCosts situations.
	output.push("\n}, resourceName: '" + resourceName + "', resourcePath: '" + resourcePath + "'});");
	
	return output.join(""); //String
}

dojo.hostenv.loadPath = function(/*String*/relpath, /*String?*/module, /*Function?*/cb){
	//summary: Internal xd loader function. Overrides loadPath() from loader.js.
	//xd loading requires slightly different behavior from loadPath().


	//Only do getBaseScriptUri if path does not start with a URL with a protocol.
	//If there is a colon before the first / then, we have a URL with a protocol.
	var colonIndex = relpath.indexOf(":");
	var slashIndex = relpath.indexOf("/");
	var uri;
	var currentIsXDomain = false;
	if(colonIndex > 0 && colonIndex < slashIndex){
		uri = relpath;
		this.isXDomain = currentIsXDomain = true;
	}else{
		uri = this.getBaseScriptUri() + relpath;

		//Is ithe base script URI-based URL a cross domain URL?
		colonIndex = uri.indexOf(":");
		slashIndex = uri.indexOf("/");
		if(colonIndex > 0 && colonIndex < slashIndex && (!location.host || uri.indexOf("http://" + location.host) != 0)){
			this.isXDomain = currentIsXDomain = true;
		}
	}

	if(djConfig.cacheBust && dojo.render.html.capable) { uri += "?" + String(djConfig.cacheBust).replace(/\W+/g,""); }
	try{
		return ((!module || this.isXDomain) ? this.loadUri(uri, cb, currentIsXDomain, module) : this.loadUriAndCheck(uri, module, cb)); //boolean
	}catch(e){
		dojo.debug(e);
		return false; //boolean
	}
}

dojo.hostenv.loadUri = function(/*String*/uri, /*Function?*/cb, /*boolean*/currentIsXDomain, /*String?*/module){
	//summary: Internal xd loader function. Overrides loadUri() from loader.js.
	//		xd loading requires slightly different behavior from loadPath().
	//description: Wanted to override getText(), but it is used by
	//		the widget code in too many, synchronous ways right now.
	if(this.loadedUris[uri]){
		return 1; //boolean
	}

	//Add the module (package) to the list of modules.
	//Only do this work if we have a modlue name. Otherwise,
	//it is a non-xd i18n bundle, which can load immediately and does not
	//need to be tracked.
	if(this.isXDomain && module){
		//If this is a __package__.js file, then this must be
		//a package.* request (since xdomain can only work with the first
		//path in a package search list. However, .* module names are not
		//passed to this function, so do an adjustment here.
		if(uri.indexOf("__package__") != -1){
			module += ".*";
		}

		this.xdOrderedReqs.push(module);

		//Add to waiting packages if it is an xdomain resource.
		//Don't add non-xdomain i18n bundles, those get evaled immediately.
		if(currentIsXDomain || uri.indexOf("/nls/") == -1){
			this.xdInFlight[module] = true;

			//Increment inFlightCount
			//This will stop the modulesLoaded from firing all the way.
			this.inFlightCount++;
		}

		//Start timer
		if(!this.xdTimer){
			this.xdTimer = setInterval("dojo.hostenv.watchInFlightXDomain();", 100);
		}
		this.xdStartTime = (new Date()).getTime();
	}

	if (currentIsXDomain){
		//Fix name to be a .xd.fileextension name.
		var lastIndex = uri.lastIndexOf('.');
		if(lastIndex <= 0){
			lastIndex = uri.length - 1;
		}

		var xdUri = uri.substring(0, lastIndex) + ".xd";
		if(lastIndex != uri.length - 1){
			xdUri += uri.substring(lastIndex, uri.length);
		}

		//Add to script src
		var element = document.createElement("script");
		element.type = "text/javascript";
		element.src = xdUri;
		if(!this.headElement){
			this.headElement = document.getElementsByTagName("head")[0];

			//Head element may not exist, particularly in html
			//html 4 or tag soup cases where the page does not
			//have a head tag in it. Use html element, since that will exist.
			//Seems to be an issue mostly with Opera 9 and to lesser extent Safari 2
			if(!this.headElement){
				this.headElement = document.getElementsByTagName("html")[0];
			}
		}
		this.headElement.appendChild(element);
	}else{
		var contents = this.getText(uri, null, true);
		if(contents == null){ return 0; /*boolean*/}
		
		//If this is not xdomain, or if loading a i18n resource bundle, then send it down
		//the normal eval/callback path.
		if(this.isXDomain && uri.indexOf("/nls/") == -1){
			var pkg = this.createXdPackage(contents, module, uri);
			dj_eval(pkg);
		}else{
			if(cb){ contents = '('+contents+')'; }
			var value = dj_eval(contents);
			if(cb){
				cb(value);
			}
		}
	}

	//These steps are done in the non-xd loader version of this function.
	//Maintain these steps to fit in with the existing system.
	this.loadedUris[uri] = true;
	return 1; //boolean
}

dojo.hostenv.packageLoaded = function(/*Object*/pkg){
	//summary: Internal xd loader function. Called by an xd module when
	//it has been loaded via a script tag.
	var deps = pkg.depends;
	var requireList = null;
	var requireAfterList = null;
	var provideList = [];
	if(deps && deps.length > 0){
		var dep = null;
		var insertHint = 0;
		var attachedPackage = false;
		for(var i = 0; i < deps.length; i++){
			dep = deps[i];

			//Look for specific dependency indicators.
			if (dep[0] == "provide" || dep[0] == "hostenv.moduleLoaded"){
				provideList.push(dep[1]);
			}else{
				if(!requireList){
					requireList = [];
				}
				if(!requireAfterList){
					requireAfterList = [];
				}

				var unpackedDeps = this.unpackXdDependency(dep);
				if(unpackedDeps.requires){
					requireList = requireList.concat(unpackedDeps.requires);
				}
				if(unpackedDeps.requiresAfter){
					requireAfterList = requireAfterList.concat(unpackedDeps.requiresAfter);
				}
			}

			//Call the dependency indicator to allow for the normal dojo setup.
			//Only allow for one dot reference, for the hostenv.* type calls.
			var depType = dep[0];
			var objPath = depType.split(".");
			if(objPath.length == 2){
				dojo[objPath[0]][objPath[1]].apply(dojo[objPath[0]], dep.slice(1));
			}else{
				dojo[depType].apply(dojo, dep.slice(1));
			}
		}

		//Save off the package contents for definition later.
		var contentIndex = this.xdContents.push({
				content: pkg.definePackage,
				resourceName: pkg["resourceName"],
				resourcePath: pkg["resourcePath"],
				isDefined: false
			}) - 1;

		//Add provide/requires to dependency map.
		for(var i = 0; i < provideList.length; i++){
			this.xdDepMap[provideList[i]] = { requires: requireList, requiresAfter: requireAfterList, contentIndex: contentIndex };
		}

		//Now update the inflight status for any provided packages in this loaded package.
		//Do this at the very end (in a *separate* for loop) to avoid shutting down the 
		//inflight timer check too soon.
		for(var i = 0; i < provideList.length; i++){
			this.xdInFlight[provideList[i]] = false;
		}
	}
}

dojo.hostenv.xdLoadFlattenedBundle = function(/*String*/moduleName, /*String*/bundleName, /*String?*/locale, /*Object*/bundleData){
	//summary: Internal xd loader function. Used when loading
	//a flattened localized bundle via a script tag.
	locale = locale || "root";
	var jsLoc = dojo.hostenv.normalizeLocale(locale).replace('-', '_');
 	var bundlePackage = [moduleName, "nls", bundleName].join(".");
	var bundle = dojo.hostenv.startPackage(bundlePackage);
	bundle[jsLoc] = bundleData;
	
	//Assign the bundle for the original locale(s) we wanted.
	var mapName = [moduleName, jsLoc, bundleName].join(".");
	var bundleMap = dojo.hostenv.xdBundleMap[mapName];
	if(bundleMap){
		for(var param in bundleMap){
			bundle[param] = bundleData;
		}
	}
};


dojo.hostenv.xdBundleMap = {};

dojo.xdRequireLocalization = function(/*String*/moduleName, /*String*/bundleName, /*String?*/locale, /*String*/availableFlatLocales){
	//summary: Internal xd loader function. The xd version of dojo.requireLocalization.
	var locales = availableFlatLocales.split(",");
	
	//Find the best-match locale to load.
	var jsLoc = dojo.hostenv.normalizeLocale(locale);

	var bestLocale = "";
	for(var i = 0; i < locales.length; i++){
		//Locale must match from start of string.
		if(jsLoc.indexOf(locales[i]) == 0){
			if(locales[i].length > bestLocale.length){
				bestLocale = locales[i];
			}
		}
	}

	var fixedBestLocale = bestLocale.replace('-', '_');
	//See if the bundle we are going to use is already loaded.
 	var bundlePackage = dojo.evalObjPath([moduleName, "nls", bundleName].join("."));
	if(bundlePackage && bundlePackage[fixedBestLocale]){
		bundle[jsLoc.replace('-', '_')] = bundlePackage[fixedBestLocale];
	}else{
		//Need to remember what locale we wanted and which one we actually use.
		//Then when we load the one we are actually using, use that bundle for the one
		//we originally wanted.
		var mapName = [moduleName, (fixedBestLocale||"root"), bundleName].join(".");
		var bundleMap = dojo.hostenv.xdBundleMap[mapName];
		if(!bundleMap){
			bundleMap = dojo.hostenv.xdBundleMap[mapName] = {};
		}
		bundleMap[jsLoc.replace('-', '_')] = true;
		
		//Do just a normal dojo.require so the package tracking stuff works as usual.
		dojo.require(moduleName + ".nls" + (bestLocale ? "." + bestLocale : "") + "." + bundleName);
	}
}

;(function(){
	// Simulate the extra locale work that dojo.requireLocalization does.

	var extra = djConfig.extraLocale;
	if(extra){
		if(!extra instanceof Array){
			extra = [extra];
		}

		dojo._xdReqLoc = dojo.xdRequireLocalization;
		dojo.xdRequireLocalization = function(m, b, locale, fLocales){
			dojo._xdReqLoc(m,b,locale, fLocales);
			if(locale){return;}
			for(var i=0; i<extra.length; i++){
				dojo._xdReqLoc(m,b,extra[i], fLocales);
			}
		};
	}
})();


//This is a bit brittle: it has to know about the dojo methods that deal with dependencies
//It would be ideal to intercept the actual methods and do something fancy at that point,
//but I have concern about knowing which provide to match to the dependency in that case,
//since scripts can load whenever they want, and trigger new calls to dojo.hostenv.packageLoaded().
dojo.hostenv.unpackXdDependency = function(dep){
	//summary: Internal xd loader function. Determines what to do with a dependency
	//that was listed in an xd version of a module contents.

	//Extract the dependency(ies).
	var newDeps = null;
	var newAfterDeps = null;
	switch(dep[0]){
		case "requireIf":
		case "requireAfterIf":
		case "conditionalRequire":
			//First arg (dep[1]) is the test. Depedency is dep[2].
			if((dep[1] === true)||(dep[1]=="common")||(dep[1] && dojo.render[dep[1]].capable)){
				newDeps = [{name: dep[2], content: null}];
			}
			break;
		case "requireAll":
			//the arguments are an array, each element a call to require.
			//Get rid of first item, which is "requireAll".
			dep.shift();
			newDeps = dep;
			dojo.hostenv.flattenRequireArray(newDeps);
			break;
		case "kwCompoundRequire":
		case "hostenv.conditionalLoadModule":
			var modMap = dep[1];
			var common = modMap["common"]||[];
			var newDeps = (modMap[dojo.hostenv.name_]) ? common.concat(modMap[dojo.hostenv.name_]||[]) : common.concat(modMap["default"]||[]);	
			dojo.hostenv.flattenRequireArray(newDeps);
			break;
		case "require":
		case "requireAfter":
		case "hostenv.loadModule":
			//Just worry about dep[1]
			newDeps = [{name: dep[1], content: null}];
			break;
	}

	//The requireAfterIf or requireAfter needs to be evaluated after the current package is evaluated.
	if(dep[0] == "requireAfterIf" || dep[0] == "requireIf"){
		newAfterDeps = newDeps;
		newDeps = null;
	}
	return {requires: newDeps, requiresAfter: newAfterDeps}; //Object
}

dojo.hostenv.xdWalkReqs = function(){
	//summary: Internal xd loader function. 
	//Walks the requires and evaluates package contents in
	//the right order.
	var reqChain = null;
	var req;
	for(var i = 0; i < this.xdOrderedReqs.length; i++){
		req = this.xdOrderedReqs[i];
		if(this.xdDepMap[req]){
			reqChain = [req];
			reqChain[req] = true; //Allow for fast lookup of the req in the array
			this.xdEvalReqs(reqChain);
		}
	}
}

dojo.hostenv.xdEvalReqs = function(/*Array*/reqChain){
	//summary: Internal xd loader function. 
	//Does a depth first, breadth second search and eval of required modules.
	while(reqChain.length > 0){
		var req = reqChain[reqChain.length - 1];
		var pkg = this.xdDepMap[req];
		if(pkg){
			//Trace down any requires for this package.
			//START dojo.hostenv.xdTraceReqs() inlining for small Safari 2.0 call stack
			var reqs = pkg.requires;
			if(reqs && reqs.length > 0){
				var nextReq;
				for(var i = 0; i < reqs.length; i++){
					nextReq = reqs[i].name;
					if(nextReq && !reqChain[nextReq]){
						//New req depedency. Follow it down.
						reqChain.push(nextReq);
						reqChain[nextReq] = true;
						this.xdEvalReqs(reqChain);
					}
				}
			}
			//END dojo.hostenv.xdTraceReqs() inlining for small Safari 2.0 call stack

			//Evaluate the package.
			var contents = this.xdContents[pkg.contentIndex];
			if(!contents.isDefined){
				var content = contents.content;
				content["resourceName"] = contents["resourceName"];
				content["resourcePath"] = contents["resourcePath"];
				this.xdDefList.push(content);
				contents.isDefined = true;
			}
			this.xdDepMap[req] = null;

			//Trace down any requireAfters for this package.
			//START dojo.hostenv.xdTraceReqs() inlining for small Safari 2.0 call stack
			var reqs = pkg.requiresAfter;
			if(reqs && reqs.length > 0){
				var nextReq;
				for(var i = 0; i < reqs.length; i++){
					nextReq = reqs[i].name;
					if(nextReq && !reqChain[nextReq]){
						//New req depedency. Follow it down.
						reqChain.push(nextReq);
						reqChain[nextReq] = true;
						this.xdEvalReqs(reqChain);
					}
				}
			}
			//END dojo.hostenv.xdTraceReqs() inlining for small Safari 2.0 call stack
		}

		//Done with that require. Remove it and go to the next one.
		reqChain.pop();
	}
}

dojo.hostenv.clearXdInterval = function(){
	//summary: Internal xd loader function.
	//Clears the interval timer used to check on the
	//status of in-flight xd module resource requests.
	clearInterval(this.xdTimer);
	this.xdTimer = 0;
}

dojo.hostenv.watchInFlightXDomain = function(){
	//summary: Internal xd loader function.
	//Monitors in-flight requests for xd module resources.

	//Make sure we haven't waited timed out.
	var waitInterval = (djConfig.xdWaitSeconds || 15) * 1000;

	if(this.xdStartTime + waitInterval < (new Date()).getTime()){
		this.clearXdInterval();
		var noLoads = "";
		for(var param in this.xdInFlight){
			if(this.xdInFlight[param]){
				noLoads += param + " ";
			}
		}
		dojo.raise("Could not load cross-domain packages: " + noLoads);
	}

	//If any are true, then still waiting.
	//Come back later.	
	for(var param in this.xdInFlight){
		if(this.xdInFlight[param]){
			return;
		}
	}

	//All done loading. Clean up and notify that we are loaded.
	this.clearXdInterval();

	this.xdWalkReqs();
	
	var defLength = this.xdDefList.length;
	for(var i= 0; i < defLength; i++){
		var content = dojo.hostenv.xdDefList[i];
		if(djConfig["debugAtAllCosts"] && content["resourceName"]){
			if(!this["xdDebugQueue"]){
				this.xdDebugQueue = [];
			}
			this.xdDebugQueue.push({resourceName: content.resourceName, resourcePath: content.resourcePath});
		}else{
			//Evaluate the package to bring it into being.
			//Pass dojo in so that later, to support multiple versions of dojo
			//in a page, we can pass which version of dojo to use.			
			content(dojo);
		}
	}

	//Evaluate any packages that were not evaled before.
	//This normally shouldn't happen with proper dojo.provide and dojo.require
	//usage, but providing it just in case. Note that these may not be executed
	//in the original order that the developer intended.
	//Pass dojo in so that later, to support multiple versions of dojo
	//in a page, we can pass which version of dojo to use.
	for(var i = 0; i < this.xdContents.length; i++){
		var current = this.xdContents[i];
		if(current.content && !current.isDefined){
			current.content(dojo);
		}
	}

	//Clean up for the next round of xd loading.
	this.resetXd();

	if(this["xdDebugQueue"] && this.xdDebugQueue.length > 0){
		this.xdDebugFileLoaded();
	}else{
		this.xdNotifyLoaded();
	}
}

dojo.hostenv.xdNotifyLoaded = function(){
	//Clear inflight count so we will finally do finish work.
	this.inFlightCount = 0; 
	
	//Only trigger call loaded if dj_load_init has run.
	if(this._djInitFired && !this.loadNotifying){
		this.callLoaded();
	}
}

dojo.hostenv.flattenRequireArray = function(/*Array*/target){
	//summary: Internal xd loader function.
	//Flattens an array of arrays into a one-level deep array.

	//Each result could be an array of 3 elements  (the 3 arguments to dojo.require).
	//We only need the first one.
	if(target){
		for(var i = 0; i < target.length; i++){
			if(target[i] instanceof Array){
				target[i] = {name: target[i][0], content: null};
			}else{
				target[i] = {name: target[i], content: null};
			}
		}
	}
}


dojo.hostenv.xdHasCalledPreload = false;
dojo.hostenv.xdRealCallLoaded = dojo.hostenv.callLoaded;
dojo.hostenv.callLoaded = function(){
	//summary: Internal xd loader function. Overrides callLoaded() from loader.js
	//description: The method is overridden because xd loading needs to preload 
	//any flattened i18n bundles before dojo starts executing code, 
	//since xd loading cannot do it synchronously, as the i18n code normally expects.

	//If getModulePrefix for dojo returns anything other than "src", that means
	//there is a path registered for dojo, with implies that dojo was xdomain loaded.
	if(this.xdHasCalledPreload || dojo.hostenv.getModulePrefix("dojo") == "src" || !this.localesGenerated){
		this.xdRealCallLoaded();
	}else{
		if(this.localesGenerated){
			this.registerNlsPrefix = function(){
				//Need to set the nls prefix to be the xd location.
				dojo.registerModulePath("nls", dojo.hostenv.getModulePrefix("dojo") + "/../nls");	
			};
			this.preloadLocalizations();
		}
	}
	this.xdHasCalledPreload = true;
}

}});

__CPAN_FILE__ src/loader.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



(function () {
	var _addHostEnv = {pkgFileName:"__package__", loading_modules_:{}, loaded_modules_:{}, addedToLoadingCount:[], removedFromLoadingCount:[], inFlightCount:0, modulePrefixes_:{dojo:{name:"dojo", value:"src"}}, setModulePrefix:function (module, prefix) {
		this.modulePrefixes_[module] = {name:module, value:prefix};
	}, moduleHasPrefix:function (module) {
		var mp = this.modulePrefixes_;
		return Boolean(mp[module] && mp[module].value);
	}, getModulePrefix:function (module) {
		if (this.moduleHasPrefix(module)) {
			return this.modulePrefixes_[module].value;
		}
		return module;
	}, getTextStack:[], loadUriStack:[], loadedUris:[], post_load_:false, modulesLoadedListeners:[], unloadListeners:[], loadNotifying:false};
	for (var param in _addHostEnv) {
		dojo.hostenv[param] = _addHostEnv[param];
	}
})();
dojo.hostenv.loadPath = function (relpath, module, cb) {
	var uri;
	if (relpath.charAt(0) == "/" || relpath.match(/^\w+:/)) {
		uri = relpath;
	} else {
		uri = this.getBaseScriptUri() + relpath;
	}
	if (djConfig.cacheBust && dojo.render.html.capable) {
		uri += "?" + String(djConfig.cacheBust).replace(/\W+/g, "");
	}
	try {
		return !module ? this.loadUri(uri, cb) : this.loadUriAndCheck(uri, module, cb);
	}
	catch (e) {
		dojo.debug(e);
		return false;
	}
};
dojo.hostenv.loadUri = function (uri, cb) {
	if (this.loadedUris[uri]) {
		return true;
	}
	var contents = this.getText(uri, null, true);
	if (!contents) {
		return false;
	}
	this.loadedUris[uri] = true;
	if (cb) {
		contents = "(" + contents + ")";
	}
	var value = dj_eval(contents);
	if (cb) {
		cb(value);
	}
	return true;
};
dojo.hostenv.loadUriAndCheck = function (uri, moduleName, cb) {
	var ok = true;
	try {
		ok = this.loadUri(uri, cb);
	}
	catch (e) {
		dojo.debug("failed loading ", uri, " with error: ", e);
	}
	return Boolean(ok && this.findModule(moduleName, false));
};
dojo.loaded = function () {
};
dojo.unloaded = function () {
};
dojo.hostenv.loaded = function () {
	this.loadNotifying = true;
	this.post_load_ = true;
	var mll = this.modulesLoadedListeners;
	for (var x = 0; x < mll.length; x++) {
		mll[x]();
	}
	this.modulesLoadedListeners = [];
	this.loadNotifying = false;
	dojo.loaded();
};
dojo.hostenv.unloaded = function () {
	var mll = this.unloadListeners;
	while (mll.length) {
		(mll.pop())();
	}
	dojo.unloaded();
};
dojo.addOnLoad = function (obj, functionName) {
	var dh = dojo.hostenv;
	if (arguments.length == 1) {
		dh.modulesLoadedListeners.push(obj);
	} else {
		if (arguments.length > 1) {
			dh.modulesLoadedListeners.push(function () {
				obj[functionName]();
			});
		}
	}
	if (dh.post_load_ && dh.inFlightCount == 0 && !dh.loadNotifying) {
		dh.callLoaded();
	}
};
dojo.addOnUnload = function (obj, functionName) {
	var dh = dojo.hostenv;
	if (arguments.length == 1) {
		dh.unloadListeners.push(obj);
	} else {
		if (arguments.length > 1) {
			dh.unloadListeners.push(function () {
				obj[functionName]();
			});
		}
	}
};
dojo.hostenv.modulesLoaded = function () {
	if (this.post_load_) {
		return;
	}
	if (this.loadUriStack.length == 0 && this.getTextStack.length == 0) {
		if (this.inFlightCount > 0) {
			dojo.debug("files still in flight!");
			return;
		}
		dojo.hostenv.callLoaded();
	}
};
dojo.hostenv.callLoaded = function () {
	if (typeof setTimeout == "object" || (djConfig["useXDomain"] && dojo.render.html.opera)) {
		setTimeout("dojo.hostenv.loaded();", 0);
	} else {
		dojo.hostenv.loaded();
	}
};
dojo.hostenv.getModuleSymbols = function (modulename) {
	var syms = modulename.split(".");
	for (var i = syms.length; i > 0; i--) {
		var parentModule = syms.slice(0, i).join(".");
		if ((i == 1) && !this.moduleHasPrefix(parentModule)) {
			syms[0] = "../" + syms[0];
		} else {
			var parentModulePath = this.getModulePrefix(parentModule);
			if (parentModulePath != parentModule) {
				syms.splice(0, i, parentModulePath);
				break;
			}
		}
	}
	return syms;
};
dojo.hostenv._global_omit_module_check = false;
dojo.hostenv.loadModule = function (moduleName, exactOnly, omitModuleCheck) {
	if (!moduleName) {
		return;
	}
	omitModuleCheck = this._global_omit_module_check || omitModuleCheck;
	var module = this.findModule(moduleName, false);
	if (module) {
		return module;
	}
	if (dj_undef(moduleName, this.loading_modules_)) {
		this.addedToLoadingCount.push(moduleName);
	}
	this.loading_modules_[moduleName] = 1;
	var relpath = moduleName.replace(/\./g, "/") + ".js";
	var nsyms = moduleName.split(".");
	var syms = this.getModuleSymbols(moduleName);
	var startedRelative = ((syms[0].charAt(0) != "/") && !syms[0].match(/^\w+:/));
	var last = syms[syms.length - 1];
	var ok;
	if (last == "*") {
		moduleName = nsyms.slice(0, -1).join(".");
		while (syms.length) {
			syms.pop();
			syms.push(this.pkgFileName);
			relpath = syms.join("/") + ".js";
			if (startedRelative && relpath.charAt(0) == "/") {
				relpath = relpath.slice(1);
			}
			ok = this.loadPath(relpath, !omitModuleCheck ? moduleName : null);
			if (ok) {
				break;
			}
			syms.pop();
		}
	} else {
		relpath = syms.join("/") + ".js";
		moduleName = nsyms.join(".");
		var modArg = !omitModuleCheck ? moduleName : null;
		ok = this.loadPath(relpath, modArg);
		if (!ok && !exactOnly) {
			syms.pop();
			while (syms.length) {
				relpath = syms.join("/") + ".js";
				ok = this.loadPath(relpath, modArg);
				if (ok) {
					break;
				}
				syms.pop();
				relpath = syms.join("/") + "/" + this.pkgFileName + ".js";
				if (startedRelative && relpath.charAt(0) == "/") {
					relpath = relpath.slice(1);
				}
				ok = this.loadPath(relpath, modArg);
				if (ok) {
					break;
				}
			}
		}
		if (!ok && !omitModuleCheck) {
			dojo.raise("Could not load '" + moduleName + "'; last tried '" + relpath + "'");
		}
	}
	if (!omitModuleCheck && !this["isXDomain"]) {
		module = this.findModule(moduleName, false);
		if (!module) {
			dojo.raise("symbol '" + moduleName + "' is not defined after loading '" + relpath + "'");
		}
	}
	return module;
};
dojo.hostenv.startPackage = function (packageName) {
	var fullPkgName = String(packageName);
	var strippedPkgName = fullPkgName;
	var syms = packageName.split(/\./);
	if (syms[syms.length - 1] == "*") {
		syms.pop();
		strippedPkgName = syms.join(".");
	}
	var evaledPkg = dojo.evalObjPath(strippedPkgName, true);
	this.loaded_modules_[fullPkgName] = evaledPkg;
	this.loaded_modules_[strippedPkgName] = evaledPkg;
	return evaledPkg;
};
dojo.hostenv.findModule = function (moduleName, mustExist) {
	var lmn = String(moduleName);
	if (this.loaded_modules_[lmn]) {
		return this.loaded_modules_[lmn];
	}
	if (mustExist) {
		dojo.raise("no loaded module named '" + moduleName + "'");
	}
	return null;
};
dojo.kwCompoundRequire = function (modMap) {
	var common = modMap["common"] || [];
	var result = modMap[dojo.hostenv.name_] ? common.concat(modMap[dojo.hostenv.name_] || []) : common.concat(modMap["default"] || []);
	for (var x = 0; x < result.length; x++) {
		var curr = result[x];
		if (curr.constructor == Array) {
			dojo.hostenv.loadModule.apply(dojo.hostenv, curr);
		} else {
			dojo.hostenv.loadModule(curr);
		}
	}
};
dojo.require = function (resourceName) {
	dojo.hostenv.loadModule.apply(dojo.hostenv, arguments);
};
dojo.requireIf = function (condition, resourceName) {
	var arg0 = arguments[0];
	if ((arg0 === true) || (arg0 == "common") || (arg0 && dojo.render[arg0].capable)) {
		var args = [];
		for (var i = 1; i < arguments.length; i++) {
			args.push(arguments[i]);
		}
		dojo.require.apply(dojo, args);
	}
};
dojo.requireAfterIf = dojo.requireIf;
dojo.provide = function (resourceName) {
	return dojo.hostenv.startPackage.apply(dojo.hostenv, arguments);
};
dojo.registerModulePath = function (module, prefix) {
	return dojo.hostenv.setModulePrefix(module, prefix);
};
if (djConfig["modulePaths"]) {
	for (var param in djConfig["modulePaths"]) {
		dojo.registerModulePath(param, djConfig["modulePaths"][param]);
	}
}
dojo.setModulePrefix = function (module, prefix) {
	dojo.deprecated("dojo.setModulePrefix(\"" + module + "\", \"" + prefix + "\")", "replaced by dojo.registerModulePath", "0.5");
	return dojo.registerModulePath(module, prefix);
};
dojo.exists = function (obj, name) {
	var p = name.split(".");
	for (var i = 0; i < p.length; i++) {
		if (!obj[p[i]]) {
			return false;
		}
		obj = obj[p[i]];
	}
	return true;
};
dojo.hostenv.normalizeLocale = function (locale) {
	var result = locale ? locale.toLowerCase() : dojo.locale;
	if (result == "root") {
		result = "ROOT";
	}
	return result;
};
dojo.hostenv.searchLocalePath = function (locale, down, searchFunc) {
	locale = dojo.hostenv.normalizeLocale(locale);
	var elements = locale.split("-");
	var searchlist = [];
	for (var i = elements.length; i > 0; i--) {
		searchlist.push(elements.slice(0, i).join("-"));
	}
	searchlist.push(false);
	if (down) {
		searchlist.reverse();
	}
	for (var j = searchlist.length - 1; j >= 0; j--) {
		var loc = searchlist[j] || "ROOT";
		var stop = searchFunc(loc);
		if (stop) {
			break;
		}
	}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix = function () {
	dojo.registerModulePath("nls", "nls");
};
dojo.hostenv.preloadLocalizations = function () {
	if (dojo.hostenv.localesGenerated) {
		dojo.hostenv.registerNlsPrefix();
		function preload(locale) {
			locale = dojo.hostenv.normalizeLocale(locale);
			dojo.hostenv.searchLocalePath(locale, true, function (loc) {
				for (var i = 0; i < dojo.hostenv.localesGenerated.length; i++) {
					if (dojo.hostenv.localesGenerated[i] == loc) {
						dojo["require"]("nls.dojo_" + loc);
						return true;
					}
				}
				return false;
			});
		}
		preload();
		var extra = djConfig.extraLocale || [];
		for (var i = 0; i < extra.length; i++) {
			preload(extra[i]);
		}
	}
	dojo.hostenv.preloadLocalizations = function () {
	};
};
dojo.requireLocalization = function (moduleName, bundleName, locale, availableFlatLocales) {
	dojo.hostenv.preloadLocalizations();
	var targetLocale = dojo.hostenv.normalizeLocale(locale);
	var bundlePackage = [moduleName, "nls", bundleName].join(".");
	var bestLocale = "";
	if (availableFlatLocales) {
		var flatLocales = availableFlatLocales.split(",");
		for (var i = 0; i < flatLocales.length; i++) {
			if (targetLocale.indexOf(flatLocales[i]) == 0) {
				if (flatLocales[i].length > bestLocale.length) {
					bestLocale = flatLocales[i];
				}
			}
		}
		if (!bestLocale) {
			bestLocale = "ROOT";
		}
	}
	var tempLocale = availableFlatLocales ? bestLocale : targetLocale;
	var bundle = dojo.hostenv.findModule(bundlePackage);
	var localizedBundle = null;
	if (bundle) {
		if (djConfig.localizationComplete && bundle._built) {
			return;
		}
		var jsLoc = tempLocale.replace("-", "_");
		var translationPackage = bundlePackage + "." + jsLoc;
		localizedBundle = dojo.hostenv.findModule(translationPackage);
	}
	if (!localizedBundle) {
		bundle = dojo.hostenv.startPackage(bundlePackage);
		var syms = dojo.hostenv.getModuleSymbols(moduleName);
		var modpath = syms.concat("nls").join("/");
		var parent;
		dojo.hostenv.searchLocalePath(tempLocale, availableFlatLocales, function (loc) {
			var jsLoc = loc.replace("-", "_");
			var translationPackage = bundlePackage + "." + jsLoc;
			var loaded = false;
			if (!dojo.hostenv.findModule(translationPackage)) {
				dojo.hostenv.startPackage(translationPackage);
				var module = [modpath];
				if (loc != "ROOT") {
					module.push(loc);
				}
				module.push(bundleName);
				var filespec = module.join("/") + ".js";
				loaded = dojo.hostenv.loadPath(filespec, null, function (hash) {
					var clazz = function () {
					};
					clazz.prototype = parent;
					bundle[jsLoc] = new clazz();
					for (var j in hash) {
						bundle[jsLoc][j] = hash[j];
					}
				});
			} else {
				loaded = true;
			}
			if (loaded && bundle[jsLoc]) {
				parent = bundle[jsLoc];
			} else {
				bundle[jsLoc] = parent;
			}
			if (availableFlatLocales) {
				return true;
			}
		});
	}
	if (availableFlatLocales && targetLocale != bestLocale) {
		bundle[targetLocale.replace("-", "_")] = bundle[bestLocale.replace("-", "_")];
	}
};
(function () {
	var extra = djConfig.extraLocale;
	if (extra) {
		if (!extra instanceof Array) {
			extra = [extra];
		}
		var req = dojo.requireLocalization;
		dojo.requireLocalization = function (m, b, locale, availableFlatLocales) {
			req(m, b, locale, availableFlatLocales);
			if (locale) {
				return;
			}
			for (var i = 0; i < extra.length; i++) {
				req(m, b, extra[i], availableFlatLocales);
			}
		};
	}
})();


__CPAN_FILE__ src/storage.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.storage");
dojo.require("dojo.lang.*");
dojo.require("dojo.event.*");
dojo.storage = new function () {
};
dojo.declare("dojo.storage", null, {SUCCESS:"success", FAILED:"failed", PENDING:"pending", SIZE_NOT_AVAILABLE:"Size not available", SIZE_NO_LIMIT:"No size limit", namespace:"default", onHideSettingsUI:null, initialize:function () {
	dojo.unimplemented("dojo.storage.initialize");
}, isAvailable:function () {
	dojo.unimplemented("dojo.storage.isAvailable");
}, put:function (key, value, resultsHandler) {
	dojo.unimplemented("dojo.storage.put");
}, get:function (key) {
	dojo.unimplemented("dojo.storage.get");
}, hasKey:function (key) {
	return (this.get(key) != null);
}, getKeys:function () {
	dojo.unimplemented("dojo.storage.getKeys");
}, clear:function () {
	dojo.unimplemented("dojo.storage.clear");
}, remove:function (key) {
	dojo.unimplemented("dojo.storage.remove");
}, isPermanent:function () {
	dojo.unimplemented("dojo.storage.isPermanent");
}, getMaximumSize:function () {
	dojo.unimplemented("dojo.storage.getMaximumSize");
}, hasSettingsUI:function () {
	return false;
}, showSettingsUI:function () {
	dojo.unimplemented("dojo.storage.showSettingsUI");
}, hideSettingsUI:function () {
	dojo.unimplemented("dojo.storage.hideSettingsUI");
}, getType:function () {
	dojo.unimplemented("dojo.storage.getType");
}, isValidKey:function (keyName) {
	if ((keyName == null) || (typeof keyName == "undefined")) {
		return false;
	}
	return /^[0-9A-Za-z_]*$/.test(keyName);
}});
dojo.storage.manager = new function () {
	this.currentProvider = null;
	this.available = false;
	this._initialized = false;
	this._providers = [];
	this.namespace = "default";
	this.initialize = function () {
		this.autodetect();
	};
	this.register = function (name, instance) {
		this._providers[this._providers.length] = instance;
		this._providers[name] = instance;
	};
	this.setProvider = function (storageClass) {
	};
	this.autodetect = function () {
		if (this._initialized == true) {
			return;
		}
		var providerToUse = null;
		for (var i = 0; i < this._providers.length; i++) {
			providerToUse = this._providers[i];
			if (dojo.lang.isUndefined(djConfig["forceStorageProvider"]) == false && providerToUse.getType() == djConfig["forceStorageProvider"]) {
				providerToUse.isAvailable();
				break;
			} else {
				if (dojo.lang.isUndefined(djConfig["forceStorageProvider"]) == true && providerToUse.isAvailable()) {
					break;
				}
			}
		}
		if (providerToUse == null) {
			this._initialized = true;
			this.available = false;
			this.currentProvider = null;
			dojo.raise("No storage provider found for this platform");
		}
		this.currentProvider = providerToUse;
		for (var i in providerToUse) {
			dojo.storage[i] = providerToUse[i];
		}
		dojo.storage.manager = this;
		dojo.storage.initialize();
		this._initialized = true;
		this.available = true;
	};
	this.isAvailable = function () {
		return this.available;
	};
	this.isInitialized = function () {
		if (this.currentProvider.getType() == "dojo.storage.browser.FlashStorageProvider" && dojo.flash.ready == false) {
			return false;
		} else {
			return this._initialized;
		}
	};
	this.supportsProvider = function (storageClass) {
		try {
			var provider = eval("new " + storageClass + "()");
			var results = provider.isAvailable();
			if (results == null || typeof results == "undefined") {
				return false;
			}
			return results;
		}
		catch (exception) {
			return false;
		}
	};
	this.getProvider = function () {
		return this.currentProvider;
	};
	this.loaded = function () {
	};
};


__CPAN_FILE__ src/style.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.style");
dojo.require("dojo.lang.common");
dojo.kwCompoundRequire({browser:["dojo.html.style"]});
dojo.deprecated("dojo.style", "replaced by dojo.html.style", "0.5");
dojo.lang.mixin(dojo.style, dojo.html);


__CPAN_FILE__ src/style.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.style"], ["require", "dojo.lang.common"], ["kwCompoundRequire", {browser:["dojo.html.style"]}]], definePackage:function (dojo) {
	dojo.provide("dojo.style");
	dojo.require("dojo.lang.common");
	dojo.kwCompoundRequire({browser:["dojo.html.style"]});
	dojo.deprecated("dojo.style", "replaced by dojo.html.style", "0.5");
	dojo.lang.mixin(dojo.style, dojo.html);
}});


__CPAN_FILE__ src/behavior.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.behavior"], ["require", "dojo.event.*"], ["require", "dojo.experimental"]], definePackage:function (dojo) {
	dojo.provide("dojo.behavior");
	dojo.require("dojo.event.*");
	dojo.require("dojo.experimental");
	dojo.experimental("dojo.behavior");
	dojo.behavior = new function () {
		function arrIn(obj, name) {
			if (!obj[name]) {
				obj[name] = [];
			}
			return obj[name];
		}
		function forIn(obj, scope, func) {
			var tmpObj = {};
			for (var x in obj) {
				if (typeof tmpObj[x] == "undefined") {
					if (!func) {
						scope(obj[x], x);
					} else {
						func.call(scope, obj[x], x);
					}
				}
			}
		}
		this.behaviors = {};
		this.add = function (behaviorObj) {
			var tmpObj = {};
			forIn(behaviorObj, this, function (behavior, name) {
				var tBehavior = arrIn(this.behaviors, name);
				if ((dojo.lang.isString(behavior)) || (dojo.lang.isFunction(behavior))) {
					behavior = {found:behavior};
				}
				forIn(behavior, function (rule, ruleName) {
					arrIn(tBehavior, ruleName).push(rule);
				});
			});
		};
		this.apply = function () {
			dojo.profile.start("dojo.behavior.apply");
			var r = dojo.render.html;
			var safariGoodEnough = (!r.safari);
			if (r.safari) {
				var uas = r.UA.split("AppleWebKit/")[1];
				if (parseInt(uas.match(/[0-9.]{3,}/)) >= 420) {
					safariGoodEnough = true;
				}
			}
			if ((dj_undef("behaviorFastParse", djConfig) ? (safariGoodEnough) : djConfig["behaviorFastParse"])) {
				this.applyFast();
			} else {
				this.applySlow();
			}
			dojo.profile.end("dojo.behavior.apply");
		};
		this.matchCache = {};
		this.elementsById = function (id, handleRemoved) {
			var removed = [];
			var added = [];
			arrIn(this.matchCache, id);
			if (handleRemoved) {
				var nodes = this.matchCache[id];
				for (var x = 0; x < nodes.length; x++) {
					if (nodes[x].id != "") {
						removed.push(nodes[x]);
						nodes.splice(x, 1);
						x--;
					}
				}
			}
			var tElem = dojo.byId(id);
			while (tElem) {
				if (!tElem["idcached"]) {
					added.push(tElem);
				}
				tElem.id = "";
				tElem = dojo.byId(id);
			}
			this.matchCache[id] = this.matchCache[id].concat(added);
			dojo.lang.forEach(this.matchCache[id], function (node) {
				node.id = id;
				node.idcached = true;
			});
			return {"removed":removed, "added":added, "match":this.matchCache[id]};
		};
		this.applyToNode = function (node, action, ruleSetName) {
			if (typeof action == "string") {
				dojo.event.topic.registerPublisher(action, node, ruleSetName);
			} else {
				if (typeof action == "function") {
					if (ruleSetName == "found") {
						action(node);
					} else {
						dojo.event.connect(node, ruleSetName, action);
					}
				} else {
					action.srcObj = node;
					action.srcFunc = ruleSetName;
					dojo.event.kwConnect(action);
				}
			}
		};
		this.applyFast = function () {
			dojo.profile.start("dojo.behavior.applyFast");
			forIn(this.behaviors, function (tBehavior, id) {
				var elems = dojo.behavior.elementsById(id);
				dojo.lang.forEach(elems.added, function (elem) {
					forIn(tBehavior, function (ruleSet, ruleSetName) {
						if (dojo.lang.isArray(ruleSet)) {
							dojo.lang.forEach(ruleSet, function (action) {
								dojo.behavior.applyToNode(elem, action, ruleSetName);
							});
						}
					});
				});
			});
			dojo.profile.end("dojo.behavior.applyFast");
		};
		this.applySlow = function () {
			dojo.profile.start("dojo.behavior.applySlow");
			var all = document.getElementsByTagName("*");
			var allLen = all.length;
			for (var x = 0; x < allLen; x++) {
				var elem = all[x];
				if ((elem.id) && (!elem["behaviorAdded"]) && (this.behaviors[elem.id])) {
					elem["behaviorAdded"] = true;
					forIn(this.behaviors[elem.id], function (ruleSet, ruleSetName) {
						if (dojo.lang.isArray(ruleSet)) {
							dojo.lang.forEach(ruleSet, function (action) {
								dojo.behavior.applyToNode(elem, action, ruleSetName);
							});
						}
					});
				}
			}
			dojo.profile.end("dojo.behavior.applySlow");
		};
	};
	dojo.addOnLoad(dojo.behavior, "apply");
}});


__CPAN_FILE__ src/data.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.data");
dojo.data = {};


__CPAN_FILE__ src/browser_debug_xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.browser_debug_xd");
dojo.nonDebugProvide = dojo.provide;
dojo.provide = function (resourceName) {
	var dbgQueue = dojo.hostenv["xdDebugQueue"];
	if (dbgQueue && dbgQueue.length > 0 && resourceName == dbgQueue["currentResourceName"]) {
		window.setTimeout("dojo.hostenv.xdDebugFileLoaded('" + resourceName + "')", 1);
	}
	dojo.nonDebugProvide.apply(dojo, arguments);
};
dojo.hostenv.xdDebugFileLoaded = function (resourceName) {
	var dbgQueue = this.xdDebugQueue;
	if (resourceName && resourceName == dbgQueue.currentResourceName) {
		dbgQueue.shift();
	}
	if (dbgQueue.length == 0) {
		dbgQueue.currentResourceName = null;
		this.xdNotifyLoaded();
	} else {
		dbgQueue.currentResourceName = dbgQueue[0].resourceName;
		var element = document.createElement("script");
		element.type = "text/javascript";
		element.src = dbgQueue[0].resourcePath;
		document.getElementsByTagName("head")[0].appendChild(element);
	}
};


__CPAN_FILE__ src/svg.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.svg");
dojo.require("dojo.lang.common");
dojo.require("dojo.dom");
dojo.mixin(dojo.svg, dojo.dom);
dojo.svg.graphics = dojo.svg.g = new function (d) {
	this.suspend = function () {
		try {
			d.documentElement.suspendRedraw(0);
		}
		catch (e) {
		}
	};
	this.resume = function () {
		try {
			d.documentElement.unsuspendRedraw(0);
		}
		catch (e) {
		}
	};
	this.force = function () {
		try {
			d.documentElement.forceRedraw();
		}
		catch (e) {
		}
	};
}(document);
dojo.svg.animations = dojo.svg.anim = new function (d) {
	this.arePaused = function () {
		try {
			return d.documentElement.animationsPaused();
		}
		catch (e) {
			return false;
		}
	};
	this.pause = function () {
		try {
			d.documentElement.pauseAnimations();
		}
		catch (e) {
		}
	};
	this.resume = function () {
		try {
			d.documentElement.unpauseAnimations();
		}
		catch (e) {
		}
	};
}(document);
dojo.svg.toCamelCase = function (selector) {
	var arr = selector.split("-"), cc = arr[0];
	for (var i = 1; i < arr.length; i++) {
		cc += arr[i].charAt(0).toUpperCase() + arr[i].substring(1);
	}
	return cc;
};
dojo.svg.toSelectorCase = function (selector) {
	return selector.replace(/([A-Z])/g, "-$1").toLowerCase();
};
dojo.svg.getStyle = function (node, cssSelector) {
	return document.defaultView.getComputedStyle(node, cssSelector);
};
dojo.svg.getNumericStyle = function (node, cssSelector) {
	return parseFloat(dojo.svg.getStyle(node, cssSelector));
};
dojo.svg.getOpacity = function (node) {
	return Math.min(1, dojo.svg.getNumericStyle(node, "fill-opacity"));
};
dojo.svg.setOpacity = function (node, opacity) {
	node.setAttributeNS(this.xmlns.svg, "fill-opacity", opacity);
	node.setAttributeNS(this.xmlns.svg, "stroke-opacity", opacity);
};
dojo.svg.clearOpacity = function (node) {
	node.setAttributeNS(this.xmlns.svg, "fill-opacity", "1.0");
	node.setAttributeNS(this.xmlns.svg, "stroke-opacity", "1.0");
};
dojo.svg.getCoords = function (node) {
	if (node.getBBox) {
		var box = node.getBBox();
		return {x:box.x, y:box.y};
	}
	return null;
};
dojo.svg.setCoords = function (node, coords) {
	var p = dojo.svg.getCoords();
	if (!p) {
		return;
	}
	var dx = p.x - coords.x;
	var dy = p.y - coords.y;
	dojo.svg.translate(node, dx, dy);
};
dojo.svg.getDimensions = function (node) {
	if (node.getBBox) {
		var box = node.getBBox();
		return {width:box.width, height:box.height};
	}
	return null;
};
dojo.svg.setDimensions = function (node, dim) {
	if (node.width) {
		node.width.baseVal.value = dim.width;
		node.height.baseVal.value = dim.height;
	} else {
		if (node.r) {
			node.r.baseVal.value = Math.min(dim.width, dim.height) / 2;
		} else {
			if (node.rx) {
				node.rx.baseVal.value = dim.width / 2;
				node.ry.baseVal.value = dim.height / 2;
			}
		}
	}
};
dojo.svg.translate = function (node, dx, dy) {
	if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
		var t = node.ownerSVGElement.createSVGTransform();
		t.setTranslate(dx, dy);
		node.transform.baseVal.appendItem(t);
	}
};
dojo.svg.scale = function (node, scaleX, scaleY) {
	if (!scaleY) {
		var scaleY = scaleX;
	}
	if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
		var t = node.ownerSVGElement.createSVGTransform();
		t.setScale(scaleX, scaleY);
		node.transform.baseVal.appendItem(t);
	}
};
dojo.svg.rotate = function (node, ang, cx, cy) {
	if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
		var t = node.ownerSVGElement.createSVGTransform();
		if (cx == null) {
			t.setMatrix(t.matrix.rotate(ang));
		} else {
			t.setRotate(ang, cx, cy);
		}
		node.transform.baseVal.appendItem(t);
	}
};
dojo.svg.skew = function (node, ang, axis) {
	var dir = axis || "x";
	if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
		var t = node.ownerSVGElement.createSVGTransform();
		if (dir != "x") {
			t.setSkewY(ang);
		} else {
			t.setSkewX(ang);
		}
		node.transform.baseVal.appendItem(t);
	}
};
dojo.svg.flip = function (node, axis) {
	var dir = axis || "x";
	if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
		var t = node.ownerSVGElement.createSVGTransform();
		t.setMatrix((dir != "x") ? t.matrix.flipY() : t.matrix.flipX());
		node.transform.baseVal.appendItem(t);
	}
};
dojo.svg.invert = function (node) {
	if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
		var t = node.ownerSVGElement.createSVGTransform();
		t.setMatrix(t.matrix.inverse());
		node.transform.baseVal.appendItem(t);
	}
};
dojo.svg.applyMatrix = function (node, a, b, c, d, e, f) {
	if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
		var m;
		if (b) {
			var m = node.ownerSVGElement.createSVGMatrix();
			m.a = a;
			m.b = b;
			m.c = c;
			m.d = d;
			m.e = e;
			m.f = f;
		} else {
			m = a;
		}
		var t = node.ownerSVGElement.createSVGTransform();
		t.setMatrix(m);
		node.transform.baseVal.appendItem(t);
	}
};
dojo.svg.group = function (nodes) {
	var p = nodes.item(0).parentNode;
	var g = document.createElementNS(this.xmlns.svg, "g");
	for (var i = 0; i < nodes.length; i++) {
		g.appendChild(nodes.item(i));
	}
	p.appendChild(g);
	return g;
};
dojo.svg.ungroup = function (g) {
	var p = g.parentNode;
	while (g.childNodes.length > 0) {
		p.appendChild(g.childNodes.item(0));
	}
	p.removeChild(g);
};
dojo.svg.getGroup = function (node) {
	var a = this.getAncestors(node);
	for (var i = 0; i < a.length; i++) {
		if (a[i].nodeType == this.ELEMENT_NODE && a[i].nodeName.toLowerCase() == "g") {
			return a[i];
		}
	}
	return null;
};
dojo.svg.bringToFront = function (node) {
	var n = this.getGroup(node) || node;
	n.ownerSVGElement.appendChild(n);
};
dojo.svg.sendToBack = function (node) {
	var n = this.getGroup(node) || node;
	n.ownerSVGElement.insertBefore(n, n.ownerSVGElement.firstChild);
};
dojo.svg.bringForward = function (node) {
	var n = this.getGroup(node) || node;
	if (this.getLastChildElement(n.parentNode) != n) {
		this.insertAfter(n, this.getNextSiblingElement(n), true);
	}
};
dojo.svg.sendBackward = function (node) {
	var n = this.getGroup(node) || node;
	if (this.getFirstChildElement(n.parentNode) != n) {
		this.insertBefore(n, this.getPreviousSiblingElement(n), true);
	}
};
dojo.svg.createNodesFromText = function (txt, wrap) {
	var docFrag = (new DOMParser()).parseFromString(txt, "text/xml").normalize();
	if (wrap) {
		return [docFrag.firstChild.cloneNode(true)];
	}
	var nodes = [];
	for (var x = 0; x < docFrag.childNodes.length; x++) {
		nodes.push(docFrag.childNodes.item(x).cloneNode(true));
	}
	return nodes;
};


__CPAN_FILE__ src/hostenv_svg.xd.js
dojo.hostenv.packageLoaded({
depends: [["require", '" + moduleName + "'],
["requireIf", (djConfig["isDebug"] || djConfig["debugAtAllCosts"]]],
definePackage: function(dojo){/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

//	hostenv_svg
if(typeof window == 'undefined'){
	dojo.raise("attempt to use adobe svg hostenv when no window object");
}
dojo.debug = function(){ 
	if (!djConfig.isDebug) { return; }
	var args = arguments;
	var isJUM = dj_global["jum"];
	var s = isJUM ? "": "DEBUG: ";
	for (var i = 0; i < args.length; ++i){ s += args[i]; }
	if (isJUM){ // this seems to be the only way to get JUM to "play nice"
		jum.debug(s);
	} else{ 
		dojo.hostenv.println(s);
	}
};

//	set up dojo.render.
dojo.render.name = navigator.appName;
dojo.render.ver = parseFloat(navigator.appVersion, 10);
switch(navigator.platform){
	case "MacOS":
		dojo.render.os.osx =  true;
		break;
	case "Linux":
		dojo.render.os.linux =  true;
		break;
	case "Windows":
		dojo.render.os.win =  true;
		break;
	default:
		dojo.render.os.linux = true;
		break;
};
dojo.render.svg.capable = true;
dojo.render.svg.support.builtin = true;
//	FIXME the following two is a big-ass hack for now.
dojo.render.svg.moz = ((navigator.userAgent.indexOf("Gecko") >= 0) && (!((navigator.appVersion.indexOf("Konqueror") >= 0) || (navigator.appVersion.indexOf("Safari") >= 0))));
dojo.render.svg.adobe = (window.parseXML != null);

//	agent-specific implementations.

//	from old hostenv_adobesvg.
dojo.hostenv.startPackage("dojo.hostenv");
dojo.hostenv.println = function(s){ 
	try {
		var ti = document.createElement("text");
		ti.setAttribute("x","50");
		ti.setAttribute("y", (25 + 15 * document.getElementsByTagName("text").length));
		ti.appendChild(document.createTextNode(s));
		document.documentElement.appendChild(ti);
	} catch(e){ }
};
dojo.hostenv.name_ = "svg";

//	expected/defined by bootstrap1.js
dojo.hostenv.setModulePrefix = function(module, prefix){ };
dojo.hostenv.getModulePrefix = function(module){ };
dojo.hostenv.getTextStack = [];
dojo.hostenv.loadUriStack = [];
dojo.hostenv.loadedUris = [];
dojo.hostenv.modules_ = {};
dojo.hostenv.modulesLoadedFired = false;
dojo.hostenv.modulesLoadedListeners = [];
dojo.hostenv.getText = function(uri, cb, data){ 
	if (!cb) var cb = function(result){ window.alert(result); };
	if (!data) {
		window.getUrl(uri, cb);
	} else {
		window.postUrl(uri, data, cb);
	}
};
dojo.hostenv.getLibaryScriptUri = function(){ };

dojo.hostenv.loadUri = function(uri){ };
dojo.hostenv.loadUriAndCheck = function(uri, module){ };

//	aliased in loader.js, don't ignore
//	we are going to kill loadModule for the first round of SVG stuff, and include stuff manually.
dojo.hostenv.loadModule = function(moduleName){
	//	just like startPackage, but this time we're just checking to make sure it exists already.
	var a = moduleName.split(".");
	var currentObj = window;
	var s = [];
	for (var i = 0; i < a.length; i++){
		if (a[i] == "*") continue;
		s.push(a[i]);
		if (!currentObj[a[i]]){
			dojo.raise("dojo.require('" + moduleName + "'): module does not exist.");
		} else currentObj = currentObj[a[i]];
	}
	return; 
};
dojo.hostenv.startPackage = function(moduleName){
	var a = moduleName.split(".");
	var currentObj = window;
	var s = [];
	for (var i = 0; i < a.length; i++){
		if (a[i] == "*") continue;
		s.push(a[i]);
		if (!currentObj[a[i]]) currentObj[a[i]] = {};
		currentObj = currentObj[a[i]];
	}
	return; 
};

//	wrapper objects for ASVG
if (window.parseXML){
	window.XMLSerialzer = function(){
		//	based on WebFX RichTextControl getXHTML() function.
		function nodeToString(n, a) {
			function fixText(s) { return String(s).replace(/\&/g, "&amp;").replace(/>/g, "&gt;").replace(/</g, "&lt;"); }
			function fixAttribute(s) { return fixText(s).replace(/\"/g, "&quot;"); }
			switch (n.nodeType) {
				case 1:	{	//	ELEMENT
					var name = n.nodeName;
					a.push("<" + name);
					for (var i = 0; i < n.attributes.length; i++) {
						if (n.attributes.item(i).specified) {
							a.push(" " + n.attributes.item(i).nodeName.toLowerCase() + "=\"" + fixAttribute(n.attributes.item(i).nodeValue) + "\"");
						}
					}
					if (n.canHaveChildren || n.hasChildNodes()) {
						a.push(">");
						for (var i = 0; i < n.childNodes.length; i++) nodeToString(n.childNodes.item(i), a);
						a.push("</" + name + ">\n");
					} else a.push(" />\n");
					break;
				}
				case 3: {	//	TEXT
					a.push(fixText(n.nodeValue));
					break;
				}
				case 4: {	//	CDATA
					a.push("<![CDA" + "TA[\n" + n.nodeValue + "\n]" + "]>");
					break;
				}
				case 7:{	//	PROCESSING INSTRUCTION
					a.push(n.nodeValue);
					if (/(^<\?xml)|(^<\!DOCTYPE)/.test(n.nodeValue)) a.push("\n");
					break;
				}
				case 8:{	//	COMMENT
					a.push("<!-- " + n.nodeValue + " -->\n");
					break;
				}
				case 9:		//	DOCUMENT
				case 11:{	//	DOCUMENT FRAGMENT
					for (var i = 0; i < n.childNodes.length; i++) nodeToString(n.childNodes.item(i), a);
					break;
				}
				default:{
					a.push("<!--\nNot Supported:\n\n" + "nodeType: " + n.nodeType + "\nnodeName: " + n.nodeName + "\n-->");
				}
			}
		}
		this.serializeToString = function(node){
			var a = [];
			nodeToString(node, a);
			return a.join("");
		};
	};

	window.DOMParser = function(){
		//	mimetype is basically ignored
		this.parseFromString = function(s){
			return parseXML(s, window.document);
		}
	};

	window.XMLHttpRequest = function(){
		//	we ignore the setting and getting of content-type.
		var uri = null;
		var method = "POST";
		var isAsync = true;	
		var cb = function(d){
			this.responseText = d.content;
			try {
				this.responseXML = parseXML(this.responseText, window.document);
			} catch(e){}
			this.status = "200";
			this.statusText = "OK";
			if (!d.success) {
				this.status = "500";
				this.statusText = "Internal Server Error";
			}
			this.onload();
			this.onreadystatechange();
		};
		this.onload = function(){};
		this.readyState = 4;
		this.onreadystatechange = function(){};
		this.status = 0;
		this.statusText = "";
		this.responseBody = null;
		this.responseStream = null;
		this.responseXML = null;
		this.responseText = null;
		this.abort = function(){ return; };
		this.getAllResponseHeaders = function(){ return []; };
		this.getResponseHeader = function(n){ return null; };
		this.setRequestHeader = function(nm, val){ };
		this.open = function(meth, url, async){ 
			method = meth;
			uri = url;
		};
		this.send = function(data){
			var d = data || null;
			if (method == "GET") getURL(uri, cb);
			else postURL(uri, data, cb);
		};
	};
}

dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");

}});

__CPAN_FILE__ src/validate.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.validate");
dojo.require("dojo.validate.common");


__CPAN_FILE__ src/crypto.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.crypto");
dojo.crypto.cipherModes = {ECB:0, CBC:1, PCBC:2, CFB:3, OFB:4, CTR:5};
dojo.crypto.outputTypes = {Base64:0, Hex:1, String:2, Raw:3};


__CPAN_FILE__ src/hostenv_jsc.xd.js
dojo.hostenv.packageLoaded({
depends: [["requireIf", (djConfig["isDebug"] || djConfig["debugAtAllCosts"]]],
definePackage: function(dojo){/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
 * JScript .NET jsc
 *
 */

dojo.hostenv.name_ = 'jsc';

// Sanity check this is the right hostenv.
// See the Rotor source code jscript/engine/globalobject.cs for what globals
// are available.
if((typeof ScriptEngineMajorVersion != 'function')||(ScriptEngineMajorVersion() < 7)){
	dojo.raise("attempt to use JScript .NET host environment with inappropriate ScriptEngine"); 
}

// for more than you wanted to know about why this import is required even if
// we fully qualify all symbols, see
// http://groups.google.com/groups?th=f050c7aeefdcbde2&rnum=12
import System;

dojo.hostenv.getText = function(uri){
	if(!System.IO.File.Exists(uri)){
		// dojo.raise("No such file '" + uri + "'");
		return 0;
	}
	var reader = new System.IO.StreamReader(uri);
	var contents : String = reader.ReadToEnd();
	return contents;
}

dojo.hostenv.loadUri = function(uri){
	var contents = this.getText(uri);
	if(!contents){
		dojo.raise("got no back contents from uri '" + uri + "': " + contents);
	}
	// TODO: in JScript .NET, eval will not affect the symbol table of the current code?
	var value = dj_eval(contents);
	dojo.debug("jsc eval of contents returned: ", value);
	return 1;

	// for an example doing runtime code compilation, see:
	// http://groups.google.com/groups?selm=eQ1aeciCBHA.1644%40tkmsftngp05&rnum=6
	// Microsoft.JScript or System.CodeDom.Compiler ?
	// var engine = new Microsoft.JScript.Vsa.VsaEngine()
	// what about loading a js file vs. a dll?
	// GetObject("script:" . uri);
}

/* The System.Environment object is useful:
    print ("CommandLine='" + System.Environment.CommandLine + "' " +
	   "program name='" + System.Environment.GetCommandLineArgs()[0] + "' " +
	   "CurrentDirectory='" + System.Environment.CurrentDirectory + "' " +
	   "StackTrace='" + System.Environment.StackTrace + "'");
*/

// same as System.Console.WriteLine
// sigh; Rotor treats symbol "print" at parse time without actually putting it
// in the builtin symbol table.
// Note that the print symbol is not available if jsc is run with the "/print-"
// option.
dojo.hostenv.println = function(s){
	print(s); // = print
}

dojo.hostenv.getLibraryScriptUri = function(){
	return System.Environment.GetCommandLineArgs()[0];
}

dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");

}});

__CPAN_FILE__ src/json.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.json"], ["require", "dojo.lang.func"], ["require", "dojo.string.extras"], ["require", "dojo.AdapterRegistry"]], definePackage:function (dojo) {
	dojo.provide("dojo.json");
	dojo.require("dojo.lang.func");
	dojo.require("dojo.string.extras");
	dojo.require("dojo.AdapterRegistry");
	dojo.json = {jsonRegistry:new dojo.AdapterRegistry(), register:function (name, check, wrap, override) {
		dojo.json.jsonRegistry.register(name, check, wrap, override);
	}, evalJson:function (json) {
		try {
			return eval("(" + json + ")");
		}
		catch (e) {
			dojo.debug(e);
			return json;
		}
	}, serialize:function (o) {
		var objtype = typeof (o);
		if (objtype == "undefined") {
			return "undefined";
		} else {
			if ((objtype == "number") || (objtype == "boolean")) {
				return o + "";
			} else {
				if (o === null) {
					return "null";
				}
			}
		}
		if (objtype == "string") {
			return dojo.string.escapeString(o);
		}
		var me = arguments.callee;
		var newObj;
		if (typeof (o.__json__) == "function") {
			newObj = o.__json__();
			if (o !== newObj) {
				return me(newObj);
			}
		}
		if (typeof (o.json) == "function") {
			newObj = o.json();
			if (o !== newObj) {
				return me(newObj);
			}
		}
		if (objtype != "function" && typeof (o.length) == "number") {
			var res = [];
			for (var i = 0; i < o.length; i++) {
				var val = me(o[i]);
				if (typeof (val) != "string") {
					val = "undefined";
				}
				res.push(val);
			}
			return "[" + res.join(",") + "]";
		}
		try {
			window.o = o;
			newObj = dojo.json.jsonRegistry.match(o);
			return me(newObj);
		}
		catch (e) {
		}
		if (objtype == "function") {
			return null;
		}
		res = [];
		for (var k in o) {
			var useKey;
			if (typeof (k) == "number") {
				useKey = "\"" + k + "\"";
			} else {
				if (typeof (k) == "string") {
					useKey = dojo.string.escapeString(k);
				} else {
					continue;
				}
			}
			val = me(o[k]);
			if (typeof (val) != "string") {
				continue;
			}
			res.push(useKey + ":" + val);
		}
		return "{" + res.join(",") + "}";
	}};
}});


__CPAN_FILE__ src/docs.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

dojo.provide("dojo.docs");
dojo.require("dojo.io.*");
dojo.require("dojo.event.topic");
dojo.require("dojo.rpc.JotService");
dojo.require("dojo.dom");
dojo.require("dojo.uri.Uri");
dojo.require("dojo.Deferred");
dojo.require("dojo.DeferredList");

/*
 * TODO:
 *
 * Package summary needs to compensate for "is"
 * Handle host environments
 * Deal with dojo.widget weirdness
 * Parse parameters
 * Limit function parameters to only the valid ones (Involves packing parameters onto meta during rewriting)
 *
 */

dojo.docs = new function() {
	this._url = dojo.uri.dojoUri("docscripts");
	this._rpc = new dojo.rpc.JotService;
	this._rpc.serviceUrl = dojo.uri.dojoUri("docscripts/jsonrpc.php");
};
dojo.lang.mixin(dojo.docs, {
	_count: 0,
	_callbacks: {function_names: []},
	_cache: {}, // Saves the JSON objects in cache
	require: function(/*String*/ require, /*bool*/ sync) {
		dojo.debug("require(): " + require);
		var parts = require.split("/");
		
		var size = parts.length;
		var deferred = new dojo.Deferred;
		var args = {
			mimetype: "text/json",
			load: function(type, data){
				dojo.debug("require(): loaded for " + require);
				
				if(parts[0] != "function_names") {
					for(var i = 0, part; part = parts[i]; i++){
						data = data[part];
					}
				}
				deferred.callback(data);
			},
			error: function(){
				deferred.errback();
			}
		};

		if(location.protocol == "file:"){
			if(size){
				if(parts[parts.length - 1] == "documentation"){
					parts[parts.length - 1] = "meta";
				}
			
				if(parts[0] == "function_names"){
					args.url = [this._url, "local_json", "function_names"].join("/");
				}else{
					var dirs = parts[0].split(".");
					args.url = [this._url, "local_json", dirs[0]].join("/");
					if(dirs.length > 1){
						args.url = [args.url, dirs[1]].join(".");
					}
				}
			}
		}
		
		dojo.io.bind(args);
		return deferred;
	},
	getFunctionNames: function(){
		return this.require("function_names"); // dojo.Deferred
	},
	unFormat: function(/*String*/ string){
		var fString = string;
		if(string.charAt(string.length - 1) == "_"){
			fString = [string.substring(0, string.length - 1), "*"].join("");
		}
		return fString;
	},
	getMeta: function(/*String*/ pkg, /*String*/ name, /*Function*/ callback, /*String?*/ id){
		// summary: Gets information about a function in regards to its meta data
		if(typeof name == "function"){
			// pId: a
			// pkg: ignore
			id = callback;
			callback = name;
			name = pkg;
			pkg = null;
			dojo.debug("getMeta(" + name + ")");
		}else{
			dojo.debug("getMeta(" + pkg + "/" + name + ")");
		}
		
		if(!id){
			id = "_";
		}
	},
	_withPkg: function(/*String*/ type, /*Object*/ data, /*Object*/ evt, /*Object*/ input, /*String*/ newType){
		dojo.debug("_withPkg(" + evt.name + ") has package: " + data[0]);
		evt.pkg = data[0];
		if("load" == type && evt.pkg){
			evt.type = newType;
		}else{
			if(evt.callbacks && evt.callbacks.length){
				evt.callbacks.shift()("error", {}, evt, evt.input);
			}
		}
	},
	_gotMeta: function(/*String*/ type, /*Object*/ data, /*Object*/ evt){
		dojo.debug("_gotMeta(" + evt.name + ")");

		var cached = dojo.docs._getCache(evt.pkg, evt.name, "meta", "functions", evt.id);
		if(cached.summary){
			data.summary = cached.summary;
		}
		if(evt.callbacks && evt.callbacks.length){
			evt.callbacks.shift()(type, data, evt, evt.input);
		}
	},
	getSrc: function(/*String*/ name, /*Function*/ callback, /*String?*/ id){
		// summary: Gets src file (created by the doc parser)
		dojo.debug("getSrc(" + name + ")");
		if(!id){
			id = "_";
		}
	},
	getDoc: function(/*String*/ name, /*Function*/ callback, /*String?*/ id){
		// summary: Gets external documentation stored on Jot for a given function
		dojo.debug("getDoc(" + name  + ")");

		if(!id){
			id = "_";
		}

		var input = {};

		input.type = "doc";
		input.name = name;
		input.callbacks = [callback];
	},
	_gotDoc: function(/*String*/ type, /*Array*/ data, /*Object*/ evt, /*Object*/ input){
		dojo.debug("_gotDoc(" + evt.type + ")");
		
		evt[evt.type] = data;
		if(evt.expects && evt.expects.doc){
			for(var i = 0, expect; expect = evt.expects.doc[i]; i++){
				if(!(expect in evt)){
					dojo.debug("_gotDoc() waiting for more data");
					return;
				}
			}
		}
		
		var cache = dojo.docs._getCache(evt.pkg, "meta", "functions", evt.name, evt.id, "meta");

		var description = evt.fn.description;
		cache.description = description;
		data = {
			returns: evt.fn.returns,
			id: evt.id,
			variables: []
		}
		if(!cache.parameters){
			cache.parameters = {};
		}
		for(var i = 0, param; param = evt.param[i]; i++){
			var fName = param["DocParamForm/name"];
			if(!cache.parameters[fName]){
				cache.parameters[fName] = {};
			}
			cache.parameters[fName].description = param["DocParamForm/desc"]
		}

		data.description = cache.description;
		data.parameters = cache.parameters;
		
		evt.type = "doc";
	
		if(evt.callbacks && evt.callbacks.length){
			evt.callbacks.shift()("load", data, evt, input);
		}
	},
	getPkgDoc: function(/*String*/ name, /*Function*/ callback){
		// summary: Gets external documentation stored on Jot for a given package
		dojo.debug("getPkgDoc(" + name + ")");
		var input = {};
	},
	getPkgInfo: function(/*String*/ name, /*Function*/ callback){
		// summary: Gets a combination of the metadata and external documentation for a given package
		dojo.debug("getPkgInfo(" + name + ")");

		var input = {
			expects: {
				pkginfo: ["pkgmeta", "pkgdoc"]
			},
			callback: callback
		};
		dojo.docs.getPkgMeta(input, name, dojo.docs._getPkgInfo);
		dojo.docs.getPkgDoc(input, name, dojo.docs._getPkgInfo);
	},
	_getPkgInfo: function(/*String*/ type, /*Object*/ data, /*Object*/ evt){
		dojo.debug("_getPkgInfo() for " + evt.type);
		var input = {};
		var results = {};
		if(typeof key == "object"){
			input = key;
			input[evt.type] = data;
			if(input.expects && input.expects.pkginfo){
				for(var i = 0, expect; expect = input.expects.pkginfo[i]; i++){
					if(!(expect in input)){
						dojo.debug("_getPkgInfo() waiting for more data");
						return;
					}
				}
			}
			results = input.pkgmeta;
			results.description = input.pkgdoc;
		}

		if(input.callback){
			input.callback("load", results, evt);
		}
	},
	getInfo: function(/*String*/ name, /*Function*/ callback){
		dojo.debug("getInfo(" + name + ")");
		var input = {
			expects: {
				"info": ["meta", "doc"]
			},
			callback: callback
		}
		dojo.docs.getMeta(input, name, dojo.docs._getInfo);
		dojo.docs.getDoc(input, name, dojo.docs._getInfo);
	},
	_getInfo: function(/*String*/ type, /*String*/ data, /*Object*/ evt, /*Object*/ input){
		dojo.debug("_getInfo(" + evt.type + ")");
		if(input && input.expects && input.expects.info){
			input[evt.type] = data;
			for(var i = 0, expect; expect = input.expects.info[i]; i++){
				if(!(expect in input)){
					dojo.debug("_getInfo() waiting for more data");
					return;
				}
			}
		}

		if(input.callback){
			input.callback("load", dojo.docs._getCache(evt.pkg, "meta", "functions", evt.name, evt.id, "meta"), evt, input);
		}
	},
	_getMainText: function(/*String*/ text){
		// summary: Grabs the innerHTML from a Jot Rech Text node
		dojo.debug("_getMainText()");
		return text.replace(/^<html[^<]*>/, "").replace(/<\/html>$/, "").replace(/<\w+\s*\/>/g, "");
	},
	getPackageMeta: function(/*Object*/ input){
		dojo.debug("getPackageMeta(): " + input.package);
		return this.require(input.package + "/meta", input.sync);
	},
	getFunctionMeta: function(/*Object*/ input){
		var package = input.package || "";
		var name = input.name;
		var id = input.id || "_";
		dojo.debug("getFunctionMeta(): " + name);

		if(!name) return;

		if(package){
			return this.require(package + "/meta/functions/" + name + "/" + id + "/meta");
		}else{
			this.getFunctionNames();
		}
	},
	getFunctionDocumentation: function(/*Object*/ input){
		var package = input.package || "";
		var name = input.name;
		var id = input.id || "_";
		dojo.debug("getFunctionDocumentation(): " + name);
		
		if(!name) return;
		
		if(package){
			return this.require(package + "/meta/functions/" + name + "/" + id + "/documentation");
		}
	},
	_onDocSearch: function(/*Object*/ input){
		var _this = this;
		var name = input.name.toLowerCase();
		if(!name) return;

		this.getFunctionNames().addCallback(function(data){
			dojo.debug("_onDocSearch(): function names loaded for " + name);

			var output = [];
			var list = [];
			var closure = function(pkg, fn) {
				return function(data){
					dojo.debug("_onDocSearch(): package meta loaded for: " + pkg);
					if(data.functions){
						var functions = data.functions;
						for(var key in functions){
							if(fn == key){
								var ids = functions[key];
								for(var id in ids){
									var fnMeta = ids[id];
									output.push({
										package: pkg,
										name: fn,
										id: id,
										summary: fnMeta.summary
									});
								}
							}
						}
					}
					return output;
				}
			}

			pkgLoop:
			for(var pkg in data){
				if(pkg.toLowerCase() == name){
					name = pkg;
					dojo.debug("_onDocSearch found a package");
					//dojo.docs._onDocSelectPackage(input);
					return;
				}
				for(var i = 0, fn; fn = data[pkg][i]; i++){
					if(fn.toLowerCase().indexOf(name) != -1){
						dojo.debug("_onDocSearch(): Search matched " + fn);
						var meta = _this.getPackageMeta({package: pkg});
						meta.addCallback(closure(pkg, fn));
						list.push(meta);

						// Build a list of all packages that need to be loaded and their loaded state.
						continue pkgLoop;
					}
				}
			}
			
			list = new dojo.DeferredList(list);
			list.addCallback(function(results){
				dojo.debug("_onDocSearch(): All packages loaded");
				_this._printFunctionResults(results[0][1]);
			});
		});
	},
	_onDocSearchFn: function(/*String*/ type, /*Array*/ data, /*Object*/ evt){
		dojo.debug("_onDocSearchFn(" + evt.name + ")");

		var name = evt.name || evt.pkg;

		dojo.debug("_onDocSearchFn found a function");

		evt.pkgs = packages;
		evt.pkg = name;
		evt.loaded = 0;
		for(var i = 0, pkg; pkg = packages[i]; i++){
			dojo.docs.getPkgMeta(evt, pkg, dojo.docs._onDocResults);
		}
	},
	_onPkgResults: function(/*String*/ type, /*Object*/ data, /*Object*/ evt, /*Object*/ input){
		dojo.debug("_onPkgResults(" + evt.type + ")");
		var description = "";
		var path = "";
		var methods = {};
		var requires = {};
		if(input){
			input[evt.type] = data;
			if(input.expects && input.expects.pkgresults){
				for(var i = 0, expect; expect = input.expects.pkgresults[i]; i++){
					if(!(expect in input)){
						dojo.debug("_onPkgResults() waiting for more data");
						return;
					}
				}
			}
			path = input.pkgdoc.path;
			description = input.pkgdoc.description;
			methods = input.pkgmeta.methods;
			requires = input.pkgmeta.requires;
		}
		var pkg = evt.name.replace("_", "*");
		var results = {
			path: path,
			description: description,
			size: 0,
			methods: [],
			pkg: pkg,
			requires: requires
		}
		var rePrivate = /_[^.]+$/;
		for(var method in methods){
			if(!rePrivate.test(method)){
				for(var pId in methods[method]){
					results.methods.push({
						pkg: pkg,
						name: method,
						id: pId,
						summary: methods[method][pId].summary
					})
				}
			}
		}
		results.size = results.methods.length;
		dojo.docs._printPkgResult(results);
	},
	_onDocResults: function(/*String*/ type, /*Object*/ data, /*Object*/ evt, /*Object*/ input){
		dojo.debug("_onDocResults(" + evt.name + "/" + input.pkg + ") " + type);
		++input.loaded;

		if(input.loaded == input.pkgs.length){
			var pkgs = input.pkgs;
			var name = input.pkg;
			var results = {methods: []};
			var rePrivate = /_[^.]+$/;
			data = dojo.docs._cache;

			for(var i = 0, pkg; pkg = pkgs[i]; i++){
				var methods = dojo.docs._getCache(pkg, "meta", "methods");
				for(var fn in methods){
					if(fn.toLowerCase().indexOf(name) == -1){
						continue;
					}
					if(fn != "requires" && !rePrivate.test(fn)){
						for(var pId in methods[fn]){
							var result = {
								pkg: pkg,
								name: fn,
								id: "_",
								summary: ""
							}
							if(methods[fn][pId].summary){
								result.summary = methods[fn][pId].summary;
							}
							results.methods.push(result);
						}
					}
				}
			}

			dojo.debug("Publishing docResults");
			dojo.docs._printFnResults(results);
		}
	},
	_printFunctionResults: function(results){
		dojo.debug("_printFnResults(): called");
		// summary: Call this function to send the /docs/function/results topic
	},
	_printPkgResult: function(results){
		dojo.debug("_printPkgResult(): called");
	},
	_onDocSelectFunction: function(/*Object*/ input){
		// summary: Get doc, meta, and src
		var name = input.name;
		var package = input.package || "";
		var id = input.id || "_";
		dojo.debug("_onDocSelectFunction(" + name + ")");
		if(!name || !package) return false;

		var pkgMeta = this.getPackageMeta({package: package});
		var meta = this.getFunctionMeta({package: package, name: name, id: id});
		var doc = this.getFunctionDocumentation({package: package, name: name, id: id});
		
		var list = new dojo.DeferredList([pkgMeta, meta, doc]);
		list.addCallback(function(results){
			dojo.debug("_onDocSelectFunction() loaded");
			for(var i = 0, result; result = results[i]; i++){
				dojo.debugShallow(result[1]);
			}
		});
		
		return list;
	},
	_onDocSelectPackage: function(/*Object*/ input){
		dojo.debug("_onDocSelectPackage(" + input.name + ")")
		input.expects = {
			"pkgresults": ["pkgmeta", "pkgdoc"]
		};
		dojo.docs.getPkgMeta(input, input.name, dojo.docs._onPkgResults);
		dojo.docs.getPkgDoc(input, input.name, dojo.docs._onPkgResults);
	},
	_onDocSelectResults: function(/*String*/ type, /*Object*/ data, /*Object*/ evt, /*Object*/ input){
		dojo.debug("_onDocSelectResults(" + evt.type + ", " + evt.name + ")");
		if(evt.type == "meta"){
			dojo.docs.getPkgMeta(input, evt.pkg, dojo.docs._onDocSelectResults);
		}
		if(input){
			input[evt.type] = data;
			if(input.expects && input.expects.docresults){
				for(var i = 0, expect; expect = input.expects.docresults[i]; i++){
					if(!(expect in input)){
						dojo.debug("_onDocSelectResults() waiting for more data");
						return;
					}
				}
			}
		}

		dojo.docs._printFunctionDetail(input);
	},
	
	_printFunctionDetail: function(results) {
		// summary: Call this function to send the /docs/function/detail topic event
	},

	selectFunction: function(/*String*/ name, /*String?*/ id){
		// summary: The combined information
	},
	savePackage: function(/*Object*/ callbackObject, /*String*/ callback, /*Object*/ parameters){
		dojo.event.kwConnect({
			srcObj: dojo.docs,
			srcFunc: "_savedPkgRpc",
			targetObj: callbackObject,
			targetFunc: callback,
			once: true
		});
		
		var props = {};
		var cache = dojo.docs._getCache(parameters.pkg, "meta");

		var i = 1;

		if(!cache.path){
			var path = "id";
			props[["pname", i].join("")] = "DocPkgForm/require";
			props[["pvalue", i++].join("")] = parameters.pkg;
		}else{
			var path = cache.path;
		}

		props.form = "//DocPkgForm";
		props.path = ["/WikiHome/DojoDotDoc/", path].join("");

		if(parameters.description){
			props[["pname", i].join("")] = "main/text";
			props[["pvalue", i++].join("")] = parameters.description;
		}
		
		dojo.docs._rpc.callRemote("saveForm",	props).addCallbacks(dojo.docs._pkgRpc, dojo.docs._pkgRpc);
	},
	_pkgRpc: function(data){
		if(data.name){
			dojo.docs._getCache(data["DocPkgForm/require"], "meta").path = data.name;
			dojo.docs._savedPkgRpc("load");
		}else{
			dojo.docs._savedPkgRpc("error");
		}
	},
	_savedPkgRpc: function(type){
	},
	functionPackages: function(/*String*/ name, /*Function*/ callback, /*Object*/ input){
		// summary: Gets the package associated with a function and stores it in the .pkg value of input
		dojo.debug("functionPackages() name: " + name);

		if(!input){
			input = {};
		}
		if(!input.callbacks){
			input.callbacks = [];
		}

		input.type = "function_names";
		input.name = name;
		input.callbacks.unshift(callback);
		input.callbacks.unshift(dojo.docs._functionPackages);
	},
	_functionPackages: function(/*String*/ type, /*Array*/ data, /*Object*/ evt){
		dojo.debug("_functionPackages() name: " + evt.name);
		evt.pkg = '';

		var results = [];
		var data = dojo.docs._cache['function_names'];
		for(var key in data){
			if(dojo.lang.inArray(data[key], evt.name)){
				dojo.debug("_functionPackages() package: " + key);
				results.push(key);
			}
		}

		if(evt.callbacks && evt.callbacks.length){
			evt.callbacks.shift()(type, results, evt, evt.input);
		}
	},
	setUserName: function(/*String*/ name){
		dojo.docs._userName = name;
		if(name && dojo.docs._password){
			dojo.docs._logIn();
		}
	},
	setPassword: function(/*String*/ password){
		dojo.docs._password = password;
		if(password && dojo.docs._userName){
			dojo.docs._logIn();
		}
	},
	_logIn: function(){
		dojo.io.bind({
			url: dojo.docs._rpc.serviceUrl.toString(),
			method: "post",
			mimetype: "text/json",
			content: {
				username: dojo.docs._userName,
				password: dojo.docs._password
			},
			load: function(type, data){
				if(data.error){
					dojo.docs.logInSuccess();
				}else{
					dojo.docs.logInFailure();
				}
			},
			error: function(){
				dojo.docs.logInFailure();
			}
		});
	},
	logInSuccess: function(){},
	logInFailure: function(){},
	_set: function(/*Object*/ base, /*String...*/ keys, /*String*/ value){
		var args = [];
		for(var i = 0, arg; arg = arguments[i]; i++){
			args.push(arg);
		}

		if(args.length < 3) return;
		base = args.shift();
		value = args.pop();
		var key = args.pop();
		for(var i = 0, arg; arg = args[i]; i++){
			if(typeof base[arg] != "object"){
				base[arg] = {};
			}
			base = base[arg];
		}
		base[key] = value;
	},
	_getCache: function(/*String...*/ keys){
		var obj = dojo.docs._cache;
		for(var i = 0; i < arguments.length; i++){
			var arg = arguments[i];
			if(!obj[arg]){
				obj[arg] = {};
			}
			obj = obj[arg];
		}
		return obj;
	}
});

dojo.event.topic.subscribe("/docs/search", dojo.docs, "_onDocSearch");
dojo.event.topic.subscribe("/docs/function/select", dojo.docs, "_onDocSelectFunction");
dojo.event.topic.subscribe("/docs/package/select", dojo.docs, "_onDocSelectPackage");

dojo.event.topic.registerPublisher("/docs/function/results", dojo.docs, "_printFunctionResults");
dojo.event.topic.registerPublisher("/docs/function/detail", dojo.docs, "_printFunctionDetail");
dojo.event.topic.registerPublisher("/docs/package/detail", dojo.docs, "_printPkgResult");

__CPAN_FILE__ src/regexp.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.regexp");
dojo.evalObjPath("dojo.regexp.us", true);
dojo.regexp.tld = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.allowCC != "boolean") {
		flags.allowCC = true;
	}
	if (typeof flags.allowInfra != "boolean") {
		flags.allowInfra = true;
	}
	if (typeof flags.allowGeneric != "boolean") {
		flags.allowGeneric = true;
	}
	var infraRE = "arpa";
	var genericRE = "aero|biz|com|coop|edu|gov|info|int|mil|museum|name|net|org|pro|travel|xxx|jobs|mobi|post";
	var ccRE = "ac|ad|ae|af|ag|ai|al|am|an|ao|aq|ar|as|at|au|aw|az|ba|bb|bd|be|bf|bg|bh|bi|bj|bm|bn|bo|br|" + "bs|bt|bv|bw|by|bz|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|co|cr|cu|cv|cx|cy|cz|de|dj|dk|dm|do|dz|" + "ec|ee|eg|er|eu|es|et|fi|fj|fk|fm|fo|fr|ga|gd|ge|gf|gg|gh|gi|gl|gm|gn|gp|gq|gr|gs|gt|gu|gw|" + "gy|hk|hm|hn|hr|ht|hu|id|ie|il|im|in|io|ir|is|it|je|jm|jo|jp|ke|kg|kh|ki|km|kn|kr|kw|ky|kz|" + "la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|mg|mh|mk|ml|mm|mn|mo|mp|mq|mr|ms|mt|mu|mv|mw|mx|" + "my|mz|na|nc|ne|nf|ng|ni|nl|no|np|nr|nu|nz|om|pa|pe|pf|pg|ph|pk|pl|pm|pn|pr|ps|pt|pw|py|qa|" + "re|ro|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sk|sl|sm|sn|sr|st|su|sv|sy|sz|tc|td|tf|tg|th|tj|tk|tm|" + "tn|to|tr|tt|tv|tw|tz|ua|ug|uk|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|ye|yt|yu|za|zm|zw";
	var a = [];
	if (flags.allowInfra) {
		a.push(infraRE);
	}
	if (flags.allowGeneric) {
		a.push(genericRE);
	}
	if (flags.allowCC) {
		a.push(ccRE);
	}
	var tldRE = "";
	if (a.length > 0) {
		tldRE = "(" + a.join("|") + ")";
	}
	return tldRE;
};
dojo.regexp.ipAddress = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.allowDottedDecimal != "boolean") {
		flags.allowDottedDecimal = true;
	}
	if (typeof flags.allowDottedHex != "boolean") {
		flags.allowDottedHex = true;
	}
	if (typeof flags.allowDottedOctal != "boolean") {
		flags.allowDottedOctal = true;
	}
	if (typeof flags.allowDecimal != "boolean") {
		flags.allowDecimal = true;
	}
	if (typeof flags.allowHex != "boolean") {
		flags.allowHex = true;
	}
	if (typeof flags.allowIPv6 != "boolean") {
		flags.allowIPv6 = true;
	}
	if (typeof flags.allowHybrid != "boolean") {
		flags.allowHybrid = true;
	}
	var dottedDecimalRE = "((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])";
	var dottedHexRE = "(0[xX]0*[\\da-fA-F]?[\\da-fA-F]\\.){3}0[xX]0*[\\da-fA-F]?[\\da-fA-F]";
	var dottedOctalRE = "(0+[0-3][0-7][0-7]\\.){3}0+[0-3][0-7][0-7]";
	var decimalRE = "(0|[1-9]\\d{0,8}|[1-3]\\d{9}|4[01]\\d{8}|42[0-8]\\d{7}|429[0-3]\\d{6}|" + "4294[0-8]\\d{5}|42949[0-5]\\d{4}|429496[0-6]\\d{3}|4294967[01]\\d{2}|42949672[0-8]\\d|429496729[0-5])";
	var hexRE = "0[xX]0*[\\da-fA-F]{1,8}";
	var ipv6RE = "([\\da-fA-F]{1,4}\\:){7}[\\da-fA-F]{1,4}";
	var hybridRE = "([\\da-fA-F]{1,4}\\:){6}" + "((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])";
	var a = [];
	if (flags.allowDottedDecimal) {
		a.push(dottedDecimalRE);
	}
	if (flags.allowDottedHex) {
		a.push(dottedHexRE);
	}
	if (flags.allowDottedOctal) {
		a.push(dottedOctalRE);
	}
	if (flags.allowDecimal) {
		a.push(decimalRE);
	}
	if (flags.allowHex) {
		a.push(hexRE);
	}
	if (flags.allowIPv6) {
		a.push(ipv6RE);
	}
	if (flags.allowHybrid) {
		a.push(hybridRE);
	}
	var ipAddressRE = "";
	if (a.length > 0) {
		ipAddressRE = "(" + a.join("|") + ")";
	}
	return ipAddressRE;
};
dojo.regexp.host = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.allowIP != "boolean") {
		flags.allowIP = true;
	}
	if (typeof flags.allowLocal != "boolean") {
		flags.allowLocal = false;
	}
	if (typeof flags.allowPort != "boolean") {
		flags.allowPort = true;
	}
	var domainNameRE = "([0-9a-zA-Z]([-0-9a-zA-Z]{0,61}[0-9a-zA-Z])?\\.)+" + dojo.regexp.tld(flags);
	var portRE = (flags.allowPort) ? "(\\:" + dojo.regexp.integer({signed:false}) + ")?" : "";
	var hostNameRE = domainNameRE;
	if (flags.allowIP) {
		hostNameRE += "|" + dojo.regexp.ipAddress(flags);
	}
	if (flags.allowLocal) {
		hostNameRE += "|localhost";
	}
	return "(" + hostNameRE + ")" + portRE;
};
dojo.regexp.url = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.scheme == "undefined") {
		flags.scheme = [true, false];
	}
	var protocolRE = dojo.regexp.buildGroupRE(flags.scheme, function (q) {
		if (q) {
			return "(https?|ftps?)\\://";
		}
		return "";
	});
	var pathRE = "(/([^?#\\s/]+/)*)?([^?#\\s/]+(\\?[^?#\\s/]*)?(#[A-Za-z][\\w.:-]*)?)?";
	return protocolRE + dojo.regexp.host(flags) + pathRE;
};
dojo.regexp.emailAddress = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.allowCruft != "boolean") {
		flags.allowCruft = false;
	}
	flags.allowPort = false;
	var usernameRE = "([\\da-z]+[-._+&'])*[\\da-z]+";
	var emailAddressRE = usernameRE + "@" + dojo.regexp.host(flags);
	if (flags.allowCruft) {
		emailAddressRE = "<?(mailto\\:)?" + emailAddressRE + ">?";
	}
	return emailAddressRE;
};
dojo.regexp.emailAddressList = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.listSeparator != "string") {
		flags.listSeparator = "\\s;,";
	}
	var emailAddressRE = dojo.regexp.emailAddress(flags);
	var emailAddressListRE = "(" + emailAddressRE + "\\s*[" + flags.listSeparator + "]\\s*)*" + emailAddressRE + "\\s*[" + flags.listSeparator + "]?\\s*";
	return emailAddressListRE;
};
dojo.regexp.integer = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.signed == "undefined") {
		flags.signed = [true, false];
	}
	if (typeof flags.separator == "undefined") {
		flags.separator = "";
	} else {
		if (typeof flags.groupSize == "undefined") {
			flags.groupSize = 3;
		}
	}
	var signRE = dojo.regexp.buildGroupRE(flags.signed, function (q) {
		return q ? "[-+]" : "";
	});
	var numberRE = dojo.regexp.buildGroupRE(flags.separator, function (sep) {
		if (sep == "") {
			return "(0|[1-9]\\d*)";
		}
		var grp = flags.groupSize, grp2 = flags.groupSize2;
		if (typeof grp2 != "undefined") {
			var grp2RE = "(0|[1-9]\\d{0," + (grp2 - 1) + "}([" + sep + "]\\d{" + grp2 + "})*[" + sep + "]\\d{" + grp + "})";
			return ((grp - grp2) > 0) ? "(" + grp2RE + "|(0|[1-9]\\d{0," + (grp - 1) + "}))" : grp2RE;
		}
		return "(0|[1-9]\\d{0," + (grp - 1) + "}([" + sep + "]\\d{" + grp + "})*)";
	});
	return signRE + numberRE;
};
dojo.regexp.realNumber = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.places != "number") {
		flags.places = Infinity;
	}
	if (typeof flags.decimal != "string") {
		flags.decimal = ".";
	}
	if (typeof flags.fractional == "undefined") {
		flags.fractional = [true, false];
	}
	if (typeof flags.exponent == "undefined") {
		flags.exponent = [true, false];
	}
	if (typeof flags.eSigned == "undefined") {
		flags.eSigned = [true, false];
	}
	var integerRE = dojo.regexp.integer(flags);
	var decimalRE = dojo.regexp.buildGroupRE(flags.fractional, function (q) {
		var re = "";
		if (q && (flags.places > 0)) {
			re = "\\" + flags.decimal;
			if (flags.places == Infinity) {
				re = "(" + re + "\\d+)?";
			} else {
				re = re + "\\d{" + flags.places + "}";
			}
		}
		return re;
	});
	var exponentRE = dojo.regexp.buildGroupRE(flags.exponent, function (q) {
		if (q) {
			return "([eE]" + dojo.regexp.integer({signed:flags.eSigned}) + ")";
		}
		return "";
	});
	return integerRE + decimalRE + exponentRE;
};
dojo.regexp.currency = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.signed == "undefined") {
		flags.signed = [true, false];
	}
	if (typeof flags.symbol == "undefined") {
		flags.symbol = "$";
	}
	if (typeof flags.placement != "string") {
		flags.placement = "before";
	}
	if (typeof flags.signPlacement != "string") {
		flags.signPlacement = "before";
	}
	if (typeof flags.separator == "undefined") {
		flags.separator = ",";
	}
	if (typeof flags.fractional == "undefined" && typeof flags.cents != "undefined") {
		dojo.deprecated("dojo.regexp.currency: flags.cents", "use flags.fractional instead", "0.5");
		flags.fractional = flags.cents;
	}
	if (typeof flags.decimal != "string") {
		flags.decimal = ".";
	}
	var signRE = dojo.regexp.buildGroupRE(flags.signed, function (q) {
		if (q) {
			return "[-+]";
		}
		return "";
	});
	var symbolRE = dojo.regexp.buildGroupRE(flags.symbol, function (symbol) {
		return "\\s?" + symbol.replace(/([.$?*!=:|\\\/^])/g, "\\$1") + "\\s?";
	});
	switch (flags.signPlacement) {
	  case "before":
		symbolRE = signRE + symbolRE;
		break;
	  case "after":
		symbolRE = symbolRE + signRE;
		break;
	}
	var flagsCopy = flags;
	flagsCopy.signed = false;
	flagsCopy.exponent = false;
	var numberRE = dojo.regexp.realNumber(flagsCopy);
	var currencyRE;
	switch (flags.placement) {
	  case "before":
		currencyRE = symbolRE + numberRE;
		break;
	  case "after":
		currencyRE = numberRE + symbolRE;
		break;
	}
	switch (flags.signPlacement) {
	  case "around":
		currencyRE = "(" + currencyRE + "|" + "\\(" + currencyRE + "\\)" + ")";
		break;
	  case "begin":
		currencyRE = signRE + currencyRE;
		break;
	  case "end":
		currencyRE = currencyRE + signRE;
		break;
	}
	return currencyRE;
};
dojo.regexp.us.state = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.allowTerritories != "boolean") {
		flags.allowTerritories = true;
	}
	if (typeof flags.allowMilitary != "boolean") {
		flags.allowMilitary = true;
	}
	var statesRE = "AL|AK|AZ|AR|CA|CO|CT|DE|DC|FL|GA|HI|ID|IL|IN|IA|KS|KY|LA|ME|MD|MA|MI|MN|MS|MO|MT|" + "NE|NV|NH|NJ|NM|NY|NC|ND|OH|OK|OR|PA|RI|SC|SD|TN|TX|UT|VT|VA|WA|WV|WI|WY";
	var territoriesRE = "AS|FM|GU|MH|MP|PW|PR|VI";
	var militaryRE = "AA|AE|AP";
	if (flags.allowTerritories) {
		statesRE += "|" + territoriesRE;
	}
	if (flags.allowMilitary) {
		statesRE += "|" + militaryRE;
	}
	return "(" + statesRE + ")";
};
dojo.regexp.time = function (flags) {
	dojo.deprecated("dojo.regexp.time", "Use dojo.date.parse instead", "0.5");
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.format == "undefined") {
		flags.format = "h:mm:ss t";
	}
	if (typeof flags.amSymbol != "string") {
		flags.amSymbol = "AM";
	}
	if (typeof flags.pmSymbol != "string") {
		flags.pmSymbol = "PM";
	}
	var timeRE = function (format) {
		format = format.replace(/([.$?*!=:|{}\(\)\[\]\\\/^])/g, "\\$1");
		var amRE = flags.amSymbol.replace(/([.$?*!=:|{}\(\)\[\]\\\/^])/g, "\\$1");
		var pmRE = flags.pmSymbol.replace(/([.$?*!=:|{}\(\)\[\]\\\/^])/g, "\\$1");
		format = format.replace("hh", "(0[1-9]|1[0-2])");
		format = format.replace("h", "([1-9]|1[0-2])");
		format = format.replace("HH", "([01][0-9]|2[0-3])");
		format = format.replace("H", "([0-9]|1[0-9]|2[0-3])");
		format = format.replace("mm", "([0-5][0-9])");
		format = format.replace("m", "([1-5][0-9]|[0-9])");
		format = format.replace("ss", "([0-5][0-9])");
		format = format.replace("s", "([1-5][0-9]|[0-9])");
		format = format.replace("t", "\\s?(" + amRE + "|" + pmRE + ")\\s?");
		return format;
	};
	return dojo.regexp.buildGroupRE(flags.format, timeRE);
};
dojo.regexp.numberFormat = function (flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (typeof flags.format == "undefined") {
		flags.format = "###-###-####";
	}
	var digitRE = function (format) {
		format = format.replace(/([.$*!=:|{}\(\)\[\]\\\/^])/g, "\\$1");
		format = format.replace(/\?/g, "\\d?");
		format = format.replace(/#/g, "\\d");
		return format;
	};
	return dojo.regexp.buildGroupRE(flags.format, digitRE);
};
dojo.regexp.buildGroupRE = function (a, re) {
	if (!(a instanceof Array)) {
		return re(a);
	}
	var b = [];
	for (var i = 0; i < a.length; i++) {
		b.push(re(a[i]));
	}
	return "(" + b.join("|") + ")";
};


__CPAN_FILE__ src/hostenv_rhino.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.println = function (line) {
	if (arguments.length > 0) {
		print(arguments[0]);
		for (var i = 1; i < arguments.length; i++) {
			var valid = false;
			for (var p in arguments[i]) {
				valid = true;
				break;
			}
			if (valid) {
				dojo.debugShallow(arguments[i]);
			}
		}
	} else {
		print(line);
	}
};
dojo.locale = dojo.locale || java.util.Locale.getDefault().toString().replace("_", "-").toLowerCase();
dojo.render.name = dojo.hostenv.name_ = "rhino";
dojo.hostenv.getVersion = function () {
	return version();
};
if (dj_undef("byId")) {
	dojo.byId = function (id, doc) {
		if (id && (typeof id == "string" || id instanceof String)) {
			if (!doc) {
				doc = document;
			}
			return doc.getElementById(id);
		}
		return id;
	};
}
dojo.hostenv.loadUri = function (uri, cb) {
	try {
		var local = (new java.io.File(uri)).exists();
		if (!local) {
			try {
				var stream = (new java.net.URL(uri)).openStream();
				stream.close();
			}
			catch (e) {
				return false;
			}
		}
		if (cb) {
			var contents = (local ? readText : readUri)(uri, "UTF-8");
			cb(eval("(" + contents + ")"));
		} else {
			load(uri);
		}
		return true;
	}
	catch (e) {
		dojo.debug("rhino load('" + uri + "') failed. Exception: " + e);
		return false;
	}
};
dojo.hostenv.exit = function (exitcode) {
	quit(exitcode);
};
function dj_rhino_current_script_via_java(depth) {
	var optLevel = Packages.org.mozilla.javascript.Context.getCurrentContext().getOptimizationLevel();
	var caw = new java.io.CharArrayWriter();
	var pw = new java.io.PrintWriter(caw);
	var exc = new java.lang.Exception();
	var s = caw.toString();
	var matches = s.match(/[^\(]*\.js\)/gi);
	if (!matches) {
		throw Error("cannot parse printStackTrace output: " + s);
	}
	var fname = ((typeof depth != "undefined") && (depth)) ? matches[depth + 1] : matches[matches.length - 1];
	var fname = matches[3];
	if (!fname) {
		fname = matches[1];
	}
	if (!fname) {
		throw Error("could not find js file in printStackTrace output: " + s);
	}
	return fname;
}
function readText(path, encoding) {
	encoding = encoding || "utf-8";
	var jf = new java.io.File(path);
	var is = new java.io.FileInputStream(jf);
	return dj_readInputStream(is, encoding);
}
function readUri(uri, encoding) {
	var conn = (new java.net.URL(uri)).openConnection();
	encoding = encoding || conn.getContentEncoding() || "utf-8";
	var is = conn.getInputStream();
	return dj_readInputStream(is, encoding);
}
function dj_readInputStream(is, encoding) {
	var input = new java.io.BufferedReader(new java.io.InputStreamReader(is, encoding));
	try {
		var sb = new java.lang.StringBuffer();
		var line = "";
		while ((line = input.readLine()) !== null) {
			sb.append(line);
			sb.append(java.lang.System.getProperty("line.separator"));
		}
		return sb.toString();
	}
	finally {
		input.close();
	}
}
if (!djConfig.libraryScriptUri.length) {
	try {
		djConfig.libraryScriptUri = dj_rhino_current_script_via_java(1);
	}
	catch (e) {
		if (djConfig["isDebug"]) {
			print("\n");
			print("we have no idea where Dojo is located.");
			print("Please try loading rhino in a non-interpreted mode or set a");
			print("\n\tdjConfig.libraryScriptUri\n");
			print("Setting the dojo path to './'");
			print("This is probably wrong!");
			print("\n");
			print("Dojo will try to load anyway");
		}
		djConfig.libraryScriptUri = "./";
	}
}
dojo.doc = function () {
	return document;
};
dojo.body = function () {
	return document.body;
};
function setTimeout(func, delay) {
	var def = {sleepTime:delay, hasSlept:false, run:function () {
		if (!this.hasSlept) {
			this.hasSlept = true;
			java.lang.Thread.currentThread().sleep(this.sleepTime);
		}
		try {
			func();
		}
		catch (e) {
			dojo.debug("Error running setTimeout thread:" + e);
		}
	}};
	var runnable = new java.lang.Runnable(def);
	var thread = new java.lang.Thread(runnable);
	thread.start();
}
dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");


__CPAN_FILE__ src/string.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.string"], ["require", "dojo.string.common"]], definePackage:function (dojo) {
	dojo.provide("dojo.string");
	dojo.require("dojo.string.common");
}});


__CPAN_FILE__ src/crypto.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.crypto"]], definePackage:function (dojo) {
	dojo.provide("dojo.crypto");
	dojo.crypto.cipherModes = {ECB:0, CBC:1, PCBC:2, CFB:3, OFB:4, CTR:5};
	dojo.crypto.outputTypes = {Base64:0, Hex:1, String:2, Raw:3};
}});


__CPAN_FILE__ src/lang.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.lang");
dojo.require("dojo.lang.common");
dojo.deprecated("dojo.lang", "replaced by dojo.lang.common", "0.5");


__CPAN_FILE__ src/bootstrap1.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



var dj_global = this;
var dj_currentContext = this;
function dj_undef(name, object) {
	return (typeof (object || dj_currentContext)[name] == "undefined");
}
if (dj_undef("djConfig", this)) {
	var djConfig = {};
}
if (dj_undef("dojo", this)) {
	var dojo = {};
}
dojo.global = function () {
	return dj_currentContext;
};
dojo.locale = djConfig.locale;
dojo.version = {major:0, minor:4, patch:3, flag:"", revision:Number("$Rev: 8617 $".match(/[0-9]+/)[0]), toString:function () {
	with (dojo.version) {
		return major + "." + minor + "." + patch + flag + " (" + revision + ")";
	}
}};
dojo.evalProp = function (name, object, create) {
	if ((!object) || (!name)) {
		return undefined;
	}
	if (!dj_undef(name, object)) {
		return object[name];
	}
	return (create ? (object[name] = {}) : undefined);
};
dojo.parseObjPath = function (path, context, create) {
	var object = (context || dojo.global());
	var names = path.split(".");
	var prop = names.pop();
	for (var i = 0, l = names.length; i < l && object; i++) {
		object = dojo.evalProp(names[i], object, create);
	}
	return {obj:object, prop:prop};
};
dojo.evalObjPath = function (path, create) {
	if (typeof path != "string") {
		return dojo.global();
	}
	if (path.indexOf(".") == -1) {
		return dojo.evalProp(path, dojo.global(), create);
	}
	var ref = dojo.parseObjPath(path, dojo.global(), create);
	if (ref) {
		return dojo.evalProp(ref.prop, ref.obj, create);
	}
	return null;
};
dojo.errorToString = function (exception) {
	if (!dj_undef("message", exception)) {
		return exception.message;
	} else {
		if (!dj_undef("description", exception)) {
			return exception.description;
		} else {
			return exception;
		}
	}
};
dojo.raise = function (message, exception) {
	if (exception) {
		message = message + ": " + dojo.errorToString(exception);
	} else {
		message = dojo.errorToString(message);
	}
	try {
		if (djConfig.isDebug) {
			dojo.hostenv.println("FATAL exception raised: " + message);
		}
	}
	catch (e) {
	}
	throw exception || Error(message);
};
dojo.debug = function () {
};
dojo.debugShallow = function (obj) {
};
dojo.profile = {start:function () {
}, end:function () {
}, stop:function () {
}, dump:function () {
}};
function dj_eval(scriptFragment) {
	return dj_global.eval ? dj_global.eval(scriptFragment) : eval(scriptFragment);
}
dojo.unimplemented = function (funcname, extra) {
	var message = "'" + funcname + "' not implemented";
	if (extra != null) {
		message += " " + extra;
	}
	dojo.raise(message);
};
dojo.deprecated = function (behaviour, extra, removal) {
	var message = "DEPRECATED: " + behaviour;
	if (extra) {
		message += " " + extra;
	}
	if (removal) {
		message += " -- will be removed in version: " + removal;
	}
	dojo.debug(message);
};
dojo.render = (function () {
	function vscaffold(prefs, names) {
		var tmp = {capable:false, support:{builtin:false, plugin:false}, prefixes:prefs};
		for (var i = 0; i < names.length; i++) {
			tmp[names[i]] = false;
		}
		return tmp;
	}
	return {name:"", ver:dojo.version, os:{win:false, linux:false, osx:false}, html:vscaffold(["html"], ["ie", "opera", "khtml", "safari", "moz"]), svg:vscaffold(["svg"], ["corel", "adobe", "batik"]), vml:vscaffold(["vml"], ["ie"]), swf:vscaffold(["Swf", "Flash", "Mm"], ["mm"]), swt:vscaffold(["Swt"], ["ibm"])};
})();
dojo.hostenv = (function () {
	var config = {isDebug:false, allowQueryConfig:false, baseScriptUri:"", baseRelativePath:"", libraryScriptUri:"", iePreventClobber:false, ieClobberMinimal:true, preventBackButtonFix:true, delayMozLoadingFix:false, searchIds:[], parseWidgets:true};
	if (typeof djConfig == "undefined") {
		djConfig = config;
	} else {
		for (var option in config) {
			if (typeof djConfig[option] == "undefined") {
				djConfig[option] = config[option];
			}
		}
	}
	return {name_:"(unset)", version_:"(unset)", getName:function () {
		return this.name_;
	}, getVersion:function () {
		return this.version_;
	}, getText:function (uri) {
		dojo.unimplemented("getText", "uri=" + uri);
	}};
})();
dojo.hostenv.getBaseScriptUri = function () {
	if (djConfig.baseScriptUri.length) {
		return djConfig.baseScriptUri;
	}
	var uri = new String(djConfig.libraryScriptUri || djConfig.baseRelativePath);
	if (!uri) {
		dojo.raise("Nothing returned by getLibraryScriptUri(): " + uri);
	}
	var lastslash = uri.lastIndexOf("/");
	djConfig.baseScriptUri = djConfig.baseRelativePath;
	return djConfig.baseScriptUri;
};


__CPAN_FILE__ src/dom.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.dom"]], definePackage:function (dojo) {
	dojo.provide("dojo.dom");
	dojo.dom.ELEMENT_NODE = 1;
	dojo.dom.ATTRIBUTE_NODE = 2;
	dojo.dom.TEXT_NODE = 3;
	dojo.dom.CDATA_SECTION_NODE = 4;
	dojo.dom.ENTITY_REFERENCE_NODE = 5;
	dojo.dom.ENTITY_NODE = 6;
	dojo.dom.PROCESSING_INSTRUCTION_NODE = 7;
	dojo.dom.COMMENT_NODE = 8;
	dojo.dom.DOCUMENT_NODE = 9;
	dojo.dom.DOCUMENT_TYPE_NODE = 10;
	dojo.dom.DOCUMENT_FRAGMENT_NODE = 11;
	dojo.dom.NOTATION_NODE = 12;
	dojo.dom.dojoml = "http://www.dojotoolkit.org/2004/dojoml";
	dojo.dom.xmlns = {svg:"http://www.w3.org/2000/svg", smil:"http://www.w3.org/2001/SMIL20/", mml:"http://www.w3.org/1998/Math/MathML", cml:"http://www.xml-cml.org", xlink:"http://www.w3.org/1999/xlink", xhtml:"http://www.w3.org/1999/xhtml", xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", xbl:"http://www.mozilla.org/xbl", fo:"http://www.w3.org/1999/XSL/Format", xsl:"http://www.w3.org/1999/XSL/Transform", xslt:"http://www.w3.org/1999/XSL/Transform", xi:"http://www.w3.org/2001/XInclude", xforms:"http://www.w3.org/2002/01/xforms", saxon:"http://icl.com/saxon", xalan:"http://xml.apache.org/xslt", xsd:"http://www.w3.org/2001/XMLSchema", dt:"http://www.w3.org/2001/XMLSchema-datatypes", xsi:"http://www.w3.org/2001/XMLSchema-instance", rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#", rdfs:"http://www.w3.org/2000/01/rdf-schema#", dc:"http://purl.org/dc/elements/1.1/", dcq:"http://purl.org/dc/qualifiers/1.0", "soap-env":"http://schemas.xmlsoap.org/soap/envelope/", wsdl:"http://schemas.xmlsoap.org/wsdl/", AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
	dojo.dom.isNode = function (wh) {
		if (typeof Element == "function") {
			try {
				return wh instanceof Element;
			}
			catch (e) {
			}
		} else {
			return wh && !isNaN(wh.nodeType);
		}
	};
	dojo.dom.getUniqueId = function () {
		var _document = dojo.doc();
		do {
			var id = "dj_unique_" + (++arguments.callee._idIncrement);
		} while (_document.getElementById(id));
		return id;
	};
	dojo.dom.getUniqueId._idIncrement = 0;
	dojo.dom.firstElement = dojo.dom.getFirstChildElement = function (parentNode, tagName) {
		var node = parentNode.firstChild;
		while (node && node.nodeType != dojo.dom.ELEMENT_NODE) {
			node = node.nextSibling;
		}
		if (tagName && node && node.tagName && node.tagName.toLowerCase() != tagName.toLowerCase()) {
			node = dojo.dom.nextElement(node, tagName);
		}
		return node;
	};
	dojo.dom.lastElement = dojo.dom.getLastChildElement = function (parentNode, tagName) {
		var node = parentNode.lastChild;
		while (node && node.nodeType != dojo.dom.ELEMENT_NODE) {
			node = node.previousSibling;
		}
		if (tagName && node && node.tagName && node.tagName.toLowerCase() != tagName.toLowerCase()) {
			node = dojo.dom.prevElement(node, tagName);
		}
		return node;
	};
	dojo.dom.nextElement = dojo.dom.getNextSiblingElement = function (node, tagName) {
		if (!node) {
			return null;
		}
		do {
			node = node.nextSibling;
		} while (node && node.nodeType != dojo.dom.ELEMENT_NODE);
		if (node && tagName && tagName.toLowerCase() != node.tagName.toLowerCase()) {
			return dojo.dom.nextElement(node, tagName);
		}
		return node;
	};
	dojo.dom.prevElement = dojo.dom.getPreviousSiblingElement = function (node, tagName) {
		if (!node) {
			return null;
		}
		if (tagName) {
			tagName = tagName.toLowerCase();
		}
		do {
			node = node.previousSibling;
		} while (node && node.nodeType != dojo.dom.ELEMENT_NODE);
		if (node && tagName && tagName.toLowerCase() != node.tagName.toLowerCase()) {
			return dojo.dom.prevElement(node, tagName);
		}
		return node;
	};
	dojo.dom.moveChildren = function (srcNode, destNode, trim) {
		var count = 0;
		if (trim) {
			while (srcNode.hasChildNodes() && srcNode.firstChild.nodeType == dojo.dom.TEXT_NODE) {
				srcNode.removeChild(srcNode.firstChild);
			}
			while (srcNode.hasChildNodes() && srcNode.lastChild.nodeType == dojo.dom.TEXT_NODE) {
				srcNode.removeChild(srcNode.lastChild);
			}
		}
		while (srcNode.hasChildNodes()) {
			destNode.appendChild(srcNode.firstChild);
			count++;
		}
		return count;
	};
	dojo.dom.copyChildren = function (srcNode, destNode, trim) {
		var clonedNode = srcNode.cloneNode(true);
		return this.moveChildren(clonedNode, destNode, trim);
	};
	dojo.dom.replaceChildren = function (node, newChild) {
		var nodes = [];
		if (dojo.render.html.ie) {
			for (var i = 0; i < node.childNodes.length; i++) {
				nodes.push(node.childNodes[i]);
			}
		}
		dojo.dom.removeChildren(node);
		node.appendChild(newChild);
		for (var i = 0; i < nodes.length; i++) {
			dojo.dom.destroyNode(nodes[i]);
		}
	};
	dojo.dom.removeChildren = function (node) {
		var count = node.childNodes.length;
		while (node.hasChildNodes()) {
			dojo.dom.removeNode(node.firstChild);
		}
		return count;
	};
	dojo.dom.replaceNode = function (node, newNode) {
		return node.parentNode.replaceChild(newNode, node);
	};
	dojo.dom.destroyNode = function (node) {
		if (node.parentNode) {
			node = dojo.dom.removeNode(node);
		}
		if (node.nodeType != 3) {
			if (dojo.evalObjPath("dojo.event.browser.clean", false)) {
				dojo.event.browser.clean(node);
			}
			if (dojo.render.html.ie) {
				node.outerHTML = "";
			}
		}
	};
	dojo.dom.removeNode = function (node) {
		if (node && node.parentNode) {
			return node.parentNode.removeChild(node);
		}
	};
	dojo.dom.getAncestors = function (node, filterFunction, returnFirstHit) {
		var ancestors = [];
		var isFunction = (filterFunction && (filterFunction instanceof Function || typeof filterFunction == "function"));
		while (node) {
			if (!isFunction || filterFunction(node)) {
				ancestors.push(node);
			}
			if (returnFirstHit && ancestors.length > 0) {
				return ancestors[0];
			}
			node = node.parentNode;
		}
		if (returnFirstHit) {
			return null;
		}
		return ancestors;
	};
	dojo.dom.getAncestorsByTag = function (node, tag, returnFirstHit) {
		tag = tag.toLowerCase();
		return dojo.dom.getAncestors(node, function (el) {
			return ((el.tagName) && (el.tagName.toLowerCase() == tag));
		}, returnFirstHit);
	};
	dojo.dom.getFirstAncestorByTag = function (node, tag) {
		return dojo.dom.getAncestorsByTag(node, tag, true);
	};
	dojo.dom.isDescendantOf = function (node, ancestor, guaranteeDescendant) {
		if (guaranteeDescendant && node) {
			node = node.parentNode;
		}
		while (node) {
			if (node == ancestor) {
				return true;
			}
			node = node.parentNode;
		}
		return false;
	};
	dojo.dom.innerXML = function (node) {
		if (node.innerXML) {
			return node.innerXML;
		} else {
			if (node.xml) {
				return node.xml;
			} else {
				if (typeof XMLSerializer != "undefined") {
					return (new XMLSerializer()).serializeToString(node);
				}
			}
		}
	};
	dojo.dom.createDocument = function () {
		var doc = null;
		var _document = dojo.doc();
		if (!dj_undef("ActiveXObject")) {
			var prefixes = ["MSXML2", "Microsoft", "MSXML", "MSXML3"];
			for (var i = 0; i < prefixes.length; i++) {
				try {
					doc = new ActiveXObject(prefixes[i] + ".XMLDOM");
				}
				catch (e) {
				}
				if (doc) {
					break;
				}
			}
		} else {
			if ((_document.implementation) && (_document.implementation.createDocument)) {
				doc = _document.implementation.createDocument("", "", null);
			}
		}
		return doc;
	};
	dojo.dom.createDocumentFromText = function (str, mimetype) {
		if (!mimetype) {
			mimetype = "text/xml";
		}
		if (!dj_undef("DOMParser")) {
			var parser = new DOMParser();
			return parser.parseFromString(str, mimetype);
		} else {
			if (!dj_undef("ActiveXObject")) {
				var domDoc = dojo.dom.createDocument();
				if (domDoc) {
					domDoc.async = false;
					domDoc.loadXML(str);
					return domDoc;
				} else {
					dojo.debug("toXml didn't work?");
				}
			} else {
				var _document = dojo.doc();
				if (_document.createElement) {
					var tmp = _document.createElement("xml");
					tmp.innerHTML = str;
					if (_document.implementation && _document.implementation.createDocument) {
						var xmlDoc = _document.implementation.createDocument("foo", "", null);
						for (var i = 0; i < tmp.childNodes.length; i++) {
							xmlDoc.importNode(tmp.childNodes.item(i), true);
						}
						return xmlDoc;
					}
					return ((tmp.document) && (tmp.document.firstChild ? tmp.document.firstChild : tmp));
				}
			}
		}
		return null;
	};
	dojo.dom.prependChild = function (node, parent) {
		if (parent.firstChild) {
			parent.insertBefore(node, parent.firstChild);
		} else {
			parent.appendChild(node);
		}
		return true;
	};
	dojo.dom.insertBefore = function (node, ref, force) {
		if ((force != true) && (node === ref || node.nextSibling === ref)) {
			return false;
		}
		var parent = ref.parentNode;
		parent.insertBefore(node, ref);
		return true;
	};
	dojo.dom.insertAfter = function (node, ref, force) {
		var pn = ref.parentNode;
		if (ref == pn.lastChild) {
			if ((force != true) && (node === ref)) {
				return false;
			}
			pn.appendChild(node);
		} else {
			return this.insertBefore(node, ref.nextSibling, force);
		}
		return true;
	};
	dojo.dom.insertAtPosition = function (node, ref, position) {
		if ((!node) || (!ref) || (!position)) {
			return false;
		}
		switch (position.toLowerCase()) {
		  case "before":
			return dojo.dom.insertBefore(node, ref);
		  case "after":
			return dojo.dom.insertAfter(node, ref);
		  case "first":
			if (ref.firstChild) {
				return dojo.dom.insertBefore(node, ref.firstChild);
			} else {
				ref.appendChild(node);
				return true;
			}
			break;
		  default:
			ref.appendChild(node);
			return true;
		}
	};
	dojo.dom.insertAtIndex = function (node, containingNode, insertionIndex) {
		var siblingNodes = containingNode.childNodes;
		if (!siblingNodes.length || siblingNodes.length == insertionIndex) {
			containingNode.appendChild(node);
			return true;
		}
		if (insertionIndex == 0) {
			return dojo.dom.prependChild(node, containingNode);
		}
		return dojo.dom.insertAfter(node, siblingNodes[insertionIndex - 1]);
	};
	dojo.dom.textContent = function (node, text) {
		if (arguments.length > 1) {
			var _document = dojo.doc();
			dojo.dom.replaceChildren(node, _document.createTextNode(text));
			return text;
		} else {
			if (node.textContent != undefined) {
				return node.textContent;
			}
			var _result = "";
			if (node == null) {
				return _result;
			}
			for (var i = 0; i < node.childNodes.length; i++) {
				switch (node.childNodes[i].nodeType) {
				  case 1:
				  case 5:
					_result += dojo.dom.textContent(node.childNodes[i]);
					break;
				  case 3:
				  case 2:
				  case 4:
					_result += node.childNodes[i].nodeValue;
					break;
				  default:
					break;
				}
			}
			return _result;
		}
	};
	dojo.dom.hasParent = function (node) {
		return Boolean(node && node.parentNode && dojo.dom.isNode(node.parentNode));
	};
	dojo.dom.isTag = function (node) {
		if (node && node.tagName) {
			for (var i = 1; i < arguments.length; i++) {
				if (node.tagName == String(arguments[i])) {
					return String(arguments[i]);
				}
			}
		}
		return "";
	};
	dojo.dom.setAttributeNS = function (elem, namespaceURI, attrName, attrValue) {
		if (elem == null || ((elem == undefined) && (typeof elem == "undefined"))) {
			dojo.raise("No element given to dojo.dom.setAttributeNS");
		}
		if (!((elem.setAttributeNS == undefined) && (typeof elem.setAttributeNS == "undefined"))) {
			elem.setAttributeNS(namespaceURI, attrName, attrValue);
		} else {
			var ownerDoc = elem.ownerDocument;
			var attribute = ownerDoc.createNode(2, attrName, namespaceURI);
			attribute.nodeValue = attrValue;
			elem.setAttributeNode(attribute);
		}
	};
}});


__CPAN_FILE__ src/html.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.html");
dojo.require("dojo.html.*");
dojo.deprecated("dojo.html", "replaced by dojo.html.*", "0.5");


__CPAN_FILE__ src/hostenv_jsc.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
 * JScript .NET jsc
 *
 */

dojo.hostenv.name_ = 'jsc';

// Sanity check this is the right hostenv.
// See the Rotor source code jscript/engine/globalobject.cs for what globals
// are available.
if((typeof ScriptEngineMajorVersion != 'function')||(ScriptEngineMajorVersion() < 7)){
	dojo.raise("attempt to use JScript .NET host environment with inappropriate ScriptEngine"); 
}

// for more than you wanted to know about why this import is required even if
// we fully qualify all symbols, see
// http://groups.google.com/groups?th=f050c7aeefdcbde2&rnum=12
import System;

dojo.hostenv.getText = function(uri){
	if(!System.IO.File.Exists(uri)){
		// dojo.raise("No such file '" + uri + "'");
		return 0;
	}
	var reader = new System.IO.StreamReader(uri);
	var contents : String = reader.ReadToEnd();
	return contents;
}

dojo.hostenv.loadUri = function(uri){
	var contents = this.getText(uri);
	if(!contents){
		dojo.raise("got no back contents from uri '" + uri + "': " + contents);
	}
	// TODO: in JScript .NET, eval will not affect the symbol table of the current code?
	var value = dj_eval(contents);
	dojo.debug("jsc eval of contents returned: ", value);
	return 1;

	// for an example doing runtime code compilation, see:
	// http://groups.google.com/groups?selm=eQ1aeciCBHA.1644%40tkmsftngp05&rnum=6
	// Microsoft.JScript or System.CodeDom.Compiler ?
	// var engine = new Microsoft.JScript.Vsa.VsaEngine()
	// what about loading a js file vs. a dll?
	// GetObject("script:" . uri);
}

/* The System.Environment object is useful:
    print ("CommandLine='" + System.Environment.CommandLine + "' " +
	   "program name='" + System.Environment.GetCommandLineArgs()[0] + "' " +
	   "CurrentDirectory='" + System.Environment.CurrentDirectory + "' " +
	   "StackTrace='" + System.Environment.StackTrace + "'");
*/

// same as System.Console.WriteLine
// sigh; Rotor treats symbol "print" at parse time without actually putting it
// in the builtin symbol table.
// Note that the print symbol is not available if jsc is run with the "/print-"
// option.
dojo.hostenv.println = function(s){
	print(s); // = print
}

dojo.hostenv.getLibraryScriptUri = function(){
	return System.Environment.GetCommandLineArgs()[0];
}

dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");

__CPAN_FILE__ src/hostenv_adobesvg.xd.js
dojo.hostenv.packageLoaded({
depends: [["requireIf", (djConfig["isDebug"] || djConfig["debugAtAllCosts"]]],
definePackage: function(dojo){/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
 * Adobe SVG Viewer host environment
 */
if(typeof window == 'undefined'){
	dojo.raise("attempt to use adobe svg hostenv when no window object");
}

with(dojo.render){
	name = navigator.appName;
	ver = parseFloat(navigator.appVersion, 10);
	switch(navigator.platform){
		case "MacOS":
			os.osx =  true;
			break;
		case "Linux":
			os.linux =  true;
			break;
		case "Windows":
			os.win =  true;
			break;
		default:
			os.linux = true;
			break;
	};
	svg.capable = true;
	svg.support.builtin = true;
	svg.adobe = true;
};

// browserEval("alert(window.location);");

dojo.hostenv.println = function(s){
	try{
    // FIXME: this may not work with adobe's viewer, as we may first need a 
		// reference to the svgDocument
		// FIXME: need a way to determine where to position the text for this
    var ti = document.createElement("text");
    ti.setAttribute("x","50");
		var yPos = 25 + 15*document.getElementsByTagName("text").length;
    ti.setAttribute("y",yPos);
		var tn = document.createTextNode(s);
		ti.appendChild(tn);
		document.documentElement.appendChild(ti);
	}catch(e){

	}
}

dojo.debug = function() {
	if (!djConfig.isDebug) { return; }
	var args = arguments;
	if(typeof dojo.hostenv.println != 'function'){
		dojo.raise("attempt to call dojo.debug when there is no dojo.hostenv println implementation (yet?)");
	}
	var isJUM = dj_global["jum"];
	var s = isJUM ? "": "DEBUG: ";
	for(var i=0;i<args.length;++i){ s += args[i]; }
	if(isJUM){ // this seems to be the only way to get JUM to "play nice"
		jum.debug(s);
	}else{
		dojo.hostenv.println(s);
	}
}

dojo.hostenv.startPackage("dojo.hostenv");

dojo.hostenv.name_ = 'adobesvg';

dojo.hostenv.anonCtr = 0;
dojo.hostenv.anon = {};

dojo.hostenv.nameAnonFunc = function(anonFuncPtr, namespaceObj){
	var ret = "_"+this.anonCtr++;
	var nso = (namespaceObj || this.anon);
	while(typeof nso[ret] != "undefined"){
		ret = "_"+this.anonCtr++;
	}
	nso[ret] = anonFuncPtr;
	return ret;
}

dojo.hostenv.modulesLoadedFired = false;
dojo.hostenv.modulesLoadedListeners = [];
dojo.hostenv.getTextStack = [];
dojo.hostenv.loadUriStack = [];
dojo.hostenv.loadedUris = [];


dojo.hostenv.modulesLoaded = function(){
	if(this.modulesLoadedFired){ return; }
	if((this.loadUriStack.length==0)&&(this.getTextStack.length==0)){
		if(this.inFlightCount > 0){ 
			dojo.debug("couldn't initialize, there are files still in flight");
			return;
		}
		this.modulesLoadedFired = true;
		var mll = this.modulesLoadedListeners;
		for(var x=0; x<mll.length; x++){
			mll[x]();
		}
	}
}

dojo.hostenv.getNewAnonFunc = function(){
	var ret = "_"+this.anonCtr++;
	while(typeof this.anon[ret] != "undefined"){
		ret = "_"+this.anonCtr++;
	}
	// this.anon[ret] = function(){};
	eval("dojo.nostenv.anon."+ret+" = function(){};");
	return [ret, this.anon[ret]];
}

dojo.hostenv.displayStack = function(){
	var oa = [];
	var stack = this.loadUriStack;
	for(var x=0; x<stack.length; x++){
		oa.unshift([stack[x][0], (typeof stack[x][2])]);
	}
	dojo.debug("<pre>"+oa.join("\n")+"</pre>");
}

dojo.hostenv.unwindUriStack = function(){
	var stack = this.loadUriStack;
	for(var x in dojo.hostenv.loadedUris){
		for(var y=stack.length-1; y>=0; y--){
			if(stack[y][0]==x){
				stack.splice(y, 1);
			}
		}
	}
	var next = stack.pop();
	if((!next)&&(stack.length==0)){ 
		return;
	}
	for(var x=0; x<stack.length; x++){
		if((stack[x][0]==next[0])&&(stack[x][2])){
			next[2] == stack[x][2]
		}
	}
	var last = next;
	while(dojo.hostenv.loadedUris[next[0]]){
		last = next;
		next = stack.pop();
	}
	while(typeof next[2] == "string"){ // unwind as far as we can
		try{
			// dojo.debug("<pre><![CDATA["+next[2]+"]]></pre>");
			dj_eval(next[2]);
			next[1](true);
		}catch(e){
			dojo.debug("we got an error when loading "+next[0]);
			dojo.debug("error: "+e);
			// for(var x in e){ alert(x+" "+e[x]); }
		}
		dojo.hostenv.loadedUris[next[0]] = true;
		dojo.hostenv.loadedUris.push(next[0]);
		last = next;
		next = stack.pop();
		if((!next)&&(stack.length==0)){ break; }
		while(dojo.hostenv.loadedUris[next[0]]){
			last = next;
			next = stack.pop();
		}
	}
	if(next){
		stack.push(next);
		dojo.debug("### CHOKED ON: "+next[0]);
	}
}

/**
 * Reads the contents of the URI, and evaluates the contents.
 * Returns true if it succeeded. Returns false if the URI reading failed. Throws if the evaluation throws.
 * The result of the eval is not available to the caller.
 */
dojo.hostenv.loadUri = function(uri, cb){
	if(dojo.hostenv.loadedUris[uri]){
		return;
	}
	var stack = this.loadUriStack;
	stack.push([uri, cb, null]);
	var tcb = function(contents){
		// gratuitous hack for Adobe SVG 3
		if(contents.content){
			contents = contents.content;
		}

		// stack management
		var next = stack.pop();
		if((!next)&&(stack.length==0)){ 
			dojo.hostenv.modulesLoaded();
			return;
		}
		if(typeof contents == "string"){
			stack.push(next);
			for(var x=0; x<stack.length; x++){
				if(stack[x][0]==uri){
					stack[x][2] = contents;
				}
			}
			next = stack.pop();
		}
		if(dojo.hostenv.loadedUris[next[0]]){ 
			// dojo.debug("WE ALREADY HAD: "+next[0]);
			dojo.hostenv.unwindUriStack();
			return;
		}
		// push back onto stack
		stack.push(next);
		if(next[0]!=uri){
			//  and then unwind as far as we can
			if(typeof next[2] == "string"){
				dojo.hostenv.unwindUriStack();
			}

		}else{
			if(!contents){ 
				next[1](false);
			}else{
				var deps = dojo.hostenv.getDepsForEval(next[2]);
				if(deps.length>0){
					eval(deps.join(";"));
				}else{
					dojo.hostenv.unwindUriStack();
				}
			}
		}
	}
	this.getText(uri, tcb, true);
}

/**
* loadModule("A.B") first checks to see if symbol A.B is defined. 
* If it is, it is simply returned (nothing to do).
* If it is not defined, it will look for "A/B.js" in the script root directory, followed
* by "A.js".
* It throws if it cannot find a file to load, or if the symbol A.B is not defined after loading.
* It returns the object A.B.
*
* This does nothing about importing symbols into the current package.
* It is presumed that the caller will take care of that. For example, to import
* all symbols:
*
*    with (dojo.hostenv.loadModule("A.B")) {
*       ...
*    }
*
* And to import just the leaf symbol:
*
*    var B = dojo.hostenv.loadModule("A.B");
*    ...
*
* dj_load is an alias for dojo.hostenv.loadModule
*/
dojo.hostenv.loadModule = function(modulename, exact_only, omit_module_check){
	// alert("dojo.hostenv.loadModule('"+modulename+"');");
	var module = this.findModule(modulename, 0);
	if(module){
		return module;
	}

	// dojo.debug("dojo.hostenv.loadModule('"+modulename+"');");

	// protect against infinite recursion from mutual dependencies
	if (typeof this.loading_modules_[modulename] !== 'undefined'){
		// NOTE: this should never throw an exception!! "recursive" includes
		// are normal in the course of app and module building, so blow out of
		// it gracefully, but log it in debug mode

		// dojo.raise("recursive attempt to load module '" + modulename + "'");
		dojo.debug("recursive attempt to load module '" + modulename + "'");
	}else{
		this.addedToLoadingCount.push(modulename);
	}
	this.loading_modules_[modulename] = 1;


	// convert periods to slashes
	var relpath = modulename.replace(/\./g, '/') + '.js';

	var syms = modulename.split(".");
	var nsyms = modulename.split(".");
	if(syms[0]=="dojo"){ // FIXME: need a smarter way to do this!
		syms[0] = "src"; 
	}
	var last = syms.pop();
	syms.push(last);
	// figure out if we're looking for a full package, if so, we want to do
	// things slightly diffrently
	var _this = this;
	var pfn = this.pkgFileName;
	if(last=="*"){
		modulename = (nsyms.slice(0, -1)).join('.');

		var module = this.findModule(modulename, 0);
		// dojo.debug("found: "+modulename+"="+module);
		if(module){
			_this.removedFromLoadingCount.push(modulename);
			return module;
		}

		var nextTry = function(lastStatus){
			if(lastStatus){ 
				module = _this.findModule(modulename, false); // pass in false so we can give better error
				if((!module)&&(syms[syms.length-1]!=pfn)){
					dojo.raise("Module symbol '" + modulename + "' is not defined after loading '" + relpath + "'"); 
				}
				if(module){
					_this.removedFromLoadingCount.push(modulename);
					dojo.hostenv.modulesLoaded();
					return;
				}
			}
			syms.pop();
			syms.push(pfn);
			// dojo.debug("syms: "+syms);
			relpath = syms.join("/") + '.js';
			if(relpath.charAt(0)=="/"){
				relpath = relpath.slice(1);
			}
			// dojo.debug("relpath: "+relpath);
			_this.loadPath(relpath, ((!omit_module_check) ? modulename : null), nextTry);
		}

		nextTry();
	}else{
		relpath = syms.join("/") + '.js';
		modulename = nsyms.join('.');

		var nextTry = function(lastStatus){
			// dojo.debug("lastStatus: "+lastStatus);
			if(lastStatus){ 
				// dojo.debug("inital relpath: "+relpath);
				module = _this.findModule(modulename, false); // pass in false so we can give better error
				// if(!module){
				if((!module)&&(syms[syms.length-1]!=pfn)){
					dojo.raise("Module symbol '" + modulename + "' is not defined after loading '" + relpath + "'"); 
				}
				if(module){
					_this.removedFromLoadingCount.push(modulename);
					dojo.hostenv.modulesLoaded();
					return;
				}
			}
			var setPKG = (syms[syms.length-1]==pfn) ? false : true;
			syms.pop();
			if(setPKG){
				syms.push(pfn);
			}
			relpath = syms.join("/") + '.js';
			if(relpath.charAt(0)=="/"){
				relpath = relpath.slice(1);
			}
			// dojo.debug("relpath: "+relpath);
			_this.loadPath(relpath, ((!omit_module_check) ? modulename : null), nextTry);
		}

		this.loadPath(relpath, ((!omit_module_check) ? modulename : null), nextTry);
	}
	return;
}

/**
 * Read the contents of the specified uri and return those contents.
 *
 * FIXME: Make sure this is consistent with other implementations of getText
 * @param uri A relative or absolute uri. If absolute, it still must be in the same "domain" as we are.
 * @param async_cb If not specified, returns false as synchronous is not
 * supported. If specified, load asynchronously, and use async_cb as the handler which receives the result of the request.
 * @param fail_ok Default false. If fail_ok and !async_cb and loading fails, return null instead of throwing.
 */ 
dojo.hostenv.async_cb = null;

dojo.hostenv.unWindGetTextStack = function(){
	if(dojo.hostenv.inFlightCount>0){
		setTimeout("dojo.hostenv.unWindGetTextStack()", 100);
		return;
	}
	// we serialize because this environment is too messed up
	// to know how to do anything else
	dojo.hostenv.inFlightCount++;
	var next = dojo.hostenv.getTextStack.pop();
	if((!next)&&(dojo.hostenv.getTextStack.length==0)){ 
		dojo.hostenv.inFlightCount--;
		dojo.hostenv.async_cb = function(){};
		return;
	}
	dojo.hostenv.async_cb = next[1];
	// http = window.getURL(uri, dojo.hostenv.anon[cbn]);
	window.getURL(next[0], function(result){ 
		dojo.hostenv.inFlightCount--;
		dojo.hostenv.async_cb(result.content);
		dojo.hostenv.unWindGetTextStack();
	});
}

dojo.hostenv.getText = function(uri, async_cb, fail_ok){
	// dojo.debug("Calling getText()");
	try{
		if(async_cb){
			dojo.hostenv.getTextStack.push([uri, async_cb, fail_ok]);
			dojo.hostenv.unWindGetTextStack();
		}else{
			return dojo.raise("No synchronous XMLHTTP implementation available, for uri " + uri);
		}
	}catch(e){
		return dojo.raise("No XMLHTTP implementation available, for uri " + uri);
	}
}


/**
 * Makes an async post to the specified uri.
 *
 * FIXME: Not sure that we need this, but adding for completeness.
 * More details about the implementation of this are available at 
 * http://wiki.svg.org/index.php/PostUrl
 * @param uri A relative or absolute uri. If absolute, it still must be in the same "domain" as we are.
 * @param async_cb If not specified, returns false as synchronous is not
 * supported. If specified, load asynchronously, and use async_cb as the progress handler which takes the xmlhttp object as its argument. If async_cb, this function returns null.
 * @param text Data to post
 * @param fail_ok Default false. If fail_ok and !async_cb and loading fails, return null instead of throwing.
 * @param mime_type optional MIME type of the posted data (such as "text/plain")
 * @param encoding optional encoding for data. null, 'gzip' and 'deflate' are possible values. If browser does not support binary post this parameter is ignored.
 */ 
dojo.hostenv.postText = function(uri, async_cb, text, fail_ok, mime_type, encoding){
	var http = null;
	
	var async_callback = function(httpResponse){
		if (!httpResponse.success) {
			dojo.raise("Request for uri '" + uri + "' resulted in " + httpResponse.status);
		}
		
		if(!httpResponse.content) {
			if (!fail_ok) dojo.raise("Request for uri '" + uri + "' resulted in no content");
			return null;
		}
		// FIXME: wtf, I'm losing a reference to async_cb
		async_cb(httpResponse.content);
	}
	
	try {
		if(async_cb) {
			http = window.postURL(uri, text, async_callback, mimeType, encoding);
		} else {
		return dojo.raise("No synchronous XMLHTTP post implementation available, for uri " + uri);
		}
	} catch(e) {
		return dojo.raise("No XMLHTTP post implementation available, for uri " + uri);
	}
}

/*
 * It turns out that if we check *right now*, as this script file is being loaded,
 * then the last script element in the window DOM is ourselves.
 * That is because any subsequent script elements haven't shown up in the document
 * object yet.
 */
function dj_last_script_src() {
	var scripts = window.document.getElementsByTagName('script');
	if(scripts.length < 1){ 
		dojo.raise("No script elements in window.document, so can't figure out my script src"); 
	}
	var li = scripts.length-1;
	var xlinkNS = "http://www.w3.org/1999/xlink";
	var src = null;
	var script = null;
	while(!src){
		script = scripts.item(li);
		src = script.getAttributeNS(xlinkNS,"href");
		li--;
		if(li<0){ break; }
		// break;
	}
	if(!src){
		dojo.raise("Last script element (out of " + scripts.length + ") has no src");
	}
	return src;
}

if(!dojo.hostenv["library_script_uri_"]){
	dojo.hostenv.library_script_uri_ = dj_last_script_src();
}

// dojo.hostenv.loadUri = function(uri){
	/* FIXME: adding a script element doesn't seem to be synchronous, and so
	 * checking for namespace or object existance after loadUri using this
	 * method will error out. Need to figure out some other way of handling
	 * this!
	 */
	/*
	var se = document.createElement("script");
	se.src = uri;
	var head = document.getElementsByTagName("head")[0];
	head.appendChild(se);
	// document.write("<script type='text/javascript' src='"+uri+"' />");
	return 1;
}
*/

dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");

}});

__CPAN_FILE__ src/browser_debug.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.browser_debug");
dojo.hostenv.loadedUris.push("../src/bootstrap1.js");
dojo.hostenv.loadedUris.push("../src/loader.js");
dojo.hostenv.loadedUris.push("../src/hostenv_browser.js");
dojo.hostenv._loadedUrisListStart = dojo.hostenv.loadedUris.length;
function removeComments(contents) {
	contents = new String((!contents) ? "" : contents);
	contents = contents.replace(/^(.*?)\/\/(.*)$/mg, "$1");
	contents = contents.replace(/(\n)/mg, "__DOJONEWLINE");
	contents = contents.replace(/\/\*(.*?)\*\//g, "");
	return contents.replace(/__DOJONEWLINE/mg, "\n");
}
dojo.hostenv.getRequiresAndProvides = function (contents) {
	if (!contents) {
		return [];
	}
	var deps = [];
	var tmp;
	RegExp.lastIndex = 0;
	var testExp = /dojo.(hostenv.loadModule|hostenv.require|require|requireIf|kwCompoundRequire|hostenv.conditionalLoadModule|hostenv.startPackage|provide)\([\w\W]*?\)/mg;
	while ((tmp = testExp.exec(contents)) != null) {
		deps.push(tmp[0]);
	}
	return deps;
};
dojo.hostenv.getDelayRequiresAndProvides = function (contents) {
	if (!contents) {
		return [];
	}
	var deps = [];
	var tmp;
	RegExp.lastIndex = 0;
	var testExp = /dojo.(requireAfterIf)\([\w\W]*?\)/mg;
	while ((tmp = testExp.exec(contents)) != null) {
		deps.push(tmp[0]);
	}
	return deps;
};
dojo.clobberLastObject = function (objpath) {
	if (objpath.indexOf(".") == -1) {
		if (!dj_undef(objpath, dj_global)) {
			delete dj_global[objpath];
		}
		return true;
	}
	var syms = objpath.split(/\./);
	var base = dojo.evalObjPath(syms.slice(0, -1).join("."), false);
	var child = syms[syms.length - 1];
	if (!dj_undef(child, base)) {
		delete base[child];
		return true;
	}
	return false;
};
var removals = [];
function zip(arr) {
	var ret = [];
	var seen = {};
	for (var x = 0; x < arr.length; x++) {
		if (!seen[arr[x]]) {
			ret.push(arr[x]);
			seen[arr[x]] = true;
		}
	}
	return ret;
}
var old_dj_eval = dj_eval;
dj_eval = function () {
	return true;
};
dojo.hostenv.oldLoadUri = dojo.hostenv.loadUri;
dojo.hostenv.loadUri = function (uri, cb) {
	if (dojo.hostenv.loadedUris[uri]) {
		return true;
	}
	try {
		var text = this.getText(uri, null, true);
		if (!text) {
			return false;
		}
		if (cb) {
			var expr = old_dj_eval("(" + text + ")");
			cb(expr);
		} else {
			var requires = dojo.hostenv.getRequiresAndProvides(text);
			eval(requires.join(";"));
			dojo.hostenv.loadedUris.push(uri);
			dojo.hostenv.loadedUris[uri] = true;
			var delayRequires = dojo.hostenv.getDelayRequiresAndProvides(text);
			eval(delayRequires.join(";"));
		}
	}
	catch (e) {
		alert(e);
	}
	return true;
};
dojo.hostenv._writtenIncludes = {};
dojo.hostenv.writeIncludes = function (willCallAgain) {
	for (var x = removals.length - 1; x >= 0; x--) {
		dojo.clobberLastObject(removals[x]);
	}
	var depList = [];
	var seen = dojo.hostenv._writtenIncludes;
	for (var x = 0; x < dojo.hostenv.loadedUris.length; x++) {
		var curi = dojo.hostenv.loadedUris[x];
		if (!seen[curi]) {
			seen[curi] = true;
			depList.push(curi);
		}
	}
	dojo.hostenv._global_omit_module_check = true;
	for (var x = dojo.hostenv._loadedUrisListStart; x < depList.length; x++) {
		document.write("<script type='text/javascript' src='" + depList[x] + "'></script>");
	}
	document.write("<script type='text/javascript'>dojo.hostenv._global_omit_module_check = false;</script>");
	dojo.hostenv._loadedUrisListStart = 0;
	if (!willCallAgain) {
		dj_eval = old_dj_eval;
		dojo.hostenv.loadUri = dojo.hostenv.oldLoadUri;
	}
};


__CPAN_FILE__ src/json.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.json");
dojo.require("dojo.lang.func");
dojo.require("dojo.string.extras");
dojo.require("dojo.AdapterRegistry");
dojo.json = {jsonRegistry:new dojo.AdapterRegistry(), register:function (name, check, wrap, override) {
	dojo.json.jsonRegistry.register(name, check, wrap, override);
}, evalJson:function (json) {
	try {
		return eval("(" + json + ")");
	}
	catch (e) {
		dojo.debug(e);
		return json;
	}
}, serialize:function (o) {
	var objtype = typeof (o);
	if (objtype == "undefined") {
		return "undefined";
	} else {
		if ((objtype == "number") || (objtype == "boolean")) {
			return o + "";
		} else {
			if (o === null) {
				return "null";
			}
		}
	}
	if (objtype == "string") {
		return dojo.string.escapeString(o);
	}
	var me = arguments.callee;
	var newObj;
	if (typeof (o.__json__) == "function") {
		newObj = o.__json__();
		if (o !== newObj) {
			return me(newObj);
		}
	}
	if (typeof (o.json) == "function") {
		newObj = o.json();
		if (o !== newObj) {
			return me(newObj);
		}
	}
	if (objtype != "function" && typeof (o.length) == "number") {
		var res = [];
		for (var i = 0; i < o.length; i++) {
			var val = me(o[i]);
			if (typeof (val) != "string") {
				val = "undefined";
			}
			res.push(val);
		}
		return "[" + res.join(",") + "]";
	}
	try {
		window.o = o;
		newObj = dojo.json.jsonRegistry.match(o);
		return me(newObj);
	}
	catch (e) {
	}
	if (objtype == "function") {
		return null;
	}
	res = [];
	for (var k in o) {
		var useKey;
		if (typeof (k) == "number") {
			useKey = "\"" + k + "\"";
		} else {
			if (typeof (k) == "string") {
				useKey = dojo.string.escapeString(k);
			} else {
				continue;
			}
		}
		val = me(o[k]);
		if (typeof (val) != "string") {
			continue;
		}
		res.push(useKey + ":" + val);
	}
	return "{" + res.join(",") + "}";
}};


__CPAN_FILE__ src/DeferredList.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["require", "dojo.Deferred"], ["provide", "dojo.DeferredList"]], definePackage:function (dojo) {
	dojo.require("dojo.Deferred");
	dojo.provide("dojo.DeferredList");
	dojo.DeferredList = function (list, fireOnOneCallback, fireOnOneErrback, consumeErrors, canceller) {
		this.list = list;
		this.resultList = new Array(this.list.length);
		this.chain = [];
		this.id = this._nextId();
		this.fired = -1;
		this.paused = 0;
		this.results = [null, null];
		this.canceller = canceller;
		this.silentlyCancelled = false;
		if (this.list.length === 0 && !fireOnOneCallback) {
			this.callback(this.resultList);
		}
		this.finishedCount = 0;
		this.fireOnOneCallback = fireOnOneCallback;
		this.fireOnOneErrback = fireOnOneErrback;
		this.consumeErrors = consumeErrors;
		var index = 0;
		var _this = this;
		dojo.lang.forEach(this.list, function (d) {
			var _index = index;
			d.addCallback(function (r) {
				_this._cbDeferred(_index, true, r);
			});
			d.addErrback(function (r) {
				_this._cbDeferred(_index, false, r);
			});
			index++;
		});
	};
	dojo.inherits(dojo.DeferredList, dojo.Deferred);
	dojo.lang.extend(dojo.DeferredList, {_cbDeferred:function (index, succeeded, result) {
		this.resultList[index] = [succeeded, result];
		this.finishedCount += 1;
		if (this.fired !== 0) {
			if (succeeded && this.fireOnOneCallback) {
				this.callback([index, result]);
			} else {
				if (!succeeded && this.fireOnOneErrback) {
					this.errback(result);
				} else {
					if (this.finishedCount == this.list.length) {
						this.callback(this.resultList);
					}
				}
			}
		}
		if (!succeeded && this.consumeErrors) {
			result = null;
		}
		return result;
	}, gatherResults:function (deferredList) {
		var d = new dojo.DeferredList(deferredList, false, true, false);
		d.addCallback(function (results) {
			var ret = [];
			for (var i = 0; i < results.length; i++) {
				ret.push(results[i][1]);
			}
			return ret;
		});
		return d;
	}});
}});


__CPAN_FILE__ src/string.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.string");
dojo.require("dojo.string.common");


__CPAN_FILE__ src/io.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.io");
dojo.require("dojo.io.*");
dojo.deprecated("dojo.io", "replaced by dojo.io.*", "0.5");


__CPAN_FILE__ src/a11y.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.a11y"], ["require", "dojo.uri.*"], ["require", "dojo.html.common"]], definePackage:function (dojo) {
	dojo.provide("dojo.a11y");
	dojo.require("dojo.uri.*");
	dojo.require("dojo.html.common");
	dojo.a11y = {imgPath:dojo.uri.moduleUri("dojo.widget", "templates/images"), doAccessibleCheck:true, accessible:null, checkAccessible:function () {
		if (this.accessible === null) {
			this.accessible = false;
			if (this.doAccessibleCheck == true) {
				this.accessible = this.testAccessible();
			}
		}
		return this.accessible;
	}, testAccessible:function () {
		this.accessible = false;
		if (dojo.render.html.ie || dojo.render.html.mozilla) {
			var div = document.createElement("div");
			div.style.backgroundImage = "url(\"" + this.imgPath + "/tab_close.gif\")";
			dojo.body().appendChild(div);
			var bkImg = null;
			if (window.getComputedStyle) {
				var cStyle = getComputedStyle(div, "");
				bkImg = cStyle.getPropertyValue("background-image");
			} else {
				bkImg = div.currentStyle.backgroundImage;
			}
			var bUseImgElem = false;
			if (bkImg != null && (bkImg == "none" || bkImg == "url(invalid-url:)")) {
				this.accessible = true;
			}
			dojo.body().removeChild(div);
		}
		return this.accessible;
	}, setCheckAccessible:function (bTest) {
		this.doAccessibleCheck = bTest;
	}, setAccessibleMode:function () {
		if (this.accessible === null) {
			if (this.checkAccessible()) {
				dojo.render.html.prefixes.unshift("a11y");
			}
		}
		return this.accessible;
	}};
}});


__CPAN_FILE__ src/bootstrap1.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({definePackage:function (dojo) {
	var dj_global = this;
	var dj_currentContext = this;
	function dj_undef(name, object) {
		return (typeof (object || dj_currentContext)[name] == "undefined");
	}
	if (dj_undef("djConfig", this)) {
		var djConfig = {};
	}
	if (dj_undef("dojo", this)) {
		var dojo = {};
	}
	dojo.global = function () {
		return dj_currentContext;
	};
	dojo.locale = djConfig.locale;
	dojo.version = {major:0, minor:4, patch:3, flag:"", revision:Number("$Rev: 8617 $".match(/[0-9]+/)[0]), toString:function () {
		with (dojo.version) {
			return major + "." + minor + "." + patch + flag + " (" + revision + ")";
		}
	}};
	dojo.evalProp = function (name, object, create) {
		if ((!object) || (!name)) {
			return undefined;
		}
		if (!dj_undef(name, object)) {
			return object[name];
		}
		return (create ? (object[name] = {}) : undefined);
	};
	dojo.parseObjPath = function (path, context, create) {
		var object = (context || dojo.global());
		var names = path.split(".");
		var prop = names.pop();
		for (var i = 0, l = names.length; i < l && object; i++) {
			object = dojo.evalProp(names[i], object, create);
		}
		return {obj:object, prop:prop};
	};
	dojo.evalObjPath = function (path, create) {
		if (typeof path != "string") {
			return dojo.global();
		}
		if (path.indexOf(".") == -1) {
			return dojo.evalProp(path, dojo.global(), create);
		}
		var ref = dojo.parseObjPath(path, dojo.global(), create);
		if (ref) {
			return dojo.evalProp(ref.prop, ref.obj, create);
		}
		return null;
	};
	dojo.errorToString = function (exception) {
		if (!dj_undef("message", exception)) {
			return exception.message;
		} else {
			if (!dj_undef("description", exception)) {
				return exception.description;
			} else {
				return exception;
			}
		}
	};
	dojo.raise = function (message, exception) {
		if (exception) {
			message = message + ": " + dojo.errorToString(exception);
		} else {
			message = dojo.errorToString(message);
		}
		try {
			if (djConfig.isDebug) {
				dojo.hostenv.println("FATAL exception raised: " + message);
			}
		}
		catch (e) {
		}
		throw exception || Error(message);
	};
	dojo.debug = function () {
	};
	dojo.debugShallow = function (obj) {
	};
	dojo.profile = {start:function () {
	}, end:function () {
	}, stop:function () {
	}, dump:function () {
	}};
	function dj_eval(scriptFragment) {
		return dj_global.eval ? dj_global.eval(scriptFragment) : eval(scriptFragment);
	}
	dojo.unimplemented = function (funcname, extra) {
		var message = "'" + funcname + "' not implemented";
		if (extra != null) {
			message += " " + extra;
		}
		dojo.raise(message);
	};
	dojo.deprecated = function (behaviour, extra, removal) {
		var message = "DEPRECATED: " + behaviour;
		if (extra) {
			message += " " + extra;
		}
		if (removal) {
			message += " -- will be removed in version: " + removal;
		}
		dojo.debug(message);
	};
	dojo.render = (function () {
		function vscaffold(prefs, names) {
			var tmp = {capable:false, support:{builtin:false, plugin:false}, prefixes:prefs};
			for (var i = 0; i < names.length; i++) {
				tmp[names[i]] = false;
			}
			return tmp;
		}
		return {name:"", ver:dojo.version, os:{win:false, linux:false, osx:false}, html:vscaffold(["html"], ["ie", "opera", "khtml", "safari", "moz"]), svg:vscaffold(["svg"], ["corel", "adobe", "batik"]), vml:vscaffold(["vml"], ["ie"]), swf:vscaffold(["Swf", "Flash", "Mm"], ["mm"]), swt:vscaffold(["Swt"], ["ibm"])};
	})();
	dojo.hostenv = (function () {
		var config = {isDebug:false, allowQueryConfig:false, baseScriptUri:"", baseRelativePath:"", libraryScriptUri:"", iePreventClobber:false, ieClobberMinimal:true, preventBackButtonFix:true, delayMozLoadingFix:false, searchIds:[], parseWidgets:true};
		if (typeof djConfig == "undefined") {
			djConfig = config;
		} else {
			for (var option in config) {
				if (typeof djConfig[option] == "undefined") {
					djConfig[option] = config[option];
				}
			}
		}
		return {name_:"(unset)", version_:"(unset)", getName:function () {
			return this.name_;
		}, getVersion:function () {
			return this.version_;
		}, getText:function (uri) {
			dojo.unimplemented("getText", "uri=" + uri);
		}};
	})();
	dojo.hostenv.getBaseScriptUri = function () {
		if (djConfig.baseScriptUri.length) {
			return djConfig.baseScriptUri;
		}
		var uri = new String(djConfig.libraryScriptUri || djConfig.baseRelativePath);
		if (!uri) {
			dojo.raise("Nothing returned by getLibraryScriptUri(): " + uri);
		}
		var lastslash = uri.lastIndexOf("/");
		djConfig.baseScriptUri = djConfig.baseRelativePath;
		return djConfig.baseScriptUri;
	};
}});


__CPAN_FILE__ src/experimental.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.experimental");
dojo.experimental = function (moduleName, extra) {
	var message = "EXPERIMENTAL: " + moduleName;
	message += " -- Not yet ready for use.  APIs subject to change without notice.";
	if (extra) {
		message += " " + extra;
	}
	dojo.debug(message);
};


__CPAN_FILE__ src/browser_debug.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.browser_debug"], ["require", ]], definePackage:function (dojo) {
	dojo.provide("dojo.browser_debug");
	dojo.hostenv.loadedUris.push("../src/bootstrap1.js");
	dojo.hostenv.loadedUris.push("../src/loader.js");
	dojo.hostenv.loadedUris.push("../src/hostenv_browser.js");
	dojo.hostenv._loadedUrisListStart = dojo.hostenv.loadedUris.length;
	function removeComments(contents) {
		contents = new String((!contents) ? "" : contents);
		contents = contents.replace(/^(.*?)\/\/(.*)$/mg, "$1");
		contents = contents.replace(/(\n)/mg, "__DOJONEWLINE");
		contents = contents.replace(/\/\*(.*?)\*\//g, "");
		return contents.replace(/__DOJONEWLINE/mg, "\n");
	}
	dojo.hostenv.getRequiresAndProvides = function (contents) {
		if (!contents) {
			return [];
		}
		var deps = [];
		var tmp;
		RegExp.lastIndex = 0;
		var testExp = /dojo.(hostenv.loadModule|hostenv.require|require|requireIf|kwCompoundRequire|hostenv.conditionalLoadModule|hostenv.startPackage|provide)\([\w\W]*?\)/mg;
		while ((tmp = testExp.exec(contents)) != null) {
			deps.push(tmp[0]);
		}
		return deps;
	};
	dojo.hostenv.getDelayRequiresAndProvides = function (contents) {
		if (!contents) {
			return [];
		}
		var deps = [];
		var tmp;
		RegExp.lastIndex = 0;
		var testExp = /dojo.(requireAfterIf)\([\w\W]*?\)/mg;
		while ((tmp = testExp.exec(contents)) != null) {
			deps.push(tmp[0]);
		}
		return deps;
	};
	dojo.clobberLastObject = function (objpath) {
		if (objpath.indexOf(".") == -1) {
			if (!dj_undef(objpath, dj_global)) {
				delete dj_global[objpath];
			}
			return true;
		}
		var syms = objpath.split(/\./);
		var base = dojo.evalObjPath(syms.slice(0, -1).join("."), false);
		var child = syms[syms.length - 1];
		if (!dj_undef(child, base)) {
			delete base[child];
			return true;
		}
		return false;
	};
	var removals = [];
	function zip(arr) {
		var ret = [];
		var seen = {};
		for (var x = 0; x < arr.length; x++) {
			if (!seen[arr[x]]) {
				ret.push(arr[x]);
				seen[arr[x]] = true;
			}
		}
		return ret;
	}
	var old_dj_eval = dj_eval;
	dj_eval = function () {
		return true;
	};
	dojo.hostenv.oldLoadUri = dojo.hostenv.loadUri;
	dojo.hostenv.loadUri = function (uri, cb) {
		if (dojo.hostenv.loadedUris[uri]) {
			return true;
		}
		try {
			var text = this.getText(uri, null, true);
			if (!text) {
				return false;
			}
			if (cb) {
				var expr = old_dj_eval("(" + text + ")");
				cb(expr);
			} else {
				var requires = dojo.hostenv.getRequiresAndProvides(text);
				eval(requires.join(";"));
				dojo.hostenv.loadedUris.push(uri);
				dojo.hostenv.loadedUris[uri] = true;
				var delayRequires = dojo.hostenv.getDelayRequiresAndProvides(text);
				eval(delayRequires.join(";"));
			}
		}
		catch (e) {
			alert(e);
		}
		return true;
	};
	dojo.hostenv._writtenIncludes = {};
	dojo.hostenv.writeIncludes = function (willCallAgain) {
		for (var x = removals.length - 1; x >= 0; x--) {
			dojo.clobberLastObject(removals[x]);
		}
		var depList = [];
		var seen = dojo.hostenv._writtenIncludes;
		for (var x = 0; x < dojo.hostenv.loadedUris.length; x++) {
			var curi = dojo.hostenv.loadedUris[x];
			if (!seen[curi]) {
				seen[curi] = true;
				depList.push(curi);
			}
		}
		dojo.hostenv._global_omit_module_check = true;
		for (var x = dojo.hostenv._loadedUrisListStart; x < depList.length; x++) {
			document.write("<script type='text/javascript' src='" + depList[x] + "'></script>");
		}
		document.write("<script type='text/javascript'>dojo.hostenv._global_omit_module_check = false;</script>");
		dojo.hostenv._loadedUrisListStart = 0;
		if (!willCallAgain) {
			dj_eval = old_dj_eval;
			dojo.hostenv.loadUri = dojo.hostenv.oldLoadUri;
		}
	};
}});


__CPAN_FILE__ src/svg.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.svg"], ["require", "dojo.lang.common"], ["require", "dojo.dom"]], definePackage:function (dojo) {
	dojo.provide("dojo.svg");
	dojo.require("dojo.lang.common");
	dojo.require("dojo.dom");
	dojo.mixin(dojo.svg, dojo.dom);
	dojo.svg.graphics = dojo.svg.g = new function (d) {
		this.suspend = function () {
			try {
				d.documentElement.suspendRedraw(0);
			}
			catch (e) {
			}
		};
		this.resume = function () {
			try {
				d.documentElement.unsuspendRedraw(0);
			}
			catch (e) {
			}
		};
		this.force = function () {
			try {
				d.documentElement.forceRedraw();
			}
			catch (e) {
			}
		};
	}(document);
	dojo.svg.animations = dojo.svg.anim = new function (d) {
		this.arePaused = function () {
			try {
				return d.documentElement.animationsPaused();
			}
			catch (e) {
				return false;
			}
		};
		this.pause = function () {
			try {
				d.documentElement.pauseAnimations();
			}
			catch (e) {
			}
		};
		this.resume = function () {
			try {
				d.documentElement.unpauseAnimations();
			}
			catch (e) {
			}
		};
	}(document);
	dojo.svg.toCamelCase = function (selector) {
		var arr = selector.split("-"), cc = arr[0];
		for (var i = 1; i < arr.length; i++) {
			cc += arr[i].charAt(0).toUpperCase() + arr[i].substring(1);
		}
		return cc;
	};
	dojo.svg.toSelectorCase = function (selector) {
		return selector.replace(/([A-Z])/g, "-$1").toLowerCase();
	};
	dojo.svg.getStyle = function (node, cssSelector) {
		return document.defaultView.getComputedStyle(node, cssSelector);
	};
	dojo.svg.getNumericStyle = function (node, cssSelector) {
		return parseFloat(dojo.svg.getStyle(node, cssSelector));
	};
	dojo.svg.getOpacity = function (node) {
		return Math.min(1, dojo.svg.getNumericStyle(node, "fill-opacity"));
	};
	dojo.svg.setOpacity = function (node, opacity) {
		node.setAttributeNS(this.xmlns.svg, "fill-opacity", opacity);
		node.setAttributeNS(this.xmlns.svg, "stroke-opacity", opacity);
	};
	dojo.svg.clearOpacity = function (node) {
		node.setAttributeNS(this.xmlns.svg, "fill-opacity", "1.0");
		node.setAttributeNS(this.xmlns.svg, "stroke-opacity", "1.0");
	};
	dojo.svg.getCoords = function (node) {
		if (node.getBBox) {
			var box = node.getBBox();
			return {x:box.x, y:box.y};
		}
		return null;
	};
	dojo.svg.setCoords = function (node, coords) {
		var p = dojo.svg.getCoords();
		if (!p) {
			return;
		}
		var dx = p.x - coords.x;
		var dy = p.y - coords.y;
		dojo.svg.translate(node, dx, dy);
	};
	dojo.svg.getDimensions = function (node) {
		if (node.getBBox) {
			var box = node.getBBox();
			return {width:box.width, height:box.height};
		}
		return null;
	};
	dojo.svg.setDimensions = function (node, dim) {
		if (node.width) {
			node.width.baseVal.value = dim.width;
			node.height.baseVal.value = dim.height;
		} else {
			if (node.r) {
				node.r.baseVal.value = Math.min(dim.width, dim.height) / 2;
			} else {
				if (node.rx) {
					node.rx.baseVal.value = dim.width / 2;
					node.ry.baseVal.value = dim.height / 2;
				}
			}
		}
	};
	dojo.svg.translate = function (node, dx, dy) {
		if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
			var t = node.ownerSVGElement.createSVGTransform();
			t.setTranslate(dx, dy);
			node.transform.baseVal.appendItem(t);
		}
	};
	dojo.svg.scale = function (node, scaleX, scaleY) {
		if (!scaleY) {
			var scaleY = scaleX;
		}
		if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
			var t = node.ownerSVGElement.createSVGTransform();
			t.setScale(scaleX, scaleY);
			node.transform.baseVal.appendItem(t);
		}
	};
	dojo.svg.rotate = function (node, ang, cx, cy) {
		if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
			var t = node.ownerSVGElement.createSVGTransform();
			if (cx == null) {
				t.setMatrix(t.matrix.rotate(ang));
			} else {
				t.setRotate(ang, cx, cy);
			}
			node.transform.baseVal.appendItem(t);
		}
	};
	dojo.svg.skew = function (node, ang, axis) {
		var dir = axis || "x";
		if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
			var t = node.ownerSVGElement.createSVGTransform();
			if (dir != "x") {
				t.setSkewY(ang);
			} else {
				t.setSkewX(ang);
			}
			node.transform.baseVal.appendItem(t);
		}
	};
	dojo.svg.flip = function (node, axis) {
		var dir = axis || "x";
		if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
			var t = node.ownerSVGElement.createSVGTransform();
			t.setMatrix((dir != "x") ? t.matrix.flipY() : t.matrix.flipX());
			node.transform.baseVal.appendItem(t);
		}
	};
	dojo.svg.invert = function (node) {
		if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
			var t = node.ownerSVGElement.createSVGTransform();
			t.setMatrix(t.matrix.inverse());
			node.transform.baseVal.appendItem(t);
		}
	};
	dojo.svg.applyMatrix = function (node, a, b, c, d, e, f) {
		if (node.transform && node.ownerSVGElement && node.ownerSVGElement.createSVGTransform) {
			var m;
			if (b) {
				var m = node.ownerSVGElement.createSVGMatrix();
				m.a = a;
				m.b = b;
				m.c = c;
				m.d = d;
				m.e = e;
				m.f = f;
			} else {
				m = a;
			}
			var t = node.ownerSVGElement.createSVGTransform();
			t.setMatrix(m);
			node.transform.baseVal.appendItem(t);
		}
	};
	dojo.svg.group = function (nodes) {
		var p = nodes.item(0).parentNode;
		var g = document.createElementNS(this.xmlns.svg, "g");
		for (var i = 0; i < nodes.length; i++) {
			g.appendChild(nodes.item(i));
		}
		p.appendChild(g);
		return g;
	};
	dojo.svg.ungroup = function (g) {
		var p = g.parentNode;
		while (g.childNodes.length > 0) {
			p.appendChild(g.childNodes.item(0));
		}
		p.removeChild(g);
	};
	dojo.svg.getGroup = function (node) {
		var a = this.getAncestors(node);
		for (var i = 0; i < a.length; i++) {
			if (a[i].nodeType == this.ELEMENT_NODE && a[i].nodeName.toLowerCase() == "g") {
				return a[i];
			}
		}
		return null;
	};
	dojo.svg.bringToFront = function (node) {
		var n = this.getGroup(node) || node;
		n.ownerSVGElement.appendChild(n);
	};
	dojo.svg.sendToBack = function (node) {
		var n = this.getGroup(node) || node;
		n.ownerSVGElement.insertBefore(n, n.ownerSVGElement.firstChild);
	};
	dojo.svg.bringForward = function (node) {
		var n = this.getGroup(node) || node;
		if (this.getLastChildElement(n.parentNode) != n) {
			this.insertAfter(n, this.getNextSiblingElement(n), true);
		}
	};
	dojo.svg.sendBackward = function (node) {
		var n = this.getGroup(node) || node;
		if (this.getFirstChildElement(n.parentNode) != n) {
			this.insertBefore(n, this.getPreviousSiblingElement(n), true);
		}
	};
	dojo.svg.createNodesFromText = function (txt, wrap) {
		var docFrag = (new DOMParser()).parseFromString(txt, "text/xml").normalize();
		if (wrap) {
			return [docFrag.firstChild.cloneNode(true)];
		}
		var nodes = [];
		for (var x = 0; x < docFrag.childNodes.length; x++) {
			nodes.push(docFrag.childNodes.item(x).cloneNode(true));
		}
		return nodes;
	};
}});


__CPAN_FILE__ src/hostenv_dashboard.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.render.name = dojo.hostenv.name_ = "dashboard";
dojo.hostenv.println = function (message) {
	return alert(message);
};
dojo.hostenv.getXmlhttpObject = function (kwArgs) {
	if (widget.system && kwArgs) {
		if ((kwArgs.contentType && kwArgs.contentType.indexOf("text/") != 0) || (kwArgs.headers && kwArgs.headers["content-type"] && kwArgs.headers["content-type"].indexOf("text/") != 0)) {
			var curl = new dojo.hostenv.CurlRequest;
			curl._save = true;
			return curl;
		} else {
			if (kwArgs.method && kwArgs.method.toUpperCase() == "HEAD") {
				return new dojo.hostenv.CurlRequest;
			} else {
				if (kwArgs.headers && kwArgs.header.referer) {
					return new dojo.hostenv.CurlRequest;
				}
			}
		}
	}
	return new XMLHttpRequest;
};
dojo.hostenv.CurlRequest = function () {
	this.onreadystatechange = null;
	this.readyState = 0;
	this.responseText = "";
	this.responseXML = null;
	this.status = 0;
	this.statusText = "";
	this._method = "";
	this._url = "";
	this._async = true;
	this._referrer = "";
	this._headers = [];
	this._save = false;
	this._responseHeader = "";
	this._responseHeaders = {};
	this._fileName = "";
	this._username = "";
	this._password = "";
};
dojo.hostenv.CurlRequest.prototype.open = function (method, url, async, username, password) {
	this._method = method;
	this._url = url;
	if (async) {
		this._async = async;
	}
	if (username) {
		this._username = username;
	}
	if (password) {
		this._password = password;
	}
};
dojo.hostenv.CurlRequest.prototype.setRequestHeader = function (label, value) {
	switch (label) {
	  case "Referer":
		this._referrer = value;
		break;
	  case "content-type":
		break;
	  default:
		this._headers.push(label + "=" + value);
		break;
	}
};
dojo.hostenv.CurlRequest.prototype.getAllResponseHeaders = function () {
	return this._responseHeader;
};
dojo.hostenv.CurlRequest.prototype.getResponseHeader = function (headerLabel) {
	return this._responseHeaders[headerLabel];
};
dojo.hostenv.CurlRequest.prototype.send = function (content) {
	this.readyState = 1;
	if (this.onreadystatechange) {
		this.onreadystatechange.call(this);
	}
	var query = {sS:""};
	if (this._referrer) {
		query.e = this._referrer;
	}
	if (this._headers.length) {
		query.H = this._headers.join("&");
	}
	if (this._username) {
		if (this._password) {
			query.u = this._username + ":" + this._password;
		} else {
			query.u = this._username;
		}
	}
	if (content) {
		query.d = this.content;
		if (this._method != "POST") {
			query.G = "";
		}
	}
	if (this._method == "HEAD") {
		query.I = "";
	} else {
		if (this._save) {
			query.I = "";
		} else {
			query.i = "";
		}
	}
	var system = widget.system(dojo.hostenv.CurlRequest._formatCall(query, this._url), null);
	this.readyState = 2;
	if (this.onreadystatechange) {
		this.onreadystatechange.call(this);
	}
	if (system.errorString) {
		this.responseText = system.errorString;
		this.status = 0;
	} else {
		if (this._save) {
			this._responseHeader = system.outputString;
		} else {
			var split = system.outputString.replace(/\r/g, "").split("\n\n", 2);
			this._responseHeader = split[0];
			this.responseText = split[1];
		}
		split = this._responseHeader.split("\n");
		this.statusText = split.shift();
		this.status = this.statusText.split(" ")[1];
		for (var i = 0, header; header = split[i]; i++) {
			var header_split = header.split(": ", 2);
			this._responseHeaders[header_split[0]] = header_split[1];
		}
		if (this._save) {
			widget.system("/bin/mkdir cache", null);
			this._fileName = this._url.split("/").pop().replace(/\W/g, "");
			this._fileName += "." + this._responseHeaders["Content-Type"].replace(/[\r\n]/g, "").split("/").pop();
			delete query.I;
			query.o = "cache/" + this._fileName;
			system = widget.system(dojo.hostenv.CurlRequest._formatCall(query, this._url), null);
			if (!system.errorString) {
				this.responseText = "cache/" + this._fileName;
			}
		} else {
			if (this._method == "HEAD") {
				this.responseText = this._responseHeader;
			}
		}
	}
	this.readyState = 4;
	if (this.onreadystatechange) {
		this.onreadystatechange.call(this);
	}
};
dojo.hostenv.CurlRequest._formatCall = function (query, url) {
	var call = ["/usr/bin/curl"];
	for (var key in query) {
		if (query[key] != "") {
			call.push("-" + key + " '" + query[key].replace(/'/g, "'") + "'");
		} else {
			call.push("-" + key);
		}
	}
	call.push("'" + url.replace(/'/g, "'") + "'");
	return call.join(" ");
};
dojo.hostenv.exit = function () {
	if (widget.system) {
		widget.system("/bin/rm -rf cache/*", null);
	}
};


__CPAN_FILE__ src/html.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.html"], ["require", "dojo.html.*"]], definePackage:function (dojo) {
	dojo.provide("dojo.html");
	dojo.require("dojo.html.*");
	dojo.deprecated("dojo.html", "replaced by dojo.html.*", "0.5");
}});


__CPAN_FILE__ src/flash.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.flash"], ["require", "dojo.string.*"], ["require", "dojo.uri.*"], ["require", "dojo.html.common"]], definePackage:function (dojo) {
	dojo.provide("dojo.flash");
	dojo.require("dojo.string.*");
	dojo.require("dojo.uri.*");
	dojo.require("dojo.html.common");
	dojo.flash = function () {
	};
	dojo.flash = {flash6_version:null, flash8_version:null, ready:false, _visible:true, _loadedListeners:new Array(), _installingListeners:new Array(), setSwf:function (fileInfo) {
		if (fileInfo == null || dojo.lang.isUndefined(fileInfo)) {
			return;
		}
		if (fileInfo.flash6 != null && !dojo.lang.isUndefined(fileInfo.flash6)) {
			this.flash6_version = fileInfo.flash6;
		}
		if (fileInfo.flash8 != null && !dojo.lang.isUndefined(fileInfo.flash8)) {
			this.flash8_version = fileInfo.flash8;
		}
		if (!dojo.lang.isUndefined(fileInfo.visible)) {
			this._visible = fileInfo.visible;
		}
		this._initialize();
	}, useFlash6:function () {
		if (this.flash6_version == null) {
			return false;
		} else {
			if (this.flash6_version != null && dojo.flash.info.commVersion == 6) {
				return true;
			} else {
				return false;
			}
		}
	}, useFlash8:function () {
		if (this.flash8_version == null) {
			return false;
		} else {
			if (this.flash8_version != null && dojo.flash.info.commVersion == 8) {
				return true;
			} else {
				return false;
			}
		}
	}, addLoadedListener:function (listener) {
		this._loadedListeners.push(listener);
	}, addInstallingListener:function (listener) {
		this._installingListeners.push(listener);
	}, loaded:function () {
		dojo.flash.ready = true;
		if (dojo.flash._loadedListeners.length > 0) {
			for (var i = 0; i < dojo.flash._loadedListeners.length; i++) {
				dojo.flash._loadedListeners[i].call(null);
			}
		}
	}, installing:function () {
		if (dojo.flash._installingListeners.length > 0) {
			for (var i = 0; i < dojo.flash._installingListeners.length; i++) {
				dojo.flash._installingListeners[i].call(null);
			}
		}
	}, _initialize:function () {
		var installer = new dojo.flash.Install();
		dojo.flash.installer = installer;
		if (installer.needed() == true) {
			installer.install();
		} else {
			dojo.flash.obj = new dojo.flash.Embed(this._visible);
			dojo.flash.obj.write(dojo.flash.info.commVersion);
			dojo.flash.comm = new dojo.flash.Communicator();
		}
	}};
	dojo.flash.Info = function () {
		if (dojo.render.html.ie) {
			document.writeln("<script language=\"VBScript\" type=\"text/vbscript\">");
			document.writeln("Function VBGetSwfVer(i)");
			document.writeln("  on error resume next");
			document.writeln("  Dim swControl, swVersion");
			document.writeln("  swVersion = 0");
			document.writeln("  set swControl = CreateObject(\"ShockwaveFlash.ShockwaveFlash.\" + CStr(i))");
			document.writeln("  if (IsObject(swControl)) then");
			document.writeln("	swVersion = swControl.GetVariable(\"$version\")");
			document.writeln("  end if");
			document.writeln("  VBGetSwfVer = swVersion");
			document.writeln("End Function");
			document.writeln("</script>");
		}
		this._detectVersion();
		this._detectCommunicationVersion();
	};
	dojo.flash.Info.prototype = {version:-1, versionMajor:-1, versionMinor:-1, versionRevision:-1, capable:false, commVersion:6, installing:false, isVersionOrAbove:function (reqMajorVer, reqMinorVer, reqVer) {
		reqVer = parseFloat("." + reqVer);
		if (this.versionMajor >= reqMajorVer && this.versionMinor >= reqMinorVer && this.versionRevision >= reqVer) {
			return true;
		} else {
			return false;
		}
	}, _detectVersion:function () {
		var versionStr;
		for (var testVersion = 25; testVersion > 0; testVersion--) {
			if (dojo.render.html.ie) {
				versionStr = VBGetSwfVer(testVersion);
			} else {
				versionStr = this._JSFlashInfo(testVersion);
			}
			if (versionStr == -1) {
				this.capable = false;
				return;
			} else {
				if (versionStr != 0) {
					var versionArray;
					if (dojo.render.html.ie) {
						var tempArray = versionStr.split(" ");
						var tempString = tempArray[1];
						versionArray = tempString.split(",");
					} else {
						versionArray = versionStr.split(".");
					}
					this.versionMajor = versionArray[0];
					this.versionMinor = versionArray[1];
					this.versionRevision = versionArray[2];
					var versionString = this.versionMajor + "." + this.versionRevision;
					this.version = parseFloat(versionString);
					this.capable = true;
					break;
				}
			}
		}
	}, _JSFlashInfo:function (testVersion) {
		if (navigator.plugins != null && navigator.plugins.length > 0) {
			if (navigator.plugins["Shockwave Flash 2.0"] || navigator.plugins["Shockwave Flash"]) {
				var swVer2 = navigator.plugins["Shockwave Flash 2.0"] ? " 2.0" : "";
				var flashDescription = navigator.plugins["Shockwave Flash" + swVer2].description;
				var descArray = flashDescription.split(" ");
				var tempArrayMajor = descArray[2].split(".");
				var versionMajor = tempArrayMajor[0];
				var versionMinor = tempArrayMajor[1];
				if (descArray[3] != "") {
					var tempArrayMinor = descArray[3].split("r");
				} else {
					var tempArrayMinor = descArray[4].split("r");
				}
				var versionRevision = tempArrayMinor[1] > 0 ? tempArrayMinor[1] : 0;
				var version = versionMajor + "." + versionMinor + "." + versionRevision;
				return version;
			}
		}
		return -1;
	}, _detectCommunicationVersion:function () {
		if (this.capable == false) {
			this.commVersion = null;
			return;
		}
		if (typeof djConfig["forceFlashComm"] != "undefined" && typeof djConfig["forceFlashComm"] != null) {
			this.commVersion = djConfig["forceFlashComm"];
			return;
		}
		if (dojo.render.html.safari == true || dojo.render.html.opera == true) {
			this.commVersion = 8;
		} else {
			this.commVersion = 6;
		}
	}};
	dojo.flash.Embed = function (visible) {
		this._visible = visible;
	};
	dojo.flash.Embed.prototype = {width:215, height:138, id:"flashObject", _visible:true, protocol:function () {
		switch (window.location.protocol) {
		  case "https:":
			return "https";
			break;
		  default:
			return "http";
			break;
		}
	}, write:function (flashVer, doExpressInstall) {
		if (dojo.lang.isUndefined(doExpressInstall)) {
			doExpressInstall = false;
		}
		var containerStyle = new dojo.string.Builder();
		containerStyle.append("width: " + this.width + "px; ");
		containerStyle.append("height: " + this.height + "px; ");
		if (this._visible == false) {
			containerStyle.append("position: absolute; ");
			containerStyle.append("z-index: 10000; ");
			containerStyle.append("top: -1000px; ");
			containerStyle.append("left: -1000px; ");
		}
		containerStyle = containerStyle.toString();
		var objectHTML;
		var swfloc;
		if (flashVer == 6) {
			swfloc = dojo.flash.flash6_version;
			var dojoPath = djConfig.baseRelativePath;
			swfloc = swfloc + "?baseRelativePath=" + escape(dojoPath);
			objectHTML = "<embed id=\"" + this.id + "\" src=\"" + swfloc + "\" " + "	quality=\"high\" bgcolor=\"#ffffff\" " + "	width=\"" + this.width + "\" height=\"" + this.height + "\" " + "	name=\"" + this.id + "\" " + "	align=\"middle\" allowScriptAccess=\"sameDomain\" " + "	type=\"application/x-shockwave-flash\" swLiveConnect=\"true\" " + "	pluginspage=\"" + this.protocol() + "://www.macromedia.com/go/getflashplayer\">";
		} else {
			swfloc = dojo.flash.flash8_version;
			var swflocObject = swfloc;
			var swflocEmbed = swfloc;
			var dojoPath = djConfig.baseRelativePath;
			if (doExpressInstall) {
				var redirectURL = escape(window.location);
				document.title = document.title.slice(0, 47) + " - Flash Player Installation";
				var docTitle = escape(document.title);
				swflocObject += "?MMredirectURL=" + redirectURL + "&MMplayerType=ActiveX" + "&MMdoctitle=" + docTitle + "&baseRelativePath=" + escape(dojoPath);
				swflocEmbed += "?MMredirectURL=" + redirectURL + "&MMplayerType=PlugIn" + "&baseRelativePath=" + escape(dojoPath);
			}
			if (swflocEmbed.indexOf("?") == -1) {
				swflocEmbed += "?baseRelativePath=" + escape(dojoPath) + "' ";
			}
			objectHTML = "<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" " + "codebase=\"" + this.protocol() + "://fpdownload.macromedia.com/pub/shockwave/cabs/flash/" + "swflash.cab#version=8,0,0,0\" " + "width=\"" + this.width + "\" " + "height=\"" + this.height + "\" " + "id=\"" + this.id + "\" " + "align=\"middle\"> " + "<param name=\"allowScriptAccess\" value=\"sameDomain\" /> " + "<param name=\"movie\" value=\"" + swflocObject + "\" /> " + "<param name=\"quality\" value=\"high\" /> " + "<param name=\"bgcolor\" value=\"#ffffff\" /> " + "<embed src=\"" + swflocEmbed + "' " + "quality=\"high\" " + "bgcolor=\"#ffffff\" " + "width=\"" + this.width + "\" " + "height=\"" + this.height + "\" " + "id=\"" + this.id + "\" " + "name=\"" + this.id + "\" " + "swLiveConnect=\"true\" " + "align=\"middle\" " + "allowScriptAccess=\"sameDomain\" " + "type=\"application/x-shockwave-flash\" " + "pluginspage=\"" + this.protocol() + "://www.macromedia.com/go/getflashplayer\" />" + "</object>";
		}
		objectHTML = "<div id=\"" + this.id + "Container\" style=\"" + containerStyle + "\"> " + objectHTML + "</div>";
		document.writeln(objectHTML);
	}, get:function () {
		return document.getElementById(this.id);
	}, setVisible:function (visible) {
		var container = dojo.byId(this.id + "Container");
		if (visible == true) {
			container.style.visibility = "visible";
		} else {
			container.style.position = "absolute";
			container.style.x = "-1000px";
			container.style.y = "-1000px";
			container.style.visibility = "hidden";
		}
	}, center:function () {
		var elementWidth = this.width;
		var elementHeight = this.height;
		var scroll_offset = dojo.html.getScroll().offset;
		var viewport_size = dojo.html.getViewport();
		var x = scroll_offset.x + (viewport_size.width - elementWidth) / 2;
		var y = scroll_offset.y + (viewport_size.height - elementHeight) / 2;
		var container = dojo.byId(this.id + "Container");
		container.style.top = y + "px";
		container.style.left = x + "px";
	}};
	dojo.flash.Communicator = function () {
		if (dojo.flash.useFlash6()) {
			this._writeFlash6();
		} else {
			if (dojo.flash.useFlash8()) {
				this._writeFlash8();
			}
		}
	};
	dojo.flash.Communicator.prototype = {_writeFlash6:function () {
		var id = dojo.flash.obj.id;
		document.writeln("<script language=\"JavaScript\">");
		document.writeln("  function " + id + "_DoFSCommand(command, args){ ");
		document.writeln("	dojo.flash.comm._handleFSCommand(command, args); ");
		document.writeln("}");
		document.writeln("</script>");
		if (dojo.render.html.ie) {
			document.writeln("<SCRIPT LANGUAGE=VBScript> ");
			document.writeln("on error resume next ");
			document.writeln("Sub " + id + "_FSCommand(ByVal command, ByVal args)");
			document.writeln(" call " + id + "_DoFSCommand(command, args)");
			document.writeln("end sub");
			document.writeln("</SCRIPT> ");
		}
	}, _writeFlash8:function () {
	}, _handleFSCommand:function (command, args) {
		if (command != null && !dojo.lang.isUndefined(command) && /^FSCommand:(.*)/.test(command) == true) {
			command = command.match(/^FSCommand:(.*)/)[1];
		}
		if (command == "addCallback") {
			this._fscommandAddCallback(command, args);
		} else {
			if (command == "call") {
				this._fscommandCall(command, args);
			} else {
				if (command == "fscommandReady") {
					this._fscommandReady();
				}
			}
		}
	}, _fscommandAddCallback:function (command, args) {
		var functionName = args;
		var callFunc = function () {
			return dojo.flash.comm._call(functionName, arguments);
		};
		dojo.flash.comm[functionName] = callFunc;
		dojo.flash.obj.get().SetVariable("_succeeded", true);
	}, _fscommandCall:function (command, args) {
		var plugin = dojo.flash.obj.get();
		var functionName = args;
		var numArgs = parseInt(plugin.GetVariable("_numArgs"));
		var flashArgs = new Array();
		for (var i = 0; i < numArgs; i++) {
			var currentArg = plugin.GetVariable("_" + i);
			flashArgs.push(currentArg);
		}
		var runMe;
		if (functionName.indexOf(".") == -1) {
			runMe = window[functionName];
		} else {
			runMe = eval(functionName);
		}
		var results = null;
		if (!dojo.lang.isUndefined(runMe) && runMe != null) {
			results = runMe.apply(null, flashArgs);
		}
		plugin.SetVariable("_returnResult", results);
	}, _fscommandReady:function () {
		var plugin = dojo.flash.obj.get();
		plugin.SetVariable("fscommandReady", "true");
	}, _call:function (functionName, args) {
		var plugin = dojo.flash.obj.get();
		plugin.SetVariable("_functionName", functionName);
		plugin.SetVariable("_numArgs", args.length);
		for (var i = 0; i < args.length; i++) {
			var value = args[i];
			value = value.replace(/\0/g, "\\0");
			plugin.SetVariable("_" + i, value);
		}
		plugin.TCallLabel("/_flashRunner", "execute");
		var results = plugin.GetVariable("_returnResult");
		results = results.replace(/\\0/g, "\x00");
		return results;
	}, _addExternalInterfaceCallback:function (methodName) {
		var wrapperCall = function () {
			var methodArgs = new Array(arguments.length);
			for (var i = 0; i < arguments.length; i++) {
				methodArgs[i] = arguments[i];
			}
			return dojo.flash.comm._execFlash(methodName, methodArgs);
		};
		dojo.flash.comm[methodName] = wrapperCall;
	}, _encodeData:function (data) {
		var entityRE = /\&([^;]*)\;/g;
		data = data.replace(entityRE, "&amp;$1;");
		data = data.replace(/</g, "&lt;");
		data = data.replace(/>/g, "&gt;");
		data = data.replace("\\", "&custom_backslash;&custom_backslash;");
		data = data.replace(/\n/g, "\\n");
		data = data.replace(/\r/g, "\\r");
		data = data.replace(/\f/g, "\\f");
		data = data.replace(/\0/g, "\\0");
		data = data.replace(/\'/g, "\\'");
		data = data.replace(/\"/g, "\\\"");
		return data;
	}, _decodeData:function (data) {
		if (data == null || typeof data == "undefined") {
			return data;
		}
		data = data.replace(/\&custom_lt\;/g, "<");
		data = data.replace(/\&custom_gt\;/g, ">");
		data = eval("\"" + data + "\"");
		return data;
	}, _chunkArgumentData:function (value, argIndex) {
		var plugin = dojo.flash.obj.get();
		var numSegments = Math.ceil(value.length / 1024);
		for (var i = 0; i < numSegments; i++) {
			var startCut = i * 1024;
			var endCut = i * 1024 + 1024;
			if (i == (numSegments - 1)) {
				endCut = i * 1024 + value.length;
			}
			var piece = value.substring(startCut, endCut);
			piece = this._encodeData(piece);
			plugin.CallFunction("<invoke name=\"chunkArgumentData\" " + "returntype=\"javascript\">" + "<arguments>" + "<string>" + piece + "</string>" + "<number>" + argIndex + "</number>" + "</arguments>" + "</invoke>");
		}
	}, _chunkReturnData:function () {
		var plugin = dojo.flash.obj.get();
		var numSegments = plugin.getReturnLength();
		var resultsArray = new Array();
		for (var i = 0; i < numSegments; i++) {
			var piece = plugin.CallFunction("<invoke name=\"chunkReturnData\" " + "returntype=\"javascript\">" + "<arguments>" + "<number>" + i + "</number>" + "</arguments>" + "</invoke>");
			if (piece == "\"\"" || piece == "''") {
				piece = "";
			} else {
				piece = piece.substring(1, piece.length - 1);
			}
			resultsArray.push(piece);
		}
		var results = resultsArray.join("");
		return results;
	}, _execFlash:function (methodName, methodArgs) {
		var plugin = dojo.flash.obj.get();
		plugin.startExec();
		plugin.setNumberArguments(methodArgs.length);
		for (var i = 0; i < methodArgs.length; i++) {
			this._chunkArgumentData(methodArgs[i], i);
		}
		plugin.exec(methodName);
		var results = this._chunkReturnData();
		results = this._decodeData(results);
		plugin.endExec();
		return results;
	}};
	dojo.flash.Install = function () {
	};
	dojo.flash.Install.prototype = {needed:function () {
		if (dojo.flash.info.capable == false) {
			return true;
		}
		if (dojo.render.os.mac == true && !dojo.flash.info.isVersionOrAbove(8, 0, 0)) {
			return true;
		}
		if (!dojo.flash.info.isVersionOrAbove(6, 0, 0)) {
			return true;
		}
		return false;
	}, install:function () {
		dojo.flash.info.installing = true;
		dojo.flash.installing();
		if (dojo.flash.info.capable == false) {
			var installObj = new dojo.flash.Embed(false);
			installObj.write(8);
		} else {
			if (dojo.flash.info.isVersionOrAbove(6, 0, 65)) {
				var installObj = new dojo.flash.Embed(false);
				installObj.write(8, true);
				installObj.setVisible(true);
				installObj.center();
			} else {
				alert("This content requires a more recent version of the Macromedia " + " Flash Player.");
				window.location.href = +dojo.flash.Embed.protocol() + "://www.macromedia.com/go/getflashplayer";
			}
		}
	}, _onInstallStatus:function (msg) {
		if (msg == "Download.Complete") {
			dojo.flash._initialize();
		} else {
			if (msg == "Download.Cancelled") {
				alert("This content requires a more recent version of the Macromedia " + " Flash Player.");
				window.location.href = dojo.flash.Embed.protocol() + "://www.macromedia.com/go/getflashplayer";
			} else {
				if (msg == "Download.Failed") {
					alert("There was an error downloading the Flash Player update. " + "Please try again later, or visit macromedia.com to download " + "the latest version of the Flash plugin.");
				}
			}
		}
	}};
	dojo.flash.info = new dojo.flash.Info();
}});


__CPAN_FILE__ src/loader_xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.resetXd = function () {
	this.isXDomain = djConfig.useXDomain || false;
	this.xdTimer = 0;
	this.xdInFlight = {};
	this.xdOrderedReqs = [];
	this.xdDepMap = {};
	this.xdContents = [];
	this.xdDefList = [];
};
dojo.hostenv.resetXd();
dojo.hostenv.createXdPackage = function (contents, resourceName, resourcePath) {
	var deps = [];
	var depRegExp = /dojo.(requireLocalization|require|requireIf|requireAll|provide|requireAfterIf|requireAfter|kwCompoundRequire|conditionalRequire|hostenv\.conditionalLoadModule|.hostenv\.loadModule|hostenv\.moduleLoaded)\(([\w\W]*?)\)/mg;
	var match;
	while ((match = depRegExp.exec(contents)) != null) {
		if (match[1] == "requireLocalization") {
			eval(match[0]);
		} else {
			deps.push("\"" + match[1] + "\", " + match[2]);
		}
	}
	var output = [];
	output.push("dojo.hostenv.packageLoaded({\n");
	if (deps.length > 0) {
		output.push("depends: [");
		for (var i = 0; i < deps.length; i++) {
			if (i > 0) {
				output.push(",\n");
			}
			output.push("[" + deps[i] + "]");
		}
		output.push("],");
	}
	output.push("\ndefinePackage: function(dojo){");
	output.push(contents);
	output.push("\n}, resourceName: '" + resourceName + "', resourcePath: '" + resourcePath + "'});");
	return output.join("");
};
dojo.hostenv.loadPath = function (relpath, module, cb) {
	var colonIndex = relpath.indexOf(":");
	var slashIndex = relpath.indexOf("/");
	var uri;
	var currentIsXDomain = false;
	if (colonIndex > 0 && colonIndex < slashIndex) {
		uri = relpath;
		this.isXDomain = currentIsXDomain = true;
	} else {
		uri = this.getBaseScriptUri() + relpath;
		colonIndex = uri.indexOf(":");
		slashIndex = uri.indexOf("/");
		if (colonIndex > 0 && colonIndex < slashIndex && (!location.host || uri.indexOf("http://" + location.host) != 0)) {
			this.isXDomain = currentIsXDomain = true;
		}
	}
	if (djConfig.cacheBust && dojo.render.html.capable) {
		uri += "?" + String(djConfig.cacheBust).replace(/\W+/g, "");
	}
	try {
		return ((!module || this.isXDomain) ? this.loadUri(uri, cb, currentIsXDomain, module) : this.loadUriAndCheck(uri, module, cb));
	}
	catch (e) {
		dojo.debug(e);
		return false;
	}
};
dojo.hostenv.loadUri = function (uri, cb, currentIsXDomain, module) {
	if (this.loadedUris[uri]) {
		return 1;
	}
	if (this.isXDomain && module) {
		if (uri.indexOf("__package__") != -1) {
			module += ".*";
		}
		this.xdOrderedReqs.push(module);
		if (currentIsXDomain || uri.indexOf("/nls/") == -1) {
			this.xdInFlight[module] = true;
			this.inFlightCount++;
		}
		if (!this.xdTimer) {
			this.xdTimer = setInterval("dojo.hostenv.watchInFlightXDomain();", 100);
		}
		this.xdStartTime = (new Date()).getTime();
	}
	if (currentIsXDomain) {
		var lastIndex = uri.lastIndexOf(".");
		if (lastIndex <= 0) {
			lastIndex = uri.length - 1;
		}
		var xdUri = uri.substring(0, lastIndex) + ".xd";
		if (lastIndex != uri.length - 1) {
			xdUri += uri.substring(lastIndex, uri.length);
		}
		var element = document.createElement("script");
		element.type = "text/javascript";
		element.src = xdUri;
		if (!this.headElement) {
			this.headElement = document.getElementsByTagName("head")[0];
			if (!this.headElement) {
				this.headElement = document.getElementsByTagName("html")[0];
			}
		}
		this.headElement.appendChild(element);
	} else {
		var contents = this.getText(uri, null, true);
		if (contents == null) {
			return 0;
		}
		if (this.isXDomain && uri.indexOf("/nls/") == -1) {
			var pkg = this.createXdPackage(contents, module, uri);
			dj_eval(pkg);
		} else {
			if (cb) {
				contents = "(" + contents + ")";
			}
			var value = dj_eval(contents);
			if (cb) {
				cb(value);
			}
		}
	}
	this.loadedUris[uri] = true;
	return 1;
};
dojo.hostenv.packageLoaded = function (pkg) {
	var deps = pkg.depends;
	var requireList = null;
	var requireAfterList = null;
	var provideList = [];
	if (deps && deps.length > 0) {
		var dep = null;
		var insertHint = 0;
		var attachedPackage = false;
		for (var i = 0; i < deps.length; i++) {
			dep = deps[i];
			if (dep[0] == "provide" || dep[0] == "hostenv.moduleLoaded") {
				provideList.push(dep[1]);
			} else {
				if (!requireList) {
					requireList = [];
				}
				if (!requireAfterList) {
					requireAfterList = [];
				}
				var unpackedDeps = this.unpackXdDependency(dep);
				if (unpackedDeps.requires) {
					requireList = requireList.concat(unpackedDeps.requires);
				}
				if (unpackedDeps.requiresAfter) {
					requireAfterList = requireAfterList.concat(unpackedDeps.requiresAfter);
				}
			}
			var depType = dep[0];
			var objPath = depType.split(".");
			if (objPath.length == 2) {
				dojo[objPath[0]][objPath[1]].apply(dojo[objPath[0]], dep.slice(1));
			} else {
				dojo[depType].apply(dojo, dep.slice(1));
			}
		}
		var contentIndex = this.xdContents.push({content:pkg.definePackage, resourceName:pkg["resourceName"], resourcePath:pkg["resourcePath"], isDefined:false}) - 1;
		for (var i = 0; i < provideList.length; i++) {
			this.xdDepMap[provideList[i]] = {requires:requireList, requiresAfter:requireAfterList, contentIndex:contentIndex};
		}
		for (var i = 0; i < provideList.length; i++) {
			this.xdInFlight[provideList[i]] = false;
		}
	}
};
dojo.hostenv.xdLoadFlattenedBundle = function (moduleName, bundleName, locale, bundleData) {
	locale = locale || "root";
	var jsLoc = dojo.hostenv.normalizeLocale(locale).replace("-", "_");
	var bundlePackage = [moduleName, "nls", bundleName].join(".");
	var bundle = dojo.hostenv.startPackage(bundlePackage);
	bundle[jsLoc] = bundleData;
	var mapName = [moduleName, jsLoc, bundleName].join(".");
	var bundleMap = dojo.hostenv.xdBundleMap[mapName];
	if (bundleMap) {
		for (var param in bundleMap) {
			bundle[param] = bundleData;
		}
	}
};
dojo.hostenv.xdBundleMap = {};
dojo.xdRequireLocalization = function (moduleName, bundleName, locale, availableFlatLocales) {
	var locales = availableFlatLocales.split(",");
	var jsLoc = dojo.hostenv.normalizeLocale(locale);
	var bestLocale = "";
	for (var i = 0; i < locales.length; i++) {
		if (jsLoc.indexOf(locales[i]) == 0) {
			if (locales[i].length > bestLocale.length) {
				bestLocale = locales[i];
			}
		}
	}
	var fixedBestLocale = bestLocale.replace("-", "_");
	var bundlePackage = dojo.evalObjPath([moduleName, "nls", bundleName].join("."));
	if (bundlePackage && bundlePackage[fixedBestLocale]) {
		bundle[jsLoc.replace("-", "_")] = bundlePackage[fixedBestLocale];
	} else {
		var mapName = [moduleName, (fixedBestLocale || "root"), bundleName].join(".");
		var bundleMap = dojo.hostenv.xdBundleMap[mapName];
		if (!bundleMap) {
			bundleMap = dojo.hostenv.xdBundleMap[mapName] = {};
		}
		bundleMap[jsLoc.replace("-", "_")] = true;
		dojo.require(moduleName + ".nls" + (bestLocale ? "." + bestLocale : "") + "." + bundleName);
	}
};
(function () {
	var extra = djConfig.extraLocale;
	if (extra) {
		if (!extra instanceof Array) {
			extra = [extra];
		}
		dojo._xdReqLoc = dojo.xdRequireLocalization;
		dojo.xdRequireLocalization = function (m, b, locale, fLocales) {
			dojo._xdReqLoc(m, b, locale, fLocales);
			if (locale) {
				return;
			}
			for (var i = 0; i < extra.length; i++) {
				dojo._xdReqLoc(m, b, extra[i], fLocales);
			}
		};
	}
})();
dojo.hostenv.unpackXdDependency = function (dep) {
	var newDeps = null;
	var newAfterDeps = null;
	switch (dep[0]) {
	  case "requireIf":
	  case "requireAfterIf":
	  case "conditionalRequire":
		if ((dep[1] === true) || (dep[1] == "common") || (dep[1] && dojo.render[dep[1]].capable)) {
			newDeps = [{name:dep[2], content:null}];
		}
		break;
	  case "requireAll":
		dep.shift();
		newDeps = dep;
		dojo.hostenv.flattenRequireArray(newDeps);
		break;
	  case "kwCompoundRequire":
	  case "hostenv.conditionalLoadModule":
		var modMap = dep[1];
		var common = modMap["common"] || [];
		var newDeps = (modMap[dojo.hostenv.name_]) ? common.concat(modMap[dojo.hostenv.name_] || []) : common.concat(modMap["default"] || []);
		dojo.hostenv.flattenRequireArray(newDeps);
		break;
	  case "require":
	  case "requireAfter":
	  case "hostenv.loadModule":
		newDeps = [{name:dep[1], content:null}];
		break;
	}
	if (dep[0] == "requireAfterIf" || dep[0] == "requireIf") {
		newAfterDeps = newDeps;
		newDeps = null;
	}
	return {requires:newDeps, requiresAfter:newAfterDeps};
};
dojo.hostenv.xdWalkReqs = function () {
	var reqChain = null;
	var req;
	for (var i = 0; i < this.xdOrderedReqs.length; i++) {
		req = this.xdOrderedReqs[i];
		if (this.xdDepMap[req]) {
			reqChain = [req];
			reqChain[req] = true;
			this.xdEvalReqs(reqChain);
		}
	}
};
dojo.hostenv.xdEvalReqs = function (reqChain) {
	while (reqChain.length > 0) {
		var req = reqChain[reqChain.length - 1];
		var pkg = this.xdDepMap[req];
		if (pkg) {
			var reqs = pkg.requires;
			if (reqs && reqs.length > 0) {
				var nextReq;
				for (var i = 0; i < reqs.length; i++) {
					nextReq = reqs[i].name;
					if (nextReq && !reqChain[nextReq]) {
						reqChain.push(nextReq);
						reqChain[nextReq] = true;
						this.xdEvalReqs(reqChain);
					}
				}
			}
			var contents = this.xdContents[pkg.contentIndex];
			if (!contents.isDefined) {
				var content = contents.content;
				content["resourceName"] = contents["resourceName"];
				content["resourcePath"] = contents["resourcePath"];
				this.xdDefList.push(content);
				contents.isDefined = true;
			}
			this.xdDepMap[req] = null;
			var reqs = pkg.requiresAfter;
			if (reqs && reqs.length > 0) {
				var nextReq;
				for (var i = 0; i < reqs.length; i++) {
					nextReq = reqs[i].name;
					if (nextReq && !reqChain[nextReq]) {
						reqChain.push(nextReq);
						reqChain[nextReq] = true;
						this.xdEvalReqs(reqChain);
					}
				}
			}
		}
		reqChain.pop();
	}
};
dojo.hostenv.clearXdInterval = function () {
	clearInterval(this.xdTimer);
	this.xdTimer = 0;
};
dojo.hostenv.watchInFlightXDomain = function () {
	var waitInterval = (djConfig.xdWaitSeconds || 15) * 1000;
	if (this.xdStartTime + waitInterval < (new Date()).getTime()) {
		this.clearXdInterval();
		var noLoads = "";
		for (var param in this.xdInFlight) {
			if (this.xdInFlight[param]) {
				noLoads += param + " ";
			}
		}
		dojo.raise("Could not load cross-domain packages: " + noLoads);
	}
	for (var param in this.xdInFlight) {
		if (this.xdInFlight[param]) {
			return;
		}
	}
	this.clearXdInterval();
	this.xdWalkReqs();
	var defLength = this.xdDefList.length;
	for (var i = 0; i < defLength; i++) {
		var content = dojo.hostenv.xdDefList[i];
		if (djConfig["debugAtAllCosts"] && content["resourceName"]) {
			if (!this["xdDebugQueue"]) {
				this.xdDebugQueue = [];
			}
			this.xdDebugQueue.push({resourceName:content.resourceName, resourcePath:content.resourcePath});
		} else {
			content(dojo);
		}
	}
	for (var i = 0; i < this.xdContents.length; i++) {
		var current = this.xdContents[i];
		if (current.content && !current.isDefined) {
			current.content(dojo);
		}
	}
	this.resetXd();
	if (this["xdDebugQueue"] && this.xdDebugQueue.length > 0) {
		this.xdDebugFileLoaded();
	} else {
		this.xdNotifyLoaded();
	}
};
dojo.hostenv.xdNotifyLoaded = function () {
	this.inFlightCount = 0;
	if (this._djInitFired && !this.loadNotifying) {
		this.callLoaded();
	}
};
dojo.hostenv.flattenRequireArray = function (target) {
	if (target) {
		for (var i = 0; i < target.length; i++) {
			if (target[i] instanceof Array) {
				target[i] = {name:target[i][0], content:null};
			} else {
				target[i] = {name:target[i], content:null};
			}
		}
	}
};
dojo.hostenv.xdHasCalledPreload = false;
dojo.hostenv.xdRealCallLoaded = dojo.hostenv.callLoaded;
dojo.hostenv.callLoaded = function () {
	if (this.xdHasCalledPreload || dojo.hostenv.getModulePrefix("dojo") == "src" || !this.localesGenerated) {
		this.xdRealCallLoaded();
	} else {
		if (this.localesGenerated) {
			this.registerNlsPrefix = function () {
				dojo.registerModulePath("nls", dojo.hostenv.getModulePrefix("dojo") + "/../nls");
			};
			this.preloadLocalizations();
		}
	}
	this.xdHasCalledPreload = true;
};


__CPAN_FILE__ src/lang.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.lang"], ["require", "dojo.lang.common"]], definePackage:function (dojo) {
	dojo.provide("dojo.lang");
	dojo.require("dojo.lang.common");
	dojo.deprecated("dojo.lang", "replaced by dojo.lang.common", "0.5");
}});


__CPAN_FILE__ src/dom.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE = 1;
dojo.dom.ATTRIBUTE_NODE = 2;
dojo.dom.TEXT_NODE = 3;
dojo.dom.CDATA_SECTION_NODE = 4;
dojo.dom.ENTITY_REFERENCE_NODE = 5;
dojo.dom.ENTITY_NODE = 6;
dojo.dom.PROCESSING_INSTRUCTION_NODE = 7;
dojo.dom.COMMENT_NODE = 8;
dojo.dom.DOCUMENT_NODE = 9;
dojo.dom.DOCUMENT_TYPE_NODE = 10;
dojo.dom.DOCUMENT_FRAGMENT_NODE = 11;
dojo.dom.NOTATION_NODE = 12;
dojo.dom.dojoml = "http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns = {svg:"http://www.w3.org/2000/svg", smil:"http://www.w3.org/2001/SMIL20/", mml:"http://www.w3.org/1998/Math/MathML", cml:"http://www.xml-cml.org", xlink:"http://www.w3.org/1999/xlink", xhtml:"http://www.w3.org/1999/xhtml", xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", xbl:"http://www.mozilla.org/xbl", fo:"http://www.w3.org/1999/XSL/Format", xsl:"http://www.w3.org/1999/XSL/Transform", xslt:"http://www.w3.org/1999/XSL/Transform", xi:"http://www.w3.org/2001/XInclude", xforms:"http://www.w3.org/2002/01/xforms", saxon:"http://icl.com/saxon", xalan:"http://xml.apache.org/xslt", xsd:"http://www.w3.org/2001/XMLSchema", dt:"http://www.w3.org/2001/XMLSchema-datatypes", xsi:"http://www.w3.org/2001/XMLSchema-instance", rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#", rdfs:"http://www.w3.org/2000/01/rdf-schema#", dc:"http://purl.org/dc/elements/1.1/", dcq:"http://purl.org/dc/qualifiers/1.0", "soap-env":"http://schemas.xmlsoap.org/soap/envelope/", wsdl:"http://schemas.xmlsoap.org/wsdl/", AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode = function (wh) {
	if (typeof Element == "function") {
		try {
			return wh instanceof Element;
		}
		catch (e) {
		}
	} else {
		return wh && !isNaN(wh.nodeType);
	}
};
dojo.dom.getUniqueId = function () {
	var _document = dojo.doc();
	do {
		var id = "dj_unique_" + (++arguments.callee._idIncrement);
	} while (_document.getElementById(id));
	return id;
};
dojo.dom.getUniqueId._idIncrement = 0;
dojo.dom.firstElement = dojo.dom.getFirstChildElement = function (parentNode, tagName) {
	var node = parentNode.firstChild;
	while (node && node.nodeType != dojo.dom.ELEMENT_NODE) {
		node = node.nextSibling;
	}
	if (tagName && node && node.tagName && node.tagName.toLowerCase() != tagName.toLowerCase()) {
		node = dojo.dom.nextElement(node, tagName);
	}
	return node;
};
dojo.dom.lastElement = dojo.dom.getLastChildElement = function (parentNode, tagName) {
	var node = parentNode.lastChild;
	while (node && node.nodeType != dojo.dom.ELEMENT_NODE) {
		node = node.previousSibling;
	}
	if (tagName && node && node.tagName && node.tagName.toLowerCase() != tagName.toLowerCase()) {
		node = dojo.dom.prevElement(node, tagName);
	}
	return node;
};
dojo.dom.nextElement = dojo.dom.getNextSiblingElement = function (node, tagName) {
	if (!node) {
		return null;
	}
	do {
		node = node.nextSibling;
	} while (node && node.nodeType != dojo.dom.ELEMENT_NODE);
	if (node && tagName && tagName.toLowerCase() != node.tagName.toLowerCase()) {
		return dojo.dom.nextElement(node, tagName);
	}
	return node;
};
dojo.dom.prevElement = dojo.dom.getPreviousSiblingElement = function (node, tagName) {
	if (!node) {
		return null;
	}
	if (tagName) {
		tagName = tagName.toLowerCase();
	}
	do {
		node = node.previousSibling;
	} while (node && node.nodeType != dojo.dom.ELEMENT_NODE);
	if (node && tagName && tagName.toLowerCase() != node.tagName.toLowerCase()) {
		return dojo.dom.prevElement(node, tagName);
	}
	return node;
};
dojo.dom.moveChildren = function (srcNode, destNode, trim) {
	var count = 0;
	if (trim) {
		while (srcNode.hasChildNodes() && srcNode.firstChild.nodeType == dojo.dom.TEXT_NODE) {
			srcNode.removeChild(srcNode.firstChild);
		}
		while (srcNode.hasChildNodes() && srcNode.lastChild.nodeType == dojo.dom.TEXT_NODE) {
			srcNode.removeChild(srcNode.lastChild);
		}
	}
	while (srcNode.hasChildNodes()) {
		destNode.appendChild(srcNode.firstChild);
		count++;
	}
	return count;
};
dojo.dom.copyChildren = function (srcNode, destNode, trim) {
	var clonedNode = srcNode.cloneNode(true);
	return this.moveChildren(clonedNode, destNode, trim);
};
dojo.dom.replaceChildren = function (node, newChild) {
	var nodes = [];
	if (dojo.render.html.ie) {
		for (var i = 0; i < node.childNodes.length; i++) {
			nodes.push(node.childNodes[i]);
		}
	}
	dojo.dom.removeChildren(node);
	node.appendChild(newChild);
	for (var i = 0; i < nodes.length; i++) {
		dojo.dom.destroyNode(nodes[i]);
	}
};
dojo.dom.removeChildren = function (node) {
	var count = node.childNodes.length;
	while (node.hasChildNodes()) {
		dojo.dom.removeNode(node.firstChild);
	}
	return count;
};
dojo.dom.replaceNode = function (node, newNode) {
	return node.parentNode.replaceChild(newNode, node);
};
dojo.dom.destroyNode = function (node) {
	if (node.parentNode) {
		node = dojo.dom.removeNode(node);
	}
	if (node.nodeType != 3) {
		if (dojo.evalObjPath("dojo.event.browser.clean", false)) {
			dojo.event.browser.clean(node);
		}
		if (dojo.render.html.ie) {
			node.outerHTML = "";
		}
	}
};
dojo.dom.removeNode = function (node) {
	if (node && node.parentNode) {
		return node.parentNode.removeChild(node);
	}
};
dojo.dom.getAncestors = function (node, filterFunction, returnFirstHit) {
	var ancestors = [];
	var isFunction = (filterFunction && (filterFunction instanceof Function || typeof filterFunction == "function"));
	while (node) {
		if (!isFunction || filterFunction(node)) {
			ancestors.push(node);
		}
		if (returnFirstHit && ancestors.length > 0) {
			return ancestors[0];
		}
		node = node.parentNode;
	}
	if (returnFirstHit) {
		return null;
	}
	return ancestors;
};
dojo.dom.getAncestorsByTag = function (node, tag, returnFirstHit) {
	tag = tag.toLowerCase();
	return dojo.dom.getAncestors(node, function (el) {
		return ((el.tagName) && (el.tagName.toLowerCase() == tag));
	}, returnFirstHit);
};
dojo.dom.getFirstAncestorByTag = function (node, tag) {
	return dojo.dom.getAncestorsByTag(node, tag, true);
};
dojo.dom.isDescendantOf = function (node, ancestor, guaranteeDescendant) {
	if (guaranteeDescendant && node) {
		node = node.parentNode;
	}
	while (node) {
		if (node == ancestor) {
			return true;
		}
		node = node.parentNode;
	}
	return false;
};
dojo.dom.innerXML = function (node) {
	if (node.innerXML) {
		return node.innerXML;
	} else {
		if (node.xml) {
			return node.xml;
		} else {
			if (typeof XMLSerializer != "undefined") {
				return (new XMLSerializer()).serializeToString(node);
			}
		}
	}
};
dojo.dom.createDocument = function () {
	var doc = null;
	var _document = dojo.doc();
	if (!dj_undef("ActiveXObject")) {
		var prefixes = ["MSXML2", "Microsoft", "MSXML", "MSXML3"];
		for (var i = 0; i < prefixes.length; i++) {
			try {
				doc = new ActiveXObject(prefixes[i] + ".XMLDOM");
			}
			catch (e) {
			}
			if (doc) {
				break;
			}
		}
	} else {
		if ((_document.implementation) && (_document.implementation.createDocument)) {
			doc = _document.implementation.createDocument("", "", null);
		}
	}
	return doc;
};
dojo.dom.createDocumentFromText = function (str, mimetype) {
	if (!mimetype) {
		mimetype = "text/xml";
	}
	if (!dj_undef("DOMParser")) {
		var parser = new DOMParser();
		return parser.parseFromString(str, mimetype);
	} else {
		if (!dj_undef("ActiveXObject")) {
			var domDoc = dojo.dom.createDocument();
			if (domDoc) {
				domDoc.async = false;
				domDoc.loadXML(str);
				return domDoc;
			} else {
				dojo.debug("toXml didn't work?");
			}
		} else {
			var _document = dojo.doc();
			if (_document.createElement) {
				var tmp = _document.createElement("xml");
				tmp.innerHTML = str;
				if (_document.implementation && _document.implementation.createDocument) {
					var xmlDoc = _document.implementation.createDocument("foo", "", null);
					for (var i = 0; i < tmp.childNodes.length; i++) {
						xmlDoc.importNode(tmp.childNodes.item(i), true);
					}
					return xmlDoc;
				}
				return ((tmp.document) && (tmp.document.firstChild ? tmp.document.firstChild : tmp));
			}
		}
	}
	return null;
};
dojo.dom.prependChild = function (node, parent) {
	if (parent.firstChild) {
		parent.insertBefore(node, parent.firstChild);
	} else {
		parent.appendChild(node);
	}
	return true;
};
dojo.dom.insertBefore = function (node, ref, force) {
	if ((force != true) && (node === ref || node.nextSibling === ref)) {
		return false;
	}
	var parent = ref.parentNode;
	parent.insertBefore(node, ref);
	return true;
};
dojo.dom.insertAfter = function (node, ref, force) {
	var pn = ref.parentNode;
	if (ref == pn.lastChild) {
		if ((force != true) && (node === ref)) {
			return false;
		}
		pn.appendChild(node);
	} else {
		return this.insertBefore(node, ref.nextSibling, force);
	}
	return true;
};
dojo.dom.insertAtPosition = function (node, ref, position) {
	if ((!node) || (!ref) || (!position)) {
		return false;
	}
	switch (position.toLowerCase()) {
	  case "before":
		return dojo.dom.insertBefore(node, ref);
	  case "after":
		return dojo.dom.insertAfter(node, ref);
	  case "first":
		if (ref.firstChild) {
			return dojo.dom.insertBefore(node, ref.firstChild);
		} else {
			ref.appendChild(node);
			return true;
		}
		break;
	  default:
		ref.appendChild(node);
		return true;
	}
};
dojo.dom.insertAtIndex = function (node, containingNode, insertionIndex) {
	var siblingNodes = containingNode.childNodes;
	if (!siblingNodes.length || siblingNodes.length == insertionIndex) {
		containingNode.appendChild(node);
		return true;
	}
	if (insertionIndex == 0) {
		return dojo.dom.prependChild(node, containingNode);
	}
	return dojo.dom.insertAfter(node, siblingNodes[insertionIndex - 1]);
};
dojo.dom.textContent = function (node, text) {
	if (arguments.length > 1) {
		var _document = dojo.doc();
		dojo.dom.replaceChildren(node, _document.createTextNode(text));
		return text;
	} else {
		if (node.textContent != undefined) {
			return node.textContent;
		}
		var _result = "";
		if (node == null) {
			return _result;
		}
		for (var i = 0; i < node.childNodes.length; i++) {
			switch (node.childNodes[i].nodeType) {
			  case 1:
			  case 5:
				_result += dojo.dom.textContent(node.childNodes[i]);
				break;
			  case 3:
			  case 2:
			  case 4:
				_result += node.childNodes[i].nodeValue;
				break;
			  default:
				break;
			}
		}
		return _result;
	}
};
dojo.dom.hasParent = function (node) {
	return Boolean(node && node.parentNode && dojo.dom.isNode(node.parentNode));
};
dojo.dom.isTag = function (node) {
	if (node && node.tagName) {
		for (var i = 1; i < arguments.length; i++) {
			if (node.tagName == String(arguments[i])) {
				return String(arguments[i]);
			}
		}
	}
	return "";
};
dojo.dom.setAttributeNS = function (elem, namespaceURI, attrName, attrValue) {
	if (elem == null || ((elem == undefined) && (typeof elem == "undefined"))) {
		dojo.raise("No element given to dojo.dom.setAttributeNS");
	}
	if (!((elem.setAttributeNS == undefined) && (typeof elem.setAttributeNS == "undefined"))) {
		elem.setAttributeNS(namespaceURI, attrName, attrValue);
	} else {
		var ownerDoc = elem.ownerDocument;
		var attribute = ownerDoc.createNode(2, attrName, namespaceURI);
		attribute.nodeValue = attrValue;
		elem.setAttributeNode(attribute);
	}
};


__CPAN_FILE__ src/hostenv_wsh.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.name_ = "wsh";
if (typeof WScript == "undefined") {
	dojo.raise("attempt to use WSH host environment when no WScript global");
}
dojo.hostenv.println = WScript.Echo;
dojo.hostenv.getCurrentScriptUri = function () {
	return WScript.ScriptFullName();
};
dojo.hostenv.getText = function (fpath) {
	var fso = new ActiveXObject("Scripting.FileSystemObject");
	var istream = fso.OpenTextFile(fpath, 1);
	if (!istream) {
		return null;
	}
	var contents = istream.ReadAll();
	istream.Close();
	return contents;
};
dojo.hostenv.exit = function (exitcode) {
	WScript.Quit(exitcode);
};
dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");


__CPAN_FILE__ src/experimental.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.experimental"]], definePackage:function (dojo) {
	dojo.provide("dojo.experimental");
	dojo.experimental = function (moduleName, extra) {
		var message = "EXPERIMENTAL: " + moduleName;
		message += " -- Not yet ready for use.  APIs subject to change without notice.";
		if (extra) {
			message += " " + extra;
		}
		dojo.debug(message);
	};
}});


__CPAN_FILE__ src/browser_debug_xd.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.browser_debug_xd"]], definePackage:function (dojo) {
	dojo.provide("dojo.browser_debug_xd");
	dojo.nonDebugProvide = dojo.provide;
	dojo.provide = function (resourceName) {
		var dbgQueue = dojo.hostenv["xdDebugQueue"];
		if (dbgQueue && dbgQueue.length > 0 && resourceName == dbgQueue["currentResourceName"]) {
			window.setTimeout("dojo.hostenv.xdDebugFileLoaded('" + resourceName + "')", 1);
		}
		dojo.nonDebugProvide.apply(dojo, arguments);
	};
	dojo.hostenv.xdDebugFileLoaded = function (resourceName) {
		var dbgQueue = this.xdDebugQueue;
		if (resourceName && resourceName == dbgQueue.currentResourceName) {
			dbgQueue.shift();
		}
		if (dbgQueue.length == 0) {
			dbgQueue.currentResourceName = null;
			this.xdNotifyLoaded();
		} else {
			dbgQueue.currentResourceName = dbgQueue[0].resourceName;
			var element = document.createElement("script");
			element.type = "text/javascript";
			element.src = dbgQueue[0].resourcePath;
			document.getElementsByTagName("head")[0].appendChild(element);
		}
	};
}});


__CPAN_FILE__ src/AdapterRegistry.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.AdapterRegistry");
dojo.require("dojo.lang.func");
dojo.AdapterRegistry = function (returnWrappers) {
	this.pairs = [];
	this.returnWrappers = returnWrappers || false;
};
dojo.lang.extend(dojo.AdapterRegistry, {register:function (name, check, wrap, directReturn, override) {
	var type = (override) ? "unshift" : "push";
	this.pairs[type]([name, check, wrap, directReturn]);
}, match:function () {
	for (var i = 0; i < this.pairs.length; i++) {
		var pair = this.pairs[i];
		if (pair[1].apply(this, arguments)) {
			if ((pair[3]) || (this.returnWrappers)) {
				return pair[2];
			} else {
				return pair[2].apply(this, arguments);
			}
		}
	}
	throw new Error("No match found");
}, unregister:function (name) {
	for (var i = 0; i < this.pairs.length; i++) {
		var pair = this.pairs[i];
		if (pair[0] == name) {
			this.pairs.splice(i, 1);
			return true;
		}
	}
	return false;
}});


__CPAN_FILE__ src/hostenv_svg.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



if (typeof window == "undefined") {
	dojo.raise("attempt to use adobe svg hostenv when no window object");
}
dojo.debug = function () {
	if (!djConfig.isDebug) {
		return;
	}
	var args = arguments;
	var isJUM = dj_global["jum"];
	var s = isJUM ? "" : "DEBUG: ";
	for (var i = 0; i < args.length; ++i) {
		s += args[i];
	}
	if (isJUM) {
		jum.debug(s);
	} else {
		dojo.hostenv.println(s);
	}
};
dojo.render.name = navigator.appName;
dojo.render.ver = parseFloat(navigator.appVersion, 10);
switch (navigator.platform) {
  case "MacOS":
	dojo.render.os.osx = true;
	break;
  case "Linux":
	dojo.render.os.linux = true;
	break;
  case "Windows":
	dojo.render.os.win = true;
	break;
  default:
	dojo.render.os.linux = true;
	break;
}
dojo.render.svg.capable = true;
dojo.render.svg.support.builtin = true;
dojo.render.svg.moz = ((navigator.userAgent.indexOf("Gecko") >= 0) && (!((navigator.appVersion.indexOf("Konqueror") >= 0) || (navigator.appVersion.indexOf("Safari") >= 0))));
dojo.render.svg.adobe = (window.parseXML != null);
dojo.hostenv.startPackage("dojo.hostenv");
dojo.hostenv.println = function (s) {
	try {
		var ti = document.createElement("text");
		ti.setAttribute("x", "50");
		ti.setAttribute("y", (25 + 15 * document.getElementsByTagName("text").length));
		ti.appendChild(document.createTextNode(s));
		document.documentElement.appendChild(ti);
	}
	catch (e) {
	}
};
dojo.hostenv.name_ = "svg";
dojo.hostenv.setModulePrefix = function (module, prefix) {
};
dojo.hostenv.getModulePrefix = function (module) {
};
dojo.hostenv.getTextStack = [];
dojo.hostenv.loadUriStack = [];
dojo.hostenv.loadedUris = [];
dojo.hostenv.modules_ = {};
dojo.hostenv.modulesLoadedFired = false;
dojo.hostenv.modulesLoadedListeners = [];
dojo.hostenv.getText = function (uri, cb, data) {
	if (!cb) {
		var cb = function (result) {
			window.alert(result);
		};
	}
	if (!data) {
		window.getUrl(uri, cb);
	} else {
		window.postUrl(uri, data, cb);
	}
};
dojo.hostenv.getLibaryScriptUri = function () {
};
dojo.hostenv.loadUri = function (uri) {
};
dojo.hostenv.loadUriAndCheck = function (uri, module) {
};
dojo.hostenv.loadModule = function (moduleName) {
	var a = moduleName.split(".");
	var currentObj = window;
	var s = [];
	for (var i = 0; i < a.length; i++) {
		if (a[i] == "*") {
			continue;
		}
		s.push(a[i]);
		if (!currentObj[a[i]]) {
			dojo.raise("dojo.require('" + moduleName + "'): module does not exist.");
		} else {
			currentObj = currentObj[a[i]];
		}
	}
	return;
};
dojo.hostenv.startPackage = function (moduleName) {
	var a = moduleName.split(".");
	var currentObj = window;
	var s = [];
	for (var i = 0; i < a.length; i++) {
		if (a[i] == "*") {
			continue;
		}
		s.push(a[i]);
		if (!currentObj[a[i]]) {
			currentObj[a[i]] = {};
		}
		currentObj = currentObj[a[i]];
	}
	return;
};
if (window.parseXML) {
	window.XMLSerialzer = function () {
		function nodeToString(n, a) {
			function fixText(s) {
				return String(s).replace(/\&/g, "&amp;").replace(/>/g, "&gt;").replace(/</g, "&lt;");
			}
			function fixAttribute(s) {
				return fixText(s).replace(/\"/g, "&quot;");
			}
			switch (n.nodeType) {
			  case 1:
				var name = n.nodeName;
				a.push("<" + name);
				for (var i = 0; i < n.attributes.length; i++) {
					if (n.attributes.item(i).specified) {
						a.push(" " + n.attributes.item(i).nodeName.toLowerCase() + "=\"" + fixAttribute(n.attributes.item(i).nodeValue) + "\"");
					}
				}
				if (n.canHaveChildren || n.hasChildNodes()) {
					a.push(">");
					for (var i = 0; i < n.childNodes.length; i++) {
						nodeToString(n.childNodes.item(i), a);
					}
					a.push("</" + name + ">\n");
				} else {
					a.push(" />\n");
				}
				break;
			  case 3:
				a.push(fixText(n.nodeValue));
				break;
			  case 4:
				a.push("<![CDA" + "TA[\n" + n.nodeValue + "\n]" + "]>");
				break;
			  case 7:
				a.push(n.nodeValue);
				if (/(^<\?xml)|(^<\!DOCTYPE)/.test(n.nodeValue)) {
					a.push("\n");
				}
				break;
			  case 8:
				a.push("<!-- " + n.nodeValue + " -->\n");
				break;
			  case 9:
			  case 11:
				for (var i = 0; i < n.childNodes.length; i++) {
					nodeToString(n.childNodes.item(i), a);
				}
				break;
			  default:
				a.push("<!--\nNot Supported:\n\n" + "nodeType: " + n.nodeType + "\nnodeName: " + n.nodeName + "\n-->");
			}
		}
		this.serializeToString = function (node) {
			var a = [];
			nodeToString(node, a);
			return a.join("");
		};
	};
	window.DOMParser = function () {
		this.parseFromString = function (s) {
			return parseXML(s, window.document);
		};
	};
	window.XMLHttpRequest = function () {
		var uri = null;
		var method = "POST";
		var isAsync = true;
		var cb = function (d) {
			this.responseText = d.content;
			try {
				this.responseXML = parseXML(this.responseText, window.document);
			}
			catch (e) {
			}
			this.status = "200";
			this.statusText = "OK";
			if (!d.success) {
				this.status = "500";
				this.statusText = "Internal Server Error";
			}
			this.onload();
			this.onreadystatechange();
		};
		this.onload = function () {
		};
		this.readyState = 4;
		this.onreadystatechange = function () {
		};
		this.status = 0;
		this.statusText = "";
		this.responseBody = null;
		this.responseStream = null;
		this.responseXML = null;
		this.responseText = null;
		this.abort = function () {
			return;
		};
		this.getAllResponseHeaders = function () {
			return [];
		};
		this.getResponseHeader = function (n) {
			return null;
		};
		this.setRequestHeader = function (nm, val) {
		};
		this.open = function (meth, url, async) {
			method = meth;
			uri = url;
		};
		this.send = function (data) {
			var d = data || null;
			if (method == "GET") {
				getURL(uri, cb);
			} else {
				postURL(uri, data, cb);
			}
		};
	};
}
dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");


__CPAN_FILE__ src/regexp.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.regexp"]], definePackage:function (dojo) {
	dojo.provide("dojo.regexp");
	dojo.evalObjPath("dojo.regexp.us", true);
	dojo.regexp.tld = function (flags) {
		flags = (typeof flags == "object") ? flags : {};
		if (typeof flags.allowCC != "boolean") {
			flags.allowCC = true;
		}
		if (typeof flags.allowInfra != "boolean") {
			flags.allowInfra = true;
		}
		if (typeof flags.allowGeneric != "boolean") {
			flags.allowGeneric = true;
		}
		var infraRE = "arpa";
		var genericRE = "aero|biz|com|coop|edu|gov|info|int|mil|museum|name|net|org|pro|travel|xxx|jobs|mobi|post";
		var ccRE = "ac|ad|ae|af|ag|ai|al|am|an|ao|aq|ar|as|at|au|aw|az|ba|bb|bd|be|bf|bg|bh|bi|bj|bm|bn|bo|br|" + "bs|bt|bv|bw|by|bz|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|co|cr|cu|cv|cx|cy|cz|de|dj|dk|dm|do|dz|" + "ec|ee|eg|er|eu|es|et|fi|fj|fk|fm|fo|fr|ga|gd|ge|gf|gg|gh|gi|gl|gm|gn|gp|gq|gr|gs|gt|gu|gw|" + "gy|hk|hm|hn|hr|ht|hu|id|ie|il|im|in|io|ir|is|it|je|jm|jo|jp|ke|kg|kh|ki|km|kn|kr|kw|ky|kz|" + "la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|mg|mh|mk|ml|mm|mn|mo|mp|mq|mr|ms|mt|mu|mv|mw|mx|" + "my|mz|na|nc|ne|nf|ng|ni|nl|no|np|nr|nu|nz|om|pa|pe|pf|pg|ph|pk|pl|pm|pn|pr|ps|pt|pw|py|qa|" + "re|ro|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sk|sl|sm|sn|sr|st|su|sv|sy|sz|tc|td|tf|tg|th|tj|tk|tm|" + "tn|to|tr|tt|tv|tw|tz|ua|ug|uk|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|ye|yt|yu|za|zm|zw";
		var a = [];
		if (flags.allowInfra) {
			a.push(infraRE);
		}
		if (flags.allowGeneric) {
			a.push(genericRE);
		}
		if (flags.allowCC) {
			a.push(ccRE);
		}
		var tldRE = "";
		if (a.length > 0) {
			tldRE = "(" + a.join("|") + ")";
		}
		return tldRE;
	};
	dojo.regexp.ipAddress = function (flags) {
		flags = (typeof flags == "object") ? flags : {};
		if (typeof flags.allowDottedDecimal != "boolean") {
			flags.allowDottedDecimal = true;
		}
		if (typeof flags.allowDottedHex != "boolean") {
			flags.allowDottedHex = true;
		}
		if (typeof flags.allowDottedOctal != "boolean") {
			flags.allowDottedOctal = true;
		}
		if (typeof flags.allowDecimal != "boolean") {
			flags.allowDecimal = true;
		}
		if (typeof flags.allowHex != "boolean") {
			flags.allowHex = true;
		}
		if (typeof flags.allowIPv6 != "boolean") {
			flags.allowIPv6 = true;
		}
		if (typeof flags.allowHybrid != "boolean") {
			flags.allowHybrid = true;
		}
		var dottedDecimalRE = "((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])";
		var dottedHexRE = "(0[xX]0*[\\da-fA-F]?[\\da-fA-F]\\.){3}0[xX]0*[\\da-fA-F]?[\\da-fA-F]";
		var dottedOctalRE = "(0+[0-3][0-7][0-7]\\.){3}0+[0-3][0-7][0-7]";
		var decimalRE = "(0|[1-9]\\d{0,8}|[1-3]\\d{9}|4[01]\\d{8}|42[0-8]\\d{7}|429[0-3]\\d{6}|" + "4294[0-8]\\d{5}|42949[0-5]\\d{4}|429496[0-6]\\d{3}|4294967[01]\\d{2}|42949672[0-8]\\d|429496729[0-5])";
		var hexRE = "0[xX]0*[\\da-fA-F]{1,8}";
		var ipv6RE = "([\\da-fA-F]{1,4}\\:){7}[\\da-fA-F]{1,4}";
		var hybridRE = "([\\da-fA-F]{1,4}\\:){6}" + "((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])";
		var a = [];
		if (flags.allowDottedDecimal) {
			a.push(dottedDecimalRE);
		}
		if (flags.allowDottedHex) {
			a.push(dottedHexRE);
		}
		if (flags.allowDottedOctal) {
			a.push(dottedOctalRE);
		}
		if (flags.allowDecimal) {
			a.push(decimalRE);
		}
		if (flags.allowHex) {
			a.push(hexRE);
		}
		if (flags.allowIPv6) {
			a.push(ipv6RE);
		}
		if (flags.allowHybrid) {
			a.push(hybridRE);
		}
		var ipAddressRE = "";
		if (a.length > 0) {
			ipAddressRE = "(" + a.join("|") + ")";
		}
		return ipAddressRE;
	};
	dojo.regexp.host = function (flags) {
		flags = (typeof flags == "object") ? flags : {};
		if (typeof flags.allowIP != "boolean") {
			flags.allowIP = true;
		}
		if (typeof flags.allowLocal != "boolean") {
			flags.allowLocal = false;
		}
		if (typeof flags.allowPort != "boolean") {
			flags.allowPort = true;
		}
		var domainNameRE = "([0-9a-zA-Z]([-0-9a-zA-Z]{0,61}[0-9a-zA-Z])?\\.)+" + dojo.regexp.tld(flags);
		var portRE = (flags.allowPort) ? "(\\:" + dojo.regexp.integer({signed:false}) + ")?" : "";
		var hostNameRE = domainNameRE;
		if (flags.allowIP) {
			hostNameRE += "|" + dojo.regexp.ipAddress(flags);
		}
		if (flags.allowLocal) {
			hostNameRE += "|localhost";
		}
		return "(" + hostNameRE + ")" + portRE;
	};
	dojo.regexp.url = function (flags) {
		flags = (typeof flags == "object") ? flags : {};
		if (typeof flags.scheme == "undefined") {
			flags.scheme = [true, false];
		}
		var protocolRE = dojo.regexp.buildGroupRE(flags.scheme, function (q) {
			if (q) {
				return "(https?|ftps?)\\://";
			}
			return "";
		});
		var pathRE = "(/([^?#\\s/]+/)*)?([^?#\\s/]+(\\?[^?#\\s/]*)?(#[A-Za-z][\\w.:-]*)?)?";
		return protocolRE + dojo.regexp.host(flags) + pathRE;
	};
	dojo.regexp.emailAddress = function (flags) {
		flags = (typeof flags == "object") ? flags : {};
		if (typeof flags.allowCruft != "boolean") {
			flags.allowCruft = false;
		}
		flags.allowPort = false;
		var usernameRE = "([\\da-z]+[-._+&'])*[\\da-z]+";
		var emailAddressRE = usernameRE + "@" + dojo.regexp.host(flags);
		if (flags.allowCruft) {
			emailAddressRE = "<?(mailto\\:)?" + emailAddressRE + ">?";
		}
		return emailAddressRE;
	};
	dojo.regexp.emailAddressList = function (flags) {
		flags = (typeof flags == "object") ? flags : {};
		if (typeof flags.listSeparator != "string") {
			flags.listSeparator = "\\s;,";
		}
		var emailAddressRE = dojo.regexp.emailAddress(flags);
		var emailAddressListRE = "(" + emailAddressRE + "\\s*[" + flags.listSeparator + "]\\s*)*" + emailAddressRE + "\\s*[" + flags.listSeparator + "]?\\s*";
		return emailAddressListRE;
	};
	dojo.regexp.integer = function (flags) {
		flags = (typeof flags == "object") ? flags : {};
		if (typeof flags.signed == "undefined") {
			flags.signed = [true, false];
		}
		if (typeof flags.separator == "undefined") {
			flags.separator = "";
		} else {
			if (typeof flags.groupSize == "undefined") {
				flags.groupSize = 3;
			}
		}
		var signRE = dojo.regexp.buildGroupRE(flags.signed, function (q) {
			return q ? "[-+]" : "";
		});
		var numberRE = dojo.regexp.buildGroupRE(flags.separator, function (sep) {
			if (sep == "") {
				return "(0|[1-9]\\d*)";
			}
			var grp = flags.groupSize, grp2 = flags.groupSize2;
			if (typeof grp2 != "undefined") {
				var grp2RE = "(0|[1-9]\\d{0," + (grp2 - 1) + "}([" + sep + "]\\d{" + grp2 + "})*[" + sep + "]\\d{" + grp + "})";
				return ((grp - grp2) > 0) ? "(" + grp2RE + "|(0|[1-9]\\d{0," + (grp - 1) + "}))" : grp2RE;
			}
			return "(0|[1-9]\\d{0," + (grp - 1) + "}([" + sep + "]\\d{" + grp + "})*)";
		});
		return signRE + numberRE;
	};
	dojo.regexp.realNumber = function (flags) {
		flags = (typeof flags == "object") ? flags : {};
		if (typeof flags.places != "number") {
			flags.places = Infinity;
		}
		if (typeof flags.decimal != "string") {
			flags.decimal = ".";
		}
		if (typeof flags.fractional == "undefined") {
			flags.fractional = [true, false];
		}
		if (typeof flags.exponent == "undefined") {
			flags.exponent = [true, false];
		}
		if (typeof flags.eSigned == "undefined") {
			flags.eSigned = [true, false];
		}
		var integerRE = dojo.regexp.integer(flags);
		var decimalRE = dojo.regexp.buildGroupRE(flags.fractional, function (q) {
			var re = "";
			if (q && (flags.places > 0)) {
				re = "\\" + flags.decimal;
				if (flags.places == Infinity) {
					re = "(" + re + "\\d+)?";
				} else {
					re = re + "\\d{" + flags.places + "}";
				}
			}
			return re;
		});
		var exponentRE = dojo.regexp.buildGroupRE(flags.exponent, function (q) {
			if (q) {
				return "([eE]" + dojo.regexp.integer({signed:flags.eSigned}) + ")";
			}
			return "";
		});
		return integerRE + decimalRE + exponentRE;
	};
	dojo.regexp.currency = function (flags) {
		flags = (typeof flags == "object") ? flags : {};
		if (typeof flags.signed == "undefined") {
			flags.signed = [true, false];
		}
		if (typeof flags.symbol == "undefined") {
			flags.symbol = "$";
		}
		if (typeof flags.placement != "string") {
			flags.placement = "before";
		}
		if (typeof flags.signPlacement != "string") {
			flags.signPlacement = "before";
		}
		if (typeof flags.separator == "undefined") {
			flags.separator = ",";
		}
		if (typeof flags.fractional == "undefined" && typeof flags.cents != "undefined") {
			dojo.deprecated("dojo.regexp.currency: flags.cents", "use flags.fractional instead", "0.5");
			flags.fractional = flags.cents;
		}
		if (typeof flags.decimal != "string") {
			flags.decimal = ".";
		}
		var signRE = dojo.regexp.buildGroupRE(flags.signed, function (q) {
			if (q) {
				return "[-+]";
			}
			return "";
		});
		var symbolRE = dojo.regexp.buildGroupRE(flags.symbol, function (symbol) {
			return "\\s?" + symbol.replace(/([.$?*!=:|\\\/^])/g, "\\$1") + "\\s?";
		});
		switch (flags.signPlacement) {
		  case "before":
			symbolRE = signRE + symbolRE;
			break;
		  case "after":
			symbolRE = symbolRE + signRE;
			break;
		}
		var flagsCopy = flags;
		flagsCopy.signed = false;
		flagsCopy.exponent = false;
		var numberRE = dojo.regexp.realNumber(flagsCopy);
		var currencyRE;
		switch (flags.placement) {
		  case "before":
			currencyRE = symbolRE + numberRE;
			break;
		  case "after":
			currencyRE = numberRE + symbolRE;
			break;
		}
		switch (flags.signPlacement) {
		  case "around":
			currencyRE = "(" + currencyRE + "|" + "\\(" + currencyRE + "\\)" + ")";
			break;
		  case "begin":
			currencyRE = signRE + currencyRE;
			break;
		  case "end":
			currencyRE = currencyRE + signRE;
			break;
		}
		return currencyRE;
	};
	dojo.regexp.us.state = function (flags) {
		flags = (typeof flags == "object") ? flags : {};
		if (typeof flags.allowTerritories != "boolean") {
			flags.allowTerritories = true;
		}
		if (typeof flags.allowMilitary != "boolean") {
			flags.allowMilitary = true;
		}
		var statesRE = "AL|AK|AZ|AR|CA|CO|CT|DE|DC|FL|GA|HI|ID|IL|IN|IA|KS|KY|LA|ME|MD|MA|MI|MN|MS|MO|MT|" + "NE|NV|NH|NJ|NM|NY|NC|ND|OH|OK|OR|PA|RI|SC|SD|TN|TX|UT|VT|VA|WA|WV|WI|WY";
		var territoriesRE = "AS|FM|GU|MH|MP|PW|PR|VI";
		var militaryRE = "AA|AE|AP";
		if (flags.allowTerritories) {
			statesRE += "|" + territoriesRE;
		}
		if (flags.allowMilitary) {
			statesRE += "|" + militaryRE;
		}
		return "(" + statesRE + ")";
	};
	dojo.regexp.time = function (flags) {
		dojo.deprecated("dojo.regexp.time", "Use dojo.date.parse instead", "0.5");
		flags = (typeof flags == "object") ? flags : {};
		if (typeof flags.format == "undefined") {
			flags.format = "h:mm:ss t";
		}
		if (typeof flags.amSymbol != "string") {
			flags.amSymbol = "AM";
		}
		if (typeof flags.pmSymbol != "string") {
			flags.pmSymbol = "PM";
		}
		var timeRE = function (format) {
			format = format.replace(/([.$?*!=:|{}\(\)\[\]\\\/^])/g, "\\$1");
			var amRE = flags.amSymbol.replace(/([.$?*!=:|{}\(\)\[\]\\\/^])/g, "\\$1");
			var pmRE = flags.pmSymbol.replace(/([.$?*!=:|{}\(\)\[\]\\\/^])/g, "\\$1");
			format = format.replace("hh", "(0[1-9]|1[0-2])");
			format = format.replace("h", "([1-9]|1[0-2])");
			format = format.replace("HH", "([01][0-9]|2[0-3])");
			format = format.replace("H", "([0-9]|1[0-9]|2[0-3])");
			format = format.replace("mm", "([0-5][0-9])");
			format = format.replace("m", "([1-5][0-9]|[0-9])");
			format = format.replace("ss", "([0-5][0-9])");
			format = format.replace("s", "([1-5][0-9]|[0-9])");
			format = format.replace("t", "\\s?(" + amRE + "|" + pmRE + ")\\s?");
			return format;
		};
		return dojo.regexp.buildGroupRE(flags.format, timeRE);
	};
	dojo.regexp.numberFormat = function (flags) {
		flags = (typeof flags == "object") ? flags : {};
		if (typeof flags.format == "undefined") {
			flags.format = "###-###-####";
		}
		var digitRE = function (format) {
			format = format.replace(/([.$*!=:|{}\(\)\[\]\\\/^])/g, "\\$1");
			format = format.replace(/\?/g, "\\d?");
			format = format.replace(/#/g, "\\d");
			return format;
		};
		return dojo.regexp.buildGroupRE(flags.format, digitRE);
	};
	dojo.regexp.buildGroupRE = function (a, re) {
		if (!(a instanceof Array)) {
			return re(a);
		}
		var b = [];
		for (var i = 0; i < a.length; i++) {
			b.push(re(a[i]));
		}
		return "(" + b.join("|") + ")";
	};
}});


__CPAN_FILE__ src/math.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.math");
dojo.math.degToRad = function (x) {
	return (x * Math.PI) / 180;
};
dojo.math.radToDeg = function (x) {
	return (x * 180) / Math.PI;
};
dojo.math.factorial = function (n) {
	if (n < 1) {
		return 0;
	}
	var retVal = 1;
	for (var i = 1; i <= n; i++) {
		retVal *= i;
	}
	return retVal;
};
dojo.math.permutations = function (n, k) {
	if (n == 0 || k == 0) {
		return 1;
	}
	return (dojo.math.factorial(n) / dojo.math.factorial(n - k));
};
dojo.math.combinations = function (n, r) {
	if (n == 0 || r == 0) {
		return 1;
	}
	return (dojo.math.factorial(n) / (dojo.math.factorial(n - r) * dojo.math.factorial(r)));
};
dojo.math.bernstein = function (t, n, i) {
	return (dojo.math.combinations(n, i) * Math.pow(t, i) * Math.pow(1 - t, n - i));
};
dojo.math.gaussianRandom = function () {
	var k = 2;
	do {
		var i = 2 * Math.random() - 1;
		var j = 2 * Math.random() - 1;
		k = i * i + j * j;
	} while (k >= 1);
	k = Math.sqrt((-2 * Math.log(k)) / k);
	return i * k;
};
dojo.math.mean = function () {
	var array = dojo.lang.isArray(arguments[0]) ? arguments[0] : arguments;
	var mean = 0;
	for (var i = 0; i < array.length; i++) {
		mean += array[i];
	}
	return mean / array.length;
};
dojo.math.round = function (number, places) {
	if (!places) {
		var shift = 1;
	} else {
		var shift = Math.pow(10, places);
	}
	return Math.round(number * shift) / shift;
};
dojo.math.sd = dojo.math.standardDeviation = function () {
	var array = dojo.lang.isArray(arguments[0]) ? arguments[0] : arguments;
	return Math.sqrt(dojo.math.variance(array));
};
dojo.math.variance = function () {
	var array = dojo.lang.isArray(arguments[0]) ? arguments[0] : arguments;
	var mean = 0, squares = 0;
	for (var i = 0; i < array.length; i++) {
		mean += array[i];
		squares += Math.pow(array[i], 2);
	}
	return (squares / array.length) - Math.pow(mean / array.length, 2);
};
dojo.math.range = function (a, b, step) {
	if (arguments.length < 2) {
		b = a;
		a = 0;
	}
	if (arguments.length < 3) {
		step = 1;
	}
	var range = [];
	if (step > 0) {
		for (var i = a; i < b; i += step) {
			range.push(i);
		}
	} else {
		if (step < 0) {
			for (var i = a; i > b; i += step) {
				range.push(i);
			}
		} else {
			throw new Error("dojo.math.range: step must be non-zero");
		}
	}
	return range;
};


__CPAN_FILE__ src/a11y.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.a11y");
dojo.require("dojo.uri.*");
dojo.require("dojo.html.common");
dojo.a11y = {imgPath:dojo.uri.moduleUri("dojo.widget", "templates/images"), doAccessibleCheck:true, accessible:null, checkAccessible:function () {
	if (this.accessible === null) {
		this.accessible = false;
		if (this.doAccessibleCheck == true) {
			this.accessible = this.testAccessible();
		}
	}
	return this.accessible;
}, testAccessible:function () {
	this.accessible = false;
	if (dojo.render.html.ie || dojo.render.html.mozilla) {
		var div = document.createElement("div");
		div.style.backgroundImage = "url(\"" + this.imgPath + "/tab_close.gif\")";
		dojo.body().appendChild(div);
		var bkImg = null;
		if (window.getComputedStyle) {
			var cStyle = getComputedStyle(div, "");
			bkImg = cStyle.getPropertyValue("background-image");
		} else {
			bkImg = div.currentStyle.backgroundImage;
		}
		var bUseImgElem = false;
		if (bkImg != null && (bkImg == "none" || bkImg == "url(invalid-url:)")) {
			this.accessible = true;
		}
		dojo.body().removeChild(div);
	}
	return this.accessible;
}, setCheckAccessible:function (bTest) {
	this.doAccessibleCheck = bTest;
}, setAccessibleMode:function () {
	if (this.accessible === null) {
		if (this.checkAccessible()) {
			dojo.render.html.prefixes.unshift("a11y");
		}
	}
	return this.accessible;
}};


__CPAN_FILE__ src/event.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.event");
dojo.require("dojo.event.*");
dojo.deprecated("dojo.event", "replaced by dojo.event.*", "0.5");


__CPAN_FILE__ src/data.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.data"]], definePackage:function (dojo) {
	dojo.provide("dojo.data");
	dojo.data = {};
}});


__CPAN_FILE__ src/hostenv_browser.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



if (typeof window != "undefined") {
	(function () {
		if (djConfig.allowQueryConfig) {
			var baseUrl = document.location.toString();
			var params = baseUrl.split("?", 2);
			if (params.length > 1) {
				var paramStr = params[1];
				var pairs = paramStr.split("&");
				for (var x in pairs) {
					var sp = pairs[x].split("=");
					if ((sp[0].length > 9) && (sp[0].substr(0, 9) == "djConfig.")) {
						var opt = sp[0].substr(9);
						try {
							djConfig[opt] = eval(sp[1]);
						}
						catch (e) {
							djConfig[opt] = sp[1];
						}
					}
				}
			}
		}
		if (((djConfig["baseScriptUri"] == "") || (djConfig["baseRelativePath"] == "")) && (document && document.getElementsByTagName)) {
			var scripts = document.getElementsByTagName("script");
			var rePkg = /(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
			for (var i = 0; i < scripts.length; i++) {
				var src = scripts[i].getAttribute("src");
				if (!src) {
					continue;
				}
				var m = src.match(rePkg);
				if (m) {
					var root = src.substring(0, m.index);
					if (src.indexOf("bootstrap1") > -1) {
						root += "../";
					}
					if (!this["djConfig"]) {
						djConfig = {};
					}
					if (djConfig["baseScriptUri"] == "") {
						djConfig["baseScriptUri"] = root;
					}
					if (djConfig["baseRelativePath"] == "") {
						djConfig["baseRelativePath"] = root;
					}
					break;
				}
			}
		}
		var dr = dojo.render;
		var drh = dojo.render.html;
		var drs = dojo.render.svg;
		var dua = (drh.UA = navigator.userAgent);
		var dav = (drh.AV = navigator.appVersion);
		var t = true;
		var f = false;
		drh.capable = t;
		drh.support.builtin = t;
		dr.ver = parseFloat(drh.AV);
		dr.os.mac = dav.indexOf("Macintosh") >= 0;
		dr.os.win = dav.indexOf("Windows") >= 0;
		dr.os.linux = dav.indexOf("X11") >= 0;
		drh.opera = dua.indexOf("Opera") >= 0;
		drh.khtml = (dav.indexOf("Konqueror") >= 0) || (dav.indexOf("Safari") >= 0);
		drh.safari = dav.indexOf("Safari") >= 0;
		var geckoPos = dua.indexOf("Gecko");
		drh.mozilla = drh.moz = (geckoPos >= 0) && (!drh.khtml);
		if (drh.mozilla) {
			drh.geckoVersion = dua.substring(geckoPos + 6, geckoPos + 14);
		}
		drh.ie = (document.all) && (!drh.opera);
		drh.ie50 = drh.ie && dav.indexOf("MSIE 5.0") >= 0;
		drh.ie55 = drh.ie && dav.indexOf("MSIE 5.5") >= 0;
		drh.ie60 = drh.ie && dav.indexOf("MSIE 6.0") >= 0;
		drh.ie70 = drh.ie && dav.indexOf("MSIE 7.0") >= 0;
		var cm = document["compatMode"];
		drh.quirks = (cm == "BackCompat") || (cm == "QuirksMode") || drh.ie55 || drh.ie50;
		dojo.locale = dojo.locale || (drh.ie ? navigator.userLanguage : navigator.language).toLowerCase();
		dr.vml.capable = drh.ie;
		drs.capable = f;
		drs.support.plugin = f;
		drs.support.builtin = f;
		var tdoc = window["document"];
		var tdi = tdoc["implementation"];
		if ((tdi) && (tdi["hasFeature"]) && (tdi.hasFeature("org.w3c.dom.svg", "1.0"))) {
			drs.capable = t;
			drs.support.builtin = t;
			drs.support.plugin = f;
		}
		if (drh.safari) {
			var tmp = dua.split("AppleWebKit/")[1];
			var ver = parseFloat(tmp.split(" ")[0]);
			if (ver >= 420) {
				drs.capable = t;
				drs.support.builtin = t;
				drs.support.plugin = f;
			}
		} else {
		}
	})();
	dojo.hostenv.startPackage("dojo.hostenv");
	dojo.render.name = dojo.hostenv.name_ = "browser";
	dojo.hostenv.searchIds = [];
	dojo.hostenv._XMLHTTP_PROGIDS = ["Msxml2.XMLHTTP", "Microsoft.XMLHTTP", "Msxml2.XMLHTTP.4.0"];
	dojo.hostenv.getXmlhttpObject = function () {
		var http = null;
		var last_e = null;
		try {
			http = new XMLHttpRequest();
		}
		catch (e) {
		}
		if (!http) {
			for (var i = 0; i < 3; ++i) {
				var progid = dojo.hostenv._XMLHTTP_PROGIDS[i];
				try {
					http = new ActiveXObject(progid);
				}
				catch (e) {
					last_e = e;
				}
				if (http) {
					dojo.hostenv._XMLHTTP_PROGIDS = [progid];
					break;
				}
			}
		}
		if (!http) {
			return dojo.raise("XMLHTTP not available", last_e);
		}
		return http;
	};
	dojo.hostenv._blockAsync = false;
	dojo.hostenv.getText = function (uri, async_cb, fail_ok) {
		if (!async_cb) {
			this._blockAsync = true;
		}
		var http = this.getXmlhttpObject();
		function isDocumentOk(http) {
			var stat = http["status"];
			return Boolean((!stat) || ((200 <= stat) && (300 > stat)) || (stat == 304));
		}
		if (async_cb) {
			var _this = this, timer = null, gbl = dojo.global();
			var xhr = dojo.evalObjPath("dojo.io.XMLHTTPTransport");
			http.onreadystatechange = function () {
				if (timer) {
					gbl.clearTimeout(timer);
					timer = null;
				}
				if (_this._blockAsync || (xhr && xhr._blockAsync)) {
					timer = gbl.setTimeout(function () {
						http.onreadystatechange.apply(this);
					}, 10);
				} else {
					if (4 == http.readyState) {
						if (isDocumentOk(http)) {
							async_cb(http.responseText);
						}
					}
				}
			};
		}
		http.open("GET", uri, async_cb ? true : false);
		try {
			http.send(null);
			if (async_cb) {
				return null;
			}
			if (!isDocumentOk(http)) {
				var err = Error("Unable to load " + uri + " status:" + http.status);
				err.status = http.status;
				err.responseText = http.responseText;
				throw err;
			}
		}
		catch (e) {
			this._blockAsync = false;
			if ((fail_ok) && (!async_cb)) {
				return null;
			} else {
				throw e;
			}
		}
		this._blockAsync = false;
		return http.responseText;
	};
	dojo.hostenv.defaultDebugContainerId = "dojoDebug";
	dojo.hostenv._println_buffer = [];
	dojo.hostenv._println_safe = false;
	dojo.hostenv.println = function (line) {
		if (!dojo.hostenv._println_safe) {
			dojo.hostenv._println_buffer.push(line);
		} else {
			try {
				var console = document.getElementById(djConfig.debugContainerId ? djConfig.debugContainerId : dojo.hostenv.defaultDebugContainerId);
				if (!console) {
					console = dojo.body();
				}
				var div = document.createElement("div");
				div.appendChild(document.createTextNode(line));
				console.appendChild(div);
			}
			catch (e) {
				try {
					document.write("<div>" + line + "</div>");
				}
				catch (e2) {
					window.status = line;
				}
			}
		}
	};
	dojo.addOnLoad(function () {
		dojo.hostenv._println_safe = true;
		while (dojo.hostenv._println_buffer.length > 0) {
			dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
		}
	});
	function dj_addNodeEvtHdlr(node, evtName, fp) {
		var oldHandler = node["on" + evtName] || function () {
		};
		node["on" + evtName] = function () {
			fp.apply(node, arguments);
			oldHandler.apply(node, arguments);
		};
		return true;
	}
	dojo.hostenv._djInitFired = false;
	function dj_load_init(e) {
		dojo.hostenv._djInitFired = true;
		var type = (e && e.type) ? e.type.toLowerCase() : "load";
		if (arguments.callee.initialized || (type != "domcontentloaded" && type != "load")) {
			return;
		}
		arguments.callee.initialized = true;
		if (typeof (_timer) != "undefined") {
			clearInterval(_timer);
			delete _timer;
		}
		var initFunc = function () {
			if (dojo.render.html.ie) {
				dojo.hostenv.makeWidgets();
			}
		};
		if (dojo.hostenv.inFlightCount == 0) {
			initFunc();
			dojo.hostenv.modulesLoaded();
		} else {
			dojo.hostenv.modulesLoadedListeners.unshift(initFunc);
		}
	}
	if (document.addEventListener) {
		if (dojo.render.html.opera || (dojo.render.html.moz && (djConfig["enableMozDomContentLoaded"] === true))) {
			document.addEventListener("DOMContentLoaded", dj_load_init, null);
		}
		window.addEventListener("load", dj_load_init, null);
	}
	if (dojo.render.html.ie && dojo.render.os.win) {
		document.attachEvent("onreadystatechange", function (e) {
			if (document.readyState == "complete") {
				dj_load_init();
			}
		});
	}
	if (/(WebKit|khtml)/i.test(navigator.userAgent)) {
		var _timer = setInterval(function () {
			if (/loaded|complete/.test(document.readyState)) {
				dj_load_init();
			}
		}, 10);
	}
	if (dojo.render.html.ie) {
		dj_addNodeEvtHdlr(window, "beforeunload", function () {
			dojo.hostenv._unloading = true;
			window.setTimeout(function () {
				dojo.hostenv._unloading = false;
			}, 0);
		});
	}
	dj_addNodeEvtHdlr(window, "unload", function () {
		dojo.hostenv.unloaded();
		if ((!dojo.render.html.ie) || (dojo.render.html.ie && dojo.hostenv._unloading)) {
			dojo.hostenv.unloaded();
		}
	});
	dojo.hostenv.makeWidgets = function () {
		var sids = [];
		if (djConfig.searchIds && djConfig.searchIds.length > 0) {
			sids = sids.concat(djConfig.searchIds);
		}
		if (dojo.hostenv.searchIds && dojo.hostenv.searchIds.length > 0) {
			sids = sids.concat(dojo.hostenv.searchIds);
		}
		if ((djConfig.parseWidgets) || (sids.length > 0)) {
			if (dojo.evalObjPath("dojo.widget.Parse")) {
				var parser = new dojo.xml.Parse();
				if (sids.length > 0) {
					for (var x = 0; x < sids.length; x++) {
						var tmpNode = document.getElementById(sids[x]);
						if (!tmpNode) {
							continue;
						}
						var frag = parser.parseElement(tmpNode, null, true);
						dojo.widget.getParser().createComponents(frag);
					}
				} else {
					if (djConfig.parseWidgets) {
						var frag = parser.parseElement(dojo.body(), null, true);
						dojo.widget.getParser().createComponents(frag);
					}
				}
			}
		}
	};
	dojo.addOnLoad(function () {
		if (!dojo.render.html.ie) {
			dojo.hostenv.makeWidgets();
		}
	});
	try {
		if (dojo.render.html.ie) {
			document.namespaces.add("v", "urn:schemas-microsoft-com:vml");
			document.createStyleSheet().addRule("v\\:*", "behavior:url(#default#VML)");
		}
	}
	catch (e) {
	}
	dojo.hostenv.writeIncludes = function () {
	};
	if (!dj_undef("document", this)) {
		dj_currentDocument = this.document;
	}
	dojo.doc = function () {
		return dj_currentDocument;
	};
	dojo.body = function () {
		return dojo.doc().body || dojo.doc().getElementsByTagName("body")[0];
	};
	dojo.byId = function (id, doc) {
		if ((id) && ((typeof id == "string") || (id instanceof String))) {
			if (!doc) {
				doc = dj_currentDocument;
			}
			var ele = doc.getElementById(id);
			if (ele && (ele.id != id) && doc.all) {
				ele = null;
				eles = doc.all[id];
				if (eles) {
					if (eles.length) {
						for (var i = 0; i < eles.length; i++) {
							if (eles[i].id == id) {
								ele = eles[i];
								break;
							}
						}
					} else {
						ele = eles;
					}
				}
			}
			return ele;
		}
		return id;
	};
	dojo.setContext = function (globalObject, globalDocument) {
		dj_currentContext = globalObject;
		dj_currentDocument = globalDocument;
	};
	dojo._fireCallback = function (callback, context, cbArguments) {
		if ((context) && ((typeof callback == "string") || (callback instanceof String))) {
			callback = context[callback];
		}
		return (context ? callback.apply(context, cbArguments || []) : callback());
	};
	dojo.withGlobal = function (globalObject, callback, thisObject, cbArguments) {
		var rval;
		var oldGlob = dj_currentContext;
		var oldDoc = dj_currentDocument;
		try {
			dojo.setContext(globalObject, globalObject.document);
			rval = dojo._fireCallback(callback, thisObject, cbArguments);
		}
		finally {
			dojo.setContext(oldGlob, oldDoc);
		}
		return rval;
	};
	dojo.withDoc = function (documentObject, callback, thisObject, cbArguments) {
		var rval;
		var oldDoc = dj_currentDocument;
		try {
			dj_currentDocument = documentObject;
			rval = dojo._fireCallback(callback, thisObject, cbArguments);
		}
		finally {
			dj_currentDocument = oldDoc;
		}
		return rval;
	};
}
dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");
dojo.requireIf(djConfig["debugAtAllCosts"] && !window.widget && !djConfig["useXDomain"], "dojo.browser_debug");
dojo.requireIf(djConfig["debugAtAllCosts"] && !window.widget && djConfig["useXDomain"], "dojo.browser_debug_xd");


__CPAN_FILE__ src/Deferred.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.Deferred"], ["require", "dojo.lang.func"]], definePackage:function (dojo) {
	dojo.provide("dojo.Deferred");
	dojo.require("dojo.lang.func");
	dojo.Deferred = function (canceller) {
		this.chain = [];
		this.id = this._nextId();
		this.fired = -1;
		this.paused = 0;
		this.results = [null, null];
		this.canceller = canceller;
		this.silentlyCancelled = false;
	};
	dojo.lang.extend(dojo.Deferred, {getFunctionFromArgs:function () {
		var a = arguments;
		if ((a[0]) && (!a[1])) {
			if (dojo.lang.isFunction(a[0])) {
				return a[0];
			} else {
				if (dojo.lang.isString(a[0])) {
					return dj_global[a[0]];
				}
			}
		} else {
			if ((a[0]) && (a[1])) {
				return dojo.lang.hitch(a[0], a[1]);
			}
		}
		return null;
	}, makeCalled:function () {
		var deferred = new dojo.Deferred();
		deferred.callback();
		return deferred;
	}, repr:function () {
		var state;
		if (this.fired == -1) {
			state = "unfired";
		} else {
			if (this.fired == 0) {
				state = "success";
			} else {
				state = "error";
			}
		}
		return "Deferred(" + this.id + ", " + state + ")";
	}, toString:dojo.lang.forward("repr"), _nextId:(function () {
		var n = 1;
		return function () {
			return n++;
		};
	})(), cancel:function () {
		if (this.fired == -1) {
			if (this.canceller) {
				this.canceller(this);
			} else {
				this.silentlyCancelled = true;
			}
			if (this.fired == -1) {
				this.errback(new Error(this.repr()));
			}
		} else {
			if ((this.fired == 0) && (this.results[0] instanceof dojo.Deferred)) {
				this.results[0].cancel();
			}
		}
	}, _pause:function () {
		this.paused++;
	}, _unpause:function () {
		this.paused--;
		if ((this.paused == 0) && (this.fired >= 0)) {
			this._fire();
		}
	}, _continue:function (res) {
		this._resback(res);
		this._unpause();
	}, _resback:function (res) {
		this.fired = ((res instanceof Error) ? 1 : 0);
		this.results[this.fired] = res;
		this._fire();
	}, _check:function () {
		if (this.fired != -1) {
			if (!this.silentlyCancelled) {
				dojo.raise("already called!");
			}
			this.silentlyCancelled = false;
			return;
		}
	}, callback:function (res) {
		this._check();
		this._resback(res);
	}, errback:function (res) {
		this._check();
		if (!(res instanceof Error)) {
			res = new Error(res);
		}
		this._resback(res);
	}, addBoth:function (cb, cbfn) {
		var enclosed = this.getFunctionFromArgs(cb, cbfn);
		if (arguments.length > 2) {
			enclosed = dojo.lang.curryArguments(null, enclosed, arguments, 2);
		}
		return this.addCallbacks(enclosed, enclosed);
	}, addCallback:function (cb, cbfn) {
		var enclosed = this.getFunctionFromArgs(cb, cbfn);
		if (arguments.length > 2) {
			enclosed = dojo.lang.curryArguments(null, enclosed, arguments, 2);
		}
		return this.addCallbacks(enclosed, null);
	}, addErrback:function (cb, cbfn) {
		var enclosed = this.getFunctionFromArgs(cb, cbfn);
		if (arguments.length > 2) {
			enclosed = dojo.lang.curryArguments(null, enclosed, arguments, 2);
		}
		return this.addCallbacks(null, enclosed);
		return this.addCallbacks(null, cbfn);
	}, addCallbacks:function (cb, eb) {
		this.chain.push([cb, eb]);
		if (this.fired >= 0) {
			this._fire();
		}
		return this;
	}, _fire:function () {
		var chain = this.chain;
		var fired = this.fired;
		var res = this.results[fired];
		var self = this;
		var cb = null;
		while (chain.length > 0 && this.paused == 0) {
			var pair = chain.shift();
			var f = pair[fired];
			if (f == null) {
				continue;
			}
			try {
				res = f(res);
				fired = ((res instanceof Error) ? 1 : 0);
				if (res instanceof dojo.Deferred) {
					cb = function (res) {
						self._continue(res);
					};
					this._pause();
				}
			}
			catch (err) {
				fired = 1;
				res = err;
			}
		}
		this.fired = fired;
		this.results[fired] = res;
		if ((cb) && (this.paused)) {
			res.addBoth(cb);
		}
	}});
}});


__CPAN_FILE__ src/iCalendar.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.require("dojo.cal.iCalendar");
dojo.deprecated("dojo.icalendar", "use dojo.cal.iCalendar isntead", "0.5");


__CPAN_FILE__ src/profile.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.profile"]], definePackage:function (dojo) {
	dojo.provide("dojo.profile");
	dojo.profile = {_profiles:{}, _pns:[], start:function (name) {
		if (!this._profiles[name]) {
			this._profiles[name] = {iters:0, total:0};
			this._pns[this._pns.length] = name;
		} else {
			if (this._profiles[name]["start"]) {
				this.end(name);
			}
		}
		this._profiles[name].end = null;
		this._profiles[name].start = new Date();
	}, end:function (name) {
		var ed = new Date();
		if ((this._profiles[name]) && (this._profiles[name]["start"])) {
			with (this._profiles[name]) {
				end = ed;
				total += (end - start);
				start = null;
				iters++;
			}
		} else {
			return true;
		}
	}, dump:function (appendToDoc) {
		var tbl = document.createElement("table");
		with (tbl.style) {
			border = "1px solid black";
			borderCollapse = "collapse";
		}
		var hdr = tbl.createTHead();
		var hdrtr = hdr.insertRow(0);
		var cols = ["Identifier", "Calls", "Total", "Avg"];
		for (var x = 0; x < cols.length; x++) {
			var ntd = hdrtr.insertCell(x);
			with (ntd.style) {
				backgroundColor = "#225d94";
				color = "white";
				borderBottom = "1px solid black";
				borderRight = "1px solid black";
				fontFamily = "tahoma";
				fontWeight = "bolder";
				paddingLeft = paddingRight = "5px";
			}
			ntd.appendChild(document.createTextNode(cols[x]));
		}
		for (var x = 0; x < this._pns.length; x++) {
			var prf = this._profiles[this._pns[x]];
			this.end(this._pns[x]);
			if (prf.iters > 0) {
				var bdytr = tbl.insertRow(true);
				var vals = [this._pns[x], prf.iters, prf.total, parseInt(prf.total / prf.iters)];
				for (var y = 0; y < vals.length; y++) {
					var cc = bdytr.insertCell(y);
					cc.appendChild(document.createTextNode(vals[y]));
					with (cc.style) {
						borderBottom = "1px solid gray";
						paddingLeft = paddingRight = "5px";
						if (x % 2) {
							backgroundColor = "#e1f1ff";
						}
						if (y > 0) {
							textAlign = "right";
							borderRight = "1px solid gray";
						} else {
							borderRight = "1px solid black";
						}
					}
				}
			}
		}
		if (appendToDoc) {
			var ne = document.createElement("div");
			ne.id = "profileOutputTable";
			with (ne.style) {
				fontFamily = "Courier New, monospace";
				fontSize = "12px";
				lineHeight = "16px";
				borderTop = "1px solid black";
				padding = "10px";
			}
			if (document.getElementById("profileOutputTable")) {
				dojo.body().replaceChild(ne, document.getElementById("profileOutputTable"));
			} else {
				dojo.body().appendChild(ne);
			}
			ne.appendChild(tbl);
		}
		return tbl;
	}};
	dojo.profile.stop = dojo.profile.end;
}});


__CPAN_FILE__ src/loader.xd.js
dojo.hostenv.packageLoaded({
depends: [["require", ],
["kwCompoundRequire", {
//		browser: [
//			["foo.bar.baz", true, true], // an example that passes multiple args to loadModule(],
["require", ],
["require", ],
["require", ],
["require", ],
["provide", ],
["provide", "dojo.foo"],
["provide", ],
["provide", ],
["provide", "dojo.html.common"],
["provide", ]],
definePackage: function(dojo){/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
 * loader.js - A bootstrap module.  Runs before the hostenv_*.js file. Contains all of the package loading methods.
 */

//A semi-colon is at the start of the line because after doing a build, this function definition
//get compressed onto the same line as the last line in bootstrap1.js. That list line is just a
//curly bracket, and the browser complains about that syntax. The semicolon fixes it. Putting it
//here instead of at the end of bootstrap1.js, since it is more of an issue for this file, (using
//the closure), and bootstrap1.js could change in the future.
;(function(){
	//Additional properties for dojo.hostenv
	var _addHostEnv = {
		pkgFileName: "__package__",
	
		// for recursion protection
		loading_modules_: {},
		loaded_modules_: {},
		addedToLoadingCount: [],
		removedFromLoadingCount: [],
	
		inFlightCount: 0,
	
		// FIXME: it should be possible to pull module prefixes in from djConfig
		modulePrefixes_: {
			dojo: {name: "dojo", value: "src"}
		},

		setModulePrefix: function(/*String*/module, /*String*/prefix){
			// summary: establishes module/prefix pair
			this.modulePrefixes_[module] = {name: module, value: prefix};
		},

		moduleHasPrefix: function(/*String*/module){
			// summary: checks to see if module has been established
			var mp = this.modulePrefixes_;
			return Boolean(mp[module] && mp[module].value); // Boolean
		},

		getModulePrefix: function(/*String*/module){
			// summary: gets the prefix associated with module
			if(this.moduleHasPrefix(module)){
				return this.modulePrefixes_[module].value; // String
			}
			return module; // String
		},

		getTextStack: [],
		loadUriStack: [],
		loadedUris: [],
	
		//WARNING: This variable is referenced by packages outside of bootstrap: FloatingPane.js and undo/browser.js
		post_load_: false,
		
		//Egad! Lots of test files push on this directly instead of using dojo.addOnLoad.
		modulesLoadedListeners: [],
		unloadListeners: [],
		loadNotifying: false
	};
	
	//Add all of these properties to dojo.hostenv
	for(var param in _addHostEnv){
		dojo.hostenv[param] = _addHostEnv[param];
	}
})();

dojo.hostenv.loadPath = function(/*String*/relpath, /*String?*/module, /*Function?*/cb){
// summary:
//	Load a Javascript module given a relative path
//
// description:
//	Loads and interprets the script located at relpath, which is relative to the
//	script root directory.  If the script is found but its interpretation causes
//	a runtime exception, that exception is not caught by us, so the caller will
//	see it.  We return a true value if and only if the script is found.
//
//	For now, we do not have an implementation of a true search path.  We
//	consider only the single base script uri, as returned by getBaseScriptUri().
//
// relpath: A relative path to a script (no leading '/', and typically
// 	ending in '.js').
// module: A module whose existance to check for after loading a path.
//	Can be used to determine success or failure of the load.
// cb: a callback function to pass the result of evaluating the script

	var uri;
	if(relpath.charAt(0) == '/' || relpath.match(/^\w+:/)){
		// dojo.raise("relpath '" + relpath + "'; must be relative");
		uri = relpath;
	}else{
		uri = this.getBaseScriptUri() + relpath;
	}
	if(djConfig.cacheBust && dojo.render.html.capable){
		uri += "?" + String(djConfig.cacheBust).replace(/\W+/g,"");
	}
	try{
		return !module ? this.loadUri(uri, cb) : this.loadUriAndCheck(uri, module, cb); // Boolean
	}catch(e){
		dojo.debug(e);
		return false; // Boolean
	}
}

dojo.hostenv.loadUri = function(/*String (URL)*/uri, /*Function?*/cb){
// summary:
//	Loads JavaScript from a URI
//
// description:
//	Reads the contents of the URI, and evaluates the contents.  This is used to load modules as well
//	as resource bundles.  Returns true if it succeeded. Returns false if the URI reading failed.
//	Throws if the evaluation throws.
//
// uri: a uri which points at the script to be loaded
// cb: a callback function to process the result of evaluating the script as an expression, typically
//	used by the resource bundle loader to load JSON-style resources

	if(this.loadedUris[uri]){
		return true; // Boolean
	}
	var contents = this.getText(uri, null, true);
	if(!contents){ return false; } // Boolean
	this.loadedUris[uri] = true;
	if(cb){ contents = '('+contents+')'; }
	var value = dj_eval(contents);
	if(cb){ cb(value); }
	return true; // Boolean
}

// FIXME: probably need to add logging to this method
dojo.hostenv.loadUriAndCheck = function(/*String (URL)*/uri, /*String*/moduleName, /*Function?*/cb){
	// summary: calls loadUri then findModule and returns true if both succeed
	var ok = true;
	try{
		ok = this.loadUri(uri, cb);
	}catch(e){
		dojo.debug("failed loading ", uri, " with error: ", e);
	}
	return Boolean(ok && this.findModule(moduleName, false)); // Boolean
}

dojo.loaded = function(){ }
dojo.unloaded = function(){ }

dojo.hostenv.loaded = function(){
	this.loadNotifying = true;
	this.post_load_ = true;
	var mll = this.modulesLoadedListeners;
	for(var x=0; x<mll.length; x++){
		mll[x]();
	}

	//Clear listeners so new ones can be added
	//For other xdomain package loads after the initial load.
	this.modulesLoadedListeners = [];
	this.loadNotifying = false;

	dojo.loaded();
}

dojo.hostenv.unloaded = function(){
	var mll = this.unloadListeners;
	while(mll.length){
		(mll.pop())();
	}
	dojo.unloaded();
}

dojo.addOnLoad = function(/*Object?*/obj, /*String|Function*/functionName) {
// summary:
//	Registers a function to be triggered after the DOM has finished loading 
//	and widgets declared in markup have been instantiated.  Images and CSS files
//	may or may not have finished downloading when the specified function is called.
//	(Note that widgets' CSS and HTML code is guaranteed to be downloaded before said
//	widgets are instantiated.)
//
// usage:
//	dojo.addOnLoad(functionPointer)
//	dojo.addOnLoad(object, "functionName")

	var dh = dojo.hostenv;
	if(arguments.length == 1) {
		dh.modulesLoadedListeners.push(obj);
	} else if(arguments.length > 1) {
		dh.modulesLoadedListeners.push(function() {
			obj[functionName]();
		});
	}

	//Added for xdomain loading. dojo.addOnLoad is used to
	//indicate callbacks after doing some dojo.require() statements.
	//In the xdomain case, if all the requires are loaded (after initial
	//page load), then immediately call any listeners.
	if(dh.post_load_ && dh.inFlightCount == 0 && !dh.loadNotifying){
		dh.callLoaded();
	}
}

dojo.addOnUnload = function(/*Object?*/obj, /*String|Function?*/functionName){
// summary: registers a function to be triggered when the page unloads
//
// usage:
//	dojo.addOnLoad(functionPointer)
//	dojo.addOnLoad(object, "functionName")
	var dh = dojo.hostenv;
	if(arguments.length == 1){
		dh.unloadListeners.push(obj);
	} else if(arguments.length > 1) {
		dh.unloadListeners.push(function() {
			obj[functionName]();
		});
	}
}

dojo.hostenv.modulesLoaded = function(){
	if(this.post_load_){ return; }
	if(this.loadUriStack.length==0 && this.getTextStack.length==0){
		if(this.inFlightCount > 0){ 
			dojo.debug("files still in flight!");
			return;
		}
		dojo.hostenv.callLoaded();
	}
}

dojo.hostenv.callLoaded = function(){
	//The "object" check is for IE, and the other opera check fixes an issue
	//in Opera where it could not find the body element in some widget test cases.
	//For 0.9, maybe route all browsers through the setTimeout (need protection
	//still for non-browser environments though). This might also help the issue with
	//FF 2.0 and freezing issues where we try to do sync xhr while background css images
	//are being loaded (trac #2572)? Consider for 0.9.
	if(typeof setTimeout == "object" || (djConfig["useXDomain"] && dojo.render.html.opera)){
		setTimeout("dojo.hostenv.loaded();", 0);
	}else{
		dojo.hostenv.loaded();
	}
}

dojo.hostenv.getModuleSymbols = function(/*String*/modulename){
// summary:
//	Converts a module name in dotted JS notation to an array representing the path in the source tree
	var syms = modulename.split(".");
	for(var i = syms.length; i>0; i--){
		var parentModule = syms.slice(0, i).join(".");
		if((i==1) && !this.moduleHasPrefix(parentModule)){		
			// Support default module directory (sibling of dojo) for top-level modules 
			syms[0] = "../" + syms[0];
		}else{
			var parentModulePath = this.getModulePrefix(parentModule);
			if(parentModulePath != parentModule){
				syms.splice(0, i, parentModulePath);
				break;
			}
		}
	}
	return syms; // Array
}

dojo.hostenv._global_omit_module_check = false;
dojo.hostenv.loadModule = function(/*String*/moduleName, /*Boolean?*/exactOnly, /*Boolean?*/omitModuleCheck){
// summary:
//	loads a Javascript module from the appropriate URI
//
// description:
//	loadModule("A.B") first checks to see if symbol A.B is defined. 
//	If it is, it is simply returned (nothing to do).
//	
//	If it is not defined, it will look for "A/B.js" in the script root directory,
//	followed by "A.js".
//	
//	It throws if it cannot find a file to load, or if the symbol A.B is not
//	defined after loading.
//	
//	It returns the object A.B.
//	
//	This does nothing about importing symbols into the current package.
//	It is presumed that the caller will take care of that. For example, to import
//	all symbols:
//	
//	   with (dojo.hostenv.loadModule("A.B")) {
//	      ...
//	   }
//	
//	And to import just the leaf symbol:
//	
//	   var B = dojo.hostenv.loadModule("A.B");
//	   ...
//	
//	dj_load is an alias for dojo.hostenv.loadModule

	if(!moduleName){ return; }
	omitModuleCheck = this._global_omit_module_check || omitModuleCheck;
	var module = this.findModule(moduleName, false);
	if(module){
		return module;
	}

	// protect against infinite recursion from mutual dependencies
	if(dj_undef(moduleName, this.loading_modules_)){
		this.addedToLoadingCount.push(moduleName);
	}
	this.loading_modules_[moduleName] = 1;

	// convert periods to slashes
	var relpath = moduleName.replace(/\./g, '/') + '.js';

	var nsyms = moduleName.split(".");
	
	// this line allowed loading of a module manifest as if it were a namespace
	// it's an interesting idea, but shouldn't be combined with 'namespaces' proper
	// and leads to unwanted dependencies
	// the effect can be achieved in other (albeit less-flexible) ways now, so I am
	// removing this pending further design work
	// perhaps we can explicitly define this idea of a 'module manifest', and subclass
	// 'namespace manifest' from that
	//dojo.getNamespace(nsyms[0]);

	var syms = this.getModuleSymbols(moduleName);
	var startedRelative = ((syms[0].charAt(0) != '/') && !syms[0].match(/^\w+:/));
	var last = syms[syms.length - 1];
	var ok;
	// figure out if we're looking for a full package, if so, we want to do
	// things slightly diffrently
	if(last=="*"){
		moduleName = nsyms.slice(0, -1).join('.');
		while(syms.length){
			syms.pop();
			syms.push(this.pkgFileName);
			relpath = syms.join("/") + '.js';
			if(startedRelative && relpath.charAt(0)=="/"){
				relpath = relpath.slice(1);
			}
			ok = this.loadPath(relpath, !omitModuleCheck ? moduleName : null);
			if(ok){ break; }
			syms.pop();
		}
	}else{
		relpath = syms.join("/") + '.js';
		moduleName = nsyms.join('.');
		var modArg = !omitModuleCheck ? moduleName : null;
		ok = this.loadPath(relpath, modArg);
		if(!ok && !exactOnly){
			syms.pop();
			while(syms.length){
				relpath = syms.join('/') + '.js';
				ok = this.loadPath(relpath, modArg);
				if(ok){ break; }
				syms.pop();
				relpath = syms.join('/') + '/'+this.pkgFileName+'.js';
				if(startedRelative && relpath.charAt(0)=="/"){
					relpath = relpath.slice(1);
				}
				ok = this.loadPath(relpath, modArg);
				if(ok){ break; }
			}
		}

		if(!ok && !omitModuleCheck){
			dojo.raise("Could not load '" + moduleName + "'; last tried '" + relpath + "'");
		}
	}

	// check that the symbol was defined
	//Don't bother if we're doing xdomain (asynchronous) loading.
	if(!omitModuleCheck && !this["isXDomain"]){
		// pass in false so we can give better error
		module = this.findModule(moduleName, false);
		if(!module){
			dojo.raise("symbol '" + moduleName + "' is not defined after loading '" + relpath + "'"); 
		}
	}

	return module;
}

dojo.hostenv.startPackage = function(/*String*/packageName){
// summary:
//	Creates a JavaScript package
//
// description:
//	startPackage("A.B") follows the path, and at each level creates a new empty
//	object or uses what already exists. It returns the result.
//
// packageName: the package to be created as a String in dot notation

	//Make sure we have a string.
	var fullPkgName = String(packageName);
	var strippedPkgName = fullPkgName;

	var syms = packageName.split(/\./);
	if(syms[syms.length-1]=="*"){
		syms.pop();
		strippedPkgName = syms.join(".");
	}
	var evaledPkg = dojo.evalObjPath(strippedPkgName, true);
	this.loaded_modules_[fullPkgName] = evaledPkg;
	this.loaded_modules_[strippedPkgName] = evaledPkg;
	
	return evaledPkg; // Object
}

dojo.hostenv.findModule = function(/*String*/moduleName, /*Boolean?*/mustExist){
// summary:
//	Returns the Object representing the module, if it exists, otherwise null.
//
// moduleName A fully qualified module including package name, like 'A.B'.
// mustExist Optional, default false. throw instead of returning null
//	if the module does not currently exist.

	var lmn = String(moduleName);

	if(this.loaded_modules_[lmn]){
		return this.loaded_modules_[lmn]; // Object
	}

	if(mustExist){
		dojo.raise("no loaded module named '" + moduleName + "'");
	}
	return null; // null
}

//Start of old bootstrap2:

dojo.kwCompoundRequire = function(/*Object containing Arrays*/modMap){
// description:
//	This method taks a "map" of arrays which one can use to optionally load dojo
//	modules. The map is indexed by the possible dojo.hostenv.name_ values, with
//	two additional values: "default" and "common". The items in the "default"
//	array will be loaded if none of the other items have been choosen based on
//	the hostenv.name_ item. The items in the "common" array will _always_ be
//	loaded, regardless of which list is chosen.  Here's how it's normally
//	called:
//	
//	dojo.kwCompoundRequire({
//		browser: [
//			["foo.bar.baz", true, true], // an example that passes multiple args to loadModule()
//			"foo.sample.*",
//			"foo.test,
//		],
//		default: [ "foo.sample.*" ],
//		common: [ "really.important.module.*" ]
//	});

	var common = modMap["common"]||[];
	var result = modMap[dojo.hostenv.name_] ? common.concat(modMap[dojo.hostenv.name_]||[]) : common.concat(modMap["default"]||[]);

	for(var x=0; x<result.length; x++){
		var curr = result[x];
		if(curr.constructor == Array){
			dojo.hostenv.loadModule.apply(dojo.hostenv, curr);
		}else{
			dojo.hostenv.loadModule(curr);
		}
	}
}

dojo.require = function(/*String*/ resourceName){
	// summary
	//	Ensure that the given resource (ie, javascript
	//	source file) has been loaded.
	// description
	//	dojo.require() is similar to C's #include command or java's "import" command.
	//	You call dojo.require() to pull in the resources (ie, javascript source files)
	//	that define the functions you are using. 
	//
	//	Note that in the case of a build, many resources have already been included
	//	into dojo.js (ie, many of the javascript source files have been compressed and
	//	concatened into dojo.js), so many dojo.require() calls will simply return
	//	without downloading anything.
	dojo.hostenv.loadModule.apply(dojo.hostenv, arguments);
}

dojo.requireIf = function(/*Boolean*/ condition, /*String*/ resourceName){
	// summary
	//	If the condition is true then call dojo.require() for the specified resource
	var arg0 = arguments[0];
	if((arg0 === true)||(arg0=="common")||(arg0 && dojo.render[arg0].capable)){
		var args = [];
		for (var i = 1; i < arguments.length; i++) { args.push(arguments[i]); }
		dojo.require.apply(dojo, args);
	}
}

dojo.requireAfterIf = dojo.requireIf;

dojo.provide = function(/*String*/ resourceName){
	// summary
	//	Each javascript source file must have (exactly) one dojo.provide()
	//	call at the top of the file, corresponding to the file name.
	//	For example, dojo/src/foo.js must have dojo.provide("dojo.foo"); at the top of the file.
	//
	// description
	//	Each javascript source file is called a resource.  When a resource
	//	is loaded by the browser, dojo.provide() registers that it has
	//	been loaded.
	//	
	//	For backwards compatibility reasons, in addition to registering the resource,
	//	dojo.provide() also ensures that the javascript object for the module exists.  For
	//	example, dojo.provide("dojo.html.common"), in addition to registering that common.js
	//	is a resource for the dojo.html module, will ensure that the dojo.html javascript object
	//	exists, so that calls like dojo.html.foo = function(){ ... } don't fail.
	//
	//	In the case of a build (or in the future, a rollup), where multiple javascript source
	//	files are combined into one bigger file (similar to a .lib or .jar file), that file
	//	will contain multiple dojo.provide() calls, to note that it includes
	//	multiple resources.
	return dojo.hostenv.startPackage.apply(dojo.hostenv, arguments);
}

dojo.registerModulePath = function(/*String*/module, /*String*/prefix){
	// summary: maps a module name to a path
	// description: An unregistered module is given the default path of ../<module>,
	//	relative to Dojo root. For example, module acme is mapped to ../acme.
	//	If you want to use a different module name, use dojo.registerModulePath. 
	return dojo.hostenv.setModulePrefix(module, prefix);
}

if(djConfig["modulePaths"]){
	for(var param in djConfig["modulePaths"]){
		dojo.registerModulePath(param, djConfig["modulePaths"][param]);
	}
}

dojo.setModulePrefix = function(/*String*/module, /*String*/prefix){
	// summary: maps a module name to a path
	dojo.deprecated('dojo.setModulePrefix("' + module + '", "' + prefix + '")', "replaced by dojo.registerModulePath", "0.5");
	return dojo.registerModulePath(module, prefix);
}

dojo.exists = function(/*Object*/obj, /*String*/name){
	// summary: determine if an object supports a given method
	// description: useful for longer api chains where you have to test each object in the chain
	var p = name.split(".");
	for(var i = 0; i < p.length; i++){
		if(!obj[p[i]]){ return false; } // Boolean
		obj = obj[p[i]];
	}
	return true; // Boolean
}

// Localization routines

dojo.hostenv.normalizeLocale = function(/*String?*/locale){
//	summary:
//		Returns canonical form of locale, as used by Dojo.  All variants are case-insensitive and are separated by '-'
//		as specified in RFC 3066. If no locale is specified, the user agent's default is returned.

	var result = locale ? locale.toLowerCase() : dojo.locale;
	if(result == "root"){
		result = "ROOT";
	}
	return result;// String
};

dojo.hostenv.searchLocalePath = function(/*String*/locale, /*Boolean*/down, /*Function*/searchFunc){
//	summary:
//		A helper method to assist in searching for locale-based resources.  Will iterate through
//		the variants of a particular locale, either up or down, executing a callback function.
//		For example, "en-us" and true will try "en-us" followed by "en" and finally "ROOT".

	locale = dojo.hostenv.normalizeLocale(locale);

	var elements = locale.split('-');
	var searchlist = [];
	for(var i = elements.length; i > 0; i--){
		searchlist.push(elements.slice(0, i).join('-'));
	}
	searchlist.push(false);
	if(down){searchlist.reverse();}

	for(var j = searchlist.length - 1; j >= 0; j--){
		var loc = searchlist[j] || "ROOT";
		var stop = searchFunc(loc);
		if(stop){ break; }
	}
}

//These two functions are placed outside of preloadLocalizations
//So that the xd loading can use/override them.
dojo.hostenv.localesGenerated /***BUILD:localesGenerated***/; // value will be inserted here at build time, if necessary

dojo.hostenv.registerNlsPrefix = function(){
// summary:
//	Register module "nls" to point where Dojo can find pre-built localization files
	dojo.registerModulePath("nls","nls");	
}

dojo.hostenv.preloadLocalizations = function(){
// summary:
//	Load built, flattened resource bundles, if available for all locales used in the page.
//	Execute only once.  Note that this is a no-op unless there is a build.

	if(dojo.hostenv.localesGenerated){
		dojo.hostenv.registerNlsPrefix();

		function preload(locale){
			locale = dojo.hostenv.normalizeLocale(locale);
			dojo.hostenv.searchLocalePath(locale, true, function(loc){
				for(var i=0; i<dojo.hostenv.localesGenerated.length;i++){
					if(dojo.hostenv.localesGenerated[i] == loc){
						dojo["require"]("nls.dojo_"+loc);
						return true; // Boolean
					}
				}
				return false; // Boolean
			});
		}
		preload();
		var extra = djConfig.extraLocale||[];
		for(var i=0; i<extra.length; i++){
			preload(extra[i]);
		}
	}
	dojo.hostenv.preloadLocalizations = function(){};
}

dojo.requireLocalization = function(/*String*/moduleName, /*String*/bundleName, /*String?*/locale, /*String?*/availableFlatLocales){
// summary:
//	Declares translated resources and loads them if necessary, in the same style as dojo.require.
//	Contents of the resource bundle are typically strings, but may be any name/value pair,
//	represented in JSON format.  See also dojo.i18n.getLocalization.
//
// moduleName: name of the package containing the "nls" directory in which the bundle is found
// bundleName: bundle name, i.e. the filename without the '.js' suffix
// locale: the locale to load (optional)  By default, the browser's user locale as defined by dojo.locale
// availableFlatLocales: A comma-separated list of the available, flattened locales for this bundle.
// This argument should only be set by the build process.
//
// description:
//	Load translated resource bundles provided underneath the "nls" directory within a package.
//	Translated resources may be located in different packages throughout the source tree.  For example,
//	a particular widget may define one or more resource bundles, structured in a program as follows,
//	where moduleName is mycode.mywidget and bundleNames available include bundleone and bundletwo:
//	...
//	mycode/
//	 mywidget/
//	  nls/
//	   bundleone.js (the fallback translation, English in this example)
//	   bundletwo.js (also a fallback translation)
//	   de/
//	    bundleone.js
//	    bundletwo.js
//	   de-at/
//	    bundleone.js
//	   en/
//	    (empty; use the fallback translation)
//	   en-us/
//	    bundleone.js
//	   en-gb/
//	    bundleone.js
//	   es/
//	    bundleone.js
//	    bundletwo.js
//	  ...etc
//	...
//	Each directory is named for a locale as specified by RFC 3066, (http://www.ietf.org/rfc/rfc3066.txt),
//	normalized in lowercase.  Note that the two bundles in the example do not define all the same variants.
//	For a given locale, bundles will be loaded for that locale and all more general locales above it, including
//	a fallback at the root directory.  For example, a declaration for the "de-at" locale will first
//	load nls/de-at/bundleone.js, then nls/de/bundleone.js and finally nls/bundleone.js.  The data will
//	be flattened into a single Object so that lookups will follow this cascading pattern.  An optional build
//	step can preload the bundles to avoid data redundancy and the multiple network hits normally required to
//	load these resources.

	dojo.hostenv.preloadLocalizations();
	var targetLocale = dojo.hostenv.normalizeLocale(locale);
 	var bundlePackage = [moduleName, "nls", bundleName].join(".");
//NOTE: When loading these resources, the packaging does not match what is on disk.  This is an
// implementation detail, as this is just a private data structure to hold the loaded resources.
// e.g. tests/hello/nls/en-us/salutations.js is loaded as the object tests.hello.nls.salutations.en_us={...}
// The structure on disk is intended to be most convenient for developers and translators, but in memory
// it is more logical and efficient to store in a different order.  Locales cannot use dashes, since the
// resulting path will not evaluate as valid JS, so we translate them to underscores.
	
	//Find the best-match locale to load if we have available flat locales.
	var bestLocale = "";
	if(availableFlatLocales){
		var flatLocales = availableFlatLocales.split(",");
		for(var i = 0; i < flatLocales.length; i++){
			//Locale must match from start of string.
			if(targetLocale.indexOf(flatLocales[i]) == 0){
				if(flatLocales[i].length > bestLocale.length){
					bestLocale = flatLocales[i];
				}
			}
		}
		if(!bestLocale){
			bestLocale = "ROOT";
		}		
	}

	//See if the desired locale is already loaded.
	var tempLocale = availableFlatLocales ? bestLocale : targetLocale;
	var bundle = dojo.hostenv.findModule(bundlePackage);
	var localizedBundle = null;
	if(bundle){
		if(djConfig.localizationComplete && bundle._built){return;}
		var jsLoc = tempLocale.replace('-', '_');
		var translationPackage = bundlePackage+"."+jsLoc;
		localizedBundle = dojo.hostenv.findModule(translationPackage);
	}

	if(!localizedBundle){
		bundle = dojo.hostenv.startPackage(bundlePackage);
		var syms = dojo.hostenv.getModuleSymbols(moduleName);
		var modpath = syms.concat("nls").join("/");
		var parent;

		dojo.hostenv.searchLocalePath(tempLocale, availableFlatLocales, function(loc){
			var jsLoc = loc.replace('-', '_');
			var translationPackage = bundlePackage + "." + jsLoc;
			var loaded = false;
			if(!dojo.hostenv.findModule(translationPackage)){
				// Mark loaded whether it's found or not, so that further load attempts will not be made
				dojo.hostenv.startPackage(translationPackage);
				var module = [modpath];
				if(loc != "ROOT"){module.push(loc);}
				module.push(bundleName);
				var filespec = module.join("/") + '.js';
				loaded = dojo.hostenv.loadPath(filespec, null, function(hash){
					// Use singleton with prototype to point to parent bundle, then mix-in result from loadPath
					var clazz = function(){};
					clazz.prototype = parent;
					bundle[jsLoc] = new clazz();
					for(var j in hash){ bundle[jsLoc][j] = hash[j]; }
				});
			}else{
				loaded = true;
			}
			if(loaded && bundle[jsLoc]){
				parent = bundle[jsLoc];
			}else{
				bundle[jsLoc] = parent;
			}
			
			if(availableFlatLocales){
				//Stop the locale path searching if we know the availableFlatLocales, since
				//the first call to this function will load the only bundle that is needed.
				return true;
			}
		});
	}

	//Save the best locale bundle as the target locale bundle when we know the
	//the available bundles.
	if(availableFlatLocales && targetLocale != bestLocale){
		bundle[targetLocale.replace('-', '_')] = bundle[bestLocale.replace('-', '_')];
	}
};

(function(){
	// If other locales are used, dojo.requireLocalization should load them as well, by default.
	// Override dojo.requireLocalization to do load the default bundle, then iterate through the
	// extraLocale list and load those translations as well, unless a particular locale was requested.

	var extra = djConfig.extraLocale;
	if(extra){
		if(!extra instanceof Array){
			extra = [extra];
		}

		var req = dojo.requireLocalization;
		dojo.requireLocalization = function(m, b, locale, availableFlatLocales){
			req(m,b,locale, availableFlatLocales);
			if(locale){return;}
			for(var i=0; i<extra.length; i++){
				req(m,b,extra[i], availableFlatLocales);
			}
		};
	}
})();

}});

__CPAN_FILE__ src/profile.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.profile");
dojo.profile = {_profiles:{}, _pns:[], start:function (name) {
	if (!this._profiles[name]) {
		this._profiles[name] = {iters:0, total:0};
		this._pns[this._pns.length] = name;
	} else {
		if (this._profiles[name]["start"]) {
			this.end(name);
		}
	}
	this._profiles[name].end = null;
	this._profiles[name].start = new Date();
}, end:function (name) {
	var ed = new Date();
	if ((this._profiles[name]) && (this._profiles[name]["start"])) {
		with (this._profiles[name]) {
			end = ed;
			total += (end - start);
			start = null;
			iters++;
		}
	} else {
		return true;
	}
}, dump:function (appendToDoc) {
	var tbl = document.createElement("table");
	with (tbl.style) {
		border = "1px solid black";
		borderCollapse = "collapse";
	}
	var hdr = tbl.createTHead();
	var hdrtr = hdr.insertRow(0);
	var cols = ["Identifier", "Calls", "Total", "Avg"];
	for (var x = 0; x < cols.length; x++) {
		var ntd = hdrtr.insertCell(x);
		with (ntd.style) {
			backgroundColor = "#225d94";
			color = "white";
			borderBottom = "1px solid black";
			borderRight = "1px solid black";
			fontFamily = "tahoma";
			fontWeight = "bolder";
			paddingLeft = paddingRight = "5px";
		}
		ntd.appendChild(document.createTextNode(cols[x]));
	}
	for (var x = 0; x < this._pns.length; x++) {
		var prf = this._profiles[this._pns[x]];
		this.end(this._pns[x]);
		if (prf.iters > 0) {
			var bdytr = tbl.insertRow(true);
			var vals = [this._pns[x], prf.iters, prf.total, parseInt(prf.total / prf.iters)];
			for (var y = 0; y < vals.length; y++) {
				var cc = bdytr.insertCell(y);
				cc.appendChild(document.createTextNode(vals[y]));
				with (cc.style) {
					borderBottom = "1px solid gray";
					paddingLeft = paddingRight = "5px";
					if (x % 2) {
						backgroundColor = "#e1f1ff";
					}
					if (y > 0) {
						textAlign = "right";
						borderRight = "1px solid gray";
					} else {
						borderRight = "1px solid black";
					}
				}
			}
		}
	}
	if (appendToDoc) {
		var ne = document.createElement("div");
		ne.id = "profileOutputTable";
		with (ne.style) {
			fontFamily = "Courier New, monospace";
			fontSize = "12px";
			lineHeight = "16px";
			borderTop = "1px solid black";
			padding = "10px";
		}
		if (document.getElementById("profileOutputTable")) {
			dojo.body().replaceChild(ne, document.getElementById("profileOutputTable"));
		} else {
			dojo.body().appendChild(ne);
		}
		ne.appendChild(tbl);
	}
	return tbl;
}};
dojo.profile.stop = dojo.profile.end;


__CPAN_FILE__ src/storage.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.storage"], ["require", "dojo.lang.*"], ["require", "dojo.event.*"]], definePackage:function (dojo) {
	dojo.provide("dojo.storage");
	dojo.require("dojo.lang.*");
	dojo.require("dojo.event.*");
	dojo.storage = new function () {
	};
	dojo.declare("dojo.storage", null, {SUCCESS:"success", FAILED:"failed", PENDING:"pending", SIZE_NOT_AVAILABLE:"Size not available", SIZE_NO_LIMIT:"No size limit", namespace:"default", onHideSettingsUI:null, initialize:function () {
		dojo.unimplemented("dojo.storage.initialize");
	}, isAvailable:function () {
		dojo.unimplemented("dojo.storage.isAvailable");
	}, put:function (key, value, resultsHandler) {
		dojo.unimplemented("dojo.storage.put");
	}, get:function (key) {
		dojo.unimplemented("dojo.storage.get");
	}, hasKey:function (key) {
		return (this.get(key) != null);
	}, getKeys:function () {
		dojo.unimplemented("dojo.storage.getKeys");
	}, clear:function () {
		dojo.unimplemented("dojo.storage.clear");
	}, remove:function (key) {
		dojo.unimplemented("dojo.storage.remove");
	}, isPermanent:function () {
		dojo.unimplemented("dojo.storage.isPermanent");
	}, getMaximumSize:function () {
		dojo.unimplemented("dojo.storage.getMaximumSize");
	}, hasSettingsUI:function () {
		return false;
	}, showSettingsUI:function () {
		dojo.unimplemented("dojo.storage.showSettingsUI");
	}, hideSettingsUI:function () {
		dojo.unimplemented("dojo.storage.hideSettingsUI");
	}, getType:function () {
		dojo.unimplemented("dojo.storage.getType");
	}, isValidKey:function (keyName) {
		if ((keyName == null) || (typeof keyName == "undefined")) {
			return false;
		}
		return /^[0-9A-Za-z_]*$/.test(keyName);
	}});
	dojo.storage.manager = new function () {
		this.currentProvider = null;
		this.available = false;
		this._initialized = false;
		this._providers = [];
		this.namespace = "default";
		this.initialize = function () {
			this.autodetect();
		};
		this.register = function (name, instance) {
			this._providers[this._providers.length] = instance;
			this._providers[name] = instance;
		};
		this.setProvider = function (storageClass) {
		};
		this.autodetect = function () {
			if (this._initialized == true) {
				return;
			}
			var providerToUse = null;
			for (var i = 0; i < this._providers.length; i++) {
				providerToUse = this._providers[i];
				if (dojo.lang.isUndefined(djConfig["forceStorageProvider"]) == false && providerToUse.getType() == djConfig["forceStorageProvider"]) {
					providerToUse.isAvailable();
					break;
				} else {
					if (dojo.lang.isUndefined(djConfig["forceStorageProvider"]) == true && providerToUse.isAvailable()) {
						break;
					}
				}
			}
			if (providerToUse == null) {
				this._initialized = true;
				this.available = false;
				this.currentProvider = null;
				dojo.raise("No storage provider found for this platform");
			}
			this.currentProvider = providerToUse;
			for (var i in providerToUse) {
				dojo.storage[i] = providerToUse[i];
			}
			dojo.storage.manager = this;
			dojo.storage.initialize();
			this._initialized = true;
			this.available = true;
		};
		this.isAvailable = function () {
			return this.available;
		};
		this.isInitialized = function () {
			if (this.currentProvider.getType() == "dojo.storage.browser.FlashStorageProvider" && dojo.flash.ready == false) {
				return false;
			} else {
				return this._initialized;
			}
		};
		this.supportsProvider = function (storageClass) {
			try {
				var provider = eval("new " + storageClass + "()");
				var results = provider.isAvailable();
				if (results == null || typeof results == "undefined") {
					return false;
				}
				return results;
			}
			catch (exception) {
				return false;
			}
		};
		this.getProvider = function () {
			return this.currentProvider;
		};
		this.loaded = function () {
		};
	};
}});


__CPAN_FILE__ src/event.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.event"], ["require", "dojo.event.*"]], definePackage:function (dojo) {
	dojo.provide("dojo.event");
	dojo.require("dojo.event.*");
	dojo.deprecated("dojo.event", "replaced by dojo.event.*", "0.5");
}});


__CPAN_FILE__ src/date.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.date"]], definePackage:function (dojo) {
	dojo.provide("dojo.date");
	dojo.deprecated("dojo.date", "use one of the modules in dojo.date.* instead", "0.5");
}});


__CPAN_FILE__ src/hostenv_spidermonkey.xd.js
dojo.hostenv.packageLoaded({
depends: [["requireIf", (djConfig["isDebug"] || djConfig["debugAtAllCosts"]]],
definePackage: function(dojo){/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
 * SpiderMonkey host environment
 */

dojo.hostenv.name_ = 'spidermonkey';

dojo.hostenv.println = print;
dojo.hostenv.exit = function(exitcode){ 
	quit(exitcode); 
}

// version() returns 0, sigh. and build() returns nothing but just prints.
dojo.hostenv.getVersion = function(){ return version(); }

// make jsc shut up (so we can use jsc for sanity checking) 
/*@cc_on
@if (@_jscript_version >= 7)
var line2pc; var print; var load; var quit;
@end
@*/

if(typeof line2pc == 'undefined'){
	dojo.raise("attempt to use SpiderMonkey host environment when no 'line2pc' global");
}

/*
 * This is a hack that determines the current script file by parsing a generated
 * stack trace (relying on the non-standard "stack" member variable of the
 * SpiderMonkey Error object).
 * If param depth is passed in, it'll return the script file which is that far down
 * the stack, but that does require that you know how deep your stack is when you are
 * calling.
 */
function dj_spidermonkey_current_file(depth){
    var s = '';
    try{
		throw Error("whatever");
	}catch(e){
		s = e.stack;
	}
    // lines are like: bu_getCurrentScriptURI_spidermonkey("ScriptLoader.js")@burst/Runtime.js:101
    var matches = s.match(/[^@]*\.js/gi);
    if(!matches){ 
		dojo.raise("could not parse stack string: '" + s + "'");
	}
    var fname = (typeof depth != 'undefined' && depth) ? matches[depth + 1] : matches[matches.length - 1];
    if(!fname){ 
		dojo.raise("could not find file name in stack string '" + s + "'");
	}
    //print("SpiderMonkeyRuntime got fname '" + fname + "' from stack string '" + s + "'");
    return fname;
}

// call this now because later we may not be on the top of the stack
if(!dojo.hostenv.library_script_uri_){ 
	dojo.hostenv.library_script_uri_ = dj_spidermonkey_current_file(0); 
}

dojo.hostenv.loadUri = function(uri){
	// spidermonkey load() evaluates the contents into the global scope (which
	// is what we want).
	// TODO: sigh, load() does not return a useful value. 
	// Perhaps it is returning the value of the last thing evaluated?
	var ok = load(uri);
	// dojo.debug("spidermonkey load(", uri, ") returned ", ok);
	return 1;
}

dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");


}});

__CPAN_FILE__ src/hostenv_browser.xd.js
dojo.hostenv.packageLoaded({
depends: [["requireIf", (djConfig["isDebug"] || djConfig["debugAtAllCosts"]],
["requireIf", djConfig["debugAtAllCosts"] && !window.widget && !djConfig["useXDomain"], "dojo.browser_debug"],
["requireIf", djConfig["debugAtAllCosts"] && !window.widget && djConfig["useXDomain"], "dojo.browser_debug_xd"]],
definePackage: function(dojo){/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

if(typeof window != 'undefined'){

	// attempt to figure out the path to dojo if it isn't set in the config
	(function(){
		// before we get any further with the config options, try to pick them out
		// of the URL. Most of this code is from NW
		if(djConfig.allowQueryConfig){
			var baseUrl = document.location.toString(); // FIXME: use location.query instead?
			var params = baseUrl.split("?", 2);
			if(params.length > 1){
				var paramStr = params[1];
				var pairs = paramStr.split("&");
				for(var x in pairs){
					var sp = pairs[x].split("=");
					// FIXME: is this eval dangerous?
					if((sp[0].length > 9)&&(sp[0].substr(0, 9) == "djConfig.")){
						var opt = sp[0].substr(9);
						try{
							djConfig[opt]=eval(sp[1]);
						}catch(e){
							djConfig[opt]=sp[1];
						}
					}
				}
			}
		}

		if(
			((djConfig["baseScriptUri"] == "")||(djConfig["baseRelativePath"] == "")) && 
			(document && document.getElementsByTagName)
		){
			var scripts = document.getElementsByTagName("script");
			var rePkg = /(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
			for(var i = 0; i < scripts.length; i++) {
				var src = scripts[i].getAttribute("src");
				if(!src) { continue; }
				var m = src.match(rePkg);
				if(m) {
					var root = src.substring(0, m.index);
					if(src.indexOf("bootstrap1") > -1) { root += "../"; }
					if(!this["djConfig"]) { djConfig = {}; }
					if(djConfig["baseScriptUri"] == "") { djConfig["baseScriptUri"] = root; }
					if(djConfig["baseRelativePath"] == "") { djConfig["baseRelativePath"] = root; }
					break;
				}
			}
		}

		// fill in the rendering support information in dojo.render.*
		var dr = dojo.render;
		var drh = dojo.render.html;
		var drs = dojo.render.svg;
		var dua = (drh.UA = navigator.userAgent);
		var dav = (drh.AV = navigator.appVersion);
		var t = true;
		var f = false;
		drh.capable = t;
		drh.support.builtin = t;

		dr.ver = parseFloat(drh.AV);
		dr.os.mac = dav.indexOf("Macintosh") >= 0;
		dr.os.win = dav.indexOf("Windows") >= 0;
		// could also be Solaris or something, but it's the same browser
		dr.os.linux = dav.indexOf("X11") >= 0;

		drh.opera = dua.indexOf("Opera") >= 0;
		drh.khtml = (dav.indexOf("Konqueror") >= 0)||(dav.indexOf("Safari") >= 0);
		drh.safari = dav.indexOf("Safari") >= 0;
		var geckoPos = dua.indexOf("Gecko");
		drh.mozilla = drh.moz = (geckoPos >= 0)&&(!drh.khtml);
		if (drh.mozilla) {
			// gecko version is YYYYMMDD
			drh.geckoVersion = dua.substring(geckoPos + 6, geckoPos + 14);
		}
		drh.ie = (document.all)&&(!drh.opera);
		drh.ie50 = drh.ie && dav.indexOf("MSIE 5.0")>=0;
		drh.ie55 = drh.ie && dav.indexOf("MSIE 5.5")>=0;
		drh.ie60 = drh.ie && dav.indexOf("MSIE 6.0")>=0;
		drh.ie70 = drh.ie && dav.indexOf("MSIE 7.0")>=0;

		var cm = document["compatMode"];
		drh.quirks = (cm == "BackCompat")||(cm == "QuirksMode")||drh.ie55||drh.ie50;

		// TODO: is the HTML LANG attribute relevant?
		dojo.locale = dojo.locale || (drh.ie ? navigator.userLanguage : navigator.language).toLowerCase();

		dr.vml.capable=drh.ie;
		drs.capable = f;
		drs.support.plugin = f;
		drs.support.builtin = f;
		var tdoc = window["document"];
		var tdi = tdoc["implementation"];

		if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg", "1.0"))){
			drs.capable = t;
			drs.support.builtin = t;
			drs.support.plugin = f;
		}
		// webkits after 420 support SVG natively. The test string is "AppleWebKit/420+"
		if(drh.safari){
			var tmp = dua.split("AppleWebKit/")[1];
			var ver = parseFloat(tmp.split(" ")[0]);
			if(ver >= 420){
				drs.capable = t;
				drs.support.builtin = t;
				drs.support.plugin = f;
			}
		}else{
		}
	})();

	dojo.hostenv.startPackage("dojo.hostenv");

	dojo.render.name = dojo.hostenv.name_ = 'browser';
	dojo.hostenv.searchIds = [];

	// These are in order of decreasing likelihood; this will change in time.
	dojo.hostenv._XMLHTTP_PROGIDS = ['Msxml2.XMLHTTP', 'Microsoft.XMLHTTP', 'Msxml2.XMLHTTP.4.0'];

	dojo.hostenv.getXmlhttpObject = function(){
		// summary: does the work of portably generating a new XMLHTTPRequest object.
		var http = null;
		var last_e = null;
		try{ http = new XMLHttpRequest(); }catch(e){}
		if(!http){
			for(var i=0; i<3; ++i){
				var progid = dojo.hostenv._XMLHTTP_PROGIDS[i];
				try{
					http = new ActiveXObject(progid);
				}catch(e){
					last_e = e;
				}

				if(http){
					dojo.hostenv._XMLHTTP_PROGIDS = [progid];  // so faster next time
					break;
				}
			}

			/*if(http && !http.toString) {
				http.toString = function() { "[object XMLHttpRequest]"; }
			}*/
		}

		if(!http){
			return dojo.raise("XMLHTTP not available", last_e);
		}

		return http; // XMLHTTPRequest instance
	}

	dojo.hostenv._blockAsync = false;
	dojo.hostenv.getText = function(uri, async_cb, fail_ok){
		// summary: Read the contents of the specified uri and return those contents.
		// uri:
		//		A relative or absolute uri. If absolute, it still must be in
		//		the same "domain" as we are.
		// async_cb:
		//		If not specified, load synchronously. If specified, load
		//		asynchronously, and use async_cb as the progress handler which
		//		takes the xmlhttp object as its argument. If async_cb, this
		//		function returns null.
		// fail_ok:
		//		Default false. If fail_ok and !async_cb and loading fails,
		//		return null instead of throwing.

		// need to block async callbacks from snatching this thread as the result
		// of an async callback might call another sync XHR, this hangs khtml forever
		// hostenv._blockAsync must also be checked in BrowserIO's watchInFlight()
		// NOTE: must be declared before scope switches ie. this.getXmlhttpObject()
		if(!async_cb){ this._blockAsync = true; }

		var http = this.getXmlhttpObject();

		function isDocumentOk(http){
			var stat = http["status"];
			// allow a 304 use cache, needed in konq (is this compliant with the http spec?)
			return Boolean((!stat)||((200 <= stat)&&(300 > stat))||(stat==304));
		}

		if(async_cb){
			var _this = this, timer = null, gbl = dojo.global();
			var xhr = dojo.evalObjPath("dojo.io.XMLHTTPTransport");
			http.onreadystatechange = function(){
				if(timer){ gbl.clearTimeout(timer); timer = null; }
				if(_this._blockAsync || (xhr && xhr._blockAsync)){
					timer = gbl.setTimeout(function () { http.onreadystatechange.apply(this); }, 10);
				}else{
					if(4==http.readyState){
						if(isDocumentOk(http)){
							// dojo.debug("LOADED URI: "+uri);
							async_cb(http.responseText);
						}
					}
				}
			}
		}

		http.open('GET', uri, async_cb ? true : false);
		try{
			http.send(null);
			if(async_cb){
				return null;
			}
			if(!isDocumentOk(http)){
				var err = Error("Unable to load "+uri+" status:"+ http.status);
				err.status = http.status;
				err.responseText = http.responseText;
				throw err;
			}
		}catch(e){
			this._blockAsync = false;
			if((fail_ok)&&(!async_cb)){
				return null;
			}else{
				throw e;
			}
		}

		this._blockAsync = false;
		return http.responseText; // String
	}

	dojo.hostenv.defaultDebugContainerId = 'dojoDebug';
	dojo.hostenv._println_buffer = [];
	dojo.hostenv._println_safe = false;
	dojo.hostenv.println = function(/*String*/line){
		// summary:
		//		prints the provided line to whatever logging container is
		//		available. If the page isn't loaded yet, the line may be added
		//		to a buffer for printing later.
		if(!dojo.hostenv._println_safe){
			dojo.hostenv._println_buffer.push(line);
		}else{
			try {
				var console = document.getElementById(djConfig.debugContainerId ?
					djConfig.debugContainerId : dojo.hostenv.defaultDebugContainerId);
				if(!console) { console = dojo.body(); }

				var div = document.createElement("div");
				div.appendChild(document.createTextNode(line));
				console.appendChild(div);
			} catch (e) {
				try{
					// safari needs the output wrapped in an element for some reason
					document.write("<div>" + line + "</div>");
				}catch(e2){
					window.status = line;
				}
			}
		}
	}

	dojo.addOnLoad(function(){
		dojo.hostenv._println_safe = true;
		while(dojo.hostenv._println_buffer.length > 0){
			dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
		}
	});

	function dj_addNodeEvtHdlr(/*DomNode*/node, /*String*/evtName, /*Function*/fp){
		// summary:
		//		non-destructively adds the specified function to the node's
		//		evtName handler.
		// node: the DomNode to add the handler to
		// evtName: should be in the form "click" for "onclick" handlers
		var oldHandler = node["on"+evtName] || function(){};
		node["on"+evtName] = function(){
			fp.apply(node, arguments);
			oldHandler.apply(node, arguments);
		}
		return true;
	}

	dojo.hostenv._djInitFired = false;
	//	BEGIN DOMContentLoaded, from Dean Edwards (http://dean.edwards.name/weblog/2006/06/again/)
	function dj_load_init(e){
		dojo.hostenv._djInitFired = true;
		// allow multiple calls, only first one will take effect
		// A bug in khtml calls events callbacks for document for event which isnt supported
		// for example a created contextmenu event calls DOMContentLoaded, workaround
		var type = (e && e.type) ? e.type.toLowerCase() : "load";
		if(arguments.callee.initialized || (type!="domcontentloaded" && type!="load")){ return; }
		arguments.callee.initialized = true;
		if(typeof(_timer) != 'undefined'){
			clearInterval(_timer);
			delete _timer;
		}

		var initFunc = function(){
			//perform initialization
			if(dojo.render.html.ie){
				dojo.hostenv.makeWidgets();
			}
		};

		if(dojo.hostenv.inFlightCount == 0){
			initFunc();
			dojo.hostenv.modulesLoaded();
		}else{
			//This else case should be xdomain loading.
			//Make sure this is the first thing in the load listener array.
			//Part of the dojo.addOnLoad guarantee is that when the listeners are notified,
			//It means the DOM (or page) has loaded and that widgets have been parsed.
			dojo.hostenv.modulesLoadedListeners.unshift(initFunc);
		}
	}

	//	START DOMContentLoaded
	// Mozilla and Opera 9 expose the event we could use
	if(document.addEventListener){
		// NOTE: 
		//		due to a threading issue in Firefox 2.0, we can't enable
		//		DOMContentLoaded on that platform. For more information, see:
		//		http://trac.dojotoolkit.org/ticket/1704
		if(dojo.render.html.opera || (dojo.render.html.moz && (djConfig["enableMozDomContentLoaded"] === true))){
			document.addEventListener("DOMContentLoaded", dj_load_init, null);
		}

		//	mainly for Opera 8.5, won't be fired if DOMContentLoaded fired already.
		//  also used for Mozilla because of trac #1640
		window.addEventListener("load", dj_load_init, null);
	}

	// 	for Internet Explorer. readyState will not be achieved on init call, but dojo doesn't need it
	//	however, we'll include it because we don't know if there are other functions added that might.
	//	Note that this has changed because the build process strips all comments--including conditional
	//		ones.
	if(dojo.render.html.ie && dojo.render.os.win){
		document.attachEvent("onreadystatechange", function(e){
			if(document.readyState == "complete"){
				dj_load_init();
			}
		});
	}

	if (/(WebKit|khtml)/i.test(navigator.userAgent)) { // sniff
		var _timer = setInterval(function() {
			if (/loaded|complete/.test(document.readyState)) {
				dj_load_init(); // call the onload handler
			}
		}, 10);
	}
	//	END DOMContentLoaded

	// IE WebControl hosted in an application can fire "beforeunload" and "unload"
	// events when control visibility changes, causing Dojo to unload too soon. The
	// following code fixes the problem
	// Reference: http://support.microsoft.com/default.aspx?scid=kb;en-us;199155
	if(dojo.render.html.ie){
		dj_addNodeEvtHdlr(window, "beforeunload", function(){
			dojo.hostenv._unloading = true;
			window.setTimeout(function() {
				dojo.hostenv._unloading = false;
			}, 0);
		});
	}

	dj_addNodeEvtHdlr(window, "unload", function(){
		dojo.hostenv.unloaded();
		if((!dojo.render.html.ie)||(dojo.render.html.ie && dojo.hostenv._unloading)){
			dojo.hostenv.unloaded();
		}
	});

	dojo.hostenv.makeWidgets = function(){
		// you can put searchIds in djConfig and dojo.hostenv at the moment
		// we should probably eventually move to one or the other
		var sids = [];
		if(djConfig.searchIds && djConfig.searchIds.length > 0) {
			sids = sids.concat(djConfig.searchIds);
		}
		if(dojo.hostenv.searchIds && dojo.hostenv.searchIds.length > 0) {
			sids = sids.concat(dojo.hostenv.searchIds);
		}

		if((djConfig.parseWidgets)||(sids.length > 0)){
			if(dojo.evalObjPath("dojo.widget.Parse")){
				// we must do this on a delay to avoid:
				//	http://www.shaftek.org/blog/archives/000212.html
				// (IE bug)
					var parser = new dojo.xml.Parse();
					if(sids.length > 0){
						for(var x=0; x<sids.length; x++){
							var tmpNode = document.getElementById(sids[x]);
							if(!tmpNode){ continue; }
							var frag = parser.parseElement(tmpNode, null, true);
							dojo.widget.getParser().createComponents(frag);
						}
					}else if(djConfig.parseWidgets){
						var frag  = parser.parseElement(dojo.body(), null, true);
						dojo.widget.getParser().createComponents(frag);
					}
			}
		}
	}

	dojo.addOnLoad(function(){
		if(!dojo.render.html.ie) {
			dojo.hostenv.makeWidgets();
		}
	});

	try{
		if(dojo.render.html.ie){
			document.namespaces.add("v","urn:schemas-microsoft-com:vml");
			document.createStyleSheet().addRule("v\\:*", "behavior:url(#default#VML)");
		}
	}catch(e){ }

	// stub, over-ridden by debugging code. This will at least keep us from
	// breaking when it's not included
	dojo.hostenv.writeIncludes = function(){}

	//TODOC:  HOW TO DOC THIS?
	// @global: dj_currentDocument
	// summary:
	//		Current document object. 'dj_currentDocument' can be modified for temporary context shifting.
	// description:
	//    dojo.doc() returns dojo.currentDocument.
	//		Refer to dojo.doc() rather than referring to 'window.document' to ensure your
	//		code runs correctly in managed contexts.
	if(!dj_undef("document", this)){
		dj_currentDocument = this.document;
	}

	dojo.doc = function(){
		// summary:
		//		return the document object associated with the dojo.global()
		return dj_currentDocument;
	}

	dojo.body = function(){
		// summary:
		//		return the body object associated with dojo.doc()
		// Note: document.body is not defined for a strict xhtml document
		return dojo.doc().body || dojo.doc().getElementsByTagName("body")[0];
	}

	dojo.byId = function(/*String*/id, /*DocumentElement*/doc){
		// summary:
		// 		similar to other library's "$" function, takes a string
		// 		representing a DOM id or a DomNode and returns the
		// 		corresponding DomNode. If a Node is passed, this function is a
		// 		no-op. Returns a single DOM node or null, working around
		// 		several browser-specific bugs to do so.
		// id: DOM id or DOM Node
		// doc:
		//		optional, defaults to the current value of dj_currentDocument.
		//		Can be used to retreive node references from other documents.
		if((id)&&((typeof id == "string")||(id instanceof String))){
			if(!doc){ doc = dj_currentDocument; }
			var ele = doc.getElementById(id);
			// workaround bug in IE and Opera 8.2 where getElementById returns wrong element
			if(ele && (ele.id != id) && doc.all){
				ele = null;
				// get all matching elements with this id
				eles = doc.all[id];
				if(eles){
					// if more than 1, choose first with the correct id
					if(eles.length){
						for(var i=0; i<eles.length; i++){
							if(eles[i].id == id){
								ele = eles[i];
								break;
							}
						}
					// return 1 and only element
					}else{
						ele = eles;
					}
				}
			}
			return ele; // DomNode
		}
		return id; // DomNode
	}

	dojo.setContext = function(/*Object*/globalObject, /*DocumentElement*/globalDocument){
		// summary:
		//		changes the behavior of many core Dojo functions that deal with
		//		namespace and DOM lookup, changing them to work in a new global
		//		context. The varibles dj_currentContext and dj_currentDocument
		//		are modified as a result of calling this function.
		dj_currentContext = globalObject;
		dj_currentDocument = globalDocument;
	};

	dojo._fireCallback = function(callback, context, cbArguments){
		if((context)&&((typeof callback == "string")||(callback instanceof String))){
			callback=context[callback];
		}
		return (context ? callback.apply(context, cbArguments || [ ]) : callback());
	}

	dojo.withGlobal = function(/*Object*/globalObject, /*Function*/callback, /*Object?*/thisObject, /*Array?*/cbArguments){
		// summary:
		//		Call callback with globalObject as dojo.global() and globalObject.document
		//		as dojo.doc(). If provided, globalObject will be executed in the context of
		//		object thisObject
		// description:
		//		When callback() returns or throws an error, the dojo.global() and dojo.doc() will
		//		be restored to its previous state.
		var rval;
		var oldGlob = dj_currentContext;
		var oldDoc = dj_currentDocument;
		try{
			dojo.setContext(globalObject, globalObject.document);
			rval = dojo._fireCallback(callback, thisObject, cbArguments);
		}finally{
			dojo.setContext(oldGlob, oldDoc);
		}
		return rval;
	}

	dojo.withDoc = function (/*Object*/documentObject, /*Function*/callback, /*Object?*/thisObject, /*Array?*/cbArguments) {
		// summary:
		//		Call callback with documentObject as dojo.doc(). If provided, callback will be executed
		//		in the context of object thisObject
		// description:
		//		When callback() returns or throws an error, the dojo.doc() will
		//		be restored to its previous state.
		var rval;
		var oldDoc = dj_currentDocument;
		try{
			dj_currentDocument = documentObject;
			rval = dojo._fireCallback(callback, thisObject, cbArguments);
		}finally{
			dj_currentDocument = oldDoc;
		}
		return rval;
	}

} //if (typeof window != 'undefined')

//Load debug code if necessary.
dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");

//window.widget is for Dashboard detection
//The full conditionals are spelled out to avoid issues during builds.
//Builds may be looking for require/requireIf statements and processing them.
dojo.requireIf(djConfig["debugAtAllCosts"] && !window.widget && !djConfig["useXDomain"], "dojo.browser_debug");
dojo.requireIf(djConfig["debugAtAllCosts"] && !window.widget && djConfig["useXDomain"], "dojo.browser_debug_xd");

}});

__CPAN_FILE__ src/hostenv_wsh.xd.js
dojo.hostenv.packageLoaded({
depends: [["requireIf", (djConfig["isDebug"] || djConfig["debugAtAllCosts"]]],
definePackage: function(dojo){/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
 * WSH
 */

dojo.hostenv.name_ = 'wsh';

// make jsc shut up (so can sanity check)
/*@cc_on
@if (@_jscript_version >= 7)
var WScript;
@end
@*/

// make sure we are in right environment
if(typeof WScript == 'undefined'){
	dojo.raise("attempt to use WSH host environment when no WScript global");
}

dojo.hostenv.println = WScript.Echo;

dojo.hostenv.getCurrentScriptUri = function(){
	return WScript.ScriptFullName();
}

dojo.hostenv.getText = function(fpath){
	var fso = new ActiveXObject("Scripting.FileSystemObject");
	var istream = fso.OpenTextFile(fpath, 1); // iomode==1 means read only
	if(!istream){
		return null;
	}
	var contents = istream.ReadAll();
	istream.Close();
	return contents;
}

dojo.hostenv.exit = function(exitcode){ WScript.Quit(exitcode); }

dojo.requireIf((djConfig["isDebug"] || djConfig["debugAtAllCosts"]), "dojo.debug");

}});

__CPAN_FILE__ src/flash.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.flash");
dojo.require("dojo.string.*");
dojo.require("dojo.uri.*");
dojo.require("dojo.html.common");
dojo.flash = function () {
};
dojo.flash = {flash6_version:null, flash8_version:null, ready:false, _visible:true, _loadedListeners:new Array(), _installingListeners:new Array(), setSwf:function (fileInfo) {
	if (fileInfo == null || dojo.lang.isUndefined(fileInfo)) {
		return;
	}
	if (fileInfo.flash6 != null && !dojo.lang.isUndefined(fileInfo.flash6)) {
		this.flash6_version = fileInfo.flash6;
	}
	if (fileInfo.flash8 != null && !dojo.lang.isUndefined(fileInfo.flash8)) {
		this.flash8_version = fileInfo.flash8;
	}
	if (!dojo.lang.isUndefined(fileInfo.visible)) {
		this._visible = fileInfo.visible;
	}
	this._initialize();
}, useFlash6:function () {
	if (this.flash6_version == null) {
		return false;
	} else {
		if (this.flash6_version != null && dojo.flash.info.commVersion == 6) {
			return true;
		} else {
			return false;
		}
	}
}, useFlash8:function () {
	if (this.flash8_version == null) {
		return false;
	} else {
		if (this.flash8_version != null && dojo.flash.info.commVersion == 8) {
			return true;
		} else {
			return false;
		}
	}
}, addLoadedListener:function (listener) {
	this._loadedListeners.push(listener);
}, addInstallingListener:function (listener) {
	this._installingListeners.push(listener);
}, loaded:function () {
	dojo.flash.ready = true;
	if (dojo.flash._loadedListeners.length > 0) {
		for (var i = 0; i < dojo.flash._loadedListeners.length; i++) {
			dojo.flash._loadedListeners[i].call(null);
		}
	}
}, installing:function () {
	if (dojo.flash._installingListeners.length > 0) {
		for (var i = 0; i < dojo.flash._installingListeners.length; i++) {
			dojo.flash._installingListeners[i].call(null);
		}
	}
}, _initialize:function () {
	var installer = new dojo.flash.Install();
	dojo.flash.installer = installer;
	if (installer.needed() == true) {
		installer.install();
	} else {
		dojo.flash.obj = new dojo.flash.Embed(this._visible);
		dojo.flash.obj.write(dojo.flash.info.commVersion);
		dojo.flash.comm = new dojo.flash.Communicator();
	}
}};
dojo.flash.Info = function () {
	if (dojo.render.html.ie) {
		document.writeln("<script language=\"VBScript\" type=\"text/vbscript\">");
		document.writeln("Function VBGetSwfVer(i)");
		document.writeln("  on error resume next");
		document.writeln("  Dim swControl, swVersion");
		document.writeln("  swVersion = 0");
		document.writeln("  set swControl = CreateObject(\"ShockwaveFlash.ShockwaveFlash.\" + CStr(i))");
		document.writeln("  if (IsObject(swControl)) then");
		document.writeln("	swVersion = swControl.GetVariable(\"$version\")");
		document.writeln("  end if");
		document.writeln("  VBGetSwfVer = swVersion");
		document.writeln("End Function");
		document.writeln("</script>");
	}
	this._detectVersion();
	this._detectCommunicationVersion();
};
dojo.flash.Info.prototype = {version:-1, versionMajor:-1, versionMinor:-1, versionRevision:-1, capable:false, commVersion:6, installing:false, isVersionOrAbove:function (reqMajorVer, reqMinorVer, reqVer) {
	reqVer = parseFloat("." + reqVer);
	if (this.versionMajor >= reqMajorVer && this.versionMinor >= reqMinorVer && this.versionRevision >= reqVer) {
		return true;
	} else {
		return false;
	}
}, _detectVersion:function () {
	var versionStr;
	for (var testVersion = 25; testVersion > 0; testVersion--) {
		if (dojo.render.html.ie) {
			versionStr = VBGetSwfVer(testVersion);
		} else {
			versionStr = this._JSFlashInfo(testVersion);
		}
		if (versionStr == -1) {
			this.capable = false;
			return;
		} else {
			if (versionStr != 0) {
				var versionArray;
				if (dojo.render.html.ie) {
					var tempArray = versionStr.split(" ");
					var tempString = tempArray[1];
					versionArray = tempString.split(",");
				} else {
					versionArray = versionStr.split(".");
				}
				this.versionMajor = versionArray[0];
				this.versionMinor = versionArray[1];
				this.versionRevision = versionArray[2];
				var versionString = this.versionMajor + "." + this.versionRevision;
				this.version = parseFloat(versionString);
				this.capable = true;
				break;
			}
		}
	}
}, _JSFlashInfo:function (testVersion) {
	if (navigator.plugins != null && navigator.plugins.length > 0) {
		if (navigator.plugins["Shockwave Flash 2.0"] || navigator.plugins["Shockwave Flash"]) {
			var swVer2 = navigator.plugins["Shockwave Flash 2.0"] ? " 2.0" : "";
			var flashDescription = navigator.plugins["Shockwave Flash" + swVer2].description;
			var descArray = flashDescription.split(" ");
			var tempArrayMajor = descArray[2].split(".");
			var versionMajor = tempArrayMajor[0];
			var versionMinor = tempArrayMajor[1];
			if (descArray[3] != "") {
				var tempArrayMinor = descArray[3].split("r");
			} else {
				var tempArrayMinor = descArray[4].split("r");
			}
			var versionRevision = tempArrayMinor[1] > 0 ? tempArrayMinor[1] : 0;
			var version = versionMajor + "." + versionMinor + "." + versionRevision;
			return version;
		}
	}
	return -1;
}, _detectCommunicationVersion:function () {
	if (this.capable == false) {
		this.commVersion = null;
		return;
	}
	if (typeof djConfig["forceFlashComm"] != "undefined" && typeof djConfig["forceFlashComm"] != null) {
		this.commVersion = djConfig["forceFlashComm"];
		return;
	}
	if (dojo.render.html.safari == true || dojo.render.html.opera == true) {
		this.commVersion = 8;
	} else {
		this.commVersion = 6;
	}
}};
dojo.flash.Embed = function (visible) {
	this._visible = visible;
};
dojo.flash.Embed.prototype = {width:215, height:138, id:"flashObject", _visible:true, protocol:function () {
	switch (window.location.protocol) {
	  case "https:":
		return "https";
		break;
	  default:
		return "http";
		break;
	}
}, write:function (flashVer, doExpressInstall) {
	if (dojo.lang.isUndefined(doExpressInstall)) {
		doExpressInstall = false;
	}
	var containerStyle = new dojo.string.Builder();
	containerStyle.append("width: " + this.width + "px; ");
	containerStyle.append("height: " + this.height + "px; ");
	if (this._visible == false) {
		containerStyle.append("position: absolute; ");
		containerStyle.append("z-index: 10000; ");
		containerStyle.append("top: -1000px; ");
		containerStyle.append("left: -1000px; ");
	}
	containerStyle = containerStyle.toString();
	var objectHTML;
	var swfloc;
	if (flashVer == 6) {
		swfloc = dojo.flash.flash6_version;
		var dojoPath = djConfig.baseRelativePath;
		swfloc = swfloc + "?baseRelativePath=" + escape(dojoPath);
		objectHTML = "<embed id=\"" + this.id + "\" src=\"" + swfloc + "\" " + "	quality=\"high\" bgcolor=\"#ffffff\" " + "	width=\"" + this.width + "\" height=\"" + this.height + "\" " + "	name=\"" + this.id + "\" " + "	align=\"middle\" allowScriptAccess=\"sameDomain\" " + "	type=\"application/x-shockwave-flash\" swLiveConnect=\"true\" " + "	pluginspage=\"" + this.protocol() + "://www.macromedia.com/go/getflashplayer\">";
	} else {
		swfloc = dojo.flash.flash8_version;
		var swflocObject = swfloc;
		var swflocEmbed = swfloc;
		var dojoPath = djConfig.baseRelativePath;
		if (doExpressInstall) {
			var redirectURL = escape(window.location);
			document.title = document.title.slice(0, 47) + " - Flash Player Installation";
			var docTitle = escape(document.title);
			swflocObject += "?MMredirectURL=" + redirectURL + "&MMplayerType=ActiveX" + "&MMdoctitle=" + docTitle + "&baseRelativePath=" + escape(dojoPath);
			swflocEmbed += "?MMredirectURL=" + redirectURL + "&MMplayerType=PlugIn" + "&baseRelativePath=" + escape(dojoPath);
		}
		if (swflocEmbed.indexOf("?") == -1) {
			swflocEmbed += "?baseRelativePath=" + escape(dojoPath) + "' ";
		}
		objectHTML = "<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" " + "codebase=\"" + this.protocol() + "://fpdownload.macromedia.com/pub/shockwave/cabs/flash/" + "swflash.cab#version=8,0,0,0\" " + "width=\"" + this.width + "\" " + "height=\"" + this.height + "\" " + "id=\"" + this.id + "\" " + "align=\"middle\"> " + "<param name=\"allowScriptAccess\" value=\"sameDomain\" /> " + "<param name=\"movie\" value=\"" + swflocObject + "\" /> " + "<param name=\"quality\" value=\"high\" /> " + "<param name=\"bgcolor\" value=\"#ffffff\" /> " + "<embed src=\"" + swflocEmbed + "' " + "quality=\"high\" " + "bgcolor=\"#ffffff\" " + "width=\"" + this.width + "\" " + "height=\"" + this.height + "\" " + "id=\"" + this.id + "\" " + "name=\"" + this.id + "\" " + "swLiveConnect=\"true\" " + "align=\"middle\" " + "allowScriptAccess=\"sameDomain\" " + "type=\"application/x-shockwave-flash\" " + "pluginspage=\"" + this.protocol() + "://www.macromedia.com/go/getflashplayer\" />" + "</object>";
	}
	objectHTML = "<div id=\"" + this.id + "Container\" style=\"" + containerStyle + "\"> " + objectHTML + "</div>";
	document.writeln(objectHTML);
}, get:function () {
	return document.getElementById(this.id);
}, setVisible:function (visible) {
	var container = dojo.byId(this.id + "Container");
	if (visible == true) {
		container.style.visibility = "visible";
	} else {
		container.style.position = "absolute";
		container.style.x = "-1000px";
		container.style.y = "-1000px";
		container.style.visibility = "hidden";
	}
}, center:function () {
	var elementWidth = this.width;
	var elementHeight = this.height;
	var scroll_offset = dojo.html.getScroll().offset;
	var viewport_size = dojo.html.getViewport();
	var x = scroll_offset.x + (viewport_size.width - elementWidth) / 2;
	var y = scroll_offset.y + (viewport_size.height - elementHeight) / 2;
	var container = dojo.byId(this.id + "Container");
	container.style.top = y + "px";
	container.style.left = x + "px";
}};
dojo.flash.Communicator = function () {
	if (dojo.flash.useFlash6()) {
		this._writeFlash6();
	} else {
		if (dojo.flash.useFlash8()) {
			this._writeFlash8();
		}
	}
};
dojo.flash.Communicator.prototype = {_writeFlash6:function () {
	var id = dojo.flash.obj.id;
	document.writeln("<script language=\"JavaScript\">");
	document.writeln("  function " + id + "_DoFSCommand(command, args){ ");
	document.writeln("	dojo.flash.comm._handleFSCommand(command, args); ");
	document.writeln("}");
	document.writeln("</script>");
	if (dojo.render.html.ie) {
		document.writeln("<SCRIPT LANGUAGE=VBScript> ");
		document.writeln("on error resume next ");
		document.writeln("Sub " + id + "_FSCommand(ByVal command, ByVal args)");
		document.writeln(" call " + id + "_DoFSCommand(command, args)");
		document.writeln("end sub");
		document.writeln("</SCRIPT> ");
	}
}, _writeFlash8:function () {
}, _handleFSCommand:function (command, args) {
	if (command != null && !dojo.lang.isUndefined(command) && /^FSCommand:(.*)/.test(command) == true) {
		command = command.match(/^FSCommand:(.*)/)[1];
	}
	if (command == "addCallback") {
		this._fscommandAddCallback(command, args);
	} else {
		if (command == "call") {
			this._fscommandCall(command, args);
		} else {
			if (command == "fscommandReady") {
				this._fscommandReady();
			}
		}
	}
}, _fscommandAddCallback:function (command, args) {
	var functionName = args;
	var callFunc = function () {
		return dojo.flash.comm._call(functionName, arguments);
	};
	dojo.flash.comm[functionName] = callFunc;
	dojo.flash.obj.get().SetVariable("_succeeded", true);
}, _fscommandCall:function (command, args) {
	var plugin = dojo.flash.obj.get();
	var functionName = args;
	var numArgs = parseInt(plugin.GetVariable("_numArgs"));
	var flashArgs = new Array();
	for (var i = 0; i < numArgs; i++) {
		var currentArg = plugin.GetVariable("_" + i);
		flashArgs.push(currentArg);
	}
	var runMe;
	if (functionName.indexOf(".") == -1) {
		runMe = window[functionName];
	} else {
		runMe = eval(functionName);
	}
	var results = null;
	if (!dojo.lang.isUndefined(runMe) && runMe != null) {
		results = runMe.apply(null, flashArgs);
	}
	plugin.SetVariable("_returnResult", results);
}, _fscommandReady:function () {
	var plugin = dojo.flash.obj.get();
	plugin.SetVariable("fscommandReady", "true");
}, _call:function (functionName, args) {
	var plugin = dojo.flash.obj.get();
	plugin.SetVariable("_functionName", functionName);
	plugin.SetVariable("_numArgs", args.length);
	for (var i = 0; i < args.length; i++) {
		var value = args[i];
		value = value.replace(/\0/g, "\\0");
		plugin.SetVariable("_" + i, value);
	}
	plugin.TCallLabel("/_flashRunner", "execute");
	var results = plugin.GetVariable("_returnResult");
	results = results.replace(/\\0/g, "\x00");
	return results;
}, _addExternalInterfaceCallback:function (methodName) {
	var wrapperCall = function () {
		var methodArgs = new Array(arguments.length);
		for (var i = 0; i < arguments.length; i++) {
			methodArgs[i] = arguments[i];
		}
		return dojo.flash.comm._execFlash(methodName, methodArgs);
	};
	dojo.flash.comm[methodName] = wrapperCall;
}, _encodeData:function (data) {
	var entityRE = /\&([^;]*)\;/g;
	data = data.replace(entityRE, "&amp;$1;");
	data = data.replace(/</g, "&lt;");
	data = data.replace(/>/g, "&gt;");
	data = data.replace("\\", "&custom_backslash;&custom_backslash;");
	data = data.replace(/\n/g, "\\n");
	data = data.replace(/\r/g, "\\r");
	data = data.replace(/\f/g, "\\f");
	data = data.replace(/\0/g, "\\0");
	data = data.replace(/\'/g, "\\'");
	data = data.replace(/\"/g, "\\\"");
	return data;
}, _decodeData:function (data) {
	if (data == null || typeof data == "undefined") {
		return data;
	}
	data = data.replace(/\&custom_lt\;/g, "<");
	data = data.replace(/\&custom_gt\;/g, ">");
	data = eval("\"" + data + "\"");
	return data;
}, _chunkArgumentData:function (value, argIndex) {
	var plugin = dojo.flash.obj.get();
	var numSegments = Math.ceil(value.length / 1024);
	for (var i = 0; i < numSegments; i++) {
		var startCut = i * 1024;
		var endCut = i * 1024 + 1024;
		if (i == (numSegments - 1)) {
			endCut = i * 1024 + value.length;
		}
		var piece = value.substring(startCut, endCut);
		piece = this._encodeData(piece);
		plugin.CallFunction("<invoke name=\"chunkArgumentData\" " + "returntype=\"javascript\">" + "<arguments>" + "<string>" + piece + "</string>" + "<number>" + argIndex + "</number>" + "</arguments>" + "</invoke>");
	}
}, _chunkReturnData:function () {
	var plugin = dojo.flash.obj.get();
	var numSegments = plugin.getReturnLength();
	var resultsArray = new Array();
	for (var i = 0; i < numSegments; i++) {
		var piece = plugin.CallFunction("<invoke name=\"chunkReturnData\" " + "returntype=\"javascript\">" + "<arguments>" + "<number>" + i + "</number>" + "</arguments>" + "</invoke>");
		if (piece == "\"\"" || piece == "''") {
			piece = "";
		} else {
			piece = piece.substring(1, piece.length - 1);
		}
		resultsArray.push(piece);
	}
	var results = resultsArray.join("");
	return results;
}, _execFlash:function (methodName, methodArgs) {
	var plugin = dojo.flash.obj.get();
	plugin.startExec();
	plugin.setNumberArguments(methodArgs.length);
	for (var i = 0; i < methodArgs.length; i++) {
		this._chunkArgumentData(methodArgs[i], i);
	}
	plugin.exec(methodName);
	var results = this._chunkReturnData();
	results = this._decodeData(results);
	plugin.endExec();
	return results;
}};
dojo.flash.Install = function () {
};
dojo.flash.Install.prototype = {needed:function () {
	if (dojo.flash.info.capable == false) {
		return true;
	}
	if (dojo.render.os.mac == true && !dojo.flash.info.isVersionOrAbove(8, 0, 0)) {
		return true;
	}
	if (!dojo.flash.info.isVersionOrAbove(6, 0, 0)) {
		return true;
	}
	return false;
}, install:function () {
	dojo.flash.info.installing = true;
	dojo.flash.installing();
	if (dojo.flash.info.capable == false) {
		var installObj = new dojo.flash.Embed(false);
		installObj.write(8);
	} else {
		if (dojo.flash.info.isVersionOrAbove(6, 0, 65)) {
			var installObj = new dojo.flash.Embed(false);
			installObj.write(8, true);
			installObj.setVisible(true);
			installObj.center();
		} else {
			alert("This content requires a more recent version of the Macromedia " + " Flash Player.");
			window.location.href = +dojo.flash.Embed.protocol() + "://www.macromedia.com/go/getflashplayer";
		}
	}
}, _onInstallStatus:function (msg) {
	if (msg == "Download.Complete") {
		dojo.flash._initialize();
	} else {
		if (msg == "Download.Cancelled") {
			alert("This content requires a more recent version of the Macromedia " + " Flash Player.");
			window.location.href = dojo.flash.Embed.protocol() + "://www.macromedia.com/go/getflashplayer";
		} else {
			if (msg == "Download.Failed") {
				alert("There was an error downloading the Flash Player update. " + "Please try again later, or visit macromedia.com to download " + "the latest version of the Flash plugin.");
			}
		}
	}
}};
dojo.flash.info = new dojo.flash.Info();


__CPAN_DIR__ src/rpc
__CPAN_FILE__ src/rpc/Deferred.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.rpc.Deferred");
dojo.require("dojo.Deferred");
dojo.deprecated("dojo.rpc.Deferred", "replaced by dojo.Deferred", "0.6");
dojo.rpc.Deferred = dojo.Deferred;
dojo.rpc.Deferred.prototype = dojo.Deferred.prototype;


__CPAN_FILE__ src/rpc/YahooService.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.rpc.YahooService");
dojo.require("dojo.rpc.RpcService");
dojo.require("dojo.rpc.JsonService");
dojo.require("dojo.json");
dojo.require("dojo.uri.*");
dojo.require("dojo.io.ScriptSrcIO");
dojo.rpc.YahooService = function (appId) {
	this.appId = appId;
	if (!appId) {
		this.appId = "dojotoolkit";
		dojo.debug("please initialize the YahooService class with your own", "application ID. Using the default may cause problems during", "deployment of your application");
	}
	if (djConfig["useXDomain"] && !djConfig["yahooServiceSmdUrl"]) {
		dojo.debug("dojo.rpc.YahooService: When using cross-domain Dojo builds," + " please save yahoo.smd to your domain and set djConfig.yahooServiceSmdUrl" + " to the path on your domain to yahoo.smd");
	}
	this.connect(djConfig["yahooServiceSmdUrl"] || dojo.uri.moduleUri("dojo.rpc", "yahoo.smd"));
	this.strictArgChecks = false;
};
dojo.inherits(dojo.rpc.YahooService, dojo.rpc.JsonService);
dojo.lang.extend(dojo.rpc.YahooService, {strictArgChecks:false, bind:function (method, parameters, deferredRequestHandler, url) {
	var params = parameters;
	if ((dojo.lang.isArrayLike(parameters)) && (parameters.length == 1)) {
		params = parameters[0];
	}
	params.output = "json";
	params.appid = this.appId;
	dojo.io.bind({url:url || this.serviceUrl, transport:"ScriptSrcTransport", content:params, jsonParamName:"callback", mimetype:"text/json", load:this.resultCallback(deferredRequestHandler), error:this.errorCallback(deferredRequestHandler), preventCache:true});
}});


__CPAN_FILE__ src/rpc/yahoo.smd
{
	"SMDVersion":".1",
	"objectName":"yahoo",
	"serviceType":"JSON-P",
	"methods":[
		//
		// MAPS 
		//
		{
			// http://developer.yahoo.com/maps/rest/V1/mapImage.html
			"name":"mapImage",
			"serviceURL": "http://api.local.yahoo.com/MapsService/V1/mapImage",
			"parameters":[
				{ "name":"street", "type":"STRING" },
				{ "name":"city", "type":"STRING" },
				{ "name":"zip", "type":"INTEGER" },
				{ "name":"location", "type":"STRING" },
				{ "name":"longitude", "type":"FLOAT" },
				{ "name":"latitude", "type":"FLOAT" },
				{ "name":"image_type", "type":"STRING" },
				{ "name":"image_width", "type":"INTEGER" },
				{ "name":"image_height", "type":"INTEGER" },
				{ "name":"zoom", "type":"INTEGER" },
				{ "name":"radius", "type":"INTEGER" }
			]
		},
		{
			// http://developer.yahoo.com/traffic/rest/V1/index.html
			"name":"trafficData",
			"serviceURL": "http://api.local.yahoo.com/MapsService/V1/trafficData",
			"parameters":[
				{ "name":"street", "type":"STRING" },
				{ "name":"city", "type":"STRING" },
				{ "name":"zip", "type":"INTEGER" },
				{ "name":"location", "type":"STRING" },
				{ "name":"longitude", "type":"FLOAT" },
				{ "name":"latitude", "type":"FLOAT" },
				{ "name":"severity", "type":"INTEGER" },
				{ "name":"include_map", "type":"INTEGER" },
				{ "name":"image_type", "type":"STRING" },
				{ "name":"image_width", "type":"INTEGER" },
				{ "name":"image_height", "type":"INTEGER" },
				{ "name":"zoom", "type":"INTEGER" },
				{ "name":"radius", "type":"INTEGER" }
			]
		},
		/*
			// Yahoo's geocoding service is f'd for JSON and Y! advises that it
			// may not be returning
		{
			// http://developer.yahoo.com/maps/rest/V1/geocode.html
			"name":"geocode",
			"serviceURL": "http://api.local.yahoo.com/MapsService/V1/geocode",
			"parameters":[
				{ "name":"street", "type":"STRING" },
				{ "name":"city", "type":"STRING" },
				{ "name":"zip", "type":"INTEGER" },
				{ "name":"location", "type":"STRING" }
			]
		},
		*/
		//
		// LOCAL SEARCH
		//
		{
			// http://developer.yahoo.com/search/local/V3/localSearch.html
			"name":"localSearch",
			"serviceURL": "http://api.local.yahoo.com/LocalSearchService/V3/localSearch",
			"parameters":[
				{ "name":"street", "type":"STRING" },
				{ "name":"city", "type":"STRING" },
				{ "name":"zip", "type":"INTEGER" },
				{ "name":"location", "type":"STRING" },
				{ "name":"listing_id", "type":"STRING" },
				{ "name":"sort", "type":"STRING" }, // "relevence", "title", "distance", or "rating"
				{ "name":"start", "type":"INTEGER" },
				{ "name":"radius", "type":"FLOAT" },
				{ "name":"results", "type":"INTEGER" }, // 1-50, defaults to 10
				{ "name":"longitude", "type":"FLOAT" },
				{ "name":"latitude", "type":"FLOAT" },
				{ "name":"category", "type":"INTEGER" },
				{ "name":"omit_category", "type":"INTEGER" },
				{ "name":"minimum_rating", "type":"INTEGER" }
			]
		},
		//
		// WEB SEARCH
		//
		{
			// http://developer.yahoo.com/search/web/V1/webSearch.html 
			"name":"webSearch",
			"serviceURL": "http://api.search.yahoo.com/WebSearchService/V1/webSearch",
			"parameters":[
				{ "name":"query", "type":"STRING" },
				{ "name":"type", "type":"STRING" }, // defaults to "all"
				{ "name":"region", "type":"STRING" }, // defaults to "us"
				{ "name":"results", "type":"INTEGER" }, // defaults to 10
				{ "name":"start", "type":"INTEGER" }, // defaults to 1
				{ "name":"format", "type":"STRING" }, // defaults to "any", can be "html", "msword", "pdf", "ppt", "rst", "txt", or "xls"
				{ "name":"adult_ok", "type":"INTEGER" }, // defaults to null
				{ "name":"similar_ok", "type":"INTEGER" }, // defaults to null
				{ "name":"language", "type":"STRING" }, // defaults to null
				{ "name":"country", "type":"STRING" }, // defaults to null
				{ "name":"site", "type":"STRING" }, // defaults to null
				{ "name":"subscription", "type":"STRING" }, // defaults to null
				{ "name":"license", "type":"STRING" } // defaults to "any"
			]
		},
		{
			// http://developer.yahoo.com/search/web/V1/spellingSuggestion.html
			"name":"spellingSuggestion",
			"serviceURL": "http://api.search.yahoo.com/WebSearchService/V1/spellingSuggestion",
			"parameters":[ { "name":"query", "type":"STRING" } ]
		},
		{
			// http://developer.yahoo.com/search/web/V1/relatedSuggestion.html
			"name":"spellingSuggestion",
			"serviceURL": "http://api.search.yahoo.com/WebSearchService/V1/relatedSuggestion",
			"parameters":[
				{ "name":"query", "type":"STRING" },
				{ "name":"results", "type":"INTEGER" } // 1-50, defaults to 10
			]
		},
		{
			// http://developer.yahoo.com/search/content/V1/termExtraction.html
			"name":"termExtraction",
			"serviceURL": "http://search.yahooapis.com/ContentAnalysisService/V1/termExtraction",
			"parameters":[
				{ "name":"query", "type":"STRING" },
				{ "name":"context", "type":"STRING" },
				{ "name":"results", "type":"INTEGER" } // 1-50, defaults to 10
			]
		},
		{
			// http://developer.yahoo.com/search/web/V1/contextSearch.html
			"name":"contextSearch",
			"serviceURL": "http://search.yahooapis.com/WebSearchService/V1/contextSearch",
			"parameters":[
				{ "name":"query", "type":"STRING" },
				{ "name":"context", "type":"STRING" },
				{ "name":"type", "type":"STRING" }, // defaults to "all"
				{ "name":"results", "type":"INTEGER" }, // defaults to 10
				{ "name":"start", "type":"INTEGER" }, // defaults to 1
				{ "name":"format", "type":"STRING" }, // defaults to "any", can be "html", "msword", "pdf", "ppt", "rst", "txt", or "xls"
				{ "name":"adult_ok", "type":"INTEGER" }, // defaults to null
				{ "name":"similar_ok", "type":"INTEGER" }, // defaults to null
				{ "name":"language", "type":"STRING" }, // defaults to null
				{ "name":"country", "type":"STRING" }, // defaults to null
				{ "name":"site", "type":"STRING" }, // defaults to null
				{ "name":"license", "type":"STRING" } // defaults to "any", could be "cc_any", "cc_commercial", "cc_modifiable"
			]
		},
		//
		// IMAGE SEARCH
		//
		{
			// http://developer.yahoo.com/search/image/V1/imageSearch.html
			"name":"imageSearch",
			"serviceURL": "http://api.search.yahoo.com/ImageSearchService/V1/imageSearch",
			"parameters":[
				{ "name":"query", "type":"STRING" },
				{ "name":"type", "type":"STRING" }, // defaults to "all", can by "any" or "phrase"
				{ "name":"results", "type":"INTEGER" }, // defaults to 10
				{ "name":"start", "type":"INTEGER" }, // defaults to 1
				{ "name":"format", "type":"STRING" }, // defaults to "any", can be "bmp", "gif", "jpeg", or "png"
				{ "name":"adult_ok", "type":"INTEGER" }, // defaults to null
				{ "name":"coloration", "type":"STRING" }, // "any", "color", or "bw"
				{ "name":"site", "type":"STRING" } // defaults to null
			]
		},
		//
		// SITE EXPLORER
		//
		{
			// http://developer.yahoo.com/search/siteexplorer/V1/inlinkData.html 
			"name":"inlinkData",
			"serviceURL": "http://api.search.yahoo.com/SiteExplorerService/V1/inlinkData",
			"parameters":[
				{ "name":"query", "type":"STRING" },
				{ "name":"type", "type":"STRING" }, // defaults to "all", can by "any" or "phrase"
				{ "name":"entire_site", "type":"INTEGER" }, // defaults to null
				{ "name":"omit_inlinks", "type":"STRING" }, // "domain" or "subdomain", defaults to null
				{ "name":"results", "type":"INTEGER" }, // defaults to 50
				{ "name":"start", "type":"INTEGER" }, // defaults to 1
				{ "name":"site", "type":"STRING" } // defaults to null
			]
		},
		{
			// http://developer.yahoo.com/search/siteexplorer/V1/pageData.html
			"name":"pageData",
			"serviceURL": "http://api.search.yahoo.com/SiteExplorerService/V1/pageData",
			"parameters":[
				{ "name":"query", "type":"STRING" },
				{ "name":"type", "type":"STRING" }, // defaults to "all", can by "any" or "phrase"
				{ "name":"domain_only", "type":"INTEGER" }, // defaults to null
				{ "name":"results", "type":"INTEGER" }, // defaults to 50
				{ "name":"start", "type":"INTEGER" }, // defaults to 1
				{ "name":"site", "type":"STRING" } // defaults to null
			]
		},
		//
		// MUSIC SEARCH
		//
		{
			// http://developer.yahoo.com/search/audio/V1/artistSearch.html
			"name":"artistSearch",
			"serviceURL": "http://api.search.yahoo.com/AudioSearchService/V1/artistSearch",
			"parameters":[
				{ "name":"artist", "type":"STRING" },
				{ "name":"artistid", "type":"STRING" },
				{ "name":"type", "type":"STRING" }, // "all", "any", or "phrase"
				{ "name":"results", "type":"INTEGER" }, // 1-50, defaults to 10
				{ "name":"start", "type":"INTEGER" } // defaults to 1
			]
		},
		{
			// http://developer.yahoo.com/search/audio/V1/albumSearch.html
			"name":"albumSearch",
			"serviceURL": "http://api.search.yahoo.com/AudioSearchService/V1/albumSearch",
			"parameters":[
				{ "name":"artist", "type":"STRING" },
				{ "name":"artistid", "type":"STRING" },
				{ "name":"album", "type":"STRING" },
				{ "name":"type", "type":"STRING" }, // "all", "any", or "phrase"
				{ "name":"results", "type":"INTEGER" }, // 1-50, defaults to 10
				{ "name":"start", "type":"INTEGER" } // defaults to 1
			]
		},
		{
			// http://developer.yahoo.com/search/audio/V1/songSearch.html
			"name":"songSearch",
			"serviceURL": "http://api.search.yahoo.com/AudioSearchService/V1/songSearch",
			"parameters":[
				{ "name":"artist", "type":"STRING" },
				{ "name":"artistid", "type":"STRING" },
				{ "name":"album", "type":"STRING" },
				{ "name":"albumid", "type":"STRING" },
				{ "name":"song", "type":"STRING" },
				{ "name":"songid", "type":"STRING" },
				{ "name":"type", "type":"STRING" }, // "all", "any", or "phrase"
				{ "name":"results", "type":"INTEGER" }, // 1-50, defaults to 10
				{ "name":"start", "type":"INTEGER" } // defaults to 1
			]
		},
		{
			// http://developer.yahoo.com/search/audio/V1/songDownloadLocation.html
			"name":"songDownloadLocation",
			"serviceURL": "http://api.search.yahoo.com/AudioSearchService/V1/songDownloadLocation",
			"parameters":[
				{ "name":"songid", "type":"STRING" },
				// "source" can contain:
				//	audiolunchbox artistdirect buymusic dmusic
				//	emusic epitonic garageband itunes yahoo
				//	livedownloads mp34u msn musicmatch mapster passalong
				//	rhapsody soundclick theweb
				{ "name":"source", "type":"STRING" },
				{ "name":"results", "type":"INTEGER" }, // 1-50, defaults to 10
				{ "name":"start", "type":"INTEGER" } // defaults to 1
			]
		},
		//
		// NEWS SEARCH
		//
		{
			// http://developer.yahoo.com/search/news/V1/newsSearch.html
			"name":"newsSearch",
			"serviceURL": "http://api.search.yahoo.com/NewsSearchService/V1/newsSearch",
			"parameters":[
				{ "name":"query", "type":"STRING" },
				{ "name":"type", "type":"STRING" }, // defaults to "all"
				{ "name":"results", "type":"INTEGER" }, // defaults to 10
				{ "name":"start", "type":"INTEGER" }, // defaults to 1
				{ "name":"sort", "type":"STRING" }, // "rank" or "date"
				{ "name":"language", "type":"STRING" }, // defaults to null
				{ "name":"site", "type":"STRING" } // defaults to null
			]
		}
		/*
		{
			// 
			"name":"",
			"serviceURL": "",
			"parameters":[
				{ "name":"street", "type":"STRING" },
			]
		}
		*/
	]
}

__CPAN_FILE__ src/rpc/JotService.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.rpc.JotService"], ["require", "dojo.rpc.RpcService"], ["require", "dojo.rpc.JsonService"], ["require", "dojo.json"]], definePackage:function (dojo) {
	dojo.provide("dojo.rpc.JotService");
	dojo.require("dojo.rpc.RpcService");
	dojo.require("dojo.rpc.JsonService");
	dojo.require("dojo.json");
	dojo.rpc.JotService = function () {
		this.serviceUrl = "/_/jsonrpc";
	};
	dojo.inherits(dojo.rpc.JotService, dojo.rpc.JsonService);
	dojo.lang.extend(dojo.rpc.JotService, {bind:function (method, parameters, deferredRequestHandler, url) {
		dojo.io.bind({url:url || this.serviceUrl, content:{json:this.createRequest(method, parameters)}, method:"POST", mimetype:"text/json", load:this.resultCallback(deferredRequestHandler), error:this.errorCallback(deferredRequestHandler), preventCache:true});
	}, createRequest:function (method, params) {
		var req = {"params":params, "method":method, "id":this.lastSubmissionId++};
		return dojo.json.serialize(req);
	}});
}});


__CPAN_FILE__ src/rpc/RpcService.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.rpc.RpcService");
dojo.require("dojo.io.*");
dojo.require("dojo.json");
dojo.require("dojo.lang.func");
dojo.require("dojo.Deferred");
dojo.rpc.RpcService = function (url) {
	if (url) {
		this.connect(url);
	}
};
dojo.lang.extend(dojo.rpc.RpcService, {strictArgChecks:true, serviceUrl:"", parseResults:function (obj) {
	return obj;
}, errorCallback:function (deferredRequestHandler) {
	return function (type, e) {
		deferredRequestHandler.errback(new Error(e.message));
	};
}, resultCallback:function (deferredRequestHandler) {
	var tf = dojo.lang.hitch(this, function (type, obj, e) {
		if (obj["error"] != null) {
			var err = new Error(obj.error);
			err.id = obj.id;
			deferredRequestHandler.errback(err);
		} else {
			var results = this.parseResults(obj);
			deferredRequestHandler.callback(results);
		}
	});
	return tf;
}, generateMethod:function (method, parameters, url) {
	return dojo.lang.hitch(this, function () {
		var deferredRequestHandler = new dojo.Deferred();
		if ((this.strictArgChecks) && (parameters != null) && (arguments.length != parameters.length)) {
			dojo.raise("Invalid number of parameters for remote method.");
		} else {
			this.bind(method, arguments, deferredRequestHandler, url);
		}
		return deferredRequestHandler;
	});
}, processSmd:function (object) {
	dojo.debug("RpcService: Processing returned SMD.");
	if (object.methods) {
		dojo.lang.forEach(object.methods, function (m) {
			if (m && m["name"]) {
				dojo.debug("RpcService: Creating Method: this.", m.name, "()");
				this[m.name] = this.generateMethod(m.name, m.parameters, m["url"] || m["serviceUrl"] || m["serviceURL"]);
				if (dojo.lang.isFunction(this[m.name])) {
					dojo.debug("RpcService: Successfully created", m.name, "()");
				} else {
					dojo.debug("RpcService: Failed to create", m.name, "()");
				}
			}
		}, this);
	}
	this.serviceUrl = object.serviceUrl || object.serviceURL;
	dojo.debug("RpcService: Dojo RpcService is ready for use.");
}, connect:function (smdUrl) {
	dojo.debug("RpcService: Attempting to load SMD document from:", smdUrl);
	dojo.io.bind({url:smdUrl, mimetype:"text/json", load:dojo.lang.hitch(this, function (type, object, e) {
		return this.processSmd(object);
	}), sync:true});
}});


__CPAN_FILE__ src/rpc/JsonService.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.rpc.JsonService"], ["require", "dojo.rpc.RpcService"], ["require", "dojo.io.*"], ["require", "dojo.json"], ["require", "dojo.lang.common"]], definePackage:function (dojo) {
	dojo.provide("dojo.rpc.JsonService");
	dojo.require("dojo.rpc.RpcService");
	dojo.require("dojo.io.*");
	dojo.require("dojo.json");
	dojo.require("dojo.lang.common");
	dojo.rpc.JsonService = function (args) {
		if (args) {
			if (dojo.lang.isString(args)) {
				this.connect(args);
			} else {
				if (args["smdUrl"]) {
					this.connect(args.smdUrl);
				}
				if (args["smdStr"]) {
					this.processSmd(dj_eval("(" + args.smdStr + ")"));
				}
				if (args["smdObj"]) {
					this.processSmd(args.smdObj);
				}
				if (args["serviceUrl"]) {
					this.serviceUrl = args.serviceUrl;
				}
				if (typeof args["strictArgChecks"] != "undefined") {
					this.strictArgChecks = args.strictArgChecks;
				}
			}
		}
	};
	dojo.inherits(dojo.rpc.JsonService, dojo.rpc.RpcService);
	dojo.extend(dojo.rpc.JsonService, {bustCache:false, contentType:"application/json-rpc", lastSubmissionId:0, callRemote:function (method, params) {
		var deferred = new dojo.Deferred();
		this.bind(method, params, deferred);
		return deferred;
	}, bind:function (method, parameters, deferredRequestHandler, url) {
		dojo.io.bind({url:url || this.serviceUrl, postContent:this.createRequest(method, parameters), method:"POST", contentType:this.contentType, mimetype:"text/json", load:this.resultCallback(deferredRequestHandler), error:this.errorCallback(deferredRequestHandler), preventCache:this.bustCache});
	}, createRequest:function (method, params) {
		var req = {"params":params, "method":method, "id":++this.lastSubmissionId};
		var data = dojo.json.serialize(req);
		dojo.debug("JsonService: JSON-RPC Request: " + data);
		return data;
	}, parseResults:function (obj) {
		if (!obj) {
			return;
		}
		if (obj["Result"] != null) {
			return obj["Result"];
		} else {
			if (obj["result"] != null) {
				return obj["result"];
			} else {
				if (obj["ResultSet"]) {
					return obj["ResultSet"];
				} else {
					return obj;
				}
			}
		}
	}});
}});


__CPAN_FILE__ src/rpc/__package__.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.kwCompoundRequire({common:[["dojo.rpc.JsonService", false, false]]});
dojo.provide("dojo.rpc.*");


__CPAN_FILE__ src/rpc/JotService.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.rpc.JotService");
dojo.require("dojo.rpc.RpcService");
dojo.require("dojo.rpc.JsonService");
dojo.require("dojo.json");
dojo.rpc.JotService = function () {
	this.serviceUrl = "/_/jsonrpc";
};
dojo.inherits(dojo.rpc.JotService, dojo.rpc.JsonService);
dojo.lang.extend(dojo.rpc.JotService, {bind:function (method, parameters, deferredRequestHandler, url) {
	dojo.io.bind({url:url || this.serviceUrl, content:{json:this.createRequest(method, parameters)}, method:"POST", mimetype:"text/json", load:this.resultCallback(deferredRequestHandler), error:this.errorCallback(deferredRequestHandler), preventCache:true});
}, createRequest:function (method, params) {
	var req = {"params":params, "method":method, "id":this.lastSubmissionId++};
	return dojo.json.serialize(req);
}});


__CPAN_FILE__ src/rpc/YahooService.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.rpc.YahooService"], ["require", "dojo.rpc.RpcService"], ["require", "dojo.rpc.JsonService"], ["require", "dojo.json"], ["require", "dojo.uri.*"], ["require", "dojo.io.ScriptSrcIO"]], definePackage:function (dojo) {
	dojo.provide("dojo.rpc.YahooService");
	dojo.require("dojo.rpc.RpcService");
	dojo.require("dojo.rpc.JsonService");
	dojo.require("dojo.json");
	dojo.require("dojo.uri.*");
	dojo.require("dojo.io.ScriptSrcIO");
	dojo.rpc.YahooService = function (appId) {
		this.appId = appId;
		if (!appId) {
			this.appId = "dojotoolkit";
			dojo.debug("please initialize the YahooService class with your own", "application ID. Using the default may cause problems during", "deployment of your application");
		}
		if (djConfig["useXDomain"] && !djConfig["yahooServiceSmdUrl"]) {
			dojo.debug("dojo.rpc.YahooService: When using cross-domain Dojo builds," + " please save yahoo.smd to your domain and set djConfig.yahooServiceSmdUrl" + " to the path on your domain to yahoo.smd");
		}
		this.connect(djConfig["yahooServiceSmdUrl"] || dojo.uri.moduleUri("dojo.rpc", "yahoo.smd"));
		this.strictArgChecks = false;
	};
	dojo.inherits(dojo.rpc.YahooService, dojo.rpc.JsonService);
	dojo.lang.extend(dojo.rpc.YahooService, {strictArgChecks:false, bind:function (method, parameters, deferredRequestHandler, url) {
		var params = parameters;
		if ((dojo.lang.isArrayLike(parameters)) && (parameters.length == 1)) {
			params = parameters[0];
		}
		params.output = "json";
		params.appid = this.appId;
		dojo.io.bind({url:url || this.serviceUrl, transport:"ScriptSrcTransport", content:params, jsonParamName:"callback", mimetype:"text/json", load:this.resultCallback(deferredRequestHandler), error:this.errorCallback(deferredRequestHandler), preventCache:true});
	}});
}});


__CPAN_FILE__ src/rpc/__package__.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["kwCompoundRequire", {common:[["dojo.rpc.JsonService", false, false]]}], ["provide", "dojo.rpc.*"]], definePackage:function (dojo) {
	dojo.kwCompoundRequire({common:[["dojo.rpc.JsonService", false, false]]});
	dojo.provide("dojo.rpc.*");
}});


__CPAN_FILE__ src/rpc/JsonService.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.rpc.JsonService");
dojo.require("dojo.rpc.RpcService");
dojo.require("dojo.io.*");
dojo.require("dojo.json");
dojo.require("dojo.lang.common");
dojo.rpc.JsonService = function (args) {
	if (args) {
		if (dojo.lang.isString(args)) {
			this.connect(args);
		} else {
			if (args["smdUrl"]) {
				this.connect(args.smdUrl);
			}
			if (args["smdStr"]) {
				this.processSmd(dj_eval("(" + args.smdStr + ")"));
			}
			if (args["smdObj"]) {
				this.processSmd(args.smdObj);
			}
			if (args["serviceUrl"]) {
				this.serviceUrl = args.serviceUrl;
			}
			if (typeof args["strictArgChecks"] != "undefined") {
				this.strictArgChecks = args.strictArgChecks;
			}
		}
	}
};
dojo.inherits(dojo.rpc.JsonService, dojo.rpc.RpcService);
dojo.extend(dojo.rpc.JsonService, {bustCache:false, contentType:"application/json-rpc", lastSubmissionId:0, callRemote:function (method, params) {
	var deferred = new dojo.Deferred();
	this.bind(method, params, deferred);
	return deferred;
}, bind:function (method, parameters, deferredRequestHandler, url) {
	dojo.io.bind({url:url || this.serviceUrl, postContent:this.createRequest(method, parameters), method:"POST", contentType:this.contentType, mimetype:"text/json", load:this.resultCallback(deferredRequestHandler), error:this.errorCallback(deferredRequestHandler), preventCache:this.bustCache});
}, createRequest:function (method, params) {
	var req = {"params":params, "method":method, "id":++this.lastSubmissionId};
	var data = dojo.json.serialize(req);
	dojo.debug("JsonService: JSON-RPC Request: " + data);
	return data;
}, parseResults:function (obj) {
	if (!obj) {
		return;
	}
	if (obj["Result"] != null) {
		return obj["Result"];
	} else {
		if (obj["result"] != null) {
			return obj["result"];
		} else {
			if (obj["ResultSet"]) {
				return obj["ResultSet"];
			} else {
				return obj;
			}
		}
	}
}});


__CPAN_FILE__ src/rpc/RpcService.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.rpc.RpcService"], ["require", "dojo.io.*"], ["require", "dojo.json"], ["require", "dojo.lang.func"], ["require", "dojo.Deferred"]], definePackage:function (dojo) {
	dojo.provide("dojo.rpc.RpcService");
	dojo.require("dojo.io.*");
	dojo.require("dojo.json");
	dojo.require("dojo.lang.func");
	dojo.require("dojo.Deferred");
	dojo.rpc.RpcService = function (url) {
		if (url) {
			this.connect(url);
		}
	};
	dojo.lang.extend(dojo.rpc.RpcService, {strictArgChecks:true, serviceUrl:"", parseResults:function (obj) {
		return obj;
	}, errorCallback:function (deferredRequestHandler) {
		return function (type, e) {
			deferredRequestHandler.errback(new Error(e.message));
		};
	}, resultCallback:function (deferredRequestHandler) {
		var tf = dojo.lang.hitch(this, function (type, obj, e) {
			if (obj["error"] != null) {
				var err = new Error(obj.error);
				err.id = obj.id;
				deferredRequestHandler.errback(err);
			} else {
				var results = this.parseResults(obj);
				deferredRequestHandler.callback(results);
			}
		});
		return tf;
	}, generateMethod:function (method, parameters, url) {
		return dojo.lang.hitch(this, function () {
			var deferredRequestHandler = new dojo.Deferred();
			if ((this.strictArgChecks) && (parameters != null) && (arguments.length != parameters.length)) {
				dojo.raise("Invalid number of parameters for remote method.");
			} else {
				this.bind(method, arguments, deferredRequestHandler, url);
			}
			return deferredRequestHandler;
		});
	}, processSmd:function (object) {
		dojo.debug("RpcService: Processing returned SMD.");
		if (object.methods) {
			dojo.lang.forEach(object.methods, function (m) {
				if (m && m["name"]) {
					dojo.debug("RpcService: Creating Method: this.", m.name, "()");
					this[m.name] = this.generateMethod(m.name, m.parameters, m["url"] || m["serviceUrl"] || m["serviceURL"]);
					if (dojo.lang.isFunction(this[m.name])) {
						dojo.debug("RpcService: Successfully created", m.name, "()");
					} else {
						dojo.debug("RpcService: Failed to create", m.name, "()");
					}
				}
			}, this);
		}
		this.serviceUrl = object.serviceUrl || object.serviceURL;
		dojo.debug("RpcService: Dojo RpcService is ready for use.");
	}, connect:function (smdUrl) {
		dojo.debug("RpcService: Attempting to load SMD document from:", smdUrl);
		dojo.io.bind({url:smdUrl, mimetype:"text/json", load:dojo.lang.hitch(this, function (type, object, e) {
			return this.processSmd(object);
		}), sync:true});
	}});
}});


__CPAN_FILE__ src/rpc/Deferred.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.rpc.Deferred"], ["require", "dojo.Deferred"]], definePackage:function (dojo) {
	dojo.provide("dojo.rpc.Deferred");
	dojo.require("dojo.Deferred");
	dojo.deprecated("dojo.rpc.Deferred", "replaced by dojo.Deferred", "0.6");
	dojo.rpc.Deferred = dojo.Deferred;
	dojo.rpc.Deferred.prototype = dojo.Deferred.prototype;
}});


__CPAN_DIR__ src/validate
__CPAN_FILE__ src/validate/datetime.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.validate.datetime"], ["require", "dojo.validate.common"]], definePackage:function (dojo) {
	dojo.provide("dojo.validate.datetime");
	dojo.require("dojo.validate.common");
	dojo.validate.isValidTime = function (value, flags) {
		dojo.deprecated("dojo.validate.datetime", "use dojo.date.parse instead", "0.5");
		var re = new RegExp("^" + dojo.regexp.time(flags) + "$", "i");
		return re.test(value);
	};
	dojo.validate.is12HourTime = function (value) {
		dojo.deprecated("dojo.validate.datetime", "use dojo.date.parse instead", "0.5");
		return dojo.validate.isValidTime(value, {format:["h:mm:ss t", "h:mm t"]});
	};
	dojo.validate.is24HourTime = function (value) {
		dojo.deprecated("dojo.validate.datetime", "use dojo.date.parse instead", "0.5");
		return dojo.validate.isValidTime(value, {format:["HH:mm:ss", "HH:mm"]});
	};
	dojo.validate.isValidDate = function (dateValue, format) {
		dojo.deprecated("dojo.validate.datetime", "use dojo.date.parse instead", "0.5");
		if (typeof format == "object" && typeof format.format == "string") {
			format = format.format;
		}
		if (typeof format != "string") {
			format = "MM/DD/YYYY";
		}
		var reLiteral = format.replace(/([$^.*+?=!:|\/\\\(\)\[\]\{\}])/g, "\\$1");
		reLiteral = reLiteral.replace("YYYY", "([0-9]{4})");
		reLiteral = reLiteral.replace("MM", "(0[1-9]|10|11|12)");
		reLiteral = reLiteral.replace("M", "([1-9]|10|11|12)");
		reLiteral = reLiteral.replace("DDD", "(00[1-9]|0[1-9][0-9]|[12][0-9][0-9]|3[0-5][0-9]|36[0-6])");
		reLiteral = reLiteral.replace("DD", "(0[1-9]|[12][0-9]|30|31)");
		reLiteral = reLiteral.replace("D", "([1-9]|[12][0-9]|30|31)");
		reLiteral = reLiteral.replace("ww", "(0[1-9]|[1-4][0-9]|5[0-3])");
		reLiteral = reLiteral.replace("d", "([1-7])");
		reLiteral = "^" + reLiteral + "$";
		var re = new RegExp(reLiteral);
		if (!re.test(dateValue)) {
			return false;
		}
		var year = 0, month = 1, date = 1, dayofyear = 1, week = 1, day = 1;
		var tokens = format.match(/(YYYY|MM|M|DDD|DD|D|ww|d)/g);
		var values = re.exec(dateValue);
		for (var i = 0; i < tokens.length; i++) {
			switch (tokens[i]) {
			  case "YYYY":
				year = Number(values[i + 1]);
				break;
			  case "M":
			  case "MM":
				month = Number(values[i + 1]);
				break;
			  case "D":
			  case "DD":
				date = Number(values[i + 1]);
				break;
			  case "DDD":
				dayofyear = Number(values[i + 1]);
				break;
			  case "ww":
				week = Number(values[i + 1]);
				break;
			  case "d":
				day = Number(values[i + 1]);
				break;
			}
		}
		var leapyear = (year % 4 == 0 && (year % 100 != 0 || year % 400 == 0));
		if (date == 31 && (month == 4 || month == 6 || month == 9 || month == 11)) {
			return false;
		}
		if (date >= 30 && month == 2) {
			return false;
		}
		if (date == 29 && month == 2 && !leapyear) {
			return false;
		}
		if (dayofyear == 366 && !leapyear) {
			return false;
		}
		return true;
	};
}});


__CPAN_FILE__ src/validate/us.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.validate.us"], ["require", "dojo.validate.common"]], definePackage:function (dojo) {
	dojo.provide("dojo.validate.us");
	dojo.require("dojo.validate.common");
	dojo.validate.us.isCurrency = function (value, flags) {
		return dojo.validate.isCurrency(value, flags);
	};
	dojo.validate.us.isState = function (value, flags) {
		var re = new RegExp("^" + dojo.regexp.us.state(flags) + "$", "i");
		return re.test(value);
	};
	dojo.validate.us.isPhoneNumber = function (value) {
		var flags = {format:["###-###-####", "(###) ###-####", "(###) ### ####", "###.###.####", "###/###-####", "### ### ####", "###-###-#### x#???", "(###) ###-#### x#???", "(###) ### #### x#???", "###.###.#### x#???", "###/###-#### x#???", "### ### #### x#???", "##########"]};
		return dojo.validate.isNumberFormat(value, flags);
	};
	dojo.validate.us.isSocialSecurityNumber = function (value) {
		var flags = {format:["###-##-####", "### ## ####", "#########"]};
		return dojo.validate.isNumberFormat(value, flags);
	};
	dojo.validate.us.isZipCode = function (value) {
		var flags = {format:["#####-####", "##### ####", "#########", "#####"]};
		return dojo.validate.isNumberFormat(value, flags);
	};
}});


__CPAN_FILE__ src/validate/common.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.validate.common");
dojo.require("dojo.regexp");
dojo.validate.isText = function (value, flags) {
	flags = (typeof flags == "object") ? flags : {};
	if (/^\s*$/.test(value)) {
		return false;
	}
	if (typeof flags.length == "number" && flags.length != value.length) {
		return false;
	}
	if (typeof flags.minlength == "number" && flags.minlength > value.length) {
		return false;
	}
	if (typeof flags.maxlength == "number" && flags.maxlength < value.length) {
		return false;
	}
	return true;
};
dojo.validate.isInteger = function (value, flags) {
	var re = new RegExp("^" + dojo.regexp.integer(flags) + "$");
	return re.test(value);
};
dojo.validate.isRealNumber = function (value, flags) {
	var re = new RegExp("^" + dojo.regexp.realNumber(flags) + "$");
	return re.test(value);
};
dojo.validate.isCurrency = function (value, flags) {
	var re = new RegExp("^" + dojo.regexp.currency(flags) + "$");
	return re.test(value);
};
dojo.validate._isInRangeCache = {};
dojo.validate.isInRange = function (value, flags) {
	value = value.replace(dojo.lang.has(flags, "separator") ? flags.separator : ",", "", "g").replace(dojo.lang.has(flags, "symbol") ? flags.symbol : "$", "");
	if (isNaN(value)) {
		return false;
	}
	flags = (typeof flags == "object") ? flags : {};
	var max = (typeof flags.max == "number") ? flags.max : Infinity;
	var min = (typeof flags.min == "number") ? flags.min : -Infinity;
	var dec = (typeof flags.decimal == "string") ? flags.decimal : ".";
	var cache = dojo.validate._isInRangeCache;
	var cacheIdx = value + "max" + max + "min" + min + "dec" + dec;
	if (typeof cache[cacheIdx] != "undefined") {
		return cache[cacheIdx];
	}
	var pattern = "[^" + dec + "\\deE+-]";
	value = value.replace(RegExp(pattern, "g"), "");
	value = value.replace(/^([+-]?)(\D*)/, "$1");
	value = value.replace(/(\D*)$/, "");
	pattern = "(\\d)[" + dec + "](\\d)";
	value = value.replace(RegExp(pattern, "g"), "$1.$2");
	value = Number(value);
	if (value < min || value > max) {
		cache[cacheIdx] = false;
		return false;
	}
	cache[cacheIdx] = true;
	return true;
};
dojo.validate.isNumberFormat = function (value, flags) {
	var re = new RegExp("^" + dojo.regexp.numberFormat(flags) + "$", "i");
	return re.test(value);
};
dojo.validate.isValidLuhn = function (value) {
	var sum, parity, curDigit;
	if (typeof value != "string") {
		value = String(value);
	}
	value = value.replace(/[- ]/g, "");
	parity = value.length % 2;
	sum = 0;
	for (var i = 0; i < value.length; i++) {
		curDigit = parseInt(value.charAt(i));
		if (i % 2 == parity) {
			curDigit *= 2;
		}
		if (curDigit > 9) {
			curDigit -= 9;
		}
		sum += curDigit;
	}
	return !(sum % 10);
};


__CPAN_FILE__ src/validate/us.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.validate.us");
dojo.require("dojo.validate.common");
dojo.validate.us.isCurrency = function (value, flags) {
	return dojo.validate.isCurrency(value, flags);
};
dojo.validate.us.isState = function (value, flags) {
	var re = new RegExp("^" + dojo.regexp.us.state(flags) + "$", "i");
	return re.test(value);
};
dojo.validate.us.isPhoneNumber = function (value) {
	var flags = {format:["###-###-####", "(###) ###-####", "(###) ### ####", "###.###.####", "###/###-####", "### ### ####", "###-###-#### x#???", "(###) ###-#### x#???", "(###) ### #### x#???", "###.###.#### x#???", "###/###-#### x#???", "### ### #### x#???", "##########"]};
	return dojo.validate.isNumberFormat(value, flags);
};
dojo.validate.us.isSocialSecurityNumber = function (value) {
	var flags = {format:["###-##-####", "### ## ####", "#########"]};
	return dojo.validate.isNumberFormat(value, flags);
};
dojo.validate.us.isZipCode = function (value) {
	var flags = {format:["#####-####", "##### ####", "#########", "#####"]};
	return dojo.validate.isNumberFormat(value, flags);
};


__CPAN_FILE__ src/validate/de.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.validate.de");
dojo.require("dojo.validate.common");
dojo.validate.isGermanCurrency = function (value) {
	var flags = {symbol:"\u20ac", placement:"after", signPlacement:"begin", decimal:",", separator:"."};
	return dojo.validate.isCurrency(value, flags);
};


__CPAN_FILE__ src/validate/jp.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.validate.jp");
dojo.require("dojo.validate.common");
dojo.validate.isJapaneseCurrency = function (value) {
	var flags = {symbol:"\xa5", fractional:false};
	return dojo.validate.isCurrency(value, flags);
};


__CPAN_FILE__ src/validate/check.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.validate.check"], ["require", "dojo.validate.common"], ["require", "dojo.lang.common"]], definePackage:function (dojo) {
	dojo.provide("dojo.validate.check");
	dojo.require("dojo.validate.common");
	dojo.require("dojo.lang.common");
	dojo.validate.check = function (form, profile) {
		var missing = [];
		var invalid = [];
		var results = {isSuccessful:function () {
			return (!this.hasInvalid() && !this.hasMissing());
		}, hasMissing:function () {
			return (missing.length > 0);
		}, getMissing:function () {
			return missing;
		}, isMissing:function (elemname) {
			for (var i = 0; i < missing.length; i++) {
				if (elemname == missing[i]) {
					return true;
				}
			}
			return false;
		}, hasInvalid:function () {
			return (invalid.length > 0);
		}, getInvalid:function () {
			return invalid;
		}, isInvalid:function (elemname) {
			for (var i = 0; i < invalid.length; i++) {
				if (elemname == invalid[i]) {
					return true;
				}
			}
			return false;
		}};
		if (profile.trim instanceof Array) {
			for (var i = 0; i < profile.trim.length; i++) {
				var elem = form[profile.trim[i]];
				if (dj_undef("type", elem) || elem.type != "text" && elem.type != "textarea" && elem.type != "password") {
					continue;
				}
				elem.value = elem.value.replace(/(^\s*|\s*$)/g, "");
			}
		}
		if (profile.uppercase instanceof Array) {
			for (var i = 0; i < profile.uppercase.length; i++) {
				var elem = form[profile.uppercase[i]];
				if (dj_undef("type", elem) || elem.type != "text" && elem.type != "textarea" && elem.type != "password") {
					continue;
				}
				elem.value = elem.value.toUpperCase();
			}
		}
		if (profile.lowercase instanceof Array) {
			for (var i = 0; i < profile.lowercase.length; i++) {
				var elem = form[profile.lowercase[i]];
				if (dj_undef("type", elem) || elem.type != "text" && elem.type != "textarea" && elem.type != "password") {
					continue;
				}
				elem.value = elem.value.toLowerCase();
			}
		}
		if (profile.ucfirst instanceof Array) {
			for (var i = 0; i < profile.ucfirst.length; i++) {
				var elem = form[profile.ucfirst[i]];
				if (dj_undef("type", elem) || elem.type != "text" && elem.type != "textarea" && elem.type != "password") {
					continue;
				}
				elem.value = elem.value.replace(/\b\w+\b/g, function (word) {
					return word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase();
				});
			}
		}
		if (profile.digit instanceof Array) {
			for (var i = 0; i < profile.digit.length; i++) {
				var elem = form[profile.digit[i]];
				if (dj_undef("type", elem) || elem.type != "text" && elem.type != "textarea" && elem.type != "password") {
					continue;
				}
				elem.value = elem.value.replace(/\D/g, "");
			}
		}
		if (profile.required instanceof Array) {
			for (var i = 0; i < profile.required.length; i++) {
				if (!dojo.lang.isString(profile.required[i])) {
					continue;
				}
				var elem = form[profile.required[i]];
				if (!dj_undef("type", elem) && (elem.type == "text" || elem.type == "textarea" || elem.type == "password") && /^\s*$/.test(elem.value)) {
					missing[missing.length] = elem.name;
				} else {
					if (!dj_undef("type", elem) && (elem.type == "select-one" || elem.type == "select-multiple") && (elem.selectedIndex == -1 || /^\s*$/.test(elem.options[elem.selectedIndex].value))) {
						missing[missing.length] = elem.name;
					} else {
						if (elem instanceof Array) {
							var checked = false;
							for (var j = 0; j < elem.length; j++) {
								if (elem[j].checked) {
									checked = true;
								}
							}
							if (!checked) {
								missing[missing.length] = elem[0].name;
							}
						}
					}
				}
			}
		}
		if (profile.required instanceof Array) {
			for (var i = 0; i < profile.required.length; i++) {
				if (!dojo.lang.isObject(profile.required[i])) {
					continue;
				}
				var elem, numRequired;
				for (var name in profile.required[i]) {
					elem = form[name];
					numRequired = profile.required[i][name];
				}
				if (elem instanceof Array) {
					var checked = 0;
					for (var j = 0; j < elem.length; j++) {
						if (elem[j].checked) {
							checked++;
						}
					}
					if (checked < numRequired) {
						missing[missing.length] = elem[0].name;
					}
				} else {
					if (!dj_undef("type", elem) && elem.type == "select-multiple") {
						var selected = 0;
						for (var j = 0; j < elem.options.length; j++) {
							if (elem.options[j].selected && !/^\s*$/.test(elem.options[j].value)) {
								selected++;
							}
						}
						if (selected < numRequired) {
							missing[missing.length] = elem.name;
						}
					}
				}
			}
		}
		if (dojo.lang.isObject(profile.dependencies) || dojo.lang.isObject(profile.dependancies)) {
			if (profile["dependancies"]) {
				dojo.deprecated("dojo.validate.check", "profile 'dependancies' is deprecated, please use " + "'dependencies'", "0.5");
				profile.dependencies = profile.dependancies;
			}
			for (name in profile.dependencies) {
				var elem = form[name];
				if (dj_undef("type", elem)) {
					continue;
				}
				if (elem.type != "text" && elem.type != "textarea" && elem.type != "password") {
					continue;
				}
				if (/\S+/.test(elem.value)) {
					continue;
				}
				if (results.isMissing(elem.name)) {
					continue;
				}
				var target = form[profile.dependencies[name]];
				if (target.type != "text" && target.type != "textarea" && target.type != "password") {
					continue;
				}
				if (/^\s*$/.test(target.value)) {
					continue;
				}
				missing[missing.length] = elem.name;
			}
		}
		if (dojo.lang.isObject(profile.constraints)) {
			for (name in profile.constraints) {
				var elem = form[name];
				if (!elem) {
					continue;
				}
				if (!dj_undef("tagName", elem) && (elem.tagName.toLowerCase().indexOf("input") >= 0 || elem.tagName.toLowerCase().indexOf("textarea") >= 0) && /^\s*$/.test(elem.value)) {
					continue;
				}
				var isValid = true;
				if (dojo.lang.isFunction(profile.constraints[name])) {
					isValid = profile.constraints[name](elem.value);
				} else {
					if (dojo.lang.isArray(profile.constraints[name])) {
						if (dojo.lang.isArray(profile.constraints[name][0])) {
							for (var i = 0; i < profile.constraints[name].length; i++) {
								isValid = dojo.validate.evaluateConstraint(profile, profile.constraints[name][i], name, elem);
								if (!isValid) {
									break;
								}
							}
						} else {
							isValid = dojo.validate.evaluateConstraint(profile, profile.constraints[name], name, elem);
						}
					}
				}
				if (!isValid) {
					invalid[invalid.length] = elem.name;
				}
			}
		}
		if (dojo.lang.isObject(profile.confirm)) {
			for (name in profile.confirm) {
				var elem = form[name];
				var target = form[profile.confirm[name]];
				if (dj_undef("type", elem) || dj_undef("type", target) || (elem.type != "text" && elem.type != "textarea" && elem.type != "password") || (target.type != elem.type) || (target.value == elem.value) || (results.isInvalid(elem.name)) || (/^\s*$/.test(target.value))) {
					continue;
				}
				invalid[invalid.length] = elem.name;
			}
		}
		return results;
	};
	dojo.validate.evaluateConstraint = function (profile, constraint, fieldName, elem) {
		var isValidSomething = constraint[0];
		var params = constraint.slice(1);
		params.unshift(elem.value);
		if (typeof isValidSomething != "undefined") {
			return isValidSomething.apply(null, params);
		}
		return false;
	};
}});


__CPAN_FILE__ src/validate/de.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.validate.de"], ["require", "dojo.validate.common"]], definePackage:function (dojo) {
	dojo.provide("dojo.validate.de");
	dojo.require("dojo.validate.common");
	dojo.validate.isGermanCurrency = function (value) {
		var flags = {symbol:"\u20ac", placement:"after", signPlacement:"begin", decimal:",", separator:"."};
		return dojo.validate.isCurrency(value, flags);
	};
}});


__CPAN_FILE__ src/validate/__package__.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.require("dojo.validate");
dojo.kwCompoundRequire({common:["dojo.validate.check", "dojo.validate.datetime", "dojo.validate.de", "dojo.validate.jp", "dojo.validate.us", "dojo.validate.web"]});
dojo.provide("dojo.validate.*");


__CPAN_FILE__ src/validate/__package__.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["require", "dojo.validate"], ["kwCompoundRequire", {common:["dojo.validate.check", "dojo.validate.datetime", "dojo.validate.de", "dojo.validate.jp", "dojo.validate.us", "dojo.validate.web"]}], ["provide", "dojo.validate.*"]], definePackage:function (dojo) {
	dojo.require("dojo.validate");
	dojo.kwCompoundRequire({common:["dojo.validate.check", "dojo.validate.datetime", "dojo.validate.de", "dojo.validate.jp", "dojo.validate.us", "dojo.validate.web"]});
	dojo.provide("dojo.validate.*");
}});


__CPAN_FILE__ src/validate/common.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.validate.common"], ["require", "dojo.regexp"]], definePackage:function (dojo) {
	dojo.provide("dojo.validate.common");
	dojo.require("dojo.regexp");
	dojo.validate.isText = function (value, flags) {
		flags = (typeof flags == "object") ? flags : {};
		if (/^\s*$/.test(value)) {
			return false;
		}
		if (typeof flags.length == "number" && flags.length != value.length) {
			return false;
		}
		if (typeof flags.minlength == "number" && flags.minlength > value.length) {
			return false;
		}
		if (typeof flags.maxlength == "number" && flags.maxlength < value.length) {
			return false;
		}
		return true;
	};
	dojo.validate.isInteger = function (value, flags) {
		var re = new RegExp("^" + dojo.regexp.integer(flags) + "$");
		return re.test(value);
	};
	dojo.validate.isRealNumber = function (value, flags) {
		var re = new RegExp("^" + dojo.regexp.realNumber(flags) + "$");
		return re.test(value);
	};
	dojo.validate.isCurrency = function (value, flags) {
		var re = new RegExp("^" + dojo.regexp.currency(flags) + "$");
		return re.test(value);
	};
	dojo.validate._isInRangeCache = {};
	dojo.validate.isInRange = function (value, flags) {
		value = value.replace(dojo.lang.has(flags, "separator") ? flags.separator : ",", "", "g").replace(dojo.lang.has(flags, "symbol") ? flags.symbol : "$", "");
		if (isNaN(value)) {
			return false;
		}
		flags = (typeof flags == "object") ? flags : {};
		var max = (typeof flags.max == "number") ? flags.max : Infinity;
		var min = (typeof flags.min == "number") ? flags.min : -Infinity;
		var dec = (typeof flags.decimal == "string") ? flags.decimal : ".";
		var cache = dojo.validate._isInRangeCache;
		var cacheIdx = value + "max" + max + "min" + min + "dec" + dec;
		if (typeof cache[cacheIdx] != "undefined") {
			return cache[cacheIdx];
		}
		var pattern = "[^" + dec + "\\deE+-]";
		value = value.replace(RegExp(pattern, "g"), "");
		value = value.replace(/^([+-]?)(\D*)/, "$1");
		value = value.replace(/(\D*)$/, "");
		pattern = "(\\d)[" + dec + "](\\d)";
		value = value.replace(RegExp(pattern, "g"), "$1.$2");
		value = Number(value);
		if (value < min || value > max) {
			cache[cacheIdx] = false;
			return false;
		}
		cache[cacheIdx] = true;
		return true;
	};
	dojo.validate.isNumberFormat = function (value, flags) {
		var re = new RegExp("^" + dojo.regexp.numberFormat(flags) + "$", "i");
		return re.test(value);
	};
	dojo.validate.isValidLuhn = function (value) {
		var sum, parity, curDigit;
		if (typeof value != "string") {
			value = String(value);
		}
		value = value.replace(/[- ]/g, "");
		parity = value.length % 2;
		sum = 0;
		for (var i = 0; i < value.length; i++) {
			curDigit = parseInt(value.charAt(i));
			if (i % 2 == parity) {
				curDigit *= 2;
			}
			if (curDigit > 9) {
				curDigit -= 9;
			}
			sum += curDigit;
		}
		return !(sum % 10);
	};
}});


__CPAN_FILE__ src/validate/web.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.validate.web"], ["require", "dojo.validate.common"]], definePackage:function (dojo) {
	dojo.provide("dojo.validate.web");
	dojo.require("dojo.validate.common");
	dojo.validate.isIpAddress = function (value, flags) {
		var re = new RegExp("^" + dojo.regexp.ipAddress(flags) + "$", "i");
		return re.test(value);
	};
	dojo.validate.isUrl = function (value, flags) {
		var re = new RegExp("^" + dojo.regexp.url(flags) + "$", "i");
		return re.test(value);
	};
	dojo.validate.isEmailAddress = function (value, flags) {
		var re = new RegExp("^" + dojo.regexp.emailAddress(flags) + "$", "i");
		return re.test(value);
	};
	dojo.validate.isEmailAddressList = function (value, flags) {
		var re = new RegExp("^" + dojo.regexp.emailAddressList(flags) + "$", "i");
		return re.test(value);
	};
	dojo.validate.getEmailAddressList = function (value, flags) {
		if (!flags) {
			flags = {};
		}
		if (!flags.listSeparator) {
			flags.listSeparator = "\\s;,";
		}
		if (dojo.validate.isEmailAddressList(value, flags)) {
			return value.split(new RegExp("\\s*[" + flags.listSeparator + "]\\s*"));
		}
		return [];
	};
}});


__CPAN_FILE__ src/validate/jp.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.validate.jp"], ["require", "dojo.validate.common"]], definePackage:function (dojo) {
	dojo.provide("dojo.validate.jp");
	dojo.require("dojo.validate.common");
	dojo.validate.isJapaneseCurrency = function (value) {
		var flags = {symbol:"\xa5", fractional:false};
		return dojo.validate.isCurrency(value, flags);
	};
}});


__CPAN_FILE__ src/validate/datetime.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.validate.datetime");
dojo.require("dojo.validate.common");
dojo.validate.isValidTime = function (value, flags) {
	dojo.deprecated("dojo.validate.datetime", "use dojo.date.parse instead", "0.5");
	var re = new RegExp("^" + dojo.regexp.time(flags) + "$", "i");
	return re.test(value);
};
dojo.validate.is12HourTime = function (value) {
	dojo.deprecated("dojo.validate.datetime", "use dojo.date.parse instead", "0.5");
	return dojo.validate.isValidTime(value, {format:["h:mm:ss t", "h:mm t"]});
};
dojo.validate.is24HourTime = function (value) {
	dojo.deprecated("dojo.validate.datetime", "use dojo.date.parse instead", "0.5");
	return dojo.validate.isValidTime(value, {format:["HH:mm:ss", "HH:mm"]});
};
dojo.validate.isValidDate = function (dateValue, format) {
	dojo.deprecated("dojo.validate.datetime", "use dojo.date.parse instead", "0.5");
	if (typeof format == "object" && typeof format.format == "string") {
		format = format.format;
	}
	if (typeof format != "string") {
		format = "MM/DD/YYYY";
	}
	var reLiteral = format.replace(/([$^.*+?=!:|\/\\\(\)\[\]\{\}])/g, "\\$1");
	reLiteral = reLiteral.replace("YYYY", "([0-9]{4})");
	reLiteral = reLiteral.replace("MM", "(0[1-9]|10|11|12)");
	reLiteral = reLiteral.replace("M", "([1-9]|10|11|12)");
	reLiteral = reLiteral.replace("DDD", "(00[1-9]|0[1-9][0-9]|[12][0-9][0-9]|3[0-5][0-9]|36[0-6])");
	reLiteral = reLiteral.replace("DD", "(0[1-9]|[12][0-9]|30|31)");
	reLiteral = reLiteral.replace("D", "([1-9]|[12][0-9]|30|31)");
	reLiteral = reLiteral.replace("ww", "(0[1-9]|[1-4][0-9]|5[0-3])");
	reLiteral = reLiteral.replace("d", "([1-7])");
	reLiteral = "^" + reLiteral + "$";
	var re = new RegExp(reLiteral);
	if (!re.test(dateValue)) {
		return false;
	}
	var year = 0, month = 1, date = 1, dayofyear = 1, week = 1, day = 1;
	var tokens = format.match(/(YYYY|MM|M|DDD|DD|D|ww|d)/g);
	var values = re.exec(dateValue);
	for (var i = 0; i < tokens.length; i++) {
		switch (tokens[i]) {
		  case "YYYY":
			year = Number(values[i + 1]);
			break;
		  case "M":
		  case "MM":
			month = Number(values[i + 1]);
			break;
		  case "D":
		  case "DD":
			date = Number(values[i + 1]);
			break;
		  case "DDD":
			dayofyear = Number(values[i + 1]);
			break;
		  case "ww":
			week = Number(values[i + 1]);
			break;
		  case "d":
			day = Number(values[i + 1]);
			break;
		}
	}
	var leapyear = (year % 4 == 0 && (year % 100 != 0 || year % 400 == 0));
	if (date == 31 && (month == 4 || month == 6 || month == 9 || month == 11)) {
		return false;
	}
	if (date >= 30 && month == 2) {
		return false;
	}
	if (date == 29 && month == 2 && !leapyear) {
		return false;
	}
	if (dayofyear == 366 && !leapyear) {
		return false;
	}
	return true;
};


__CPAN_FILE__ src/validate/creditCard.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.validate.creditCard"], ["require", "dojo.lang.common"], ["require", "dojo.validate.common"]], definePackage:function (dojo) {
	dojo.provide("dojo.validate.creditCard");
	dojo.require("dojo.lang.common");
	dojo.require("dojo.validate.common");
	dojo.validate.isValidCreditCard = function (value, ccType) {
		if (value && ccType && ((ccType.toLowerCase() == "er" || dojo.validate.isValidLuhn(value)) && (dojo.validate.isValidCreditCardNumber(value, ccType.toLowerCase())))) {
			return true;
		}
		return false;
	};
	dojo.validate.isValidCreditCardNumber = function (value, ccType) {
		if (typeof value != "string") {
			value = String(value);
		}
		value = value.replace(/[- ]/g, "");
		var results = [];
		var cardinfo = {"mc":"5[1-5][0-9]{14}", "ec":"5[1-5][0-9]{14}", "vi":"4([0-9]{12}|[0-9]{15})", "ax":"3[47][0-9]{13}", "dc":"3(0[0-5][0-9]{11}|[68][0-9]{12})", "bl":"3(0[0-5][0-9]{11}|[68][0-9]{12})", "di":"6011[0-9]{12}", "jcb":"(3[0-9]{15}|(2131|1800)[0-9]{11})", "er":"2(014|149)[0-9]{11}"};
		if (ccType && dojo.lang.has(cardinfo, ccType.toLowerCase())) {
			return Boolean(value.match(cardinfo[ccType.toLowerCase()]));
		} else {
			for (var p in cardinfo) {
				if (value.match("^" + cardinfo[p] + "$") != null) {
					results.push(p);
				}
			}
			return (results.length) ? results.join("|") : false;
		}
	};
	dojo.validate.isValidCvv = function (value, ccType) {
		if (typeof value != "string") {
			value = String(value);
		}
		var format;
		switch (ccType.toLowerCase()) {
		  case "mc":
		  case "ec":
		  case "vi":
		  case "di":
			format = "###";
			break;
		  case "ax":
			format = "####";
			break;
		  default:
			return false;
		}
		var flags = {format:format};
		if ((value.length == format.length) && (dojo.validate.isNumberFormat(value, flags))) {
			return true;
		}
		return false;
	};
}});


__CPAN_FILE__ src/validate/web.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.validate.web");
dojo.require("dojo.validate.common");
dojo.validate.isIpAddress = function (value, flags) {
	var re = new RegExp("^" + dojo.regexp.ipAddress(flags) + "$", "i");
	return re.test(value);
};
dojo.validate.isUrl = function (value, flags) {
	var re = new RegExp("^" + dojo.regexp.url(flags) + "$", "i");
	return re.test(value);
};
dojo.validate.isEmailAddress = function (value, flags) {
	var re = new RegExp("^" + dojo.regexp.emailAddress(flags) + "$", "i");
	return re.test(value);
};
dojo.validate.isEmailAddressList = function (value, flags) {
	var re = new RegExp("^" + dojo.regexp.emailAddressList(flags) + "$", "i");
	return re.test(value);
};
dojo.validate.getEmailAddressList = function (value, flags) {
	if (!flags) {
		flags = {};
	}
	if (!flags.listSeparator) {
		flags.listSeparator = "\\s;,";
	}
	if (dojo.validate.isEmailAddressList(value, flags)) {
		return value.split(new RegExp("\\s*[" + flags.listSeparator + "]\\s*"));
	}
	return [];
};


__CPAN_FILE__ src/validate/creditCard.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.validate.creditCard");
dojo.require("dojo.lang.common");
dojo.require("dojo.validate.common");
dojo.validate.isValidCreditCard = function (value, ccType) {
	if (value && ccType && ((ccType.toLowerCase() == "er" || dojo.validate.isValidLuhn(value)) && (dojo.validate.isValidCreditCardNumber(value, ccType.toLowerCase())))) {
		return true;
	}
	return false;
};
dojo.validate.isValidCreditCardNumber = function (value, ccType) {
	if (typeof value != "string") {
		value = String(value);
	}
	value = value.replace(/[- ]/g, "");
	var results = [];
	var cardinfo = {"mc":"5[1-5][0-9]{14}", "ec":"5[1-5][0-9]{14}", "vi":"4([0-9]{12}|[0-9]{15})", "ax":"3[47][0-9]{13}", "dc":"3(0[0-5][0-9]{11}|[68][0-9]{12})", "bl":"3(0[0-5][0-9]{11}|[68][0-9]{12})", "di":"6011[0-9]{12}", "jcb":"(3[0-9]{15}|(2131|1800)[0-9]{11})", "er":"2(014|149)[0-9]{11}"};
	if (ccType && dojo.lang.has(cardinfo, ccType.toLowerCase())) {
		return Boolean(value.match(cardinfo[ccType.toLowerCase()]));
	} else {
		for (var p in cardinfo) {
			if (value.match("^" + cardinfo[p] + "$") != null) {
				results.push(p);
			}
		}
		return (results.length) ? results.join("|") : false;
	}
};
dojo.validate.isValidCvv = function (value, ccType) {
	if (typeof value != "string") {
		value = String(value);
	}
	var format;
	switch (ccType.toLowerCase()) {
	  case "mc":
	  case "ec":
	  case "vi":
	  case "di":
		format = "###";
		break;
	  case "ax":
		format = "####";
		break;
	  default:
		return false;
	}
	var flags = {format:format};
	if ((value.length == format.length) && (dojo.validate.isNumberFormat(value, flags))) {
		return true;
	}
	return false;
};


__CPAN_FILE__ src/validate/check.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.validate.check");
dojo.require("dojo.validate.common");
dojo.require("dojo.lang.common");
dojo.validate.check = function (form, profile) {
	var missing = [];
	var invalid = [];
	var results = {isSuccessful:function () {
		return (!this.hasInvalid() && !this.hasMissing());
	}, hasMissing:function () {
		return (missing.length > 0);
	}, getMissing:function () {
		return missing;
	}, isMissing:function (elemname) {
		for (var i = 0; i < missing.length; i++) {
			if (elemname == missing[i]) {
				return true;
			}
		}
		return false;
	}, hasInvalid:function () {
		return (invalid.length > 0);
	}, getInvalid:function () {
		return invalid;
	}, isInvalid:function (elemname) {
		for (var i = 0; i < invalid.length; i++) {
			if (elemname == invalid[i]) {
				return true;
			}
		}
		return false;
	}};
	if (profile.trim instanceof Array) {
		for (var i = 0; i < profile.trim.length; i++) {
			var elem = form[profile.trim[i]];
			if (dj_undef("type", elem) || elem.type != "text" && elem.type != "textarea" && elem.type != "password") {
				continue;
			}
			elem.value = elem.value.replace(/(^\s*|\s*$)/g, "");
		}
	}
	if (profile.uppercase instanceof Array) {
		for (var i = 0; i < profile.uppercase.length; i++) {
			var elem = form[profile.uppercase[i]];
			if (dj_undef("type", elem) || elem.type != "text" && elem.type != "textarea" && elem.type != "password") {
				continue;
			}
			elem.value = elem.value.toUpperCase();
		}
	}
	if (profile.lowercase instanceof Array) {
		for (var i = 0; i < profile.lowercase.length; i++) {
			var elem = form[profile.lowercase[i]];
			if (dj_undef("type", elem) || elem.type != "text" && elem.type != "textarea" && elem.type != "password") {
				continue;
			}
			elem.value = elem.value.toLowerCase();
		}
	}
	if (profile.ucfirst instanceof Array) {
		for (var i = 0; i < profile.ucfirst.length; i++) {
			var elem = form[profile.ucfirst[i]];
			if (dj_undef("type", elem) || elem.type != "text" && elem.type != "textarea" && elem.type != "password") {
				continue;
			}
			elem.value = elem.value.replace(/\b\w+\b/g, function (word) {
				return word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase();
			});
		}
	}
	if (profile.digit instanceof Array) {
		for (var i = 0; i < profile.digit.length; i++) {
			var elem = form[profile.digit[i]];
			if (dj_undef("type", elem) || elem.type != "text" && elem.type != "textarea" && elem.type != "password") {
				continue;
			}
			elem.value = elem.value.replace(/\D/g, "");
		}
	}
	if (profile.required instanceof Array) {
		for (var i = 0; i < profile.required.length; i++) {
			if (!dojo.lang.isString(profile.required[i])) {
				continue;
			}
			var elem = form[profile.required[i]];
			if (!dj_undef("type", elem) && (elem.type == "text" || elem.type == "textarea" || elem.type == "password") && /^\s*$/.test(elem.value)) {
				missing[missing.length] = elem.name;
			} else {
				if (!dj_undef("type", elem) && (elem.type == "select-one" || elem.type == "select-multiple") && (elem.selectedIndex == -1 || /^\s*$/.test(elem.options[elem.selectedIndex].value))) {
					missing[missing.length] = elem.name;
				} else {
					if (elem instanceof Array) {
						var checked = false;
						for (var j = 0; j < elem.length; j++) {
							if (elem[j].checked) {
								checked = true;
							}
						}
						if (!checked) {
							missing[missing.length] = elem[0].name;
						}
					}
				}
			}
		}
	}
	if (profile.required instanceof Array) {
		for (var i = 0; i < profile.required.length; i++) {
			if (!dojo.lang.isObject(profile.required[i])) {
				continue;
			}
			var elem, numRequired;
			for (var name in profile.required[i]) {
				elem = form[name];
				numRequired = profile.required[i][name];
			}
			if (elem instanceof Array) {
				var checked = 0;
				for (var j = 0; j < elem.length; j++) {
					if (elem[j].checked) {
						checked++;
					}
				}
				if (checked < numRequired) {
					missing[missing.length] = elem[0].name;
				}
			} else {
				if (!dj_undef("type", elem) && elem.type == "select-multiple") {
					var selected = 0;
					for (var j = 0; j < elem.options.length; j++) {
						if (elem.options[j].selected && !/^\s*$/.test(elem.options[j].value)) {
							selected++;
						}
					}
					if (selected < numRequired) {
						missing[missing.length] = elem.name;
					}
				}
			}
		}
	}
	if (dojo.lang.isObject(profile.dependencies) || dojo.lang.isObject(profile.dependancies)) {
		if (profile["dependancies"]) {
			dojo.deprecated("dojo.validate.check", "profile 'dependancies' is deprecated, please use " + "'dependencies'", "0.5");
			profile.dependencies = profile.dependancies;
		}
		for (name in profile.dependencies) {
			var elem = form[name];
			if (dj_undef("type", elem)) {
				continue;
			}
			if (elem.type != "text" && elem.type != "textarea" && elem.type != "password") {
				continue;
			}
			if (/\S+/.test(elem.value)) {
				continue;
			}
			if (results.isMissing(elem.name)) {
				continue;
			}
			var target = form[profile.dependencies[name]];
			if (target.type != "text" && target.type != "textarea" && target.type != "password") {
				continue;
			}
			if (/^\s*$/.test(target.value)) {
				continue;
			}
			missing[missing.length] = elem.name;
		}
	}
	if (dojo.lang.isObject(profile.constraints)) {
		for (name in profile.constraints) {
			var elem = form[name];
			if (!elem) {
				continue;
			}
			if (!dj_undef("tagName", elem) && (elem.tagName.toLowerCase().indexOf("input") >= 0 || elem.tagName.toLowerCase().indexOf("textarea") >= 0) && /^\s*$/.test(elem.value)) {
				continue;
			}
			var isValid = true;
			if (dojo.lang.isFunction(profile.constraints[name])) {
				isValid = profile.constraints[name](elem.value);
			} else {
				if (dojo.lang.isArray(profile.constraints[name])) {
					if (dojo.lang.isArray(profile.constraints[name][0])) {
						for (var i = 0; i < profile.constraints[name].length; i++) {
							isValid = dojo.validate.evaluateConstraint(profile, profile.constraints[name][i], name, elem);
							if (!isValid) {
								break;
							}
						}
					} else {
						isValid = dojo.validate.evaluateConstraint(profile, profile.constraints[name], name, elem);
					}
				}
			}
			if (!isValid) {
				invalid[invalid.length] = elem.name;
			}
		}
	}
	if (dojo.lang.isObject(profile.confirm)) {
		for (name in profile.confirm) {
			var elem = form[name];
			var target = form[profile.confirm[name]];
			if (dj_undef("type", elem) || dj_undef("type", target) || (elem.type != "text" && elem.type != "textarea" && elem.type != "password") || (target.type != elem.type) || (target.value == elem.value) || (results.isInvalid(elem.name)) || (/^\s*$/.test(target.value))) {
				continue;
			}
			invalid[invalid.length] = elem.name;
		}
	}
	return results;
};
dojo.validate.evaluateConstraint = function (profile, constraint, fieldName, elem) {
	var isValidSomething = constraint[0];
	var params = constraint.slice(1);
	params.unshift(elem.value);
	if (typeof isValidSomething != "undefined") {
		return isValidSomething.apply(null, params);
	}
	return false;
};


__CPAN_DIR__ src/animation
__CPAN_FILE__ src/animation/Timer.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.animation.Timer"], ["require", "dojo.lang.timing.Timer"]], definePackage:function (dojo) {
	dojo.provide("dojo.animation.Timer");
	dojo.require("dojo.lang.timing.Timer");
	dojo.deprecated("dojo.animation.Timer is now dojo.lang.timing.Timer", "0.5");
	dojo.animation.Timer = dojo.lang.timing.Timer;
}});


__CPAN_FILE__ src/animation/AnimationEvent.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.animation.AnimationEvent"], ["require", "dojo.lang.common"]], definePackage:function (dojo) {
	dojo.provide("dojo.animation.AnimationEvent");
	dojo.require("dojo.lang.common");
	dojo.deprecated("dojo.animation.AnimationEvent is slated for removal in 0.5; use dojo.lfx.* instead.", "0.5");
	dojo.animation.AnimationEvent = function (animation, type, coords, startTime, currentTime, endTime, duration, percent, fps) {
		this.type = type;
		this.animation = animation;
		this.coords = coords;
		this.x = coords[0];
		this.y = coords[1];
		this.z = coords[2];
		this.startTime = startTime;
		this.currentTime = currentTime;
		this.endTime = endTime;
		this.duration = duration;
		this.percent = percent;
		this.fps = fps;
	};
	dojo.extend(dojo.animation.AnimationEvent, {coordsAsInts:function () {
		var cints = new Array(this.coords.length);
		for (var i = 0; i < this.coords.length; i++) {
			cints[i] = Math.round(this.coords[i]);
		}
		return cints;
	}});
}});


__CPAN_FILE__ src/animation/Animation.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.animation.Animation"], ["require", "dojo.animation.AnimationEvent"], ["require", "dojo.lang.func"], ["require", "dojo.math"], ["require", "dojo.math.curves"]], definePackage:function (dojo) {
	dojo.provide("dojo.animation.Animation");
	dojo.require("dojo.animation.AnimationEvent");
	dojo.require("dojo.lang.func");
	dojo.require("dojo.math");
	dojo.require("dojo.math.curves");
	dojo.deprecated("dojo.animation.Animation is slated for removal in 0.5; use dojo.lfx.* instead.", "0.5");
	dojo.animation.Animation = function (curve, duration, accel, repeatCount, rate) {
		if (dojo.lang.isArray(curve)) {
			curve = new dojo.math.curves.Line(curve[0], curve[1]);
		}
		this.curve = curve;
		this.duration = duration;
		this.repeatCount = repeatCount || 0;
		this.rate = rate || 25;
		if (accel) {
			if (dojo.lang.isFunction(accel.getValue)) {
				this.accel = accel;
			} else {
				var i = 0.35 * accel + 0.5;
				this.accel = new dojo.math.curves.CatmullRom([[0], [i], [1]], 0.45);
			}
		}
	};
	dojo.lang.extend(dojo.animation.Animation, {curve:null, duration:0, repeatCount:0, accel:null, onBegin:null, onAnimate:null, onEnd:null, onPlay:null, onPause:null, onStop:null, handler:null, _animSequence:null, _startTime:null, _endTime:null, _lastFrame:null, _timer:null, _percent:0, _active:false, _paused:false, _startRepeatCount:0, play:function (gotoStart) {
		if (gotoStart) {
			clearTimeout(this._timer);
			this._active = false;
			this._paused = false;
			this._percent = 0;
		} else {
			if (this._active && !this._paused) {
				return;
			}
		}
		this._startTime = new Date().valueOf();
		if (this._paused) {
			this._startTime -= (this.duration * this._percent / 100);
		}
		this._endTime = this._startTime + this.duration;
		this._lastFrame = this._startTime;
		var e = new dojo.animation.AnimationEvent(this, null, this.curve.getValue(this._percent), this._startTime, this._startTime, this._endTime, this.duration, this._percent, 0);
		this._active = true;
		this._paused = false;
		if (this._percent == 0) {
			if (!this._startRepeatCount) {
				this._startRepeatCount = this.repeatCount;
			}
			e.type = "begin";
			if (typeof this.handler == "function") {
				this.handler(e);
			}
			if (typeof this.onBegin == "function") {
				this.onBegin(e);
			}
		}
		e.type = "play";
		if (typeof this.handler == "function") {
			this.handler(e);
		}
		if (typeof this.onPlay == "function") {
			this.onPlay(e);
		}
		if (this._animSequence) {
			this._animSequence._setCurrent(this);
		}
		this._cycle();
	}, pause:function () {
		clearTimeout(this._timer);
		if (!this._active) {
			return;
		}
		this._paused = true;
		var e = new dojo.animation.AnimationEvent(this, "pause", this.curve.getValue(this._percent), this._startTime, new Date().valueOf(), this._endTime, this.duration, this._percent, 0);
		if (typeof this.handler == "function") {
			this.handler(e);
		}
		if (typeof this.onPause == "function") {
			this.onPause(e);
		}
	}, playPause:function () {
		if (!this._active || this._paused) {
			this.play();
		} else {
			this.pause();
		}
	}, gotoPercent:function (pct, andPlay) {
		clearTimeout(this._timer);
		this._active = true;
		this._paused = true;
		this._percent = pct;
		if (andPlay) {
			this.play();
		}
	}, stop:function (gotoEnd) {
		clearTimeout(this._timer);
		var step = this._percent / 100;
		if (gotoEnd) {
			step = 1;
		}
		var e = new dojo.animation.AnimationEvent(this, "stop", this.curve.getValue(step), this._startTime, new Date().valueOf(), this._endTime, this.duration, this._percent);
		if (typeof this.handler == "function") {
			this.handler(e);
		}
		if (typeof this.onStop == "function") {
			this.onStop(e);
		}
		this._active = false;
		this._paused = false;
	}, status:function () {
		if (this._active) {
			return this._paused ? "paused" : "playing";
		} else {
			return "stopped";
		}
	}, _cycle:function () {
		clearTimeout(this._timer);
		if (this._active) {
			var curr = new Date().valueOf();
			var step = (curr - this._startTime) / (this._endTime - this._startTime);
			var fps = 1000 / (curr - this._lastFrame);
			this._lastFrame = curr;
			if (step >= 1) {
				step = 1;
				this._percent = 100;
			} else {
				this._percent = step * 100;
			}
			if (this.accel && this.accel.getValue) {
				step = this.accel.getValue(step);
			}
			var e = new dojo.animation.AnimationEvent(this, "animate", this.curve.getValue(step), this._startTime, curr, this._endTime, this.duration, this._percent, Math.round(fps));
			if (typeof this.handler == "function") {
				this.handler(e);
			}
			if (typeof this.onAnimate == "function") {
				this.onAnimate(e);
			}
			if (step < 1) {
				this._timer = setTimeout(dojo.lang.hitch(this, "_cycle"), this.rate);
			} else {
				e.type = "end";
				this._active = false;
				if (typeof this.handler == "function") {
					this.handler(e);
				}
				if (typeof this.onEnd == "function") {
					this.onEnd(e);
				}
				if (this.repeatCount > 0) {
					this.repeatCount--;
					this.play(true);
				} else {
					if (this.repeatCount == -1) {
						this.play(true);
					} else {
						if (this._startRepeatCount) {
							this.repeatCount = this._startRepeatCount;
							this._startRepeatCount = 0;
						}
						if (this._animSequence) {
							this._animSequence._playNext();
						}
					}
				}
			}
		}
	}});
}});


__CPAN_FILE__ src/animation/Timer.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.animation.Timer");
dojo.require("dojo.lang.timing.Timer");
dojo.deprecated("dojo.animation.Timer is now dojo.lang.timing.Timer", "0.5");
dojo.animation.Timer = dojo.lang.timing.Timer;


__CPAN_FILE__ src/animation/Animation.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.animation.Animation");
dojo.require("dojo.animation.AnimationEvent");
dojo.require("dojo.lang.func");
dojo.require("dojo.math");
dojo.require("dojo.math.curves");
dojo.deprecated("dojo.animation.Animation is slated for removal in 0.5; use dojo.lfx.* instead.", "0.5");
dojo.animation.Animation = function (curve, duration, accel, repeatCount, rate) {
	if (dojo.lang.isArray(curve)) {
		curve = new dojo.math.curves.Line(curve[0], curve[1]);
	}
	this.curve = curve;
	this.duration = duration;
	this.repeatCount = repeatCount || 0;
	this.rate = rate || 25;
	if (accel) {
		if (dojo.lang.isFunction(accel.getValue)) {
			this.accel = accel;
		} else {
			var i = 0.35 * accel + 0.5;
			this.accel = new dojo.math.curves.CatmullRom([[0], [i], [1]], 0.45);
		}
	}
};
dojo.lang.extend(dojo.animation.Animation, {curve:null, duration:0, repeatCount:0, accel:null, onBegin:null, onAnimate:null, onEnd:null, onPlay:null, onPause:null, onStop:null, handler:null, _animSequence:null, _startTime:null, _endTime:null, _lastFrame:null, _timer:null, _percent:0, _active:false, _paused:false, _startRepeatCount:0, play:function (gotoStart) {
	if (gotoStart) {
		clearTimeout(this._timer);
		this._active = false;
		this._paused = false;
		this._percent = 0;
	} else {
		if (this._active && !this._paused) {
			return;
		}
	}
	this._startTime = new Date().valueOf();
	if (this._paused) {
		this._startTime -= (this.duration * this._percent / 100);
	}
	this._endTime = this._startTime + this.duration;
	this._lastFrame = this._startTime;
	var e = new dojo.animation.AnimationEvent(this, null, this.curve.getValue(this._percent), this._startTime, this._startTime, this._endTime, this.duration, this._percent, 0);
	this._active = true;
	this._paused = false;
	if (this._percent == 0) {
		if (!this._startRepeatCount) {
			this._startRepeatCount = this.repeatCount;
		}
		e.type = "begin";
		if (typeof this.handler == "function") {
			this.handler(e);
		}
		if (typeof this.onBegin == "function") {
			this.onBegin(e);
		}
	}
	e.type = "play";
	if (typeof this.handler == "function") {
		this.handler(e);
	}
	if (typeof this.onPlay == "function") {
		this.onPlay(e);
	}
	if (this._animSequence) {
		this._animSequence._setCurrent(this);
	}
	this._cycle();
}, pause:function () {
	clearTimeout(this._timer);
	if (!this._active) {
		return;
	}
	this._paused = true;
	var e = new dojo.animation.AnimationEvent(this, "pause", this.curve.getValue(this._percent), this._startTime, new Date().valueOf(), this._endTime, this.duration, this._percent, 0);
	if (typeof this.handler == "function") {
		this.handler(e);
	}
	if (typeof this.onPause == "function") {
		this.onPause(e);
	}
}, playPause:function () {
	if (!this._active || this._paused) {
		this.play();
	} else {
		this.pause();
	}
}, gotoPercent:function (pct, andPlay) {
	clearTimeout(this._timer);
	this._active = true;
	this._paused = true;
	this._percent = pct;
	if (andPlay) {
		this.play();
	}
}, stop:function (gotoEnd) {
	clearTimeout(this._timer);
	var step = this._percent / 100;
	if (gotoEnd) {
		step = 1;
	}
	var e = new dojo.animation.AnimationEvent(this, "stop", this.curve.getValue(step), this._startTime, new Date().valueOf(), this._endTime, this.duration, this._percent);
	if (typeof this.handler == "function") {
		this.handler(e);
	}
	if (typeof this.onStop == "function") {
		this.onStop(e);
	}
	this._active = false;
	this._paused = false;
}, status:function () {
	if (this._active) {
		return this._paused ? "paused" : "playing";
	} else {
		return "stopped";
	}
}, _cycle:function () {
	clearTimeout(this._timer);
	if (this._active) {
		var curr = new Date().valueOf();
		var step = (curr - this._startTime) / (this._endTime - this._startTime);
		var fps = 1000 / (curr - this._lastFrame);
		this._lastFrame = curr;
		if (step >= 1) {
			step = 1;
			this._percent = 100;
		} else {
			this._percent = step * 100;
		}
		if (this.accel && this.accel.getValue) {
			step = this.accel.getValue(step);
		}
		var e = new dojo.animation.AnimationEvent(this, "animate", this.curve.getValue(step), this._startTime, curr, this._endTime, this.duration, this._percent, Math.round(fps));
		if (typeof this.handler == "function") {
			this.handler(e);
		}
		if (typeof this.onAnimate == "function") {
			this.onAnimate(e);
		}
		if (step < 1) {
			this._timer = setTimeout(dojo.lang.hitch(this, "_cycle"), this.rate);
		} else {
			e.type = "end";
			this._active = false;
			if (typeof this.handler == "function") {
				this.handler(e);
			}
			if (typeof this.onEnd == "function") {
				this.onEnd(e);
			}
			if (this.repeatCount > 0) {
				this.repeatCount--;
				this.play(true);
			} else {
				if (this.repeatCount == -1) {
					this.play(true);
				} else {
					if (this._startRepeatCount) {
						this.repeatCount = this._startRepeatCount;
						this._startRepeatCount = 0;
					}
					if (this._animSequence) {
						this._animSequence._playNext();
					}
				}
			}
		}
	}
}});


__CPAN_FILE__ src/animation/__package__.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.kwCompoundRequire({common:["dojo.animation.AnimationEvent", "dojo.animation.Animation", "dojo.animation.AnimationSequence"]});
dojo.provide("dojo.animation.*");
dojo.deprecated("dojo.Animation.* is slated for removal in 0.5; use dojo.lfx.* instead.", "0.5");


__CPAN_FILE__ src/animation/AnimationSequence.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.animation.AnimationSequence");
dojo.require("dojo.animation.AnimationEvent");
dojo.require("dojo.animation.Animation");
dojo.deprecated("dojo.animation.AnimationSequence is slated for removal in 0.5; use dojo.lfx.* instead.", "0.5");
dojo.animation.AnimationSequence = function (repeatCount) {
	this._anims = [];
	this.repeatCount = repeatCount || 0;
};
dojo.lang.extend(dojo.animation.AnimationSequence, {repeatCount:0, _anims:[], _currAnim:-1, onBegin:null, onEnd:null, onNext:null, handler:null, add:function () {
	for (var i = 0; i < arguments.length; i++) {
		this._anims.push(arguments[i]);
		arguments[i]._animSequence = this;
	}
}, remove:function (anim) {
	for (var i = 0; i < this._anims.length; i++) {
		if (this._anims[i] == anim) {
			this._anims[i]._animSequence = null;
			this._anims.splice(i, 1);
			break;
		}
	}
}, removeAll:function () {
	for (var i = 0; i < this._anims.length; i++) {
		this._anims[i]._animSequence = null;
	}
	this._anims = [];
	this._currAnim = -1;
}, clear:function () {
	this.removeAll();
}, play:function (gotoStart) {
	if (this._anims.length == 0) {
		return;
	}
	if (gotoStart || !this._anims[this._currAnim]) {
		this._currAnim = 0;
	}
	if (this._anims[this._currAnim]) {
		if (this._currAnim == 0) {
			var e = {type:"begin", animation:this._anims[this._currAnim]};
			if (typeof this.handler == "function") {
				this.handler(e);
			}
			if (typeof this.onBegin == "function") {
				this.onBegin(e);
			}
		}
		this._anims[this._currAnim].play(gotoStart);
	}
}, pause:function () {
	if (this._anims[this._currAnim]) {
		this._anims[this._currAnim].pause();
	}
}, playPause:function () {
	if (this._anims.length == 0) {
		return;
	}
	if (this._currAnim == -1) {
		this._currAnim = 0;
	}
	if (this._anims[this._currAnim]) {
		this._anims[this._currAnim].playPause();
	}
}, stop:function () {
	if (this._anims[this._currAnim]) {
		this._anims[this._currAnim].stop();
	}
}, status:function () {
	if (this._anims[this._currAnim]) {
		return this._anims[this._currAnim].status();
	} else {
		return "stopped";
	}
}, _setCurrent:function (anim) {
	for (var i = 0; i < this._anims.length; i++) {
		if (this._anims[i] == anim) {
			this._currAnim = i;
			break;
		}
	}
}, _playNext:function () {
	if (this._currAnim == -1 || this._anims.length == 0) {
		return;
	}
	this._currAnim++;
	if (this._anims[this._currAnim]) {
		var e = {type:"next", animation:this._anims[this._currAnim]};
		if (typeof this.handler == "function") {
			this.handler(e);
		}
		if (typeof this.onNext == "function") {
			this.onNext(e);
		}
		this._anims[this._currAnim].play(true);
	} else {
		var e = {type:"end", animation:this._anims[this._anims.length - 1]};
		if (typeof this.handler == "function") {
			this.handler(e);
		}
		if (typeof this.onEnd == "function") {
			this.onEnd(e);
		}
		if (this.repeatCount > 0) {
			this._currAnim = 0;
			this.repeatCount--;
			this._anims[this._currAnim].play(true);
		} else {
			if (this.repeatCount == -1) {
				this._currAnim = 0;
				this._anims[this._currAnim].play(true);
			} else {
				this._currAnim = -1;
			}
		}
	}
}});


__CPAN_FILE__ src/animation/AnimationSequence.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.animation.AnimationSequence"], ["require", "dojo.animation.AnimationEvent"], ["require", "dojo.animation.Animation"]], definePackage:function (dojo) {
	dojo.provide("dojo.animation.AnimationSequence");
	dojo.require("dojo.animation.AnimationEvent");
	dojo.require("dojo.animation.Animation");
	dojo.deprecated("dojo.animation.AnimationSequence is slated for removal in 0.5; use dojo.lfx.* instead.", "0.5");
	dojo.animation.AnimationSequence = function (repeatCount) {
		this._anims = [];
		this.repeatCount = repeatCount || 0;
	};
	dojo.lang.extend(dojo.animation.AnimationSequence, {repeatCount:0, _anims:[], _currAnim:-1, onBegin:null, onEnd:null, onNext:null, handler:null, add:function () {
		for (var i = 0; i < arguments.length; i++) {
			this._anims.push(arguments[i]);
			arguments[i]._animSequence = this;
		}
	}, remove:function (anim) {
		for (var i = 0; i < this._anims.length; i++) {
			if (this._anims[i] == anim) {
				this._anims[i]._animSequence = null;
				this._anims.splice(i, 1);
				break;
			}
		}
	}, removeAll:function () {
		for (var i = 0; i < this._anims.length; i++) {
			this._anims[i]._animSequence = null;
		}
		this._anims = [];
		this._currAnim = -1;
	}, clear:function () {
		this.removeAll();
	}, play:function (gotoStart) {
		if (this._anims.length == 0) {
			return;
		}
		if (gotoStart || !this._anims[this._currAnim]) {
			this._currAnim = 0;
		}
		if (this._anims[this._currAnim]) {
			if (this._currAnim == 0) {
				var e = {type:"begin", animation:this._anims[this._currAnim]};
				if (typeof this.handler == "function") {
					this.handler(e);
				}
				if (typeof this.onBegin == "function") {
					this.onBegin(e);
				}
			}
			this._anims[this._currAnim].play(gotoStart);
		}
	}, pause:function () {
		if (this._anims[this._currAnim]) {
			this._anims[this._currAnim].pause();
		}
	}, playPause:function () {
		if (this._anims.length == 0) {
			return;
		}
		if (this._currAnim == -1) {
			this._currAnim = 0;
		}
		if (this._anims[this._currAnim]) {
			this._anims[this._currAnim].playPause();
		}
	}, stop:function () {
		if (this._anims[this._currAnim]) {
			this._anims[this._currAnim].stop();
		}
	}, status:function () {
		if (this._anims[this._currAnim]) {
			return this._anims[this._currAnim].status();
		} else {
			return "stopped";
		}
	}, _setCurrent:function (anim) {
		for (var i = 0; i < this._anims.length; i++) {
			if (this._anims[i] == anim) {
				this._currAnim = i;
				break;
			}
		}
	}, _playNext:function () {
		if (this._currAnim == -1 || this._anims.length == 0) {
			return;
		}
		this._currAnim++;
		if (this._anims[this._currAnim]) {
			var e = {type:"next", animation:this._anims[this._currAnim]};
			if (typeof this.handler == "function") {
				this.handler(e);
			}
			if (typeof this.onNext == "function") {
				this.onNext(e);
			}
			this._anims[this._currAnim].play(true);
		} else {
			var e = {type:"end", animation:this._anims[this._anims.length - 1]};
			if (typeof this.handler == "function") {
				this.handler(e);
			}
			if (typeof this.onEnd == "function") {
				this.onEnd(e);
			}
			if (this.repeatCount > 0) {
				this._currAnim = 0;
				this.repeatCount--;
				this._anims[this._currAnim].play(true);
			} else {
				if (this.repeatCount == -1) {
					this._currAnim = 0;
					this._anims[this._currAnim].play(true);
				} else {
					this._currAnim = -1;
				}
			}
		}
	}});
}});


__CPAN_FILE__ src/animation/__package__.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["kwCompoundRequire", {common:["dojo.animation.AnimationEvent", "dojo.animation.Animation", "dojo.animation.AnimationSequence"]}], ["provide", "dojo.animation.*"]], definePackage:function (dojo) {
	dojo.kwCompoundRequire({common:["dojo.animation.AnimationEvent", "dojo.animation.Animation", "dojo.animation.AnimationSequence"]});
	dojo.provide("dojo.animation.*");
	dojo.deprecated("dojo.Animation.* is slated for removal in 0.5; use dojo.lfx.* instead.", "0.5");
}});


__CPAN_FILE__ src/animation/AnimationEvent.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.animation.AnimationEvent");
dojo.require("dojo.lang.common");
dojo.deprecated("dojo.animation.AnimationEvent is slated for removal in 0.5; use dojo.lfx.* instead.", "0.5");
dojo.animation.AnimationEvent = function (animation, type, coords, startTime, currentTime, endTime, duration, percent, fps) {
	this.type = type;
	this.animation = animation;
	this.coords = coords;
	this.x = coords[0];
	this.y = coords[1];
	this.z = coords[2];
	this.startTime = startTime;
	this.currentTime = currentTime;
	this.endTime = endTime;
	this.duration = duration;
	this.percent = percent;
	this.fps = fps;
};
dojo.extend(dojo.animation.AnimationEvent, {coordsAsInts:function () {
	var cints = new Array(this.coords.length);
	for (var i = 0; i < this.coords.length; i++) {
		cints[i] = Math.round(this.coords[i]);
	}
	return cints;
}});


__CPAN_DIR__ src/debug
__CPAN_FILE__ src/debug/Firebug.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.debug.Firebug"]], definePackage:function (dojo) {
	dojo.provide("dojo.debug.Firebug");
	dojo.deprecated("dojo.debug.Firebug is slated for removal in 0.5; use dojo.debug.console instead.", "0.5");
	if (dojo.render.html.moz) {
		if (console && console.log) {
			var consoleLog = function () {
				if (!djConfig.isDebug) {
					return;
				}
				var args = dojo.lang.toArray(arguments);
				args.splice(0, 0, "DEBUG: ");
				console.log.apply(console, args);
			};
			dojo.debug = consoleLog;
			dojo.debugDeep = consoleLog;
			dojo.debugShallow = function (obj) {
				if (!djConfig.isDebug) {
					return;
				}
				if (dojo.lang.isArray(obj)) {
					console.log("Array: ", obj);
					for (var i = 0; x < obj.length; i++) {
						console.log("	", "[" + i + "]", obj[i]);
					}
				} else {
					console.log("Object: ", obj);
					var propNames = [];
					for (var prop in obj) {
						propNames.push(prop);
					}
					propNames.sort();
					dojo.lang.forEach(propNames, function (prop) {
						try {
							console.log("	", prop, obj[prop]);
						}
						catch (e) {
							console.log("	", prop, "ERROR", e.message, e);
						}
					});
				}
			};
		} else {
			dojo.debug("dojo.debug.Firebug requires Firebug > 0.4");
		}
	}
}});


__CPAN_FILE__ src/debug/arrow_show.gif
GIF89a	 	  !/=)5*6$.",%4DZgt(8H&6F8HXAP_'3TaofrDSb*;Lhtq|,8!/<p|#1@#.(4                     !   ,    	 	  " QbYFYBbjrTR`"5%0W ;
__CPAN_FILE__ src/debug/console.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.debug.console"], ["require", "dojo.logging.ConsoleLogger"]], definePackage:function (dojo) {
	dojo.provide("dojo.debug.console");
	dojo.require("dojo.logging.ConsoleLogger");
	if (window.console) {
		if (console.info != null) {
			dojo.hostenv.println = function () {
				if (!djConfig.isDebug) {
					return;
				}
				console.info.apply(console, arguments);
			};
			dojo.debug = dojo.hostenv.println;
			dojo.debugDeep = dojo.debug;
			dojo.debugShallow = function (obj, showMethods, sort) {
				if (!djConfig.isDebug) {
					return;
				}
				showMethods = (showMethods != false);
				sort = (sort != false);
				if (obj == null || obj.constructor == null) {
					return dojo.debug(obj);
				}
				var type = obj.declaredClass;
				if (type == null) {
					type = obj.constructor.toString().match(/function\s*(.*)\(/);
					if (type) {
						type = type[1];
					}
				}
				if (type) {
					if (type == "String" || type == "Number") {
						return dojo.debug(type + ": ", obj);
					}
					if (showMethods && !sort) {
						var sortedObj = obj;
					} else {
						var propNames = [];
						if (showMethods) {
							for (var prop in obj) {
								propNames.push(prop);
							}
						} else {
							for (var prop in obj) {
								if (typeof obj[prop] != "function") {
									propNames.push(prop);
								} else {
									dojo.debug(prop);
								}
							}
						}
						if (sort) {
							propNames.sort();
						}
						var sortedObj = {};
						dojo.lang.forEach(propNames, function (prop) {
							sortedObj[prop] = obj[prop];
						});
					}
					return dojo.debug(type + ": %o\n%2.o", obj, sortedObj);
				}
				return dojo.debug(obj.constructor + ": ", obj);
			};
		} else {
			if (console.log != null) {
				dojo.hostenv.println = function () {
					if (!djConfig.isDebug) {
						return;
					}
					var args = dojo.lang.toArray(arguments);
					console.log("DEBUG: " + args.join(" "));
				};
				dojo.debug = dojo.hostenv.println;
			} else {
				dojo.debug("dojo.debug.console requires Firebug > 0.4");
			}
		}
	} else {
		if (dojo.render.html.opera) {
			if (opera && opera.postError) {
				dojo.hostenv.println = opera.postError;
			} else {
				dojo.debug("dojo.debug.Opera requires Opera > 8.0");
			}
		}
	}
}});


__CPAN_FILE__ src/debug/spacer.gif
GIF89a	 	  @@@   gԈ0Ԉ*  2     P   $0  2  H   L  2  H   $h82         dtu꼐xqu!    p   u,     p  @      $                       @(H        p p,     tH(            @2              悰  @2S`@    H\Qm       鄑QH    頑QHm     D    0    PԈ   0    l       @   HQ8mHr8H  qՆ  `x     pm	     đ	     b  b                PHDpm     Hr8H  hHHP \ pDHccEH  Hr8H       pltHH  悰  !   ,    	 	   H*\p`@ ;
__CPAN_FILE__ src/debug/Firebug.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.debug.Firebug");
dojo.deprecated("dojo.debug.Firebug is slated for removal in 0.5; use dojo.debug.console instead.", "0.5");
if (dojo.render.html.moz) {
	if (console && console.log) {
		var consoleLog = function () {
			if (!djConfig.isDebug) {
				return;
			}
			var args = dojo.lang.toArray(arguments);
			args.splice(0, 0, "DEBUG: ");
			console.log.apply(console, args);
		};
		dojo.debug = consoleLog;
		dojo.debugDeep = consoleLog;
		dojo.debugShallow = function (obj) {
			if (!djConfig.isDebug) {
				return;
			}
			if (dojo.lang.isArray(obj)) {
				console.log("Array: ", obj);
				for (var i = 0; x < obj.length; i++) {
					console.log("	", "[" + i + "]", obj[i]);
				}
			} else {
				console.log("Object: ", obj);
				var propNames = [];
				for (var prop in obj) {
					propNames.push(prop);
				}
				propNames.sort();
				dojo.lang.forEach(propNames, function (prop) {
					try {
						console.log("	", prop, obj[prop]);
					}
					catch (e) {
						console.log("	", prop, "ERROR", e.message, e);
					}
				});
			}
		};
	} else {
		dojo.debug("dojo.debug.Firebug requires Firebug > 0.4");
	}
}


__CPAN_FILE__ src/debug/arrow_hide.gif
GIF89a	 	  )6'7H):K!/=)5%4C$/,9DSb%0)&5EO]kJXg;K[)9J )8HX .;$3Bdp|]jw                           !   ,    	 	   %d9VU1LVDO1c0IDRɢ! ;
__CPAN_FILE__ src/debug/console.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.debug.console");
dojo.require("dojo.logging.ConsoleLogger");
if (window.console) {
	if (console.info != null) {
		dojo.hostenv.println = function () {
			if (!djConfig.isDebug) {
				return;
			}
			console.info.apply(console, arguments);
		};
		dojo.debug = dojo.hostenv.println;
		dojo.debugDeep = dojo.debug;
		dojo.debugShallow = function (obj, showMethods, sort) {
			if (!djConfig.isDebug) {
				return;
			}
			showMethods = (showMethods != false);
			sort = (sort != false);
			if (obj == null || obj.constructor == null) {
				return dojo.debug(obj);
			}
			var type = obj.declaredClass;
			if (type == null) {
				type = obj.constructor.toString().match(/function\s*(.*)\(/);
				if (type) {
					type = type[1];
				}
			}
			if (type) {
				if (type == "String" || type == "Number") {
					return dojo.debug(type + ": ", obj);
				}
				if (showMethods && !sort) {
					var sortedObj = obj;
				} else {
					var propNames = [];
					if (showMethods) {
						for (var prop in obj) {
							propNames.push(prop);
						}
					} else {
						for (var prop in obj) {
							if (typeof obj[prop] != "function") {
								propNames.push(prop);
							} else {
								dojo.debug(prop);
							}
						}
					}
					if (sort) {
						propNames.sort();
					}
					var sortedObj = {};
					dojo.lang.forEach(propNames, function (prop) {
						sortedObj[prop] = obj[prop];
					});
				}
				return dojo.debug(type + ": %o\n%2.o", obj, sortedObj);
			}
			return dojo.debug(obj.constructor + ": ", obj);
		};
	} else {
		if (console.log != null) {
			dojo.hostenv.println = function () {
				if (!djConfig.isDebug) {
					return;
				}
				var args = dojo.lang.toArray(arguments);
				console.log("DEBUG: " + args.join(" "));
			};
			dojo.debug = dojo.hostenv.println;
		} else {
			dojo.debug("dojo.debug.console requires Firebug > 0.4");
		}
	}
} else {
	if (dojo.render.html.opera) {
		if (opera && opera.postError) {
			dojo.hostenv.println = opera.postError;
		} else {
			dojo.debug("dojo.debug.Opera requires Opera > 8.0");
		}
	}
}


__CPAN_FILE__ src/debug/deep.html
<html>
<head>
<title>Deep Debugger</title>
<script>

var tableRows = {};
var tableCels = {};
var tableObjs = {};
var tablesBuilt = {};
var tableShows = {};
var tableHides = {};

// IE: nodes w/id need to be redeclared or getElementById is b0rked
var frame = null;

window.onload = function(){
	// if IE loads this page too quickly (instantly) then 
	// window.debugVar might not have been set
	window.setTimeout(startMeUp, 100);
}

function startMeUp(){
	frame = document.getElementById('frame');
	// GET string 
	var index = location.search.split("=").pop();
	var debugObj = window.opener.dojo.debugDeep;
	var debugVar = debugObj.debugVars[index] || window.debugVar;
	buildTable('root', frame, debugVar);
}

function buildTable(path, parent, obj){
	var keys = [];
	var vals = [];
	for(var prop in obj){
		keys.push(prop);
		try {
			vals[prop] = obj[prop];
		} catch(E) {
			vals[prop] = 'ERROR: ' + E.message;
		}
	}
	keys.sort(keySorter);

	if (!keys.length){

		var div = document.createElement('div');
		div.appendChild(document.createTextNode('Object has no properties.'));

		parent.appendChild(div);
		return;
	}


	var t = document.createElement('table');
	t.border = "1";

	var tb = document.createElement('tbody');
	t.appendChild(tb);


	for(var i = 0; i < keys.length; i++) {
		buildTableRow(path+'-'+keys[i], tb, keys[i], vals[keys[i]]);
	}

	if (path == 'root'){
		//t.style.width = '90%';
	}
	t.style.width = '100%';

	parent.appendChild(t);

	tablesBuilt[path] = true;
}

function buildTableRow(path, tb, name, value) {

	var simpleType = typeof(value);
	var createSubrow = (simpleType == 'object');
	var complexType = simpleType;

	if (simpleType == 'object'){
		var cls = getConstructorClass(value);
		if (cls){
			if (cls == 'Object'){
			}else if (cls == 'Array'){
				complexType = 'array';
			}else{
				complexType += ' ('+cls+')';
			}
		}
	}

/*var tr1 = document.createElement('tr');
	var td1 = document.createElement('td');
	var td2 = document.createElement('td');
	var td3 = document.createElement('td');
	var td4 = document.createElement('td');*/

	var row = tb.rows.length;
	var tr1 = tb.insertRow(row++);
	var td1 = tr1.insertCell(0);
	var td2 = tr1.insertCell(1);
	var td3 = tr1.insertCell(2);
	var td4 = tr1.insertCell(3);
	
	tr1.style.verticalAlign = 'top';
	td1.style.verticalAlign = 'middle';

	td1.className = 'propPlus';
	td2.className = 'propName';
	td3.className = 'propType';
	td4.className = 'propVal';

	//tr1.appendChild(td1);
	//tr1.appendChild(td2);
	//tr1.appendChild(td3);
	//tr1.appendChild(td4);

	if (createSubrow){
		var img1 = document.createElement('img');
		img1.width = 9;
		img1.height = 9;
		img1.src = 'arrow_show.gif';
		var a1 = document.createElement('a');
		a1.appendChild(img1);
		a1.href = '#';
		a1.onclick = function(){ showTableRow(path); return false; };

		var img2 = document.createElement('img');
		img2.width = 9;
		img2.height = 9;
		img2.src = 'arrow_hide.gif';
		var a2 = document.createElement('a');
		a2.appendChild(img2);
		a2.href = '#';
		a2.onclick = function(){ hideTableRow(path); return false; };
		a2.style.display = 'none';

		tableShows[path] = a1;
		tableHides[path] = a2;

		td1.appendChild(a1);
		td1.appendChild(a2);
	}else{
		var img = document.createElement('img');
		img.width = 9;
		img.height = 9;
		img.src = 'spacer.gif';

		td1.appendChild(img);
	}

	td2.appendChild(document.createTextNode(name));
	td3.appendChild(document.createTextNode(complexType));
	td4.appendChild(buildPreBlock(value));

	//tb.appendChild(tr1);

	if (createSubrow){
		var tr2 = tb.insertRow(row++);
		var td5 = tr2.insertCell(0);
		var td6 = tr2.insertCell(1);
		
		//var tr2 = document.createElement('tr');
		//var td5 = document.createElement('td');
		//var td6 = document.createElement('td');

		td5.innerHTML = '&nbsp;';
		//td6.innerHTML = '&nbsp;';

		td6.colSpan = '3';

		tr2.appendChild(td5);
		tr2.appendChild(td6);

		tr2.style.display = 'none';

		tb.appendChild(tr2);

		tableRows[path] = tr2;
		tableCels[path] = td6;
		tableObjs[path] = value;
	}
}

function showTableRow(path){

	var tr = tableRows[path];
	var td = tableCels[path];
	var a1 = tableShows[path];
	var a2 = tableHides[path];

	if (!tablesBuilt[path]){

		//alert('building table for '+path);
		buildTable(path, td, tableObjs[path]);
	}

	tr.style.display = 'table-row';

	a1.style.display = 'none';
	a2.style.display = 'inline';
}

function hideTableRow(path){

	var tr = tableRows[path];
	var a1 = tableShows[path];
	var a2 = tableHides[path];

	tr.style.display = 'none';

	a1.style.display = 'inline';
	a2.style.display = 'none';
}

function buildPreBlock(value){

	//
	// how many lines ?
	//

	var s = ''+value;
	s = s.replace("\r\n", "\n");
	s = s.replace("\r", "");
	var lines = s.split("\n");


	if (lines.length < 2){

		if (lines[0].length < 60){

			var pre = document.createElement('pre');
			pre.appendChild(document.createTextNode(s));
			return pre;
		}
	}


	//
	// multiple lines :(
	//

	var preview = lines[0].substr(0, 60) + ' ...';

	var pre1 = document.createElement('pre');
	pre1.appendChild(document.createTextNode(preview));
	pre1.className = 'clicky';

	var pre2 = document.createElement('pre');
	pre2.appendChild(document.createTextNode(s));
	pre2.style.display = 'none';
	pre2.className = 'clicky';

	pre1.onclick = function(){
		pre1.style.display = 'none';
		pre2.style.display = 'block';
	}

	pre2.onclick = function(){
		pre1.style.display = 'block';
		pre2.style.display = 'none';
	}

	var pre = document.createElement('div');

	pre.appendChild(pre1);
	pre.appendChild(pre2);

	return pre;
}

function getConstructorClass(obj){

	if (!obj.constructor || !obj.constructor.toString) return;

	var m = obj.constructor.toString().match(/function\s*(\w+)/);

	if (m && m.length == 2) return m[1];

	return null;
}

function keySorter(a, b){

	if (a == parseInt(a) && b == parseInt(b)){

		return (parseInt(a) > parseInt(b)) ? 1 : ((parseInt(a) < parseInt(b)) ? -1 : 0);
	}

	// sort by lowercase string

	var a2 = String(a).toLowerCase();
	var b2 = String(b).toLowerCase();

	return (a2 > b2) ? 1 : ((a2 < b2) ? -1 : 0);
}

</script>
<style>

body {
	font-family: arial, helvetica, sans-serif;
}

table {
	border-width: 0px;
	border-spacing: 1px;
	border-collapse: separate;
}

td {
	border-width: 0px;
	padding: 2px;
}

img {
	border: 0;
}

pre {
	margin: 0;
	padding: 0;
	white-space: -moz-pre-wrap;  /* Mozilla, supported since 1999 */
	white-space: -pre-wrap;      /* Opera 4 - 6 */
	white-space: -o-pre-wrap;    /* Opera 7 */
	white-space: pre-wrap;       /* CSS3 - Text module (Candidate Recommendation) http://www.w3.org/TR/css3-text/#white-space */
	word-wrap: break-word;       /* IE 5.5+ */
}

pre.clicky {
	cursor: hand;
	cursor: pointer;
}

td.propPlus {
	width: 9px;
	background-color: #ddd;
}

td.propName {
	background-color: #ddd;
}

td.propType {
	background-color: #ddd;
}

td.propVal {
	background-color: #ddd;
}

</style>
</head>
<body>

<h2>Javascript Object Browser</h2>

<div id="frame"></div>

</body>
</html>
__CPAN_DIR__ src/selection
__CPAN_FILE__ src/selection/Selection.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.selection.Selection");
dojo.require("dojo.lang.array");
dojo.require("dojo.lang.func");
dojo.require("dojo.lang.common");
dojo.require("dojo.math");
dojo.declare("dojo.selection.Selection", null, {initializer:function (items, isCollection) {
	this.items = [];
	this.selection = [];
	this._pivotItems = [];
	this.clearItems();
	if (items) {
		if (isCollection) {
			this.setItemsCollection(items);
		} else {
			this.setItems(items);
		}
	}
}, items:null, selection:null, lastSelected:null, allowImplicit:true, length:0, isGrowable:true, _pivotItems:null, _pivotItem:null, onSelect:function (item) {
}, onDeselect:function (item) {
}, onSelectChange:function (item, selected) {
}, _find:function (item, inSelection) {
	if (inSelection) {
		return dojo.lang.find(this.selection, item);
	} else {
		return dojo.lang.find(this.items, item);
	}
}, isSelectable:function (item) {
	return true;
}, setItems:function () {
	this.clearItems();
	this.addItems.call(this, arguments);
}, setItemsCollection:function (collection) {
	this.items = collection;
}, addItems:function () {
	var args = dojo.lang.unnest(arguments);
	for (var i = 0; i < args.length; i++) {
		this.items.push(args[i]);
	}
}, addItemsAt:function (item, before) {
	if (this.items.length == 0) {
		return this.addItems(dojo.lang.toArray(arguments, 2));
	}
	if (!this.isItem(item)) {
		item = this.items[item];
	}
	if (!item) {
		throw new Error("addItemsAt: item doesn't exist");
	}
	var idx = this._find(item);
	if (idx > 0 && before) {
		idx--;
	}
	for (var i = 2; i < arguments.length; i++) {
		if (!this.isItem(arguments[i])) {
			this.items.splice(idx++, 0, arguments[i]);
		}
	}
}, removeItem:function (item) {
	var idx = this._find(item);
	if (idx > -1) {
		this.items.splice(idx, 1);
	}
	idx = this._find(item, true);
	if (idx > -1) {
		this.selection.splice(idx, 1);
	}
}, clearItems:function () {
	this.items = [];
	this.deselectAll();
}, isItem:function (item) {
	return this._find(item) > -1;
}, isSelected:function (item) {
	return this._find(item, true) > -1;
}, selectFilter:function (item, selection, add, grow) {
	return true;
}, update:function (item, add, grow, noToggle) {
	if (!this.isItem(item)) {
		return false;
	}
	if (this.isGrowable && grow) {
		if ((!this.isSelected(item)) && this.selectFilter(item, this.selection, false, true)) {
			this.grow(item);
			this.lastSelected = item;
		}
	} else {
		if (add) {
			if (this.selectFilter(item, this.selection, true, false)) {
				if (noToggle) {
					if (this.select(item)) {
						this.lastSelected = item;
					}
				} else {
					if (this.toggleSelected(item)) {
						this.lastSelected = item;
					}
				}
			}
		} else {
			this.deselectAll();
			this.select(item);
		}
	}
	this.length = this.selection.length;
	return true;
}, grow:function (toItem, fromItem) {
	if (!this.isGrowable) {
		return;
	}
	if (arguments.length == 1) {
		fromItem = this._pivotItem;
		if (!fromItem && this.allowImplicit) {
			fromItem = this.items[0];
		}
	}
	if (!toItem || !fromItem) {
		return false;
	}
	var fromIdx = this._find(fromItem);
	var toDeselect = {};
	var lastIdx = -1;
	if (this.lastSelected) {
		lastIdx = this._find(this.lastSelected);
		var step = fromIdx < lastIdx ? -1 : 1;
		var range = dojo.math.range(lastIdx, fromIdx, step);
		for (var i = 0; i < range.length; i++) {
			toDeselect[range[i]] = true;
		}
	}
	var toIdx = this._find(toItem);
	var step = fromIdx < toIdx ? -1 : 1;
	var shrink = lastIdx >= 0 && step == 1 ? lastIdx < toIdx : lastIdx > toIdx;
	var range = dojo.math.range(toIdx, fromIdx, step);
	if (range.length) {
		for (var i = range.length - 1; i >= 0; i--) {
			var item = this.items[range[i]];
			if (this.selectFilter(item, this.selection, false, true)) {
				if (this.select(item, true) || shrink) {
					this.lastSelected = item;
				}
				if (range[i] in toDeselect) {
					delete toDeselect[range[i]];
				}
			}
		}
	} else {
		this.lastSelected = fromItem;
	}
	for (var i in toDeselect) {
		if (this.items[i] == this.lastSelected) {
		}
		this.deselect(this.items[i]);
	}
	this._updatePivot();
}, growUp:function () {
	if (!this.isGrowable) {
		return;
	}
	var idx = this._find(this.lastSelected) - 1;
	while (idx >= 0) {
		if (this.selectFilter(this.items[idx], this.selection, false, true)) {
			this.grow(this.items[idx]);
			break;
		}
		idx--;
	}
}, growDown:function () {
	if (!this.isGrowable) {
		return;
	}
	var idx = this._find(this.lastSelected);
	if (idx < 0 && this.allowImplicit) {
		this.select(this.items[0]);
		idx = 0;
	}
	idx++;
	while (idx > 0 && idx < this.items.length) {
		if (this.selectFilter(this.items[idx], this.selection, false, true)) {
			this.grow(this.items[idx]);
			break;
		}
		idx++;
	}
}, toggleSelected:function (item, noPivot) {
	if (this.isItem(item)) {
		if (this.select(item, noPivot)) {
			return 1;
		}
		if (this.deselect(item)) {
			return -1;
		}
	}
	return 0;
}, select:function (item, noPivot) {
	if (this.isItem(item) && !this.isSelected(item) && this.isSelectable(item)) {
		this.selection.push(item);
		this.lastSelected = item;
		this.onSelect(item);
		this.onSelectChange(item, true);
		if (!noPivot) {
			this._addPivot(item);
		}
		this.length = this.selection.length;
		return true;
	}
	return false;
}, deselect:function (item) {
	var idx = this._find(item, true);
	if (idx > -1) {
		this.selection.splice(idx, 1);
		this.onDeselect(item);
		this.onSelectChange(item, false);
		if (item == this.lastSelected) {
			this.lastSelected = null;
		}
		this._removePivot(item);
		this.length = this.selection.length;
		return true;
	}
	return false;
}, selectAll:function () {
	for (var i = 0; i < this.items.length; i++) {
		this.select(this.items[i]);
	}
}, deselectAll:function () {
	while (this.selection && this.selection.length) {
		this.deselect(this.selection[0]);
	}
}, selectNext:function () {
	var idx = this._find(this.lastSelected);
	while (idx > -1 && ++idx < this.items.length) {
		if (this.isSelectable(this.items[idx])) {
			this.deselectAll();
			this.select(this.items[idx]);
			return true;
		}
	}
	return false;
}, selectPrevious:function () {
	var idx = this._find(this.lastSelected);
	while (idx-- > 0) {
		if (this.isSelectable(this.items[idx])) {
			this.deselectAll();
			this.select(this.items[idx]);
			return true;
		}
	}
	return false;
}, selectFirst:function () {
	this.deselectAll();
	var idx = 0;
	while (this.items[idx] && !this.select(this.items[idx])) {
		idx++;
	}
	return this.items[idx] ? true : false;
}, selectLast:function () {
	this.deselectAll();
	var idx = this.items.length - 1;
	while (this.items[idx] && !this.select(this.items[idx])) {
		idx--;
	}
	return this.items[idx] ? true : false;
}, _addPivot:function (item, andClear) {
	this._pivotItem = item;
	if (andClear) {
		this._pivotItems = [item];
	} else {
		this._pivotItems.push(item);
	}
}, _removePivot:function (item) {
	var i = dojo.lang.find(this._pivotItems, item);
	if (i > -1) {
		this._pivotItems.splice(i, 1);
		this._pivotItem = this._pivotItems[this._pivotItems.length - 1];
	}
	this._updatePivot();
}, _updatePivot:function () {
	if (this._pivotItems.length == 0) {
		if (this.lastSelected) {
			this._addPivot(this.lastSelected);
		}
	}
}, sorted:function () {
	return dojo.lang.toArray(this.selection).sort(dojo.lang.hitch(this, function (a, b) {
		var A = this._find(a), B = this._find(b);
		if (A > B) {
			return 1;
		} else {
			if (A < B) {
				return -1;
			} else {
				return 0;
			}
		}
	}));
}, updateSelected:function () {
	for (var i = 0; i < this.selection.length; i++) {
		if (this._find(this.selection[i]) < 0) {
			var removed = this.selection.splice(i, 1);
			this._removePivot(removed[0]);
		}
	}
	this.length = this.selection.length;
}});


__CPAN_FILE__ src/selection/Selection.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.selection.Selection"], ["require", "dojo.lang.array"], ["require", "dojo.lang.func"], ["require", "dojo.lang.common"], ["require", "dojo.math"]], definePackage:function (dojo) {
	dojo.provide("dojo.selection.Selection");
	dojo.require("dojo.lang.array");
	dojo.require("dojo.lang.func");
	dojo.require("dojo.lang.common");
	dojo.require("dojo.math");
	dojo.declare("dojo.selection.Selection", null, {initializer:function (items, isCollection) {
		this.items = [];
		this.selection = [];
		this._pivotItems = [];
		this.clearItems();
		if (items) {
			if (isCollection) {
				this.setItemsCollection(items);
			} else {
				this.setItems(items);
			}
		}
	}, items:null, selection:null, lastSelected:null, allowImplicit:true, length:0, isGrowable:true, _pivotItems:null, _pivotItem:null, onSelect:function (item) {
	}, onDeselect:function (item) {
	}, onSelectChange:function (item, selected) {
	}, _find:function (item, inSelection) {
		if (inSelection) {
			return dojo.lang.find(this.selection, item);
		} else {
			return dojo.lang.find(this.items, item);
		}
	}, isSelectable:function (item) {
		return true;
	}, setItems:function () {
		this.clearItems();
		this.addItems.call(this, arguments);
	}, setItemsCollection:function (collection) {
		this.items = collection;
	}, addItems:function () {
		var args = dojo.lang.unnest(arguments);
		for (var i = 0; i < args.length; i++) {
			this.items.push(args[i]);
		}
	}, addItemsAt:function (item, before) {
		if (this.items.length == 0) {
			return this.addItems(dojo.lang.toArray(arguments, 2));
		}
		if (!this.isItem(item)) {
			item = this.items[item];
		}
		if (!item) {
			throw new Error("addItemsAt: item doesn't exist");
		}
		var idx = this._find(item);
		if (idx > 0 && before) {
			idx--;
		}
		for (var i = 2; i < arguments.length; i++) {
			if (!this.isItem(arguments[i])) {
				this.items.splice(idx++, 0, arguments[i]);
			}
		}
	}, removeItem:function (item) {
		var idx = this._find(item);
		if (idx > -1) {
			this.items.splice(idx, 1);
		}
		idx = this._find(item, true);
		if (idx > -1) {
			this.selection.splice(idx, 1);
		}
	}, clearItems:function () {
		this.items = [];
		this.deselectAll();
	}, isItem:function (item) {
		return this._find(item) > -1;
	}, isSelected:function (item) {
		return this._find(item, true) > -1;
	}, selectFilter:function (item, selection, add, grow) {
		return true;
	}, update:function (item, add, grow, noToggle) {
		if (!this.isItem(item)) {
			return false;
		}
		if (this.isGrowable && grow) {
			if ((!this.isSelected(item)) && this.selectFilter(item, this.selection, false, true)) {
				this.grow(item);
				this.lastSelected = item;
			}
		} else {
			if (add) {
				if (this.selectFilter(item, this.selection, true, false)) {
					if (noToggle) {
						if (this.select(item)) {
							this.lastSelected = item;
						}
					} else {
						if (this.toggleSelected(item)) {
							this.lastSelected = item;
						}
					}
				}
			} else {
				this.deselectAll();
				this.select(item);
			}
		}
		this.length = this.selection.length;
		return true;
	}, grow:function (toItem, fromItem) {
		if (!this.isGrowable) {
			return;
		}
		if (arguments.length == 1) {
			fromItem = this._pivotItem;
			if (!fromItem && this.allowImplicit) {
				fromItem = this.items[0];
			}
		}
		if (!toItem || !fromItem) {
			return false;
		}
		var fromIdx = this._find(fromItem);
		var toDeselect = {};
		var lastIdx = -1;
		if (this.lastSelected) {
			lastIdx = this._find(this.lastSelected);
			var step = fromIdx < lastIdx ? -1 : 1;
			var range = dojo.math.range(lastIdx, fromIdx, step);
			for (var i = 0; i < range.length; i++) {
				toDeselect[range[i]] = true;
			}
		}
		var toIdx = this._find(toItem);
		var step = fromIdx < toIdx ? -1 : 1;
		var shrink = lastIdx >= 0 && step == 1 ? lastIdx < toIdx : lastIdx > toIdx;
		var range = dojo.math.range(toIdx, fromIdx, step);
		if (range.length) {
			for (var i = range.length - 1; i >= 0; i--) {
				var item = this.items[range[i]];
				if (this.selectFilter(item, this.selection, false, true)) {
					if (this.select(item, true) || shrink) {
						this.lastSelected = item;
					}
					if (range[i] in toDeselect) {
						delete toDeselect[range[i]];
					}
				}
			}
		} else {
			this.lastSelected = fromItem;
		}
		for (var i in toDeselect) {
			if (this.items[i] == this.lastSelected) {
			}
			this.deselect(this.items[i]);
		}
		this._updatePivot();
	}, growUp:function () {
		if (!this.isGrowable) {
			return;
		}
		var idx = this._find(this.lastSelected) - 1;
		while (idx >= 0) {
			if (this.selectFilter(this.items[idx], this.selection, false, true)) {
				this.grow(this.items[idx]);
				break;
			}
			idx--;
		}
	}, growDown:function () {
		if (!this.isGrowable) {
			return;
		}
		var idx = this._find(this.lastSelected);
		if (idx < 0 && this.allowImplicit) {
			this.select(this.items[0]);
			idx = 0;
		}
		idx++;
		while (idx > 0 && idx < this.items.length) {
			if (this.selectFilter(this.items[idx], this.selection, false, true)) {
				this.grow(this.items[idx]);
				break;
			}
			idx++;
		}
	}, toggleSelected:function (item, noPivot) {
		if (this.isItem(item)) {
			if (this.select(item, noPivot)) {
				return 1;
			}
			if (this.deselect(item)) {
				return -1;
			}
		}
		return 0;
	}, select:function (item, noPivot) {
		if (this.isItem(item) && !this.isSelected(item) && this.isSelectable(item)) {
			this.selection.push(item);
			this.lastSelected = item;
			this.onSelect(item);
			this.onSelectChange(item, true);
			if (!noPivot) {
				this._addPivot(item);
			}
			this.length = this.selection.length;
			return true;
		}
		return false;
	}, deselect:function (item) {
		var idx = this._find(item, true);
		if (idx > -1) {
			this.selection.splice(idx, 1);
			this.onDeselect(item);
			this.onSelectChange(item, false);
			if (item == this.lastSelected) {
				this.lastSelected = null;
			}
			this._removePivot(item);
			this.length = this.selection.length;
			return true;
		}
		return false;
	}, selectAll:function () {
		for (var i = 0; i < this.items.length; i++) {
			this.select(this.items[i]);
		}
	}, deselectAll:function () {
		while (this.selection && this.selection.length) {
			this.deselect(this.selection[0]);
		}
	}, selectNext:function () {
		var idx = this._find(this.lastSelected);
		while (idx > -1 && ++idx < this.items.length) {
			if (this.isSelectable(this.items[idx])) {
				this.deselectAll();
				this.select(this.items[idx]);
				return true;
			}
		}
		return false;
	}, selectPrevious:function () {
		var idx = this._find(this.lastSelected);
		while (idx-- > 0) {
			if (this.isSelectable(this.items[idx])) {
				this.deselectAll();
				this.select(this.items[idx]);
				return true;
			}
		}
		return false;
	}, selectFirst:function () {
		this.deselectAll();
		var idx = 0;
		while (this.items[idx] && !this.select(this.items[idx])) {
			idx++;
		}
		return this.items[idx] ? true : false;
	}, selectLast:function () {
		this.deselectAll();
		var idx = this.items.length - 1;
		while (this.items[idx] && !this.select(this.items[idx])) {
			idx--;
		}
		return this.items[idx] ? true : false;
	}, _addPivot:function (item, andClear) {
		this._pivotItem = item;
		if (andClear) {
			this._pivotItems = [item];
		} else {
			this._pivotItems.push(item);
		}
	}, _removePivot:function (item) {
		var i = dojo.lang.find(this._pivotItems, item);
		if (i > -1) {
			this._pivotItems.splice(i, 1);
			this._pivotItem = this._pivotItems[this._pivotItems.length - 1];
		}
		this._updatePivot();
	}, _updatePivot:function () {
		if (this._pivotItems.length == 0) {
			if (this.lastSelected) {
				this._addPivot(this.lastSelected);
			}
		}
	}, sorted:function () {
		return dojo.lang.toArray(this.selection).sort(dojo.lang.hitch(this, function (a, b) {
			var A = this._find(a), B = this._find(b);
			if (A > B) {
				return 1;
			} else {
				if (A < B) {
					return -1;
				} else {
					return 0;
				}
			}
		}));
	}, updateSelected:function () {
		for (var i = 0; i < this.selection.length; i++) {
			if (this._find(this.selection[i]) < 0) {
				var removed = this.selection.splice(i, 1);
				this._removePivot(removed[0]);
			}
		}
		this.length = this.selection.length;
	}});
}});


__CPAN_DIR__ src/string
__CPAN_FILE__ src/string/common.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.string.common");
dojo.string.trim = function (str, wh) {
	if (!str.replace) {
		return str;
	}
	if (!str.length) {
		return str;
	}
	var re = (wh > 0) ? (/^\s+/) : (wh < 0) ? (/\s+$/) : (/^\s+|\s+$/g);
	return str.replace(re, "");
};
dojo.string.trimStart = function (str) {
	return dojo.string.trim(str, 1);
};
dojo.string.trimEnd = function (str) {
	return dojo.string.trim(str, -1);
};
dojo.string.repeat = function (str, count, separator) {
	var out = "";
	for (var i = 0; i < count; i++) {
		out += str;
		if (separator && i < count - 1) {
			out += separator;
		}
	}
	return out;
};
dojo.string.pad = function (str, len, c, dir) {
	var out = String(str);
	if (!c) {
		c = "0";
	}
	if (!dir) {
		dir = 1;
	}
	while (out.length < len) {
		if (dir > 0) {
			out = c + out;
		} else {
			out += c;
		}
	}
	return out;
};
dojo.string.padLeft = function (str, len, c) {
	return dojo.string.pad(str, len, c, 1);
};
dojo.string.padRight = function (str, len, c) {
	return dojo.string.pad(str, len, c, -1);
};


__CPAN_FILE__ src/string/Builder.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.string.Builder");
dojo.require("dojo.string");
dojo.require("dojo.lang.common");
dojo.string.Builder = function (str) {
	this.arrConcat = (dojo.render.html.capable && dojo.render.html["ie"]);
	var a = [];
	var b = "";
	var length = this.length = b.length;
	if (this.arrConcat) {
		if (b.length > 0) {
			a.push(b);
		}
		b = "";
	}
	this.toString = this.valueOf = function () {
		return (this.arrConcat) ? a.join("") : b;
	};
	this.append = function () {
		for (var x = 0; x < arguments.length; x++) {
			var s = arguments[x];
			if (dojo.lang.isArrayLike(s)) {
				this.append.apply(this, s);
			} else {
				if (this.arrConcat) {
					a.push(s);
				} else {
					b += s;
				}
				length += s.length;
				this.length = length;
			}
		}
		return this;
	};
	this.clear = function () {
		a = [];
		b = "";
		length = this.length = 0;
		return this;
	};
	this.remove = function (f, l) {
		var s = "";
		if (this.arrConcat) {
			b = a.join("");
		}
		a = [];
		if (f > 0) {
			s = b.substring(0, (f - 1));
		}
		b = s + b.substring(f + l);
		length = this.length = b.length;
		if (this.arrConcat) {
			a.push(b);
			b = "";
		}
		return this;
	};
	this.replace = function (o, n) {
		if (this.arrConcat) {
			b = a.join("");
		}
		a = [];
		b = b.replace(o, n);
		length = this.length = b.length;
		if (this.arrConcat) {
			a.push(b);
			b = "";
		}
		return this;
	};
	this.insert = function (idx, s) {
		if (this.arrConcat) {
			b = a.join("");
		}
		a = [];
		if (idx == 0) {
			b = s + b;
		} else {
			var t = b.split("");
			t.splice(idx, 0, s);
			b = t.join("");
		}
		length = this.length = b.length;
		if (this.arrConcat) {
			a.push(b);
			b = "";
		}
		return this;
	};
	this.append.apply(this, arguments);
};


__CPAN_FILE__ src/string/Builder.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.string.Builder"], ["require", "dojo.string"], ["require", "dojo.lang.common"]], definePackage:function (dojo) {
	dojo.provide("dojo.string.Builder");
	dojo.require("dojo.string");
	dojo.require("dojo.lang.common");
	dojo.string.Builder = function (str) {
		this.arrConcat = (dojo.render.html.capable && dojo.render.html["ie"]);
		var a = [];
		var b = "";
		var length = this.length = b.length;
		if (this.arrConcat) {
			if (b.length > 0) {
				a.push(b);
			}
			b = "";
		}
		this.toString = this.valueOf = function () {
			return (this.arrConcat) ? a.join("") : b;
		};
		this.append = function () {
			for (var x = 0; x < arguments.length; x++) {
				var s = arguments[x];
				if (dojo.lang.isArrayLike(s)) {
					this.append.apply(this, s);
				} else {
					if (this.arrConcat) {
						a.push(s);
					} else {
						b += s;
					}
					length += s.length;
					this.length = length;
				}
			}
			return this;
		};
		this.clear = function () {
			a = [];
			b = "";
			length = this.length = 0;
			return this;
		};
		this.remove = function (f, l) {
			var s = "";
			if (this.arrConcat) {
				b = a.join("");
			}
			a = [];
			if (f > 0) {
				s = b.substring(0, (f - 1));
			}
			b = s + b.substring(f + l);
			length = this.length = b.length;
			if (this.arrConcat) {
				a.push(b);
				b = "";
			}
			return this;
		};
		this.replace = function (o, n) {
			if (this.arrConcat) {
				b = a.join("");
			}
			a = [];
			b = b.replace(o, n);
			length = this.length = b.length;
			if (this.arrConcat) {
				a.push(b);
				b = "";
			}
			return this;
		};
		this.insert = function (idx, s) {
			if (this.arrConcat) {
				b = a.join("");
			}
			a = [];
			if (idx == 0) {
				b = s + b;
			} else {
				var t = b.split("");
				t.splice(idx, 0, s);
				b = t.join("");
			}
			length = this.length = b.length;
			if (this.arrConcat) {
				a.push(b);
				b = "";
			}
			return this;
		};
		this.append.apply(this, arguments);
	};
}});


__CPAN_FILE__ src/string/__package__.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.kwCompoundRequire({common:["dojo.string", "dojo.string.common", "dojo.string.extras", "dojo.string.Builder"]});
dojo.provide("dojo.string.*");


__CPAN_FILE__ src/string/extras.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.string.extras"], ["require", "dojo.string.common"], ["require", "dojo.lang.common"], ["require", "dojo.lang.array"]], definePackage:function (dojo) {
	dojo.provide("dojo.string.extras");
	dojo.require("dojo.string.common");
	dojo.require("dojo.lang.common");
	dojo.require("dojo.lang.array");
	dojo.string.substituteParams = function (template, hash) {
		var map = (typeof hash == "object") ? hash : dojo.lang.toArray(arguments, 1);
		return template.replace(/\%\{(\w+)\}/g, function (match, key) {
			if (typeof (map[key]) != "undefined" && map[key] != null) {
				return map[key];
			}
			dojo.raise("Substitution not found: " + key);
		});
	};
	dojo.string.capitalize = function (str) {
		if (!dojo.lang.isString(str)) {
			return "";
		}
		if (arguments.length == 0) {
			str = this;
		}
		var words = str.split(" ");
		for (var i = 0; i < words.length; i++) {
			words[i] = words[i].charAt(0).toUpperCase() + words[i].substring(1);
		}
		return words.join(" ");
	};
	dojo.string.isBlank = function (str) {
		if (!dojo.lang.isString(str)) {
			return true;
		}
		return (dojo.string.trim(str).length == 0);
	};
	dojo.string.encodeAscii = function (str) {
		if (!dojo.lang.isString(str)) {
			return str;
		}
		var ret = "";
		var value = escape(str);
		var match, re = /%u([0-9A-F]{4})/i;
		while ((match = value.match(re))) {
			var num = Number("0x" + match[1]);
			var newVal = escape("&#" + num + ";");
			ret += value.substring(0, match.index) + newVal;
			value = value.substring(match.index + match[0].length);
		}
		ret += value.replace(/\+/g, "%2B");
		return ret;
	};
	dojo.string.escape = function (type, str) {
		var args = dojo.lang.toArray(arguments, 1);
		switch (type.toLowerCase()) {
		  case "xml":
		  case "html":
		  case "xhtml":
			return dojo.string.escapeXml.apply(this, args);
		  case "sql":
			return dojo.string.escapeSql.apply(this, args);
		  case "regexp":
		  case "regex":
			return dojo.string.escapeRegExp.apply(this, args);
		  case "javascript":
		  case "jscript":
		  case "js":
			return dojo.string.escapeJavaScript.apply(this, args);
		  case "ascii":
			return dojo.string.encodeAscii.apply(this, args);
		  default:
			return str;
		}
	};
	dojo.string.escapeXml = function (str, noSingleQuotes) {
		str = str.replace(/&/gm, "&amp;").replace(/</gm, "&lt;").replace(/>/gm, "&gt;").replace(/"/gm, "&quot;");
		if (!noSingleQuotes) {
			str = str.replace(/'/gm, "&#39;");
		}
		return str;
	};
	dojo.string.escapeSql = function (str) {
		return str.replace(/'/gm, "''");
	};
	dojo.string.escapeRegExp = function (str) {
		return str.replace(/\\/gm, "\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm, "\\$1");
	};
	dojo.string.escapeJavaScript = function (str) {
		return str.replace(/(["'\f\b\n\t\r])/gm, "\\$1");
	};
	dojo.string.escapeString = function (str) {
		return ("\"" + str.replace(/(["\\])/g, "\\$1") + "\"").replace(/[\f]/g, "\\f").replace(/[\b]/g, "\\b").replace(/[\n]/g, "\\n").replace(/[\t]/g, "\\t").replace(/[\r]/g, "\\r");
	};
	dojo.string.summary = function (str, len) {
		if (!len || str.length <= len) {
			return str;
		}
		return str.substring(0, len).replace(/\.+$/, "") + "...";
	};
	dojo.string.endsWith = function (str, end, ignoreCase) {
		if (ignoreCase) {
			str = str.toLowerCase();
			end = end.toLowerCase();
		}
		if ((str.length - end.length) < 0) {
			return false;
		}
		return str.lastIndexOf(end) == str.length - end.length;
	};
	dojo.string.endsWithAny = function (str) {
		for (var i = 1; i < arguments.length; i++) {
			if (dojo.string.endsWith(str, arguments[i])) {
				return true;
			}
		}
		return false;
	};
	dojo.string.startsWith = function (str, start, ignoreCase) {
		if (ignoreCase) {
			str = str.toLowerCase();
			start = start.toLowerCase();
		}
		return str.indexOf(start) == 0;
	};
	dojo.string.startsWithAny = function (str) {
		for (var i = 1; i < arguments.length; i++) {
			if (dojo.string.startsWith(str, arguments[i])) {
				return true;
			}
		}
		return false;
	};
	dojo.string.has = function (str) {
		for (var i = 1; i < arguments.length; i++) {
			if (str.indexOf(arguments[i]) > -1) {
				return true;
			}
		}
		return false;
	};
	dojo.string.normalizeNewlines = function (text, newlineChar) {
		if (newlineChar == "\n") {
			text = text.replace(/\r\n/g, "\n");
			text = text.replace(/\r/g, "\n");
		} else {
			if (newlineChar == "\r") {
				text = text.replace(/\r\n/g, "\r");
				text = text.replace(/\n/g, "\r");
			} else {
				text = text.replace(/([^\r])\n/g, "$1\r\n").replace(/\r([^\n])/g, "\r\n$1");
			}
		}
		return text;
	};
	dojo.string.splitEscaped = function (str, charac) {
		var components = [];
		for (var i = 0, prevcomma = 0; i < str.length; i++) {
			if (str.charAt(i) == "\\") {
				i++;
				continue;
			}
			if (str.charAt(i) == charac) {
				components.push(str.substring(prevcomma, i));
				prevcomma = i + 1;
			}
		}
		components.push(str.substr(prevcomma));
		return components;
	};
}});


__CPAN_FILE__ src/string/__package__.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["kwCompoundRequire", {common:["dojo.string", "dojo.string.common", "dojo.string.extras", "dojo.string.Builder"]}], ["provide", "dojo.string.*"]], definePackage:function (dojo) {
	dojo.kwCompoundRequire({common:["dojo.string", "dojo.string.common", "dojo.string.extras", "dojo.string.Builder"]});
	dojo.provide("dojo.string.*");
}});


__CPAN_FILE__ src/string/common.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.string.common"]], definePackage:function (dojo) {
	dojo.provide("dojo.string.common");
	dojo.string.trim = function (str, wh) {
		if (!str.replace) {
			return str;
		}
		if (!str.length) {
			return str;
		}
		var re = (wh > 0) ? (/^\s+/) : (wh < 0) ? (/\s+$/) : (/^\s+|\s+$/g);
		return str.replace(re, "");
	};
	dojo.string.trimStart = function (str) {
		return dojo.string.trim(str, 1);
	};
	dojo.string.trimEnd = function (str) {
		return dojo.string.trim(str, -1);
	};
	dojo.string.repeat = function (str, count, separator) {
		var out = "";
		for (var i = 0; i < count; i++) {
			out += str;
			if (separator && i < count - 1) {
				out += separator;
			}
		}
		return out;
	};
	dojo.string.pad = function (str, len, c, dir) {
		var out = String(str);
		if (!c) {
			c = "0";
		}
		if (!dir) {
			dir = 1;
		}
		while (out.length < len) {
			if (dir > 0) {
				out = c + out;
			} else {
				out += c;
			}
		}
		return out;
	};
	dojo.string.padLeft = function (str, len, c) {
		return dojo.string.pad(str, len, c, 1);
	};
	dojo.string.padRight = function (str, len, c) {
		return dojo.string.pad(str, len, c, -1);
	};
}});


__CPAN_FILE__ src/string/extras.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.string.extras");
dojo.require("dojo.string.common");
dojo.require("dojo.lang.common");
dojo.require("dojo.lang.array");
dojo.string.substituteParams = function (template, hash) {
	var map = (typeof hash == "object") ? hash : dojo.lang.toArray(arguments, 1);
	return template.replace(/\%\{(\w+)\}/g, function (match, key) {
		if (typeof (map[key]) != "undefined" && map[key] != null) {
			return map[key];
		}
		dojo.raise("Substitution not found: " + key);
	});
};
dojo.string.capitalize = function (str) {
	if (!dojo.lang.isString(str)) {
		return "";
	}
	if (arguments.length == 0) {
		str = this;
	}
	var words = str.split(" ");
	for (var i = 0; i < words.length; i++) {
		words[i] = words[i].charAt(0).toUpperCase() + words[i].substring(1);
	}
	return words.join(" ");
};
dojo.string.isBlank = function (str) {
	if (!dojo.lang.isString(str)) {
		return true;
	}
	return (dojo.string.trim(str).length == 0);
};
dojo.string.encodeAscii = function (str) {
	if (!dojo.lang.isString(str)) {
		return str;
	}
	var ret = "";
	var value = escape(str);
	var match, re = /%u([0-9A-F]{4})/i;
	while ((match = value.match(re))) {
		var num = Number("0x" + match[1]);
		var newVal = escape("&#" + num + ";");
		ret += value.substring(0, match.index) + newVal;
		value = value.substring(match.index + match[0].length);
	}
	ret += value.replace(/\+/g, "%2B");
	return ret;
};
dojo.string.escape = function (type, str) {
	var args = dojo.lang.toArray(arguments, 1);
	switch (type.toLowerCase()) {
	  case "xml":
	  case "html":
	  case "xhtml":
		return dojo.string.escapeXml.apply(this, args);
	  case "sql":
		return dojo.string.escapeSql.apply(this, args);
	  case "regexp":
	  case "regex":
		return dojo.string.escapeRegExp.apply(this, args);
	  case "javascript":
	  case "jscript":
	  case "js":
		return dojo.string.escapeJavaScript.apply(this, args);
	  case "ascii":
		return dojo.string.encodeAscii.apply(this, args);
	  default:
		return str;
	}
};
dojo.string.escapeXml = function (str, noSingleQuotes) {
	str = str.replace(/&/gm, "&amp;").replace(/</gm, "&lt;").replace(/>/gm, "&gt;").replace(/"/gm, "&quot;");
	if (!noSingleQuotes) {
		str = str.replace(/'/gm, "&#39;");
	}
	return str;
};
dojo.string.escapeSql = function (str) {
	return str.replace(/'/gm, "''");
};
dojo.string.escapeRegExp = function (str) {
	return str.replace(/\\/gm, "\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm, "\\$1");
};
dojo.string.escapeJavaScript = function (str) {
	return str.replace(/(["'\f\b\n\t\r])/gm, "\\$1");
};
dojo.string.escapeString = function (str) {
	return ("\"" + str.replace(/(["\\])/g, "\\$1") + "\"").replace(/[\f]/g, "\\f").replace(/[\b]/g, "\\b").replace(/[\n]/g, "\\n").replace(/[\t]/g, "\\t").replace(/[\r]/g, "\\r");
};
dojo.string.summary = function (str, len) {
	if (!len || str.length <= len) {
		return str;
	}
	return str.substring(0, len).replace(/\.+$/, "") + "...";
};
dojo.string.endsWith = function (str, end, ignoreCase) {
	if (ignoreCase) {
		str = str.toLowerCase();
		end = end.toLowerCase();
	}
	if ((str.length - end.length) < 0) {
		return false;
	}
	return str.lastIndexOf(end) == str.length - end.length;
};
dojo.string.endsWithAny = function (str) {
	for (var i = 1; i < arguments.length; i++) {
		if (dojo.string.endsWith(str, arguments[i])) {
			return true;
		}
	}
	return false;
};
dojo.string.startsWith = function (str, start, ignoreCase) {
	if (ignoreCase) {
		str = str.toLowerCase();
		start = start.toLowerCase();
	}
	return str.indexOf(start) == 0;
};
dojo.string.startsWithAny = function (str) {
	for (var i = 1; i < arguments.length; i++) {
		if (dojo.string.startsWith(str, arguments[i])) {
			return true;
		}
	}
	return false;
};
dojo.string.has = function (str) {
	for (var i = 1; i < arguments.length; i++) {
		if (str.indexOf(arguments[i]) > -1) {
			return true;
		}
	}
	return false;
};
dojo.string.normalizeNewlines = function (text, newlineChar) {
	if (newlineChar == "\n") {
		text = text.replace(/\r\n/g, "\n");
		text = text.replace(/\r/g, "\n");
	} else {
		if (newlineChar == "\r") {
			text = text.replace(/\r\n/g, "\r");
			text = text.replace(/\n/g, "\r");
		} else {
			text = text.replace(/([^\r])\n/g, "$1\r\n").replace(/\r([^\n])/g, "\r\n$1");
		}
	}
	return text;
};
dojo.string.splitEscaped = function (str, charac) {
	var components = [];
	for (var i = 0, prevcomma = 0; i < str.length; i++) {
		if (str.charAt(i) == "\\") {
			i++;
			continue;
		}
		if (str.charAt(i) == charac) {
			components.push(str.substring(prevcomma, i));
			prevcomma = i + 1;
		}
	}
	components.push(str.substr(prevcomma));
	return components;
};


__CPAN_DIR__ src/html
__CPAN_FILE__ src/html/util.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.html.util");
dojo.require("dojo.html.layout");
dojo.html.getElementWindow = function (element) {
	return dojo.html.getDocumentWindow(element.ownerDocument);
};
dojo.html.getDocumentWindow = function (doc) {
	if (dojo.render.html.safari && !doc._parentWindow) {
		var fix = function (win) {
			win.document._parentWindow = win;
			for (var i = 0; i < win.frames.length; i++) {
				fix(win.frames[i]);
			}
		};
		fix(window.top);
	}
	if (dojo.render.html.ie && window !== document.parentWindow && !doc._parentWindow) {
		doc.parentWindow.execScript("document._parentWindow = window;", "Javascript");
		var win = doc._parentWindow;
		doc._parentWindow = null;
		return win;
	}
	return doc._parentWindow || doc.parentWindow || doc.defaultView;
};
dojo.html.gravity = function (node, e) {
	node = dojo.byId(node);
	var mouse = dojo.html.getCursorPosition(e);
	with (dojo.html) {
		var absolute = getAbsolutePosition(node, true);
		var bb = getBorderBox(node);
		var nodecenterx = absolute.x + (bb.width / 2);
		var nodecentery = absolute.y + (bb.height / 2);
	}
	with (dojo.html.gravity) {
		return ((mouse.x < nodecenterx ? WEST : EAST) | (mouse.y < nodecentery ? NORTH : SOUTH));
	}
};
dojo.html.gravity.NORTH = 1;
dojo.html.gravity.SOUTH = 1 << 1;
dojo.html.gravity.EAST = 1 << 2;
dojo.html.gravity.WEST = 1 << 3;
dojo.html.overElement = function (element, e) {
	element = dojo.byId(element);
	var mouse = dojo.html.getCursorPosition(e);
	var bb = dojo.html.getBorderBox(element);
	var absolute = dojo.html.getAbsolutePosition(element, true, dojo.html.boxSizing.BORDER_BOX);
	var top = absolute.y;
	var bottom = top + bb.height;
	var left = absolute.x;
	var right = left + bb.width;
	return (mouse.x >= left && mouse.x <= right && mouse.y >= top && mouse.y <= bottom);
};
dojo.html.renderedTextContent = function (node) {
	node = dojo.byId(node);
	var result = "";
	if (node == null) {
		return result;
	}
	for (var i = 0; i < node.childNodes.length; i++) {
		switch (node.childNodes[i].nodeType) {
		  case 1:
		  case 5:
			var display = "unknown";
			try {
				display = dojo.html.getStyle(node.childNodes[i], "display");
			}
			catch (E) {
			}
			switch (display) {
			  case "block":
			  case "list-item":
			  case "run-in":
			  case "table":
			  case "table-row-group":
			  case "table-header-group":
			  case "table-footer-group":
			  case "table-row":
			  case "table-column-group":
			  case "table-column":
			  case "table-cell":
			  case "table-caption":
				result += "\n";
				result += dojo.html.renderedTextContent(node.childNodes[i]);
				result += "\n";
				break;
			  case "none":
				break;
			  default:
				if (node.childNodes[i].tagName && node.childNodes[i].tagName.toLowerCase() == "br") {
					result += "\n";
				} else {
					result += dojo.html.renderedTextContent(node.childNodes[i]);
				}
				break;
			}
			break;
		  case 3:
		  case 2:
		  case 4:
			var text = node.childNodes[i].nodeValue;
			var textTransform = "unknown";
			try {
				textTransform = dojo.html.getStyle(node, "text-transform");
			}
			catch (E) {
			}
			switch (textTransform) {
			  case "capitalize":
				var words = text.split(" ");
				for (var i = 0; i < words.length; i++) {
					words[i] = words[i].charAt(0).toUpperCase() + words[i].substring(1);
				}
				text = words.join(" ");
				break;
			  case "uppercase":
				text = text.toUpperCase();
				break;
			  case "lowercase":
				text = text.toLowerCase();
				break;
			  default:
				break;
			}
			switch (textTransform) {
			  case "nowrap":
				break;
			  case "pre-wrap":
				break;
			  case "pre-line":
				break;
			  case "pre":
				break;
			  default:
				text = text.replace(/\s+/, " ");
				if (/\s$/.test(result)) {
					text.replace(/^\s/, "");
				}
				break;
			}
			result += text;
			break;
		  default:
			break;
		}
	}
	return result;
};
dojo.html.createNodesFromText = function (txt, trim) {
	if (trim) {
		txt = txt.replace(/^\s+|\s+$/g, "");
	}
	var tn = dojo.doc().createElement("div");
	tn.style.visibility = "hidden";
	dojo.body().appendChild(tn);
	var tableType = "none";
	if ((/^<t[dh][\s\r\n>]/i).test(txt.replace(/^\s+/))) {
		txt = "<table><tbody><tr>" + txt + "</tr></tbody></table>";
		tableType = "cell";
	} else {
		if ((/^<tr[\s\r\n>]/i).test(txt.replace(/^\s+/))) {
			txt = "<table><tbody>" + txt + "</tbody></table>";
			tableType = "row";
		} else {
			if ((/^<(thead|tbody|tfoot)[\s\r\n>]/i).test(txt.replace(/^\s+/))) {
				txt = "<table>" + txt + "</table>";
				tableType = "section";
			}
		}
	}
	tn.innerHTML = txt;
	if (tn["normalize"]) {
		tn.normalize();
	}
	var parent = null;
	switch (tableType) {
	  case "cell":
		parent = tn.getElementsByTagName("tr")[0];
		break;
	  case "row":
		parent = tn.getElementsByTagName("tbody")[0];
		break;
	  case "section":
		parent = tn.getElementsByTagName("table")[0];
		break;
	  default:
		parent = tn;
		break;
	}
	var nodes = [];
	for (var x = 0; x < parent.childNodes.length; x++) {
		nodes.push(parent.childNodes[x].cloneNode(true));
	}
	tn.style.display = "none";
	dojo.html.destroyNode(tn);
	return nodes;
};
dojo.html.placeOnScreen = function (node, desiredX, desiredY, padding, hasScroll, corners, tryOnly) {
	if (desiredX instanceof Array || typeof desiredX == "array") {
		tryOnly = corners;
		corners = hasScroll;
		hasScroll = padding;
		padding = desiredY;
		desiredY = desiredX[1];
		desiredX = desiredX[0];
	}
	if (corners instanceof String || typeof corners == "string") {
		corners = corners.split(",");
	}
	if (!isNaN(padding)) {
		padding = [Number(padding), Number(padding)];
	} else {
		if (!(padding instanceof Array || typeof padding == "array")) {
			padding = [0, 0];
		}
	}
	var scroll = dojo.html.getScroll().offset;
	var view = dojo.html.getViewport();
	node = dojo.byId(node);
	var oldDisplay = node.style.display;
	node.style.display = "";
	var bb = dojo.html.getBorderBox(node);
	var w = bb.width;
	var h = bb.height;
	node.style.display = oldDisplay;
	if (!(corners instanceof Array || typeof corners == "array")) {
		corners = ["TL"];
	}
	var bestx, besty, bestDistance = Infinity, bestCorner;
	for (var cidex = 0; cidex < corners.length; ++cidex) {
		var corner = corners[cidex];
		var match = true;
		var tryX = desiredX - (corner.charAt(1) == "L" ? 0 : w) + padding[0] * (corner.charAt(1) == "L" ? 1 : -1);
		var tryY = desiredY - (corner.charAt(0) == "T" ? 0 : h) + padding[1] * (corner.charAt(0) == "T" ? 1 : -1);
		if (hasScroll) {
			tryX -= scroll.x;
			tryY -= scroll.y;
		}
		if (tryX < 0) {
			tryX = 0;
			match = false;
		}
		if (tryY < 0) {
			tryY = 0;
			match = false;
		}
		var x = tryX + w;
		if (x > view.width) {
			x = view.width - w;
			match = false;
		} else {
			x = tryX;
		}
		x = Math.max(padding[0], x) + scroll.x;
		var y = tryY + h;
		if (y > view.height) {
			y = view.height - h;
			match = false;
		} else {
			y = tryY;
		}
		y = Math.max(padding[1], y) + scroll.y;
		if (match) {
			bestx = x;
			besty = y;
			bestDistance = 0;
			bestCorner = corner;
			break;
		} else {
			var dist = Math.pow(x - tryX - scroll.x, 2) + Math.pow(y - tryY - scroll.y, 2);
			if (bestDistance > dist) {
				bestDistance = dist;
				bestx = x;
				besty = y;
				bestCorner = corner;
			}
		}
	}
	if (!tryOnly) {
		node.style.left = bestx + "px";
		node.style.top = besty + "px";
	}
	return {left:bestx, top:besty, x:bestx, y:besty, dist:bestDistance, corner:bestCorner};
};
dojo.html.placeOnScreenPoint = function (node, desiredX, desiredY, padding, hasScroll) {
	dojo.deprecated("dojo.html.placeOnScreenPoint", "use dojo.html.placeOnScreen() instead", "0.5");
	return dojo.html.placeOnScreen(node, desiredX, desiredY, padding, hasScroll, ["TL", "TR", "BL", "BR"]);
};
dojo.html.placeOnScreenAroundElement = function (node, aroundNode, padding, aroundType, aroundCorners, tryOnly) {
	var best, bestDistance = Infinity;
	aroundNode = dojo.byId(aroundNode);
	var oldDisplay = aroundNode.style.display;
	aroundNode.style.display = "";
	var mb = dojo.html.getElementBox(aroundNode, aroundType);
	var aroundNodeW = mb.width;
	var aroundNodeH = mb.height;
	var aroundNodePos = dojo.html.getAbsolutePosition(aroundNode, true, aroundType);
	aroundNode.style.display = oldDisplay;
	for (var nodeCorner in aroundCorners) {
		var pos, desiredX, desiredY;
		var corners = aroundCorners[nodeCorner];
		desiredX = aroundNodePos.x + (nodeCorner.charAt(1) == "L" ? 0 : aroundNodeW);
		desiredY = aroundNodePos.y + (nodeCorner.charAt(0) == "T" ? 0 : aroundNodeH);
		pos = dojo.html.placeOnScreen(node, desiredX, desiredY, padding, true, corners, true);
		if (pos.dist == 0) {
			best = pos;
			break;
		} else {
			if (bestDistance > pos.dist) {
				bestDistance = pos.dist;
				best = pos;
			}
		}
	}
	if (!tryOnly) {
		node.style.left = best.left + "px";
		node.style.top = best.top + "px";
	}
	return best;
};
dojo.html.scrollIntoView = function (node) {
	if (!node) {
		return;
	}
	if (dojo.render.html.ie) {
		if (dojo.html.getBorderBox(node.parentNode).height <= node.parentNode.scrollHeight) {
			node.scrollIntoView(false);
		}
	} else {
		if (dojo.render.html.mozilla) {
			node.scrollIntoView(false);
		} else {
			var parent = node.parentNode;
			var parentBottom = parent.scrollTop + dojo.html.getBorderBox(parent).height;
			var nodeBottom = node.offsetTop + dojo.html.getMarginBox(node).height;
			if (parentBottom < nodeBottom) {
				parent.scrollTop += (nodeBottom - parentBottom);
			} else {
				if (parent.scrollTop > node.offsetTop) {
					parent.scrollTop -= (parent.scrollTop - node.offsetTop);
				}
			}
		}
	}
};


__CPAN_FILE__ src/html/display.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.html.display");
dojo.require("dojo.html.style");
dojo.html._toggle = function (node, tester, setter) {
	node = dojo.byId(node);
	setter(node, !tester(node));
	return tester(node);
};
dojo.html.show = function (node) {
	node = dojo.byId(node);
	if (dojo.html.getStyleProperty(node, "display") == "none") {
		dojo.html.setStyle(node, "display", (node.dojoDisplayCache || ""));
		node.dojoDisplayCache = undefined;
	}
};
dojo.html.hide = function (node) {
	node = dojo.byId(node);
	if (typeof node["dojoDisplayCache"] == "undefined") {
		var d = dojo.html.getStyleProperty(node, "display");
		if (d != "none") {
			node.dojoDisplayCache = d;
		}
	}
	dojo.html.setStyle(node, "display", "none");
};
dojo.html.setShowing = function (node, showing) {
	dojo.html[(showing ? "show" : "hide")](node);
};
dojo.html.isShowing = function (node) {
	return (dojo.html.getStyleProperty(node, "display") != "none");
};
dojo.html.toggleShowing = function (node) {
	return dojo.html._toggle(node, dojo.html.isShowing, dojo.html.setShowing);
};
dojo.html.displayMap = {tr:"", td:"", th:"", img:"inline", span:"inline", input:"inline", button:"inline"};
dojo.html.suggestDisplayByTagName = function (node) {
	node = dojo.byId(node);
	if (node && node.tagName) {
		var tag = node.tagName.toLowerCase();
		return (tag in dojo.html.displayMap ? dojo.html.displayMap[tag] : "block");
	}
};
dojo.html.setDisplay = function (node, display) {
	dojo.html.setStyle(node, "display", ((display instanceof String || typeof display == "string") ? display : (display ? dojo.html.suggestDisplayByTagName(node) : "none")));
};
dojo.html.isDisplayed = function (node) {
	return (dojo.html.getComputedStyle(node, "display") != "none");
};
dojo.html.toggleDisplay = function (node) {
	return dojo.html._toggle(node, dojo.html.isDisplayed, dojo.html.setDisplay);
};
dojo.html.setVisibility = function (node, visibility) {
	dojo.html.setStyle(node, "visibility", ((visibility instanceof String || typeof visibility == "string") ? visibility : (visibility ? "visible" : "hidden")));
};
dojo.html.isVisible = function (node) {
	return (dojo.html.getComputedStyle(node, "visibility") != "hidden");
};
dojo.html.toggleVisibility = function (node) {
	return dojo.html._toggle(node, dojo.html.isVisible, dojo.html.setVisibility);
};
dojo.html.setOpacity = function (node, opacity, dontFixOpacity) {
	node = dojo.byId(node);
	var h = dojo.render.html;
	if (!dontFixOpacity) {
		if (opacity >= 1) {
			if (h.ie) {
				dojo.html.clearOpacity(node);
				return;
			} else {
				opacity = 0.999999;
			}
		} else {
			if (opacity < 0) {
				opacity = 0;
			}
		}
	}
	if (h.ie) {
		if (node.nodeName.toLowerCase() == "tr") {
			var tds = node.getElementsByTagName("td");
			for (var x = 0; x < tds.length; x++) {
				tds[x].style.filter = "Alpha(Opacity=" + opacity * 100 + ")";
			}
		}
		node.style.filter = "Alpha(Opacity=" + opacity * 100 + ")";
	} else {
		if (h.moz) {
			node.style.opacity = opacity;
			node.style.MozOpacity = opacity;
		} else {
			if (h.safari) {
				node.style.opacity = opacity;
				node.style.KhtmlOpacity = opacity;
			} else {
				node.style.opacity = opacity;
			}
		}
	}
};
dojo.html.clearOpacity = function (node) {
	node = dojo.byId(node);
	var ns = node.style;
	var h = dojo.render.html;
	if (h.ie) {
		try {
			if (node.filters && node.filters.alpha) {
				ns.filter = "";
			}
		}
		catch (e) {
		}
	} else {
		if (h.moz) {
			ns.opacity = 1;
			ns.MozOpacity = 1;
		} else {
			if (h.safari) {
				ns.opacity = 1;
				ns.KhtmlOpacity = 1;
			} else {
				ns.opacity = 1;
			}
		}
	}
};
dojo.html.getOpacity = function (node) {
	node = dojo.byId(node);
	var h = dojo.render.html;
	if (h.ie) {
		var opac = (node.filters && node.filters.alpha && typeof node.filters.alpha.opacity == "number" ? node.filters.alpha.opacity : 100) / 100;
	} else {
		var opac = node.style.opacity || node.style.MozOpacity || node.style.KhtmlOpacity || 1;
	}
	return opac >= 0.999999 ? 1 : Number(opac);
};


__CPAN_FILE__ src/html/layout.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.html.layout"], ["require", "dojo.html.common"], ["require", "dojo.html.style"], ["require", "dojo.html.display"]], definePackage:function (dojo) {
	dojo.provide("dojo.html.layout");
	dojo.require("dojo.html.common");
	dojo.require("dojo.html.style");
	dojo.require("dojo.html.display");
	dojo.html.sumAncestorProperties = function (node, prop) {
		node = dojo.byId(node);
		if (!node) {
			return 0;
		}
		var retVal = 0;
		while (node) {
			if (dojo.html.getComputedStyle(node, "position") == "fixed") {
				return 0;
			}
			var val = node[prop];
			if (val) {
				retVal += val - 0;
				if (node == dojo.body()) {
					break;
				}
			}
			node = node.parentNode;
		}
		return retVal;
	};
	dojo.html.setStyleAttributes = function (node, attributes) {
		node = dojo.byId(node);
		var splittedAttribs = attributes.replace(/(;)?\s*$/, "").split(";");
		for (var i = 0; i < splittedAttribs.length; i++) {
			var nameValue = splittedAttribs[i].split(":");
			var name = nameValue[0].replace(/\s*$/, "").replace(/^\s*/, "").toLowerCase();
			var value = nameValue[1].replace(/\s*$/, "").replace(/^\s*/, "");
			switch (name) {
			  case "opacity":
				dojo.html.setOpacity(node, value);
				break;
			  case "content-height":
				dojo.html.setContentBox(node, {height:value});
				break;
			  case "content-width":
				dojo.html.setContentBox(node, {width:value});
				break;
			  case "outer-height":
				dojo.html.setMarginBox(node, {height:value});
				break;
			  case "outer-width":
				dojo.html.setMarginBox(node, {width:value});
				break;
			  default:
				node.style[dojo.html.toCamelCase(name)] = value;
			}
		}
	};
	dojo.html.boxSizing = {MARGIN_BOX:"margin-box", BORDER_BOX:"border-box", PADDING_BOX:"padding-box", CONTENT_BOX:"content-box"};
	dojo.html.getAbsolutePosition = dojo.html.abs = function (node, includeScroll, boxType) {
		node = dojo.byId(node, node.ownerDocument);
		var ret = {x:0, y:0};
		var bs = dojo.html.boxSizing;
		if (!boxType) {
			boxType = bs.CONTENT_BOX;
		}
		var nativeBoxType = 2;
		var targetBoxType;
		switch (boxType) {
		  case bs.MARGIN_BOX:
			targetBoxType = 3;
			break;
		  case bs.BORDER_BOX:
			targetBoxType = 2;
			break;
		  case bs.PADDING_BOX:
		  default:
			targetBoxType = 1;
			break;
		  case bs.CONTENT_BOX:
			targetBoxType = 0;
			break;
		}
		var h = dojo.render.html;
		var db = document["body"] || document["documentElement"];
		if (h.ie) {
			with (node.getBoundingClientRect()) {
				ret.x = left - 2;
				ret.y = top - 2;
			}
		} else {
			if (document.getBoxObjectFor) {
				nativeBoxType = 1;
				try {
					var bo = document.getBoxObjectFor(node);
					ret.x = bo.x - dojo.html.sumAncestorProperties(node, "scrollLeft");
					ret.y = bo.y - dojo.html.sumAncestorProperties(node, "scrollTop");
				}
				catch (e) {
				}
			} else {
				if (node["offsetParent"]) {
					var endNode;
					if ((h.safari) && (node.style.getPropertyValue("position") == "absolute") && (node.parentNode == db)) {
						endNode = db;
					} else {
						endNode = db.parentNode;
					}
					if (node.parentNode != db) {
						var nd = node;
						if (dojo.render.html.opera) {
							nd = db;
						}
						ret.x -= dojo.html.sumAncestorProperties(nd, "scrollLeft");
						ret.y -= dojo.html.sumAncestorProperties(nd, "scrollTop");
					}
					var curnode = node;
					do {
						var n = curnode["offsetLeft"];
						if (!h.opera || n > 0) {
							ret.x += isNaN(n) ? 0 : n;
						}
						var m = curnode["offsetTop"];
						ret.y += isNaN(m) ? 0 : m;
						curnode = curnode.offsetParent;
					} while ((curnode != endNode) && (curnode != null));
				} else {
					if (node["x"] && node["y"]) {
						ret.x += isNaN(node.x) ? 0 : node.x;
						ret.y += isNaN(node.y) ? 0 : node.y;
					}
				}
			}
		}
		if (includeScroll) {
			var scroll = dojo.html.getScroll();
			ret.y += scroll.top;
			ret.x += scroll.left;
		}
		var extentFuncArray = [dojo.html.getPaddingExtent, dojo.html.getBorderExtent, dojo.html.getMarginExtent];
		if (nativeBoxType > targetBoxType) {
			for (var i = targetBoxType; i < nativeBoxType; ++i) {
				ret.y += extentFuncArray[i](node, "top");
				ret.x += extentFuncArray[i](node, "left");
			}
		} else {
			if (nativeBoxType < targetBoxType) {
				for (var i = targetBoxType; i > nativeBoxType; --i) {
					ret.y -= extentFuncArray[i - 1](node, "top");
					ret.x -= extentFuncArray[i - 1](node, "left");
				}
			}
		}
		ret.top = ret.y;
		ret.left = ret.x;
		return ret;
	};
	dojo.html.isPositionAbsolute = function (node) {
		return (dojo.html.getComputedStyle(node, "position") == "absolute");
	};
	dojo.html._sumPixelValues = function (node, selectors, autoIsZero) {
		var total = 0;
		for (var x = 0; x < selectors.length; x++) {
			total += dojo.html.getPixelValue(node, selectors[x], autoIsZero);
		}
		return total;
	};
	dojo.html.getMargin = function (node) {
		return {width:dojo.html._sumPixelValues(node, ["margin-left", "margin-right"], (dojo.html.getComputedStyle(node, "position") == "absolute")), height:dojo.html._sumPixelValues(node, ["margin-top", "margin-bottom"], (dojo.html.getComputedStyle(node, "position") == "absolute"))};
	};
	dojo.html.getBorder = function (node) {
		return {width:dojo.html.getBorderExtent(node, "left") + dojo.html.getBorderExtent(node, "right"), height:dojo.html.getBorderExtent(node, "top") + dojo.html.getBorderExtent(node, "bottom")};
	};
	dojo.html.getBorderExtent = function (node, side) {
		return (dojo.html.getStyle(node, "border-" + side + "-style") == "none" ? 0 : dojo.html.getPixelValue(node, "border-" + side + "-width"));
	};
	dojo.html.getMarginExtent = function (node, side) {
		return dojo.html._sumPixelValues(node, ["margin-" + side], dojo.html.isPositionAbsolute(node));
	};
	dojo.html.getPaddingExtent = function (node, side) {
		return dojo.html._sumPixelValues(node, ["padding-" + side], true);
	};
	dojo.html.getPadding = function (node) {
		return {width:dojo.html._sumPixelValues(node, ["padding-left", "padding-right"], true), height:dojo.html._sumPixelValues(node, ["padding-top", "padding-bottom"], true)};
	};
	dojo.html.getPadBorder = function (node) {
		var pad = dojo.html.getPadding(node);
		var border = dojo.html.getBorder(node);
		return {width:pad.width + border.width, height:pad.height + border.height};
	};
	dojo.html.getBoxSizing = function (node) {
		var h = dojo.render.html;
		var bs = dojo.html.boxSizing;
		if (((h.ie) || (h.opera)) && node.nodeName.toLowerCase() != "img") {
			var cm = document["compatMode"];
			if ((cm == "BackCompat") || (cm == "QuirksMode")) {
				return bs.BORDER_BOX;
			} else {
				return bs.CONTENT_BOX;
			}
		} else {
			if (arguments.length == 0) {
				node = document.documentElement;
			}
			var sizing;
			if (!h.ie) {
				sizing = dojo.html.getStyle(node, "-moz-box-sizing");
				if (!sizing) {
					sizing = dojo.html.getStyle(node, "box-sizing");
				}
			}
			return (sizing ? sizing : bs.CONTENT_BOX);
		}
	};
	dojo.html.isBorderBox = function (node) {
		return (dojo.html.getBoxSizing(node) == dojo.html.boxSizing.BORDER_BOX);
	};
	dojo.html.getBorderBox = function (node) {
		node = dojo.byId(node);
		return {width:node.offsetWidth, height:node.offsetHeight};
	};
	dojo.html.getPaddingBox = function (node) {
		var box = dojo.html.getBorderBox(node);
		var border = dojo.html.getBorder(node);
		return {width:box.width - border.width, height:box.height - border.height};
	};
	dojo.html.getContentBox = function (node) {
		node = dojo.byId(node);
		var padborder = dojo.html.getPadBorder(node);
		return {width:node.offsetWidth - padborder.width, height:node.offsetHeight - padborder.height};
	};
	dojo.html.setContentBox = function (node, args) {
		node = dojo.byId(node);
		var width = 0;
		var height = 0;
		var isbb = dojo.html.isBorderBox(node);
		var padborder = (isbb ? dojo.html.getPadBorder(node) : {width:0, height:0});
		var ret = {};
		if (typeof args.width != "undefined") {
			width = args.width + padborder.width;
			ret.width = dojo.html.setPositivePixelValue(node, "width", width);
		}
		if (typeof args.height != "undefined") {
			height = args.height + padborder.height;
			ret.height = dojo.html.setPositivePixelValue(node, "height", height);
		}
		return ret;
	};
	dojo.html.getMarginBox = function (node) {
		var borderbox = dojo.html.getBorderBox(node);
		var margin = dojo.html.getMargin(node);
		return {width:borderbox.width + margin.width, height:borderbox.height + margin.height};
	};
	dojo.html.setMarginBox = function (node, args) {
		node = dojo.byId(node);
		var width = 0;
		var height = 0;
		var isbb = dojo.html.isBorderBox(node);
		var padborder = (!isbb ? dojo.html.getPadBorder(node) : {width:0, height:0});
		var margin = dojo.html.getMargin(node);
		var ret = {};
		if (typeof args.width != "undefined") {
			width = args.width - padborder.width;
			width -= margin.width;
			ret.width = dojo.html.setPositivePixelValue(node, "width", width);
		}
		if (typeof args.height != "undefined") {
			height = args.height - padborder.height;
			height -= margin.height;
			ret.height = dojo.html.setPositivePixelValue(node, "height", height);
		}
		return ret;
	};
	dojo.html.getElementBox = function (node, type) {
		var bs = dojo.html.boxSizing;
		switch (type) {
		  case bs.MARGIN_BOX:
			return dojo.html.getMarginBox(node);
		  case bs.BORDER_BOX:
			return dojo.html.getBorderBox(node);
		  case bs.PADDING_BOX:
			return dojo.html.getPaddingBox(node);
		  case bs.CONTENT_BOX:
		  default:
			return dojo.html.getContentBox(node);
		}
	};
	dojo.html.toCoordinateObject = dojo.html.toCoordinateArray = function (coords, includeScroll, boxtype) {
		if (coords instanceof Array || typeof coords == "array") {
			dojo.deprecated("dojo.html.toCoordinateArray", "use dojo.html.toCoordinateObject({left: , top: , width: , height: }) instead", "0.5");
			while (coords.length < 4) {
				coords.push(0);
			}
			while (coords.length > 4) {
				coords.pop();
			}
			var ret = {left:coords[0], top:coords[1], width:coords[2], height:coords[3]};
		} else {
			if (!coords.nodeType && !(coords instanceof String || typeof coords == "string") && ("width" in coords || "height" in coords || "left" in coords || "x" in coords || "top" in coords || "y" in coords)) {
				var ret = {left:coords.left || coords.x || 0, top:coords.top || coords.y || 0, width:coords.width || 0, height:coords.height || 0};
			} else {
				var node = dojo.byId(coords);
				var pos = dojo.html.abs(node, includeScroll, boxtype);
				var marginbox = dojo.html.getMarginBox(node);
				var ret = {left:pos.left, top:pos.top, width:marginbox.width, height:marginbox.height};
			}
		}
		ret.x = ret.left;
		ret.y = ret.top;
		return ret;
	};
	dojo.html.setMarginBoxWidth = dojo.html.setOuterWidth = function (node, width) {
		return dojo.html._callDeprecated("setMarginBoxWidth", "setMarginBox", arguments, "width");
	};
	dojo.html.setMarginBoxHeight = dojo.html.setOuterHeight = function () {
		return dojo.html._callDeprecated("setMarginBoxHeight", "setMarginBox", arguments, "height");
	};
	dojo.html.getMarginBoxWidth = dojo.html.getOuterWidth = function () {
		return dojo.html._callDeprecated("getMarginBoxWidth", "getMarginBox", arguments, null, "width");
	};
	dojo.html.getMarginBoxHeight = dojo.html.getOuterHeight = function () {
		return dojo.html._callDeprecated("getMarginBoxHeight", "getMarginBox", arguments, null, "height");
	};
	dojo.html.getTotalOffset = function (node, type, includeScroll) {
		return dojo.html._callDeprecated("getTotalOffset", "getAbsolutePosition", arguments, null, type);
	};
	dojo.html.getAbsoluteX = function (node, includeScroll) {
		return dojo.html._callDeprecated("getAbsoluteX", "getAbsolutePosition", arguments, null, "x");
	};
	dojo.html.getAbsoluteY = function (node, includeScroll) {
		return dojo.html._callDeprecated("getAbsoluteY", "getAbsolutePosition", arguments, null, "y");
	};
	dojo.html.totalOffsetLeft = function (node, includeScroll) {
		return dojo.html._callDeprecated("totalOffsetLeft", "getAbsolutePosition", arguments, null, "left");
	};
	dojo.html.totalOffsetTop = function (node, includeScroll) {
		return dojo.html._callDeprecated("totalOffsetTop", "getAbsolutePosition", arguments, null, "top");
	};
	dojo.html.getMarginWidth = function (node) {
		return dojo.html._callDeprecated("getMarginWidth", "getMargin", arguments, null, "width");
	};
	dojo.html.getMarginHeight = function (node) {
		return dojo.html._callDeprecated("getMarginHeight", "getMargin", arguments, null, "height");
	};
	dojo.html.getBorderWidth = function (node) {
		return dojo.html._callDeprecated("getBorderWidth", "getBorder", arguments, null, "width");
	};
	dojo.html.getBorderHeight = function (node) {
		return dojo.html._callDeprecated("getBorderHeight", "getBorder", arguments, null, "height");
	};
	dojo.html.getPaddingWidth = function (node) {
		return dojo.html._callDeprecated("getPaddingWidth", "getPadding", arguments, null, "width");
	};
	dojo.html.getPaddingHeight = function (node) {
		return dojo.html._callDeprecated("getPaddingHeight", "getPadding", arguments, null, "height");
	};
	dojo.html.getPadBorderWidth = function (node) {
		return dojo.html._callDeprecated("getPadBorderWidth", "getPadBorder", arguments, null, "width");
	};
	dojo.html.getPadBorderHeight = function (node) {
		return dojo.html._callDeprecated("getPadBorderHeight", "getPadBorder", arguments, null, "height");
	};
	dojo.html.getBorderBoxWidth = dojo.html.getInnerWidth = function () {
		return dojo.html._callDeprecated("getBorderBoxWidth", "getBorderBox", arguments, null, "width");
	};
	dojo.html.getBorderBoxHeight = dojo.html.getInnerHeight = function () {
		return dojo.html._callDeprecated("getBorderBoxHeight", "getBorderBox", arguments, null, "height");
	};
	dojo.html.getContentBoxWidth = dojo.html.getContentWidth = function () {
		return dojo.html._callDeprecated("getContentBoxWidth", "getContentBox", arguments, null, "width");
	};
	dojo.html.getContentBoxHeight = dojo.html.getContentHeight = function () {
		return dojo.html._callDeprecated("getContentBoxHeight", "getContentBox", arguments, null, "height");
	};
	dojo.html.setContentBoxWidth = dojo.html.setContentWidth = function (node, width) {
		return dojo.html._callDeprecated("setContentBoxWidth", "setContentBox", arguments, "width");
	};
	dojo.html.setContentBoxHeight = dojo.html.setContentHeight = function (node, height) {
		return dojo.html._callDeprecated("setContentBoxHeight", "setContentBox", arguments, "height");
	};
}});


__CPAN_FILE__ src/html/shadow.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.html.shadow"], ["require", "dojo.lfx.shadow"]], definePackage:function (dojo) {
	dojo.provide("dojo.html.shadow");
	dojo.require("dojo.lfx.shadow");
	dojo.deprecated("dojo.html.shadow has been moved to dojo.lfx.", "0.5");
	dojo.html.shadow = dojo.lfx.shadow;
}});


__CPAN_FILE__ src/html/common.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.html.common");
dojo.require("dojo.lang.common");
dojo.require("dojo.dom");
dojo.lang.mixin(dojo.html, dojo.dom);
dojo.html.body = function () {
	dojo.deprecated("dojo.html.body() moved to dojo.body()", "0.5");
	return dojo.body();
};
dojo.html.getEventTarget = function (evt) {
	if (!evt) {
		evt = dojo.global().event || {};
	}
	var t = (evt.srcElement ? evt.srcElement : (evt.target ? evt.target : null));
	while ((t) && (t.nodeType != 1)) {
		t = t.parentNode;
	}
	return t;
};
dojo.html.getViewport = function () {
	var _window = dojo.global();
	var _document = dojo.doc();
	var w = 0;
	var h = 0;
	if (dojo.render.html.mozilla) {
		w = _document.documentElement.clientWidth;
		h = _window.innerHeight;
	} else {
		if (!dojo.render.html.opera && _window.innerWidth) {
			w = _window.innerWidth;
			h = _window.innerHeight;
		} else {
			if (!dojo.render.html.opera && dojo.exists(_document, "documentElement.clientWidth")) {
				var w2 = _document.documentElement.clientWidth;
				if (!w || w2 && w2 < w) {
					w = w2;
				}
				h = _document.documentElement.clientHeight;
			} else {
				if (dojo.body().clientWidth) {
					w = dojo.body().clientWidth;
					h = dojo.body().clientHeight;
				}
			}
		}
	}
	return {width:w, height:h};
};
dojo.html.getScroll = function () {
	var _window = dojo.global();
	var _document = dojo.doc();
	var top = _window.pageYOffset || _document.documentElement.scrollTop || dojo.body().scrollTop || 0;
	var left = _window.pageXOffset || _document.documentElement.scrollLeft || dojo.body().scrollLeft || 0;
	return {top:top, left:left, offset:{x:left, y:top}};
};
dojo.html.getParentByType = function (node, type) {
	var _document = dojo.doc();
	var parent = dojo.byId(node);
	type = type.toLowerCase();
	while ((parent) && (parent.nodeName.toLowerCase() != type)) {
		if (parent == (_document["body"] || _document["documentElement"])) {
			return null;
		}
		parent = parent.parentNode;
	}
	return parent;
};
dojo.html.getAttribute = function (node, attr) {
	node = dojo.byId(node);
	if ((!node) || (!node.getAttribute)) {
		return null;
	}
	var ta = typeof attr == "string" ? attr : new String(attr);
	var v = node.getAttribute(ta.toUpperCase());
	if ((v) && (typeof v == "string") && (v != "")) {
		return v;
	}
	if (v && v.value) {
		return v.value;
	}
	if ((node.getAttributeNode) && (node.getAttributeNode(ta))) {
		return (node.getAttributeNode(ta)).value;
	} else {
		if (node.getAttribute(ta)) {
			return node.getAttribute(ta);
		} else {
			if (node.getAttribute(ta.toLowerCase())) {
				return node.getAttribute(ta.toLowerCase());
			}
		}
	}
	return null;
};
dojo.html.hasAttribute = function (node, attr) {
	return dojo.html.getAttribute(dojo.byId(node), attr) ? true : false;
};
dojo.html.getCursorPosition = function (e) {
	e = e || dojo.global().event;
	var cursor = {x:0, y:0};
	if (e.pageX || e.pageY) {
		cursor.x = e.pageX;
		cursor.y = e.pageY;
	} else {
		var de = dojo.doc().documentElement;
		var db = dojo.body();
		cursor.x = e.clientX + ((de || db)["scrollLeft"]) - ((de || db)["clientLeft"]);
		cursor.y = e.clientY + ((de || db)["scrollTop"]) - ((de || db)["clientTop"]);
	}
	return cursor;
};
dojo.html.isTag = function (node) {
	node = dojo.byId(node);
	if (node && node.tagName) {
		for (var i = 1; i < arguments.length; i++) {
			if (node.tagName.toLowerCase() == String(arguments[i]).toLowerCase()) {
				return String(arguments[i]).toLowerCase();
			}
		}
	}
	return "";
};
if (dojo.render.html.ie && !dojo.render.html.ie70) {
	if (window.location.href.substr(0, 6).toLowerCase() != "https:") {
		(function () {
			var xscript = dojo.doc().createElement("script");
			xscript.src = "javascript:'dojo.html.createExternalElement=function(doc, tag){ return doc.createElement(tag); }'";
			dojo.doc().getElementsByTagName("head")[0].appendChild(xscript);
		})();
	}
} else {
	dojo.html.createExternalElement = function (doc, tag) {
		return doc.createElement(tag);
	};
}
dojo.html._callDeprecated = function (inFunc, replFunc, args, argName, retValue) {
	dojo.deprecated("dojo.html." + inFunc, "replaced by dojo.html." + replFunc + "(" + (argName ? "node, {" + argName + ": " + argName + "}" : "") + ")" + (retValue ? "." + retValue : ""), "0.5");
	var newArgs = [];
	if (argName) {
		var argsIn = {};
		argsIn[argName] = args[1];
		newArgs.push(args[0]);
		newArgs.push(argsIn);
	} else {
		newArgs = args;
	}
	var ret = dojo.html[replFunc].apply(dojo.html, args);
	if (retValue) {
		return ret[retValue];
	} else {
		return ret;
	}
};
dojo.html.getViewportWidth = function () {
	return dojo.html._callDeprecated("getViewportWidth", "getViewport", arguments, null, "width");
};
dojo.html.getViewportHeight = function () {
	return dojo.html._callDeprecated("getViewportHeight", "getViewport", arguments, null, "height");
};
dojo.html.getViewportSize = function () {
	return dojo.html._callDeprecated("getViewportSize", "getViewport", arguments);
};
dojo.html.getScrollTop = function () {
	return dojo.html._callDeprecated("getScrollTop", "getScroll", arguments, null, "top");
};
dojo.html.getScrollLeft = function () {
	return dojo.html._callDeprecated("getScrollLeft", "getScroll", arguments, null, "left");
};
dojo.html.getScrollOffset = function () {
	return dojo.html._callDeprecated("getScrollOffset", "getScroll", arguments, null, "offset");
};


__CPAN_FILE__ src/html/style.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.html.style");
dojo.require("dojo.html.common");
dojo.require("dojo.uri.Uri");
dojo.html.getClass = function (node) {
	node = dojo.byId(node);
	if (!node) {
		return "";
	}
	var cs = "";
	if (node.className) {
		cs = node.className;
	} else {
		if (dojo.html.hasAttribute(node, "class")) {
			cs = dojo.html.getAttribute(node, "class");
		}
	}
	return cs.replace(/^\s+|\s+$/g, "");
};
dojo.html.getClasses = function (node) {
	var c = dojo.html.getClass(node);
	return (c == "") ? [] : c.split(/\s+/g);
};
dojo.html.hasClass = function (node, classname) {
	return (new RegExp("(^|\\s+)" + classname + "(\\s+|$)")).test(dojo.html.getClass(node));
};
dojo.html.prependClass = function (node, classStr) {
	classStr += " " + dojo.html.getClass(node);
	return dojo.html.setClass(node, classStr);
};
dojo.html.addClass = function (node, classStr) {
	if (dojo.html.hasClass(node, classStr)) {
		return false;
	}
	classStr = (dojo.html.getClass(node) + " " + classStr).replace(/^\s+|\s+$/g, "");
	return dojo.html.setClass(node, classStr);
};
dojo.html.setClass = function (node, classStr) {
	node = dojo.byId(node);
	var cs = new String(classStr);
	try {
		if (typeof node.className == "string") {
			node.className = cs;
		} else {
			if (node.setAttribute) {
				node.setAttribute("class", classStr);
				node.className = cs;
			} else {
				return false;
			}
		}
	}
	catch (e) {
		dojo.debug("dojo.html.setClass() failed", e);
	}
	return true;
};
dojo.html.removeClass = function (node, classStr, allowPartialMatches) {
	try {
		if (!allowPartialMatches) {
			var newcs = dojo.html.getClass(node).replace(new RegExp("(^|\\s+)" + classStr + "(\\s+|$)"), "$1$2");
		} else {
			var newcs = dojo.html.getClass(node).replace(classStr, "");
		}
		dojo.html.setClass(node, newcs);
	}
	catch (e) {
		dojo.debug("dojo.html.removeClass() failed", e);
	}
	return true;
};
dojo.html.replaceClass = function (node, newClass, oldClass) {
	dojo.html.removeClass(node, oldClass);
	dojo.html.addClass(node, newClass);
};
dojo.html.classMatchType = {ContainsAll:0, ContainsAny:1, IsOnly:2};
dojo.html.getElementsByClass = function (classStr, parent, nodeType, classMatchType, useNonXpath) {
	useNonXpath = false;
	var _document = dojo.doc();
	parent = dojo.byId(parent) || _document;
	var classes = classStr.split(/\s+/g);
	var nodes = [];
	if (classMatchType != 1 && classMatchType != 2) {
		classMatchType = 0;
	}
	var reClass = new RegExp("(\\s|^)((" + classes.join(")|(") + "))(\\s|$)");
	var srtLength = classes.join(" ").length;
	var candidateNodes = [];
	if (!useNonXpath && _document.evaluate) {
		var xpath = ".//" + (nodeType || "*") + "[contains(";
		if (classMatchType != dojo.html.classMatchType.ContainsAny) {
			xpath += "concat(' ',@class,' '), ' " + classes.join(" ') and contains(concat(' ',@class,' '), ' ") + " ')";
			if (classMatchType == 2) {
				xpath += " and string-length(@class)=" + srtLength + "]";
			} else {
				xpath += "]";
			}
		} else {
			xpath += "concat(' ',@class,' '), ' " + classes.join(" ') or contains(concat(' ',@class,' '), ' ") + " ')]";
		}
		var xpathResult = _document.evaluate(xpath, parent, null, XPathResult.ANY_TYPE, null);
		var result = xpathResult.iterateNext();
		while (result) {
			try {
				candidateNodes.push(result);
				result = xpathResult.iterateNext();
			}
			catch (e) {
				break;
			}
		}
		return candidateNodes;
	} else {
		if (!nodeType) {
			nodeType = "*";
		}
		candidateNodes = parent.getElementsByTagName(nodeType);
		var node, i = 0;
	outer:
		while (node = candidateNodes[i++]) {
			var nodeClasses = dojo.html.getClasses(node);
			if (nodeClasses.length == 0) {
				continue outer;
			}
			var matches = 0;
			for (var j = 0; j < nodeClasses.length; j++) {
				if (reClass.test(nodeClasses[j])) {
					if (classMatchType == dojo.html.classMatchType.ContainsAny) {
						nodes.push(node);
						continue outer;
					} else {
						matches++;
					}
				} else {
					if (classMatchType == dojo.html.classMatchType.IsOnly) {
						continue outer;
					}
				}
			}
			if (matches == classes.length) {
				if ((classMatchType == dojo.html.classMatchType.IsOnly) && (matches == nodeClasses.length)) {
					nodes.push(node);
				} else {
					if (classMatchType == dojo.html.classMatchType.ContainsAll) {
						nodes.push(node);
					}
				}
			}
		}
		return nodes;
	}
};
dojo.html.getElementsByClassName = dojo.html.getElementsByClass;
dojo.html.toCamelCase = function (selector) {
	var arr = selector.split("-"), cc = arr[0];
	for (var i = 1; i < arr.length; i++) {
		cc += arr[i].charAt(0).toUpperCase() + arr[i].substring(1);
	}
	return cc;
};
dojo.html.toSelectorCase = function (selector) {
	return selector.replace(/([A-Z])/g, "-$1").toLowerCase();
};
if (dojo.render.html.ie) {
	dojo.html.getComputedStyle = function (node, property, value) {
		node = dojo.byId(node);
		if (!node || !node.currentStyle) {
			return value;
		}
		return node.currentStyle[dojo.html.toCamelCase(property)];
	};
	dojo.html.getComputedStyles = function (node) {
		return node.currentStyle;
	};
} else {
	dojo.html.getComputedStyle = function (node, property, value) {
		node = dojo.byId(node);
		if (!node || !node.style) {
			return value;
		}
		var s = document.defaultView.getComputedStyle(node, null);
		return (s && s[dojo.html.toCamelCase(property)]) || "";
	};
	dojo.html.getComputedStyles = function (node) {
		return document.defaultView.getComputedStyle(node, null);
	};
}
dojo.html.getStyleProperty = function (node, cssSelector) {
	node = dojo.byId(node);
	return (node && node.style ? node.style[dojo.html.toCamelCase(cssSelector)] : undefined);
};
dojo.html.getStyle = function (node, cssSelector) {
	var value = dojo.html.getStyleProperty(node, cssSelector);
	return (value ? value : dojo.html.getComputedStyle(node, cssSelector));
};
dojo.html.setStyle = function (node, cssSelector, value) {
	node = dojo.byId(node);
	if (node && node.style) {
		var camelCased = dojo.html.toCamelCase(cssSelector);
		node.style[camelCased] = value;
	}
};
dojo.html.setStyleText = function (target, text) {
	try {
		target.style.cssText = text;
	}
	catch (e) {
		target.setAttribute("style", text);
	}
};
dojo.html.copyStyle = function (target, source) {
	if (!source.style.cssText) {
		target.setAttribute("style", source.getAttribute("style"));
	} else {
		target.style.cssText = source.style.cssText;
	}
	dojo.html.addClass(target, dojo.html.getClass(source));
};
dojo.html.getUnitValue = function (node, cssSelector, autoIsZero) {
	var s = dojo.html.getComputedStyle(node, cssSelector);
	if ((!s) || ((s == "auto") && (autoIsZero))) {
		return {value:0, units:"px"};
	}
	var match = s.match(/(\-?[\d.]+)([a-z%]*)/i);
	if (!match) {
		return dojo.html.getUnitValue.bad;
	}
	return {value:Number(match[1]), units:match[2].toLowerCase()};
};
dojo.html.getUnitValue.bad = {value:NaN, units:""};
if (dojo.render.html.ie) {
	dojo.html.toPixelValue = function (element, styleValue) {
		if (!styleValue) {
			return 0;
		}
		if (styleValue.slice(-2) == "px") {
			return parseFloat(styleValue);
		}
		var pixelValue = 0;
		with (element) {
			var sLeft = style.left;
			var rsLeft = runtimeStyle.left;
			runtimeStyle.left = currentStyle.left;
			try {
				style.left = styleValue || 0;
				pixelValue = style.pixelLeft;
				style.left = sLeft;
				runtimeStyle.left = rsLeft;
			}
			catch (e) {
			}
		}
		return pixelValue;
	};
} else {
	dojo.html.toPixelValue = function (element, styleValue) {
		return (styleValue && (styleValue.slice(-2) == "px") ? parseFloat(styleValue) : 0);
	};
}
dojo.html.getPixelValue = function (node, styleProperty, autoIsZero) {
	return dojo.html.toPixelValue(node, dojo.html.getComputedStyle(node, styleProperty));
};
dojo.html.setPositivePixelValue = function (node, selector, value) {
	if (isNaN(value)) {
		return false;
	}
	node.style[selector] = Math.max(0, value) + "px";
	return true;
};
dojo.html.styleSheet = null;
dojo.html.insertCssRule = function (selector, declaration, index) {
	if (!dojo.html.styleSheet) {
		if (document.createStyleSheet) {
			dojo.html.styleSheet = document.createStyleSheet();
		} else {
			if (document.styleSheets[0]) {
				dojo.html.styleSheet = document.styleSheets[0];
			} else {
				return null;
			}
		}
	}
	if (arguments.length < 3) {
		if (dojo.html.styleSheet.cssRules) {
			index = dojo.html.styleSheet.cssRules.length;
		} else {
			if (dojo.html.styleSheet.rules) {
				index = dojo.html.styleSheet.rules.length;
			} else {
				return null;
			}
		}
	}
	if (dojo.html.styleSheet.insertRule) {
		var rule = selector + " { " + declaration + " }";
		return dojo.html.styleSheet.insertRule(rule, index);
	} else {
		if (dojo.html.styleSheet.addRule) {
			return dojo.html.styleSheet.addRule(selector, declaration, index);
		} else {
			return null;
		}
	}
};
dojo.html.removeCssRule = function (index) {
	if (!dojo.html.styleSheet) {
		dojo.debug("no stylesheet defined for removing rules");
		return false;
	}
	if (dojo.render.html.ie) {
		if (!index) {
			index = dojo.html.styleSheet.rules.length;
			dojo.html.styleSheet.removeRule(index);
		}
	} else {
		if (document.styleSheets[0]) {
			if (!index) {
				index = dojo.html.styleSheet.cssRules.length;
			}
			dojo.html.styleSheet.deleteRule(index);
		}
	}
	return true;
};
dojo.html._insertedCssFiles = [];
dojo.html.insertCssFile = function (URI, doc, checkDuplicates, fail_ok) {
	if (!URI) {
		return;
	}
	if (!doc) {
		doc = document;
	}
	var cssStr = dojo.hostenv.getText(URI, false, fail_ok);
	if (cssStr === null) {
		return;
	}
	cssStr = dojo.html.fixPathsInCssText(cssStr, URI);
	if (checkDuplicates) {
		var idx = -1, node, ent = dojo.html._insertedCssFiles;
		for (var i = 0; i < ent.length; i++) {
			if ((ent[i].doc == doc) && (ent[i].cssText == cssStr)) {
				idx = i;
				node = ent[i].nodeRef;
				break;
			}
		}
		if (node) {
			var styles = doc.getElementsByTagName("style");
			for (var i = 0; i < styles.length; i++) {
				if (styles[i] == node) {
					return;
				}
			}
			dojo.html._insertedCssFiles.shift(idx, 1);
		}
	}
	var style = dojo.html.insertCssText(cssStr, doc);
	dojo.html._insertedCssFiles.push({"doc":doc, "cssText":cssStr, "nodeRef":style});
	if (style && djConfig.isDebug) {
		style.setAttribute("dbgHref", URI);
	}
	return style;
};
dojo.html.insertCssText = function (cssStr, doc, URI) {
	if (!cssStr) {
		return;
	}
	if (!doc) {
		doc = document;
	}
	if (URI) {
		cssStr = dojo.html.fixPathsInCssText(cssStr, URI);
	}
	var style = doc.createElement("style");
	style.setAttribute("type", "text/css");
	var head = doc.getElementsByTagName("head")[0];
	if (!head) {
		dojo.debug("No head tag in document, aborting styles");
		return;
	} else {
		head.appendChild(style);
	}
	if (style.styleSheet) {
		var setFunc = function () {
			try {
				style.styleSheet.cssText = cssStr;
			}
			catch (e) {
				dojo.debug(e);
			}
		};
		if (style.styleSheet.disabled) {
			setTimeout(setFunc, 10);
		} else {
			setFunc();
		}
	} else {
		var cssText = doc.createTextNode(cssStr);
		style.appendChild(cssText);
	}
	return style;
};
dojo.html.fixPathsInCssText = function (cssStr, URI) {
	if (!cssStr || !URI) {
		return;
	}
	var match, str = "", url = "", urlChrs = "[\\t\\s\\w\\(\\)\\/\\.\\\\'\"-:#=&?~]+";
	var regex = new RegExp("url\\(\\s*(" + urlChrs + ")\\s*\\)");
	var regexProtocol = /(file|https?|ftps?):\/\//;
	regexTrim = new RegExp("^[\\s]*(['\"]?)(" + urlChrs + ")\\1[\\s]*?$");
	if (dojo.render.html.ie55 || dojo.render.html.ie60) {
		var regexIe = new RegExp("AlphaImageLoader\\((.*)src=['\"](" + urlChrs + ")['\"]");
		while (match = regexIe.exec(cssStr)) {
			url = match[2].replace(regexTrim, "$2");
			if (!regexProtocol.exec(url)) {
				url = (new dojo.uri.Uri(URI, url).toString());
			}
			str += cssStr.substring(0, match.index) + "AlphaImageLoader(" + match[1] + "src='" + url + "'";
			cssStr = cssStr.substr(match.index + match[0].length);
		}
		cssStr = str + cssStr;
		str = "";
	}
	while (match = regex.exec(cssStr)) {
		url = match[1].replace(regexTrim, "$2");
		if (!regexProtocol.exec(url)) {
			url = (new dojo.uri.Uri(URI, url).toString());
		}
		str += cssStr.substring(0, match.index) + "url(" + url + ")";
		cssStr = cssStr.substr(match.index + match[0].length);
	}
	return str + cssStr;
};
dojo.html.setActiveStyleSheet = function (title) {
	var i = 0, a, els = dojo.doc().getElementsByTagName("link");
	while (a = els[i++]) {
		if (a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("title")) {
			a.disabled = true;
			if (a.getAttribute("title") == title) {
				a.disabled = false;
			}
		}
	}
};
dojo.html.getActiveStyleSheet = function () {
	var i = 0, a, els = dojo.doc().getElementsByTagName("link");
	while (a = els[i++]) {
		if (a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("title") && !a.disabled) {
			return a.getAttribute("title");
		}
	}
	return null;
};
dojo.html.getPreferredStyleSheet = function () {
	var i = 0, a, els = dojo.doc().getElementsByTagName("link");
	while (a = els[i++]) {
		if (a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("rel").indexOf("alt") == -1 && a.getAttribute("title")) {
			return a.getAttribute("title");
		}
	}
	return null;
};
dojo.html.applyBrowserClass = function (node) {
	var drh = dojo.render.html;
	var classes = {dj_ie:drh.ie, dj_ie55:drh.ie55, dj_ie6:drh.ie60, dj_ie7:drh.ie70, dj_iequirks:drh.ie && drh.quirks, dj_opera:drh.opera, dj_opera8:drh.opera && (Math.floor(dojo.render.version) == 8), dj_opera9:drh.opera && (Math.floor(dojo.render.version) == 9), dj_khtml:drh.khtml, dj_safari:drh.safari, dj_gecko:drh.mozilla};
	for (var p in classes) {
		if (classes[p]) {
			dojo.html.addClass(node, p);
		}
	}
};


__CPAN_FILE__ src/html/style.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.html.style"], ["require", "dojo.html.common"], ["require", "dojo.uri.Uri"]], definePackage:function (dojo) {
	dojo.provide("dojo.html.style");
	dojo.require("dojo.html.common");
	dojo.require("dojo.uri.Uri");
	dojo.html.getClass = function (node) {
		node = dojo.byId(node);
		if (!node) {
			return "";
		}
		var cs = "";
		if (node.className) {
			cs = node.className;
		} else {
			if (dojo.html.hasAttribute(node, "class")) {
				cs = dojo.html.getAttribute(node, "class");
			}
		}
		return cs.replace(/^\s+|\s+$/g, "");
	};
	dojo.html.getClasses = function (node) {
		var c = dojo.html.getClass(node);
		return (c == "") ? [] : c.split(/\s+/g);
	};
	dojo.html.hasClass = function (node, classname) {
		return (new RegExp("(^|\\s+)" + classname + "(\\s+|$)")).test(dojo.html.getClass(node));
	};
	dojo.html.prependClass = function (node, classStr) {
		classStr += " " + dojo.html.getClass(node);
		return dojo.html.setClass(node, classStr);
	};
	dojo.html.addClass = function (node, classStr) {
		if (dojo.html.hasClass(node, classStr)) {
			return false;
		}
		classStr = (dojo.html.getClass(node) + " " + classStr).replace(/^\s+|\s+$/g, "");
		return dojo.html.setClass(node, classStr);
	};
	dojo.html.setClass = function (node, classStr) {
		node = dojo.byId(node);
		var cs = new String(classStr);
		try {
			if (typeof node.className == "string") {
				node.className = cs;
			} else {
				if (node.setAttribute) {
					node.setAttribute("class", classStr);
					node.className = cs;
				} else {
					return false;
				}
			}
		}
		catch (e) {
			dojo.debug("dojo.html.setClass() failed", e);
		}
		return true;
	};
	dojo.html.removeClass = function (node, classStr, allowPartialMatches) {
		try {
			if (!allowPartialMatches) {
				var newcs = dojo.html.getClass(node).replace(new RegExp("(^|\\s+)" + classStr + "(\\s+|$)"), "$1$2");
			} else {
				var newcs = dojo.html.getClass(node).replace(classStr, "");
			}
			dojo.html.setClass(node, newcs);
		}
		catch (e) {
			dojo.debug("dojo.html.removeClass() failed", e);
		}
		return true;
	};
	dojo.html.replaceClass = function (node, newClass, oldClass) {
		dojo.html.removeClass(node, oldClass);
		dojo.html.addClass(node, newClass);
	};
	dojo.html.classMatchType = {ContainsAll:0, ContainsAny:1, IsOnly:2};
	dojo.html.getElementsByClass = function (classStr, parent, nodeType, classMatchType, useNonXpath) {
		useNonXpath = false;
		var _document = dojo.doc();
		parent = dojo.byId(parent) || _document;
		var classes = classStr.split(/\s+/g);
		var nodes = [];
		if (classMatchType != 1 && classMatchType != 2) {
			classMatchType = 0;
		}
		var reClass = new RegExp("(\\s|^)((" + classes.join(")|(") + "))(\\s|$)");
		var srtLength = classes.join(" ").length;
		var candidateNodes = [];
		if (!useNonXpath && _document.evaluate) {
			var xpath = ".//" + (nodeType || "*") + "[contains(";
			if (classMatchType != dojo.html.classMatchType.ContainsAny) {
				xpath += "concat(' ',@class,' '), ' " + classes.join(" ') and contains(concat(' ',@class,' '), ' ") + " ')";
				if (classMatchType == 2) {
					xpath += " and string-length(@class)=" + srtLength + "]";
				} else {
					xpath += "]";
				}
			} else {
				xpath += "concat(' ',@class,' '), ' " + classes.join(" ') or contains(concat(' ',@class,' '), ' ") + " ')]";
			}
			var xpathResult = _document.evaluate(xpath, parent, null, XPathResult.ANY_TYPE, null);
			var result = xpathResult.iterateNext();
			while (result) {
				try {
					candidateNodes.push(result);
					result = xpathResult.iterateNext();
				}
				catch (e) {
					break;
				}
			}
			return candidateNodes;
		} else {
			if (!nodeType) {
				nodeType = "*";
			}
			candidateNodes = parent.getElementsByTagName(nodeType);
			var node, i = 0;
		outer:
			while (node = candidateNodes[i++]) {
				var nodeClasses = dojo.html.getClasses(node);
				if (nodeClasses.length == 0) {
					continue outer;
				}
				var matches = 0;
				for (var j = 0; j < nodeClasses.length; j++) {
					if (reClass.test(nodeClasses[j])) {
						if (classMatchType == dojo.html.classMatchType.ContainsAny) {
							nodes.push(node);
							continue outer;
						} else {
							matches++;
						}
					} else {
						if (classMatchType == dojo.html.classMatchType.IsOnly) {
							continue outer;
						}
					}
				}
				if (matches == classes.length) {
					if ((classMatchType == dojo.html.classMatchType.IsOnly) && (matches == nodeClasses.length)) {
						nodes.push(node);
					} else {
						if (classMatchType == dojo.html.classMatchType.ContainsAll) {
							nodes.push(node);
						}
					}
				}
			}
			return nodes;
		}
	};
	dojo.html.getElementsByClassName = dojo.html.getElementsByClass;
	dojo.html.toCamelCase = function (selector) {
		var arr = selector.split("-"), cc = arr[0];
		for (var i = 1; i < arr.length; i++) {
			cc += arr[i].charAt(0).toUpperCase() + arr[i].substring(1);
		}
		return cc;
	};
	dojo.html.toSelectorCase = function (selector) {
		return selector.replace(/([A-Z])/g, "-$1").toLowerCase();
	};
	if (dojo.render.html.ie) {
		dojo.html.getComputedStyle = function (node, property, value) {
			node = dojo.byId(node);
			if (!node || !node.currentStyle) {
				return value;
			}
			return node.currentStyle[dojo.html.toCamelCase(property)];
		};
		dojo.html.getComputedStyles = function (node) {
			return node.currentStyle;
		};
	} else {
		dojo.html.getComputedStyle = function (node, property, value) {
			node = dojo.byId(node);
			if (!node || !node.style) {
				return value;
			}
			var s = document.defaultView.getComputedStyle(node, null);
			return (s && s[dojo.html.toCamelCase(property)]) || "";
		};
		dojo.html.getComputedStyles = function (node) {
			return document.defaultView.getComputedStyle(node, null);
		};
	}
	dojo.html.getStyleProperty = function (node, cssSelector) {
		node = dojo.byId(node);
		return (node && node.style ? node.style[dojo.html.toCamelCase(cssSelector)] : undefined);
	};
	dojo.html.getStyle = function (node, cssSelector) {
		var value = dojo.html.getStyleProperty(node, cssSelector);
		return (value ? value : dojo.html.getComputedStyle(node, cssSelector));
	};
	dojo.html.setStyle = function (node, cssSelector, value) {
		node = dojo.byId(node);
		if (node && node.style) {
			var camelCased = dojo.html.toCamelCase(cssSelector);
			node.style[camelCased] = value;
		}
	};
	dojo.html.setStyleText = function (target, text) {
		try {
			target.style.cssText = text;
		}
		catch (e) {
			target.setAttribute("style", text);
		}
	};
	dojo.html.copyStyle = function (target, source) {
		if (!source.style.cssText) {
			target.setAttribute("style", source.getAttribute("style"));
		} else {
			target.style.cssText = source.style.cssText;
		}
		dojo.html.addClass(target, dojo.html.getClass(source));
	};
	dojo.html.getUnitValue = function (node, cssSelector, autoIsZero) {
		var s = dojo.html.getComputedStyle(node, cssSelector);
		if ((!s) || ((s == "auto") && (autoIsZero))) {
			return {value:0, units:"px"};
		}
		var match = s.match(/(\-?[\d.]+)([a-z%]*)/i);
		if (!match) {
			return dojo.html.getUnitValue.bad;
		}
		return {value:Number(match[1]), units:match[2].toLowerCase()};
	};
	dojo.html.getUnitValue.bad = {value:NaN, units:""};
	if (dojo.render.html.ie) {
		dojo.html.toPixelValue = function (element, styleValue) {
			if (!styleValue) {
				return 0;
			}
			if (styleValue.slice(-2) == "px") {
				return parseFloat(styleValue);
			}
			var pixelValue = 0;
			with (element) {
				var sLeft = style.left;
				var rsLeft = runtimeStyle.left;
				runtimeStyle.left = currentStyle.left;
				try {
					style.left = styleValue || 0;
					pixelValue = style.pixelLeft;
					style.left = sLeft;
					runtimeStyle.left = rsLeft;
				}
				catch (e) {
				}
			}
			return pixelValue;
		};
	} else {
		dojo.html.toPixelValue = function (element, styleValue) {
			return (styleValue && (styleValue.slice(-2) == "px") ? parseFloat(styleValue) : 0);
		};
	}
	dojo.html.getPixelValue = function (node, styleProperty, autoIsZero) {
		return dojo.html.toPixelValue(node, dojo.html.getComputedStyle(node, styleProperty));
	};
	dojo.html.setPositivePixelValue = function (node, selector, value) {
		if (isNaN(value)) {
			return false;
		}
		node.style[selector] = Math.max(0, value) + "px";
		return true;
	};
	dojo.html.styleSheet = null;
	dojo.html.insertCssRule = function (selector, declaration, index) {
		if (!dojo.html.styleSheet) {
			if (document.createStyleSheet) {
				dojo.html.styleSheet = document.createStyleSheet();
			} else {
				if (document.styleSheets[0]) {
					dojo.html.styleSheet = document.styleSheets[0];
				} else {
					return null;
				}
			}
		}
		if (arguments.length < 3) {
			if (dojo.html.styleSheet.cssRules) {
				index = dojo.html.styleSheet.cssRules.length;
			} else {
				if (dojo.html.styleSheet.rules) {
					index = dojo.html.styleSheet.rules.length;
				} else {
					return null;
				}
			}
		}
		if (dojo.html.styleSheet.insertRule) {
			var rule = selector + " { " + declaration + " }";
			return dojo.html.styleSheet.insertRule(rule, index);
		} else {
			if (dojo.html.styleSheet.addRule) {
				return dojo.html.styleSheet.addRule(selector, declaration, index);
			} else {
				return null;
			}
		}
	};
	dojo.html.removeCssRule = function (index) {
		if (!dojo.html.styleSheet) {
			dojo.debug("no stylesheet defined for removing rules");
			return false;
		}
		if (dojo.render.html.ie) {
			if (!index) {
				index = dojo.html.styleSheet.rules.length;
				dojo.html.styleSheet.removeRule(index);
			}
		} else {
			if (document.styleSheets[0]) {
				if (!index) {
					index = dojo.html.styleSheet.cssRules.length;
				}
				dojo.html.styleSheet.deleteRule(index);
			}
		}
		return true;
	};
	dojo.html._insertedCssFiles = [];
	dojo.html.insertCssFile = function (URI, doc, checkDuplicates, fail_ok) {
		if (!URI) {
			return;
		}
		if (!doc) {
			doc = document;
		}
		var cssStr = dojo.hostenv.getText(URI, false, fail_ok);
		if (cssStr === null) {
			return;
		}
		cssStr = dojo.html.fixPathsInCssText(cssStr, URI);
		if (checkDuplicates) {
			var idx = -1, node, ent = dojo.html._insertedCssFiles;
			for (var i = 0; i < ent.length; i++) {
				if ((ent[i].doc == doc) && (ent[i].cssText == cssStr)) {
					idx = i;
					node = ent[i].nodeRef;
					break;
				}
			}
			if (node) {
				var styles = doc.getElementsByTagName("style");
				for (var i = 0; i < styles.length; i++) {
					if (styles[i] == node) {
						return;
					}
				}
				dojo.html._insertedCssFiles.shift(idx, 1);
			}
		}
		var style = dojo.html.insertCssText(cssStr, doc);
		dojo.html._insertedCssFiles.push({"doc":doc, "cssText":cssStr, "nodeRef":style});
		if (style && djConfig.isDebug) {
			style.setAttribute("dbgHref", URI);
		}
		return style;
	};
	dojo.html.insertCssText = function (cssStr, doc, URI) {
		if (!cssStr) {
			return;
		}
		if (!doc) {
			doc = document;
		}
		if (URI) {
			cssStr = dojo.html.fixPathsInCssText(cssStr, URI);
		}
		var style = doc.createElement("style");
		style.setAttribute("type", "text/css");
		var head = doc.getElementsByTagName("head")[0];
		if (!head) {
			dojo.debug("No head tag in document, aborting styles");
			return;
		} else {
			head.appendChild(style);
		}
		if (style.styleSheet) {
			var setFunc = function () {
				try {
					style.styleSheet.cssText = cssStr;
				}
				catch (e) {
					dojo.debug(e);
				}
			};
			if (style.styleSheet.disabled) {
				setTimeout(setFunc, 10);
			} else {
				setFunc();
			}
		} else {
			var cssText = doc.createTextNode(cssStr);
			style.appendChild(cssText);
		}
		return style;
	};
	dojo.html.fixPathsInCssText = function (cssStr, URI) {
		if (!cssStr || !URI) {
			return;
		}
		var match, str = "", url = "", urlChrs = "[\\t\\s\\w\\(\\)\\/\\.\\\\'\"-:#=&?~]+";
		var regex = new RegExp("url\\(\\s*(" + urlChrs + ")\\s*\\)");
		var regexProtocol = /(file|https?|ftps?):\/\//;
		regexTrim = new RegExp("^[\\s]*(['\"]?)(" + urlChrs + ")\\1[\\s]*?$");
		if (dojo.render.html.ie55 || dojo.render.html.ie60) {
			var regexIe = new RegExp("AlphaImageLoader\\((.*)src=['\"](" + urlChrs + ")['\"]");
			while (match = regexIe.exec(cssStr)) {
				url = match[2].replace(regexTrim, "$2");
				if (!regexProtocol.exec(url)) {
					url = (new dojo.uri.Uri(URI, url).toString());
				}
				str += cssStr.substring(0, match.index) + "AlphaImageLoader(" + match[1] + "src='" + url + "'";
				cssStr = cssStr.substr(match.index + match[0].length);
			}
			cssStr = str + cssStr;
			str = "";
		}
		while (match = regex.exec(cssStr)) {
			url = match[1].replace(regexTrim, "$2");
			if (!regexProtocol.exec(url)) {
				url = (new dojo.uri.Uri(URI, url).toString());
			}
			str += cssStr.substring(0, match.index) + "url(" + url + ")";
			cssStr = cssStr.substr(match.index + match[0].length);
		}
		return str + cssStr;
	};
	dojo.html.setActiveStyleSheet = function (title) {
		var i = 0, a, els = dojo.doc().getElementsByTagName("link");
		while (a = els[i++]) {
			if (a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("title")) {
				a.disabled = true;
				if (a.getAttribute("title") == title) {
					a.disabled = false;
				}
			}
		}
	};
	dojo.html.getActiveStyleSheet = function () {
		var i = 0, a, els = dojo.doc().getElementsByTagName("link");
		while (a = els[i++]) {
			if (a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("title") && !a.disabled) {
				return a.getAttribute("title");
			}
		}
		return null;
	};
	dojo.html.getPreferredStyleSheet = function () {
		var i = 0, a, els = dojo.doc().getElementsByTagName("link");
		while (a = els[i++]) {
			if (a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("rel").indexOf("alt") == -1 && a.getAttribute("title")) {
				return a.getAttribute("title");
			}
		}
		return null;
	};
	dojo.html.applyBrowserClass = function (node) {
		var drh = dojo.render.html;
		var classes = {dj_ie:drh.ie, dj_ie55:drh.ie55, dj_ie6:drh.ie60, dj_ie7:drh.ie70, dj_iequirks:drh.ie && drh.quirks, dj_opera:drh.opera, dj_opera8:drh.opera && (Math.floor(dojo.render.version) == 8), dj_opera9:drh.opera && (Math.floor(dojo.render.version) == 9), dj_khtml:drh.khtml, dj_safari:drh.safari, dj_gecko:drh.mozilla};
		for (var p in classes) {
			if (classes[p]) {
				dojo.html.addClass(node, p);
			}
		}
	};
}});


__CPAN_FILE__ src/html/color.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.require("dojo.html.style");
dojo.provide("dojo.html.color");
dojo.require("dojo.gfx.color");
dojo.require("dojo.lang.common");
dojo.html.getBackgroundColor = function (node) {
	node = dojo.byId(node);
	var color;
	do {
		color = dojo.html.getStyle(node, "background-color");
		if (color.toLowerCase() == "rgba(0, 0, 0, 0)") {
			color = "transparent";
		}
		if (node == document.getElementsByTagName("body")[0]) {
			node = null;
			break;
		}
		node = node.parentNode;
	} while (node && dojo.lang.inArray(["transparent", ""], color));
	if (color == "transparent") {
		color = [255, 255, 255, 0];
	} else {
		color = dojo.gfx.color.extractRGB(color);
	}
	return color;
};


__CPAN_FILE__ src/html/color.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["require", "dojo.html.style"], ["provide", "dojo.html.color"], ["require", "dojo.gfx.color"], ["require", "dojo.lang.common"]], definePackage:function (dojo) {
	dojo.require("dojo.html.style");
	dojo.provide("dojo.html.color");
	dojo.require("dojo.gfx.color");
	dojo.require("dojo.lang.common");
	dojo.html.getBackgroundColor = function (node) {
		node = dojo.byId(node);
		var color;
		do {
			color = dojo.html.getStyle(node, "background-color");
			if (color.toLowerCase() == "rgba(0, 0, 0, 0)") {
				color = "transparent";
			}
			if (node == document.getElementsByTagName("body")[0]) {
				node = null;
				break;
			}
			node = node.parentNode;
		} while (node && dojo.lang.inArray(["transparent", ""], color));
		if (color == "transparent") {
			color = [255, 255, 255, 0];
		} else {
			color = dojo.gfx.color.extractRGB(color);
		}
		return color;
	};
}});


__CPAN_FILE__ src/html/layout.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.html.layout");
dojo.require("dojo.html.common");
dojo.require("dojo.html.style");
dojo.require("dojo.html.display");
dojo.html.sumAncestorProperties = function (node, prop) {
	node = dojo.byId(node);
	if (!node) {
		return 0;
	}
	var retVal = 0;
	while (node) {
		if (dojo.html.getComputedStyle(node, "position") == "fixed") {
			return 0;
		}
		var val = node[prop];
		if (val) {
			retVal += val - 0;
			if (node == dojo.body()) {
				break;
			}
		}
		node = node.parentNode;
	}
	return retVal;
};
dojo.html.setStyleAttributes = function (node, attributes) {
	node = dojo.byId(node);
	var splittedAttribs = attributes.replace(/(;)?\s*$/, "").split(";");
	for (var i = 0; i < splittedAttribs.length; i++) {
		var nameValue = splittedAttribs[i].split(":");
		var name = nameValue[0].replace(/\s*$/, "").replace(/^\s*/, "").toLowerCase();
		var value = nameValue[1].replace(/\s*$/, "").replace(/^\s*/, "");
		switch (name) {
		  case "opacity":
			dojo.html.setOpacity(node, value);
			break;
		  case "content-height":
			dojo.html.setContentBox(node, {height:value});
			break;
		  case "content-width":
			dojo.html.setContentBox(node, {width:value});
			break;
		  case "outer-height":
			dojo.html.setMarginBox(node, {height:value});
			break;
		  case "outer-width":
			dojo.html.setMarginBox(node, {width:value});
			break;
		  default:
			node.style[dojo.html.toCamelCase(name)] = value;
		}
	}
};
dojo.html.boxSizing = {MARGIN_BOX:"margin-box", BORDER_BOX:"border-box", PADDING_BOX:"padding-box", CONTENT_BOX:"content-box"};
dojo.html.getAbsolutePosition = dojo.html.abs = function (node, includeScroll, boxType) {
	node = dojo.byId(node, node.ownerDocument);
	var ret = {x:0, y:0};
	var bs = dojo.html.boxSizing;
	if (!boxType) {
		boxType = bs.CONTENT_BOX;
	}
	var nativeBoxType = 2;
	var targetBoxType;
	switch (boxType) {
	  case bs.MARGIN_BOX:
		targetBoxType = 3;
		break;
	  case bs.BORDER_BOX:
		targetBoxType = 2;
		break;
	  case bs.PADDING_BOX:
	  default:
		targetBoxType = 1;
		break;
	  case bs.CONTENT_BOX:
		targetBoxType = 0;
		break;
	}
	var h = dojo.render.html;
	var db = document["body"] || document["documentElement"];
	if (h.ie) {
		with (node.getBoundingClientRect()) {
			ret.x = left - 2;
			ret.y = top - 2;
		}
	} else {
		if (document.getBoxObjectFor) {
			nativeBoxType = 1;
			try {
				var bo = document.getBoxObjectFor(node);
				ret.x = bo.x - dojo.html.sumAncestorProperties(node, "scrollLeft");
				ret.y = bo.y - dojo.html.sumAncestorProperties(node, "scrollTop");
			}
			catch (e) {
			}
		} else {
			if (node["offsetParent"]) {
				var endNode;
				if ((h.safari) && (node.style.getPropertyValue("position") == "absolute") && (node.parentNode == db)) {
					endNode = db;
				} else {
					endNode = db.parentNode;
				}
				if (node.parentNode != db) {
					var nd = node;
					if (dojo.render.html.opera) {
						nd = db;
					}
					ret.x -= dojo.html.sumAncestorProperties(nd, "scrollLeft");
					ret.y -= dojo.html.sumAncestorProperties(nd, "scrollTop");
				}
				var curnode = node;
				do {
					var n = curnode["offsetLeft"];
					if (!h.opera || n > 0) {
						ret.x += isNaN(n) ? 0 : n;
					}
					var m = curnode["offsetTop"];
					ret.y += isNaN(m) ? 0 : m;
					curnode = curnode.offsetParent;
				} while ((curnode != endNode) && (curnode != null));
			} else {
				if (node["x"] && node["y"]) {
					ret.x += isNaN(node.x) ? 0 : node.x;
					ret.y += isNaN(node.y) ? 0 : node.y;
				}
			}
		}
	}
	if (includeScroll) {
		var scroll = dojo.html.getScroll();
		ret.y += scroll.top;
		ret.x += scroll.left;
	}
	var extentFuncArray = [dojo.html.getPaddingExtent, dojo.html.getBorderExtent, dojo.html.getMarginExtent];
	if (nativeBoxType > targetBoxType) {
		for (var i = targetBoxType; i < nativeBoxType; ++i) {
			ret.y += extentFuncArray[i](node, "top");
			ret.x += extentFuncArray[i](node, "left");
		}
	} else {
		if (nativeBoxType < targetBoxType) {
			for (var i = targetBoxType; i > nativeBoxType; --i) {
				ret.y -= extentFuncArray[i - 1](node, "top");
				ret.x -= extentFuncArray[i - 1](node, "left");
			}
		}
	}
	ret.top = ret.y;
	ret.left = ret.x;
	return ret;
};
dojo.html.isPositionAbsolute = function (node) {
	return (dojo.html.getComputedStyle(node, "position") == "absolute");
};
dojo.html._sumPixelValues = function (node, selectors, autoIsZero) {
	var total = 0;
	for (var x = 0; x < selectors.length; x++) {
		total += dojo.html.getPixelValue(node, selectors[x], autoIsZero);
	}
	return total;
};
dojo.html.getMargin = function (node) {
	return {width:dojo.html._sumPixelValues(node, ["margin-left", "margin-right"], (dojo.html.getComputedStyle(node, "position") == "absolute")), height:dojo.html._sumPixelValues(node, ["margin-top", "margin-bottom"], (dojo.html.getComputedStyle(node, "position") == "absolute"))};
};
dojo.html.getBorder = function (node) {
	return {width:dojo.html.getBorderExtent(node, "left") + dojo.html.getBorderExtent(node, "right"), height:dojo.html.getBorderExtent(node, "top") + dojo.html.getBorderExtent(node, "bottom")};
};
dojo.html.getBorderExtent = function (node, side) {
	return (dojo.html.getStyle(node, "border-" + side + "-style") == "none" ? 0 : dojo.html.getPixelValue(node, "border-" + side + "-width"));
};
dojo.html.getMarginExtent = function (node, side) {
	return dojo.html._sumPixelValues(node, ["margin-" + side], dojo.html.isPositionAbsolute(node));
};
dojo.html.getPaddingExtent = function (node, side) {
	return dojo.html._sumPixelValues(node, ["padding-" + side], true);
};
dojo.html.getPadding = function (node) {
	return {width:dojo.html._sumPixelValues(node, ["padding-left", "padding-right"], true), height:dojo.html._sumPixelValues(node, ["padding-top", "padding-bottom"], true)};
};
dojo.html.getPadBorder = function (node) {
	var pad = dojo.html.getPadding(node);
	var border = dojo.html.getBorder(node);
	return {width:pad.width + border.width, height:pad.height + border.height};
};
dojo.html.getBoxSizing = function (node) {
	var h = dojo.render.html;
	var bs = dojo.html.boxSizing;
	if (((h.ie) || (h.opera)) && node.nodeName.toLowerCase() != "img") {
		var cm = document["compatMode"];
		if ((cm == "BackCompat") || (cm == "QuirksMode")) {
			return bs.BORDER_BOX;
		} else {
			return bs.CONTENT_BOX;
		}
	} else {
		if (arguments.length == 0) {
			node = document.documentElement;
		}
		var sizing;
		if (!h.ie) {
			sizing = dojo.html.getStyle(node, "-moz-box-sizing");
			if (!sizing) {
				sizing = dojo.html.getStyle(node, "box-sizing");
			}
		}
		return (sizing ? sizing : bs.CONTENT_BOX);
	}
};
dojo.html.isBorderBox = function (node) {
	return (dojo.html.getBoxSizing(node) == dojo.html.boxSizing.BORDER_BOX);
};
dojo.html.getBorderBox = function (node) {
	node = dojo.byId(node);
	return {width:node.offsetWidth, height:node.offsetHeight};
};
dojo.html.getPaddingBox = function (node) {
	var box = dojo.html.getBorderBox(node);
	var border = dojo.html.getBorder(node);
	return {width:box.width - border.width, height:box.height - border.height};
};
dojo.html.getContentBox = function (node) {
	node = dojo.byId(node);
	var padborder = dojo.html.getPadBorder(node);
	return {width:node.offsetWidth - padborder.width, height:node.offsetHeight - padborder.height};
};
dojo.html.setContentBox = function (node, args) {
	node = dojo.byId(node);
	var width = 0;
	var height = 0;
	var isbb = dojo.html.isBorderBox(node);
	var padborder = (isbb ? dojo.html.getPadBorder(node) : {width:0, height:0});
	var ret = {};
	if (typeof args.width != "undefined") {
		width = args.width + padborder.width;
		ret.width = dojo.html.setPositivePixelValue(node, "width", width);
	}
	if (typeof args.height != "undefined") {
		height = args.height + padborder.height;
		ret.height = dojo.html.setPositivePixelValue(node, "height", height);
	}
	return ret;
};
dojo.html.getMarginBox = function (node) {
	var borderbox = dojo.html.getBorderBox(node);
	var margin = dojo.html.getMargin(node);
	return {width:borderbox.width + margin.width, height:borderbox.height + margin.height};
};
dojo.html.setMarginBox = function (node, args) {
	node = dojo.byId(node);
	var width = 0;
	var height = 0;
	var isbb = dojo.html.isBorderBox(node);
	var padborder = (!isbb ? dojo.html.getPadBorder(node) : {width:0, height:0});
	var margin = dojo.html.getMargin(node);
	var ret = {};
	if (typeof args.width != "undefined") {
		width = args.width - padborder.width;
		width -= margin.width;
		ret.width = dojo.html.setPositivePixelValue(node, "width", width);
	}
	if (typeof args.height != "undefined") {
		height = args.height - padborder.height;
		height -= margin.height;
		ret.height = dojo.html.setPositivePixelValue(node, "height", height);
	}
	return ret;
};
dojo.html.getElementBox = function (node, type) {
	var bs = dojo.html.boxSizing;
	switch (type) {
	  case bs.MARGIN_BOX:
		return dojo.html.getMarginBox(node);
	  case bs.BORDER_BOX:
		return dojo.html.getBorderBox(node);
	  case bs.PADDING_BOX:
		return dojo.html.getPaddingBox(node);
	  case bs.CONTENT_BOX:
	  default:
		return dojo.html.getContentBox(node);
	}
};
dojo.html.toCoordinateObject = dojo.html.toCoordinateArray = function (coords, includeScroll, boxtype) {
	if (coords instanceof Array || typeof coords == "array") {
		dojo.deprecated("dojo.html.toCoordinateArray", "use dojo.html.toCoordinateObject({left: , top: , width: , height: }) instead", "0.5");
		while (coords.length < 4) {
			coords.push(0);
		}
		while (coords.length > 4) {
			coords.pop();
		}
		var ret = {left:coords[0], top:coords[1], width:coords[2], height:coords[3]};
	} else {
		if (!coords.nodeType && !(coords instanceof String || typeof coords == "string") && ("width" in coords || "height" in coords || "left" in coords || "x" in coords || "top" in coords || "y" in coords)) {
			var ret = {left:coords.left || coords.x || 0, top:coords.top || coords.y || 0, width:coords.width || 0, height:coords.height || 0};
		} else {
			var node = dojo.byId(coords);
			var pos = dojo.html.abs(node, includeScroll, boxtype);
			var marginbox = dojo.html.getMarginBox(node);
			var ret = {left:pos.left, top:pos.top, width:marginbox.width, height:marginbox.height};
		}
	}
	ret.x = ret.left;
	ret.y = ret.top;
	return ret;
};
dojo.html.setMarginBoxWidth = dojo.html.setOuterWidth = function (node, width) {
	return dojo.html._callDeprecated("setMarginBoxWidth", "setMarginBox", arguments, "width");
};
dojo.html.setMarginBoxHeight = dojo.html.setOuterHeight = function () {
	return dojo.html._callDeprecated("setMarginBoxHeight", "setMarginBox", arguments, "height");
};
dojo.html.getMarginBoxWidth = dojo.html.getOuterWidth = function () {
	return dojo.html._callDeprecated("getMarginBoxWidth", "getMarginBox", arguments, null, "width");
};
dojo.html.getMarginBoxHeight = dojo.html.getOuterHeight = function () {
	return dojo.html._callDeprecated("getMarginBoxHeight", "getMarginBox", arguments, null, "height");
};
dojo.html.getTotalOffset = function (node, type, includeScroll) {
	return dojo.html._callDeprecated("getTotalOffset", "getAbsolutePosition", arguments, null, type);
};
dojo.html.getAbsoluteX = function (node, includeScroll) {
	return dojo.html._callDeprecated("getAbsoluteX", "getAbsolutePosition", arguments, null, "x");
};
dojo.html.getAbsoluteY = function (node, includeScroll) {
	return dojo.html._callDeprecated("getAbsoluteY", "getAbsolutePosition", arguments, null, "y");
};
dojo.html.totalOffsetLeft = function (node, includeScroll) {
	return dojo.html._callDeprecated("totalOffsetLeft", "getAbsolutePosition", arguments, null, "left");
};
dojo.html.totalOffsetTop = function (node, includeScroll) {
	return dojo.html._callDeprecated("totalOffsetTop", "getAbsolutePosition", arguments, null, "top");
};
dojo.html.getMarginWidth = function (node) {
	return dojo.html._callDeprecated("getMarginWidth", "getMargin", arguments, null, "width");
};
dojo.html.getMarginHeight = function (node) {
	return dojo.html._callDeprecated("getMarginHeight", "getMargin", arguments, null, "height");
};
dojo.html.getBorderWidth = function (node) {
	return dojo.html._callDeprecated("getBorderWidth", "getBorder", arguments, null, "width");
};
dojo.html.getBorderHeight = function (node) {
	return dojo.html._callDeprecated("getBorderHeight", "getBorder", arguments, null, "height");
};
dojo.html.getPaddingWidth = function (node) {
	return dojo.html._callDeprecated("getPaddingWidth", "getPadding", arguments, null, "width");
};
dojo.html.getPaddingHeight = function (node) {
	return dojo.html._callDeprecated("getPaddingHeight", "getPadding", arguments, null, "height");
};
dojo.html.getPadBorderWidth = function (node) {
	return dojo.html._callDeprecated("getPadBorderWidth", "getPadBorder", arguments, null, "width");
};
dojo.html.getPadBorderHeight = function (node) {
	return dojo.html._callDeprecated("getPadBorderHeight", "getPadBorder", arguments, null, "height");
};
dojo.html.getBorderBoxWidth = dojo.html.getInnerWidth = function () {
	return dojo.html._callDeprecated("getBorderBoxWidth", "getBorderBox", arguments, null, "width");
};
dojo.html.getBorderBoxHeight = dojo.html.getInnerHeight = function () {
	return dojo.html._callDeprecated("getBorderBoxHeight", "getBorderBox", arguments, null, "height");
};
dojo.html.getContentBoxWidth = dojo.html.getContentWidth = function () {
	return dojo.html._callDeprecated("getContentBoxWidth", "getContentBox", arguments, null, "width");
};
dojo.html.getContentBoxHeight = dojo.html.getContentHeight = function () {
	return dojo.html._callDeprecated("getContentBoxHeight", "getContentBox", arguments, null, "height");
};
dojo.html.setContentBoxWidth = dojo.html.setContentWidth = function (node, width) {
	return dojo.html._callDeprecated("setContentBoxWidth", "setContentBox", arguments, "width");
};
dojo.html.setContentBoxHeight = dojo.html.setContentHeight = function (node, height) {
	return dojo.html._callDeprecated("setContentBoxHeight", "setContentBox", arguments, "height");
};


__CPAN_FILE__ src/html/__package__.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.kwCompoundRequire({common:["dojo.html.common", "dojo.html.style"]});
dojo.provide("dojo.html.*");


__CPAN_FILE__ src/html/metrics.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.html.metrics");
dojo.require("dojo.html.layout");
dojo.html.getScrollbar = function () {
	var scroll = document.createElement("div");
	scroll.style.width = "100px";
	scroll.style.height = "100px";
	scroll.style.overflow = "scroll";
	scroll.style.position = "absolute";
	scroll.style.top = "-300px";
	scroll.style.left = "0px";
	var test = document.createElement("div");
	test.style.width = "400px";
	test.style.height = "400px";
	scroll.appendChild(test);
	dojo.body().appendChild(scroll);
	var width = scroll.offsetWidth - scroll.clientWidth;
	dojo.body().removeChild(scroll);
	scroll.removeChild(test);
	scroll = test = null;
	return {width:width};
};
dojo.html.getFontMeasurements = function () {
	var heights = {"1em":0, "1ex":0, "100%":0, "12pt":0, "16px":0, "xx-small":0, "x-small":0, "small":0, "medium":0, "large":0, "x-large":0, "xx-large":0};
	if (dojo.render.html.ie) {
		document.documentElement.style.fontSize = "100%";
	}
	var div = document.createElement("div");
	div.style.position = "absolute";
	div.style.left = "-100px";
	div.style.top = "0";
	div.style.width = "30px";
	div.style.height = "1000em";
	div.style.border = "0";
	div.style.margin = "0";
	div.style.padding = "0";
	div.style.outline = "0";
	div.style.lineHeight = "1";
	div.style.overflow = "hidden";
	dojo.body().appendChild(div);
	for (var p in heights) {
		div.style.fontSize = p;
		heights[p] = Math.round(div.offsetHeight * 12 / 16) * 16 / 12 / 1000;
	}
	dojo.body().removeChild(div);
	div = null;
	return heights;
};
dojo.html._fontMeasurements = null;
dojo.html.getCachedFontMeasurements = function (recalculate) {
	if (recalculate || !dojo.html._fontMeasurements) {
		dojo.html._fontMeasurements = dojo.html.getFontMeasurements();
	}
	return dojo.html._fontMeasurements;
};
dojo.html.measureFragment = function (node, html, boxType) {
	var clone = node.cloneNode(true);
	clone.innerHTML = html;
	node.parentNode.appendChild(clone);
	var ret = dojo.html.getElementBox(clone, boxType);
	node.parentNode.removeChild(clone);
	clone = null;
	return ret;
};
dojo.html.getFittedFragment = function (node, html) {
	function cl(node) {
		var element = document.createElement(node.tagName);
		element.id = node.id + "-clone";
		element.className = node.className;
		for (var j = 0; j < node.attributes.length; j++) {
			if (node.attributes[j].specified) {
				if (node.attributes[j].nodeName.toLowerCase() != "style" && node.attributes[j].nodeName.toLowerCase() != "edited" && node.attributes[j].nodeName.toLowerCase() != "contenteditable" && node.attributes[j].nodeName.toLowerCase() != "id" && node.attributes[j].nodeName.toLowerCase() != "class") {
					element.setAttribute(node.attributes[j].nodeName.toLowerCase(), node.attributes[j].nodeValue);
				}
			}
		}
		return element;
	}
	var height = dojo.html.getFontMeasurements()["16px"];
	var n = cl(node);
	n.style.width = dojo.html.getBorderBox(node).width + "px";
	n.style.height = (height + 4) + "px";
	node.parentNode.appendChild(n);
	var rem = dojo.html.fitToElement(n, html);
	var ret = n.innerHTML;
	n.parentNode.removeChild(n);
	return ret;
};
dojo.html.fitToElement = function (node, html) {
	function cl(node) {
		var element = document.createElement(node.tagName);
		element.id = node.id + "-clone";
		element.className = node.className;
		for (var j = 0; j < node.attributes.length; j++) {
			if (node.attributes[j].specified) {
				if (node.attributes[j].nodeName.toLowerCase() != "style" && node.attributes[j].nodeName.toLowerCase() != "edited" && node.attributes[j].nodeName.toLowerCase() != "contenteditable" && node.attributes[j].nodeName.toLowerCase() != "id" && node.attributes[j].nodeName.toLowerCase() != "class") {
					element.setAttribute(node.attributes[j].nodeName.toLowerCase(), node.attributes[j].nodeValue);
				}
			}
		}
		return element;
	}
	var clone = cl(node);
	node.parentNode.appendChild(clone);
	var t = dojo.html.getBorderBox(node);
	clone.style.width = t.width + "px";
	var singletons = ["br", "img", "hr", "input", "!--"];
	var chop = ["<BR>", "<br>", "<br/>", "<br />", "<p></p>", "<P></P>"];
	var openTags = [];
	var str = html;
	var i = 0;
	var limit = str.length;
	var add = 0;
	var doLoop = true;
	clone.innerHTML = str;
	while (doLoop) {
		add = Math.round((limit - i) / 2);
		if (add <= 1) {
			doLoop = false;
		}
		i += add;
		clone.innerHTML = str.substr(0, i);
		if (clone.offsetHeight > t.height) {
			limit = i;
			i -= add;
		}
	}
	if (str.substr(0, i) != str) {
		var lastSpace = str.substr(0, i).lastIndexOf(" ");
		var lastNewLine = str.substr(0, i).lastIndexOf("\n");
		var lastGreater = str.substr(0, i).lastIndexOf(">");
		var lastLess = str.substr(0, i).lastIndexOf("<");
		if (lastLess <= lastGreater && lastNewLine == i - 1) {
			i = i;
		} else {
			if (lastSpace != -1 && lastSpace > lastGreater && lastGreater > lastLess) {
				i = lastSpace + 1;
			} else {
				if (lastLess > lastGreater) {
					i = lastLess;
				} else {
					if (lastGreater != -1) {
						i = lastGreater + 1;
					}
				}
			}
		}
	}
	str = str.substr(0, i);
	var ret = html.substr(str.length);
	var doPush = true;
	var tags = str.split("<");
	tags.shift();
	for (var j = 0; j < tags.length; j++) {
		tags[j] = tags[j].split(">")[0];
		if (tags[j].charAt(tags[j].length - 1) == "/") {
			continue;
		}
		if (tags[j].charAt(0) != "/") {
			for (var k = 0; k < singletons.length; k++) {
				if (tags[j].split(" ")[0].toLowerCase() == singletons[k]) {
					doPush = false;
				}
			}
			if (doPush) {
				openTags.push(tags[j]);
			}
			doPush = true;
		} else {
			openTags.pop();
		}
	}
	for (var j = 0; j < chop.length; j++) {
		if (ret.charAt(0) == "\n") {
			ret = ret.substr(1);
		}
		while (ret.indexOf(chop[j]) == 0) {
			ret = ret.substr(chop[j].length);
		}
	}
	for (var j = openTags.length - 1; j >= 0; j--) {
		if (str.lastIndexOf(openTags[j]) == (str.length - openTags[j].length - 1)) {
			str = str.substring(0, str.lastIndexOf(openTags[j]));
		} else {
			str += "</" + openTags[j] + ">";
		}
		if (ret.length > 0) {
			ret = "<" + openTags[j] + ">" + ret;
		}
	}
	for (var j = 0; j < chop.length; j++) {
		if (ret.charAt(0) == "\n") {
			ret = ret.substr(1);
		}
		while (ret.indexOf(chop[j]) == 0) {
			ret = ret.substr(chop[j].length);
		}
	}
	node.innerHTML = str;
	clone.parentNode.removeChild(clone);
	clone = null;
	return ret;
};


__CPAN_FILE__ src/html/selection.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.require("dojo.html.common");
dojo.provide("dojo.html.selection");
dojo.require("dojo.dom");
dojo.require("dojo.lang.common");
dojo.html.selectionType = {NONE:0, TEXT:1, CONTROL:2};
dojo.html.clearSelection = function () {
	var _window = dojo.global();
	var _document = dojo.doc();
	try {
		if (_window["getSelection"]) {
			if (dojo.render.html.safari) {
				_window.getSelection().collapse();
			} else {
				_window.getSelection().removeAllRanges();
			}
		} else {
			if (_document.selection) {
				if (_document.selection.empty) {
					_document.selection.empty();
				} else {
					if (_document.selection.clear) {
						_document.selection.clear();
					}
				}
			}
		}
		return true;
	}
	catch (e) {
		dojo.debug(e);
		return false;
	}
};
dojo.html.disableSelection = function (element) {
	element = dojo.byId(element) || dojo.body();
	var h = dojo.render.html;
	if (h.mozilla) {
		element.style.MozUserSelect = "none";
	} else {
		if (h.safari) {
			element.style.KhtmlUserSelect = "none";
		} else {
			if (h.ie) {
				element.unselectable = "on";
			} else {
				return false;
			}
		}
	}
	return true;
};
dojo.html.enableSelection = function (element) {
	element = dojo.byId(element) || dojo.body();
	var h = dojo.render.html;
	if (h.mozilla) {
		element.style.MozUserSelect = "";
	} else {
		if (h.safari) {
			element.style.KhtmlUserSelect = "";
		} else {
			if (h.ie) {
				element.unselectable = "off";
			} else {
				return false;
			}
		}
	}
	return true;
};
dojo.html.selectElement = function (element) {
	dojo.deprecated("dojo.html.selectElement", "replaced by dojo.html.selection.selectElementChildren", 0.5);
};
dojo.html.selectInputText = function (element) {
	var _window = dojo.global();
	var _document = dojo.doc();
	element = dojo.byId(element);
	if (_document["selection"] && dojo.body()["createTextRange"]) {
		var range = element.createTextRange();
		range.moveStart("character", 0);
		range.moveEnd("character", element.value.length);
		range.select();
	} else {
		if (_window["getSelection"]) {
			var selection = _window.getSelection();
			element.setSelectionRange(0, element.value.length);
		}
	}
	element.focus();
};
dojo.html.isSelectionCollapsed = function () {
	dojo.deprecated("dojo.html.isSelectionCollapsed", "replaced by dojo.html.selection.isCollapsed", 0.5);
	return dojo.html.selection.isCollapsed();
};
dojo.lang.mixin(dojo.html.selection, {getType:function () {
	if (dojo.doc()["selection"]) {
		return dojo.html.selectionType[dojo.doc().selection.type.toUpperCase()];
	} else {
		var stype = dojo.html.selectionType.TEXT;
		var oSel;
		try {
			oSel = dojo.global().getSelection();
		}
		catch (e) {
		}
		if (oSel && oSel.rangeCount == 1) {
			var oRange = oSel.getRangeAt(0);
			if (oRange.startContainer == oRange.endContainer && (oRange.endOffset - oRange.startOffset) == 1 && oRange.startContainer.nodeType != dojo.dom.TEXT_NODE) {
				stype = dojo.html.selectionType.CONTROL;
			}
		}
		return stype;
	}
}, isCollapsed:function () {
	var _window = dojo.global();
	var _document = dojo.doc();
	if (_document["selection"]) {
		return _document.selection.createRange().text == "";
	} else {
		if (_window["getSelection"]) {
			var selection = _window.getSelection();
			if (dojo.lang.isString(selection)) {
				return selection == "";
			} else {
				return selection.isCollapsed || selection.toString() == "";
			}
		}
	}
}, getSelectedElement:function () {
	if (dojo.html.selection.getType() == dojo.html.selectionType.CONTROL) {
		if (dojo.doc()["selection"]) {
			var range = dojo.doc().selection.createRange();
			if (range && range.item) {
				return dojo.doc().selection.createRange().item(0);
			}
		} else {
			var selection = dojo.global().getSelection();
			return selection.anchorNode.childNodes[selection.anchorOffset];
		}
	}
}, getParentElement:function () {
	if (dojo.html.selection.getType() == dojo.html.selectionType.CONTROL) {
		var p = dojo.html.selection.getSelectedElement();
		if (p) {
			return p.parentNode;
		}
	} else {
		if (dojo.doc()["selection"]) {
			return dojo.doc().selection.createRange().parentElement();
		} else {
			var selection = dojo.global().getSelection();
			if (selection) {
				var node = selection.anchorNode;
				while (node && node.nodeType != dojo.dom.ELEMENT_NODE) {
					node = node.parentNode;
				}
				return node;
			}
		}
	}
}, getSelectedText:function () {
	if (dojo.doc()["selection"]) {
		if (dojo.html.selection.getType() == dojo.html.selectionType.CONTROL) {
			return null;
		}
		return dojo.doc().selection.createRange().text;
	} else {
		var selection = dojo.global().getSelection();
		if (selection) {
			return selection.toString();
		}
	}
}, getSelectedHtml:function () {
	if (dojo.doc()["selection"]) {
		if (dojo.html.selection.getType() == dojo.html.selectionType.CONTROL) {
			return null;
		}
		return dojo.doc().selection.createRange().htmlText;
	} else {
		var selection = dojo.global().getSelection();
		if (selection && selection.rangeCount) {
			var frag = selection.getRangeAt(0).cloneContents();
			var div = document.createElement("div");
			div.appendChild(frag);
			return div.innerHTML;
		}
		return null;
	}
}, hasAncestorElement:function (tagName) {
	return (dojo.html.selection.getAncestorElement.apply(this, arguments) != null);
}, getAncestorElement:function (tagName) {
	var node = dojo.html.selection.getSelectedElement() || dojo.html.selection.getParentElement();
	while (node) {
		if (dojo.html.selection.isTag(node, arguments).length > 0) {
			return node;
		}
		node = node.parentNode;
	}
	return null;
}, isTag:function (node, tags) {
	if (node && node.tagName) {
		for (var i = 0; i < tags.length; i++) {
			if (node.tagName.toLowerCase() == String(tags[i]).toLowerCase()) {
				return String(tags[i]).toLowerCase();
			}
		}
	}
	return "";
}, selectElement:function (element) {
	var _window = dojo.global();
	var _document = dojo.doc();
	element = dojo.byId(element);
	if (_document.selection && dojo.body().createTextRange) {
		try {
			var range = dojo.body().createControlRange();
			range.addElement(element);
			range.select();
		}
		catch (e) {
			dojo.html.selection.selectElementChildren(element);
		}
	} else {
		if (_window["getSelection"]) {
			var selection = _window.getSelection();
			if (selection["removeAllRanges"]) {
				var range = _document.createRange();
				range.selectNode(element);
				selection.removeAllRanges();
				selection.addRange(range);
			}
		}
	}
}, selectElementChildren:function (element) {
	var _window = dojo.global();
	var _document = dojo.doc();
	element = dojo.byId(element);
	if (_document.selection && dojo.body().createTextRange) {
		var range = dojo.body().createTextRange();
		range.moveToElementText(element);
		range.select();
	} else {
		if (_window["getSelection"]) {
			var selection = _window.getSelection();
			if (selection["setBaseAndExtent"]) {
				selection.setBaseAndExtent(element, 0, element, element.innerText.length - 1);
			} else {
				if (selection["selectAllChildren"]) {
					selection.selectAllChildren(element);
				}
			}
		}
	}
}, getBookmark:function () {
	var bookmark;
	var _document = dojo.doc();
	if (_document["selection"]) {
		var range = _document.selection.createRange();
		bookmark = range.getBookmark();
	} else {
		var selection;
		try {
			selection = dojo.global().getSelection();
		}
		catch (e) {
		}
		if (selection) {
			var range = selection.getRangeAt(0);
			bookmark = range.cloneRange();
		} else {
			dojo.debug("No idea how to store the current selection for this browser!");
		}
	}
	return bookmark;
}, moveToBookmark:function (bookmark) {
	var _document = dojo.doc();
	if (_document["selection"]) {
		var range = _document.selection.createRange();
		range.moveToBookmark(bookmark);
		range.select();
	} else {
		var selection;
		try {
			selection = dojo.global().getSelection();
		}
		catch (e) {
		}
		if (selection && selection["removeAllRanges"]) {
			selection.removeAllRanges();
			selection.addRange(bookmark);
		} else {
			dojo.debug("No idea how to restore selection for this browser!");
		}
	}
}, collapse:function (beginning) {
	if (dojo.global()["getSelection"]) {
		var selection = dojo.global().getSelection();
		if (selection.removeAllRanges) {
			if (beginning) {
				selection.collapseToStart();
			} else {
				selection.collapseToEnd();
			}
		} else {
			dojo.global().getSelection().collapse(beginning);
		}
	} else {
		if (dojo.doc().selection) {
			var range = dojo.doc().selection.createRange();
			range.collapse(beginning);
			range.select();
		}
	}
}, remove:function () {
	if (dojo.doc().selection) {
		var selection = dojo.doc().selection;
		if (selection.type.toUpperCase() != "NONE") {
			selection.clear();
		}
		return selection;
	} else {
		var selection = dojo.global().getSelection();
		for (var i = 0; i < selection.rangeCount; i++) {
			selection.getRangeAt(i).deleteContents();
		}
		return selection;
	}
}});


__CPAN_FILE__ src/html/iframe.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.html.iframe"], ["require", "dojo.html.util"]], definePackage:function (dojo) {
	dojo.provide("dojo.html.iframe");
	dojo.require("dojo.html.util");
	dojo.html.iframeContentWindow = function (iframe_el) {
		var win = dojo.html.getDocumentWindow(dojo.html.iframeContentDocument(iframe_el)) || dojo.html.iframeContentDocument(iframe_el).__parent__ || (iframe_el.name && document.frames[iframe_el.name]) || null;
		return win;
	};
	dojo.html.iframeContentDocument = function (iframe_el) {
		var doc = iframe_el.contentDocument || ((iframe_el.contentWindow) && (iframe_el.contentWindow.document)) || ((iframe_el.name) && (document.frames[iframe_el.name]) && (document.frames[iframe_el.name].document)) || null;
		return doc;
	};
	dojo.html.BackgroundIframe = function (node) {
		if (dojo.render.html.ie55 || dojo.render.html.ie60) {
			var html = "<iframe src='javascript:false'" + " style='position: absolute; left: 0px; top: 0px; width: 100%; height: 100%;" + "z-index: -1; filter:Alpha(Opacity=\"0\");' " + ">";
			this.iframe = dojo.doc().createElement(html);
			this.iframe.tabIndex = -1;
			if (node) {
				node.appendChild(this.iframe);
				this.domNode = node;
			} else {
				dojo.body().appendChild(this.iframe);
				this.iframe.style.display = "none";
			}
		}
	};
	dojo.lang.extend(dojo.html.BackgroundIframe, {iframe:null, onResized:function () {
		if (this.iframe && this.domNode && this.domNode.parentNode) {
			var outer = dojo.html.getMarginBox(this.domNode);
			if (outer.width == 0 || outer.height == 0) {
				dojo.lang.setTimeout(this, this.onResized, 100);
				return;
			}
			this.iframe.style.width = outer.width + "px";
			this.iframe.style.height = outer.height + "px";
		}
	}, size:function (node) {
		if (!this.iframe) {
			return;
		}
		var coords = dojo.html.toCoordinateObject(node, true, dojo.html.boxSizing.BORDER_BOX);
		with (this.iframe.style) {
			width = coords.width + "px";
			height = coords.height + "px";
			left = coords.left + "px";
			top = coords.top + "px";
		}
	}, setZIndex:function (node) {
		if (!this.iframe) {
			return;
		}
		if (dojo.dom.isNode(node)) {
			this.iframe.style.zIndex = dojo.html.getStyle(node, "z-index") - 1;
		} else {
			if (!isNaN(node)) {
				this.iframe.style.zIndex = node;
			}
		}
	}, show:function () {
		if (this.iframe) {
			this.iframe.style.display = "block";
		}
	}, hide:function () {
		if (this.iframe) {
			this.iframe.style.display = "none";
		}
	}, remove:function () {
		if (this.iframe) {
			dojo.html.removeNode(this.iframe, true);
			delete this.iframe;
			this.iframe = null;
		}
	}});
}});


__CPAN_FILE__ src/html/metrics.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.html.metrics"], ["require", "dojo.html.layout"]], definePackage:function (dojo) {
	dojo.provide("dojo.html.metrics");
	dojo.require("dojo.html.layout");
	dojo.html.getScrollbar = function () {
		var scroll = document.createElement("div");
		scroll.style.width = "100px";
		scroll.style.height = "100px";
		scroll.style.overflow = "scroll";
		scroll.style.position = "absolute";
		scroll.style.top = "-300px";
		scroll.style.left = "0px";
		var test = document.createElement("div");
		test.style.width = "400px";
		test.style.height = "400px";
		scroll.appendChild(test);
		dojo.body().appendChild(scroll);
		var width = scroll.offsetWidth - scroll.clientWidth;
		dojo.body().removeChild(scroll);
		scroll.removeChild(test);
		scroll = test = null;
		return {width:width};
	};
	dojo.html.getFontMeasurements = function () {
		var heights = {"1em":0, "1ex":0, "100%":0, "12pt":0, "16px":0, "xx-small":0, "x-small":0, "small":0, "medium":0, "large":0, "x-large":0, "xx-large":0};
		if (dojo.render.html.ie) {
			document.documentElement.style.fontSize = "100%";
		}
		var div = document.createElement("div");
		div.style.position = "absolute";
		div.style.left = "-100px";
		div.style.top = "0";
		div.style.width = "30px";
		div.style.height = "1000em";
		div.style.border = "0";
		div.style.margin = "0";
		div.style.padding = "0";
		div.style.outline = "0";
		div.style.lineHeight = "1";
		div.style.overflow = "hidden";
		dojo.body().appendChild(div);
		for (var p in heights) {
			div.style.fontSize = p;
			heights[p] = Math.round(div.offsetHeight * 12 / 16) * 16 / 12 / 1000;
		}
		dojo.body().removeChild(div);
		div = null;
		return heights;
	};
	dojo.html._fontMeasurements = null;
	dojo.html.getCachedFontMeasurements = function (recalculate) {
		if (recalculate || !dojo.html._fontMeasurements) {
			dojo.html._fontMeasurements = dojo.html.getFontMeasurements();
		}
		return dojo.html._fontMeasurements;
	};
	dojo.html.measureFragment = function (node, html, boxType) {
		var clone = node.cloneNode(true);
		clone.innerHTML = html;
		node.parentNode.appendChild(clone);
		var ret = dojo.html.getElementBox(clone, boxType);
		node.parentNode.removeChild(clone);
		clone = null;
		return ret;
	};
	dojo.html.getFittedFragment = function (node, html) {
		function cl(node) {
			var element = document.createElement(node.tagName);
			element.id = node.id + "-clone";
			element.className = node.className;
			for (var j = 0; j < node.attributes.length; j++) {
				if (node.attributes[j].specified) {
					if (node.attributes[j].nodeName.toLowerCase() != "style" && node.attributes[j].nodeName.toLowerCase() != "edited" && node.attributes[j].nodeName.toLowerCase() != "contenteditable" && node.attributes[j].nodeName.toLowerCase() != "id" && node.attributes[j].nodeName.toLowerCase() != "class") {
						element.setAttribute(node.attributes[j].nodeName.toLowerCase(), node.attributes[j].nodeValue);
					}
				}
			}
			return element;
		}
		var height = dojo.html.getFontMeasurements()["16px"];
		var n = cl(node);
		n.style.width = dojo.html.getBorderBox(node).width + "px";
		n.style.height = (height + 4) + "px";
		node.parentNode.appendChild(n);
		var rem = dojo.html.fitToElement(n, html);
		var ret = n.innerHTML;
		n.parentNode.removeChild(n);
		return ret;
	};
	dojo.html.fitToElement = function (node, html) {
		function cl(node) {
			var element = document.createElement(node.tagName);
			element.id = node.id + "-clone";
			element.className = node.className;
			for (var j = 0; j < node.attributes.length; j++) {
				if (node.attributes[j].specified) {
					if (node.attributes[j].nodeName.toLowerCase() != "style" && node.attributes[j].nodeName.toLowerCase() != "edited" && node.attributes[j].nodeName.toLowerCase() != "contenteditable" && node.attributes[j].nodeName.toLowerCase() != "id" && node.attributes[j].nodeName.toLowerCase() != "class") {
						element.setAttribute(node.attributes[j].nodeName.toLowerCase(), node.attributes[j].nodeValue);
					}
				}
			}
			return element;
		}
		var clone = cl(node);
		node.parentNode.appendChild(clone);
		var t = dojo.html.getBorderBox(node);
		clone.style.width = t.width + "px";
		var singletons = ["br", "img", "hr", "input", "!--"];
		var chop = ["<BR>", "<br>", "<br/>", "<br />", "<p></p>", "<P></P>"];
		var openTags = [];
		var str = html;
		var i = 0;
		var limit = str.length;
		var add = 0;
		var doLoop = true;
		clone.innerHTML = str;
		while (doLoop) {
			add = Math.round((limit - i) / 2);
			if (add <= 1) {
				doLoop = false;
			}
			i += add;
			clone.innerHTML = str.substr(0, i);
			if (clone.offsetHeight > t.height) {
				limit = i;
				i -= add;
			}
		}
		if (str.substr(0, i) != str) {
			var lastSpace = str.substr(0, i).lastIndexOf(" ");
			var lastNewLine = str.substr(0, i).lastIndexOf("\n");
			var lastGreater = str.substr(0, i).lastIndexOf(">");
			var lastLess = str.substr(0, i).lastIndexOf("<");
			if (lastLess <= lastGreater && lastNewLine == i - 1) {
				i = i;
			} else {
				if (lastSpace != -1 && lastSpace > lastGreater && lastGreater > lastLess) {
					i = lastSpace + 1;
				} else {
					if (lastLess > lastGreater) {
						i = lastLess;
					} else {
						if (lastGreater != -1) {
							i = lastGreater + 1;
						}
					}
				}
			}
		}
		str = str.substr(0, i);
		var ret = html.substr(str.length);
		var doPush = true;
		var tags = str.split("<");
		tags.shift();
		for (var j = 0; j < tags.length; j++) {
			tags[j] = tags[j].split(">")[0];
			if (tags[j].charAt(tags[j].length - 1) == "/") {
				continue;
			}
			if (tags[j].charAt(0) != "/") {
				for (var k = 0; k < singletons.length; k++) {
					if (tags[j].split(" ")[0].toLowerCase() == singletons[k]) {
						doPush = false;
					}
				}
				if (doPush) {
					openTags.push(tags[j]);
				}
				doPush = true;
			} else {
				openTags.pop();
			}
		}
		for (var j = 0; j < chop.length; j++) {
			if (ret.charAt(0) == "\n") {
				ret = ret.substr(1);
			}
			while (ret.indexOf(chop[j]) == 0) {
				ret = ret.substr(chop[j].length);
			}
		}
		for (var j = openTags.length - 1; j >= 0; j--) {
			if (str.lastIndexOf(openTags[j]) == (str.length - openTags[j].length - 1)) {
				str = str.substring(0, str.lastIndexOf(openTags[j]));
			} else {
				str += "</" + openTags[j] + ">";
			}
			if (ret.length > 0) {
				ret = "<" + openTags[j] + ">" + ret;
			}
		}
		for (var j = 0; j < chop.length; j++) {
			if (ret.charAt(0) == "\n") {
				ret = ret.substr(1);
			}
			while (ret.indexOf(chop[j]) == 0) {
				ret = ret.substr(chop[j].length);
			}
		}
		node.innerHTML = str;
		clone.parentNode.removeChild(clone);
		clone = null;
		return ret;
	};
}});


__CPAN_FILE__ src/html/__package__.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["kwCompoundRequire", {common:["dojo.html.common", "dojo.html.style"]}], ["provide", "dojo.html.*"]], definePackage:function (dojo) {
	dojo.kwCompoundRequire({common:["dojo.html.common", "dojo.html.style"]});
	dojo.provide("dojo.html.*");
}});


__CPAN_FILE__ src/html/common.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.html.common"], ["require", "dojo.lang.common"], ["require", "dojo.dom"]], definePackage:function (dojo) {
	dojo.provide("dojo.html.common");
	dojo.require("dojo.lang.common");
	dojo.require("dojo.dom");
	dojo.lang.mixin(dojo.html, dojo.dom);
	dojo.html.body = function () {
		dojo.deprecated("dojo.html.body() moved to dojo.body()", "0.5");
		return dojo.body();
	};
	dojo.html.getEventTarget = function (evt) {
		if (!evt) {
			evt = dojo.global().event || {};
		}
		var t = (evt.srcElement ? evt.srcElement : (evt.target ? evt.target : null));
		while ((t) && (t.nodeType != 1)) {
			t = t.parentNode;
		}
		return t;
	};
	dojo.html.getViewport = function () {
		var _window = dojo.global();
		var _document = dojo.doc();
		var w = 0;
		var h = 0;
		if (dojo.render.html.mozilla) {
			w = _document.documentElement.clientWidth;
			h = _window.innerHeight;
		} else {
			if (!dojo.render.html.opera && _window.innerWidth) {
				w = _window.innerWidth;
				h = _window.innerHeight;
			} else {
				if (!dojo.render.html.opera && dojo.exists(_document, "documentElement.clientWidth")) {
					var w2 = _document.documentElement.clientWidth;
					if (!w || w2 && w2 < w) {
						w = w2;
					}
					h = _document.documentElement.clientHeight;
				} else {
					if (dojo.body().clientWidth) {
						w = dojo.body().clientWidth;
						h = dojo.body().clientHeight;
					}
				}
			}
		}
		return {width:w, height:h};
	};
	dojo.html.getScroll = function () {
		var _window = dojo.global();
		var _document = dojo.doc();
		var top = _window.pageYOffset || _document.documentElement.scrollTop || dojo.body().scrollTop || 0;
		var left = _window.pageXOffset || _document.documentElement.scrollLeft || dojo.body().scrollLeft || 0;
		return {top:top, left:left, offset:{x:left, y:top}};
	};
	dojo.html.getParentByType = function (node, type) {
		var _document = dojo.doc();
		var parent = dojo.byId(node);
		type = type.toLowerCase();
		while ((parent) && (parent.nodeName.toLowerCase() != type)) {
			if (parent == (_document["body"] || _document["documentElement"])) {
				return null;
			}
			parent = parent.parentNode;
		}
		return parent;
	};
	dojo.html.getAttribute = function (node, attr) {
		node = dojo.byId(node);
		if ((!node) || (!node.getAttribute)) {
			return null;
		}
		var ta = typeof attr == "string" ? attr : new String(attr);
		var v = node.getAttribute(ta.toUpperCase());
		if ((v) && (typeof v == "string") && (v != "")) {
			return v;
		}
		if (v && v.value) {
			return v.value;
		}
		if ((node.getAttributeNode) && (node.getAttributeNode(ta))) {
			return (node.getAttributeNode(ta)).value;
		} else {
			if (node.getAttribute(ta)) {
				return node.getAttribute(ta);
			} else {
				if (node.getAttribute(ta.toLowerCase())) {
					return node.getAttribute(ta.toLowerCase());
				}
			}
		}
		return null;
	};
	dojo.html.hasAttribute = function (node, attr) {
		return dojo.html.getAttribute(dojo.byId(node), attr) ? true : false;
	};
	dojo.html.getCursorPosition = function (e) {
		e = e || dojo.global().event;
		var cursor = {x:0, y:0};
		if (e.pageX || e.pageY) {
			cursor.x = e.pageX;
			cursor.y = e.pageY;
		} else {
			var de = dojo.doc().documentElement;
			var db = dojo.body();
			cursor.x = e.clientX + ((de || db)["scrollLeft"]) - ((de || db)["clientLeft"]);
			cursor.y = e.clientY + ((de || db)["scrollTop"]) - ((de || db)["clientTop"]);
		}
		return cursor;
	};
	dojo.html.isTag = function (node) {
		node = dojo.byId(node);
		if (node && node.tagName) {
			for (var i = 1; i < arguments.length; i++) {
				if (node.tagName.toLowerCase() == String(arguments[i]).toLowerCase()) {
					return String(arguments[i]).toLowerCase();
				}
			}
		}
		return "";
	};
	if (dojo.render.html.ie && !dojo.render.html.ie70) {
		if (window.location.href.substr(0, 6).toLowerCase() != "https:") {
			(function () {
				var xscript = dojo.doc().createElement("script");
				xscript.src = "javascript:'dojo.html.createExternalElement=function(doc, tag){ return doc.createElement(tag); }'";
				dojo.doc().getElementsByTagName("head")[0].appendChild(xscript);
			})();
		}
	} else {
		dojo.html.createExternalElement = function (doc, tag) {
			return doc.createElement(tag);
		};
	}
	dojo.html._callDeprecated = function (inFunc, replFunc, args, argName, retValue) {
		dojo.deprecated("dojo.html." + inFunc, "replaced by dojo.html." + replFunc + "(" + (argName ? "node, {" + argName + ": " + argName + "}" : "") + ")" + (retValue ? "." + retValue : ""), "0.5");
		var newArgs = [];
		if (argName) {
			var argsIn = {};
			argsIn[argName] = args[1];
			newArgs.push(args[0]);
			newArgs.push(argsIn);
		} else {
			newArgs = args;
		}
		var ret = dojo.html[replFunc].apply(dojo.html, args);
		if (retValue) {
			return ret[retValue];
		} else {
			return ret;
		}
	};
	dojo.html.getViewportWidth = function () {
		return dojo.html._callDeprecated("getViewportWidth", "getViewport", arguments, null, "width");
	};
	dojo.html.getViewportHeight = function () {
		return dojo.html._callDeprecated("getViewportHeight", "getViewport", arguments, null, "height");
	};
	dojo.html.getViewportSize = function () {
		return dojo.html._callDeprecated("getViewportSize", "getViewport", arguments);
	};
	dojo.html.getScrollTop = function () {
		return dojo.html._callDeprecated("getScrollTop", "getScroll", arguments, null, "top");
	};
	dojo.html.getScrollLeft = function () {
		return dojo.html._callDeprecated("getScrollLeft", "getScroll", arguments, null, "left");
	};
	dojo.html.getScrollOffset = function () {
		return dojo.html._callDeprecated("getScrollOffset", "getScroll", arguments, null, "offset");
	};
}});


__CPAN_FILE__ src/html/util.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.html.util"], ["require", "dojo.html.layout"]], definePackage:function (dojo) {
	dojo.provide("dojo.html.util");
	dojo.require("dojo.html.layout");
	dojo.html.getElementWindow = function (element) {
		return dojo.html.getDocumentWindow(element.ownerDocument);
	};
	dojo.html.getDocumentWindow = function (doc) {
		if (dojo.render.html.safari && !doc._parentWindow) {
			var fix = function (win) {
				win.document._parentWindow = win;
				for (var i = 0; i < win.frames.length; i++) {
					fix(win.frames[i]);
				}
			};
			fix(window.top);
		}
		if (dojo.render.html.ie && window !== document.parentWindow && !doc._parentWindow) {
			doc.parentWindow.execScript("document._parentWindow = window;", "Javascript");
			var win = doc._parentWindow;
			doc._parentWindow = null;
			return win;
		}
		return doc._parentWindow || doc.parentWindow || doc.defaultView;
	};
	dojo.html.gravity = function (node, e) {
		node = dojo.byId(node);
		var mouse = dojo.html.getCursorPosition(e);
		with (dojo.html) {
			var absolute = getAbsolutePosition(node, true);
			var bb = getBorderBox(node);
			var nodecenterx = absolute.x + (bb.width / 2);
			var nodecentery = absolute.y + (bb.height / 2);
		}
		with (dojo.html.gravity) {
			return ((mouse.x < nodecenterx ? WEST : EAST) | (mouse.y < nodecentery ? NORTH : SOUTH));
		}
	};
	dojo.html.gravity.NORTH = 1;
	dojo.html.gravity.SOUTH = 1 << 1;
	dojo.html.gravity.EAST = 1 << 2;
	dojo.html.gravity.WEST = 1 << 3;
	dojo.html.overElement = function (element, e) {
		element = dojo.byId(element);
		var mouse = dojo.html.getCursorPosition(e);
		var bb = dojo.html.getBorderBox(element);
		var absolute = dojo.html.getAbsolutePosition(element, true, dojo.html.boxSizing.BORDER_BOX);
		var top = absolute.y;
		var bottom = top + bb.height;
		var left = absolute.x;
		var right = left + bb.width;
		return (mouse.x >= left && mouse.x <= right && mouse.y >= top && mouse.y <= bottom);
	};
	dojo.html.renderedTextContent = function (node) {
		node = dojo.byId(node);
		var result = "";
		if (node == null) {
			return result;
		}
		for (var i = 0; i < node.childNodes.length; i++) {
			switch (node.childNodes[i].nodeType) {
			  case 1:
			  case 5:
				var display = "unknown";
				try {
					display = dojo.html.getStyle(node.childNodes[i], "display");
				}
				catch (E) {
				}
				switch (display) {
				  case "block":
				  case "list-item":
				  case "run-in":
				  case "table":
				  case "table-row-group":
				  case "table-header-group":
				  case "table-footer-group":
				  case "table-row":
				  case "table-column-group":
				  case "table-column":
				  case "table-cell":
				  case "table-caption":
					result += "\n";
					result += dojo.html.renderedTextContent(node.childNodes[i]);
					result += "\n";
					break;
				  case "none":
					break;
				  default:
					if (node.childNodes[i].tagName && node.childNodes[i].tagName.toLowerCase() == "br") {
						result += "\n";
					} else {
						result += dojo.html.renderedTextContent(node.childNodes[i]);
					}
					break;
				}
				break;
			  case 3:
			  case 2:
			  case 4:
				var text = node.childNodes[i].nodeValue;
				var textTransform = "unknown";
				try {
					textTransform = dojo.html.getStyle(node, "text-transform");
				}
				catch (E) {
				}
				switch (textTransform) {
				  case "capitalize":
					var words = text.split(" ");
					for (var i = 0; i < words.length; i++) {
						words[i] = words[i].charAt(0).toUpperCase() + words[i].substring(1);
					}
					text = words.join(" ");
					break;
				  case "uppercase":
					text = text.toUpperCase();
					break;
				  case "lowercase":
					text = text.toLowerCase();
					break;
				  default:
					break;
				}
				switch (textTransform) {
				  case "nowrap":
					break;
				  case "pre-wrap":
					break;
				  case "pre-line":
					break;
				  case "pre":
					break;
				  default:
					text = text.replace(/\s+/, " ");
					if (/\s$/.test(result)) {
						text.replace(/^\s/, "");
					}
					break;
				}
				result += text;
				break;
			  default:
				break;
			}
		}
		return result;
	};
	dojo.html.createNodesFromText = function (txt, trim) {
		if (trim) {
			txt = txt.replace(/^\s+|\s+$/g, "");
		}
		var tn = dojo.doc().createElement("div");
		tn.style.visibility = "hidden";
		dojo.body().appendChild(tn);
		var tableType = "none";
		if ((/^<t[dh][\s\r\n>]/i).test(txt.replace(/^\s+/))) {
			txt = "<table><tbody><tr>" + txt + "</tr></tbody></table>";
			tableType = "cell";
		} else {
			if ((/^<tr[\s\r\n>]/i).test(txt.replace(/^\s+/))) {
				txt = "<table><tbody>" + txt + "</tbody></table>";
				tableType = "row";
			} else {
				if ((/^<(thead|tbody|tfoot)[\s\r\n>]/i).test(txt.replace(/^\s+/))) {
					txt = "<table>" + txt + "</table>";
					tableType = "section";
				}
			}
		}
		tn.innerHTML = txt;
		if (tn["normalize"]) {
			tn.normalize();
		}
		var parent = null;
		switch (tableType) {
		  case "cell":
			parent = tn.getElementsByTagName("tr")[0];
			break;
		  case "row":
			parent = tn.getElementsByTagName("tbody")[0];
			break;
		  case "section":
			parent = tn.getElementsByTagName("table")[0];
			break;
		  default:
			parent = tn;
			break;
		}
		var nodes = [];
		for (var x = 0; x < parent.childNodes.length; x++) {
			nodes.push(parent.childNodes[x].cloneNode(true));
		}
		tn.style.display = "none";
		dojo.html.destroyNode(tn);
		return nodes;
	};
	dojo.html.placeOnScreen = function (node, desiredX, desiredY, padding, hasScroll, corners, tryOnly) {
		if (desiredX instanceof Array || typeof desiredX == "array") {
			tryOnly = corners;
			corners = hasScroll;
			hasScroll = padding;
			padding = desiredY;
			desiredY = desiredX[1];
			desiredX = desiredX[0];
		}
		if (corners instanceof String || typeof corners == "string") {
			corners = corners.split(",");
		}
		if (!isNaN(padding)) {
			padding = [Number(padding), Number(padding)];
		} else {
			if (!(padding instanceof Array || typeof padding == "array")) {
				padding = [0, 0];
			}
		}
		var scroll = dojo.html.getScroll().offset;
		var view = dojo.html.getViewport();
		node = dojo.byId(node);
		var oldDisplay = node.style.display;
		node.style.display = "";
		var bb = dojo.html.getBorderBox(node);
		var w = bb.width;
		var h = bb.height;
		node.style.display = oldDisplay;
		if (!(corners instanceof Array || typeof corners == "array")) {
			corners = ["TL"];
		}
		var bestx, besty, bestDistance = Infinity, bestCorner;
		for (var cidex = 0; cidex < corners.length; ++cidex) {
			var corner = corners[cidex];
			var match = true;
			var tryX = desiredX - (corner.charAt(1) == "L" ? 0 : w) + padding[0] * (corner.charAt(1) == "L" ? 1 : -1);
			var tryY = desiredY - (corner.charAt(0) == "T" ? 0 : h) + padding[1] * (corner.charAt(0) == "T" ? 1 : -1);
			if (hasScroll) {
				tryX -= scroll.x;
				tryY -= scroll.y;
			}
			if (tryX < 0) {
				tryX = 0;
				match = false;
			}
			if (tryY < 0) {
				tryY = 0;
				match = false;
			}
			var x = tryX + w;
			if (x > view.width) {
				x = view.width - w;
				match = false;
			} else {
				x = tryX;
			}
			x = Math.max(padding[0], x) + scroll.x;
			var y = tryY + h;
			if (y > view.height) {
				y = view.height - h;
				match = false;
			} else {
				y = tryY;
			}
			y = Math.max(padding[1], y) + scroll.y;
			if (match) {
				bestx = x;
				besty = y;
				bestDistance = 0;
				bestCorner = corner;
				break;
			} else {
				var dist = Math.pow(x - tryX - scroll.x, 2) + Math.pow(y - tryY - scroll.y, 2);
				if (bestDistance > dist) {
					bestDistance = dist;
					bestx = x;
					besty = y;
					bestCorner = corner;
				}
			}
		}
		if (!tryOnly) {
			node.style.left = bestx + "px";
			node.style.top = besty + "px";
		}
		return {left:bestx, top:besty, x:bestx, y:besty, dist:bestDistance, corner:bestCorner};
	};
	dojo.html.placeOnScreenPoint = function (node, desiredX, desiredY, padding, hasScroll) {
		dojo.deprecated("dojo.html.placeOnScreenPoint", "use dojo.html.placeOnScreen() instead", "0.5");
		return dojo.html.placeOnScreen(node, desiredX, desiredY, padding, hasScroll, ["TL", "TR", "BL", "BR"]);
	};
	dojo.html.placeOnScreenAroundElement = function (node, aroundNode, padding, aroundType, aroundCorners, tryOnly) {
		var best, bestDistance = Infinity;
		aroundNode = dojo.byId(aroundNode);
		var oldDisplay = aroundNode.style.display;
		aroundNode.style.display = "";
		var mb = dojo.html.getElementBox(aroundNode, aroundType);
		var aroundNodeW = mb.width;
		var aroundNodeH = mb.height;
		var aroundNodePos = dojo.html.getAbsolutePosition(aroundNode, true, aroundType);
		aroundNode.style.display = oldDisplay;
		for (var nodeCorner in aroundCorners) {
			var pos, desiredX, desiredY;
			var corners = aroundCorners[nodeCorner];
			desiredX = aroundNodePos.x + (nodeCorner.charAt(1) == "L" ? 0 : aroundNodeW);
			desiredY = aroundNodePos.y + (nodeCorner.charAt(0) == "T" ? 0 : aroundNodeH);
			pos = dojo.html.placeOnScreen(node, desiredX, desiredY, padding, true, corners, true);
			if (pos.dist == 0) {
				best = pos;
				break;
			} else {
				if (bestDistance > pos.dist) {
					bestDistance = pos.dist;
					best = pos;
				}
			}
		}
		if (!tryOnly) {
			node.style.left = best.left + "px";
			node.style.top = best.top + "px";
		}
		return best;
	};
	dojo.html.scrollIntoView = function (node) {
		if (!node) {
			return;
		}
		if (dojo.render.html.ie) {
			if (dojo.html.getBorderBox(node.parentNode).height <= node.parentNode.scrollHeight) {
				node.scrollIntoView(false);
			}
		} else {
			if (dojo.render.html.mozilla) {
				node.scrollIntoView(false);
			} else {
				var parent = node.parentNode;
				var parentBottom = parent.scrollTop + dojo.html.getBorderBox(parent).height;
				var nodeBottom = node.offsetTop + dojo.html.getMarginBox(node).height;
				if (parentBottom < nodeBottom) {
					parent.scrollTop += (nodeBottom - parentBottom);
				} else {
					if (parent.scrollTop > node.offsetTop) {
						parent.scrollTop -= (parent.scrollTop - node.offsetTop);
					}
				}
			}
		}
	};
}});


__CPAN_FILE__ src/html/display.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.html.display"], ["require", "dojo.html.style"]], definePackage:function (dojo) {
	dojo.provide("dojo.html.display");
	dojo.require("dojo.html.style");
	dojo.html._toggle = function (node, tester, setter) {
		node = dojo.byId(node);
		setter(node, !tester(node));
		return tester(node);
	};
	dojo.html.show = function (node) {
		node = dojo.byId(node);
		if (dojo.html.getStyleProperty(node, "display") == "none") {
			dojo.html.setStyle(node, "display", (node.dojoDisplayCache || ""));
			node.dojoDisplayCache = undefined;
		}
	};
	dojo.html.hide = function (node) {
		node = dojo.byId(node);
		if (typeof node["dojoDisplayCache"] == "undefined") {
			var d = dojo.html.getStyleProperty(node, "display");
			if (d != "none") {
				node.dojoDisplayCache = d;
			}
		}
		dojo.html.setStyle(node, "display", "none");
	};
	dojo.html.setShowing = function (node, showing) {
		dojo.html[(showing ? "show" : "hide")](node);
	};
	dojo.html.isShowing = function (node) {
		return (dojo.html.getStyleProperty(node, "display") != "none");
	};
	dojo.html.toggleShowing = function (node) {
		return dojo.html._toggle(node, dojo.html.isShowing, dojo.html.setShowing);
	};
	dojo.html.displayMap = {tr:"", td:"", th:"", img:"inline", span:"inline", input:"inline", button:"inline"};
	dojo.html.suggestDisplayByTagName = function (node) {
		node = dojo.byId(node);
		if (node && node.tagName) {
			var tag = node.tagName.toLowerCase();
			return (tag in dojo.html.displayMap ? dojo.html.displayMap[tag] : "block");
		}
	};
	dojo.html.setDisplay = function (node, display) {
		dojo.html.setStyle(node, "display", ((display instanceof String || typeof display == "string") ? display : (display ? dojo.html.suggestDisplayByTagName(node) : "none")));
	};
	dojo.html.isDisplayed = function (node) {
		return (dojo.html.getComputedStyle(node, "display") != "none");
	};
	dojo.html.toggleDisplay = function (node) {
		return dojo.html._toggle(node, dojo.html.isDisplayed, dojo.html.setDisplay);
	};
	dojo.html.setVisibility = function (node, visibility) {
		dojo.html.setStyle(node, "visibility", ((visibility instanceof String || typeof visibility == "string") ? visibility : (visibility ? "visible" : "hidden")));
	};
	dojo.html.isVisible = function (node) {
		return (dojo.html.getComputedStyle(node, "visibility") != "hidden");
	};
	dojo.html.toggleVisibility = function (node) {
		return dojo.html._toggle(node, dojo.html.isVisible, dojo.html.setVisibility);
	};
	dojo.html.setOpacity = function (node, opacity, dontFixOpacity) {
		node = dojo.byId(node);
		var h = dojo.render.html;
		if (!dontFixOpacity) {
			if (opacity >= 1) {
				if (h.ie) {
					dojo.html.clearOpacity(node);
					return;
				} else {
					opacity = 0.999999;
				}
			} else {
				if (opacity < 0) {
					opacity = 0;
				}
			}
		}
		if (h.ie) {
			if (node.nodeName.toLowerCase() == "tr") {
				var tds = node.getElementsByTagName("td");
				for (var x = 0; x < tds.length; x++) {
					tds[x].style.filter = "Alpha(Opacity=" + opacity * 100 + ")";
				}
			}
			node.style.filter = "Alpha(Opacity=" + opacity * 100 + ")";
		} else {
			if (h.moz) {
				node.style.opacity = opacity;
				node.style.MozOpacity = opacity;
			} else {
				if (h.safari) {
					node.style.opacity = opacity;
					node.style.KhtmlOpacity = opacity;
				} else {
					node.style.opacity = opacity;
				}
			}
		}
	};
	dojo.html.clearOpacity = function (node) {
		node = dojo.byId(node);
		var ns = node.style;
		var h = dojo.render.html;
		if (h.ie) {
			try {
				if (node.filters && node.filters.alpha) {
					ns.filter = "";
				}
			}
			catch (e) {
			}
		} else {
			if (h.moz) {
				ns.opacity = 1;
				ns.MozOpacity = 1;
			} else {
				if (h.safari) {
					ns.opacity = 1;
					ns.KhtmlOpacity = 1;
				} else {
					ns.opacity = 1;
				}
			}
		}
	};
	dojo.html.getOpacity = function (node) {
		node = dojo.byId(node);
		var h = dojo.render.html;
		if (h.ie) {
			var opac = (node.filters && node.filters.alpha && typeof node.filters.alpha.opacity == "number" ? node.filters.alpha.opacity : 100) / 100;
		} else {
			var opac = node.style.opacity || node.style.MozOpacity || node.style.KhtmlOpacity || 1;
		}
		return opac >= 0.999999 ? 1 : Number(opac);
	};
}});


__CPAN_FILE__ src/html/shadow.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.html.shadow");
dojo.require("dojo.lfx.shadow");
dojo.deprecated("dojo.html.shadow has been moved to dojo.lfx.", "0.5");
dojo.html.shadow = dojo.lfx.shadow;


__CPAN_FILE__ src/html/selection.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["require", "dojo.html.common"], ["provide", "dojo.html.selection"], ["require", "dojo.dom"], ["require", "dojo.lang.common"]], definePackage:function (dojo) {
	dojo.require("dojo.html.common");
	dojo.provide("dojo.html.selection");
	dojo.require("dojo.dom");
	dojo.require("dojo.lang.common");
	dojo.html.selectionType = {NONE:0, TEXT:1, CONTROL:2};
	dojo.html.clearSelection = function () {
		var _window = dojo.global();
		var _document = dojo.doc();
		try {
			if (_window["getSelection"]) {
				if (dojo.render.html.safari) {
					_window.getSelection().collapse();
				} else {
					_window.getSelection().removeAllRanges();
				}
			} else {
				if (_document.selection) {
					if (_document.selection.empty) {
						_document.selection.empty();
					} else {
						if (_document.selection.clear) {
							_document.selection.clear();
						}
					}
				}
			}
			return true;
		}
		catch (e) {
			dojo.debug(e);
			return false;
		}
	};
	dojo.html.disableSelection = function (element) {
		element = dojo.byId(element) || dojo.body();
		var h = dojo.render.html;
		if (h.mozilla) {
			element.style.MozUserSelect = "none";
		} else {
			if (h.safari) {
				element.style.KhtmlUserSelect = "none";
			} else {
				if (h.ie) {
					element.unselectable = "on";
				} else {
					return false;
				}
			}
		}
		return true;
	};
	dojo.html.enableSelection = function (element) {
		element = dojo.byId(element) || dojo.body();
		var h = dojo.render.html;
		if (h.mozilla) {
			element.style.MozUserSelect = "";
		} else {
			if (h.safari) {
				element.style.KhtmlUserSelect = "";
			} else {
				if (h.ie) {
					element.unselectable = "off";
				} else {
					return false;
				}
			}
		}
		return true;
	};
	dojo.html.selectElement = function (element) {
		dojo.deprecated("dojo.html.selectElement", "replaced by dojo.html.selection.selectElementChildren", 0.5);
	};
	dojo.html.selectInputText = function (element) {
		var _window = dojo.global();
		var _document = dojo.doc();
		element = dojo.byId(element);
		if (_document["selection"] && dojo.body()["createTextRange"]) {
			var range = element.createTextRange();
			range.moveStart("character", 0);
			range.moveEnd("character", element.value.length);
			range.select();
		} else {
			if (_window["getSelection"]) {
				var selection = _window.getSelection();
				element.setSelectionRange(0, element.value.length);
			}
		}
		element.focus();
	};
	dojo.html.isSelectionCollapsed = function () {
		dojo.deprecated("dojo.html.isSelectionCollapsed", "replaced by dojo.html.selection.isCollapsed", 0.5);
		return dojo.html.selection.isCollapsed();
	};
	dojo.lang.mixin(dojo.html.selection, {getType:function () {
		if (dojo.doc()["selection"]) {
			return dojo.html.selectionType[dojo.doc().selection.type.toUpperCase()];
		} else {
			var stype = dojo.html.selectionType.TEXT;
			var oSel;
			try {
				oSel = dojo.global().getSelection();
			}
			catch (e) {
			}
			if (oSel && oSel.rangeCount == 1) {
				var oRange = oSel.getRangeAt(0);
				if (oRange.startContainer == oRange.endContainer && (oRange.endOffset - oRange.startOffset) == 1 && oRange.startContainer.nodeType != dojo.dom.TEXT_NODE) {
					stype = dojo.html.selectionType.CONTROL;
				}
			}
			return stype;
		}
	}, isCollapsed:function () {
		var _window = dojo.global();
		var _document = dojo.doc();
		if (_document["selection"]) {
			return _document.selection.createRange().text == "";
		} else {
			if (_window["getSelection"]) {
				var selection = _window.getSelection();
				if (dojo.lang.isString(selection)) {
					return selection == "";
				} else {
					return selection.isCollapsed || selection.toString() == "";
				}
			}
		}
	}, getSelectedElement:function () {
		if (dojo.html.selection.getType() == dojo.html.selectionType.CONTROL) {
			if (dojo.doc()["selection"]) {
				var range = dojo.doc().selection.createRange();
				if (range && range.item) {
					return dojo.doc().selection.createRange().item(0);
				}
			} else {
				var selection = dojo.global().getSelection();
				return selection.anchorNode.childNodes[selection.anchorOffset];
			}
		}
	}, getParentElement:function () {
		if (dojo.html.selection.getType() == dojo.html.selectionType.CONTROL) {
			var p = dojo.html.selection.getSelectedElement();
			if (p) {
				return p.parentNode;
			}
		} else {
			if (dojo.doc()["selection"]) {
				return dojo.doc().selection.createRange().parentElement();
			} else {
				var selection = dojo.global().getSelection();
				if (selection) {
					var node = selection.anchorNode;
					while (node && node.nodeType != dojo.dom.ELEMENT_NODE) {
						node = node.parentNode;
					}
					return node;
				}
			}
		}
	}, getSelectedText:function () {
		if (dojo.doc()["selection"]) {
			if (dojo.html.selection.getType() == dojo.html.selectionType.CONTROL) {
				return null;
			}
			return dojo.doc().selection.createRange().text;
		} else {
			var selection = dojo.global().getSelection();
			if (selection) {
				return selection.toString();
			}
		}
	}, getSelectedHtml:function () {
		if (dojo.doc()["selection"]) {
			if (dojo.html.selection.getType() == dojo.html.selectionType.CONTROL) {
				return null;
			}
			return dojo.doc().selection.createRange().htmlText;
		} else {
			var selection = dojo.global().getSelection();
			if (selection && selection.rangeCount) {
				var frag = selection.getRangeAt(0).cloneContents();
				var div = document.createElement("div");
				div.appendChild(frag);
				return div.innerHTML;
			}
			return null;
		}
	}, hasAncestorElement:function (tagName) {
		return (dojo.html.selection.getAncestorElement.apply(this, arguments) != null);
	}, getAncestorElement:function (tagName) {
		var node = dojo.html.selection.getSelectedElement() || dojo.html.selection.getParentElement();
		while (node) {
			if (dojo.html.selection.isTag(node, arguments).length > 0) {
				return node;
			}
			node = node.parentNode;
		}
		return null;
	}, isTag:function (node, tags) {
		if (node && node.tagName) {
			for (var i = 0; i < tags.length; i++) {
				if (node.tagName.toLowerCase() == String(tags[i]).toLowerCase()) {
					return String(tags[i]).toLowerCase();
				}
			}
		}
		return "";
	}, selectElement:function (element) {
		var _window = dojo.global();
		var _document = dojo.doc();
		element = dojo.byId(element);
		if (_document.selection && dojo.body().createTextRange) {
			try {
				var range = dojo.body().createControlRange();
				range.addElement(element);
				range.select();
			}
			catch (e) {
				dojo.html.selection.selectElementChildren(element);
			}
		} else {
			if (_window["getSelection"]) {
				var selection = _window.getSelection();
				if (selection["removeAllRanges"]) {
					var range = _document.createRange();
					range.selectNode(element);
					selection.removeAllRanges();
					selection.addRange(range);
				}
			}
		}
	}, selectElementChildren:function (element) {
		var _window = dojo.global();
		var _document = dojo.doc();
		element = dojo.byId(element);
		if (_document.selection && dojo.body().createTextRange) {
			var range = dojo.body().createTextRange();
			range.moveToElementText(element);
			range.select();
		} else {
			if (_window["getSelection"]) {
				var selection = _window.getSelection();
				if (selection["setBaseAndExtent"]) {
					selection.setBaseAndExtent(element, 0, element, element.innerText.length - 1);
				} else {
					if (selection["selectAllChildren"]) {
						selection.selectAllChildren(element);
					}
				}
			}
		}
	}, getBookmark:function () {
		var bookmark;
		var _document = dojo.doc();
		if (_document["selection"]) {
			var range = _document.selection.createRange();
			bookmark = range.getBookmark();
		} else {
			var selection;
			try {
				selection = dojo.global().getSelection();
			}
			catch (e) {
			}
			if (selection) {
				var range = selection.getRangeAt(0);
				bookmark = range.cloneRange();
			} else {
				dojo.debug("No idea how to store the current selection for this browser!");
			}
		}
		return bookmark;
	}, moveToBookmark:function (bookmark) {
		var _document = dojo.doc();
		if (_document["selection"]) {
			var range = _document.selection.createRange();
			range.moveToBookmark(bookmark);
			range.select();
		} else {
			var selection;
			try {
				selection = dojo.global().getSelection();
			}
			catch (e) {
			}
			if (selection && selection["removeAllRanges"]) {
				selection.removeAllRanges();
				selection.addRange(bookmark);
			} else {
				dojo.debug("No idea how to restore selection for this browser!");
			}
		}
	}, collapse:function (beginning) {
		if (dojo.global()["getSelection"]) {
			var selection = dojo.global().getSelection();
			if (selection.removeAllRanges) {
				if (beginning) {
					selection.collapseToStart();
				} else {
					selection.collapseToEnd();
				}
			} else {
				dojo.global().getSelection().collapse(beginning);
			}
		} else {
			if (dojo.doc().selection) {
				var range = dojo.doc().selection.createRange();
				range.collapse(beginning);
				range.select();
			}
		}
	}, remove:function () {
		if (dojo.doc().selection) {
			var selection = dojo.doc().selection;
			if (selection.type.toUpperCase() != "NONE") {
				selection.clear();
			}
			return selection;
		} else {
			var selection = dojo.global().getSelection();
			for (var i = 0; i < selection.rangeCount; i++) {
				selection.getRangeAt(i).deleteContents();
			}
			return selection;
		}
	}});
}});


__CPAN_FILE__ src/html/iframe.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.html.iframe");
dojo.require("dojo.html.util");
dojo.html.iframeContentWindow = function (iframe_el) {
	var win = dojo.html.getDocumentWindow(dojo.html.iframeContentDocument(iframe_el)) || dojo.html.iframeContentDocument(iframe_el).__parent__ || (iframe_el.name && document.frames[iframe_el.name]) || null;
	return win;
};
dojo.html.iframeContentDocument = function (iframe_el) {
	var doc = iframe_el.contentDocument || ((iframe_el.contentWindow) && (iframe_el.contentWindow.document)) || ((iframe_el.name) && (document.frames[iframe_el.name]) && (document.frames[iframe_el.name].document)) || null;
	return doc;
};
dojo.html.BackgroundIframe = function (node) {
	if (dojo.render.html.ie55 || dojo.render.html.ie60) {
		var html = "<iframe src='javascript:false'" + " style='position: absolute; left: 0px; top: 0px; width: 100%; height: 100%;" + "z-index: -1; filter:Alpha(Opacity=\"0\");' " + ">";
		this.iframe = dojo.doc().createElement(html);
		this.iframe.tabIndex = -1;
		if (node) {
			node.appendChild(this.iframe);
			this.domNode = node;
		} else {
			dojo.body().appendChild(this.iframe);
			this.iframe.style.display = "none";
		}
	}
};
dojo.lang.extend(dojo.html.BackgroundIframe, {iframe:null, onResized:function () {
	if (this.iframe && this.domNode && this.domNode.parentNode) {
		var outer = dojo.html.getMarginBox(this.domNode);
		if (outer.width == 0 || outer.height == 0) {
			dojo.lang.setTimeout(this, this.onResized, 100);
			return;
		}
		this.iframe.style.width = outer.width + "px";
		this.iframe.style.height = outer.height + "px";
	}
}, size:function (node) {
	if (!this.iframe) {
		return;
	}
	var coords = dojo.html.toCoordinateObject(node, true, dojo.html.boxSizing.BORDER_BOX);
	with (this.iframe.style) {
		width = coords.width + "px";
		height = coords.height + "px";
		left = coords.left + "px";
		top = coords.top + "px";
	}
}, setZIndex:function (node) {
	if (!this.iframe) {
		return;
	}
	if (dojo.dom.isNode(node)) {
		this.iframe.style.zIndex = dojo.html.getStyle(node, "z-index") - 1;
	} else {
		if (!isNaN(node)) {
			this.iframe.style.zIndex = node;
		}
	}
}, show:function () {
	if (this.iframe) {
		this.iframe.style.display = "block";
	}
}, hide:function () {
	if (this.iframe) {
		this.iframe.style.display = "none";
	}
}, remove:function () {
	if (this.iframe) {
		dojo.html.removeNode(this.iframe, true);
		delete this.iframe;
		this.iframe = null;
	}
}});


__CPAN_DIR__ src/html/images
__CPAN_FILE__ src/html/images/shadowBL.png
PNG

   
IHDR            gAMA  OX2   tEXtSoftware Adobe ImageReadyqe<   IDATx4 Dٲ!DH"
c<1zZ~_j84	8կ|Ȏ!UnHs ^S\NGD8pGY)q%	d4M"ʺͲN޶y.LeYxS_ =5bd5ʦ    IENDB`
__CPAN_FILE__ src/html/images/shadowTR.png
PNG

   
IHDR            gAMA  OX2   tEXtSoftware Adobe ImageReadyqe<   IDATx D(b%x]=Xt4Iqy&VJR;SZkh.`}':"`˲<1Ƽm[;+3ƤZ+
àbKB`*@{_%YZY >x{i>ׄ&nЄ]^`Ĵ,04 `ұ    IENDB`
__CPAN_FILE__ src/html/images/shadowBR.png
PNG

   
IHDR            gAMA  OX2   tEXtSoftware Adobe ImageReadyqe<   IDATx4OI <sE҄՝Z1u]"r*v O{cqiZډ*(bU	qٌ1r ) 霻sB^K'Z+Քw`oZJicL3K'ܶM ?    IENDB`
__CPAN_FILE__ src/html/images/shadowR.png
PNG

   
IHDR          C   gAMA  OX2   tEXtSoftware Adobe ImageReadyqe<   'IDATxbLII)g``
#H  @@    IENDB`
__CPAN_FILE__ src/html/images/shadowB.png
PNG

   
IHDR        d   gAMA  OX2   tEXtSoftware Adobe ImageReadyqe<  hIDATx1n0
Q}ܸХC<ɜ%:>A˨m߾ jZv   pFtum  -"  iG][6 Y7~ NAs~l 6 r7.9̖yk[;k6e6ϯm@ <wj ,  j[;3gS{Ʀف>J[DBm];s_ڣ y@ (ǎ|o^&[jM1@AGnm帶M  K_  񧟭-lj7v^_Zo&||3 x YvMm{d{  31Ws C7} ` |fZoN    IENDB`
__CPAN_FILE__ src/html/images/shadowL.png
PNG

   
IHDR          C   gAMA  OX2   tEXtSoftware Adobe ImageReadyqe<   &IDATxbLHHfee0(fdd4@ 
Zu    IENDB`
__CPAN_FILE__ src/html/images/shadowTL.png
PNG

   
IHDR            gAMA  OX2   tEXtSoftware Adobe ImageReadyqe<   IDATx,A0e[.qAΪ(QveY;rVkEymy8(R=ຮv][kIpHf.}c,Zf	>q&WGտ57=;@S	)챹âO 9uc    IENDB`
__CPAN_FILE__ src/html/images/shadowT.png
PNG

   
IHDR         8A   gAMA  OX2   tEXtSoftware Adobe ImageReadyqe<   *IDATxbHOOdb``b?%"Lqb\  7)    IENDB`
__CPAN_DIR__ src/event
__CPAN_FILE__ src/event/browser.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.event.browser");
dojo.require("dojo.event.common");
dojo._ie_clobber = new function () {
	this.clobberNodes = [];
	function nukeProp(node, prop) {
		try {
			node[prop] = null;
		}
		catch (e) {
		}
		try {
			delete node[prop];
		}
		catch (e) {
		}
		try {
			node.removeAttribute(prop);
		}
		catch (e) {
		}
	}
	this.clobber = function (nodeRef) {
		var na;
		var tna;
		if (nodeRef) {
			tna = nodeRef.all || nodeRef.getElementsByTagName("*");
			na = [nodeRef];
			for (var x = 0; x < tna.length; x++) {
				if (tna[x]["__doClobber__"]) {
					na.push(tna[x]);
				}
			}
		} else {
			try {
				window.onload = null;
			}
			catch (e) {
			}
			na = (this.clobberNodes.length) ? this.clobberNodes : document.all;
		}
		tna = null;
		var basis = {};
		for (var i = na.length - 1; i >= 0; i = i - 1) {
			var el = na[i];
			try {
				if (el && el["__clobberAttrs__"]) {
					for (var j = 0; j < el.__clobberAttrs__.length; j++) {
						nukeProp(el, el.__clobberAttrs__[j]);
					}
					nukeProp(el, "__clobberAttrs__");
					nukeProp(el, "__doClobber__");
				}
			}
			catch (e) {
			}
		}
		na = null;
	};
};
if (dojo.render.html.ie) {
	dojo.addOnUnload(function () {
		dojo._ie_clobber.clobber();
		try {
			if ((dojo["widget"]) && (dojo.widget["manager"])) {
				dojo.widget.manager.destroyAll();
			}
		}
		catch (e) {
		}
		if (dojo.widget) {
			for (var name in dojo.widget._templateCache) {
				if (dojo.widget._templateCache[name].node) {
					dojo.dom.destroyNode(dojo.widget._templateCache[name].node);
					dojo.widget._templateCache[name].node = null;
					delete dojo.widget._templateCache[name].node;
				}
			}
		}
		try {
			window.onload = null;
		}
		catch (e) {
		}
		try {
			window.onunload = null;
		}
		catch (e) {
		}
		dojo._ie_clobber.clobberNodes = [];
	});
}
dojo.event.browser = new function () {
	var clobberIdx = 0;
	this.normalizedEventName = function (eventName) {
		switch (eventName) {
		  case "CheckboxStateChange":
		  case "DOMAttrModified":
		  case "DOMMenuItemActive":
		  case "DOMMenuItemInactive":
		  case "DOMMouseScroll":
		  case "DOMNodeInserted":
		  case "DOMNodeRemoved":
		  case "RadioStateChange":
			return eventName;
			break;
		  default:
			var lcn = eventName.toLowerCase();
			return (lcn.indexOf("on") == 0) ? lcn.substr(2) : lcn;
			break;
		}
	};
	this.clean = function (node) {
		if (dojo.render.html.ie) {
			dojo._ie_clobber.clobber(node);
		}
	};
	this.addClobberNode = function (node) {
		if (!dojo.render.html.ie) {
			return;
		}
		if (!node["__doClobber__"]) {
			node.__doClobber__ = true;
			dojo._ie_clobber.clobberNodes.push(node);
			node.__clobberAttrs__ = [];
		}
	};
	this.addClobberNodeAttrs = function (node, props) {
		if (!dojo.render.html.ie) {
			return;
		}
		this.addClobberNode(node);
		for (var x = 0; x < props.length; x++) {
			node.__clobberAttrs__.push(props[x]);
		}
	};
	this.removeListener = function (node, evtName, fp, capture) {
		if (!capture) {
			var capture = false;
		}
		evtName = dojo.event.browser.normalizedEventName(evtName);
		if (evtName == "key") {
			if (dojo.render.html.ie) {
				this.removeListener(node, "onkeydown", fp, capture);
			}
			evtName = "keypress";
		}
		if (node.removeEventListener) {
			node.removeEventListener(evtName, fp, capture);
		}
	};
	this.addListener = function (node, evtName, fp, capture, dontFix) {
		if (!node) {
			return;
		}
		if (!capture) {
			var capture = false;
		}
		evtName = dojo.event.browser.normalizedEventName(evtName);
		if (evtName == "key") {
			if (dojo.render.html.ie) {
				this.addListener(node, "onkeydown", fp, capture, dontFix);
			}
			evtName = "keypress";
		}
		if (!dontFix) {
			var newfp = function (evt) {
				if (!evt) {
					evt = window.event;
				}
				var ret = fp(dojo.event.browser.fixEvent(evt, this));
				if (capture) {
					dojo.event.browser.stopEvent(evt);
				}
				return ret;
			};
		} else {
			newfp = fp;
		}
		if (node.addEventListener) {
			node.addEventListener(evtName, newfp, capture);
			return newfp;
		} else {
			evtName = "on" + evtName;
			if (typeof node[evtName] == "function") {
				var oldEvt = node[evtName];
				node[evtName] = function (e) {
					oldEvt(e);
					return newfp(e);
				};
			} else {
				node[evtName] = newfp;
			}
			if (dojo.render.html.ie) {
				this.addClobberNodeAttrs(node, [evtName]);
			}
			return newfp;
		}
	};
	this.isEvent = function (obj) {
		return (typeof obj != "undefined") && (obj) && (typeof Event != "undefined") && (obj.eventPhase);
	};
	this.currentEvent = null;
	this.callListener = function (listener, curTarget) {
		if (typeof listener != "function") {
			dojo.raise("listener not a function: " + listener);
		}
		dojo.event.browser.currentEvent.currentTarget = curTarget;
		return listener.call(curTarget, dojo.event.browser.currentEvent);
	};
	this._stopPropagation = function () {
		dojo.event.browser.currentEvent.cancelBubble = true;
	};
	this._preventDefault = function () {
		dojo.event.browser.currentEvent.returnValue = false;
	};
	this.keys = {KEY_BACKSPACE:8, KEY_TAB:9, KEY_CLEAR:12, KEY_ENTER:13, KEY_SHIFT:16, KEY_CTRL:17, KEY_ALT:18, KEY_PAUSE:19, KEY_CAPS_LOCK:20, KEY_ESCAPE:27, KEY_SPACE:32, KEY_PAGE_UP:33, KEY_PAGE_DOWN:34, KEY_END:35, KEY_HOME:36, KEY_LEFT_ARROW:37, KEY_UP_ARROW:38, KEY_RIGHT_ARROW:39, KEY_DOWN_ARROW:40, KEY_INSERT:45, KEY_DELETE:46, KEY_HELP:47, KEY_LEFT_WINDOW:91, KEY_RIGHT_WINDOW:92, KEY_SELECT:93, KEY_NUMPAD_0:96, KEY_NUMPAD_1:97, KEY_NUMPAD_2:98, KEY_NUMPAD_3:99, KEY_NUMPAD_4:100, KEY_NUMPAD_5:101, KEY_NUMPAD_6:102, KEY_NUMPAD_7:103, KEY_NUMPAD_8:104, KEY_NUMPAD_9:105, KEY_NUMPAD_MULTIPLY:106, KEY_NUMPAD_PLUS:107, KEY_NUMPAD_ENTER:108, KEY_NUMPAD_MINUS:109, KEY_NUMPAD_PERIOD:110, KEY_NUMPAD_DIVIDE:111, KEY_F1:112, KEY_F2:113, KEY_F3:114, KEY_F4:115, KEY_F5:116, KEY_F6:117, KEY_F7:118, KEY_F8:119, KEY_F9:120, KEY_F10:121, KEY_F11:122, KEY_F12:123, KEY_F13:124, KEY_F14:125, KEY_F15:126, KEY_NUM_LOCK:144, KEY_SCROLL_LOCK:145};
	this.revKeys = [];
	for (var key in this.keys) {
		this.revKeys[this.keys[key]] = key;
	}
	this.fixEvent = function (evt, sender) {
		if (!evt) {
			if (window["event"]) {
				evt = window.event;
			}
		}
		if ((evt["type"]) && (evt["type"].indexOf("key") == 0)) {
			evt.keys = this.revKeys;
			for (var key in this.keys) {
				evt[key] = this.keys[key];
			}
			if (evt["type"] == "keydown" && dojo.render.html.ie) {
				switch (evt.keyCode) {
				  case evt.KEY_SHIFT:
				  case evt.KEY_CTRL:
				  case evt.KEY_ALT:
				  case evt.KEY_CAPS_LOCK:
				  case evt.KEY_LEFT_WINDOW:
				  case evt.KEY_RIGHT_WINDOW:
				  case evt.KEY_SELECT:
				  case evt.KEY_NUM_LOCK:
				  case evt.KEY_SCROLL_LOCK:
				  case evt.KEY_NUMPAD_0:
				  case evt.KEY_NUMPAD_1:
				  case evt.KEY_NUMPAD_2:
				  case evt.KEY_NUMPAD_3:
				  case evt.KEY_NUMPAD_4:
				  case evt.KEY_NUMPAD_5:
				  case evt.KEY_NUMPAD_6:
				  case evt.KEY_NUMPAD_7:
				  case evt.KEY_NUMPAD_8:
				  case evt.KEY_NUMPAD_9:
				  case evt.KEY_NUMPAD_PERIOD:
					break;
				  case evt.KEY_NUMPAD_MULTIPLY:
				  case evt.KEY_NUMPAD_PLUS:
				  case evt.KEY_NUMPAD_ENTER:
				  case evt.KEY_NUMPAD_MINUS:
				  case evt.KEY_NUMPAD_DIVIDE:
					break;
				  case evt.KEY_PAUSE:
				  case evt.KEY_TAB:
				  case evt.KEY_BACKSPACE:
				  case evt.KEY_ENTER:
				  case evt.KEY_ESCAPE:
				  case evt.KEY_PAGE_UP:
				  case evt.KEY_PAGE_DOWN:
				  case evt.KEY_END:
				  case evt.KEY_HOME:
				  case evt.KEY_LEFT_ARROW:
				  case evt.KEY_UP_ARROW:
				  case evt.KEY_RIGHT_ARROW:
				  case evt.KEY_DOWN_ARROW:
				  case evt.KEY_INSERT:
				  case evt.KEY_DELETE:
				  case evt.KEY_F1:
				  case evt.KEY_F2:
				  case evt.KEY_F3:
				  case evt.KEY_F4:
				  case evt.KEY_F5:
				  case evt.KEY_F6:
				  case evt.KEY_F7:
				  case evt.KEY_F8:
				  case evt.KEY_F9:
				  case evt.KEY_F10:
				  case evt.KEY_F11:
				  case evt.KEY_F12:
				  case evt.KEY_F12:
				  case evt.KEY_F13:
				  case evt.KEY_F14:
				  case evt.KEY_F15:
				  case evt.KEY_CLEAR:
				  case evt.KEY_HELP:
					evt.key = evt.keyCode;
					break;
				  default:
					if (evt.ctrlKey || evt.altKey) {
						var unifiedCharCode = evt.keyCode;
						if (unifiedCharCode >= 65 && unifiedCharCode <= 90 && evt.shiftKey == false) {
							unifiedCharCode += 32;
						}
						if (unifiedCharCode >= 1 && unifiedCharCode <= 26 && evt.ctrlKey) {
							unifiedCharCode += 96;
						}
						evt.key = String.fromCharCode(unifiedCharCode);
					}
				}
			} else {
				if (evt["type"] == "keypress") {
					if (dojo.render.html.opera) {
						if (evt.which == 0) {
							evt.key = evt.keyCode;
						} else {
							if (evt.which > 0) {
								switch (evt.which) {
								  case evt.KEY_SHIFT:
								  case evt.KEY_CTRL:
								  case evt.KEY_ALT:
								  case evt.KEY_CAPS_LOCK:
								  case evt.KEY_NUM_LOCK:
								  case evt.KEY_SCROLL_LOCK:
									break;
								  case evt.KEY_PAUSE:
								  case evt.KEY_TAB:
								  case evt.KEY_BACKSPACE:
								  case evt.KEY_ENTER:
								  case evt.KEY_ESCAPE:
									evt.key = evt.which;
									break;
								  default:
									var unifiedCharCode = evt.which;
									if ((evt.ctrlKey || evt.altKey || evt.metaKey) && (evt.which >= 65 && evt.which <= 90 && evt.shiftKey == false)) {
										unifiedCharCode += 32;
									}
									evt.key = String.fromCharCode(unifiedCharCode);
								}
							}
						}
					} else {
						if (dojo.render.html.ie) {
							if (!evt.ctrlKey && !evt.altKey && evt.keyCode >= evt.KEY_SPACE) {
								evt.key = String.fromCharCode(evt.keyCode);
							}
						} else {
							if (dojo.render.html.safari) {
								switch (evt.keyCode) {
								  case 25:
									evt.key = evt.KEY_TAB;
									evt.shift = true;
									break;
								  case 63232:
									evt.key = evt.KEY_UP_ARROW;
									break;
								  case 63233:
									evt.key = evt.KEY_DOWN_ARROW;
									break;
								  case 63234:
									evt.key = evt.KEY_LEFT_ARROW;
									break;
								  case 63235:
									evt.key = evt.KEY_RIGHT_ARROW;
									break;
								  case 63236:
									evt.key = evt.KEY_F1;
									break;
								  case 63237:
									evt.key = evt.KEY_F2;
									break;
								  case 63238:
									evt.key = evt.KEY_F3;
									break;
								  case 63239:
									evt.key = evt.KEY_F4;
									break;
								  case 63240:
									evt.key = evt.KEY_F5;
									break;
								  case 63241:
									evt.key = evt.KEY_F6;
									break;
								  case 63242:
									evt.key = evt.KEY_F7;
									break;
								  case 63243:
									evt.key = evt.KEY_F8;
									break;
								  case 63244:
									evt.key = evt.KEY_F9;
									break;
								  case 63245:
									evt.key = evt.KEY_F10;
									break;
								  case 63246:
									evt.key = evt.KEY_F11;
									break;
								  case 63247:
									evt.key = evt.KEY_F12;
									break;
								  case 63250:
									evt.key = evt.KEY_PAUSE;
									break;
								  case 63272:
									evt.key = evt.KEY_DELETE;
									break;
								  case 63273:
									evt.key = evt.KEY_HOME;
									break;
								  case 63275:
									evt.key = evt.KEY_END;
									break;
								  case 63276:
									evt.key = evt.KEY_PAGE_UP;
									break;
								  case 63277:
									evt.key = evt.KEY_PAGE_DOWN;
									break;
								  case 63302:
									evt.key = evt.KEY_INSERT;
									break;
								  case 63248:
								  case 63249:
								  case 63289:
									break;
								  default:
									evt.key = evt.charCode >= evt.KEY_SPACE ? String.fromCharCode(evt.charCode) : evt.keyCode;
								}
							} else {
								evt.key = evt.charCode > 0 ? String.fromCharCode(evt.charCode) : evt.keyCode;
							}
						}
					}
				}
			}
		}
		if (dojo.render.html.ie) {
			if (!evt.target) {
				evt.target = evt.srcElement;
			}
			if (!evt.currentTarget) {
				evt.currentTarget = (sender ? sender : evt.srcElement);
			}
			if (!evt.layerX) {
				evt.layerX = evt.offsetX;
			}
			if (!evt.layerY) {
				evt.layerY = evt.offsetY;
			}
			var doc = (evt.srcElement && evt.srcElement.ownerDocument) ? evt.srcElement.ownerDocument : document;
			var docBody = ((dojo.render.html.ie55) || (doc["compatMode"] == "BackCompat")) ? doc.body : doc.documentElement;
			if (!evt.pageX) {
				evt.pageX = evt.clientX + (docBody.scrollLeft || 0);
			}
			if (!evt.pageY) {
				evt.pageY = evt.clientY + (docBody.scrollTop || 0);
			}
			if (evt.type == "mouseover") {
				evt.relatedTarget = evt.fromElement;
			}
			if (evt.type == "mouseout") {
				evt.relatedTarget = evt.toElement;
			}
			this.currentEvent = evt;
			evt.callListener = this.callListener;
			evt.stopPropagation = this._stopPropagation;
			evt.preventDefault = this._preventDefault;
		}
		return evt;
	};
	this.stopEvent = function (evt) {
		if (window.event) {
			evt.cancelBubble = true;
			evt.returnValue = false;
		} else {
			evt.preventDefault();
			evt.stopPropagation();
		}
	};
};


__CPAN_FILE__ src/event/topic.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.require("dojo.event.common");
dojo.provide("dojo.event.topic");
dojo.event.topic = new function () {
	this.topics = {};
	this.getTopic = function (topic) {
		if (!this.topics[topic]) {
			this.topics[topic] = new this.TopicImpl(topic);
		}
		return this.topics[topic];
	};
	this.registerPublisher = function (topic, obj, funcName) {
		var topic = this.getTopic(topic);
		topic.registerPublisher(obj, funcName);
	};
	this.subscribe = function (topic, obj, funcName) {
		var topic = this.getTopic(topic);
		topic.subscribe(obj, funcName);
	};
	this.unsubscribe = function (topic, obj, funcName) {
		var topic = this.getTopic(topic);
		topic.unsubscribe(obj, funcName);
	};
	this.destroy = function (topic) {
		this.getTopic(topic).destroy();
		delete this.topics[topic];
	};
	this.publishApply = function (topic, args) {
		var topic = this.getTopic(topic);
		topic.sendMessage.apply(topic, args);
	};
	this.publish = function (topic, message) {
		var topic = this.getTopic(topic);
		var args = [];
		for (var x = 1; x < arguments.length; x++) {
			args.push(arguments[x]);
		}
		topic.sendMessage.apply(topic, args);
	};
};
dojo.event.topic.TopicImpl = function (topicName) {
	this.topicName = topicName;
	this.subscribe = function (listenerObject, listenerMethod) {
		var tf = listenerMethod || listenerObject;
		var to = (!listenerMethod) ? dj_global : listenerObject;
		return dojo.event.kwConnect({srcObj:this, srcFunc:"sendMessage", adviceObj:to, adviceFunc:tf});
	};
	this.unsubscribe = function (listenerObject, listenerMethod) {
		var tf = (!listenerMethod) ? listenerObject : listenerMethod;
		var to = (!listenerMethod) ? null : listenerObject;
		return dojo.event.kwDisconnect({srcObj:this, srcFunc:"sendMessage", adviceObj:to, adviceFunc:tf});
	};
	this._getJoinPoint = function () {
		return dojo.event.MethodJoinPoint.getForMethod(this, "sendMessage");
	};
	this.setSquelch = function (shouldSquelch) {
		this._getJoinPoint().squelch = shouldSquelch;
	};
	this.destroy = function () {
		this._getJoinPoint().disconnect();
	};
	this.registerPublisher = function (publisherObject, publisherMethod) {
		dojo.event.connect(publisherObject, publisherMethod, this, "sendMessage");
	};
	this.sendMessage = function (message) {
	};
};


__CPAN_FILE__ src/event/common.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.event.common");
dojo.require("dojo.lang.array");
dojo.require("dojo.lang.extras");
dojo.require("dojo.lang.func");
dojo.event = new function () {
	this._canTimeout = dojo.lang.isFunction(dj_global["setTimeout"]) || dojo.lang.isAlien(dj_global["setTimeout"]);
	function interpolateArgs(args, searchForNames) {
		var dl = dojo.lang;
		var ao = {srcObj:dj_global, srcFunc:null, adviceObj:dj_global, adviceFunc:null, aroundObj:null, aroundFunc:null, adviceType:(args.length > 2) ? args[0] : "after", precedence:"last", once:false, delay:null, rate:0, adviceMsg:false, maxCalls:-1};
		switch (args.length) {
		  case 0:
			return;
		  case 1:
			return;
		  case 2:
			ao.srcFunc = args[0];
			ao.adviceFunc = args[1];
			break;
		  case 3:
			if ((dl.isObject(args[0])) && (dl.isString(args[1])) && (dl.isString(args[2]))) {
				ao.adviceType = "after";
				ao.srcObj = args[0];
				ao.srcFunc = args[1];
				ao.adviceFunc = args[2];
			} else {
				if ((dl.isString(args[1])) && (dl.isString(args[2]))) {
					ao.srcFunc = args[1];
					ao.adviceFunc = args[2];
				} else {
					if ((dl.isObject(args[0])) && (dl.isString(args[1])) && (dl.isFunction(args[2]))) {
						ao.adviceType = "after";
						ao.srcObj = args[0];
						ao.srcFunc = args[1];
						var tmpName = dl.nameAnonFunc(args[2], ao.adviceObj, searchForNames);
						ao.adviceFunc = tmpName;
					} else {
						if ((dl.isFunction(args[0])) && (dl.isObject(args[1])) && (dl.isString(args[2]))) {
							ao.adviceType = "after";
							ao.srcObj = dj_global;
							var tmpName = dl.nameAnonFunc(args[0], ao.srcObj, searchForNames);
							ao.srcFunc = tmpName;
							ao.adviceObj = args[1];
							ao.adviceFunc = args[2];
						}
					}
				}
			}
			break;
		  case 4:
			if ((dl.isObject(args[0])) && (dl.isObject(args[2]))) {
				ao.adviceType = "after";
				ao.srcObj = args[0];
				ao.srcFunc = args[1];
				ao.adviceObj = args[2];
				ao.adviceFunc = args[3];
			} else {
				if ((dl.isString(args[0])) && (dl.isString(args[1])) && (dl.isObject(args[2]))) {
					ao.adviceType = args[0];
					ao.srcObj = dj_global;
					ao.srcFunc = args[1];
					ao.adviceObj = args[2];
					ao.adviceFunc = args[3];
				} else {
					if ((dl.isString(args[0])) && (dl.isFunction(args[1])) && (dl.isObject(args[2]))) {
						ao.adviceType = args[0];
						ao.srcObj = dj_global;
						var tmpName = dl.nameAnonFunc(args[1], dj_global, searchForNames);
						ao.srcFunc = tmpName;
						ao.adviceObj = args[2];
						ao.adviceFunc = args[3];
					} else {
						if ((dl.isString(args[0])) && (dl.isObject(args[1])) && (dl.isString(args[2])) && (dl.isFunction(args[3]))) {
							ao.srcObj = args[1];
							ao.srcFunc = args[2];
							var tmpName = dl.nameAnonFunc(args[3], dj_global, searchForNames);
							ao.adviceObj = dj_global;
							ao.adviceFunc = tmpName;
						} else {
							if (dl.isObject(args[1])) {
								ao.srcObj = args[1];
								ao.srcFunc = args[2];
								ao.adviceObj = dj_global;
								ao.adviceFunc = args[3];
							} else {
								if (dl.isObject(args[2])) {
									ao.srcObj = dj_global;
									ao.srcFunc = args[1];
									ao.adviceObj = args[2];
									ao.adviceFunc = args[3];
								} else {
									ao.srcObj = ao.adviceObj = ao.aroundObj = dj_global;
									ao.srcFunc = args[1];
									ao.adviceFunc = args[2];
									ao.aroundFunc = args[3];
								}
							}
						}
					}
				}
			}
			break;
		  case 6:
			ao.srcObj = args[1];
			ao.srcFunc = args[2];
			ao.adviceObj = args[3];
			ao.adviceFunc = args[4];
			ao.aroundFunc = args[5];
			ao.aroundObj = dj_global;
			break;
		  default:
			ao.srcObj = args[1];
			ao.srcFunc = args[2];
			ao.adviceObj = args[3];
			ao.adviceFunc = args[4];
			ao.aroundObj = args[5];
			ao.aroundFunc = args[6];
			ao.once = args[7];
			ao.delay = args[8];
			ao.rate = args[9];
			ao.adviceMsg = args[10];
			ao.maxCalls = (!isNaN(parseInt(args[11]))) ? args[11] : -1;
			break;
		}
		if (dl.isFunction(ao.aroundFunc)) {
			var tmpName = dl.nameAnonFunc(ao.aroundFunc, ao.aroundObj, searchForNames);
			ao.aroundFunc = tmpName;
		}
		if (dl.isFunction(ao.srcFunc)) {
			ao.srcFunc = dl.getNameInObj(ao.srcObj, ao.srcFunc);
		}
		if (dl.isFunction(ao.adviceFunc)) {
			ao.adviceFunc = dl.getNameInObj(ao.adviceObj, ao.adviceFunc);
		}
		if ((ao.aroundObj) && (dl.isFunction(ao.aroundFunc))) {
			ao.aroundFunc = dl.getNameInObj(ao.aroundObj, ao.aroundFunc);
		}
		if (!ao.srcObj) {
			dojo.raise("bad srcObj for srcFunc: " + ao.srcFunc);
		}
		if (!ao.adviceObj) {
			dojo.raise("bad adviceObj for adviceFunc: " + ao.adviceFunc);
		}
		if (!ao.adviceFunc) {
			dojo.debug("bad adviceFunc for srcFunc: " + ao.srcFunc);
			dojo.debugShallow(ao);
		}
		return ao;
	}
	this.connect = function () {
		if (arguments.length == 1) {
			var ao = arguments[0];
		} else {
			var ao = interpolateArgs(arguments, true);
		}
		if (dojo.lang.isString(ao.srcFunc) && (ao.srcFunc.toLowerCase() == "onkey")) {
			if (dojo.render.html.ie) {
				ao.srcFunc = "onkeydown";
				this.connect(ao);
			}
			ao.srcFunc = "onkeypress";
		}
		if (dojo.lang.isArray(ao.srcObj) && ao.srcObj != "") {
			var tmpAO = {};
			for (var x in ao) {
				tmpAO[x] = ao[x];
			}
			var mjps = [];
			dojo.lang.forEach(ao.srcObj, function (src) {
				if ((dojo.render.html.capable) && (dojo.lang.isString(src))) {
					src = dojo.byId(src);
				}
				tmpAO.srcObj = src;
				mjps.push(dojo.event.connect.call(dojo.event, tmpAO));
			});
			return mjps;
		}
		var mjp = dojo.event.MethodJoinPoint.getForMethod(ao.srcObj, ao.srcFunc);
		if (ao.adviceFunc) {
			var mjp2 = dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj, ao.adviceFunc);
		}
		mjp.kwAddAdvice(ao);
		return mjp;
	};
	this.log = function (a1, a2) {
		var kwArgs;
		if ((arguments.length == 1) && (typeof a1 == "object")) {
			kwArgs = a1;
		} else {
			kwArgs = {srcObj:a1, srcFunc:a2};
		}
		kwArgs.adviceFunc = function () {
			var argsStr = [];
			for (var x = 0; x < arguments.length; x++) {
				argsStr.push(arguments[x]);
			}
			dojo.debug("(" + kwArgs.srcObj + ")." + kwArgs.srcFunc, ":", argsStr.join(", "));
		};
		this.kwConnect(kwArgs);
	};
	this.connectBefore = function () {
		var args = ["before"];
		for (var i = 0; i < arguments.length; i++) {
			args.push(arguments[i]);
		}
		return this.connect.apply(this, args);
	};
	this.connectAround = function () {
		var args = ["around"];
		for (var i = 0; i < arguments.length; i++) {
			args.push(arguments[i]);
		}
		return this.connect.apply(this, args);
	};
	this.connectOnce = function () {
		var ao = interpolateArgs(arguments, true);
		ao.once = true;
		return this.connect(ao);
	};
	this.connectRunOnce = function () {
		var ao = interpolateArgs(arguments, true);
		ao.maxCalls = 1;
		return this.connect(ao);
	};
	this._kwConnectImpl = function (kwArgs, disconnect) {
		var fn = (disconnect) ? "disconnect" : "connect";
		if (typeof kwArgs["srcFunc"] == "function") {
			kwArgs.srcObj = kwArgs["srcObj"] || dj_global;
			var tmpName = dojo.lang.nameAnonFunc(kwArgs.srcFunc, kwArgs.srcObj, true);
			kwArgs.srcFunc = tmpName;
		}
		if (typeof kwArgs["adviceFunc"] == "function") {
			kwArgs.adviceObj = kwArgs["adviceObj"] || dj_global;
			var tmpName = dojo.lang.nameAnonFunc(kwArgs.adviceFunc, kwArgs.adviceObj, true);
			kwArgs.adviceFunc = tmpName;
		}
		kwArgs.srcObj = kwArgs["srcObj"] || dj_global;
		kwArgs.adviceObj = kwArgs["adviceObj"] || kwArgs["targetObj"] || dj_global;
		kwArgs.adviceFunc = kwArgs["adviceFunc"] || kwArgs["targetFunc"];
		return dojo.event[fn](kwArgs);
	};
	this.kwConnect = function (kwArgs) {
		return this._kwConnectImpl(kwArgs, false);
	};
	this.disconnect = function () {
		if (arguments.length == 1) {
			var ao = arguments[0];
		} else {
			var ao = interpolateArgs(arguments, true);
		}
		if (!ao.adviceFunc) {
			return;
		}
		if (dojo.lang.isString(ao.srcFunc) && (ao.srcFunc.toLowerCase() == "onkey")) {
			if (dojo.render.html.ie) {
				ao.srcFunc = "onkeydown";
				this.disconnect(ao);
			}
			ao.srcFunc = "onkeypress";
		}
		if (!ao.srcObj[ao.srcFunc]) {
			return null;
		}
		var mjp = dojo.event.MethodJoinPoint.getForMethod(ao.srcObj, ao.srcFunc, true);
		mjp.removeAdvice(ao.adviceObj, ao.adviceFunc, ao.adviceType, ao.once);
		return mjp;
	};
	this.kwDisconnect = function (kwArgs) {
		return this._kwConnectImpl(kwArgs, true);
	};
};
dojo.event.MethodInvocation = function (join_point, obj, args) {
	this.jp_ = join_point;
	this.object = obj;
	this.args = [];
	for (var x = 0; x < args.length; x++) {
		this.args[x] = args[x];
	}
	this.around_index = -1;
};
dojo.event.MethodInvocation.prototype.proceed = function () {
	this.around_index++;
	if (this.around_index >= this.jp_.around.length) {
		return this.jp_.object[this.jp_.methodname].apply(this.jp_.object, this.args);
	} else {
		var ti = this.jp_.around[this.around_index];
		var mobj = ti[0] || dj_global;
		var meth = ti[1];
		return mobj[meth].call(mobj, this);
	}
};
dojo.event.MethodJoinPoint = function (obj, funcName) {
	this.object = obj || dj_global;
	this.methodname = funcName;
	this.methodfunc = this.object[funcName];
	this.squelch = false;
};
dojo.event.MethodJoinPoint.getForMethod = function (obj, funcName) {
	if (!obj) {
		obj = dj_global;
	}
	var ofn = obj[funcName];
	if (!ofn) {
		ofn = obj[funcName] = function () {
		};
		if (!obj[funcName]) {
			dojo.raise("Cannot set do-nothing method on that object " + funcName);
		}
	} else {
		if ((typeof ofn != "function") && (!dojo.lang.isFunction(ofn)) && (!dojo.lang.isAlien(ofn))) {
			return null;
		}
	}
	var jpname = funcName + "$joinpoint";
	var jpfuncname = funcName + "$joinpoint$method";
	var joinpoint = obj[jpname];
	if (!joinpoint) {
		var isNode = false;
		if (dojo.event["browser"]) {
			if ((obj["attachEvent"]) || (obj["nodeType"]) || (obj["addEventListener"])) {
				isNode = true;
				dojo.event.browser.addClobberNodeAttrs(obj, [jpname, jpfuncname, funcName]);
			}
		}
		var origArity = ofn.length;
		obj[jpfuncname] = ofn;
		joinpoint = obj[jpname] = new dojo.event.MethodJoinPoint(obj, jpfuncname);
		if (!isNode) {
			obj[funcName] = function () {
				return joinpoint.run.apply(joinpoint, arguments);
			};
		} else {
			obj[funcName] = function () {
				var args = [];
				if (!arguments.length) {
					var evt = null;
					try {
						if (obj.ownerDocument) {
							evt = obj.ownerDocument.parentWindow.event;
						} else {
							if (obj.documentElement) {
								evt = obj.documentElement.ownerDocument.parentWindow.event;
							} else {
								if (obj.event) {
									evt = obj.event;
								} else {
									evt = window.event;
								}
							}
						}
					}
					catch (e) {
						evt = window.event;
					}
					if (evt) {
						args.push(dojo.event.browser.fixEvent(evt, this));
					}
				} else {
					for (var x = 0; x < arguments.length; x++) {
						if ((x == 0) && (dojo.event.browser.isEvent(arguments[x]))) {
							args.push(dojo.event.browser.fixEvent(arguments[x], this));
						} else {
							args.push(arguments[x]);
						}
					}
				}
				return joinpoint.run.apply(joinpoint, args);
			};
		}
		obj[funcName].__preJoinArity = origArity;
	}
	return joinpoint;
};
dojo.lang.extend(dojo.event.MethodJoinPoint, {squelch:false, unintercept:function () {
	this.object[this.methodname] = this.methodfunc;
	this.before = [];
	this.after = [];
	this.around = [];
}, disconnect:dojo.lang.forward("unintercept"), run:function () {
	var obj = this.object || dj_global;
	var args = arguments;
	var aargs = [];
	for (var x = 0; x < args.length; x++) {
		aargs[x] = args[x];
	}
	var unrollAdvice = function (marr) {
		if (!marr) {
			dojo.debug("Null argument to unrollAdvice()");
			return;
		}
		var callObj = marr[0] || dj_global;
		var callFunc = marr[1];
		if (!callObj[callFunc]) {
			dojo.raise("function \"" + callFunc + "\" does not exist on \"" + callObj + "\"");
		}
		var aroundObj = marr[2] || dj_global;
		var aroundFunc = marr[3];
		var msg = marr[6];
		var maxCount = marr[7];
		if (maxCount > -1) {
			if (maxCount == 0) {
				return;
			}
			marr[7]--;
		}
		var undef;
		var to = {args:[], jp_:this, object:obj, proceed:function () {
			return callObj[callFunc].apply(callObj, to.args);
		}};
		to.args = aargs;
		var delay = parseInt(marr[4]);
		var hasDelay = ((!isNaN(delay)) && (marr[4] !== null) && (typeof marr[4] != "undefined"));
		if (marr[5]) {
			var rate = parseInt(marr[5]);
			var cur = new Date();
			var timerSet = false;
			if ((marr["last"]) && ((cur - marr.last) <= rate)) {
				if (dojo.event._canTimeout) {
					if (marr["delayTimer"]) {
						clearTimeout(marr.delayTimer);
					}
					var tod = parseInt(rate * 2);
					var mcpy = dojo.lang.shallowCopy(marr);
					marr.delayTimer = setTimeout(function () {
						mcpy[5] = 0;
						unrollAdvice(mcpy);
					}, tod);
				}
				return;
			} else {
				marr.last = cur;
			}
		}
		if (aroundFunc) {
			aroundObj[aroundFunc].call(aroundObj, to);
		} else {
			if ((hasDelay) && ((dojo.render.html) || (dojo.render.svg))) {
				dj_global["setTimeout"](function () {
					if (msg) {
						callObj[callFunc].call(callObj, to);
					} else {
						callObj[callFunc].apply(callObj, args);
					}
				}, delay);
			} else {
				if (msg) {
					callObj[callFunc].call(callObj, to);
				} else {
					callObj[callFunc].apply(callObj, args);
				}
			}
		}
	};
	var unRollSquelch = function () {
		if (this.squelch) {
			try {
				return unrollAdvice.apply(this, arguments);
			}
			catch (e) {
				dojo.debug(e);
			}
		} else {
			return unrollAdvice.apply(this, arguments);
		}
	};
	if ((this["before"]) && (this.before.length > 0)) {
		dojo.lang.forEach(this.before.concat(new Array()), unRollSquelch);
	}
	var result;
	try {
		if ((this["around"]) && (this.around.length > 0)) {
			var mi = new dojo.event.MethodInvocation(this, obj, args);
			result = mi.proceed();
		} else {
			if (this.methodfunc) {
				result = this.object[this.methodname].apply(this.object, args);
			}
		}
	}
	catch (e) {
		if (!this.squelch) {
			dojo.debug(e, "when calling", this.methodname, "on", this.object, "with arguments", args);
			dojo.raise(e);
		}
	}
	if ((this["after"]) && (this.after.length > 0)) {
		dojo.lang.forEach(this.after.concat(new Array()), unRollSquelch);
	}
	return (this.methodfunc) ? result : null;
}, getArr:function (kind) {
	var type = "after";
	if ((typeof kind == "string") && (kind.indexOf("before") != -1)) {
		type = "before";
	} else {
		if (kind == "around") {
			type = "around";
		}
	}
	if (!this[type]) {
		this[type] = [];
	}
	return this[type];
}, kwAddAdvice:function (args) {
	this.addAdvice(args["adviceObj"], args["adviceFunc"], args["aroundObj"], args["aroundFunc"], args["adviceType"], args["precedence"], args["once"], args["delay"], args["rate"], args["adviceMsg"], args["maxCalls"]);
}, addAdvice:function (thisAdviceObj, thisAdvice, thisAroundObj, thisAround, adviceType, precedence, once, delay, rate, asMessage, maxCalls) {
	var arr = this.getArr(adviceType);
	if (!arr) {
		dojo.raise("bad this: " + this);
	}
	var ao = [thisAdviceObj, thisAdvice, thisAroundObj, thisAround, delay, rate, asMessage, maxCalls];
	if (once) {
		if (this.hasAdvice(thisAdviceObj, thisAdvice, adviceType, arr) >= 0) {
			return;
		}
	}
	if (precedence == "first") {
		arr.unshift(ao);
	} else {
		arr.push(ao);
	}
}, hasAdvice:function (thisAdviceObj, thisAdvice, adviceType, arr) {
	if (!arr) {
		arr = this.getArr(adviceType);
	}
	var ind = -1;
	for (var x = 0; x < arr.length; x++) {
		var aao = (typeof thisAdvice == "object") ? (new String(thisAdvice)).toString() : thisAdvice;
		var a1o = (typeof arr[x][1] == "object") ? (new String(arr[x][1])).toString() : arr[x][1];
		if ((arr[x][0] == thisAdviceObj) && (a1o == aao)) {
			ind = x;
		}
	}
	return ind;
}, removeAdvice:function (thisAdviceObj, thisAdvice, adviceType, once) {
	var arr = this.getArr(adviceType);
	var ind = this.hasAdvice(thisAdviceObj, thisAdvice, adviceType, arr);
	if (ind == -1) {
		return false;
	}
	while (ind != -1) {
		arr.splice(ind, 1);
		if (once) {
			break;
		}
		ind = this.hasAdvice(thisAdviceObj, thisAdvice, adviceType, arr);
	}
	return true;
}});


__CPAN_FILE__ src/event/browser.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.event.browser"], ["require", "dojo.event.common"]], definePackage:function (dojo) {
	dojo.provide("dojo.event.browser");
	dojo.require("dojo.event.common");
	dojo._ie_clobber = new function () {
		this.clobberNodes = [];
		function nukeProp(node, prop) {
			try {
				node[prop] = null;
			}
			catch (e) {
			}
			try {
				delete node[prop];
			}
			catch (e) {
			}
			try {
				node.removeAttribute(prop);
			}
			catch (e) {
			}
		}
		this.clobber = function (nodeRef) {
			var na;
			var tna;
			if (nodeRef) {
				tna = nodeRef.all || nodeRef.getElementsByTagName("*");
				na = [nodeRef];
				for (var x = 0; x < tna.length; x++) {
					if (tna[x]["__doClobber__"]) {
						na.push(tna[x]);
					}
				}
			} else {
				try {
					window.onload = null;
				}
				catch (e) {
				}
				na = (this.clobberNodes.length) ? this.clobberNodes : document.all;
			}
			tna = null;
			var basis = {};
			for (var i = na.length - 1; i >= 0; i = i - 1) {
				var el = na[i];
				try {
					if (el && el["__clobberAttrs__"]) {
						for (var j = 0; j < el.__clobberAttrs__.length; j++) {
							nukeProp(el, el.__clobberAttrs__[j]);
						}
						nukeProp(el, "__clobberAttrs__");
						nukeProp(el, "__doClobber__");
					}
				}
				catch (e) {
				}
			}
			na = null;
		};
	};
	if (dojo.render.html.ie) {
		dojo.addOnUnload(function () {
			dojo._ie_clobber.clobber();
			try {
				if ((dojo["widget"]) && (dojo.widget["manager"])) {
					dojo.widget.manager.destroyAll();
				}
			}
			catch (e) {
			}
			if (dojo.widget) {
				for (var name in dojo.widget._templateCache) {
					if (dojo.widget._templateCache[name].node) {
						dojo.dom.destroyNode(dojo.widget._templateCache[name].node);
						dojo.widget._templateCache[name].node = null;
						delete dojo.widget._templateCache[name].node;
					}
				}
			}
			try {
				window.onload = null;
			}
			catch (e) {
			}
			try {
				window.onunload = null;
			}
			catch (e) {
			}
			dojo._ie_clobber.clobberNodes = [];
		});
	}
	dojo.event.browser = new function () {
		var clobberIdx = 0;
		this.normalizedEventName = function (eventName) {
			switch (eventName) {
			  case "CheckboxStateChange":
			  case "DOMAttrModified":
			  case "DOMMenuItemActive":
			  case "DOMMenuItemInactive":
			  case "DOMMouseScroll":
			  case "DOMNodeInserted":
			  case "DOMNodeRemoved":
			  case "RadioStateChange":
				return eventName;
				break;
			  default:
				var lcn = eventName.toLowerCase();
				return (lcn.indexOf("on") == 0) ? lcn.substr(2) : lcn;
				break;
			}
		};
		this.clean = function (node) {
			if (dojo.render.html.ie) {
				dojo._ie_clobber.clobber(node);
			}
		};
		this.addClobberNode = function (node) {
			if (!dojo.render.html.ie) {
				return;
			}
			if (!node["__doClobber__"]) {
				node.__doClobber__ = true;
				dojo._ie_clobber.clobberNodes.push(node);
				node.__clobberAttrs__ = [];
			}
		};
		this.addClobberNodeAttrs = function (node, props) {
			if (!dojo.render.html.ie) {
				return;
			}
			this.addClobberNode(node);
			for (var x = 0; x < props.length; x++) {
				node.__clobberAttrs__.push(props[x]);
			}
		};
		this.removeListener = function (node, evtName, fp, capture) {
			if (!capture) {
				var capture = false;
			}
			evtName = dojo.event.browser.normalizedEventName(evtName);
			if (evtName == "key") {
				if (dojo.render.html.ie) {
					this.removeListener(node, "onkeydown", fp, capture);
				}
				evtName = "keypress";
			}
			if (node.removeEventListener) {
				node.removeEventListener(evtName, fp, capture);
			}
		};
		this.addListener = function (node, evtName, fp, capture, dontFix) {
			if (!node) {
				return;
			}
			if (!capture) {
				var capture = false;
			}
			evtName = dojo.event.browser.normalizedEventName(evtName);
			if (evtName == "key") {
				if (dojo.render.html.ie) {
					this.addListener(node, "onkeydown", fp, capture, dontFix);
				}
				evtName = "keypress";
			}
			if (!dontFix) {
				var newfp = function (evt) {
					if (!evt) {
						evt = window.event;
					}
					var ret = fp(dojo.event.browser.fixEvent(evt, this));
					if (capture) {
						dojo.event.browser.stopEvent(evt);
					}
					return ret;
				};
			} else {
				newfp = fp;
			}
			if (node.addEventListener) {
				node.addEventListener(evtName, newfp, capture);
				return newfp;
			} else {
				evtName = "on" + evtName;
				if (typeof node[evtName] == "function") {
					var oldEvt = node[evtName];
					node[evtName] = function (e) {
						oldEvt(e);
						return newfp(e);
					};
				} else {
					node[evtName] = newfp;
				}
				if (dojo.render.html.ie) {
					this.addClobberNodeAttrs(node, [evtName]);
				}
				return newfp;
			}
		};
		this.isEvent = function (obj) {
			return (typeof obj != "undefined") && (obj) && (typeof Event != "undefined") && (obj.eventPhase);
		};
		this.currentEvent = null;
		this.callListener = function (listener, curTarget) {
			if (typeof listener != "function") {
				dojo.raise("listener not a function: " + listener);
			}
			dojo.event.browser.currentEvent.currentTarget = curTarget;
			return listener.call(curTarget, dojo.event.browser.currentEvent);
		};
		this._stopPropagation = function () {
			dojo.event.browser.currentEvent.cancelBubble = true;
		};
		this._preventDefault = function () {
			dojo.event.browser.currentEvent.returnValue = false;
		};
		this.keys = {KEY_BACKSPACE:8, KEY_TAB:9, KEY_CLEAR:12, KEY_ENTER:13, KEY_SHIFT:16, KEY_CTRL:17, KEY_ALT:18, KEY_PAUSE:19, KEY_CAPS_LOCK:20, KEY_ESCAPE:27, KEY_SPACE:32, KEY_PAGE_UP:33, KEY_PAGE_DOWN:34, KEY_END:35, KEY_HOME:36, KEY_LEFT_ARROW:37, KEY_UP_ARROW:38, KEY_RIGHT_ARROW:39, KEY_DOWN_ARROW:40, KEY_INSERT:45, KEY_DELETE:46, KEY_HELP:47, KEY_LEFT_WINDOW:91, KEY_RIGHT_WINDOW:92, KEY_SELECT:93, KEY_NUMPAD_0:96, KEY_NUMPAD_1:97, KEY_NUMPAD_2:98, KEY_NUMPAD_3:99, KEY_NUMPAD_4:100, KEY_NUMPAD_5:101, KEY_NUMPAD_6:102, KEY_NUMPAD_7:103, KEY_NUMPAD_8:104, KEY_NUMPAD_9:105, KEY_NUMPAD_MULTIPLY:106, KEY_NUMPAD_PLUS:107, KEY_NUMPAD_ENTER:108, KEY_NUMPAD_MINUS:109, KEY_NUMPAD_PERIOD:110, KEY_NUMPAD_DIVIDE:111, KEY_F1:112, KEY_F2:113, KEY_F3:114, KEY_F4:115, KEY_F5:116, KEY_F6:117, KEY_F7:118, KEY_F8:119, KEY_F9:120, KEY_F10:121, KEY_F11:122, KEY_F12:123, KEY_F13:124, KEY_F14:125, KEY_F15:126, KEY_NUM_LOCK:144, KEY_SCROLL_LOCK:145};
		this.revKeys = [];
		for (var key in this.keys) {
			this.revKeys[this.keys[key]] = key;
		}
		this.fixEvent = function (evt, sender) {
			if (!evt) {
				if (window["event"]) {
					evt = window.event;
				}
			}
			if ((evt["type"]) && (evt["type"].indexOf("key") == 0)) {
				evt.keys = this.revKeys;
				for (var key in this.keys) {
					evt[key] = this.keys[key];
				}
				if (evt["type"] == "keydown" && dojo.render.html.ie) {
					switch (evt.keyCode) {
					  case evt.KEY_SHIFT:
					  case evt.KEY_CTRL:
					  case evt.KEY_ALT:
					  case evt.KEY_CAPS_LOCK:
					  case evt.KEY_LEFT_WINDOW:
					  case evt.KEY_RIGHT_WINDOW:
					  case evt.KEY_SELECT:
					  case evt.KEY_NUM_LOCK:
					  case evt.KEY_SCROLL_LOCK:
					  case evt.KEY_NUMPAD_0:
					  case evt.KEY_NUMPAD_1:
					  case evt.KEY_NUMPAD_2:
					  case evt.KEY_NUMPAD_3:
					  case evt.KEY_NUMPAD_4:
					  case evt.KEY_NUMPAD_5:
					  case evt.KEY_NUMPAD_6:
					  case evt.KEY_NUMPAD_7:
					  case evt.KEY_NUMPAD_8:
					  case evt.KEY_NUMPAD_9:
					  case evt.KEY_NUMPAD_PERIOD:
						break;
					  case evt.KEY_NUMPAD_MULTIPLY:
					  case evt.KEY_NUMPAD_PLUS:
					  case evt.KEY_NUMPAD_ENTER:
					  case evt.KEY_NUMPAD_MINUS:
					  case evt.KEY_NUMPAD_DIVIDE:
						break;
					  case evt.KEY_PAUSE:
					  case evt.KEY_TAB:
					  case evt.KEY_BACKSPACE:
					  case evt.KEY_ENTER:
					  case evt.KEY_ESCAPE:
					  case evt.KEY_PAGE_UP:
					  case evt.KEY_PAGE_DOWN:
					  case evt.KEY_END:
					  case evt.KEY_HOME:
					  case evt.KEY_LEFT_ARROW:
					  case evt.KEY_UP_ARROW:
					  case evt.KEY_RIGHT_ARROW:
					  case evt.KEY_DOWN_ARROW:
					  case evt.KEY_INSERT:
					  case evt.KEY_DELETE:
					  case evt.KEY_F1:
					  case evt.KEY_F2:
					  case evt.KEY_F3:
					  case evt.KEY_F4:
					  case evt.KEY_F5:
					  case evt.KEY_F6:
					  case evt.KEY_F7:
					  case evt.KEY_F8:
					  case evt.KEY_F9:
					  case evt.KEY_F10:
					  case evt.KEY_F11:
					  case evt.KEY_F12:
					  case evt.KEY_F12:
					  case evt.KEY_F13:
					  case evt.KEY_F14:
					  case evt.KEY_F15:
					  case evt.KEY_CLEAR:
					  case evt.KEY_HELP:
						evt.key = evt.keyCode;
						break;
					  default:
						if (evt.ctrlKey || evt.altKey) {
							var unifiedCharCode = evt.keyCode;
							if (unifiedCharCode >= 65 && unifiedCharCode <= 90 && evt.shiftKey == false) {
								unifiedCharCode += 32;
							}
							if (unifiedCharCode >= 1 && unifiedCharCode <= 26 && evt.ctrlKey) {
								unifiedCharCode += 96;
							}
							evt.key = String.fromCharCode(unifiedCharCode);
						}
					}
				} else {
					if (evt["type"] == "keypress") {
						if (dojo.render.html.opera) {
							if (evt.which == 0) {
								evt.key = evt.keyCode;
							} else {
								if (evt.which > 0) {
									switch (evt.which) {
									  case evt.KEY_SHIFT:
									  case evt.KEY_CTRL:
									  case evt.KEY_ALT:
									  case evt.KEY_CAPS_LOCK:
									  case evt.KEY_NUM_LOCK:
									  case evt.KEY_SCROLL_LOCK:
										break;
									  case evt.KEY_PAUSE:
									  case evt.KEY_TAB:
									  case evt.KEY_BACKSPACE:
									  case evt.KEY_ENTER:
									  case evt.KEY_ESCAPE:
										evt.key = evt.which;
										break;
									  default:
										var unifiedCharCode = evt.which;
										if ((evt.ctrlKey || evt.altKey || evt.metaKey) && (evt.which >= 65 && evt.which <= 90 && evt.shiftKey == false)) {
											unifiedCharCode += 32;
										}
										evt.key = String.fromCharCode(unifiedCharCode);
									}
								}
							}
						} else {
							if (dojo.render.html.ie) {
								if (!evt.ctrlKey && !evt.altKey && evt.keyCode >= evt.KEY_SPACE) {
									evt.key = String.fromCharCode(evt.keyCode);
								}
							} else {
								if (dojo.render.html.safari) {
									switch (evt.keyCode) {
									  case 25:
										evt.key = evt.KEY_TAB;
										evt.shift = true;
										break;
									  case 63232:
										evt.key = evt.KEY_UP_ARROW;
										break;
									  case 63233:
										evt.key = evt.KEY_DOWN_ARROW;
										break;
									  case 63234:
										evt.key = evt.KEY_LEFT_ARROW;
										break;
									  case 63235:
										evt.key = evt.KEY_RIGHT_ARROW;
										break;
									  case 63236:
										evt.key = evt.KEY_F1;
										break;
									  case 63237:
										evt.key = evt.KEY_F2;
										break;
									  case 63238:
										evt.key = evt.KEY_F3;
										break;
									  case 63239:
										evt.key = evt.KEY_F4;
										break;
									  case 63240:
										evt.key = evt.KEY_F5;
										break;
									  case 63241:
										evt.key = evt.KEY_F6;
										break;
									  case 63242:
										evt.key = evt.KEY_F7;
										break;
									  case 63243:
										evt.key = evt.KEY_F8;
										break;
									  case 63244:
										evt.key = evt.KEY_F9;
										break;
									  case 63245:
										evt.key = evt.KEY_F10;
										break;
									  case 63246:
										evt.key = evt.KEY_F11;
										break;
									  case 63247:
										evt.key = evt.KEY_F12;
										break;
									  case 63250:
										evt.key = evt.KEY_PAUSE;
										break;
									  case 63272:
										evt.key = evt.KEY_DELETE;
										break;
									  case 63273:
										evt.key = evt.KEY_HOME;
										break;
									  case 63275:
										evt.key = evt.KEY_END;
										break;
									  case 63276:
										evt.key = evt.KEY_PAGE_UP;
										break;
									  case 63277:
										evt.key = evt.KEY_PAGE_DOWN;
										break;
									  case 63302:
										evt.key = evt.KEY_INSERT;
										break;
									  case 63248:
									  case 63249:
									  case 63289:
										break;
									  default:
										evt.key = evt.charCode >= evt.KEY_SPACE ? String.fromCharCode(evt.charCode) : evt.keyCode;
									}
								} else {
									evt.key = evt.charCode > 0 ? String.fromCharCode(evt.charCode) : evt.keyCode;
								}
							}
						}
					}
				}
			}
			if (dojo.render.html.ie) {
				if (!evt.target) {
					evt.target = evt.srcElement;
				}
				if (!evt.currentTarget) {
					evt.currentTarget = (sender ? sender : evt.srcElement);
				}
				if (!evt.layerX) {
					evt.layerX = evt.offsetX;
				}
				if (!evt.layerY) {
					evt.layerY = evt.offsetY;
				}
				var doc = (evt.srcElement && evt.srcElement.ownerDocument) ? evt.srcElement.ownerDocument : document;
				var docBody = ((dojo.render.html.ie55) || (doc["compatMode"] == "BackCompat")) ? doc.body : doc.documentElement;
				if (!evt.pageX) {
					evt.pageX = evt.clientX + (docBody.scrollLeft || 0);
				}
				if (!evt.pageY) {
					evt.pageY = evt.clientY + (docBody.scrollTop || 0);
				}
				if (evt.type == "mouseover") {
					evt.relatedTarget = evt.fromElement;
				}
				if (evt.type == "mouseout") {
					evt.relatedTarget = evt.toElement;
				}
				this.currentEvent = evt;
				evt.callListener = this.callListener;
				evt.stopPropagation = this._stopPropagation;
				evt.preventDefault = this._preventDefault;
			}
			return evt;
		};
		this.stopEvent = function (evt) {
			if (window.event) {
				evt.cancelBubble = true;
				evt.returnValue = false;
			} else {
				evt.preventDefault();
				evt.stopPropagation();
			}
		};
	};
}});


__CPAN_FILE__ src/event/__package__.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.kwCompoundRequire({common:["dojo.event.common", "dojo.event.topic"], browser:["dojo.event.browser"], dashboard:["dojo.event.browser"]});
dojo.provide("dojo.event.*");


__CPAN_FILE__ src/event/topic.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["require", "dojo.event.common"], ["provide", "dojo.event.topic"]], definePackage:function (dojo) {
	dojo.require("dojo.event.common");
	dojo.provide("dojo.event.topic");
	dojo.event.topic = new function () {
		this.topics = {};
		this.getTopic = function (topic) {
			if (!this.topics[topic]) {
				this.topics[topic] = new this.TopicImpl(topic);
			}
			return this.topics[topic];
		};
		this.registerPublisher = function (topic, obj, funcName) {
			var topic = this.getTopic(topic);
			topic.registerPublisher(obj, funcName);
		};
		this.subscribe = function (topic, obj, funcName) {
			var topic = this.getTopic(topic);
			topic.subscribe(obj, funcName);
		};
		this.unsubscribe = function (topic, obj, funcName) {
			var topic = this.getTopic(topic);
			topic.unsubscribe(obj, funcName);
		};
		this.destroy = function (topic) {
			this.getTopic(topic).destroy();
			delete this.topics[topic];
		};
		this.publishApply = function (topic, args) {
			var topic = this.getTopic(topic);
			topic.sendMessage.apply(topic, args);
		};
		this.publish = function (topic, message) {
			var topic = this.getTopic(topic);
			var args = [];
			for (var x = 1; x < arguments.length; x++) {
				args.push(arguments[x]);
			}
			topic.sendMessage.apply(topic, args);
		};
	};
	dojo.event.topic.TopicImpl = function (topicName) {
		this.topicName = topicName;
		this.subscribe = function (listenerObject, listenerMethod) {
			var tf = listenerMethod || listenerObject;
			var to = (!listenerMethod) ? dj_global : listenerObject;
			return dojo.event.kwConnect({srcObj:this, srcFunc:"sendMessage", adviceObj:to, adviceFunc:tf});
		};
		this.unsubscribe = function (listenerObject, listenerMethod) {
			var tf = (!listenerMethod) ? listenerObject : listenerMethod;
			var to = (!listenerMethod) ? null : listenerObject;
			return dojo.event.kwDisconnect({srcObj:this, srcFunc:"sendMessage", adviceObj:to, adviceFunc:tf});
		};
		this._getJoinPoint = function () {
			return dojo.event.MethodJoinPoint.getForMethod(this, "sendMessage");
		};
		this.setSquelch = function (shouldSquelch) {
			this._getJoinPoint().squelch = shouldSquelch;
		};
		this.destroy = function () {
			this._getJoinPoint().disconnect();
		};
		this.registerPublisher = function (publisherObject, publisherMethod) {
			dojo.event.connect(publisherObject, publisherMethod, this, "sendMessage");
		};
		this.sendMessage = function (message) {
		};
	};
}});


__CPAN_FILE__ src/event/__package__.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["kwCompoundRequire", {common:["dojo.event.common", "dojo.event.topic"], browser:["dojo.event.browser"], dashboard:["dojo.event.browser"]}], ["provide", "dojo.event.*"]], definePackage:function (dojo) {
	dojo.kwCompoundRequire({common:["dojo.event.common", "dojo.event.topic"], browser:["dojo.event.browser"], dashboard:["dojo.event.browser"]});
	dojo.provide("dojo.event.*");
}});


__CPAN_FILE__ src/event/common.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.event.common"], ["require", "dojo.lang.array"], ["require", "dojo.lang.extras"], ["require", "dojo.lang.func"]], definePackage:function (dojo) {
	dojo.provide("dojo.event.common");
	dojo.require("dojo.lang.array");
	dojo.require("dojo.lang.extras");
	dojo.require("dojo.lang.func");
	dojo.event = new function () {
		this._canTimeout = dojo.lang.isFunction(dj_global["setTimeout"]) || dojo.lang.isAlien(dj_global["setTimeout"]);
		function interpolateArgs(args, searchForNames) {
			var dl = dojo.lang;
			var ao = {srcObj:dj_global, srcFunc:null, adviceObj:dj_global, adviceFunc:null, aroundObj:null, aroundFunc:null, adviceType:(args.length > 2) ? args[0] : "after", precedence:"last", once:false, delay:null, rate:0, adviceMsg:false, maxCalls:-1};
			switch (args.length) {
			  case 0:
				return;
			  case 1:
				return;
			  case 2:
				ao.srcFunc = args[0];
				ao.adviceFunc = args[1];
				break;
			  case 3:
				if ((dl.isObject(args[0])) && (dl.isString(args[1])) && (dl.isString(args[2]))) {
					ao.adviceType = "after";
					ao.srcObj = args[0];
					ao.srcFunc = args[1];
					ao.adviceFunc = args[2];
				} else {
					if ((dl.isString(args[1])) && (dl.isString(args[2]))) {
						ao.srcFunc = args[1];
						ao.adviceFunc = args[2];
					} else {
						if ((dl.isObject(args[0])) && (dl.isString(args[1])) && (dl.isFunction(args[2]))) {
							ao.adviceType = "after";
							ao.srcObj = args[0];
							ao.srcFunc = args[1];
							var tmpName = dl.nameAnonFunc(args[2], ao.adviceObj, searchForNames);
							ao.adviceFunc = tmpName;
						} else {
							if ((dl.isFunction(args[0])) && (dl.isObject(args[1])) && (dl.isString(args[2]))) {
								ao.adviceType = "after";
								ao.srcObj = dj_global;
								var tmpName = dl.nameAnonFunc(args[0], ao.srcObj, searchForNames);
								ao.srcFunc = tmpName;
								ao.adviceObj = args[1];
								ao.adviceFunc = args[2];
							}
						}
					}
				}
				break;
			  case 4:
				if ((dl.isObject(args[0])) && (dl.isObject(args[2]))) {
					ao.adviceType = "after";
					ao.srcObj = args[0];
					ao.srcFunc = args[1];
					ao.adviceObj = args[2];
					ao.adviceFunc = args[3];
				} else {
					if ((dl.isString(args[0])) && (dl.isString(args[1])) && (dl.isObject(args[2]))) {
						ao.adviceType = args[0];
						ao.srcObj = dj_global;
						ao.srcFunc = args[1];
						ao.adviceObj = args[2];
						ao.adviceFunc = args[3];
					} else {
						if ((dl.isString(args[0])) && (dl.isFunction(args[1])) && (dl.isObject(args[2]))) {
							ao.adviceType = args[0];
							ao.srcObj = dj_global;
							var tmpName = dl.nameAnonFunc(args[1], dj_global, searchForNames);
							ao.srcFunc = tmpName;
							ao.adviceObj = args[2];
							ao.adviceFunc = args[3];
						} else {
							if ((dl.isString(args[0])) && (dl.isObject(args[1])) && (dl.isString(args[2])) && (dl.isFunction(args[3]))) {
								ao.srcObj = args[1];
								ao.srcFunc = args[2];
								var tmpName = dl.nameAnonFunc(args[3], dj_global, searchForNames);
								ao.adviceObj = dj_global;
								ao.adviceFunc = tmpName;
							} else {
								if (dl.isObject(args[1])) {
									ao.srcObj = args[1];
									ao.srcFunc = args[2];
									ao.adviceObj = dj_global;
									ao.adviceFunc = args[3];
								} else {
									if (dl.isObject(args[2])) {
										ao.srcObj = dj_global;
										ao.srcFunc = args[1];
										ao.adviceObj = args[2];
										ao.adviceFunc = args[3];
									} else {
										ao.srcObj = ao.adviceObj = ao.aroundObj = dj_global;
										ao.srcFunc = args[1];
										ao.adviceFunc = args[2];
										ao.aroundFunc = args[3];
									}
								}
							}
						}
					}
				}
				break;
			  case 6:
				ao.srcObj = args[1];
				ao.srcFunc = args[2];
				ao.adviceObj = args[3];
				ao.adviceFunc = args[4];
				ao.aroundFunc = args[5];
				ao.aroundObj = dj_global;
				break;
			  default:
				ao.srcObj = args[1];
				ao.srcFunc = args[2];
				ao.adviceObj = args[3];
				ao.adviceFunc = args[4];
				ao.aroundObj = args[5];
				ao.aroundFunc = args[6];
				ao.once = args[7];
				ao.delay = args[8];
				ao.rate = args[9];
				ao.adviceMsg = args[10];
				ao.maxCalls = (!isNaN(parseInt(args[11]))) ? args[11] : -1;
				break;
			}
			if (dl.isFunction(ao.aroundFunc)) {
				var tmpName = dl.nameAnonFunc(ao.aroundFunc, ao.aroundObj, searchForNames);
				ao.aroundFunc = tmpName;
			}
			if (dl.isFunction(ao.srcFunc)) {
				ao.srcFunc = dl.getNameInObj(ao.srcObj, ao.srcFunc);
			}
			if (dl.isFunction(ao.adviceFunc)) {
				ao.adviceFunc = dl.getNameInObj(ao.adviceObj, ao.adviceFunc);
			}
			if ((ao.aroundObj) && (dl.isFunction(ao.aroundFunc))) {
				ao.aroundFunc = dl.getNameInObj(ao.aroundObj, ao.aroundFunc);
			}
			if (!ao.srcObj) {
				dojo.raise("bad srcObj for srcFunc: " + ao.srcFunc);
			}
			if (!ao.adviceObj) {
				dojo.raise("bad adviceObj for adviceFunc: " + ao.adviceFunc);
			}
			if (!ao.adviceFunc) {
				dojo.debug("bad adviceFunc for srcFunc: " + ao.srcFunc);
				dojo.debugShallow(ao);
			}
			return ao;
		}
		this.connect = function () {
			if (arguments.length == 1) {
				var ao = arguments[0];
			} else {
				var ao = interpolateArgs(arguments, true);
			}
			if (dojo.lang.isString(ao.srcFunc) && (ao.srcFunc.toLowerCase() == "onkey")) {
				if (dojo.render.html.ie) {
					ao.srcFunc = "onkeydown";
					this.connect(ao);
				}
				ao.srcFunc = "onkeypress";
			}
			if (dojo.lang.isArray(ao.srcObj) && ao.srcObj != "") {
				var tmpAO = {};
				for (var x in ao) {
					tmpAO[x] = ao[x];
				}
				var mjps = [];
				dojo.lang.forEach(ao.srcObj, function (src) {
					if ((dojo.render.html.capable) && (dojo.lang.isString(src))) {
						src = dojo.byId(src);
					}
					tmpAO.srcObj = src;
					mjps.push(dojo.event.connect.call(dojo.event, tmpAO));
				});
				return mjps;
			}
			var mjp = dojo.event.MethodJoinPoint.getForMethod(ao.srcObj, ao.srcFunc);
			if (ao.adviceFunc) {
				var mjp2 = dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj, ao.adviceFunc);
			}
			mjp.kwAddAdvice(ao);
			return mjp;
		};
		this.log = function (a1, a2) {
			var kwArgs;
			if ((arguments.length == 1) && (typeof a1 == "object")) {
				kwArgs = a1;
			} else {
				kwArgs = {srcObj:a1, srcFunc:a2};
			}
			kwArgs.adviceFunc = function () {
				var argsStr = [];
				for (var x = 0; x < arguments.length; x++) {
					argsStr.push(arguments[x]);
				}
				dojo.debug("(" + kwArgs.srcObj + ")." + kwArgs.srcFunc, ":", argsStr.join(", "));
			};
			this.kwConnect(kwArgs);
		};
		this.connectBefore = function () {
			var args = ["before"];
			for (var i = 0; i < arguments.length; i++) {
				args.push(arguments[i]);
			}
			return this.connect.apply(this, args);
		};
		this.connectAround = function () {
			var args = ["around"];
			for (var i = 0; i < arguments.length; i++) {
				args.push(arguments[i]);
			}
			return this.connect.apply(this, args);
		};
		this.connectOnce = function () {
			var ao = interpolateArgs(arguments, true);
			ao.once = true;
			return this.connect(ao);
		};
		this.connectRunOnce = function () {
			var ao = interpolateArgs(arguments, true);
			ao.maxCalls = 1;
			return this.connect(ao);
		};
		this._kwConnectImpl = function (kwArgs, disconnect) {
			var fn = (disconnect) ? "disconnect" : "connect";
			if (typeof kwArgs["srcFunc"] == "function") {
				kwArgs.srcObj = kwArgs["srcObj"] || dj_global;
				var tmpName = dojo.lang.nameAnonFunc(kwArgs.srcFunc, kwArgs.srcObj, true);
				kwArgs.srcFunc = tmpName;
			}
			if (typeof kwArgs["adviceFunc"] == "function") {
				kwArgs.adviceObj = kwArgs["adviceObj"] || dj_global;
				var tmpName = dojo.lang.nameAnonFunc(kwArgs.adviceFunc, kwArgs.adviceObj, true);
				kwArgs.adviceFunc = tmpName;
			}
			kwArgs.srcObj = kwArgs["srcObj"] || dj_global;
			kwArgs.adviceObj = kwArgs["adviceObj"] || kwArgs["targetObj"] || dj_global;
			kwArgs.adviceFunc = kwArgs["adviceFunc"] || kwArgs["targetFunc"];
			return dojo.event[fn](kwArgs);
		};
		this.kwConnect = function (kwArgs) {
			return this._kwConnectImpl(kwArgs, false);
		};
		this.disconnect = function () {
			if (arguments.length == 1) {
				var ao = arguments[0];
			} else {
				var ao = interpolateArgs(arguments, true);
			}
			if (!ao.adviceFunc) {
				return;
			}
			if (dojo.lang.isString(ao.srcFunc) && (ao.srcFunc.toLowerCase() == "onkey")) {
				if (dojo.render.html.ie) {
					ao.srcFunc = "onkeydown";
					this.disconnect(ao);
				}
				ao.srcFunc = "onkeypress";
			}
			if (!ao.srcObj[ao.srcFunc]) {
				return null;
			}
			var mjp = dojo.event.MethodJoinPoint.getForMethod(ao.srcObj, ao.srcFunc, true);
			mjp.removeAdvice(ao.adviceObj, ao.adviceFunc, ao.adviceType, ao.once);
			return mjp;
		};
		this.kwDisconnect = function (kwArgs) {
			return this._kwConnectImpl(kwArgs, true);
		};
	};
	dojo.event.MethodInvocation = function (join_point, obj, args) {
		this.jp_ = join_point;
		this.object = obj;
		this.args = [];
		for (var x = 0; x < args.length; x++) {
			this.args[x] = args[x];
		}
		this.around_index = -1;
	};
	dojo.event.MethodInvocation.prototype.proceed = function () {
		this.around_index++;
		if (this.around_index >= this.jp_.around.length) {
			return this.jp_.object[this.jp_.methodname].apply(this.jp_.object, this.args);
		} else {
			var ti = this.jp_.around[this.around_index];
			var mobj = ti[0] || dj_global;
			var meth = ti[1];
			return mobj[meth].call(mobj, this);
		}
	};
	dojo.event.MethodJoinPoint = function (obj, funcName) {
		this.object = obj || dj_global;
		this.methodname = funcName;
		this.methodfunc = this.object[funcName];
		this.squelch = false;
	};
	dojo.event.MethodJoinPoint.getForMethod = function (obj, funcName) {
		if (!obj) {
			obj = dj_global;
		}
		var ofn = obj[funcName];
		if (!ofn) {
			ofn = obj[funcName] = function () {
			};
			if (!obj[funcName]) {
				dojo.raise("Cannot set do-nothing method on that object " + funcName);
			}
		} else {
			if ((typeof ofn != "function") && (!dojo.lang.isFunction(ofn)) && (!dojo.lang.isAlien(ofn))) {
				return null;
			}
		}
		var jpname = funcName + "$joinpoint";
		var jpfuncname = funcName + "$joinpoint$method";
		var joinpoint = obj[jpname];
		if (!joinpoint) {
			var isNode = false;
			if (dojo.event["browser"]) {
				if ((obj["attachEvent"]) || (obj["nodeType"]) || (obj["addEventListener"])) {
					isNode = true;
					dojo.event.browser.addClobberNodeAttrs(obj, [jpname, jpfuncname, funcName]);
				}
			}
			var origArity = ofn.length;
			obj[jpfuncname] = ofn;
			joinpoint = obj[jpname] = new dojo.event.MethodJoinPoint(obj, jpfuncname);
			if (!isNode) {
				obj[funcName] = function () {
					return joinpoint.run.apply(joinpoint, arguments);
				};
			} else {
				obj[funcName] = function () {
					var args = [];
					if (!arguments.length) {
						var evt = null;
						try {
							if (obj.ownerDocument) {
								evt = obj.ownerDocument.parentWindow.event;
							} else {
								if (obj.documentElement) {
									evt = obj.documentElement.ownerDocument.parentWindow.event;
								} else {
									if (obj.event) {
										evt = obj.event;
									} else {
										evt = window.event;
									}
								}
							}
						}
						catch (e) {
							evt = window.event;
						}
						if (evt) {
							args.push(dojo.event.browser.fixEvent(evt, this));
						}
					} else {
						for (var x = 0; x < arguments.length; x++) {
							if ((x == 0) && (dojo.event.browser.isEvent(arguments[x]))) {
								args.push(dojo.event.browser.fixEvent(arguments[x], this));
							} else {
								args.push(arguments[x]);
							}
						}
					}
					return joinpoint.run.apply(joinpoint, args);
				};
			}
			obj[funcName].__preJoinArity = origArity;
		}
		return joinpoint;
	};
	dojo.lang.extend(dojo.event.MethodJoinPoint, {squelch:false, unintercept:function () {
		this.object[this.methodname] = this.methodfunc;
		this.before = [];
		this.after = [];
		this.around = [];
	}, disconnect:dojo.lang.forward("unintercept"), run:function () {
		var obj = this.object || dj_global;
		var args = arguments;
		var aargs = [];
		for (var x = 0; x < args.length; x++) {
			aargs[x] = args[x];
		}
		var unrollAdvice = function (marr) {
			if (!marr) {
				dojo.debug("Null argument to unrollAdvice()");
				return;
			}
			var callObj = marr[0] || dj_global;
			var callFunc = marr[1];
			if (!callObj[callFunc]) {
				dojo.raise("function \"" + callFunc + "\" does not exist on \"" + callObj + "\"");
			}
			var aroundObj = marr[2] || dj_global;
			var aroundFunc = marr[3];
			var msg = marr[6];
			var maxCount = marr[7];
			if (maxCount > -1) {
				if (maxCount == 0) {
					return;
				}
				marr[7]--;
			}
			var undef;
			var to = {args:[], jp_:this, object:obj, proceed:function () {
				return callObj[callFunc].apply(callObj, to.args);
			}};
			to.args = aargs;
			var delay = parseInt(marr[4]);
			var hasDelay = ((!isNaN(delay)) && (marr[4] !== null) && (typeof marr[4] != "undefined"));
			if (marr[5]) {
				var rate = parseInt(marr[5]);
				var cur = new Date();
				var timerSet = false;
				if ((marr["last"]) && ((cur - marr.last) <= rate)) {
					if (dojo.event._canTimeout) {
						if (marr["delayTimer"]) {
							clearTimeout(marr.delayTimer);
						}
						var tod = parseInt(rate * 2);
						var mcpy = dojo.lang.shallowCopy(marr);
						marr.delayTimer = setTimeout(function () {
							mcpy[5] = 0;
							unrollAdvice(mcpy);
						}, tod);
					}
					return;
				} else {
					marr.last = cur;
				}
			}
			if (aroundFunc) {
				aroundObj[aroundFunc].call(aroundObj, to);
			} else {
				if ((hasDelay) && ((dojo.render.html) || (dojo.render.svg))) {
					dj_global["setTimeout"](function () {
						if (msg) {
							callObj[callFunc].call(callObj, to);
						} else {
							callObj[callFunc].apply(callObj, args);
						}
					}, delay);
				} else {
					if (msg) {
						callObj[callFunc].call(callObj, to);
					} else {
						callObj[callFunc].apply(callObj, args);
					}
				}
			}
		};
		var unRollSquelch = function () {
			if (this.squelch) {
				try {
					return unrollAdvice.apply(this, arguments);
				}
				catch (e) {
					dojo.debug(e);
				}
			} else {
				return unrollAdvice.apply(this, arguments);
			}
		};
		if ((this["before"]) && (this.before.length > 0)) {
			dojo.lang.forEach(this.before.concat(new Array()), unRollSquelch);
		}
		var result;
		try {
			if ((this["around"]) && (this.around.length > 0)) {
				var mi = new dojo.event.MethodInvocation(this, obj, args);
				result = mi.proceed();
			} else {
				if (this.methodfunc) {
					result = this.object[this.methodname].apply(this.object, args);
				}
			}
		}
		catch (e) {
			if (!this.squelch) {
				dojo.debug(e, "when calling", this.methodname, "on", this.object, "with arguments", args);
				dojo.raise(e);
			}
		}
		if ((this["after"]) && (this.after.length > 0)) {
			dojo.lang.forEach(this.after.concat(new Array()), unRollSquelch);
		}
		return (this.methodfunc) ? result : null;
	}, getArr:function (kind) {
		var type = "after";
		if ((typeof kind == "string") && (kind.indexOf("before") != -1)) {
			type = "before";
		} else {
			if (kind == "around") {
				type = "around";
			}
		}
		if (!this[type]) {
			this[type] = [];
		}
		return this[type];
	}, kwAddAdvice:function (args) {
		this.addAdvice(args["adviceObj"], args["adviceFunc"], args["aroundObj"], args["aroundFunc"], args["adviceType"], args["precedence"], args["once"], args["delay"], args["rate"], args["adviceMsg"], args["maxCalls"]);
	}, addAdvice:function (thisAdviceObj, thisAdvice, thisAroundObj, thisAround, adviceType, precedence, once, delay, rate, asMessage, maxCalls) {
		var arr = this.getArr(adviceType);
		if (!arr) {
			dojo.raise("bad this: " + this);
		}
		var ao = [thisAdviceObj, thisAdvice, thisAroundObj, thisAround, delay, rate, asMessage, maxCalls];
		if (once) {
			if (this.hasAdvice(thisAdviceObj, thisAdvice, adviceType, arr) >= 0) {
				return;
			}
		}
		if (precedence == "first") {
			arr.unshift(ao);
		} else {
			arr.push(ao);
		}
	}, hasAdvice:function (thisAdviceObj, thisAdvice, adviceType, arr) {
		if (!arr) {
			arr = this.getArr(adviceType);
		}
		var ind = -1;
		for (var x = 0; x < arr.length; x++) {
			var aao = (typeof thisAdvice == "object") ? (new String(thisAdvice)).toString() : thisAdvice;
			var a1o = (typeof arr[x][1] == "object") ? (new String(arr[x][1])).toString() : arr[x][1];
			if ((arr[x][0] == thisAdviceObj) && (a1o == aao)) {
				ind = x;
			}
		}
		return ind;
	}, removeAdvice:function (thisAdviceObj, thisAdvice, adviceType, once) {
		var arr = this.getArr(adviceType);
		var ind = this.hasAdvice(thisAdviceObj, thisAdvice, adviceType, arr);
		if (ind == -1) {
			return false;
		}
		while (ind != -1) {
			arr.splice(ind, 1);
			if (once) {
				break;
			}
			ind = this.hasAdvice(thisAdviceObj, thisAdvice, adviceType, arr);
		}
		return true;
	}});
}});


__CPAN_DIR__ src/dnd
__CPAN_FILE__ src/dnd/DragAndDrop.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.require("dojo.lang.common");
dojo.require("dojo.lang.func");
dojo.require("dojo.lang.declare");
dojo.provide("dojo.dnd.DragAndDrop");
dojo.declare("dojo.dnd.DragSource", null, {type:"", onDragEnd:function (evt) {
}, onDragStart:function (evt) {
}, onSelected:function (evt) {
}, unregister:function () {
	dojo.dnd.dragManager.unregisterDragSource(this);
}, reregister:function () {
	dojo.dnd.dragManager.registerDragSource(this);
}});
dojo.declare("dojo.dnd.DragObject", null, {type:"", register:function () {
	var dm = dojo.dnd.dragManager;
	if (dm["registerDragObject"]) {
		dm.registerDragObject(this);
	}
}, onDragStart:function (evt) {
}, onDragMove:function (evt) {
}, onDragOver:function (evt) {
}, onDragOut:function (evt) {
}, onDragEnd:function (evt) {
}, onDragLeave:dojo.lang.forward("onDragOut"), onDragEnter:dojo.lang.forward("onDragOver"), ondragout:dojo.lang.forward("onDragOut"), ondragover:dojo.lang.forward("onDragOver")});
dojo.declare("dojo.dnd.DropTarget", null, {acceptsType:function (type) {
	if (!dojo.lang.inArray(this.acceptedTypes, "*")) {
		if (!dojo.lang.inArray(this.acceptedTypes, type)) {
			return false;
		}
	}
	return true;
}, accepts:function (dragObjects) {
	if (!dojo.lang.inArray(this.acceptedTypes, "*")) {
		for (var i = 0; i < dragObjects.length; i++) {
			if (!dojo.lang.inArray(this.acceptedTypes, dragObjects[i].type)) {
				return false;
			}
		}
	}
	return true;
}, unregister:function () {
	dojo.dnd.dragManager.unregisterDropTarget(this);
}, onDragOver:function (evt) {
}, onDragOut:function (evt) {
}, onDragMove:function (evt) {
}, onDropStart:function (evt) {
}, onDrop:function (evt) {
}, onDropEnd:function () {
}}, function () {
	this.acceptedTypes = [];
});
dojo.dnd.DragEvent = function () {
	this.dragSource = null;
	this.dragObject = null;
	this.target = null;
	this.eventStatus = "success";
};
dojo.declare("dojo.dnd.DragManager", null, {selectedSources:[], dragObjects:[], dragSources:[], registerDragSource:function (source) {
}, dropTargets:[], registerDropTarget:function (target) {
}, lastDragTarget:null, currentDragTarget:null, onKeyDown:function () {
}, onMouseOut:function () {
}, onMouseMove:function () {
}, onMouseUp:function () {
}});


__CPAN_FILE__ src/dnd/TreeDragAndDropV3.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.dnd.TreeDragAndDropV3");
dojo.require("dojo.dnd.HtmlDragAndDrop");
dojo.require("dojo.lang.func");
dojo.require("dojo.lang.array");
dojo.require("dojo.lang.extras");
dojo.require("dojo.Deferred");
dojo.require("dojo.html.layout");
dojo.dnd.TreeDragSourceV3 = function (node, syncController, type, treeNode) {
	this.controller = syncController;
	this.treeNode = treeNode;
	dojo.dnd.HtmlDragSource.call(this, node, type);
};
dojo.inherits(dojo.dnd.TreeDragSourceV3, dojo.dnd.HtmlDragSource);
dojo.dnd.TreeDropTargetV3 = function (domNode, controller, type, treeNode) {
	this.treeNode = treeNode;
	this.controller = controller;
	dojo.dnd.HtmlDropTarget.call(this, domNode, type);
};
dojo.inherits(dojo.dnd.TreeDropTargetV3, dojo.dnd.HtmlDropTarget);
dojo.lang.extend(dojo.dnd.TreeDropTargetV3, {autoExpandDelay:1500, autoExpandTimer:null, position:null, indicatorStyle:"2px black groove", showIndicator:function (position) {
	if (this.position == position) {
		return;
	}
	this.hideIndicator();
	this.position = position;
	var node = this.treeNode;
	node.contentNode.style.width = dojo.html.getBorderBox(node.labelNode).width + "px";
	if (position == "onto") {
		node.contentNode.style.border = this.indicatorStyle;
	} else {
		if (position == "before") {
			node.contentNode.style.borderTop = this.indicatorStyle;
		} else {
			if (position == "after") {
				node.contentNode.style.borderBottom = this.indicatorStyle;
			}
		}
	}
}, hideIndicator:function () {
	this.treeNode.contentNode.style.borderBottom = "";
	this.treeNode.contentNode.style.borderTop = "";
	this.treeNode.contentNode.style.border = "";
	this.treeNode.contentNode.style.width = "";
	this.position = null;
}, onDragOver:function (e) {
	var accepts = dojo.dnd.HtmlDropTarget.prototype.onDragOver.apply(this, arguments);
	if (accepts && this.treeNode.isFolder && !this.treeNode.isExpanded) {
		this.setAutoExpandTimer();
	}
	if (accepts) {
		this.cacheNodeCoords();
	}
	return accepts;
}, accepts:function (dragObjects) {
	var accepts = dojo.dnd.HtmlDropTarget.prototype.accepts.apply(this, arguments);
	if (!accepts) {
		return false;
	}
	for (var i = 0; i < dragObjects.length; i++) {
		var sourceTreeNode = dragObjects[i].treeNode;
		if (sourceTreeNode === this.treeNode) {
			return false;
		}
	}
	return true;
}, setAutoExpandTimer:function () {
	var _this = this;
	var autoExpand = function () {
		if (dojo.dnd.dragManager.currentDropTarget === _this) {
			_this.controller.expand(_this.treeNode);
			dojo.dnd.dragManager.cacheTargetLocations();
		}
	};
	this.autoExpandTimer = dojo.lang.setTimeout(autoExpand, _this.autoExpandDelay);
}, getAcceptPosition:function (e, dragObjects) {
	var DndMode = this.treeNode.tree.DndMode;
	if (DndMode & dojo.widget.TreeV3.prototype.DndModes.ONTO && this.treeNode.actionIsDisabledNow(this.treeNode.actions.ADDCHILD)) {
		DndMode &= ~dojo.widget.TreeV3.prototype.DndModes.ONTO;
	}
	var position = this.getPosition(e, DndMode);
	if (position == "onto") {
		return position;
	}
	for (var i = 0; i < dragObjects.length; i++) {
		var source = dragObjects[i].dragSource;
		if (source.treeNode && this.isAdjacentNode(source.treeNode, position)) {
			continue;
		}
		if (!this.controller.canMove(source.treeNode ? source.treeNode : source, this.treeNode.parent)) {
			return false;
		}
	}
	return position;
}, onDropEnd:function (e) {
	this.clearAutoExpandTimer();
	this.hideIndicator();
}, onDragOut:function (e) {
	this.clearAutoExpandTimer();
	this.hideIndicator();
}, clearAutoExpandTimer:function () {
	if (this.autoExpandTimer) {
		clearTimeout(this.autoExpandTimer);
		this.autoExpandTimer = null;
	}
}, onDragMove:function (e, dragObjects) {
	var position = this.getAcceptPosition(e, dragObjects);
	if (position) {
		this.showIndicator(position);
	}
}, isAdjacentNode:function (sourceNode, position) {
	if (sourceNode === this.treeNode) {
		return true;
	}
	if (sourceNode.getNextSibling() === this.treeNode && position == "before") {
		return true;
	}
	if (sourceNode.getPreviousSibling() === this.treeNode && position == "after") {
		return true;
	}
	return false;
}, cacheNodeCoords:function () {
	var node = this.treeNode.contentNode;
	this.cachedNodeY = dojo.html.getAbsolutePosition(node).y;
	this.cachedNodeHeight = dojo.html.getBorderBox(node).height;
}, getPosition:function (e, DndMode) {
	var mousey = e.pageY || e.clientY + dojo.body().scrollTop;
	var relY = mousey - this.cachedNodeY;
	var p = relY / this.cachedNodeHeight;
	var position = "";
	if (DndMode & dojo.widget.TreeV3.prototype.DndModes.ONTO && DndMode & dojo.widget.TreeV3.prototype.DndModes.BETWEEN) {
		if (p <= 0.33) {
			position = "before";
		} else {
			if (p <= 0.66 || this.treeNode.isExpanded && this.treeNode.children.length && !this.treeNode.isLastChild()) {
				position = "onto";
			} else {
				position = "after";
			}
		}
	} else {
		if (DndMode & dojo.widget.TreeV3.prototype.DndModes.BETWEEN) {
			if (p <= 0.5 || this.treeNode.isExpanded && this.treeNode.children.length && !this.treeNode.isLastChild()) {
				position = "before";
			} else {
				position = "after";
			}
		} else {
			if (DndMode & dojo.widget.TreeV3.prototype.DndModes.ONTO) {
				position = "onto";
			}
		}
	}
	return position;
}, getTargetParentIndex:function (source, position) {
	var index = position == "before" ? this.treeNode.getParentIndex() : this.treeNode.getParentIndex() + 1;
	if (source.treeNode && this.treeNode.parent === source.treeNode.parent && this.treeNode.getParentIndex() > source.treeNode.getParentIndex()) {
		index--;
	}
	return index;
}, onDrop:function (e) {
	var position = this.position;
	var source = e.dragObject.dragSource;
	var targetParent, targetIndex;
	if (position == "onto") {
		targetParent = this.treeNode;
		targetIndex = 0;
	} else {
		targetIndex = this.getTargetParentIndex(source, position);
		targetParent = this.treeNode.parent;
	}
	var r = this.getDropHandler(e, source, targetParent, targetIndex)();
	return r;
}, getDropHandler:function (e, source, targetParent, targetIndex) {
	var handler;
	var _this = this;
	handler = function () {
		var result;
		if (source.treeNode) {
			result = _this.controller.move(source.treeNode, targetParent, targetIndex, true);
		} else {
			if (dojo.lang.isFunction(source.onDrop)) {
				source.onDrop(targetParent, targetIndex);
			}
			var treeNode = source.getTreeNode();
			if (treeNode) {
				result = _this.controller.createChild(targetParent, targetIndex, treeNode, true);
			} else {
				result = true;
			}
		}
		if (result instanceof dojo.Deferred) {
			var isSuccess = result.fired == 0;
			if (!isSuccess) {
				_this.handleDropError(source, targetParent, targetIndex, result);
			}
			return isSuccess;
		} else {
			return result;
		}
	};
	return handler;
}, handleDropError:function (source, parent, index, result) {
	dojo.debug("TreeDropTargetV3.handleDropError: DND error occured");
	dojo.debugShallow(result);
}});


__CPAN_FILE__ src/dnd/HtmlDragManager.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.dnd.HtmlDragManager"], ["require", "dojo.dnd.DragAndDrop"], ["require", "dojo.event.*"], ["require", "dojo.lang.array"], ["require", "dojo.html.common"], ["require", "dojo.html.layout"]], definePackage:function (dojo) {
	dojo.provide("dojo.dnd.HtmlDragManager");
	dojo.require("dojo.dnd.DragAndDrop");
	dojo.require("dojo.event.*");
	dojo.require("dojo.lang.array");
	dojo.require("dojo.html.common");
	dojo.require("dojo.html.layout");
	dojo.declare("dojo.dnd.HtmlDragManager", dojo.dnd.DragManager, {disabled:false, nestedTargets:false, mouseDownTimer:null, dsCounter:0, dsPrefix:"dojoDragSource", dropTargetDimensions:[], currentDropTarget:null, previousDropTarget:null, _dragTriggered:false, selectedSources:[], dragObjects:[], dragSources:[], dropTargets:[], currentX:null, currentY:null, lastX:null, lastY:null, mouseDownX:null, mouseDownY:null, threshold:7, dropAcceptable:false, cancelEvent:function (e) {
		e.stopPropagation();
		e.preventDefault();
	}, registerDragSource:function (ds) {
		if (ds["domNode"]) {
			var dp = this.dsPrefix;
			var dpIdx = dp + "Idx_" + (this.dsCounter++);
			ds.dragSourceId = dpIdx;
			this.dragSources[dpIdx] = ds;
			ds.domNode.setAttribute(dp, dpIdx);
			if (dojo.render.html.ie) {
				dojo.event.browser.addListener(ds.domNode, "ondragstart", this.cancelEvent);
			}
		}
	}, unregisterDragSource:function (ds) {
		if (ds["domNode"]) {
			var dp = this.dsPrefix;
			var dpIdx = ds.dragSourceId;
			delete ds.dragSourceId;
			delete this.dragSources[dpIdx];
			ds.domNode.setAttribute(dp, null);
			if (dojo.render.html.ie) {
				dojo.event.browser.removeListener(ds.domNode, "ondragstart", this.cancelEvent);
			}
		}
	}, registerDropTarget:function (dt) {
		this.dropTargets.push(dt);
	}, unregisterDropTarget:function (dt) {
		var index = dojo.lang.find(this.dropTargets, dt, true);
		if (index >= 0) {
			this.dropTargets.splice(index, 1);
		}
	}, getDragSource:function (e) {
		var tn = e.target;
		if (tn === dojo.body()) {
			return;
		}
		var ta = dojo.html.getAttribute(tn, this.dsPrefix);
		while ((!ta) && (tn)) {
			tn = tn.parentNode;
			if ((!tn) || (tn === dojo.body())) {
				return;
			}
			ta = dojo.html.getAttribute(tn, this.dsPrefix);
		}
		return this.dragSources[ta];
	}, onKeyDown:function (e) {
	}, onMouseDown:function (e) {
		if (this.disabled) {
			return;
		}
		if (dojo.render.html.ie) {
			if (e.button != 1) {
				return;
			}
		} else {
			if (e.which != 1) {
				return;
			}
		}
		var target = e.target.nodeType == dojo.html.TEXT_NODE ? e.target.parentNode : e.target;
		if (dojo.html.isTag(target, "button", "textarea", "input", "select", "option")) {
			return;
		}
		var ds = this.getDragSource(e);
		if (!ds) {
			return;
		}
		if (!dojo.lang.inArray(this.selectedSources, ds)) {
			this.selectedSources.push(ds);
			ds.onSelected();
		}
		this.mouseDownX = e.pageX;
		this.mouseDownY = e.pageY;
		e.preventDefault();
		dojo.event.connect(document, "onmousemove", this, "onMouseMove");
	}, onMouseUp:function (e, cancel) {
		if (this.selectedSources.length == 0) {
			return;
		}
		this.mouseDownX = null;
		this.mouseDownY = null;
		this._dragTriggered = false;
		e.dragSource = this.dragSource;
		if ((!e.shiftKey) && (!e.ctrlKey)) {
			if (this.currentDropTarget) {
				this.currentDropTarget.onDropStart();
			}
			dojo.lang.forEach(this.dragObjects, function (tempDragObj) {
				var ret = null;
				if (!tempDragObj) {
					return;
				}
				if (this.currentDropTarget) {
					e.dragObject = tempDragObj;
					var ce = this.currentDropTarget.domNode.childNodes;
					if (ce.length > 0) {
						e.dropTarget = ce[0];
						while (e.dropTarget == tempDragObj.domNode) {
							e.dropTarget = e.dropTarget.nextSibling;
						}
					} else {
						e.dropTarget = this.currentDropTarget.domNode;
					}
					if (this.dropAcceptable) {
						ret = this.currentDropTarget.onDrop(e);
					} else {
						this.currentDropTarget.onDragOut(e);
					}
				}
				e.dragStatus = this.dropAcceptable && ret ? "dropSuccess" : "dropFailure";
				dojo.lang.delayThese([function () {
					try {
						tempDragObj.dragSource.onDragEnd(e);
					}
					catch (err) {
						var ecopy = {};
						for (var i in e) {
							if (i == "type") {
								ecopy.type = "mouseup";
								continue;
							}
							ecopy[i] = e[i];
						}
						tempDragObj.dragSource.onDragEnd(ecopy);
					}
				}, function () {
					tempDragObj.onDragEnd(e);
				}]);
			}, this);
			this.selectedSources = [];
			this.dragObjects = [];
			this.dragSource = null;
			if (this.currentDropTarget) {
				this.currentDropTarget.onDropEnd();
			}
		} else {
		}
		dojo.event.disconnect(document, "onmousemove", this, "onMouseMove");
		this.currentDropTarget = null;
	}, onScroll:function () {
		for (var i = 0; i < this.dragObjects.length; i++) {
			if (this.dragObjects[i].updateDragOffset) {
				this.dragObjects[i].updateDragOffset();
			}
		}
		if (this.dragObjects.length) {
			this.cacheTargetLocations();
		}
	}, _dragStartDistance:function (x, y) {
		if ((!this.mouseDownX) || (!this.mouseDownX)) {
			return;
		}
		var dx = Math.abs(x - this.mouseDownX);
		var dx2 = dx * dx;
		var dy = Math.abs(y - this.mouseDownY);
		var dy2 = dy * dy;
		return parseInt(Math.sqrt(dx2 + dy2), 10);
	}, cacheTargetLocations:function () {
		dojo.profile.start("cacheTargetLocations");
		this.dropTargetDimensions = [];
		dojo.lang.forEach(this.dropTargets, function (tempTarget) {
			var tn = tempTarget.domNode;
			if (!tn || !tempTarget.accepts([this.dragSource])) {
				return;
			}
			var abs = dojo.html.getAbsolutePosition(tn, true);
			var bb = dojo.html.getBorderBox(tn);
			this.dropTargetDimensions.push([[abs.x, abs.y], [abs.x + bb.width, abs.y + bb.height], tempTarget]);
		}, this);
		dojo.profile.end("cacheTargetLocations");
	}, onMouseMove:function (e) {
		if ((dojo.render.html.ie) && (e.button != 1)) {
			this.currentDropTarget = null;
			this.onMouseUp(e, true);
			return;
		}
		if ((this.selectedSources.length) && (!this.dragObjects.length)) {
			var dx;
			var dy;
			if (!this._dragTriggered) {
				this._dragTriggered = (this._dragStartDistance(e.pageX, e.pageY) > this.threshold);
				if (!this._dragTriggered) {
					return;
				}
				dx = e.pageX - this.mouseDownX;
				dy = e.pageY - this.mouseDownY;
			}
			this.dragSource = this.selectedSources[0];
			dojo.lang.forEach(this.selectedSources, function (tempSource) {
				if (!tempSource) {
					return;
				}
				var tdo = tempSource.onDragStart(e);
				if (tdo) {
					tdo.onDragStart(e);
					tdo.dragOffset.y += dy;
					tdo.dragOffset.x += dx;
					tdo.dragSource = tempSource;
					this.dragObjects.push(tdo);
				}
			}, this);
			this.previousDropTarget = null;
			this.cacheTargetLocations();
		}
		dojo.lang.forEach(this.dragObjects, function (dragObj) {
			if (dragObj) {
				dragObj.onDragMove(e);
			}
		});
		if (this.currentDropTarget) {
			var c = dojo.html.toCoordinateObject(this.currentDropTarget.domNode, true);
			var dtp = [[c.x, c.y], [c.x + c.width, c.y + c.height]];
		}
		if ((!this.nestedTargets) && (dtp) && (this.isInsideBox(e, dtp))) {
			if (this.dropAcceptable) {
				this.currentDropTarget.onDragMove(e, this.dragObjects);
			}
		} else {
			var bestBox = this.findBestTarget(e);
			if (bestBox.target === null) {
				if (this.currentDropTarget) {
					this.currentDropTarget.onDragOut(e);
					this.previousDropTarget = this.currentDropTarget;
					this.currentDropTarget = null;
				}
				this.dropAcceptable = false;
				return;
			}
			if (this.currentDropTarget !== bestBox.target) {
				if (this.currentDropTarget) {
					this.previousDropTarget = this.currentDropTarget;
					this.currentDropTarget.onDragOut(e);
				}
				this.currentDropTarget = bestBox.target;
				e.dragObjects = this.dragObjects;
				this.dropAcceptable = this.currentDropTarget.onDragOver(e);
			} else {
				if (this.dropAcceptable) {
					this.currentDropTarget.onDragMove(e, this.dragObjects);
				}
			}
		}
	}, findBestTarget:function (e) {
		var _this = this;
		var bestBox = new Object();
		bestBox.target = null;
		bestBox.points = null;
		dojo.lang.every(this.dropTargetDimensions, function (tmpDA) {
			if (!_this.isInsideBox(e, tmpDA)) {
				return true;
			}
			bestBox.target = tmpDA[2];
			bestBox.points = tmpDA;
			return Boolean(_this.nestedTargets);
		});
		return bestBox;
	}, isInsideBox:function (e, coords) {
		if ((e.pageX > coords[0][0]) && (e.pageX < coords[1][0]) && (e.pageY > coords[0][1]) && (e.pageY < coords[1][1])) {
			return true;
		}
		return false;
	}, onMouseOver:function (e) {
	}, onMouseOut:function (e) {
	}});
	dojo.dnd.dragManager = new dojo.dnd.HtmlDragManager();
	(function () {
		var d = document;
		var dm = dojo.dnd.dragManager;
		dojo.event.connect(d, "onkeydown", dm, "onKeyDown");
		dojo.event.connect(d, "onmouseover", dm, "onMouseOver");
		dojo.event.connect(d, "onmouseout", dm, "onMouseOut");
		dojo.event.connect(d, "onmousedown", dm, "onMouseDown");
		dojo.event.connect(d, "onmouseup", dm, "onMouseUp");
		dojo.event.connect(window, "onscroll", dm, "onScroll");
	})();
}});


__CPAN_FILE__ src/dnd/Sortable.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.dnd.Sortable");
dojo.require("dojo.dnd.*");
dojo.dnd.Sortable = function () {
};
dojo.lang.extend(dojo.dnd.Sortable, {ondragstart:function (e) {
	var dragObject = e.target;
	while (dragObject.parentNode && dragObject.parentNode != this) {
		dragObject = dragObject.parentNode;
	}
	return dragObject;
}});


__CPAN_FILE__ src/dnd/TreeDragAndDrop.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.dnd.TreeDragAndDrop"], ["require", "dojo.dnd.HtmlDragAndDrop"], ["require", "dojo.lang.func"], ["require", "dojo.lang.array"], ["require", "dojo.lang.extras"], ["require", "dojo.html.layout"]], definePackage:function (dojo) {
	dojo.provide("dojo.dnd.TreeDragAndDrop");
	dojo.require("dojo.dnd.HtmlDragAndDrop");
	dojo.require("dojo.lang.func");
	dojo.require("dojo.lang.array");
	dojo.require("dojo.lang.extras");
	dojo.require("dojo.html.layout");
	dojo.dnd.TreeDragSource = function (node, syncController, type, treeNode) {
		this.controller = syncController;
		this.treeNode = treeNode;
		dojo.dnd.HtmlDragSource.call(this, node, type);
	};
	dojo.inherits(dojo.dnd.TreeDragSource, dojo.dnd.HtmlDragSource);
	dojo.lang.extend(dojo.dnd.TreeDragSource, {onDragStart:function () {
		var dragObject = dojo.dnd.HtmlDragSource.prototype.onDragStart.call(this);
		dragObject.treeNode = this.treeNode;
		dragObject.onDragStart = dojo.lang.hitch(dragObject, function (e) {
			this.savedSelectedNode = this.treeNode.tree.selector.selectedNode;
			if (this.savedSelectedNode) {
				this.savedSelectedNode.unMarkSelected();
			}
			var result = dojo.dnd.HtmlDragObject.prototype.onDragStart.apply(this, arguments);
			var cloneGrid = this.dragClone.getElementsByTagName("img");
			for (var i = 0; i < cloneGrid.length; i++) {
				cloneGrid.item(i).style.backgroundImage = "url()";
			}
			return result;
		});
		dragObject.onDragEnd = function (e) {
			if (this.savedSelectedNode) {
				this.savedSelectedNode.markSelected();
			}
			return dojo.dnd.HtmlDragObject.prototype.onDragEnd.apply(this, arguments);
		};
		return dragObject;
	}, onDragEnd:function (e) {
		var res = dojo.dnd.HtmlDragSource.prototype.onDragEnd.call(this, e);
		return res;
	}});
	dojo.dnd.TreeDropTarget = function (domNode, controller, type, treeNode) {
		this.treeNode = treeNode;
		this.controller = controller;
		dojo.dnd.HtmlDropTarget.apply(this, [domNode, type]);
	};
	dojo.inherits(dojo.dnd.TreeDropTarget, dojo.dnd.HtmlDropTarget);
	dojo.lang.extend(dojo.dnd.TreeDropTarget, {autoExpandDelay:1500, autoExpandTimer:null, position:null, indicatorStyle:"2px black solid", showIndicator:function (position) {
		if (this.position == position) {
			return;
		}
		this.hideIndicator();
		this.position = position;
		if (position == "before") {
			this.treeNode.labelNode.style.borderTop = this.indicatorStyle;
		} else {
			if (position == "after") {
				this.treeNode.labelNode.style.borderBottom = this.indicatorStyle;
			} else {
				if (position == "onto") {
					this.treeNode.markSelected();
				}
			}
		}
	}, hideIndicator:function () {
		this.treeNode.labelNode.style.borderBottom = "";
		this.treeNode.labelNode.style.borderTop = "";
		this.treeNode.unMarkSelected();
		this.position = null;
	}, onDragOver:function (e) {
		var accepts = dojo.dnd.HtmlDropTarget.prototype.onDragOver.apply(this, arguments);
		if (accepts && this.treeNode.isFolder && !this.treeNode.isExpanded) {
			this.setAutoExpandTimer();
		}
		return accepts;
	}, accepts:function (dragObjects) {
		var accepts = dojo.dnd.HtmlDropTarget.prototype.accepts.apply(this, arguments);
		if (!accepts) {
			return false;
		}
		var sourceTreeNode = dragObjects[0].treeNode;
		if (dojo.lang.isUndefined(sourceTreeNode) || !sourceTreeNode || !sourceTreeNode.isTreeNode) {
			dojo.raise("Source is not TreeNode or not found");
		}
		if (sourceTreeNode === this.treeNode) {
			return false;
		}
		return true;
	}, setAutoExpandTimer:function () {
		var _this = this;
		var autoExpand = function () {
			if (dojo.dnd.dragManager.currentDropTarget === _this) {
				_this.controller.expand(_this.treeNode);
			}
		};
		this.autoExpandTimer = dojo.lang.setTimeout(autoExpand, _this.autoExpandDelay);
	}, getDNDMode:function () {
		return this.treeNode.tree.DNDMode;
	}, getAcceptPosition:function (e, sourceTreeNode) {
		var DNDMode = this.getDNDMode();
		if (DNDMode & dojo.widget.Tree.prototype.DNDModes.ONTO && !(!this.treeNode.actionIsDisabled(dojo.widget.TreeNode.prototype.actions.ADDCHILD) && sourceTreeNode.parent !== this.treeNode && this.controller.canMove(sourceTreeNode, this.treeNode))) {
			DNDMode &= ~dojo.widget.Tree.prototype.DNDModes.ONTO;
		}
		var position = this.getPosition(e, DNDMode);
		if (position == "onto" || (!this.isAdjacentNode(sourceTreeNode, position) && this.controller.canMove(sourceTreeNode, this.treeNode.parent))) {
			return position;
		} else {
			return false;
		}
	}, onDragOut:function (e) {
		this.clearAutoExpandTimer();
		this.hideIndicator();
	}, clearAutoExpandTimer:function () {
		if (this.autoExpandTimer) {
			clearTimeout(this.autoExpandTimer);
			this.autoExpandTimer = null;
		}
	}, onDragMove:function (e, dragObjects) {
		var sourceTreeNode = dragObjects[0].treeNode;
		var position = this.getAcceptPosition(e, sourceTreeNode);
		if (position) {
			this.showIndicator(position);
		}
	}, isAdjacentNode:function (sourceNode, position) {
		if (sourceNode === this.treeNode) {
			return true;
		}
		if (sourceNode.getNextSibling() === this.treeNode && position == "before") {
			return true;
		}
		if (sourceNode.getPreviousSibling() === this.treeNode && position == "after") {
			return true;
		}
		return false;
	}, getPosition:function (e, DNDMode) {
		var node = dojo.byId(this.treeNode.labelNode);
		var mousey = e.pageY || e.clientY + dojo.body().scrollTop;
		var nodey = dojo.html.getAbsolutePosition(node).y;
		var height = dojo.html.getBorderBox(node).height;
		var relY = mousey - nodey;
		var p = relY / height;
		var position = "";
		if (DNDMode & dojo.widget.Tree.prototype.DNDModes.ONTO && DNDMode & dojo.widget.Tree.prototype.DNDModes.BETWEEN) {
			if (p <= 0.3) {
				position = "before";
			} else {
				if (p <= 0.7) {
					position = "onto";
				} else {
					position = "after";
				}
			}
		} else {
			if (DNDMode & dojo.widget.Tree.prototype.DNDModes.BETWEEN) {
				if (p <= 0.5) {
					position = "before";
				} else {
					position = "after";
				}
			} else {
				if (DNDMode & dojo.widget.Tree.prototype.DNDModes.ONTO) {
					position = "onto";
				}
			}
		}
		return position;
	}, getTargetParentIndex:function (sourceTreeNode, position) {
		var index = position == "before" ? this.treeNode.getParentIndex() : this.treeNode.getParentIndex() + 1;
		if (this.treeNode.parent === sourceTreeNode.parent && this.treeNode.getParentIndex() > sourceTreeNode.getParentIndex()) {
			index--;
		}
		return index;
	}, onDrop:function (e) {
		var position = this.position;
		this.onDragOut(e);
		var sourceTreeNode = e.dragObject.treeNode;
		if (!dojo.lang.isObject(sourceTreeNode)) {
			dojo.raise("TreeNode not found in dragObject");
		}
		if (position == "onto") {
			return this.controller.move(sourceTreeNode, this.treeNode, 0);
		} else {
			var index = this.getTargetParentIndex(sourceTreeNode, position);
			return this.controller.move(sourceTreeNode, this.treeNode.parent, index);
		}
	}});
	dojo.dnd.TreeDNDController = function (treeController) {
		this.treeController = treeController;
		this.dragSources = {};
		this.dropTargets = {};
	};
	dojo.lang.extend(dojo.dnd.TreeDNDController, {listenTree:function (tree) {
		dojo.event.topic.subscribe(tree.eventNames.createDOMNode, this, "onCreateDOMNode");
		dojo.event.topic.subscribe(tree.eventNames.moveFrom, this, "onMoveFrom");
		dojo.event.topic.subscribe(tree.eventNames.moveTo, this, "onMoveTo");
		dojo.event.topic.subscribe(tree.eventNames.addChild, this, "onAddChild");
		dojo.event.topic.subscribe(tree.eventNames.removeNode, this, "onRemoveNode");
		dojo.event.topic.subscribe(tree.eventNames.treeDestroy, this, "onTreeDestroy");
	}, unlistenTree:function (tree) {
		dojo.event.topic.unsubscribe(tree.eventNames.createDOMNode, this, "onCreateDOMNode");
		dojo.event.topic.unsubscribe(tree.eventNames.moveFrom, this, "onMoveFrom");
		dojo.event.topic.unsubscribe(tree.eventNames.moveTo, this, "onMoveTo");
		dojo.event.topic.unsubscribe(tree.eventNames.addChild, this, "onAddChild");
		dojo.event.topic.unsubscribe(tree.eventNames.removeNode, this, "onRemoveNode");
		dojo.event.topic.unsubscribe(tree.eventNames.treeDestroy, this, "onTreeDestroy");
	}, onTreeDestroy:function (message) {
		this.unlistenTree(message.source);
	}, onCreateDOMNode:function (message) {
		this.registerDNDNode(message.source);
	}, onAddChild:function (message) {
		this.registerDNDNode(message.child);
	}, onMoveFrom:function (message) {
		var _this = this;
		dojo.lang.forEach(message.child.getDescendants(), function (node) {
			_this.unregisterDNDNode(node);
		});
	}, onMoveTo:function (message) {
		var _this = this;
		dojo.lang.forEach(message.child.getDescendants(), function (node) {
			_this.registerDNDNode(node);
		});
	}, registerDNDNode:function (node) {
		if (!node.tree.DNDMode) {
			return;
		}
		var source = null;
		var target = null;
		if (!node.actionIsDisabled(node.actions.MOVE)) {
			var source = new dojo.dnd.TreeDragSource(node.labelNode, this, node.tree.widgetId, node);
			this.dragSources[node.widgetId] = source;
		}
		var target = new dojo.dnd.TreeDropTarget(node.labelNode, this.treeController, node.tree.DNDAcceptTypes, node);
		this.dropTargets[node.widgetId] = target;
	}, unregisterDNDNode:function (node) {
		if (this.dragSources[node.widgetId]) {
			dojo.dnd.dragManager.unregisterDragSource(this.dragSources[node.widgetId]);
			delete this.dragSources[node.widgetId];
		}
		if (this.dropTargets[node.widgetId]) {
			dojo.dnd.dragManager.unregisterDropTarget(this.dropTargets[node.widgetId]);
			delete this.dropTargets[node.widgetId];
		}
	}});
}});


__CPAN_FILE__ src/dnd/HtmlDragManager.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.dnd.HtmlDragManager");
dojo.require("dojo.dnd.DragAndDrop");
dojo.require("dojo.event.*");
dojo.require("dojo.lang.array");
dojo.require("dojo.html.common");
dojo.require("dojo.html.layout");
dojo.declare("dojo.dnd.HtmlDragManager", dojo.dnd.DragManager, {disabled:false, nestedTargets:false, mouseDownTimer:null, dsCounter:0, dsPrefix:"dojoDragSource", dropTargetDimensions:[], currentDropTarget:null, previousDropTarget:null, _dragTriggered:false, selectedSources:[], dragObjects:[], dragSources:[], dropTargets:[], currentX:null, currentY:null, lastX:null, lastY:null, mouseDownX:null, mouseDownY:null, threshold:7, dropAcceptable:false, cancelEvent:function (e) {
	e.stopPropagation();
	e.preventDefault();
}, registerDragSource:function (ds) {
	if (ds["domNode"]) {
		var dp = this.dsPrefix;
		var dpIdx = dp + "Idx_" + (this.dsCounter++);
		ds.dragSourceId = dpIdx;
		this.dragSources[dpIdx] = ds;
		ds.domNode.setAttribute(dp, dpIdx);
		if (dojo.render.html.ie) {
			dojo.event.browser.addListener(ds.domNode, "ondragstart", this.cancelEvent);
		}
	}
}, unregisterDragSource:function (ds) {
	if (ds["domNode"]) {
		var dp = this.dsPrefix;
		var dpIdx = ds.dragSourceId;
		delete ds.dragSourceId;
		delete this.dragSources[dpIdx];
		ds.domNode.setAttribute(dp, null);
		if (dojo.render.html.ie) {
			dojo.event.browser.removeListener(ds.domNode, "ondragstart", this.cancelEvent);
		}
	}
}, registerDropTarget:function (dt) {
	this.dropTargets.push(dt);
}, unregisterDropTarget:function (dt) {
	var index = dojo.lang.find(this.dropTargets, dt, true);
	if (index >= 0) {
		this.dropTargets.splice(index, 1);
	}
}, getDragSource:function (e) {
	var tn = e.target;
	if (tn === dojo.body()) {
		return;
	}
	var ta = dojo.html.getAttribute(tn, this.dsPrefix);
	while ((!ta) && (tn)) {
		tn = tn.parentNode;
		if ((!tn) || (tn === dojo.body())) {
			return;
		}
		ta = dojo.html.getAttribute(tn, this.dsPrefix);
	}
	return this.dragSources[ta];
}, onKeyDown:function (e) {
}, onMouseDown:function (e) {
	if (this.disabled) {
		return;
	}
	if (dojo.render.html.ie) {
		if (e.button != 1) {
			return;
		}
	} else {
		if (e.which != 1) {
			return;
		}
	}
	var target = e.target.nodeType == dojo.html.TEXT_NODE ? e.target.parentNode : e.target;
	if (dojo.html.isTag(target, "button", "textarea", "input", "select", "option")) {
		return;
	}
	var ds = this.getDragSource(e);
	if (!ds) {
		return;
	}
	if (!dojo.lang.inArray(this.selectedSources, ds)) {
		this.selectedSources.push(ds);
		ds.onSelected();
	}
	this.mouseDownX = e.pageX;
	this.mouseDownY = e.pageY;
	e.preventDefault();
	dojo.event.connect(document, "onmousemove", this, "onMouseMove");
}, onMouseUp:function (e, cancel) {
	if (this.selectedSources.length == 0) {
		return;
	}
	this.mouseDownX = null;
	this.mouseDownY = null;
	this._dragTriggered = false;
	e.dragSource = this.dragSource;
	if ((!e.shiftKey) && (!e.ctrlKey)) {
		if (this.currentDropTarget) {
			this.currentDropTarget.onDropStart();
		}
		dojo.lang.forEach(this.dragObjects, function (tempDragObj) {
			var ret = null;
			if (!tempDragObj) {
				return;
			}
			if (this.currentDropTarget) {
				e.dragObject = tempDragObj;
				var ce = this.currentDropTarget.domNode.childNodes;
				if (ce.length > 0) {
					e.dropTarget = ce[0];
					while (e.dropTarget == tempDragObj.domNode) {
						e.dropTarget = e.dropTarget.nextSibling;
					}
				} else {
					e.dropTarget = this.currentDropTarget.domNode;
				}
				if (this.dropAcceptable) {
					ret = this.currentDropTarget.onDrop(e);
				} else {
					this.currentDropTarget.onDragOut(e);
				}
			}
			e.dragStatus = this.dropAcceptable && ret ? "dropSuccess" : "dropFailure";
			dojo.lang.delayThese([function () {
				try {
					tempDragObj.dragSource.onDragEnd(e);
				}
				catch (err) {
					var ecopy = {};
					for (var i in e) {
						if (i == "type") {
							ecopy.type = "mouseup";
							continue;
						}
						ecopy[i] = e[i];
					}
					tempDragObj.dragSource.onDragEnd(ecopy);
				}
			}, function () {
				tempDragObj.onDragEnd(e);
			}]);
		}, this);
		this.selectedSources = [];
		this.dragObjects = [];
		this.dragSource = null;
		if (this.currentDropTarget) {
			this.currentDropTarget.onDropEnd();
		}
	} else {
	}
	dojo.event.disconnect(document, "onmousemove", this, "onMouseMove");
	this.currentDropTarget = null;
}, onScroll:function () {
	for (var i = 0; i < this.dragObjects.length; i++) {
		if (this.dragObjects[i].updateDragOffset) {
			this.dragObjects[i].updateDragOffset();
		}
	}
	if (this.dragObjects.length) {
		this.cacheTargetLocations();
	}
}, _dragStartDistance:function (x, y) {
	if ((!this.mouseDownX) || (!this.mouseDownX)) {
		return;
	}
	var dx = Math.abs(x - this.mouseDownX);
	var dx2 = dx * dx;
	var dy = Math.abs(y - this.mouseDownY);
	var dy2 = dy * dy;
	return parseInt(Math.sqrt(dx2 + dy2), 10);
}, cacheTargetLocations:function () {
	dojo.profile.start("cacheTargetLocations");
	this.dropTargetDimensions = [];
	dojo.lang.forEach(this.dropTargets, function (tempTarget) {
		var tn = tempTarget.domNode;
		if (!tn || !tempTarget.accepts([this.dragSource])) {
			return;
		}
		var abs = dojo.html.getAbsolutePosition(tn, true);
		var bb = dojo.html.getBorderBox(tn);
		this.dropTargetDimensions.push([[abs.x, abs.y], [abs.x + bb.width, abs.y + bb.height], tempTarget]);
	}, this);
	dojo.profile.end("cacheTargetLocations");
}, onMouseMove:function (e) {
	if ((dojo.render.html.ie) && (e.button != 1)) {
		this.currentDropTarget = null;
		this.onMouseUp(e, true);
		return;
	}
	if ((this.selectedSources.length) && (!this.dragObjects.length)) {
		var dx;
		var dy;
		if (!this._dragTriggered) {
			this._dragTriggered = (this._dragStartDistance(e.pageX, e.pageY) > this.threshold);
			if (!this._dragTriggered) {
				return;
			}
			dx = e.pageX - this.mouseDownX;
			dy = e.pageY - this.mouseDownY;
		}
		this.dragSource = this.selectedSources[0];
		dojo.lang.forEach(this.selectedSources, function (tempSource) {
			if (!tempSource) {
				return;
			}
			var tdo = tempSource.onDragStart(e);
			if (tdo) {
				tdo.onDragStart(e);
				tdo.dragOffset.y += dy;
				tdo.dragOffset.x += dx;
				tdo.dragSource = tempSource;
				this.dragObjects.push(tdo);
			}
		}, this);
		this.previousDropTarget = null;
		this.cacheTargetLocations();
	}
	dojo.lang.forEach(this.dragObjects, function (dragObj) {
		if (dragObj) {
			dragObj.onDragMove(e);
		}
	});
	if (this.currentDropTarget) {
		var c = dojo.html.toCoordinateObject(this.currentDropTarget.domNode, true);
		var dtp = [[c.x, c.y], [c.x + c.width, c.y + c.height]];
	}
	if ((!this.nestedTargets) && (dtp) && (this.isInsideBox(e, dtp))) {
		if (this.dropAcceptable) {
			this.currentDropTarget.onDragMove(e, this.dragObjects);
		}
	} else {
		var bestBox = this.findBestTarget(e);
		if (bestBox.target === null) {
			if (this.currentDropTarget) {
				this.currentDropTarget.onDragOut(e);
				this.previousDropTarget = this.currentDropTarget;
				this.currentDropTarget = null;
			}
			this.dropAcceptable = false;
			return;
		}
		if (this.currentDropTarget !== bestBox.target) {
			if (this.currentDropTarget) {
				this.previousDropTarget = this.currentDropTarget;
				this.currentDropTarget.onDragOut(e);
			}
			this.currentDropTarget = bestBox.target;
			e.dragObjects = this.dragObjects;
			this.dropAcceptable = this.currentDropTarget.onDragOver(e);
		} else {
			if (this.dropAcceptable) {
				this.currentDropTarget.onDragMove(e, this.dragObjects);
			}
		}
	}
}, findBestTarget:function (e) {
	var _this = this;
	var bestBox = new Object();
	bestBox.target = null;
	bestBox.points = null;
	dojo.lang.every(this.dropTargetDimensions, function (tmpDA) {
		if (!_this.isInsideBox(e, tmpDA)) {
			return true;
		}
		bestBox.target = tmpDA[2];
		bestBox.points = tmpDA;
		return Boolean(_this.nestedTargets);
	});
	return bestBox;
}, isInsideBox:function (e, coords) {
	if ((e.pageX > coords[0][0]) && (e.pageX < coords[1][0]) && (e.pageY > coords[0][1]) && (e.pageY < coords[1][1])) {
		return true;
	}
	return false;
}, onMouseOver:function (e) {
}, onMouseOut:function (e) {
}});
dojo.dnd.dragManager = new dojo.dnd.HtmlDragManager();
(function () {
	var d = document;
	var dm = dojo.dnd.dragManager;
	dojo.event.connect(d, "onkeydown", dm, "onKeyDown");
	dojo.event.connect(d, "onmouseover", dm, "onMouseOver");
	dojo.event.connect(d, "onmouseout", dm, "onMouseOut");
	dojo.event.connect(d, "onmousedown", dm, "onMouseDown");
	dojo.event.connect(d, "onmouseup", dm, "onMouseUp");
	dojo.event.connect(window, "onscroll", dm, "onScroll");
})();


__CPAN_FILE__ src/dnd/HtmlDragAndDrop.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.dnd.HtmlDragAndDrop"], ["require", "dojo.dnd.HtmlDragManager"], ["require", "dojo.dnd.DragAndDrop"], ["require", "dojo.html.*"], ["require", "dojo.html.display"], ["require", "dojo.html.util"], ["require", "dojo.html.selection"], ["require", "dojo.html.iframe"], ["require", "dojo.lang.extras"], ["require", "dojo.lfx.*"], ["require", "dojo.event.*"]], definePackage:function (dojo) {
	dojo.provide("dojo.dnd.HtmlDragAndDrop");
	dojo.require("dojo.dnd.HtmlDragManager");
	dojo.require("dojo.dnd.DragAndDrop");
	dojo.require("dojo.html.*");
	dojo.require("dojo.html.display");
	dojo.require("dojo.html.util");
	dojo.require("dojo.html.selection");
	dojo.require("dojo.html.iframe");
	dojo.require("dojo.lang.extras");
	dojo.require("dojo.lfx.*");
	dojo.require("dojo.event.*");
	dojo.declare("dojo.dnd.HtmlDragSource", dojo.dnd.DragSource, {dragClass:"", onDragStart:function () {
		var dragObj = new dojo.dnd.HtmlDragObject(this.dragObject, this.type);
		if (this.dragClass) {
			dragObj.dragClass = this.dragClass;
		}
		if (this.constrainToContainer) {
			dragObj.constrainTo(this.constrainingContainer || this.domNode.parentNode);
		}
		return dragObj;
	}, setDragHandle:function (node) {
		node = dojo.byId(node);
		dojo.dnd.dragManager.unregisterDragSource(this);
		this.domNode = node;
		dojo.dnd.dragManager.registerDragSource(this);
	}, setDragTarget:function (node) {
		this.dragObject = node;
	}, constrainTo:function (container) {
		this.constrainToContainer = true;
		if (container) {
			this.constrainingContainer = container;
		}
	}, onSelected:function () {
		for (var i = 0; i < this.dragObjects.length; i++) {
			dojo.dnd.dragManager.selectedSources.push(new dojo.dnd.HtmlDragSource(this.dragObjects[i]));
		}
	}, addDragObjects:function (el) {
		for (var i = 0; i < arguments.length; i++) {
			this.dragObjects.push(dojo.byId(arguments[i]));
		}
	}}, function (node, type) {
		node = dojo.byId(node);
		this.dragObjects = [];
		this.constrainToContainer = false;
		if (node) {
			this.domNode = node;
			this.dragObject = node;
			this.type = (type) || (this.domNode.nodeName.toLowerCase());
			dojo.dnd.DragSource.prototype.reregister.call(this);
		}
	});
	dojo.declare("dojo.dnd.HtmlDragObject", dojo.dnd.DragObject, {dragClass:"", opacity:0.5, createIframe:true, disableX:false, disableY:false, createDragNode:function () {
		var node = this.domNode.cloneNode(true);
		if (this.dragClass) {
			dojo.html.addClass(node, this.dragClass);
		}
		if (this.opacity < 1) {
			dojo.html.setOpacity(node, this.opacity);
		}
		var ltn = node.tagName.toLowerCase();
		var isTr = (ltn == "tr");
		if ((isTr) || (ltn == "tbody")) {
			var doc = this.domNode.ownerDocument;
			var table = doc.createElement("table");
			if (isTr) {
				var tbody = doc.createElement("tbody");
				table.appendChild(tbody);
				tbody.appendChild(node);
			} else {
				table.appendChild(node);
			}
			var tmpSrcTr = ((isTr) ? this.domNode : this.domNode.firstChild);
			var tmpDstTr = ((isTr) ? node : node.firstChild);
			var domTds = tmpSrcTr.childNodes;
			var cloneTds = tmpDstTr.childNodes;
			for (var i = 0; i < domTds.length; i++) {
				if ((cloneTds[i]) && (cloneTds[i].style)) {
					cloneTds[i].style.width = dojo.html.getContentBox(domTds[i]).width + "px";
				}
			}
			node = table;
		}
		if ((dojo.render.html.ie55 || dojo.render.html.ie60) && this.createIframe) {
			with (node.style) {
				top = "0px";
				left = "0px";
			}
			var outer = document.createElement("div");
			outer.appendChild(node);
			this.bgIframe = new dojo.html.BackgroundIframe(outer);
			outer.appendChild(this.bgIframe.iframe);
			node = outer;
		}
		node.style.zIndex = 999;
		return node;
	}, onDragStart:function (e) {
		dojo.html.clearSelection();
		this.scrollOffset = dojo.html.getScroll().offset;
		this.dragStartPosition = dojo.html.getAbsolutePosition(this.domNode, true);
		this.dragOffset = {y:this.dragStartPosition.y - e.pageY, x:this.dragStartPosition.x - e.pageX};
		this.dragClone = this.createDragNode();
		this.containingBlockPosition = this.domNode.offsetParent ? dojo.html.getAbsolutePosition(this.domNode.offsetParent, true) : {x:0, y:0};
		if (this.constrainToContainer) {
			this.constraints = this.getConstraints();
		}
		with (this.dragClone.style) {
			position = "absolute";
			top = this.dragOffset.y + e.pageY + "px";
			left = this.dragOffset.x + e.pageX + "px";
		}
		dojo.body().appendChild(this.dragClone);
		dojo.event.topic.publish("dragStart", {source:this});
	}, getConstraints:function () {
		if (this.constrainingContainer.nodeName.toLowerCase() == "body") {
			var viewport = dojo.html.getViewport();
			var width = viewport.width;
			var height = viewport.height;
			var scroll = dojo.html.getScroll().offset;
			var x = scroll.x;
			var y = scroll.y;
		} else {
			var content = dojo.html.getContentBox(this.constrainingContainer);
			width = content.width;
			height = content.height;
			x = this.containingBlockPosition.x + dojo.html.getPixelValue(this.constrainingContainer, "padding-left", true) + dojo.html.getBorderExtent(this.constrainingContainer, "left");
			y = this.containingBlockPosition.y + dojo.html.getPixelValue(this.constrainingContainer, "padding-top", true) + dojo.html.getBorderExtent(this.constrainingContainer, "top");
		}
		var mb = dojo.html.getMarginBox(this.domNode);
		return {minX:x, minY:y, maxX:x + width - mb.width, maxY:y + height - mb.height};
	}, updateDragOffset:function () {
		var scroll = dojo.html.getScroll().offset;
		if (scroll.y != this.scrollOffset.y) {
			var diff = scroll.y - this.scrollOffset.y;
			this.dragOffset.y += diff;
			this.scrollOffset.y = scroll.y;
		}
		if (scroll.x != this.scrollOffset.x) {
			var diff = scroll.x - this.scrollOffset.x;
			this.dragOffset.x += diff;
			this.scrollOffset.x = scroll.x;
		}
	}, onDragMove:function (e) {
		this.updateDragOffset();
		var x = this.dragOffset.x + e.pageX;
		var y = this.dragOffset.y + e.pageY;
		if (this.constrainToContainer) {
			if (x < this.constraints.minX) {
				x = this.constraints.minX;
			}
			if (y < this.constraints.minY) {
				y = this.constraints.minY;
			}
			if (x > this.constraints.maxX) {
				x = this.constraints.maxX;
			}
			if (y > this.constraints.maxY) {
				y = this.constraints.maxY;
			}
		}
		this.setAbsolutePosition(x, y);
		dojo.event.topic.publish("dragMove", {source:this});
	}, setAbsolutePosition:function (x, y) {
		if (!this.disableY) {
			this.dragClone.style.top = y + "px";
		}
		if (!this.disableX) {
			this.dragClone.style.left = x + "px";
		}
	}, onDragEnd:function (e) {
		switch (e.dragStatus) {
		  case "dropSuccess":
			dojo.html.removeNode(this.dragClone);
			this.dragClone = null;
			break;
		  case "dropFailure":
			var startCoords = dojo.html.getAbsolutePosition(this.dragClone, true);
			var endCoords = {left:this.dragStartPosition.x + 1, top:this.dragStartPosition.y + 1};
			var anim = dojo.lfx.slideTo(this.dragClone, endCoords, 300);
			var dragObject = this;
			dojo.event.connect(anim, "onEnd", function (e) {
				dojo.html.removeNode(dragObject.dragClone);
				dragObject.dragClone = null;
			});
			anim.play();
			break;
		}
		dojo.event.topic.publish("dragEnd", {source:this});
	}, constrainTo:function (container) {
		this.constrainToContainer = true;
		if (container) {
			this.constrainingContainer = container;
		} else {
			this.constrainingContainer = this.domNode.parentNode;
		}
	}}, function (node, type) {
		this.domNode = dojo.byId(node);
		this.type = type;
		this.constrainToContainer = false;
		this.dragSource = null;
		dojo.dnd.DragObject.prototype.register.call(this);
	});
	dojo.declare("dojo.dnd.HtmlDropTarget", dojo.dnd.DropTarget, {vertical:false, onDragOver:function (e) {
		if (!this.accepts(e.dragObjects)) {
			return false;
		}
		this.childBoxes = [];
		for (var i = 0, child; i < this.domNode.childNodes.length; i++) {
			child = this.domNode.childNodes[i];
			if (child.nodeType != dojo.html.ELEMENT_NODE) {
				continue;
			}
			var pos = dojo.html.getAbsolutePosition(child, true);
			var inner = dojo.html.getBorderBox(child);
			this.childBoxes.push({top:pos.y, bottom:pos.y + inner.height, left:pos.x, right:pos.x + inner.width, height:inner.height, width:inner.width, node:child});
		}
		return true;
	}, _getNodeUnderMouse:function (e) {
		for (var i = 0, child; i < this.childBoxes.length; i++) {
			with (this.childBoxes[i]) {
				if (e.pageX >= left && e.pageX <= right && e.pageY >= top && e.pageY <= bottom) {
					return i;
				}
			}
		}
		return -1;
	}, createDropIndicator:function () {
		this.dropIndicator = document.createElement("div");
		with (this.dropIndicator.style) {
			position = "absolute";
			zIndex = 999;
			if (this.vertical) {
				borderLeftWidth = "1px";
				borderLeftColor = "black";
				borderLeftStyle = "solid";
				height = dojo.html.getBorderBox(this.domNode).height + "px";
				top = dojo.html.getAbsolutePosition(this.domNode, true).y + "px";
			} else {
				borderTopWidth = "1px";
				borderTopColor = "black";
				borderTopStyle = "solid";
				width = dojo.html.getBorderBox(this.domNode).width + "px";
				left = dojo.html.getAbsolutePosition(this.domNode, true).x + "px";
			}
		}
	}, onDragMove:function (e, dragObjects) {
		var i = this._getNodeUnderMouse(e);
		if (!this.dropIndicator) {
			this.createDropIndicator();
		}
		var gravity = this.vertical ? dojo.html.gravity.WEST : dojo.html.gravity.NORTH;
		var hide = false;
		if (i < 0) {
			if (this.childBoxes.length) {
				var before = (dojo.html.gravity(this.childBoxes[0].node, e) & gravity);
				if (before) {
					hide = true;
				}
			} else {
				var before = true;
			}
		} else {
			var child = this.childBoxes[i];
			var before = (dojo.html.gravity(child.node, e) & gravity);
			if (child.node === dragObjects[0].dragSource.domNode) {
				hide = true;
			} else {
				var currentPosChild = before ? (i > 0 ? this.childBoxes[i - 1] : child) : (i < this.childBoxes.length - 1 ? this.childBoxes[i + 1] : child);
				if (currentPosChild.node === dragObjects[0].dragSource.domNode) {
					hide = true;
				}
			}
		}
		if (hide) {
			this.dropIndicator.style.display = "none";
			return;
		} else {
			this.dropIndicator.style.display = "";
		}
		this.placeIndicator(e, dragObjects, i, before);
		if (!dojo.html.hasParent(this.dropIndicator)) {
			dojo.body().appendChild(this.dropIndicator);
		}
	}, placeIndicator:function (e, dragObjects, boxIndex, before) {
		var targetProperty = this.vertical ? "left" : "top";
		var child;
		if (boxIndex < 0) {
			if (this.childBoxes.length) {
				child = before ? this.childBoxes[0] : this.childBoxes[this.childBoxes.length - 1];
			} else {
				this.dropIndicator.style[targetProperty] = dojo.html.getAbsolutePosition(this.domNode, true)[this.vertical ? "x" : "y"] + "px";
			}
		} else {
			child = this.childBoxes[boxIndex];
		}
		if (child) {
			this.dropIndicator.style[targetProperty] = (before ? child[targetProperty] : child[this.vertical ? "right" : "bottom"]) + "px";
			if (this.vertical) {
				this.dropIndicator.style.height = child.height + "px";
				this.dropIndicator.style.top = child.top + "px";
			} else {
				this.dropIndicator.style.width = child.width + "px";
				this.dropIndicator.style.left = child.left + "px";
			}
		}
	}, onDragOut:function (e) {
		if (this.dropIndicator) {
			dojo.html.removeNode(this.dropIndicator);
			delete this.dropIndicator;
		}
	}, onDrop:function (e) {
		this.onDragOut(e);
		var i = this._getNodeUnderMouse(e);
		var gravity = this.vertical ? dojo.html.gravity.WEST : dojo.html.gravity.NORTH;
		if (i < 0) {
			if (this.childBoxes.length) {
				if (dojo.html.gravity(this.childBoxes[0].node, e) & gravity) {
					return this.insert(e, this.childBoxes[0].node, "before");
				} else {
					return this.insert(e, this.childBoxes[this.childBoxes.length - 1].node, "after");
				}
			}
			return this.insert(e, this.domNode, "append");
		}
		var child = this.childBoxes[i];
		if (dojo.html.gravity(child.node, e) & gravity) {
			return this.insert(e, child.node, "before");
		} else {
			return this.insert(e, child.node, "after");
		}
	}, insert:function (e, refNode, position) {
		var node = e.dragObject.domNode;
		if (position == "before") {
			return dojo.html.insertBefore(node, refNode);
		} else {
			if (position == "after") {
				return dojo.html.insertAfter(node, refNode);
			} else {
				if (position == "append") {
					refNode.appendChild(node);
					return true;
				}
			}
		}
		return false;
	}}, function (node, types) {
		if (arguments.length == 0) {
			return;
		}
		this.domNode = dojo.byId(node);
		dojo.dnd.DropTarget.call(this);
		if (types && dojo.lang.isString(types)) {
			types = [types];
		}
		this.acceptedTypes = types || [];
		dojo.dnd.dragManager.registerDropTarget(this);
	});
}});


__CPAN_FILE__ src/dnd/DragAndDrop.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["require", "dojo.lang.common"], ["require", "dojo.lang.func"], ["require", "dojo.lang.declare"], ["provide", "dojo.dnd.DragAndDrop"], ["require", "dojo.dnd.*"]], definePackage:function (dojo) {
	dojo.require("dojo.lang.common");
	dojo.require("dojo.lang.func");
	dojo.require("dojo.lang.declare");
	dojo.provide("dojo.dnd.DragAndDrop");
	dojo.declare("dojo.dnd.DragSource", null, {type:"", onDragEnd:function (evt) {
	}, onDragStart:function (evt) {
	}, onSelected:function (evt) {
	}, unregister:function () {
		dojo.dnd.dragManager.unregisterDragSource(this);
	}, reregister:function () {
		dojo.dnd.dragManager.registerDragSource(this);
	}});
	dojo.declare("dojo.dnd.DragObject", null, {type:"", register:function () {
		var dm = dojo.dnd.dragManager;
		if (dm["registerDragObject"]) {
			dm.registerDragObject(this);
		}
	}, onDragStart:function (evt) {
	}, onDragMove:function (evt) {
	}, onDragOver:function (evt) {
	}, onDragOut:function (evt) {
	}, onDragEnd:function (evt) {
	}, onDragLeave:dojo.lang.forward("onDragOut"), onDragEnter:dojo.lang.forward("onDragOver"), ondragout:dojo.lang.forward("onDragOut"), ondragover:dojo.lang.forward("onDragOver")});
	dojo.declare("dojo.dnd.DropTarget", null, {acceptsType:function (type) {
		if (!dojo.lang.inArray(this.acceptedTypes, "*")) {
			if (!dojo.lang.inArray(this.acceptedTypes, type)) {
				return false;
			}
		}
		return true;
	}, accepts:function (dragObjects) {
		if (!dojo.lang.inArray(this.acceptedTypes, "*")) {
			for (var i = 0; i < dragObjects.length; i++) {
				if (!dojo.lang.inArray(this.acceptedTypes, dragObjects[i].type)) {
					return false;
				}
			}
		}
		return true;
	}, unregister:function () {
		dojo.dnd.dragManager.unregisterDropTarget(this);
	}, onDragOver:function (evt) {
	}, onDragOut:function (evt) {
	}, onDragMove:function (evt) {
	}, onDropStart:function (evt) {
	}, onDrop:function (evt) {
	}, onDropEnd:function () {
	}}, function () {
		this.acceptedTypes = [];
	});
	dojo.dnd.DragEvent = function () {
		this.dragSource = null;
		this.dragObject = null;
		this.target = null;
		this.eventStatus = "success";
	};
	dojo.declare("dojo.dnd.DragManager", null, {selectedSources:[], dragObjects:[], dragSources:[], registerDragSource:function (source) {
	}, dropTargets:[], registerDropTarget:function (target) {
	}, lastDragTarget:null, currentDragTarget:null, onKeyDown:function () {
	}, onMouseOut:function () {
	}, onMouseMove:function () {
	}, onMouseUp:function () {
	}});
}});


__CPAN_FILE__ src/dnd/HtmlDragCopy.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.dnd.HtmlDragCopy");
dojo.require("dojo.dnd.*");
dojo.declare("dojo.dnd.HtmlDragCopySource", dojo.dnd.HtmlDragSource, function (node, type, copyOnce) {
	this.copyOnce = copyOnce;
	this.makeCopy = true;
}, {onDragStart:function () {
	var dragObj = new dojo.dnd.HtmlDragCopyObject(this.dragObject, this.type, this);
	if (this.dragClass) {
		dragObj.dragClass = this.dragClass;
	}
	if (this.constrainToContainer) {
		dragObj.constrainTo(this.constrainingContainer || this.domNode.parentNode);
	}
	return dragObj;
}, onSelected:function () {
	for (var i = 0; i < this.dragObjects.length; i++) {
		dojo.dnd.dragManager.selectedSources.push(new dojo.dnd.HtmlDragCopySource(this.dragObjects[i]));
	}
}});
dojo.declare("dojo.dnd.HtmlDragCopyObject", dojo.dnd.HtmlDragObject, function (dragObject, type, source) {
	this.copySource = source;
}, {onDragStart:function (e) {
	dojo.dnd.HtmlDragCopyObject.superclass.onDragStart.apply(this, arguments);
	if (this.copySource.makeCopy) {
		this.sourceNode = this.domNode;
		this.domNode = this.domNode.cloneNode(true);
	}
}, onDragEnd:function (e) {
	switch (e.dragStatus) {
	  case "dropFailure":
		var startCoords = dojo.html.getAbsolutePosition(this.dragClone, true);
		var endCoords = {left:this.dragStartPosition.x + 1, top:this.dragStartPosition.y + 1};
		var anim = dojo.lfx.slideTo(this.dragClone, endCoords, 500, dojo.lfx.easeOut);
		var dragObject = this;
		dojo.event.connect(anim, "onEnd", function (e) {
			dojo.lang.setTimeout(function () {
				dojo.html.removeNode(dragObject.dragClone);
				dragObject.dragClone = null;
				if (dragObject.copySource.makeCopy) {
					dojo.html.removeNode(dragObject.domNode);
					dragObject.domNode = dragObject.sourceNode;
					dragObject.sourceNode = null;
				}
			}, 200);
		});
		anim.play();
		dojo.event.topic.publish("dragEnd", {source:this});
		return;
	}
	dojo.dnd.HtmlDragCopyObject.superclass.onDragEnd.apply(this, arguments);
	this.copySource.dragObject = this.domNode;
	if (this.copySource.copyOnce) {
		this.copySource.makeCopy = false;
	}
	new dojo.dnd.HtmlDragCopySource(this.sourceNode, this.type, this.copySource.copyOnce);
	this.sourceNode = null;
}});


__CPAN_FILE__ src/dnd/TreeDragAndDropV3.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.dnd.TreeDragAndDropV3"], ["require", "dojo.dnd.HtmlDragAndDrop"], ["require", "dojo.lang.func"], ["require", "dojo.lang.array"], ["require", "dojo.lang.extras"], ["require", "dojo.Deferred"], ["require", "dojo.html.layout"]], definePackage:function (dojo) {
	dojo.provide("dojo.dnd.TreeDragAndDropV3");
	dojo.require("dojo.dnd.HtmlDragAndDrop");
	dojo.require("dojo.lang.func");
	dojo.require("dojo.lang.array");
	dojo.require("dojo.lang.extras");
	dojo.require("dojo.Deferred");
	dojo.require("dojo.html.layout");
	dojo.dnd.TreeDragSourceV3 = function (node, syncController, type, treeNode) {
		this.controller = syncController;
		this.treeNode = treeNode;
		dojo.dnd.HtmlDragSource.call(this, node, type);
	};
	dojo.inherits(dojo.dnd.TreeDragSourceV3, dojo.dnd.HtmlDragSource);
	dojo.dnd.TreeDropTargetV3 = function (domNode, controller, type, treeNode) {
		this.treeNode = treeNode;
		this.controller = controller;
		dojo.dnd.HtmlDropTarget.call(this, domNode, type);
	};
	dojo.inherits(dojo.dnd.TreeDropTargetV3, dojo.dnd.HtmlDropTarget);
	dojo.lang.extend(dojo.dnd.TreeDropTargetV3, {autoExpandDelay:1500, autoExpandTimer:null, position:null, indicatorStyle:"2px black groove", showIndicator:function (position) {
		if (this.position == position) {
			return;
		}
		this.hideIndicator();
		this.position = position;
		var node = this.treeNode;
		node.contentNode.style.width = dojo.html.getBorderBox(node.labelNode).width + "px";
		if (position == "onto") {
			node.contentNode.style.border = this.indicatorStyle;
		} else {
			if (position == "before") {
				node.contentNode.style.borderTop = this.indicatorStyle;
			} else {
				if (position == "after") {
					node.contentNode.style.borderBottom = this.indicatorStyle;
				}
			}
		}
	}, hideIndicator:function () {
		this.treeNode.contentNode.style.borderBottom = "";
		this.treeNode.contentNode.style.borderTop = "";
		this.treeNode.contentNode.style.border = "";
		this.treeNode.contentNode.style.width = "";
		this.position = null;
	}, onDragOver:function (e) {
		var accepts = dojo.dnd.HtmlDropTarget.prototype.onDragOver.apply(this, arguments);
		if (accepts && this.treeNode.isFolder && !this.treeNode.isExpanded) {
			this.setAutoExpandTimer();
		}
		if (accepts) {
			this.cacheNodeCoords();
		}
		return accepts;
	}, accepts:function (dragObjects) {
		var accepts = dojo.dnd.HtmlDropTarget.prototype.accepts.apply(this, arguments);
		if (!accepts) {
			return false;
		}
		for (var i = 0; i < dragObjects.length; i++) {
			var sourceTreeNode = dragObjects[i].treeNode;
			if (sourceTreeNode === this.treeNode) {
				return false;
			}
		}
		return true;
	}, setAutoExpandTimer:function () {
		var _this = this;
		var autoExpand = function () {
			if (dojo.dnd.dragManager.currentDropTarget === _this) {
				_this.controller.expand(_this.treeNode);
				dojo.dnd.dragManager.cacheTargetLocations();
			}
		};
		this.autoExpandTimer = dojo.lang.setTimeout(autoExpand, _this.autoExpandDelay);
	}, getAcceptPosition:function (e, dragObjects) {
		var DndMode = this.treeNode.tree.DndMode;
		if (DndMode & dojo.widget.TreeV3.prototype.DndModes.ONTO && this.treeNode.actionIsDisabledNow(this.treeNode.actions.ADDCHILD)) {
			DndMode &= ~dojo.widget.TreeV3.prototype.DndModes.ONTO;
		}
		var position = this.getPosition(e, DndMode);
		if (position == "onto") {
			return position;
		}
		for (var i = 0; i < dragObjects.length; i++) {
			var source = dragObjects[i].dragSource;
			if (source.treeNode && this.isAdjacentNode(source.treeNode, position)) {
				continue;
			}
			if (!this.controller.canMove(source.treeNode ? source.treeNode : source, this.treeNode.parent)) {
				return false;
			}
		}
		return position;
	}, onDropEnd:function (e) {
		this.clearAutoExpandTimer();
		this.hideIndicator();
	}, onDragOut:function (e) {
		this.clearAutoExpandTimer();
		this.hideIndicator();
	}, clearAutoExpandTimer:function () {
		if (this.autoExpandTimer) {
			clearTimeout(this.autoExpandTimer);
			this.autoExpandTimer = null;
		}
	}, onDragMove:function (e, dragObjects) {
		var position = this.getAcceptPosition(e, dragObjects);
		if (position) {
			this.showIndicator(position);
		}
	}, isAdjacentNode:function (sourceNode, position) {
		if (sourceNode === this.treeNode) {
			return true;
		}
		if (sourceNode.getNextSibling() === this.treeNode && position == "before") {
			return true;
		}
		if (sourceNode.getPreviousSibling() === this.treeNode && position == "after") {
			return true;
		}
		return false;
	}, cacheNodeCoords:function () {
		var node = this.treeNode.contentNode;
		this.cachedNodeY = dojo.html.getAbsolutePosition(node).y;
		this.cachedNodeHeight = dojo.html.getBorderBox(node).height;
	}, getPosition:function (e, DndMode) {
		var mousey = e.pageY || e.clientY + dojo.body().scrollTop;
		var relY = mousey - this.cachedNodeY;
		var p = relY / this.cachedNodeHeight;
		var position = "";
		if (DndMode & dojo.widget.TreeV3.prototype.DndModes.ONTO && DndMode & dojo.widget.TreeV3.prototype.DndModes.BETWEEN) {
			if (p <= 0.33) {
				position = "before";
			} else {
				if (p <= 0.66 || this.treeNode.isExpanded && this.treeNode.children.length && !this.treeNode.isLastChild()) {
					position = "onto";
				} else {
					position = "after";
				}
			}
		} else {
			if (DndMode & dojo.widget.TreeV3.prototype.DndModes.BETWEEN) {
				if (p <= 0.5 || this.treeNode.isExpanded && this.treeNode.children.length && !this.treeNode.isLastChild()) {
					position = "before";
				} else {
					position = "after";
				}
			} else {
				if (DndMode & dojo.widget.TreeV3.prototype.DndModes.ONTO) {
					position = "onto";
				}
			}
		}
		return position;
	}, getTargetParentIndex:function (source, position) {
		var index = position == "before" ? this.treeNode.getParentIndex() : this.treeNode.getParentIndex() + 1;
		if (source.treeNode && this.treeNode.parent === source.treeNode.parent && this.treeNode.getParentIndex() > source.treeNode.getParentIndex()) {
			index--;
		}
		return index;
	}, onDrop:function (e) {
		var position = this.position;
		var source = e.dragObject.dragSource;
		var targetParent, targetIndex;
		if (position == "onto") {
			targetParent = this.treeNode;
			targetIndex = 0;
		} else {
			targetIndex = this.getTargetParentIndex(source, position);
			targetParent = this.treeNode.parent;
		}
		var r = this.getDropHandler(e, source, targetParent, targetIndex)();
		return r;
	}, getDropHandler:function (e, source, targetParent, targetIndex) {
		var handler;
		var _this = this;
		handler = function () {
			var result;
			if (source.treeNode) {
				result = _this.controller.move(source.treeNode, targetParent, targetIndex, true);
			} else {
				if (dojo.lang.isFunction(source.onDrop)) {
					source.onDrop(targetParent, targetIndex);
				}
				var treeNode = source.getTreeNode();
				if (treeNode) {
					result = _this.controller.createChild(targetParent, targetIndex, treeNode, true);
				} else {
					result = true;
				}
			}
			if (result instanceof dojo.Deferred) {
				var isSuccess = result.fired == 0;
				if (!isSuccess) {
					_this.handleDropError(source, targetParent, targetIndex, result);
				}
				return isSuccess;
			} else {
				return result;
			}
		};
		return handler;
	}, handleDropError:function (source, parent, index, result) {
		dojo.debug("TreeDropTargetV3.handleDropError: DND error occured");
		dojo.debugShallow(result);
	}});
}});


__CPAN_FILE__ src/dnd/HtmlDragMove.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.dnd.HtmlDragMove");
dojo.require("dojo.dnd.*");
dojo.declare("dojo.dnd.HtmlDragMoveSource", dojo.dnd.HtmlDragSource, {onDragStart:function () {
	var dragObj = new dojo.dnd.HtmlDragMoveObject(this.dragObject, this.type);
	if (this.constrainToContainer) {
		dragObj.constrainTo(this.constrainingContainer);
	}
	return dragObj;
}, onSelected:function () {
	for (var i = 0; i < this.dragObjects.length; i++) {
		dojo.dnd.dragManager.selectedSources.push(new dojo.dnd.HtmlDragMoveSource(this.dragObjects[i]));
	}
}});
dojo.declare("dojo.dnd.HtmlDragMoveObject", dojo.dnd.HtmlDragObject, {onDragStart:function (e) {
	dojo.html.clearSelection();
	this.dragClone = this.domNode;
	if (dojo.html.getComputedStyle(this.domNode, "position") != "absolute") {
		this.domNode.style.position = "relative";
	}
	var left = parseInt(dojo.html.getComputedStyle(this.domNode, "left"));
	var top = parseInt(dojo.html.getComputedStyle(this.domNode, "top"));
	this.dragStartPosition = {x:isNaN(left) ? 0 : left, y:isNaN(top) ? 0 : top};
	this.scrollOffset = dojo.html.getScroll().offset;
	this.dragOffset = {y:this.dragStartPosition.y - e.pageY, x:this.dragStartPosition.x - e.pageX};
	this.containingBlockPosition = {x:0, y:0};
	if (this.constrainToContainer) {
		this.constraints = this.getConstraints();
	}
	dojo.event.connect(this.domNode, "onclick", this, "_squelchOnClick");
}, onDragEnd:function (e) {
}, setAbsolutePosition:function (x, y) {
	if (!this.disableY) {
		this.domNode.style.top = y + "px";
	}
	if (!this.disableX) {
		this.domNode.style.left = x + "px";
	}
}, _squelchOnClick:function (e) {
	dojo.event.browser.stopEvent(e);
	dojo.event.disconnect(this.domNode, "onclick", this, "_squelchOnClick");
}});


__CPAN_FILE__ src/dnd/__package__.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.kwCompoundRequire({common:["dojo.dnd.DragAndDrop"], browser:["dojo.dnd.HtmlDragAndDrop"], dashboard:["dojo.dnd.HtmlDragAndDrop"]});
dojo.provide("dojo.dnd.*");


__CPAN_FILE__ src/dnd/HtmlDragMove.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.dnd.HtmlDragMove"], ["require", "dojo.dnd.*"]], definePackage:function (dojo) {
	dojo.provide("dojo.dnd.HtmlDragMove");
	dojo.require("dojo.dnd.*");
	dojo.declare("dojo.dnd.HtmlDragMoveSource", dojo.dnd.HtmlDragSource, {onDragStart:function () {
		var dragObj = new dojo.dnd.HtmlDragMoveObject(this.dragObject, this.type);
		if (this.constrainToContainer) {
			dragObj.constrainTo(this.constrainingContainer);
		}
		return dragObj;
	}, onSelected:function () {
		for (var i = 0; i < this.dragObjects.length; i++) {
			dojo.dnd.dragManager.selectedSources.push(new dojo.dnd.HtmlDragMoveSource(this.dragObjects[i]));
		}
	}});
	dojo.declare("dojo.dnd.HtmlDragMoveObject", dojo.dnd.HtmlDragObject, {onDragStart:function (e) {
		dojo.html.clearSelection();
		this.dragClone = this.domNode;
		if (dojo.html.getComputedStyle(this.domNode, "position") != "absolute") {
			this.domNode.style.position = "relative";
		}
		var left = parseInt(dojo.html.getComputedStyle(this.domNode, "left"));
		var top = parseInt(dojo.html.getComputedStyle(this.domNode, "top"));
		this.dragStartPosition = {x:isNaN(left) ? 0 : left, y:isNaN(top) ? 0 : top};
		this.scrollOffset = dojo.html.getScroll().offset;
		this.dragOffset = {y:this.dragStartPosition.y - e.pageY, x:this.dragStartPosition.x - e.pageX};
		this.containingBlockPosition = {x:0, y:0};
		if (this.constrainToContainer) {
			this.constraints = this.getConstraints();
		}
		dojo.event.connect(this.domNode, "onclick", this, "_squelchOnClick");
	}, onDragEnd:function (e) {
	}, setAbsolutePosition:function (x, y) {
		if (!this.disableY) {
			this.domNode.style.top = y + "px";
		}
		if (!this.disableX) {
			this.domNode.style.left = x + "px";
		}
	}, _squelchOnClick:function (e) {
		dojo.event.browser.stopEvent(e);
		dojo.event.disconnect(this.domNode, "onclick", this, "_squelchOnClick");
	}});
}});


__CPAN_FILE__ src/dnd/HtmlDragAndDrop.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.dnd.HtmlDragAndDrop");
dojo.require("dojo.dnd.HtmlDragManager");
dojo.require("dojo.dnd.DragAndDrop");
dojo.require("dojo.html.*");
dojo.require("dojo.html.display");
dojo.require("dojo.html.util");
dojo.require("dojo.html.selection");
dojo.require("dojo.html.iframe");
dojo.require("dojo.lang.extras");
dojo.require("dojo.lfx.*");
dojo.require("dojo.event.*");
dojo.declare("dojo.dnd.HtmlDragSource", dojo.dnd.DragSource, {dragClass:"", onDragStart:function () {
	var dragObj = new dojo.dnd.HtmlDragObject(this.dragObject, this.type);
	if (this.dragClass) {
		dragObj.dragClass = this.dragClass;
	}
	if (this.constrainToContainer) {
		dragObj.constrainTo(this.constrainingContainer || this.domNode.parentNode);
	}
	return dragObj;
}, setDragHandle:function (node) {
	node = dojo.byId(node);
	dojo.dnd.dragManager.unregisterDragSource(this);
	this.domNode = node;
	dojo.dnd.dragManager.registerDragSource(this);
}, setDragTarget:function (node) {
	this.dragObject = node;
}, constrainTo:function (container) {
	this.constrainToContainer = true;
	if (container) {
		this.constrainingContainer = container;
	}
}, onSelected:function () {
	for (var i = 0; i < this.dragObjects.length; i++) {
		dojo.dnd.dragManager.selectedSources.push(new dojo.dnd.HtmlDragSource(this.dragObjects[i]));
	}
}, addDragObjects:function (el) {
	for (var i = 0; i < arguments.length; i++) {
		this.dragObjects.push(dojo.byId(arguments[i]));
	}
}}, function (node, type) {
	node = dojo.byId(node);
	this.dragObjects = [];
	this.constrainToContainer = false;
	if (node) {
		this.domNode = node;
		this.dragObject = node;
		this.type = (type) || (this.domNode.nodeName.toLowerCase());
		dojo.dnd.DragSource.prototype.reregister.call(this);
	}
});
dojo.declare("dojo.dnd.HtmlDragObject", dojo.dnd.DragObject, {dragClass:"", opacity:0.5, createIframe:true, disableX:false, disableY:false, createDragNode:function () {
	var node = this.domNode.cloneNode(true);
	if (this.dragClass) {
		dojo.html.addClass(node, this.dragClass);
	}
	if (this.opacity < 1) {
		dojo.html.setOpacity(node, this.opacity);
	}
	var ltn = node.tagName.toLowerCase();
	var isTr = (ltn == "tr");
	if ((isTr) || (ltn == "tbody")) {
		var doc = this.domNode.ownerDocument;
		var table = doc.createElement("table");
		if (isTr) {
			var tbody = doc.createElement("tbody");
			table.appendChild(tbody);
			tbody.appendChild(node);
		} else {
			table.appendChild(node);
		}
		var tmpSrcTr = ((isTr) ? this.domNode : this.domNode.firstChild);
		var tmpDstTr = ((isTr) ? node : node.firstChild);
		var domTds = tmpSrcTr.childNodes;
		var cloneTds = tmpDstTr.childNodes;
		for (var i = 0; i < domTds.length; i++) {
			if ((cloneTds[i]) && (cloneTds[i].style)) {
				cloneTds[i].style.width = dojo.html.getContentBox(domTds[i]).width + "px";
			}
		}
		node = table;
	}
	if ((dojo.render.html.ie55 || dojo.render.html.ie60) && this.createIframe) {
		with (node.style) {
			top = "0px";
			left = "0px";
		}
		var outer = document.createElement("div");
		outer.appendChild(node);
		this.bgIframe = new dojo.html.BackgroundIframe(outer);
		outer.appendChild(this.bgIframe.iframe);
		node = outer;
	}
	node.style.zIndex = 999;
	return node;
}, onDragStart:function (e) {
	dojo.html.clearSelection();
	this.scrollOffset = dojo.html.getScroll().offset;
	this.dragStartPosition = dojo.html.getAbsolutePosition(this.domNode, true);
	this.dragOffset = {y:this.dragStartPosition.y - e.pageY, x:this.dragStartPosition.x - e.pageX};
	this.dragClone = this.createDragNode();
	this.containingBlockPosition = this.domNode.offsetParent ? dojo.html.getAbsolutePosition(this.domNode.offsetParent, true) : {x:0, y:0};
	if (this.constrainToContainer) {
		this.constraints = this.getConstraints();
	}
	with (this.dragClone.style) {
		position = "absolute";
		top = this.dragOffset.y + e.pageY + "px";
		left = this.dragOffset.x + e.pageX + "px";
	}
	dojo.body().appendChild(this.dragClone);
	dojo.event.topic.publish("dragStart", {source:this});
}, getConstraints:function () {
	if (this.constrainingContainer.nodeName.toLowerCase() == "body") {
		var viewport = dojo.html.getViewport();
		var width = viewport.width;
		var height = viewport.height;
		var scroll = dojo.html.getScroll().offset;
		var x = scroll.x;
		var y = scroll.y;
	} else {
		var content = dojo.html.getContentBox(this.constrainingContainer);
		width = content.width;
		height = content.height;
		x = this.containingBlockPosition.x + dojo.html.getPixelValue(this.constrainingContainer, "padding-left", true) + dojo.html.getBorderExtent(this.constrainingContainer, "left");
		y = this.containingBlockPosition.y + dojo.html.getPixelValue(this.constrainingContainer, "padding-top", true) + dojo.html.getBorderExtent(this.constrainingContainer, "top");
	}
	var mb = dojo.html.getMarginBox(this.domNode);
	return {minX:x, minY:y, maxX:x + width - mb.width, maxY:y + height - mb.height};
}, updateDragOffset:function () {
	var scroll = dojo.html.getScroll().offset;
	if (scroll.y != this.scrollOffset.y) {
		var diff = scroll.y - this.scrollOffset.y;
		this.dragOffset.y += diff;
		this.scrollOffset.y = scroll.y;
	}
	if (scroll.x != this.scrollOffset.x) {
		var diff = scroll.x - this.scrollOffset.x;
		this.dragOffset.x += diff;
		this.scrollOffset.x = scroll.x;
	}
}, onDragMove:function (e) {
	this.updateDragOffset();
	var x = this.dragOffset.x + e.pageX;
	var y = this.dragOffset.y + e.pageY;
	if (this.constrainToContainer) {
		if (x < this.constraints.minX) {
			x = this.constraints.minX;
		}
		if (y < this.constraints.minY) {
			y = this.constraints.minY;
		}
		if (x > this.constraints.maxX) {
			x = this.constraints.maxX;
		}
		if (y > this.constraints.maxY) {
			y = this.constraints.maxY;
		}
	}
	this.setAbsolutePosition(x, y);
	dojo.event.topic.publish("dragMove", {source:this});
}, setAbsolutePosition:function (x, y) {
	if (!this.disableY) {
		this.dragClone.style.top = y + "px";
	}
	if (!this.disableX) {
		this.dragClone.style.left = x + "px";
	}
}, onDragEnd:function (e) {
	switch (e.dragStatus) {
	  case "dropSuccess":
		dojo.html.removeNode(this.dragClone);
		this.dragClone = null;
		break;
	  case "dropFailure":
		var startCoords = dojo.html.getAbsolutePosition(this.dragClone, true);
		var endCoords = {left:this.dragStartPosition.x + 1, top:this.dragStartPosition.y + 1};
		var anim = dojo.lfx.slideTo(this.dragClone, endCoords, 300);
		var dragObject = this;
		dojo.event.connect(anim, "onEnd", function (e) {
			dojo.html.removeNode(dragObject.dragClone);
			dragObject.dragClone = null;
		});
		anim.play();
		break;
	}
	dojo.event.topic.publish("dragEnd", {source:this});
}, constrainTo:function (container) {
	this.constrainToContainer = true;
	if (container) {
		this.constrainingContainer = container;
	} else {
		this.constrainingContainer = this.domNode.parentNode;
	}
}}, function (node, type) {
	this.domNode = dojo.byId(node);
	this.type = type;
	this.constrainToContainer = false;
	this.dragSource = null;
	dojo.dnd.DragObject.prototype.register.call(this);
});
dojo.declare("dojo.dnd.HtmlDropTarget", dojo.dnd.DropTarget, {vertical:false, onDragOver:function (e) {
	if (!this.accepts(e.dragObjects)) {
		return false;
	}
	this.childBoxes = [];
	for (var i = 0, child; i < this.domNode.childNodes.length; i++) {
		child = this.domNode.childNodes[i];
		if (child.nodeType != dojo.html.ELEMENT_NODE) {
			continue;
		}
		var pos = dojo.html.getAbsolutePosition(child, true);
		var inner = dojo.html.getBorderBox(child);
		this.childBoxes.push({top:pos.y, bottom:pos.y + inner.height, left:pos.x, right:pos.x + inner.width, height:inner.height, width:inner.width, node:child});
	}
	return true;
}, _getNodeUnderMouse:function (e) {
	for (var i = 0, child; i < this.childBoxes.length; i++) {
		with (this.childBoxes[i]) {
			if (e.pageX >= left && e.pageX <= right && e.pageY >= top && e.pageY <= bottom) {
				return i;
			}
		}
	}
	return -1;
}, createDropIndicator:function () {
	this.dropIndicator = document.createElement("div");
	with (this.dropIndicator.style) {
		position = "absolute";
		zIndex = 999;
		if (this.vertical) {
			borderLeftWidth = "1px";
			borderLeftColor = "black";
			borderLeftStyle = "solid";
			height = dojo.html.getBorderBox(this.domNode).height + "px";
			top = dojo.html.getAbsolutePosition(this.domNode, true).y + "px";
		} else {
			borderTopWidth = "1px";
			borderTopColor = "black";
			borderTopStyle = "solid";
			width = dojo.html.getBorderBox(this.domNode).width + "px";
			left = dojo.html.getAbsolutePosition(this.domNode, true).x + "px";
		}
	}
}, onDragMove:function (e, dragObjects) {
	var i = this._getNodeUnderMouse(e);
	if (!this.dropIndicator) {
		this.createDropIndicator();
	}
	var gravity = this.vertical ? dojo.html.gravity.WEST : dojo.html.gravity.NORTH;
	var hide = false;
	if (i < 0) {
		if (this.childBoxes.length) {
			var before = (dojo.html.gravity(this.childBoxes[0].node, e) & gravity);
			if (before) {
				hide = true;
			}
		} else {
			var before = true;
		}
	} else {
		var child = this.childBoxes[i];
		var before = (dojo.html.gravity(child.node, e) & gravity);
		if (child.node === dragObjects[0].dragSource.domNode) {
			hide = true;
		} else {
			var currentPosChild = before ? (i > 0 ? this.childBoxes[i - 1] : child) : (i < this.childBoxes.length - 1 ? this.childBoxes[i + 1] : child);
			if (currentPosChild.node === dragObjects[0].dragSource.domNode) {
				hide = true;
			}
		}
	}
	if (hide) {
		this.dropIndicator.style.display = "none";
		return;
	} else {
		this.dropIndicator.style.display = "";
	}
	this.placeIndicator(e, dragObjects, i, before);
	if (!dojo.html.hasParent(this.dropIndicator)) {
		dojo.body().appendChild(this.dropIndicator);
	}
}, placeIndicator:function (e, dragObjects, boxIndex, before) {
	var targetProperty = this.vertical ? "left" : "top";
	var child;
	if (boxIndex < 0) {
		if (this.childBoxes.length) {
			child = before ? this.childBoxes[0] : this.childBoxes[this.childBoxes.length - 1];
		} else {
			this.dropIndicator.style[targetProperty] = dojo.html.getAbsolutePosition(this.domNode, true)[this.vertical ? "x" : "y"] + "px";
		}
	} else {
		child = this.childBoxes[boxIndex];
	}
	if (child) {
		this.dropIndicator.style[targetProperty] = (before ? child[targetProperty] : child[this.vertical ? "right" : "bottom"]) + "px";
		if (this.vertical) {
			this.dropIndicator.style.height = child.height + "px";
			this.dropIndicator.style.top = child.top + "px";
		} else {
			this.dropIndicator.style.width = child.width + "px";
			this.dropIndicator.style.left = child.left + "px";
		}
	}
}, onDragOut:function (e) {
	if (this.dropIndicator) {
		dojo.html.removeNode(this.dropIndicator);
		delete this.dropIndicator;
	}
}, onDrop:function (e) {
	this.onDragOut(e);
	var i = this._getNodeUnderMouse(e);
	var gravity = this.vertical ? dojo.html.gravity.WEST : dojo.html.gravity.NORTH;
	if (i < 0) {
		if (this.childBoxes.length) {
			if (dojo.html.gravity(this.childBoxes[0].node, e) & gravity) {
				return this.insert(e, this.childBoxes[0].node, "before");
			} else {
				return this.insert(e, this.childBoxes[this.childBoxes.length - 1].node, "after");
			}
		}
		return this.insert(e, this.domNode, "append");
	}
	var child = this.childBoxes[i];
	if (dojo.html.gravity(child.node, e) & gravity) {
		return this.insert(e, child.node, "before");
	} else {
		return this.insert(e, child.node, "after");
	}
}, insert:function (e, refNode, position) {
	var node = e.dragObject.domNode;
	if (position == "before") {
		return dojo.html.insertBefore(node, refNode);
	} else {
		if (position == "after") {
			return dojo.html.insertAfter(node, refNode);
		} else {
			if (position == "append") {
				refNode.appendChild(node);
				return true;
			}
		}
	}
	return false;
}}, function (node, types) {
	if (arguments.length == 0) {
		return;
	}
	this.domNode = dojo.byId(node);
	dojo.dnd.DropTarget.call(this);
	if (types && dojo.lang.isString(types)) {
		types = [types];
	}
	this.acceptedTypes = types || [];
	dojo.dnd.dragManager.registerDropTarget(this);
});


__CPAN_FILE__ src/dnd/__package__.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["kwCompoundRequire", {common:["dojo.dnd.DragAndDrop"], browser:["dojo.dnd.HtmlDragAndDrop"], dashboard:["dojo.dnd.HtmlDragAndDrop"]}], ["provide", "dojo.dnd.*"]], definePackage:function (dojo) {
	dojo.kwCompoundRequire({common:["dojo.dnd.DragAndDrop"], browser:["dojo.dnd.HtmlDragAndDrop"], dashboard:["dojo.dnd.HtmlDragAndDrop"]});
	dojo.provide("dojo.dnd.*");
}});


__CPAN_FILE__ src/dnd/HtmlDragCopy.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.dnd.HtmlDragCopy"], ["require", "dojo.dnd.*"]], definePackage:function (dojo) {
	dojo.provide("dojo.dnd.HtmlDragCopy");
	dojo.require("dojo.dnd.*");
	dojo.declare("dojo.dnd.HtmlDragCopySource", dojo.dnd.HtmlDragSource, function (node, type, copyOnce) {
		this.copyOnce = copyOnce;
		this.makeCopy = true;
	}, {onDragStart:function () {
		var dragObj = new dojo.dnd.HtmlDragCopyObject(this.dragObject, this.type, this);
		if (this.dragClass) {
			dragObj.dragClass = this.dragClass;
		}
		if (this.constrainToContainer) {
			dragObj.constrainTo(this.constrainingContainer || this.domNode.parentNode);
		}
		return dragObj;
	}, onSelected:function () {
		for (var i = 0; i < this.dragObjects.length; i++) {
			dojo.dnd.dragManager.selectedSources.push(new dojo.dnd.HtmlDragCopySource(this.dragObjects[i]));
		}
	}});
	dojo.declare("dojo.dnd.HtmlDragCopyObject", dojo.dnd.HtmlDragObject, function (dragObject, type, source) {
		this.copySource = source;
	}, {onDragStart:function (e) {
		dojo.dnd.HtmlDragCopyObject.superclass.onDragStart.apply(this, arguments);
		if (this.copySource.makeCopy) {
			this.sourceNode = this.domNode;
			this.domNode = this.domNode.cloneNode(true);
		}
	}, onDragEnd:function (e) {
		switch (e.dragStatus) {
		  case "dropFailure":
			var startCoords = dojo.html.getAbsolutePosition(this.dragClone, true);
			var endCoords = {left:this.dragStartPosition.x + 1, top:this.dragStartPosition.y + 1};
			var anim = dojo.lfx.slideTo(this.dragClone, endCoords, 500, dojo.lfx.easeOut);
			var dragObject = this;
			dojo.event.connect(anim, "onEnd", function (e) {
				dojo.lang.setTimeout(function () {
					dojo.html.removeNode(dragObject.dragClone);
					dragObject.dragClone = null;
					if (dragObject.copySource.makeCopy) {
						dojo.html.removeNode(dragObject.domNode);
						dragObject.domNode = dragObject.sourceNode;
						dragObject.sourceNode = null;
					}
				}, 200);
			});
			anim.play();
			dojo.event.topic.publish("dragEnd", {source:this});
			return;
		}
		dojo.dnd.HtmlDragCopyObject.superclass.onDragEnd.apply(this, arguments);
		this.copySource.dragObject = this.domNode;
		if (this.copySource.copyOnce) {
			this.copySource.makeCopy = false;
		}
		new dojo.dnd.HtmlDragCopySource(this.sourceNode, this.type, this.copySource.copyOnce);
		this.sourceNode = null;
	}});
}});


__CPAN_FILE__ src/dnd/Sortable.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.dnd.Sortable"], ["require", "dojo.dnd.*"]], definePackage:function (dojo) {
	dojo.provide("dojo.dnd.Sortable");
	dojo.require("dojo.dnd.*");
	dojo.dnd.Sortable = function () {
	};
	dojo.lang.extend(dojo.dnd.Sortable, {ondragstart:function (e) {
		var dragObject = e.target;
		while (dragObject.parentNode && dragObject.parentNode != this) {
			dragObject = dragObject.parentNode;
		}
		return dragObject;
	}});
}});


__CPAN_FILE__ src/dnd/TreeDragAndDrop.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.dnd.TreeDragAndDrop");
dojo.require("dojo.dnd.HtmlDragAndDrop");
dojo.require("dojo.lang.func");
dojo.require("dojo.lang.array");
dojo.require("dojo.lang.extras");
dojo.require("dojo.html.layout");
dojo.dnd.TreeDragSource = function (node, syncController, type, treeNode) {
	this.controller = syncController;
	this.treeNode = treeNode;
	dojo.dnd.HtmlDragSource.call(this, node, type);
};
dojo.inherits(dojo.dnd.TreeDragSource, dojo.dnd.HtmlDragSource);
dojo.lang.extend(dojo.dnd.TreeDragSource, {onDragStart:function () {
	var dragObject = dojo.dnd.HtmlDragSource.prototype.onDragStart.call(this);
	dragObject.treeNode = this.treeNode;
	dragObject.onDragStart = dojo.lang.hitch(dragObject, function (e) {
		this.savedSelectedNode = this.treeNode.tree.selector.selectedNode;
		if (this.savedSelectedNode) {
			this.savedSelectedNode.unMarkSelected();
		}
		var result = dojo.dnd.HtmlDragObject.prototype.onDragStart.apply(this, arguments);
		var cloneGrid = this.dragClone.getElementsByTagName("img");
		for (var i = 0; i < cloneGrid.length; i++) {
			cloneGrid.item(i).style.backgroundImage = "url()";
		}
		return result;
	});
	dragObject.onDragEnd = function (e) {
		if (this.savedSelectedNode) {
			this.savedSelectedNode.markSelected();
		}
		return dojo.dnd.HtmlDragObject.prototype.onDragEnd.apply(this, arguments);
	};
	return dragObject;
}, onDragEnd:function (e) {
	var res = dojo.dnd.HtmlDragSource.prototype.onDragEnd.call(this, e);
	return res;
}});
dojo.dnd.TreeDropTarget = function (domNode, controller, type, treeNode) {
	this.treeNode = treeNode;
	this.controller = controller;
	dojo.dnd.HtmlDropTarget.apply(this, [domNode, type]);
};
dojo.inherits(dojo.dnd.TreeDropTarget, dojo.dnd.HtmlDropTarget);
dojo.lang.extend(dojo.dnd.TreeDropTarget, {autoExpandDelay:1500, autoExpandTimer:null, position:null, indicatorStyle:"2px black solid", showIndicator:function (position) {
	if (this.position == position) {
		return;
	}
	this.hideIndicator();
	this.position = position;
	if (position == "before") {
		this.treeNode.labelNode.style.borderTop = this.indicatorStyle;
	} else {
		if (position == "after") {
			this.treeNode.labelNode.style.borderBottom = this.indicatorStyle;
		} else {
			if (position == "onto") {
				this.treeNode.markSelected();
			}
		}
	}
}, hideIndicator:function () {
	this.treeNode.labelNode.style.borderBottom = "";
	this.treeNode.labelNode.style.borderTop = "";
	this.treeNode.unMarkSelected();
	this.position = null;
}, onDragOver:function (e) {
	var accepts = dojo.dnd.HtmlDropTarget.prototype.onDragOver.apply(this, arguments);
	if (accepts && this.treeNode.isFolder && !this.treeNode.isExpanded) {
		this.setAutoExpandTimer();
	}
	return accepts;
}, accepts:function (dragObjects) {
	var accepts = dojo.dnd.HtmlDropTarget.prototype.accepts.apply(this, arguments);
	if (!accepts) {
		return false;
	}
	var sourceTreeNode = dragObjects[0].treeNode;
	if (dojo.lang.isUndefined(sourceTreeNode) || !sourceTreeNode || !sourceTreeNode.isTreeNode) {
		dojo.raise("Source is not TreeNode or not found");
	}
	if (sourceTreeNode === this.treeNode) {
		return false;
	}
	return true;
}, setAutoExpandTimer:function () {
	var _this = this;
	var autoExpand = function () {
		if (dojo.dnd.dragManager.currentDropTarget === _this) {
			_this.controller.expand(_this.treeNode);
		}
	};
	this.autoExpandTimer = dojo.lang.setTimeout(autoExpand, _this.autoExpandDelay);
}, getDNDMode:function () {
	return this.treeNode.tree.DNDMode;
}, getAcceptPosition:function (e, sourceTreeNode) {
	var DNDMode = this.getDNDMode();
	if (DNDMode & dojo.widget.Tree.prototype.DNDModes.ONTO && !(!this.treeNode.actionIsDisabled(dojo.widget.TreeNode.prototype.actions.ADDCHILD) && sourceTreeNode.parent !== this.treeNode && this.controller.canMove(sourceTreeNode, this.treeNode))) {
		DNDMode &= ~dojo.widget.Tree.prototype.DNDModes.ONTO;
	}
	var position = this.getPosition(e, DNDMode);
	if (position == "onto" || (!this.isAdjacentNode(sourceTreeNode, position) && this.controller.canMove(sourceTreeNode, this.treeNode.parent))) {
		return position;
	} else {
		return false;
	}
}, onDragOut:function (e) {
	this.clearAutoExpandTimer();
	this.hideIndicator();
}, clearAutoExpandTimer:function () {
	if (this.autoExpandTimer) {
		clearTimeout(this.autoExpandTimer);
		this.autoExpandTimer = null;
	}
}, onDragMove:function (e, dragObjects) {
	var sourceTreeNode = dragObjects[0].treeNode;
	var position = this.getAcceptPosition(e, sourceTreeNode);
	if (position) {
		this.showIndicator(position);
	}
}, isAdjacentNode:function (sourceNode, position) {
	if (sourceNode === this.treeNode) {
		return true;
	}
	if (sourceNode.getNextSibling() === this.treeNode && position == "before") {
		return true;
	}
	if (sourceNode.getPreviousSibling() === this.treeNode && position == "after") {
		return true;
	}
	return false;
}, getPosition:function (e, DNDMode) {
	var node = dojo.byId(this.treeNode.labelNode);
	var mousey = e.pageY || e.clientY + dojo.body().scrollTop;
	var nodey = dojo.html.getAbsolutePosition(node).y;
	var height = dojo.html.getBorderBox(node).height;
	var relY = mousey - nodey;
	var p = relY / height;
	var position = "";
	if (DNDMode & dojo.widget.Tree.prototype.DNDModes.ONTO && DNDMode & dojo.widget.Tree.prototype.DNDModes.BETWEEN) {
		if (p <= 0.3) {
			position = "before";
		} else {
			if (p <= 0.7) {
				position = "onto";
			} else {
				position = "after";
			}
		}
	} else {
		if (DNDMode & dojo.widget.Tree.prototype.DNDModes.BETWEEN) {
			if (p <= 0.5) {
				position = "before";
			} else {
				position = "after";
			}
		} else {
			if (DNDMode & dojo.widget.Tree.prototype.DNDModes.ONTO) {
				position = "onto";
			}
		}
	}
	return position;
}, getTargetParentIndex:function (sourceTreeNode, position) {
	var index = position == "before" ? this.treeNode.getParentIndex() : this.treeNode.getParentIndex() + 1;
	if (this.treeNode.parent === sourceTreeNode.parent && this.treeNode.getParentIndex() > sourceTreeNode.getParentIndex()) {
		index--;
	}
	return index;
}, onDrop:function (e) {
	var position = this.position;
	this.onDragOut(e);
	var sourceTreeNode = e.dragObject.treeNode;
	if (!dojo.lang.isObject(sourceTreeNode)) {
		dojo.raise("TreeNode not found in dragObject");
	}
	if (position == "onto") {
		return this.controller.move(sourceTreeNode, this.treeNode, 0);
	} else {
		var index = this.getTargetParentIndex(sourceTreeNode, position);
		return this.controller.move(sourceTreeNode, this.treeNode.parent, index);
	}
}});
dojo.dnd.TreeDNDController = function (treeController) {
	this.treeController = treeController;
	this.dragSources = {};
	this.dropTargets = {};
};
dojo.lang.extend(dojo.dnd.TreeDNDController, {listenTree:function (tree) {
	dojo.event.topic.subscribe(tree.eventNames.createDOMNode, this, "onCreateDOMNode");
	dojo.event.topic.subscribe(tree.eventNames.moveFrom, this, "onMoveFrom");
	dojo.event.topic.subscribe(tree.eventNames.moveTo, this, "onMoveTo");
	dojo.event.topic.subscribe(tree.eventNames.addChild, this, "onAddChild");
	dojo.event.topic.subscribe(tree.eventNames.removeNode, this, "onRemoveNode");
	dojo.event.topic.subscribe(tree.eventNames.treeDestroy, this, "onTreeDestroy");
}, unlistenTree:function (tree) {
	dojo.event.topic.unsubscribe(tree.eventNames.createDOMNode, this, "onCreateDOMNode");
	dojo.event.topic.unsubscribe(tree.eventNames.moveFrom, this, "onMoveFrom");
	dojo.event.topic.unsubscribe(tree.eventNames.moveTo, this, "onMoveTo");
	dojo.event.topic.unsubscribe(tree.eventNames.addChild, this, "onAddChild");
	dojo.event.topic.unsubscribe(tree.eventNames.removeNode, this, "onRemoveNode");
	dojo.event.topic.unsubscribe(tree.eventNames.treeDestroy, this, "onTreeDestroy");
}, onTreeDestroy:function (message) {
	this.unlistenTree(message.source);
}, onCreateDOMNode:function (message) {
	this.registerDNDNode(message.source);
}, onAddChild:function (message) {
	this.registerDNDNode(message.child);
}, onMoveFrom:function (message) {
	var _this = this;
	dojo.lang.forEach(message.child.getDescendants(), function (node) {
		_this.unregisterDNDNode(node);
	});
}, onMoveTo:function (message) {
	var _this = this;
	dojo.lang.forEach(message.child.getDescendants(), function (node) {
		_this.registerDNDNode(node);
	});
}, registerDNDNode:function (node) {
	if (!node.tree.DNDMode) {
		return;
	}
	var source = null;
	var target = null;
	if (!node.actionIsDisabled(node.actions.MOVE)) {
		var source = new dojo.dnd.TreeDragSource(node.labelNode, this, node.tree.widgetId, node);
		this.dragSources[node.widgetId] = source;
	}
	var target = new dojo.dnd.TreeDropTarget(node.labelNode, this.treeController, node.tree.DNDAcceptTypes, node);
	this.dropTargets[node.widgetId] = target;
}, unregisterDNDNode:function (node) {
	if (this.dragSources[node.widgetId]) {
		dojo.dnd.dragManager.unregisterDragSource(this.dragSources[node.widgetId]);
		delete this.dragSources[node.widgetId];
	}
	if (this.dropTargets[node.widgetId]) {
		dojo.dnd.dragManager.unregisterDropTarget(this.dropTargets[node.widgetId]);
		delete this.dropTargets[node.widgetId];
	}
}});


__CPAN_DIR__ src/graphics
__CPAN_FILE__ src/graphics/Colorspace.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.graphics.Colorspace"], ["require", "dojo.gfx.Colorspace"]], definePackage:function (dojo) {
	dojo.provide("dojo.graphics.Colorspace");
	dojo.require("dojo.gfx.Colorspace");
	dojo.deprecated("dojo.graphics.Colorspace: use dojo.gfx.Colorspace instead.", "0.5");
	dojo.graphics.Colorspace = dojo.gfx.Colorspace;
}});


__CPAN_FILE__ src/graphics/color.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.graphics.color");
dojo.require("dojo.gfx.color");
dojo.deprecated("dojo.graphics.color.Color is now dojo.gfx.color.Color.", "0.5");
dojo.graphics.color.Color = dojo.gfx.color.Color;
dojo.graphics.color.named = dojo.gfx.color.named;
dojo.graphics.color.blend = function (a, b, weight) {
	dojo.deprecated("dojo.graphics.color.blend is now dojo.gfx.color.blend", "0.5");
	return dojo.gfx.color.blend(a, b, weight);
};
dojo.graphics.color.blendHex = function (a, b, weight) {
	dojo.deprecated("dojo.graphics.color.blendHex is now dojo.gfx.color.blendHex", "0.5");
	return dojo.gfx.color.rgb2hex(dojo.gfx.color.blend(dojo.gfx.color.hex2rgb(a), dojo.gfx.color.hex2rgb(b), weight));
};
dojo.graphics.color.extractRGB = function (color) {
	dojo.deprecated("dojo.graphics.color.extractRGB is now dojo.gfx.color.extractRGB", "0.5");
	return dojo.gfx.color.extractRGB(color);
};
dojo.graphics.color.hex2rgb = function (hex) {
	dojo.deprecated("dojo.graphics.color.hex2rgb is now dojo.gfx.color.hex2rgb", "0.5");
	return dojo.gfx.color.hex2rgb(hex);
};
dojo.graphics.color.rgb2hex = function (r, g, b) {
	dojo.deprecated("dojo.graphics.color.rgb2hex is now dojo.gfx.color.rgb2hex", "0.5");
	return dojo.gfx.color.rgb2hex;
};


__CPAN_FILE__ src/graphics/color.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.graphics.color"], ["require", "dojo.gfx.color"]], definePackage:function (dojo) {
	dojo.provide("dojo.graphics.color");
	dojo.require("dojo.gfx.color");
	dojo.deprecated("dojo.graphics.color.Color is now dojo.gfx.color.Color.", "0.5");
	dojo.graphics.color.Color = dojo.gfx.color.Color;
	dojo.graphics.color.named = dojo.gfx.color.named;
	dojo.graphics.color.blend = function (a, b, weight) {
		dojo.deprecated("dojo.graphics.color.blend is now dojo.gfx.color.blend", "0.5");
		return dojo.gfx.color.blend(a, b, weight);
	};
	dojo.graphics.color.blendHex = function (a, b, weight) {
		dojo.deprecated("dojo.graphics.color.blendHex is now dojo.gfx.color.blendHex", "0.5");
		return dojo.gfx.color.rgb2hex(dojo.gfx.color.blend(dojo.gfx.color.hex2rgb(a), dojo.gfx.color.hex2rgb(b), weight));
	};
	dojo.graphics.color.extractRGB = function (color) {
		dojo.deprecated("dojo.graphics.color.extractRGB is now dojo.gfx.color.extractRGB", "0.5");
		return dojo.gfx.color.extractRGB(color);
	};
	dojo.graphics.color.hex2rgb = function (hex) {
		dojo.deprecated("dojo.graphics.color.hex2rgb is now dojo.gfx.color.hex2rgb", "0.5");
		return dojo.gfx.color.hex2rgb(hex);
	};
	dojo.graphics.color.rgb2hex = function (r, g, b) {
		dojo.deprecated("dojo.graphics.color.rgb2hex is now dojo.gfx.color.rgb2hex", "0.5");
		return dojo.gfx.color.rgb2hex;
	};
}});


__CPAN_FILE__ src/graphics/__package__.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.graphics.*");


__CPAN_FILE__ src/graphics/Colorspace.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.graphics.Colorspace");
dojo.require("dojo.gfx.Colorspace");
dojo.deprecated("dojo.graphics.Colorspace: use dojo.gfx.Colorspace instead.", "0.5");
dojo.graphics.Colorspace = dojo.gfx.Colorspace;


__CPAN_FILE__ src/graphics/__package__.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.graphics.*"]], definePackage:function (dojo) {
	dojo.provide("dojo.graphics.*");
}});


__CPAN_DIR__ src/graphics/color
__CPAN_FILE__ src/graphics/color/hsl.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.graphics.color.hsl"], ["require", "dojo.gfx.color.hsl"]], definePackage:function (dojo) {
	dojo.provide("dojo.graphics.color.hsl");
	dojo.require("dojo.gfx.color.hsl");
	dojo.deprecated("dojo.graphics.color.hsl has been replaced with dojo.gfx.color.hsl", "0.5");
	dojo.graphics.color.rgb2hsl = function (r, g, b) {
		dojo.deprecated("dojo.graphics.color.rgb2hsl has been replaced with dojo.gfx.color.rgb2hsl", "0.5");
		return dojo.gfx.color.rgb2hsl(r, g, b);
	};
	dojo.graphics.color.hsl2rgb = function (h, s, l) {
		dojo.deprecated("dojo.graphics.color.hsl2rgb has been replaced with dojo.gfx.color.hsl2rgb", "0.5");
		return dojo.gfx.color.hsl2rgb(h, s, l);
	};
	dojo.graphics.color.hsl2hex = function (h, s, l) {
		dojo.deprecated("dojo.graphics.color.hsl2hex has been replaced with dojo.gfx.color.hsl2hex", "0.5");
		return dojo.gfx.color.hsl2hex(h, s, l);
	};
	dojo.graphics.color.hex2hsl = function (hex) {
		dojo.deprecated("dojo.graphics.color.hex2hsl has been replaced with dojo.gfx.color.hex2hsl", "0.5");
		return dojo.gfx.color.hex2hsl(hex);
	};
}});


__CPAN_FILE__ src/graphics/color/hsl.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.graphics.color.hsl");
dojo.require("dojo.gfx.color.hsl");
dojo.deprecated("dojo.graphics.color.hsl has been replaced with dojo.gfx.color.hsl", "0.5");
dojo.graphics.color.rgb2hsl = function (r, g, b) {
	dojo.deprecated("dojo.graphics.color.rgb2hsl has been replaced with dojo.gfx.color.rgb2hsl", "0.5");
	return dojo.gfx.color.rgb2hsl(r, g, b);
};
dojo.graphics.color.hsl2rgb = function (h, s, l) {
	dojo.deprecated("dojo.graphics.color.hsl2rgb has been replaced with dojo.gfx.color.hsl2rgb", "0.5");
	return dojo.gfx.color.hsl2rgb(h, s, l);
};
dojo.graphics.color.hsl2hex = function (h, s, l) {
	dojo.deprecated("dojo.graphics.color.hsl2hex has been replaced with dojo.gfx.color.hsl2hex", "0.5");
	return dojo.gfx.color.hsl2hex(h, s, l);
};
dojo.graphics.color.hex2hsl = function (hex) {
	dojo.deprecated("dojo.graphics.color.hex2hsl has been replaced with dojo.gfx.color.hex2hsl", "0.5");
	return dojo.gfx.color.hex2hsl(hex);
};


__CPAN_FILE__ src/graphics/color/hsv.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.graphics.color.hsv"], ["require", "dojo.gfx.color.hsv"]], definePackage:function (dojo) {
	dojo.provide("dojo.graphics.color.hsv");
	dojo.require("dojo.gfx.color.hsv");
	dojo.deprecated("dojo.graphics.color.hsv has been replaced by dojo.gfx.color.hsv", "0.5");
	dojo.graphics.color.rgb2hsv = function (r, g, b) {
		dojo.deprecated("dojo.graphics.color.rgb2hsv has been replaced by dojo.gfx.color.rgb2hsv", "0.5");
		return dojo.gfx.color.rgb2hsv(r, g, b);
	};
	dojo.graphics.color.hsv2rgb = function (h, s, v) {
		dojo.deprecated("dojo.graphics.color.hsv2rgb has been replaced by dojo.gfx.color.hsv2rgb", "0.5");
		return dojo.gfx.color.hsv2rgb(h, s, v);
	};
}});


__CPAN_FILE__ src/graphics/color/hsv.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.graphics.color.hsv");
dojo.require("dojo.gfx.color.hsv");
dojo.deprecated("dojo.graphics.color.hsv has been replaced by dojo.gfx.color.hsv", "0.5");
dojo.graphics.color.rgb2hsv = function (r, g, b) {
	dojo.deprecated("dojo.graphics.color.rgb2hsv has been replaced by dojo.gfx.color.rgb2hsv", "0.5");
	return dojo.gfx.color.rgb2hsv(r, g, b);
};
dojo.graphics.color.hsv2rgb = function (h, s, v) {
	dojo.deprecated("dojo.graphics.color.hsv2rgb has been replaced by dojo.gfx.color.hsv2rgb", "0.5");
	return dojo.gfx.color.hsv2rgb(h, s, v);
};


__CPAN_DIR__ src/widget
__CPAN_FILE__ src/widget/TreeCommon.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.widget.TreeCommon"], ["require", "dojo.widget.*"]], definePackage:function (dojo) {
	dojo.provide("dojo.widget.TreeCommon");
	dojo.require("dojo.widget.*");
	dojo.declare("dojo.widget.TreeCommon", null, {listenTreeEvents:[], listenedTrees:{}, listenNodeFilter:null, listenTree:function (tree) {
		var _this = this;
		if (this.listenedTrees[tree.widgetId]) {
			return;
		}
		dojo.lang.forEach(this.listenTreeEvents, function (event) {
			var eventHandler = "on" + event.charAt(0).toUpperCase() + event.substr(1);
			dojo.event.topic.subscribe(tree.eventNames[event], _this, eventHandler);
		});
		var filter;
		if (this.listenNodeFilter) {
			this.processDescendants(tree, this.listenNodeFilter, this.listenNode, true);
		}
		this.listenedTrees[tree.widgetId] = true;
	}, listenNode:function () {
	}, unlistenNode:function () {
	}, unlistenTree:function (tree, nodeFilter) {
		var _this = this;
		if (!this.listenedTrees[tree.widgetId]) {
			return;
		}
		dojo.lang.forEach(this.listenTreeEvents, function (event) {
			var eventHandler = "on" + event.charAt(0).toUpperCase() + event.substr(1);
			dojo.event.topic.unsubscribe(tree.eventNames[event], _this, eventHandler);
		});
		if (this.listenNodeFilter) {
			this.processDescendants(tree, this.listenNodeFilter, this.unlistenNode, true);
		}
		delete this.listenedTrees[tree.widgetId];
	}, checkPathCondition:function (domElement, condition) {
		while (domElement && !domElement.widgetId) {
			if (condition.call(null, domElement)) {
				return true;
			}
			domElement = domElement.parentNode;
		}
		return false;
	}, domElement2TreeNode:function (domElement) {
		while (domElement && !domElement.widgetId) {
			domElement = domElement.parentNode;
		}
		if (!domElement) {
			return null;
		}
		var widget = dojo.widget.byId(domElement.widgetId);
		if (!widget.isTreeNode) {
			return null;
		}
		return widget;
	}, processDescendants:function (elem, filter, func, skipFirst) {
		var _this = this;
		if (!skipFirst) {
			if (!filter.call(_this, elem)) {
				return;
			}
			func.call(_this, elem);
		}
		var stack = [elem];
		while (elem = stack.pop()) {
			dojo.lang.forEach(elem.children, function (elem) {
				if (filter.call(_this, elem)) {
					func.call(_this, elem);
					stack.push(elem);
				}
			});
		}
	}});
}});


__CPAN_FILE__ src/widget/ResizableTextarea.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.widget.ResizableTextarea"], ["require", "dojo.widget.*"], ["require", "dojo.widget.LayoutContainer"], ["require", "dojo.widget.ResizeHandle"]], definePackage:function (dojo) {
	dojo.provide("dojo.widget.ResizableTextarea");
	dojo.require("dojo.widget.*");
	dojo.require("dojo.widget.LayoutContainer");
	dojo.require("dojo.widget.ResizeHandle");
	dojo.widget.defineWidget("dojo.widget.ResizableTextarea", dojo.widget.HtmlWidget, {templateString:"<div>\n\t<div style=\"border: 2px solid black; width: 90%; height: 200px;\"\n\t\tdojoAttachPoint=\"rootLayoutNode\">\n\t\t<div dojoAttachPoint=\"textAreaContainerNode\" \n\t\t\tstyle=\"border: 0px; margin: 0px; overflow: hidden;\">\n\t\t</div>\n\t\t<div dojoAttachPoint=\"statusBarContainerNode\" class=\"statusBar\">\n\t\t\t<div dojoAttachPoint=\"statusLabelNode\" \n\t\t\t\tclass=\"statusPanel\"\n\t\t\t\tstyle=\"padding-right: 0px; z-index: 1;\">drag to resize</div>\n\t\t\t<div dojoAttachPoint=\"resizeHandleNode\"></div>\n\t\t</div>\n\t</div>\n</div>\n", templateCssString:"div.statusBar {\n\tbackground-color: ThreeDFace;\n\theight: 28px;\n\tpadding: 1px;\n\toverflow: hidden;\n\tfont-size: 12px;\n}\n\ndiv.statusPanel {\n\tbackground-color: ThreeDFace;\n\tborder: 1px solid;\n\tborder-color: ThreeDShadow ThreeDHighlight ThreeDHighlight ThreeDShadow;\n\tmargin: 1px;\n\tpadding: 2px 6px;\n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/ResizableTextarea.css"), fillInTemplate:function (args, frag) {
		this.textAreaNode = this.getFragNodeRef(frag).cloneNode(true);
		dojo.body().appendChild(this.domNode);
		this.rootLayout = dojo.widget.createWidget("LayoutContainer", {minHeight:50, minWidth:100}, this.rootLayoutNode);
		this.textAreaContainer = dojo.widget.createWidget("LayoutContainer", {layoutAlign:"client"}, this.textAreaContainerNode);
		this.rootLayout.addChild(this.textAreaContainer);
		this.textAreaContainer.domNode.appendChild(this.textAreaNode);
		with (this.textAreaNode.style) {
			width = "100%";
			height = "100%";
		}
		this.statusBar = dojo.widget.createWidget("LayoutContainer", {layoutAlign:"bottom", minHeight:28}, this.statusBarContainerNode);
		this.rootLayout.addChild(this.statusBar);
		this.statusLabel = dojo.widget.createWidget("LayoutContainer", {layoutAlign:"client", minWidth:50}, this.statusLabelNode);
		this.statusBar.addChild(this.statusLabel);
		this.resizeHandle = dojo.widget.createWidget("ResizeHandle", {targetElmId:this.rootLayout.widgetId}, this.resizeHandleNode);
		this.statusBar.addChild(this.resizeHandle);
	}});
}});


__CPAN_FILE__ src/widget/TreeToggleOnSelect.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.widget.TreeToggleOnSelect");
dojo.require("dojo.widget.HtmlWidget");
dojo.widget.defineWidget("dojo.widget.TreeToggleOnSelect", dojo.widget.HtmlWidget, {selector:"", controller:"", selectEvent:"select", initialize:function () {
	this.selector = dojo.widget.byId(this.selector);
	this.controller = dojo.widget.byId(this.controller);
	dojo.event.topic.subscribe(this.selector.eventNames[this.selectEvent], this, "onSelectEvent");
}, onSelectEvent:function (message) {
	var node = message.node;
	node.isExpanded ? this.controller.collapse(node) : this.controller.expand(node);
}});


__CPAN_FILE__ src/widget/CurrencyTextbox.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.widget.CurrencyTextbox"], ["require", "dojo.widget.IntegerTextbox"], ["require", "dojo.validate.common"]], definePackage:function (dojo) {
	dojo.provide("dojo.widget.CurrencyTextbox");
	dojo.require("dojo.widget.IntegerTextbox");
	dojo.require("dojo.validate.common");
	dojo.widget.defineWidget("dojo.widget.CurrencyTextbox", dojo.widget.IntegerTextbox, {mixInProperties:function (localProperties, frag) {
		dojo.widget.CurrencyTextbox.superclass.mixInProperties.apply(this, arguments);
		if (localProperties.fractional) {
			this.flags.fractional = (localProperties.fractional == "true");
		} else {
			if (localProperties.cents) {
				dojo.deprecated("dojo.widget.IntegerTextbox", "use fractional attr instead of cents", "0.5");
				this.flags.fractional = (localProperties.cents == "true");
			}
		}
		if (localProperties.symbol) {
			this.flags.symbol = localProperties.symbol;
		}
		if (localProperties.min) {
			this.flags.min = parseFloat(localProperties.min);
		}
		if (localProperties.max) {
			this.flags.max = parseFloat(localProperties.max);
		}
	}, isValid:function () {
		return dojo.validate.isCurrency(this.textbox.value, this.flags);
	}, isInRange:function () {
		return dojo.validate.isInRange(this.textbox.value, this.flags);
	}});
}});


__CPAN_FILE__ src/widget/TreeExtension.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.widget.TreeExtension"], ["require", "dojo.widget.HtmlWidget"], ["require", "dojo.widget.TreeCommon"]], definePackage:function (dojo) {
	dojo.provide("dojo.widget.TreeExtension");
	dojo.require("dojo.widget.HtmlWidget");
	dojo.require("dojo.widget.TreeCommon");
	dojo.widget.defineWidget("dojo.widget.TreeExtension", [dojo.widget.HtmlWidget, dojo.widget.TreeCommon], function () {
		this.listenedTrees = {};
	}, {});
}});


__CPAN_FILE__ src/widget/TreeEditor.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.require("dojo.widget.*");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.widget.RichText");
dojo.provide("dojo.widget.TreeEditor");
dojo.widget.defineWidget("dojo.widget.TreeEditor", dojo.widget.HtmlWidget, {singleLineMode:false, saveOnBlur:true, sync:false, selectOnOpen:true, controller:null, node:null, richTextParams:{styleSheets:"src/widget/templates/TreeEditor.css"}, getContents:function () {
	return this.richText.getEditorContent();
}, open:function (node) {
	if (!this.richText) {
		this.richText = dojo.widget.createWidget("RichText", this.richTextParams, node.labelNode);
		dojo.event.connect("around", this.richText, "onKeyDown", this, "richText_onKeyDown");
		dojo.event.connect(this.richText, "onBlur", this, "richText_onBlur");
		var self = this;
		dojo.event.connect(this.richText, "onLoad", function () {
			if (self.selectOnOpen) {
				self.richText.execCommand("selectall");
			}
		});
	} else {
		this.richText.open(node.labelNode);
	}
	this.node = node;
}, close:function (save) {
	this.richText.close(save);
	this.node = null;
}, isClosed:function () {
	return !this.richText || this.richText.isClosed;
}, execCommand:function () {
	this.richText.execCommand.apply(this.richText, arguments);
}, richText_onKeyDown:function (invocation) {
	var e = invocation.args[0];
	if ((!e) && (this.object)) {
		e = dojo.event.browser.fixEvent(this.editor.window.event);
	}
	switch (e.keyCode) {
	  case e.KEY_ESCAPE:
		this.finish(false);
		dojo.event.browser.stopEvent(e);
		break;
	  case e.KEY_ENTER:
		if (e.ctrlKey && !this.singleLineMode) {
			this.execCommand("inserthtml", "<br/>");
		} else {
			this.finish(true);
		}
		dojo.event.browser.stopEvent(e);
		break;
	  default:
		return invocation.proceed();
	}
}, richText_onBlur:function () {
	this.finish(this.saveOnBlur);
}, finish:function (save) {
	return this.controller.editLabelFinish(save, this.sync);
}});


__CPAN_FILE__ src/widget/GoogleMap.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.widget.GoogleMap"], ["require", "dojo.event.*"], ["require", "dojo.math"], ["require", "dojo.widget.*"], ["require", "dojo.uri.Uri"], ["require", "dojo.widget.HtmlWidget"]], definePackage:function (dojo) {
	dojo.provide("dojo.widget.GoogleMap");
	dojo.require("dojo.event.*");
	dojo.require("dojo.math");
	dojo.require("dojo.widget.*");
	dojo.require("dojo.uri.Uri");
	dojo.require("dojo.widget.HtmlWidget");
	(function () {
		var gkey = djConfig["gMapKey"] || djConfig["googleMapKey"];
		var uri = new dojo.uri.Uri(window.location.href);
		if (uri.host == "www.dojotoolkit.org") {
			gkey = "ABQIAAAACUNdgv_7FGOmUslbm9l6_hRqjp7ri2mNiOEYqetD3xnFHpt5rBSjszDd1sdufPyQKUTyCf_YxoIxvw";
		} else {
			if (uri.host == "blog.dojotoolkit.org") {
				gkey = "ABQIAAAACUNdgv_7FGOmUslbm9l6_hSkep6Av1xaMhVn3yCLkorJeXeLARQ6fammI_P3qSGleTJhoI5_1JmP_Q";
			} else {
				if (uri.host == "archive.dojotoolkit.org") {
					gkey = "ABQIAAAACUNdgv_7FGOmUslbm9l6_hTaQpDt0dyGLIHbXMPTzg1kWeAfwRTwZNyrUfbfxYE9yIvRivEjcXoDTg";
				} else {
					if (uri.host == "dojotoolkit.org") {
						gkey = "ABQIAAAACUNdgv_7FGOmUslbm9l6_hSaOaO_TgJ5c3mtQFnk5JO2zD5dZBRZk-ieqVs7BORREYNzAERmcJoEjQ";
					}
				}
			}
		}
		if (!dojo.hostenv.post_load_) {
			if (!gkey || gkey == "") {
				dojo.raise("dojo.widget.GoogleMap: The Google Map widget requires a proper API key in order to be used.");
			}
			var tag = "<scr" + "ipt src='http://maps.google.com/maps?file=api&amp;v=2&amp;key=" + gkey + "'></scri" + "pt>";
			if (!dj_global["GMap2"]) {
				document.write(tag);
			}
		} else {
			dojo.debug("Cannot initialize Google Map system after the page has been loaded! Please either manually include the script block provided by Google in your page or require() the GoogleMap widget before onload has fired.");
		}
	})();
	dojo.widget.defineWidget("dojo.widget.GoogleMap", dojo.widget.HtmlWidget, function () {
		this.map = null;
		this.geocoder = null;
		this.data = [];
		this.datasrc = "";
		this.controls = ["largemap", "scale", "maptype"];
	}, {templatePath:null, templateCssPath:null, isContainer:false, _defaultPoint:{lat:39.10662, lng:-94.578209}, setControls:function () {
		var methodmap = {largemap:GLargeMapControl, smallmap:GSmallMapControl, smallzoom:GSmallZoomControl, scale:GScaleControl, maptype:GMapTypeControl, overview:GOverviewMapControl};
		for (var i = 0; i < this.controls.length; i++) {
			this.map.addControl(new (methodmap[this.controls[i].toLowerCase()])());
		}
	}, findCenter:function (bounds) {
		if (this.data.length == 1) {
			return (new GLatLng(this.data[0].lat, this.data[0].lng));
		}
		var clat = (bounds.getNorthEast().lat() + bounds.getSouthWest().lat()) / 2;
		var clng = (bounds.getNorthEast().lng() + bounds.getSouthWest().lng()) / 2;
		return (new GLatLng(clat, clng));
	}, createPinpoint:function (pt, overlay) {
		var m = new GMarker(pt);
		if (overlay) {
			GEvent.addListener(m, "click", function () {
				m.openInfoWindowHtml("<div>" + overlay + "</div>");
			});
		}
		return m;
	}, plot:function (obj) {
		var p = new GLatLng(obj.lat, obj.lng);
		var d = obj.description || null;
		var m = this.createPinpoint(p, d);
		this.map.addOverlay(m);
	}, plotAddress:function (address) {
		var self = this;
		this.geocoder.getLocations(address, function (response) {
			if (!response || response.Status.code != 200) {
				alert("The address \"" + address + "\" was not found.");
				return;
			}
			var obj = {lat:response.Placemark[0].Point.coordinates[1], lng:response.Placemark[0].Point.coordinates[0], description:response.Placemark[0].address};
			self.data.push(obj);
			self.render();
		});
	}, parse:function (table) {
		this.data = [];
		var h = table.getElementsByTagName("thead")[0];
		if (!h) {
			return;
		}
		var a = [];
		var cols = h.getElementsByTagName("td");
		if (cols.length == 0) {
			cols = h.getElementsByTagName("th");
		}
		for (var i = 0; i < cols.length; i++) {
			var c = cols[i].innerHTML.toLowerCase();
			if (c == "long") {
				c = "lng";
			}
			a.push(c);
		}
		var b = table.getElementsByTagName("tbody")[0];
		if (!b) {
			return;
		}
		for (var i = 0; i < b.childNodes.length; i++) {
			if (!(b.childNodes[i].nodeName && b.childNodes[i].nodeName.toLowerCase() == "tr")) {
				continue;
			}
			var cells = b.childNodes[i].getElementsByTagName("td");
			var o = {};
			for (var j = 0; j < a.length; j++) {
				var col = a[j];
				if (col == "lat" || col == "lng") {
					o[col] = parseFloat(cells[j].innerHTML);
				} else {
					o[col] = cells[j].innerHTML;
				}
			}
			this.data.push(o);
		}
	}, render:function () {
		if (this.data.length == 0) {
			this.map.setCenter(new GLatLng(this._defaultPoint.lat, this._defaultPoint.lng), 4);
			return;
		}
		this.map.clearOverlays();
		var bounds = new GLatLngBounds();
		var d = this.data;
		for (var i = 0; i < d.length; i++) {
			bounds.extend(new GLatLng(d[i].lat, d[i].lng));
		}
		var zoom = Math.min((this.map.getBoundsZoomLevel(bounds) - 1), 14);
		this.map.setCenter(this.findCenter(bounds), zoom);
		for (var i = 0; i < this.data.length; i++) {
			this.plot(this.data[i]);
		}
	}, initialize:function (args, frag) {
		if (this.datasrc) {
			this.parse(dojo.byId(this.datasrc));
		} else {
			if (this.domNode.getElementsByTagName("table")[0]) {
				this.parse(this.domNode.getElementsByTagName("table")[0]);
			}
		}
	}, postCreate:function () {
		while (this.domNode.childNodes.length > 0) {
			this.domNode.removeChild(this.domNode.childNodes[0]);
		}
		if (this.domNode.style.position != "absolute") {
			this.domNode.style.position = "relative";
		}
		this.map = new GMap2(this.domNode);
		try {
			this.geocoder = new GClientGeocoder();
		}
		catch (ex) {
		}
		this.render();
		this.setControls();
	}});
}});


__CPAN_FILE__ src/widget/TreeTimeoutIterator.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.widget.TreeTimeoutIterator"], ["require", "dojo.event.*"], ["require", "dojo.json"], ["require", "dojo.io.*"], ["require", "dojo.widget.TreeCommon"]], definePackage:function (dojo) {
	dojo.provide("dojo.widget.TreeTimeoutIterator");
	dojo.require("dojo.event.*");
	dojo.require("dojo.json");
	dojo.require("dojo.io.*");
	dojo.require("dojo.widget.TreeCommon");
	dojo.declare("dojo.widget.TreeTimeoutIterator", null, function (elem, callFunc, callObj) {
		var _this = this;
		this.currentParent = elem;
		this.callFunc = callFunc;
		this.callObj = callObj ? callObj : this;
		this.stack = [];
	}, {maxStackDepth:Number.POSITIVE_INFINITY, stack:null, currentParent:null, currentIndex:0, filterFunc:function () {
		return true;
	}, finishFunc:function () {
		return true;
	}, setFilter:function (func, obj) {
		this.filterFunc = func;
		this.filterObj = obj;
	}, setMaxLevel:function (level) {
		this.maxStackDepth = level - 2;
	}, forward:function (timeout) {
		var _this = this;
		if (this.timeout) {
			var tid = setTimeout(function () {
				_this.processNext();
				clearTimeout(tid);
			}, _this.timeout);
		} else {
			return this.processNext();
		}
	}, start:function (processFirst) {
		if (processFirst) {
			return this.callFunc.call(this.callObj, this.currentParent, this);
		}
		return this.processNext();
	}, processNext:function () {
		var handler;
		var _this = this;
		var found;
		var next;
		if (this.maxStackDepth == -2) {
			return;
		}
		while (true) {
			var children = this.currentParent.children;
			if (children && children.length) {
				do {
					next = children[this.currentIndex];
				} while (this.currentIndex++ < children.length && !(found = this.filterFunc.call(this.filterObj, next)));
				if (found) {
					if (next.isFolder && this.stack.length <= this.maxStackDepth) {
						this.moveParent(next, 0);
					}
					return this.callFunc.call(this.callObj, next, this);
				}
			}
			if (this.stack.length) {
				this.popParent();
				continue;
			}
			break;
		}
		return this.finishFunc.call(this.finishObj);
	}, setFinish:function (func, obj) {
		this.finishFunc = func;
		this.finishObj = obj;
	}, popParent:function () {
		var p = this.stack.pop();
		this.currentParent = p[0];
		this.currentIndex = p[1];
	}, moveParent:function (nextParent, nextIndex) {
		this.stack.push([this.currentParent, this.currentIndex]);
		this.currentParent = nextParent;
		this.currentIndex = nextIndex;
	}});
}});


__CPAN_FILE__ src/widget/Form.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.widget.Form");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.HtmlWidget");
dojo.widget.defineWidget("dojo.widget.Form", dojo.widget.HtmlWidget, {isContainer:true, templateString:"<form dojoAttachPoint='containerNode' dojoAttachEvent='onSubmit:onSubmit'></form>", formElements:[], ignoreNullValues:false, postCreate:function (args, frag) {
	for (var key in args) {
		if (key == "dojotype") {
			continue;
		}
		var attr = document.createAttribute(key);
		attr.nodeValue = args[key];
		this.containerNode.setAttributeNode(attr);
	}
}, _createRepeaters:function (obj, widget) {
	for (var i = 0; i < widget.children.length; ++i) {
		if (widget.children[i].widgetType == "RepeaterContainer") {
			var rIndex = widget.children[i].index;
			var rIndexPos = rIndex.indexOf("%{index}");
			rIndex = rIndex.substr(0, rIndexPos - 1);
			var myObj = this._getObject(obj, rIndex);
			if (typeof (myObj) == "object" && myObj.length == 0) {
				myObj = new Array();
			}
			var rowCount = widget.children[i].getRowCount();
			for (var j = 0, len = rowCount; j < len; ++j) {
				widget.children[i].deleteRow(0);
			}
			for (var j = 0; j < myObj.length; j++) {
				widget.children[i].addRow(false);
			}
		}
		if (widget.children[i].isContainer) {
			this._createRepeaters(obj, widget.children[i]);
		}
	}
}, _createFormElements:function () {
	if (dojo.render.html.safari) {
		this.formElements = [];
		var elems = ["INPUT", "SELECT", "TEXTAREA"];
		for (var k = 0; k < elems.length; k++) {
			var list = this.containerNode.getElementsByTagName(elems[k]);
			for (var j = 0, len2 = list.length; j < len2; j++) {
				this.formElements.push(list[j]);
			}
		}
	} else {
		this.formElements = this.containerNode.elements;
	}
}, onSubmit:function (e) {
	e.preventDefault();
}, submit:function () {
	this.containerNode.submit();
}, _getFormElement:function (name) {
	if (dojo.render.html.ie) {
		for (var i = 0, len = this.formElements.length; i < len; i++) {
			var element = this.formElements[i];
			if (element.name == name) {
				return element;
			}
		}
	} else {
		var elem = this.formElements[name];
		if (typeof (elem) != "undefined") {
			return elem;
		}
	}
	return null;
}, _getObject:function (obj, searchString) {
	var namePath = [];
	namePath = searchString.split(".");
	var myObj = obj;
	var name = namePath[namePath.length - 1];
	for (var j = 0, len = namePath.length; j < len; ++j) {
		var p = namePath[j];
		if (typeof (myObj[p]) == "undefined") {
			myObj[p] = {};
		}
		myObj = myObj[p];
	}
	return myObj;
}, _setToContainers:function (obj, widget) {
	for (var i = 0, len = widget.children.length; i < len; ++i) {
		var currentWidget = widget.children[i];
		if (currentWidget.widgetType == "Repeater") {
			for (var j = 0, len = currentWidget.getRowCount(); j < len; ++j) {
				currentWidget._initRow(j);
			}
		}
		if (currentWidget.isContainer) {
			this._setToContainers(obj, currentWidget);
			continue;
		}
		switch (currentWidget.widgetType) {
		  case "Checkbox":
			currentWidget.setValue(currentWidget.inputNode.checked);
			break;
		  case "DropdownDatePicker":
			currentWidget.setValue(currentWidget.getValue());
			break;
		  case "Select":
			continue;
			break;
		  case "ComboBox":
			continue;
			break;
		  default:
			break;
		}
	}
}, setValues:function (obj) {
	this._createFormElements();
	this._createRepeaters(obj, this);
	for (var i = 0, len = this.formElements.length; i < len; i++) {
		var element = this.formElements[i];
		if (element.name == "") {
			continue;
		}
		var namePath = new Array();
		namePath = element.name.split(".");
		var myObj = obj;
		var name = namePath[namePath.length - 1];
		for (var j = 1, len2 = namePath.length; j < len2; ++j) {
			var p = namePath[j - 1];
			if (typeof (myObj[p]) == "undefined") {
				myObj = undefined;
				break;
			}
			myObj = myObj[p];
		}
		if (typeof (myObj) == "undefined") {
			continue;
		}
		if (typeof (myObj[name]) == "undefined" && this.ignoreNullValues) {
			continue;
		}
		var type = element.type;
		if (type == "hidden" || type == "text" || type == "textarea" || type == "password") {
			type = "text";
		}
		switch (type) {
		  case "checkbox":
			element.checked = false;
			if (typeof (myObj[name]) == "undefined") {
				continue;
			}
			for (var j = 0, len2 = myObj[name].length; j < len2; ++j) {
				if (element.value == myObj[name][j]) {
					element.checked = true;
				}
			}
			break;
		  case "radio":
			element.checked = false;
			if (typeof (myObj[name]) == "undefined") {
				continue;
			}
			if (myObj[name] == element.value) {
				element.checked = true;
			}
			break;
		  case "select-multiple":
			element.selectedIndex = -1;
			for (var j = 0, len2 = element.options.length; j < len2; ++j) {
				for (var k = 0, len3 = myObj[name].length; k < len3; ++k) {
					if (element.options[j].value == myObj[name][k]) {
						element.options[j].selected = true;
					}
				}
			}
			break;
		  case "select-one":
			element.selectedIndex = "0";
			for (var j = 0, len2 = element.options.length; j < len2; ++j) {
				if (element.options[j].value == myObj[name]) {
					element.options[j].selected = true;
				} else {
				}
			}
			break;
		  case "text":
			var value = "";
			if (typeof (myObj[name]) != "undefined") {
				value = myObj[name];
			}
			element.value = value;
			break;
		  default:
			dojo.debug("Not supported type (" + type + ")");
			break;
		}
	}
	this._setToContainers(obj, this);
}, getValues:function () {
	this._createFormElements();
	var obj = {};
	for (var i = 0, len = this.formElements.length; i < len; i++) {
		var elm = this.formElements[i];
		var namePath = [];
		if (elm.name == "") {
			continue;
		}
		namePath = elm.name.split(".");
		var myObj = obj;
		var name = namePath[namePath.length - 1];
		for (var j = 1, len2 = namePath.length; j < len2; ++j) {
			var nameIndex = null;
			var p = namePath[j - 1];
			var nameA = p.split("[");
			if (nameA.length > 1) {
				if (typeof (myObj[nameA[0]]) == "undefined") {
					myObj[nameA[0]] = [];
				}
				nameIndex = parseInt(nameA[1]);
				if (typeof (myObj[nameA[0]][nameIndex]) == "undefined") {
					myObj[nameA[0]][nameIndex] = {};
				}
			} else {
				if (typeof (myObj[nameA[0]]) == "undefined") {
					myObj[nameA[0]] = {};
				}
			}
			if (nameA.length == 1) {
				myObj = myObj[nameA[0]];
			} else {
				myObj = myObj[nameA[0]][nameIndex];
			}
		}
		if ((elm.type != "select-multiple" && elm.type != "checkbox" && elm.type != "radio") || (elm.type == "radio" && elm.checked)) {
			if (name == name.split("[")[0]) {
				myObj[name] = elm.value;
			} else {
			}
		} else {
			if (elm.type == "checkbox" && elm.checked) {
				if (typeof (myObj[name]) == "undefined") {
					myObj[name] = [];
				}
				myObj[name].push(elm.value);
			} else {
				if (elm.type == "select-multiple") {
					if (typeof (myObj[name]) == "undefined") {
						myObj[name] = [];
					}
					for (var jdx = 0, len3 = elm.options.length; jdx < len3; ++jdx) {
						if (elm.options[jdx].selected) {
							myObj[name].push(elm.options[jdx].value);
						}
					}
				}
			}
		}
		name = undefined;
	}
	return obj;
}});


__CPAN_FILE__ src/widget/TreeControllerExtension.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.widget.TreeControllerExtension"]], definePackage:function (dojo) {
	dojo.provide("dojo.widget.TreeControllerExtension");
	dojo.declare("dojo.widget.TreeControllerExtension", null, {saveExpandedIndices:function (node, field) {
		var obj = {};
		for (var i = 0; i < node.children.length; i++) {
			if (node.children[i].isExpanded) {
				var key = dojo.lang.isUndefined(field) ? i : node.children[i][field];
				obj[key] = this.saveExpandedIndices(node.children[i], field);
			}
		}
		return obj;
	}, restoreExpandedIndices:function (node, savedIndices, field) {
		var _this = this;
		var handler = function (node, savedIndices) {
			this.node = node;
			this.savedIndices = savedIndices;
			this.process = function () {
				_this.restoreExpandedIndices(this.node, this.savedIndices, field);
			};
		};
		for (var i = 0; i < node.children.length; i++) {
			var child = node.children[i];
			var found = false;
			var key = -1;
			if (dojo.lang.isUndefined(field) && savedIndices[i]) {
				found = true;
				key = i;
			}
			if (field) {
				for (var key in savedIndices) {
					if (key == child[field]) {
						found = true;
						break;
					}
				}
			}
			if (found) {
				var h = new handler(child, savedIndices[key]);
				_this.expand(child, false, h, h.process);
			} else {
				if (child.isExpanded) {
					dojo.lang.forEach(child.getDescendants(), function (elem) {
						_this.collapse(elem);
					});
				}
			}
		}
	}});
}});


__CPAN_FILE__ src/widget/TimePicker.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.widget.TimePicker"], ["require", "dojo.widget.*"], ["require", "dojo.widget.HtmlWidget"], ["require", "dojo.event.*"], ["require", "dojo.date.serialize"], ["require", "dojo.date.format"], ["require", "dojo.dom"], ["require", "dojo.html.style"], ["xdRequireLocalization", "dojo.i18n.calendar", "gregorian", null, "ko,zh-cn,zh,sv,ja,en,zh-tw,it,hu,nl,fi,zh-hk,fr,pt,ROOT,es,de,pt-br", "ko,zh-cn,zh,sv,ja,en,zh-tw,it,hu,nl,fi,zh-hk,fr,pt,ROOT,es,de,pt-br"], ["xdRequireLocalization", "dojo.widget", "TimePicker", null, "ROOT", "ROOT"]], definePackage:function (dojo) {
	dojo.provide("dojo.widget.TimePicker");
	dojo.require("dojo.widget.*");
	dojo.require("dojo.widget.HtmlWidget");
	dojo.require("dojo.event.*");
	dojo.require("dojo.date.serialize");
	dojo.require("dojo.date.format");
	dojo.require("dojo.dom");
	dojo.require("dojo.html.style");
	dojo.widget.defineWidget("dojo.widget.TimePicker", dojo.widget.HtmlWidget, function () {
		this.time = "";
		this.useDefaultTime = false;
		this.useDefaultMinutes = false;
		this.storedTime = "";
		this.currentTime = {};
		this.classNames = {selectedTime:"selectedItem"};
		this.any = "any";
		this.selectedTime = {hour:"", minute:"", amPm:"", anyTime:false};
		this.hourIndexMap = ["", 2, 4, 6, 8, 10, 1, 3, 5, 7, 9, 11, 0];
		this.minuteIndexMap = [0, 2, 4, 6, 8, 10, 1, 3, 5, 7, 9, 11];
	}, {isContainer:false, templateString:"<div class=\"timePickerContainer\" dojoAttachPoint=\"timePickerContainerNode\">\n\t<table class=\"timeContainer\" cellspacing=\"0\" >\n\t\t<thead>\n\t\t\t<tr>\n\t\t\t\t<td class=\"timeCorner cornerTopLeft\" valign=\"top\">&nbsp;</td>\n\t\t\t\t<td class=\"timeLabelContainer hourSelector\">${this.calendar.field-hour}</td>\n\t\t\t\t<td class=\"timeLabelContainer minutesHeading\">${this.calendar.field-minute}</td>\n\t\t\t\t<td class=\"timeCorner cornerTopRight\" valign=\"top\">&nbsp;</td>\n\t\t\t</tr>\n\t\t</thead>\n\t\t<tbody>\n\t\t\t<tr>\n\t\t\t\t<td valign=\"top\" colspan=\"2\" class=\"hours\">\n\t\t\t\t\t<table align=\"center\">\n\t\t\t\t\t\t<tbody dojoAttachPoint=\"hourContainerNode\"  \n\t\t\t\t\t\t\tdojoAttachEvent=\"onClick: onSetSelectedHour;\">\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>12</td>\n\t\t\t\t\t\t\t\t<td>6</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>1</td>\n\t\t\t\t\t\t\t\t<td>7</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>2</td>\n\t\t\t\t\t\t\t\t<td>8</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>3</td>\n\t\t\t\t\t\t\t\t<td>9</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>4</td>\n\t\t\t\t\t\t\t\t<td>10</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>5</td>\n\t\t\t\t\t\t\t\t<td>11</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</tbody>\n\t\t\t\t\t</table>\n\t\t\t\t</td>\n\t\t\t\t<td valign=\"top\" class=\"minutes\" colspan=\"2\">\n\t\t\t\t\t<table align=\"center\">\n\t\t\t\t\t\t<tbody dojoAttachPoint=\"minuteContainerNode\" \n\t\t\t\t\t\t\tdojoAttachEvent=\"onClick: onSetSelectedMinute;\">\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>00</td>\n\t\t\t\t\t\t\t\t<td>30</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>05</td>\n\t\t\t\t\t\t\t\t<td>35</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>10</td>\n\t\t\t\t\t\t\t\t<td>40</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>15</td>\n\t\t\t\t\t\t\t\t<td>45</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>20</td>\n\t\t\t\t\t\t\t\t<td>50</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>25</td>\n\t\t\t\t\t\t\t\t<td>55</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</tbody>\n\t\t\t\t\t</table>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td class=\"cornerBottomLeft\">&nbsp;</td>\n\t\t\t\t<td valign=\"top\" class=\"timeOptions\">\n\t\t\t\t\t<table class=\"amPmContainer\">\n\t\t\t\t\t\t<tbody dojoAttachPoint=\"amPmContainerNode\" \n\t\t\t\t\t\t\tdojoAttachEvent=\"onClick: onSetSelectedAmPm;\">\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td id=\"am\">${this.calendar.am}</td>\n\t\t\t\t\t\t\t\t<td id=\"pm\">${this.calendar.pm}</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</tbody>\n\t\t\t\t\t</table>\n\t\t\t\t</td>\n\t\t\t\t<td class=\"timeOptions\">\n\t\t\t\t\t<div dojoAttachPoint=\"anyTimeContainerNode\" \n\t\t\t\t\t\tdojoAttachEvent=\"onClick: onSetSelectedAnyTime;\" \n\t\t\t\t\t\tclass=\"anyTimeContainer\">${this.widgetStrings.any}</div>\n\t\t\t\t</td>\n\t\t\t\t<td class=\"cornerBottomRight\">&nbsp;</td>\n\t\t\t</tr>\n\t\t</tbody>\n\t</table>\n</div>\n", templateCssString:"/*Time Picker */\n.timePickerContainer {\n\twidth:122px;\n\tfont-family:Tahoma, Myriad, Helvetica, Arial, Verdana, sans-serif;\n\tfont-size:16px;\n}\n\n.timeContainer {\n\tborder-collapse:collapse;\n\tborder-spacing:0;\n}\n\n.timeContainer thead {\n\tcolor:#293a4b;\n\tfont-size:0.9em;\n\tfont-weight:700;\n}\n\n.timeContainer thead td {\n\tpadding:0.25em;\n\tfont-size:0.80em;\n\tborder-bottom:1px solid #6782A8;\n}\n\n.timeCorner {\n\twidth:10px;\n}\n\n.cornerTopLeft {\n\tbackground: url(\"images/dpCurveTL.png\") top left no-repeat;\n}\n\n.cornerTopRight {\n\tbackground: url(\"images/dpCurveTR.png\") top right no-repeat;\n}\n\n.timeLabelContainer {\n\tbackground: url(\"images/dpMonthBg.png\") top left repeat-x;\n}\n\n.hours, .minutes, .timeBorder {\n\tbackground: #7591bc url(\"images/dpBg.gif\") top left repeat-x;\n\n}\n\n.hours td, .minutes td {\n\tpadding:0.2em;\n\ttext-align:center;\n\tfont-size:0.7em;\n\tfont-weight:bold;\n\tcursor:pointer;\n\tcursor:hand;\n\tcolor:#fff;\n}\n\n.minutes {\n\tborder-left:1px solid #f5d1db;\n}\n\n.hours {\n\tborder-right:1px solid #6782A8;\n}\n\n.hourSelector {\n\tborder-right:1px solid #6782A8;\n\tpadding:5px;\n\tpadding-right:10px;\n}\n\n.minutesSelector {\n\tpadding:5px;\n\tborder-left:1px solid #f5c7d4;\n\ttext-align:center;\n}\n\n.minutesHeading {\n\tpadding-left:9px !important;\n}\n\n.timeOptions {\n\tbackground-color:#F9C9D7;\n}\n\n.timeContainer .cornerBottomLeft, .timeContainer .cornerBottomRight, .timeContainer .timeOptions {\n\tborder-top:1px solid #6782A8;\n}\n\n.timeContainer .cornerBottomLeft {\n\tbackground: url(\"images/dpCurveBL.png\") bottom left no-repeat !important;\n\twidth:9px !important;\n\tpadding:0;\n\tmargin:0;\n}\n\n.timeContainer .cornerBottomRight {\n\tbackground: url(\"images/dpCurveBR.png\") bottom right no-repeat !important;\n\twidth:9px !important;\n\tpadding:0;\n\tmargin:0;\n}\n\n.timeOptions {\n\tcolor:#fff;\n\tbackground:url(\"images/dpYearBg.png\") top left repeat-x;\n\n}\n\n.selectedItem {\n\tbackground-color:#fff;\n\tcolor:#6782a8 !important;\n}\n\n.timeOptions .selectedItem {\n\tcolor:#fff !important;\n\tbackground-color:#9ec3fb !important;\n}\n\n.anyTimeContainer {\n\ttext-align:center;\n\tfont-weight:bold;\n\tfont-size:0.7em;\n\tpadding:0.1em;\n\tcursor:pointer;\n\tcursor:hand;\n\tcolor:#fff !important;\n}\n\n.amPmContainer {\n\twidth:100%;\n}\n\n.amPmContainer td {\n\ttext-align:center;\n\tfont-size:0.7em;\n\tfont-weight:bold;\n\tcursor:pointer;\n\tcursor:hand;\n\tcolor:#fff;\n}\n\n\n\n/*.timePickerContainer {\n\tmargin:1.75em 0 0.5em 0;\n\twidth:10em;\n\tfloat:left;\n}\n\n.timeContainer {\n\tborder-collapse:collapse;\n\tborder-spacing:0;\n}\n\n.timeContainer thead td{\n\tborder-bottom:1px solid #e6e6e6;\n\tpadding:0 0.4em 0.2em 0.4em;\n}\n\n.timeContainer td {\n\tfont-size:0.9em;\n\tpadding:0 0.25em 0 0.25em;\n\ttext-align:left;\n\tcursor:pointer;cursor:hand;\n}\n\n.timeContainer td.minutesHeading {\n\tborder-left:1px solid #e6e6e6;\n\tborder-right:1px solid #e6e6e6;\t\n}\n\n.timeContainer .minutes {\n\tborder-left:1px solid #e6e6e6;\n\tborder-right:1px solid #e6e6e6;\n}\n\n.selectedItem {\n\tbackground-color:#3a3a3a;\n\tcolor:#ffffff;\n}*/\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/TimePicker.css"), postMixInProperties:function (localProperties, frag) {
		dojo.widget.TimePicker.superclass.postMixInProperties.apply(this, arguments);
		this.calendar = dojo.i18n.getLocalization("dojo.i18n.calendar", "gregorian", this.lang);
		this.widgetStrings = dojo.i18n.getLocalization("dojo.widget", "TimePicker", this.lang);
	}, fillInTemplate:function (args, frag) {
		var source = this.getFragNodeRef(frag);
		dojo.html.copyStyle(this.domNode, source);
		if (args.value) {
			if (args.value instanceof Date) {
				this.storedTime = dojo.date.toRfc3339(args.value);
			} else {
				this.storedTime = args.value;
			}
		}
		this.initData();
		this.initUI();
	}, initData:function () {
		if (this.storedTime.indexOf("T") != -1 && this.storedTime.split("T")[1] && this.storedTime != " " && this.storedTime.split("T")[1] != "any") {
			this.time = dojo.widget.TimePicker.util.fromRfcDateTime(this.storedTime, this.useDefaultMinutes, this.selectedTime.anyTime);
		} else {
			if (this.useDefaultTime) {
				this.time = dojo.widget.TimePicker.util.fromRfcDateTime("", this.useDefaultMinutes, this.selectedTime.anyTime);
			} else {
				this.selectedTime.anyTime = true;
				this.time = dojo.widget.TimePicker.util.fromRfcDateTime("", 0, 1);
			}
		}
	}, initUI:function () {
		if (!this.selectedTime.anyTime && this.time) {
			var amPmHour = dojo.widget.TimePicker.util.toAmPmHour(this.time.getHours());
			var hour = amPmHour[0];
			var isAm = amPmHour[1];
			var minute = this.time.getMinutes();
			var minuteIndex = parseInt(minute / 5);
			this.onSetSelectedHour(this.hourIndexMap[hour]);
			this.onSetSelectedMinute(this.minuteIndexMap[minuteIndex]);
			this.onSetSelectedAmPm(isAm);
		} else {
			this.onSetSelectedAnyTime();
		}
	}, setTime:function (date) {
		if (date) {
			this.selectedTime.anyTime = false;
			this.setDateTime(dojo.date.toRfc3339(date));
		} else {
			this.selectedTime.anyTime = true;
		}
		this.initData();
		this.initUI();
	}, setDateTime:function (rfcDate) {
		this.storedTime = rfcDate;
	}, onClearSelectedHour:function (evt) {
		this.clearSelectedHour();
	}, onClearSelectedMinute:function (evt) {
		this.clearSelectedMinute();
	}, onClearSelectedAmPm:function (evt) {
		this.clearSelectedAmPm();
	}, onClearSelectedAnyTime:function (evt) {
		this.clearSelectedAnyTime();
		if (this.selectedTime.anyTime) {
			this.selectedTime.anyTime = false;
			this.time = dojo.widget.TimePicker.util.fromRfcDateTime("", this.useDefaultMinutes);
			this.initUI();
		}
	}, clearSelectedHour:function () {
		var hourNodes = this.hourContainerNode.getElementsByTagName("td");
		for (var i = 0; i < hourNodes.length; i++) {
			dojo.html.setClass(hourNodes.item(i), "");
		}
	}, clearSelectedMinute:function () {
		var minuteNodes = this.minuteContainerNode.getElementsByTagName("td");
		for (var i = 0; i < minuteNodes.length; i++) {
			dojo.html.setClass(minuteNodes.item(i), "");
		}
	}, clearSelectedAmPm:function () {
		var amPmNodes = this.amPmContainerNode.getElementsByTagName("td");
		for (var i = 0; i < amPmNodes.length; i++) {
			dojo.html.setClass(amPmNodes.item(i), "");
		}
	}, clearSelectedAnyTime:function () {
		dojo.html.setClass(this.anyTimeContainerNode, "anyTimeContainer");
	}, onSetSelectedHour:function (evt) {
		this.onClearSelectedAnyTime();
		this.onClearSelectedHour();
		this.setSelectedHour(evt);
		this.onSetTime();
	}, setSelectedHour:function (evt) {
		if (evt && evt.target) {
			if (evt.target.nodeType == dojo.dom.ELEMENT_NODE) {
				var eventTarget = evt.target;
			} else {
				var eventTarget = evt.target.parentNode;
			}
			dojo.event.browser.stopEvent(evt);
			dojo.html.setClass(eventTarget, this.classNames.selectedTime);
			this.selectedTime["hour"] = eventTarget.innerHTML;
		} else {
			if (!isNaN(evt)) {
				var hourNodes = this.hourContainerNode.getElementsByTagName("td");
				if (hourNodes.item(evt)) {
					dojo.html.setClass(hourNodes.item(evt), this.classNames.selectedTime);
					this.selectedTime["hour"] = hourNodes.item(evt).innerHTML;
				}
			}
		}
		this.selectedTime.anyTime = false;
	}, onSetSelectedMinute:function (evt) {
		this.onClearSelectedAnyTime();
		this.onClearSelectedMinute();
		this.setSelectedMinute(evt);
		this.selectedTime.anyTime = false;
		this.onSetTime();
	}, setSelectedMinute:function (evt) {
		if (evt && evt.target) {
			if (evt.target.nodeType == dojo.dom.ELEMENT_NODE) {
				var eventTarget = evt.target;
			} else {
				var eventTarget = evt.target.parentNode;
			}
			dojo.event.browser.stopEvent(evt);
			dojo.html.setClass(eventTarget, this.classNames.selectedTime);
			this.selectedTime["minute"] = eventTarget.innerHTML;
		} else {
			if (!isNaN(evt)) {
				var minuteNodes = this.minuteContainerNode.getElementsByTagName("td");
				if (minuteNodes.item(evt)) {
					dojo.html.setClass(minuteNodes.item(evt), this.classNames.selectedTime);
					this.selectedTime["minute"] = minuteNodes.item(evt).innerHTML;
				}
			}
		}
	}, onSetSelectedAmPm:function (evt) {
		this.onClearSelectedAnyTime();
		this.onClearSelectedAmPm();
		this.setSelectedAmPm(evt);
		this.selectedTime.anyTime = false;
		this.onSetTime();
	}, setSelectedAmPm:function (evt) {
		var eventTarget = evt.target;
		if (evt && eventTarget) {
			if (eventTarget.nodeType != dojo.dom.ELEMENT_NODE) {
				eventTarget = eventTarget.parentNode;
			}
			dojo.event.browser.stopEvent(evt);
			this.selectedTime.amPm = eventTarget.id;
			dojo.html.setClass(eventTarget, this.classNames.selectedTime);
		} else {
			evt = evt ? 0 : 1;
			var amPmNodes = this.amPmContainerNode.getElementsByTagName("td");
			if (amPmNodes.item(evt)) {
				this.selectedTime.amPm = amPmNodes.item(evt).id;
				dojo.html.setClass(amPmNodes.item(evt), this.classNames.selectedTime);
			}
		}
	}, onSetSelectedAnyTime:function (evt) {
		this.onClearSelectedHour();
		this.onClearSelectedMinute();
		this.onClearSelectedAmPm();
		this.setSelectedAnyTime();
		this.onSetTime();
	}, setSelectedAnyTime:function (evt) {
		this.selectedTime.anyTime = true;
		dojo.html.setClass(this.anyTimeContainerNode, this.classNames.selectedTime + " " + "anyTimeContainer");
	}, onClick:function (evt) {
		dojo.event.browser.stopEvent(evt);
	}, onSetTime:function () {
		if (this.selectedTime.anyTime) {
			this.time = new Date();
			var tempDateTime = dojo.widget.TimePicker.util.toRfcDateTime(this.time);
			this.setDateTime(tempDateTime.split("T")[0]);
		} else {
			var hour = 12;
			var minute = 0;
			var isAm = false;
			if (this.selectedTime["hour"]) {
				hour = parseInt(this.selectedTime["hour"], 10);
			}
			if (this.selectedTime["minute"]) {
				minute = parseInt(this.selectedTime["minute"], 10);
			}
			if (this.selectedTime["amPm"]) {
				isAm = (this.selectedTime["amPm"].toLowerCase() == "am");
			}
			this.time = new Date();
			this.time.setHours(dojo.widget.TimePicker.util.fromAmPmHour(hour, isAm));
			this.time.setMinutes(minute);
			this.setDateTime(dojo.widget.TimePicker.util.toRfcDateTime(this.time));
		}
		this.onValueChanged(this.time);
	}, onValueChanged:function (date) {
	}});
	dojo.widget.TimePicker.util = new function () {
		this.toRfcDateTime = function (jsDate) {
			if (!jsDate) {
				jsDate = new Date();
			}
			jsDate.setSeconds(0);
			return dojo.date.strftime(jsDate, "%Y-%m-%dT%H:%M:00%z");
		};
		this.fromRfcDateTime = function (rfcDate, useDefaultMinutes, isAnyTime) {
			var tempDate = new Date();
			if (!rfcDate || rfcDate.indexOf("T") == -1) {
				if (useDefaultMinutes) {
					tempDate.setMinutes(Math.floor(tempDate.getMinutes() / 5) * 5);
				} else {
					tempDate.setMinutes(0);
				}
			} else {
				var tempTime = rfcDate.split("T")[1].split(":");
				var tempDate = new Date();
				tempDate.setHours(tempTime[0]);
				tempDate.setMinutes(tempTime[1]);
			}
			return tempDate;
		};
		this.toAmPmHour = function (hour) {
			var amPmHour = hour;
			var isAm = true;
			if (amPmHour == 0) {
				amPmHour = 12;
			} else {
				if (amPmHour > 12) {
					amPmHour = amPmHour - 12;
					isAm = false;
				} else {
					if (amPmHour == 12) {
						isAm = false;
					}
				}
			}
			return [amPmHour, isAm];
		};
		this.fromAmPmHour = function (amPmHour, isAm) {
			var hour = parseInt(amPmHour, 10);
			if (isAm && hour == 12) {
				hour = 0;
			} else {
				if (!isAm && hour < 12) {
					hour = hour + 12;
				}
			}
			return hour;
		};
	};
}});


__CPAN_FILE__ src/widget/Widget.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.widget.Widget");
dojo.require("dojo.lang.func");
dojo.require("dojo.lang.array");
dojo.require("dojo.lang.extras");
dojo.require("dojo.lang.declare");
dojo.require("dojo.ns");
dojo.require("dojo.widget.Manager");
dojo.require("dojo.event.*");
dojo.require("dojo.a11y");
dojo.declare("dojo.widget.Widget", null, function () {
	this.children = [];
	this.extraArgs = {};
}, {parent:null, isTopLevel:false, disabled:false, isContainer:false, widgetId:"", widgetType:"Widget", ns:"dojo", getNamespacedType:function () {
	return (this.ns ? this.ns + ":" + this.widgetType : this.widgetType).toLowerCase();
}, toString:function () {
	return "[Widget " + this.getNamespacedType() + ", " + (this.widgetId || "NO ID") + "]";
}, repr:function () {
	return this.toString();
}, enable:function () {
	this.disabled = false;
}, disable:function () {
	this.disabled = true;
}, onResized:function () {
	this.notifyChildrenOfResize();
}, notifyChildrenOfResize:function () {
	for (var i = 0; i < this.children.length; i++) {
		var child = this.children[i];
		if (child.onResized) {
			child.onResized();
		}
	}
}, create:function (args, fragment, parent, ns) {
	if (ns) {
		this.ns = ns;
	}
	this.satisfyPropertySets(args, fragment, parent);
	this.mixInProperties(args, fragment, parent);
	this.postMixInProperties(args, fragment, parent);
	dojo.widget.manager.add(this);
	this.buildRendering(args, fragment, parent);
	this.initialize(args, fragment, parent);
	this.postInitialize(args, fragment, parent);
	this.postCreate(args, fragment, parent);
	return this;
}, destroy:function (finalize) {
	if (this.parent) {
		this.parent.removeChild(this);
	}
	this.destroyChildren();
	this.uninitialize();
	this.destroyRendering(finalize);
	dojo.widget.manager.removeById(this.widgetId);
}, destroyChildren:function () {
	var widget;
	var i = 0;
	while (this.children.length > i) {
		widget = this.children[i];
		if (widget instanceof dojo.widget.Widget) {
			this.removeChild(widget);
			widget.destroy();
			continue;
		}
		i++;
	}
}, getChildrenOfType:function (type, recurse) {
	var ret = [];
	var isFunc = dojo.lang.isFunction(type);
	if (!isFunc) {
		type = type.toLowerCase();
	}
	for (var x = 0; x < this.children.length; x++) {
		if (isFunc) {
			if (this.children[x] instanceof type) {
				ret.push(this.children[x]);
			}
		} else {
			if (this.children[x].widgetType.toLowerCase() == type) {
				ret.push(this.children[x]);
			}
		}
		if (recurse) {
			ret = ret.concat(this.children[x].getChildrenOfType(type, recurse));
		}
	}
	return ret;
}, getDescendants:function () {
	var result = [];
	var stack = [this];
	var elem;
	while ((elem = stack.pop())) {
		result.push(elem);
		if (elem.children) {
			dojo.lang.forEach(elem.children, function (elem) {
				stack.push(elem);
			});
		}
	}
	return result;
}, isFirstChild:function () {
	return this === this.parent.children[0];
}, isLastChild:function () {
	return this === this.parent.children[this.parent.children.length - 1];
}, satisfyPropertySets:function (args) {
	return args;
}, mixInProperties:function (args, frag) {
	if ((args["fastMixIn"]) || (frag["fastMixIn"])) {
		for (var x in args) {
			this[x] = args[x];
		}
		return;
	}
	var undef;
	var lcArgs = dojo.widget.lcArgsCache[this.widgetType];
	if (lcArgs == null) {
		lcArgs = {};
		for (var y in this) {
			lcArgs[((new String(y)).toLowerCase())] = y;
		}
		dojo.widget.lcArgsCache[this.widgetType] = lcArgs;
	}
	var visited = {};
	for (var x in args) {
		if (!this[x]) {
			var y = lcArgs[(new String(x)).toLowerCase()];
			if (y) {
				args[y] = args[x];
				x = y;
			}
		}
		if (visited[x]) {
			continue;
		}
		visited[x] = true;
		if ((typeof this[x]) != (typeof undef)) {
			if (typeof args[x] != "string") {
				this[x] = args[x];
			} else {
				if (dojo.lang.isString(this[x])) {
					this[x] = args[x];
				} else {
					if (dojo.lang.isNumber(this[x])) {
						this[x] = new Number(args[x]);
					} else {
						if (dojo.lang.isBoolean(this[x])) {
							this[x] = (args[x].toLowerCase() == "false") ? false : true;
						} else {
							if (dojo.lang.isFunction(this[x])) {
								if (args[x].search(/[^\w\.]+/i) == -1) {
									this[x] = dojo.evalObjPath(args[x], false);
								} else {
									var tn = dojo.lang.nameAnonFunc(new Function(args[x]), this);
									dojo.event.kwConnect({srcObj:this, srcFunc:x, adviceObj:this, adviceFunc:tn});
								}
							} else {
								if (dojo.lang.isArray(this[x])) {
									this[x] = args[x].split(";");
								} else {
									if (this[x] instanceof Date) {
										this[x] = new Date(Number(args[x]));
									} else {
										if (typeof this[x] == "object") {
											if (this[x] instanceof dojo.uri.Uri) {
												this[x] = dojo.uri.dojoUri(args[x]);
											} else {
												var pairs = args[x].split(";");
												for (var y = 0; y < pairs.length; y++) {
													var si = pairs[y].indexOf(":");
													if ((si != -1) && (pairs[y].length > si)) {
														this[x][pairs[y].substr(0, si).replace(/^\s+|\s+$/g, "")] = pairs[y].substr(si + 1);
													}
												}
											}
										} else {
											this[x] = args[x];
										}
									}
								}
							}
						}
					}
				}
			}
		} else {
			this.extraArgs[x.toLowerCase()] = args[x];
		}
	}
}, postMixInProperties:function (args, frag, parent) {
}, initialize:function (args, frag, parent) {
	return false;
}, postInitialize:function (args, frag, parent) {
	return false;
}, postCreate:function (args, frag, parent) {
	return false;
}, uninitialize:function () {
	return false;
}, buildRendering:function (args, frag, parent) {
	dojo.unimplemented("dojo.widget.Widget.buildRendering, on " + this.toString() + ", ");
	return false;
}, destroyRendering:function () {
	dojo.unimplemented("dojo.widget.Widget.destroyRendering");
	return false;
}, addedTo:function (parent) {
}, addChild:function (child) {
	dojo.unimplemented("dojo.widget.Widget.addChild");
	return false;
}, removeChild:function (widget) {
	for (var x = 0; x < this.children.length; x++) {
		if (this.children[x] === widget) {
			this.children.splice(x, 1);
			widget.parent = null;
			break;
		}
	}
	return widget;
}, getPreviousSibling:function () {
	var idx = this.getParentIndex();
	if (idx <= 0) {
		return null;
	}
	return this.parent.children[idx - 1];
}, getSiblings:function () {
	return this.parent.children;
}, getParentIndex:function () {
	return dojo.lang.indexOf(this.parent.children, this, true);
}, getNextSibling:function () {
	var idx = this.getParentIndex();
	if (idx == this.parent.children.length - 1) {
		return null;
	}
	if (idx < 0) {
		return null;
	}
	return this.parent.children[idx + 1];
}});
dojo.widget.lcArgsCache = {};
dojo.widget.tags = {};
dojo.widget.tags.addParseTreeHandler = function (type) {
	dojo.deprecated("addParseTreeHandler", ". ParseTreeHandlers are now reserved for components. Any unfiltered DojoML tag without a ParseTreeHandler is assumed to be a widget", "0.5");
};
dojo.widget.tags["dojo:propertyset"] = function (fragment, widgetParser, parentComp) {
	var properties = widgetParser.parseProperties(fragment["dojo:propertyset"]);
};
dojo.widget.tags["dojo:connect"] = function (fragment, widgetParser, parentComp) {
	var properties = widgetParser.parseProperties(fragment["dojo:connect"]);
};
dojo.widget.buildWidgetFromParseTree = function (type, frag, parser, parentComp, insertionIndex, localProps) {
	dojo.a11y.setAccessibleMode();
	var stype = type.split(":");
	stype = (stype.length == 2) ? stype[1] : type;
	var localProperties = localProps || parser.parseProperties(frag[frag["ns"] + ":" + stype]);
	var twidget = dojo.widget.manager.getImplementation(stype, null, null, frag["ns"]);
	if (!twidget) {
		throw new Error("cannot find \"" + type + "\" widget");
	} else {
		if (!twidget.create) {
			throw new Error("\"" + type + "\" widget object has no \"create\" method and does not appear to implement *Widget");
		}
	}
	localProperties["dojoinsertionindex"] = insertionIndex;
	var ret = twidget.create(localProperties, frag, parentComp, frag["ns"]);
	return ret;
};
dojo.widget.defineWidget = function (widgetClass, renderer, superclasses, init, props) {
	if (dojo.lang.isString(arguments[3])) {
		dojo.widget._defineWidget(arguments[0], arguments[3], arguments[1], arguments[4], arguments[2]);
	} else {
		var args = [arguments[0]], p = 3;
		if (dojo.lang.isString(arguments[1])) {
			args.push(arguments[1], arguments[2]);
		} else {
			args.push("", arguments[1]);
			p = 2;
		}
		if (dojo.lang.isFunction(arguments[p])) {
			args.push(arguments[p], arguments[p + 1]);
		} else {
			args.push(null, arguments[p]);
		}
		dojo.widget._defineWidget.apply(this, args);
	}
};
dojo.widget.defineWidget.renderers = "html|svg|vml";
dojo.widget._defineWidget = function (widgetClass, renderer, superclasses, init, props) {
	var module = widgetClass.split(".");
	var type = module.pop();
	var regx = "\\.(" + (renderer ? renderer + "|" : "") + dojo.widget.defineWidget.renderers + ")\\.";
	var r = widgetClass.search(new RegExp(regx));
	module = (r < 0 ? module.join(".") : widgetClass.substr(0, r));
	dojo.widget.manager.registerWidgetPackage(module);
	var pos = module.indexOf(".");
	var nsName = (pos > -1) ? module.substring(0, pos) : module;
	props = (props) || {};
	props.widgetType = type;
	if ((!init) && (props["classConstructor"])) {
		init = props.classConstructor;
		delete props.classConstructor;
	}
	dojo.declare(widgetClass, superclasses, init, props);
};


__CPAN_FILE__ src/widget/DropdownDatePicker.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.widget.DropdownDatePicker");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.DropdownContainer");
dojo.require("dojo.widget.DatePicker");
dojo.require("dojo.event.*");
dojo.require("dojo.html.*");
dojo.require("dojo.date.format");
dojo.require("dojo.date.serialize");
dojo.require("dojo.string.common");
dojo.require("dojo.i18n.common");
dojo.requireLocalization("dojo.widget", "DropdownDatePicker", null, "ROOT");
dojo.widget.defineWidget("dojo.widget.DropdownDatePicker", dojo.widget.DropdownContainer, {iconURL:dojo.uri.moduleUri("dojo.widget", "templates/images/dateIcon.gif"), formatLength:"short", displayFormat:"", saveFormat:"", value:"", name:"", displayWeeks:6, adjustWeeks:false, startDate:"1492-10-12", endDate:"2941-10-12", weekStartsOn:"", staticDisplay:false, postMixInProperties:function (localProperties, frag) {
	dojo.widget.DropdownDatePicker.superclass.postMixInProperties.apply(this, arguments);
	var messages = dojo.i18n.getLocalization("dojo.widget", "DropdownDatePicker", this.lang);
	this.iconAlt = messages.selectDate;
	if (typeof (this.value) == "string" && this.value.toLowerCase() == "today") {
		this.value = new Date();
	}
	if (this.value && isNaN(this.value)) {
		var orig = this.value;
		this.value = dojo.date.fromRfc3339(this.value);
		if (!this.value) {
			this.value = new Date(orig);
			dojo.deprecated("dojo.widget.DropdownDatePicker", "date attributes must be passed in Rfc3339 format", "0.5");
		}
	}
	if (this.value && !isNaN(this.value)) {
		this.value = new Date(this.value);
	}
}, fillInTemplate:function (args, frag) {
	dojo.widget.DropdownDatePicker.superclass.fillInTemplate.call(this, args, frag);
	var dpArgs = {widgetContainerId:this.widgetId, lang:this.lang, value:this.value, startDate:this.startDate, endDate:this.endDate, displayWeeks:this.displayWeeks, weekStartsOn:this.weekStartsOn, adjustWeeks:this.adjustWeeks, staticDisplay:this.staticDisplay};
	this.datePicker = dojo.widget.createWidget("DatePicker", dpArgs, this.containerNode, "child");
	dojo.event.connect(this.datePicker, "onValueChanged", this, "_updateText");
	dojo.event.connect(this.inputNode, "onChange", this, "_updateText");
	if (this.value) {
		this._updateText();
	}
	this.containerNode.explodeClassName = "calendarBodyContainer";
	this.valueNode.name = this.name;
}, getValue:function () {
	return this.valueNode.value;
}, getDate:function () {
	return this.datePicker.value;
}, setValue:function (rfcDate) {
	this.setDate(rfcDate);
}, setDate:function (dateObj) {
	this.datePicker.setDate(dateObj);
	this._syncValueNode();
}, _updateText:function () {
	this.inputNode.value = this.datePicker.value ? dojo.date.format(this.datePicker.value, {formatLength:this.formatLength, datePattern:this.displayFormat, selector:"dateOnly", locale:this.lang}) : "";
	if (this.value < this.datePicker.startDate || this.value > this.datePicker.endDate) {
		this.inputNode.value = "";
	}
	this._syncValueNode();
	this.onValueChanged(this.getDate());
	this.hideContainer();
}, onValueChanged:function (dateObj) {
}, onInputChange:function () {
	var input = dojo.string.trim(this.inputNode.value);
	if (input) {
		var inputDate = dojo.date.parse(input, {formatLength:this.formatLength, datePattern:this.displayFormat, selector:"dateOnly", locale:this.lang});
		if (!this.datePicker._isDisabledDate(inputDate)) {
			this.setDate(inputDate);
		}
	} else {
		if (input == "") {
			this.datePicker.setDate("");
		}
		this.valueNode.value = input;
	}
	if (input) {
		this._updateText();
	}
}, _syncValueNode:function () {
	var date = this.datePicker.value;
	var value = "";
	switch (this.saveFormat.toLowerCase()) {
	  case "rfc":
	  case "iso":
	  case "":
		value = dojo.date.toRfc3339(date, "dateOnly");
		break;
	  case "posix":
	  case "unix":
		value = Number(date);
		break;
	  default:
		if (date) {
			value = dojo.date.format(date, {datePattern:this.saveFormat, selector:"dateOnly", locale:this.lang});
		}
	}
	this.valueNode.value = value;
}, destroy:function (finalize) {
	this.datePicker.destroy(finalize);
	dojo.widget.DropdownDatePicker.superclass.destroy.apply(this, arguments);
}});


__CPAN_FILE__ src/widget/Dialog.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.widget.Dialog"], ["require", "dojo.widget.*"], ["require", "dojo.widget.ContentPane"], ["require", "dojo.event.*"], ["require", "dojo.gfx.color"], ["require", "dojo.html.layout"], ["require", "dojo.html.display"], ["require", "dojo.html.iframe"]], definePackage:function (dojo) {
	dojo.provide("dojo.widget.Dialog");
	dojo.require("dojo.widget.*");
	dojo.require("dojo.widget.ContentPane");
	dojo.require("dojo.event.*");
	dojo.require("dojo.gfx.color");
	dojo.require("dojo.html.layout");
	dojo.require("dojo.html.display");
	dojo.require("dojo.html.iframe");
	dojo.declare("dojo.widget.ModalDialogBase", null, {isContainer:true, focusElement:"", bgColor:"black", bgOpacity:0.4, followScroll:true, closeOnBackgroundClick:false, trapTabs:function (e) {
		if (e.target == this.tabStartOuter) {
			if (this._fromTrap) {
				this.tabStart.focus();
				this._fromTrap = false;
			} else {
				this._fromTrap = true;
				this.tabEnd.focus();
			}
		} else {
			if (e.target == this.tabStart) {
				if (this._fromTrap) {
					this._fromTrap = false;
				} else {
					this._fromTrap = true;
					this.tabEnd.focus();
				}
			} else {
				if (e.target == this.tabEndOuter) {
					if (this._fromTrap) {
						this.tabEnd.focus();
						this._fromTrap = false;
					} else {
						this._fromTrap = true;
						this.tabStart.focus();
					}
				} else {
					if (e.target == this.tabEnd) {
						if (this._fromTrap) {
							this._fromTrap = false;
						} else {
							this._fromTrap = true;
							this.tabStart.focus();
						}
					}
				}
			}
		}
	}, clearTrap:function (e) {
		var _this = this;
		setTimeout(function () {
			_this._fromTrap = false;
		}, 100);
	}, postCreate:function () {
		with (this.domNode.style) {
			position = "absolute";
			zIndex = 999;
			display = "none";
			overflow = "visible";
		}
		var b = dojo.body();
		b.appendChild(this.domNode);
		this.bg = document.createElement("div");
		this.bg.className = "dialogUnderlay";
		with (this.bg.style) {
			position = "absolute";
			left = top = "0px";
			zIndex = 998;
			display = "none";
		}
		b.appendChild(this.bg);
		this.setBackgroundColor(this.bgColor);
		this.bgIframe = new dojo.html.BackgroundIframe();
		if (this.bgIframe.iframe) {
			with (this.bgIframe.iframe.style) {
				position = "absolute";
				left = top = "0px";
				zIndex = 90;
				display = "none";
			}
		}
		if (this.closeOnBackgroundClick) {
			dojo.event.kwConnect({srcObj:this.bg, srcFunc:"onclick", adviceObj:this, adviceFunc:"onBackgroundClick", once:true});
		}
	}, uninitialize:function () {
		this.bgIframe.remove();
		dojo.html.removeNode(this.bg, true);
	}, setBackgroundColor:function (color) {
		if (arguments.length >= 3) {
			color = new dojo.gfx.color.Color(arguments[0], arguments[1], arguments[2]);
		} else {
			color = new dojo.gfx.color.Color(color);
		}
		this.bg.style.backgroundColor = color.toString();
		return this.bgColor = color;
	}, setBackgroundOpacity:function (op) {
		if (arguments.length == 0) {
			op = this.bgOpacity;
		}
		dojo.html.setOpacity(this.bg, op);
		try {
			this.bgOpacity = dojo.html.getOpacity(this.bg);
		}
		catch (e) {
			this.bgOpacity = op;
		}
		return this.bgOpacity;
	}, _sizeBackground:function () {
		if (this.bgOpacity > 0) {
			var viewport = dojo.html.getViewport();
			var h = viewport.height;
			var w = viewport.width;
			with (this.bg.style) {
				width = w + "px";
				height = h + "px";
			}
			var scroll_offset = dojo.html.getScroll().offset;
			this.bg.style.top = scroll_offset.y + "px";
			this.bg.style.left = scroll_offset.x + "px";
			var viewport = dojo.html.getViewport();
			if (viewport.width != w) {
				this.bg.style.width = viewport.width + "px";
			}
			if (viewport.height != h) {
				this.bg.style.height = viewport.height + "px";
			}
		}
		this.bgIframe.size(this.bg);
	}, _showBackground:function () {
		if (this.bgOpacity > 0) {
			this.bg.style.display = "block";
		}
		if (this.bgIframe.iframe) {
			this.bgIframe.iframe.style.display = "block";
		}
	}, placeModalDialog:function () {
		var scroll_offset = dojo.html.getScroll().offset;
		var viewport_size = dojo.html.getViewport();
		var mb;
		if (this.isShowing()) {
			mb = dojo.html.getMarginBox(this.domNode);
		} else {
			dojo.html.setVisibility(this.domNode, false);
			dojo.html.show(this.domNode);
			mb = dojo.html.getMarginBox(this.domNode);
			dojo.html.hide(this.domNode);
			dojo.html.setVisibility(this.domNode, true);
		}
		var x = scroll_offset.x + (viewport_size.width - mb.width) / 2;
		var y = scroll_offset.y + (viewport_size.height - mb.height) / 2;
		with (this.domNode.style) {
			left = x + "px";
			top = y + "px";
		}
	}, _onKey:function (evt) {
		if (evt.key) {
			var node = evt.target;
			while (node != null) {
				if (node == this.domNode) {
					return;
				}
				node = node.parentNode;
			}
			if (evt.key != evt.KEY_TAB) {
				dojo.event.browser.stopEvent(evt);
			} else {
				if (!dojo.render.html.opera) {
					try {
						this.tabStart.focus();
					}
					catch (e) {
					}
				}
			}
		}
	}, showModalDialog:function () {
		if (this.followScroll && !this._scrollConnected) {
			this._scrollConnected = true;
			dojo.event.connect(window, "onscroll", this, "_onScroll");
		}
		dojo.event.connect(document.documentElement, "onkey", this, "_onKey");
		this.placeModalDialog();
		this.setBackgroundOpacity();
		this._sizeBackground();
		this._showBackground();
		this._fromTrap = true;
		setTimeout(dojo.lang.hitch(this, function () {
			try {
				this.tabStart.focus();
			}
			catch (e) {
			}
		}), 50);
	}, hideModalDialog:function () {
		if (this.focusElement) {
			dojo.byId(this.focusElement).focus();
			dojo.byId(this.focusElement).blur();
		}
		this.bg.style.display = "none";
		this.bg.style.width = this.bg.style.height = "1px";
		if (this.bgIframe.iframe) {
			this.bgIframe.iframe.style.display = "none";
		}
		dojo.event.disconnect(document.documentElement, "onkey", this, "_onKey");
		if (this._scrollConnected) {
			this._scrollConnected = false;
			dojo.event.disconnect(window, "onscroll", this, "_onScroll");
		}
	}, _onScroll:function () {
		var scroll_offset = dojo.html.getScroll().offset;
		this.bg.style.top = scroll_offset.y + "px";
		this.bg.style.left = scroll_offset.x + "px";
		this.placeModalDialog();
	}, checkSize:function () {
		if (this.isShowing()) {
			this._sizeBackground();
			this.placeModalDialog();
			this.onResized();
		}
	}, onBackgroundClick:function () {
		if (this.lifetime - this.timeRemaining >= this.blockDuration) {
			return;
		}
		this.hide();
	}});
	dojo.widget.defineWidget("dojo.widget.Dialog", [dojo.widget.ContentPane, dojo.widget.ModalDialogBase], {templateString:"<div id=\"${this.widgetId}\" class=\"dojoDialog\" dojoattachpoint=\"wrapper\">\n\t<span dojoattachpoint=\"tabStartOuter\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\"\ttabindex=\"0\"></span>\n\t<span dojoattachpoint=\"tabStart\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\" tabindex=\"0\"></span>\n\t<div dojoattachpoint=\"containerNode\" style=\"position: relative; z-index: 2;\"></div>\n\t<span dojoattachpoint=\"tabEnd\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\" tabindex=\"0\"></span>\n\t<span dojoattachpoint=\"tabEndOuter\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\" tabindex=\"0\"></span>\n</div>\n", blockDuration:0, lifetime:0, closeNode:"", postMixInProperties:function () {
		dojo.widget.Dialog.superclass.postMixInProperties.apply(this, arguments);
		if (this.closeNode) {
			this.setCloseControl(this.closeNode);
		}
	}, postCreate:function () {
		dojo.widget.Dialog.superclass.postCreate.apply(this, arguments);
		dojo.widget.ModalDialogBase.prototype.postCreate.apply(this, arguments);
	}, show:function () {
		if (this.lifetime) {
			this.timeRemaining = this.lifetime;
			if (this.timerNode) {
				this.timerNode.innerHTML = Math.ceil(this.timeRemaining / 1000);
			}
			if (this.blockDuration && this.closeNode) {
				if (this.lifetime > this.blockDuration) {
					this.closeNode.style.visibility = "hidden";
				} else {
					this.closeNode.style.display = "none";
				}
			}
			if (this.timer) {
				clearInterval(this.timer);
			}
			this.timer = setInterval(dojo.lang.hitch(this, "_onTick"), 100);
		}
		this.showModalDialog();
		dojo.widget.Dialog.superclass.show.call(this);
	}, onLoad:function () {
		this.placeModalDialog();
		dojo.widget.Dialog.superclass.onLoad.call(this);
	}, fillInTemplate:function () {
	}, hide:function () {
		this.hideModalDialog();
		dojo.widget.Dialog.superclass.hide.call(this);
		if (this.timer) {
			clearInterval(this.timer);
		}
	}, setTimerNode:function (node) {
		this.timerNode = node;
	}, setCloseControl:function (node) {
		this.closeNode = dojo.byId(node);
		dojo.event.connect(this.closeNode, "onclick", this, "hide");
	}, setShowControl:function (node) {
		node = dojo.byId(node);
		dojo.event.connect(node, "onclick", this, "show");
	}, _onTick:function () {
		if (this.timer) {
			this.timeRemaining -= 100;
			if (this.lifetime - this.timeRemaining >= this.blockDuration) {
				if (this.closeNode) {
					this.closeNode.style.visibility = "visible";
				}
			}
			if (!this.timeRemaining) {
				clearInterval(this.timer);
				this.hide();
			} else {
				if (this.timerNode) {
					this.timerNode.innerHTML = Math.ceil(this.timeRemaining / 1000);
				}
			}
		}
	}});
}});


__CPAN_FILE__ src/widget/Button.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.widget.Button");
dojo.require("dojo.lang.extras");
dojo.require("dojo.html.*");
dojo.require("dojo.html.selection");
dojo.require("dojo.widget.*");
dojo.widget.defineWidget("dojo.widget.Button", dojo.widget.HtmlWidget, {isContainer:true, caption:"", templateString:"<div dojoAttachPoint=\"buttonNode\" class=\"dojoButton\" style=\"position:relative;\" dojoAttachEvent=\"onMouseOver; onMouseOut; onMouseDown; onMouseUp; onClick:buttonClick; onKey:onKey; onFocus;\">\n  <div class=\"dojoButtonContents\" align=center dojoAttachPoint=\"containerNode\" style=\"position:absolute;z-index:2;\"></div>\n  <img dojoAttachPoint=\"leftImage\" style=\"position:absolute;left:0px;\">\n  <img dojoAttachPoint=\"centerImage\" style=\"position:absolute;z-index:1;\">\n  <img dojoAttachPoint=\"rightImage\" style=\"position:absolute;top:0px;right:0px;\">\n</div>\n", templateCssString:"/* ---- button --- */\n.dojoButton {\n\tpadding: 0 0 0 0;\n\tfont-size: 8pt;\n\twhite-space: nowrap;\n\tcursor: pointer;\n\tfont-family: Myriad, Tahoma, Verdana, sans-serif;\n}\n\n.dojoButton .dojoButtonContents {\n\tpadding: 2px 2px 2px 2px;\n\ttext-align: center;\t\t/* if icon and label are split across two lines, center icon */\n\tcolor: white;\n}\n\n.dojoButtonLeftPart .dojoButtonContents {\n\tpadding-right: 8px;\n}\n\n.dojoButtonDisabled {\n\tcursor: url(\"images/no.gif\"), default;\n}\n\n\n.dojoButtonContents img {\n\tvertical-align: middle;\t/* if icon and label are on same line, center them */\n}\n\n/* -------- colors ------------ */\n\n.dojoButtonHover .dojoButtonContents {\n}\n\n.dojoButtonDepressed .dojoButtonContents {\n\tcolor: #293a4b;\n}\n\n.dojoButtonDisabled .dojoButtonContents {\n\tcolor: #aaa;\n}\n\n\n/* ---------- drop down button specific ---------- */\n\n/* border between label and arrow (for drop down buttons */\n.dojoButton .border {\n\twidth: 1px;\n\tbackground: gray;\n}\n\n/* button arrow */\n.dojoButton .downArrow {\n\tpadding-left: 10px;\n\ttext-align: center;\n}\n\n.dojoButton.disabled .downArrow {\n\tcursor : default;\n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/ButtonTemplate.css"), inactiveImg:"templates/images/soriaButton-", activeImg:"templates/images/soriaActive-", pressedImg:"templates/images/soriaPressed-", disabledImg:"templates/images/soriaDisabled-", width2height:1 / 3, fillInTemplate:function () {
	if (this.caption) {
		this.containerNode.appendChild(document.createTextNode(this.caption));
	}
	dojo.html.disableSelection(this.containerNode);
}, postCreate:function () {
	this._sizeMyself();
}, _sizeMyself:function () {
	if (this.domNode.parentNode) {
		var placeHolder = document.createElement("span");
		dojo.html.insertBefore(placeHolder, this.domNode);
	}
	dojo.body().appendChild(this.domNode);
	this._sizeMyselfHelper();
	if (placeHolder) {
		dojo.html.insertBefore(this.domNode, placeHolder);
		dojo.html.removeNode(placeHolder);
	}
}, _sizeMyselfHelper:function () {
	var mb = dojo.html.getMarginBox(this.containerNode);
	this.height = mb.height;
	this.containerWidth = mb.width;
	var endWidth = this.height * this.width2height;
	this.containerNode.style.left = endWidth + "px";
	this.leftImage.height = this.rightImage.height = this.centerImage.height = this.height;
	this.leftImage.width = this.rightImage.width = endWidth + 1;
	this.centerImage.width = this.containerWidth;
	this.centerImage.style.left = endWidth + "px";
	this._setImage(this.disabled ? this.disabledImg : this.inactiveImg);
	if (this.disabled) {
		dojo.html.prependClass(this.domNode, "dojoButtonDisabled");
		this.domNode.removeAttribute("tabIndex");
		dojo.widget.wai.setAttr(this.domNode, "waiState", "disabled", true);
	} else {
		dojo.html.removeClass(this.domNode, "dojoButtonDisabled");
		this.domNode.setAttribute("tabIndex", "0");
		dojo.widget.wai.setAttr(this.domNode, "waiState", "disabled", false);
	}
	this.domNode.style.height = this.height + "px";
	this.domNode.style.width = (this.containerWidth + 2 * endWidth) + "px";
}, onMouseOver:function (e) {
	if (this.disabled) {
		return;
	}
	if (!dojo.html.hasClass(this.buttonNode, "dojoButtonHover")) {
		dojo.html.prependClass(this.buttonNode, "dojoButtonHover");
	}
	this._setImage(this.activeImg);
}, onMouseDown:function (e) {
	if (this.disabled) {
		return;
	}
	dojo.html.prependClass(this.buttonNode, "dojoButtonDepressed");
	dojo.html.removeClass(this.buttonNode, "dojoButtonHover");
	this._setImage(this.pressedImg);
}, onMouseUp:function (e) {
	if (this.disabled) {
		return;
	}
	dojo.html.prependClass(this.buttonNode, "dojoButtonHover");
	dojo.html.removeClass(this.buttonNode, "dojoButtonDepressed");
	this._setImage(this.activeImg);
}, onMouseOut:function (e) {
	if (this.disabled) {
		return;
	}
	if (e.toElement && dojo.html.isDescendantOf(e.toElement, this.buttonNode)) {
		return;
	}
	dojo.html.removeClass(this.buttonNode, "dojoButtonHover");
	dojo.html.removeClass(this.buttonNode, "dojoButtonDepressed");
	this._setImage(this.inactiveImg);
}, onKey:function (e) {
	if (!e.key) {
		return;
	}
	var menu = dojo.widget.getWidgetById(this.menuId);
	if (e.key == e.KEY_ENTER || e.key == " ") {
		this.onMouseDown(e);
		this.buttonClick(e);
		dojo.lang.setTimeout(this, "onMouseUp", 75, e);
		dojo.event.browser.stopEvent(e);
	}
	if (menu && menu.isShowingNow && e.key == e.KEY_DOWN_ARROW) {
		dojo.event.disconnect(this.domNode, "onblur", this, "onBlur");
	}
}, onFocus:function (e) {
	var menu = dojo.widget.getWidgetById(this.menuId);
	if (menu) {
		dojo.event.connectOnce(this.domNode, "onblur", this, "onBlur");
	}
}, onBlur:function (e) {
	var menu = dojo.widget.getWidgetById(this.menuId);
	if (!menu) {
		return;
	}
	if (menu.close && menu.isShowingNow) {
		menu.close();
	}
}, buttonClick:function (e) {
	if (!this.disabled) {
		try {
			this.domNode.focus();
		}
		catch (e2) {
		}
		this.onClick(e);
	}
}, onClick:function (e) {
}, _setImage:function (prefix) {
	this.leftImage.src = dojo.uri.moduleUri("dojo.widget", prefix + "l.gif");
	this.centerImage.src = dojo.uri.moduleUri("dojo.widget", prefix + "c.gif");
	this.rightImage.src = dojo.uri.moduleUri("dojo.widget", prefix + "r.gif");
}, _toggleMenu:function (menuId) {
	var menu = dojo.widget.getWidgetById(menuId);
	if (!menu) {
		return;
	}
	if (menu.open && !menu.isShowingNow) {
		var pos = dojo.html.getAbsolutePosition(this.domNode, false);
		menu.open(pos.x, pos.y + this.height, this);
		dojo.event.disconnect(this.domNode, "onblur", this, "onBlur");
	} else {
		if (menu.close && menu.isShowingNow) {
			menu.close();
		} else {
			menu.toggle();
		}
	}
}, setCaption:function (content) {
	this.caption = content;
	this.containerNode.innerHTML = content;
	this._sizeMyself();
}, setDisabled:function (disabled) {
	this.disabled = disabled;
	this._sizeMyself();
}});
dojo.widget.defineWidget("dojo.widget.DropDownButton", dojo.widget.Button, {menuId:"", downArrow:"templates/images/whiteDownArrow.gif", disabledDownArrow:"templates/images/whiteDownArrow.gif", fillInTemplate:function () {
	dojo.widget.DropDownButton.superclass.fillInTemplate.apply(this, arguments);
	this.arrow = document.createElement("img");
	dojo.html.setClass(this.arrow, "downArrow");
	dojo.widget.wai.setAttr(this.domNode, "waiState", "haspopup", this.menuId);
}, _sizeMyselfHelper:function () {
	this.arrow.src = dojo.uri.moduleUri("dojo.widget", this.disabled ? this.disabledDownArrow : this.downArrow);
	this.containerNode.appendChild(this.arrow);
	dojo.widget.DropDownButton.superclass._sizeMyselfHelper.call(this);
}, onClick:function (e) {
	this._toggleMenu(this.menuId);
}});
dojo.widget.defineWidget("dojo.widget.ComboButton", dojo.widget.Button, {menuId:"", templateString:"<div class=\"dojoButton\" style=\"position:relative;top:0px;left:0px; text-align:none;\" dojoAttachEvent=\"onKey;onFocus\">\n\n\t<div dojoAttachPoint=\"buttonNode\" class=\"dojoButtonLeftPart\" style=\"position:absolute;left:0px;top:0px;\"\n\t\tdojoAttachEvent=\"onMouseOver; onMouseOut; onMouseDown; onMouseUp; onClick:buttonClick;\">\n\t\t<div class=\"dojoButtonContents\" dojoAttachPoint=\"containerNode\" style=\"position:absolute;top:0px;right:0px;z-index:2;\"></div>\n\t\t<img dojoAttachPoint=\"leftImage\" style=\"position:absolute;left:0px;top:0px;\">\n\t\t<img dojoAttachPoint=\"centerImage\" style=\"position:absolute;right:0px;top:0px;z-index:1;\">\n\t</div>\n\n\t<div dojoAttachPoint=\"rightPart\" class=\"dojoButtonRightPart\" style=\"position:absolute;top:0px;right:0px;\"\n\t\tdojoAttachEvent=\"onMouseOver:rightOver; onMouseOut:rightOut; onMouseDown:rightDown; onMouseUp:rightUp; onClick:rightClick;\">\n\t\t<img dojoAttachPoint=\"arrowBackgroundImage\" style=\"position:absolute;top:0px;left:0px;z-index:1;\">\n\t\t<img src=\"${dojoWidgetModuleUri}templates/images/whiteDownArrow.gif\"\n\t\t  \t\tstyle=\"z-index:2;position:absolute;left:3px;top:50%;\">\n\t\t<img dojoAttachPoint=\"rightImage\" style=\"position:absolute;top:0px;right:0px;\">\n\t</div>\n\n</div>\n", splitWidth:2, arrowWidth:5, _sizeMyselfHelper:function (e) {
	var mb = dojo.html.getMarginBox(this.containerNode);
	this.height = mb.height;
	this.containerWidth = mb.width;
	var endWidth = this.height / 3;
	if (this.disabled) {
		dojo.widget.wai.setAttr(this.domNode, "waiState", "disabled", true);
		this.domNode.removeAttribute("tabIndex");
	} else {
		dojo.widget.wai.setAttr(this.domNode, "waiState", "disabled", false);
		this.domNode.setAttribute("tabIndex", "0");
	}
	this.leftImage.height = this.rightImage.height = this.centerImage.height = this.arrowBackgroundImage.height = this.height;
	this.leftImage.width = endWidth + 1;
	this.centerImage.width = this.containerWidth;
	this.buttonNode.style.height = this.height + "px";
	this.buttonNode.style.width = endWidth + this.containerWidth + "px";
	this._setImage(this.disabled ? this.disabledImg : this.inactiveImg);
	this.arrowBackgroundImage.width = this.arrowWidth;
	this.rightImage.width = endWidth + 1;
	this.rightPart.style.height = this.height + "px";
	this.rightPart.style.width = this.arrowWidth + endWidth + "px";
	this._setImageR(this.disabled ? this.disabledImg : this.inactiveImg);
	this.domNode.style.height = this.height + "px";
	var totalWidth = this.containerWidth + this.splitWidth + this.arrowWidth + 2 * endWidth;
	this.domNode.style.width = totalWidth + "px";
}, _setImage:function (prefix) {
	this.leftImage.src = dojo.uri.moduleUri("dojo.widget", prefix + "l.gif");
	this.centerImage.src = dojo.uri.moduleUri("dojo.widget", prefix + "c.gif");
}, rightOver:function (e) {
	if (this.disabled) {
		return;
	}
	dojo.html.prependClass(this.rightPart, "dojoButtonHover");
	this._setImageR(this.activeImg);
}, rightDown:function (e) {
	if (this.disabled) {
		return;
	}
	dojo.html.prependClass(this.rightPart, "dojoButtonDepressed");
	dojo.html.removeClass(this.rightPart, "dojoButtonHover");
	this._setImageR(this.pressedImg);
}, rightUp:function (e) {
	if (this.disabled) {
		return;
	}
	dojo.html.prependClass(this.rightPart, "dojoButtonHover");
	dojo.html.removeClass(this.rightPart, "dojoButtonDepressed");
	this._setImageR(this.activeImg);
}, rightOut:function (e) {
	if (this.disabled) {
		return;
	}
	dojo.html.removeClass(this.rightPart, "dojoButtonHover");
	dojo.html.removeClass(this.rightPart, "dojoButtonDepressed");
	this._setImageR(this.inactiveImg);
}, rightClick:function (e) {
	if (this.disabled) {
		return;
	}
	try {
		this.domNode.focus();
	}
	catch (e2) {
	}
	this._toggleMenu(this.menuId);
}, _setImageR:function (prefix) {
	this.arrowBackgroundImage.src = dojo.uri.moduleUri("dojo.widget", prefix + "c.gif");
	this.rightImage.src = dojo.uri.moduleUri("dojo.widget", prefix + "r.gif");
}, onKey:function (e) {
	if (!e.key) {
		return;
	}
	var menu = dojo.widget.getWidgetById(this.menuId);
	if (e.key == e.KEY_ENTER || e.key == " ") {
		this.onMouseDown(e);
		this.buttonClick(e);
		dojo.lang.setTimeout(this, "onMouseUp", 75, e);
		dojo.event.browser.stopEvent(e);
	} else {
		if (e.key == e.KEY_DOWN_ARROW && e.altKey) {
			this.rightDown(e);
			this.rightClick(e);
			dojo.lang.setTimeout(this, "rightUp", 75, e);
			dojo.event.browser.stopEvent(e);
		} else {
			if (menu && menu.isShowingNow && e.key == e.KEY_DOWN_ARROW) {
				dojo.event.disconnect(this.domNode, "onblur", this, "onBlur");
			}
		}
	}
}});


__CPAN_FILE__ src/widget/DropdownTimePicker.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.widget.DropdownTimePicker"], ["require", "dojo.widget.*"], ["require", "dojo.widget.DropdownContainer"], ["require", "dojo.widget.TimePicker"], ["require", "dojo.event.*"], ["require", "dojo.html.*"], ["require", "dojo.date.format"], ["require", "dojo.date.serialize"], ["require", "dojo.i18n.common"], ["xdRequireLocalization", "dojo.widget", "DropdownTimePicker", null, "ROOT", "ROOT"]], definePackage:function (dojo) {
	dojo.provide("dojo.widget.DropdownTimePicker");
	dojo.require("dojo.widget.*");
	dojo.require("dojo.widget.DropdownContainer");
	dojo.require("dojo.widget.TimePicker");
	dojo.require("dojo.event.*");
	dojo.require("dojo.html.*");
	dojo.require("dojo.date.format");
	dojo.require("dojo.date.serialize");
	dojo.require("dojo.i18n.common");
	dojo.widget.defineWidget("dojo.widget.DropdownTimePicker", dojo.widget.DropdownContainer, {iconURL:dojo.uri.moduleUri("dojo.widget", "templates/images/timeIcon.gif"), formatLength:"short", displayFormat:"", timeFormat:"", saveFormat:"", value:"", name:"", postMixInProperties:function () {
		dojo.widget.DropdownTimePicker.superclass.postMixInProperties.apply(this, arguments);
		var messages = dojo.i18n.getLocalization("dojo.widget", "DropdownTimePicker", this.lang);
		this.iconAlt = messages.selectTime;
		if (typeof (this.value) == "string" && this.value.toLowerCase() == "today") {
			this.value = new Date();
		}
		if (this.value && isNaN(this.value)) {
			var orig = this.value;
			this.value = dojo.date.fromRfc3339(this.value);
			if (!this.value) {
				var d = dojo.date.format(new Date(), {selector:"dateOnly", datePattern:"yyyy-MM-dd"});
				var c = orig.split(":");
				for (var i = 0; i < c.length; ++i) {
					if (c[i].length == 1) {
						c[i] = "0" + c[i];
					}
				}
				orig = c.join(":");
				this.value = dojo.date.fromRfc3339(d + "T" + orig);
				dojo.deprecated("dojo.widget.DropdownTimePicker", "time attributes must be passed in Rfc3339 format", "0.5");
			}
		}
		if (this.value && !isNaN(this.value)) {
			this.value = new Date(this.value);
		}
	}, fillInTemplate:function () {
		dojo.widget.DropdownTimePicker.superclass.fillInTemplate.apply(this, arguments);
		var value = "";
		if (this.value instanceof Date) {
			value = this.value;
		} else {
			if (this.value) {
				var orig = this.value;
				var d = dojo.date.format(new Date(), {selector:"dateOnly", datePattern:"yyyy-MM-dd"});
				var c = orig.split(":");
				for (var i = 0; i < c.length; ++i) {
					if (c[i].length == 1) {
						c[i] = "0" + c[i];
					}
				}
				orig = c.join(":");
				value = dojo.date.fromRfc3339(d + "T" + orig);
			}
		}
		var tpArgs = {widgetContainerId:this.widgetId, lang:this.lang, value:value};
		this.timePicker = dojo.widget.createWidget("TimePicker", tpArgs, this.containerNode, "child");
		dojo.event.connect(this.timePicker, "onValueChanged", this, "_updateText");
		if (this.value) {
			this._updateText();
		}
		this.containerNode.style.zIndex = this.zIndex;
		this.containerNode.explodeClassName = "timeContainer";
		this.valueNode.name = this.name;
	}, getValue:function () {
		return this.valueNode.value;
	}, getTime:function () {
		return this.timePicker.storedTime;
	}, setValue:function (rfcDate) {
		this.setTime(rfcDate);
	}, setTime:function (dateObj) {
		var value = "";
		if (dateObj instanceof Date) {
			value = dateObj;
		} else {
			if (this.value) {
				var orig = this.value;
				var d = dojo.date.format(new Date(), {selector:"dateOnly", datePattern:"yyyy-MM-dd"});
				var c = orig.split(":");
				for (var i = 0; i < c.length; ++i) {
					if (c[i].length == 1) {
						c[i] = "0" + c[i];
					}
				}
				orig = c.join(":");
				value = dojo.date.fromRfc3339(d + "T" + orig);
			}
		}
		this.timePicker.setTime(value);
		this._syncValueNode();
	}, _updateText:function () {
		if (this.timePicker.selectedTime.anyTime) {
			this.inputNode.value = "";
		} else {
			if (this.timeFormat) {
				dojo.deprecated("dojo.widget.DropdownTimePicker", "Must use displayFormat attribute instead of timeFormat.  See dojo.date.format for specification.", "0.5");
				this.inputNode.value = dojo.date.strftime(this.timePicker.time, this.timeFormat, this.lang);
			} else {
				this.inputNode.value = dojo.date.format(this.timePicker.time, {formatLength:this.formatLength, timePattern:this.displayFormat, selector:"timeOnly", locale:this.lang});
			}
		}
		this._syncValueNode();
		this.onValueChanged(this.getTime());
		this.hideContainer();
	}, onValueChanged:function (dateObj) {
	}, onInputChange:function () {
		if (this.dateFormat) {
			dojo.deprecated("dojo.widget.DropdownTimePicker", "Cannot parse user input.  Must use displayFormat attribute instead of dateFormat.  See dojo.date.format for specification.", "0.5");
		} else {
			var input = dojo.string.trim(this.inputNode.value);
			if (input) {
				var inputTime = dojo.date.parse(input, {formatLength:this.formatLength, timePattern:this.displayFormat, selector:"timeOnly", locale:this.lang});
				if (inputTime) {
					this.setTime(inputTime);
				}
			} else {
				this.valueNode.value = input;
			}
		}
		if (input) {
			this._updateText();
		}
	}, _syncValueNode:function () {
		var time = this.timePicker.time;
		var value;
		switch (this.saveFormat.toLowerCase()) {
		  case "rfc":
		  case "iso":
		  case "":
			value = dojo.date.toRfc3339(time, "timeOnly");
			break;
		  case "posix":
		  case "unix":
			value = Number(time);
			break;
		  default:
			value = dojo.date.format(time, {datePattern:this.saveFormat, selector:"timeOnly", locale:this.lang});
		}
		this.valueNode.value = value;
	}, destroy:function (finalize) {
		this.timePicker.destroy(finalize);
		dojo.widget.DropdownTimePicker.superclass.destroy.apply(this, arguments);
	}});
}});


__CPAN_FILE__ src/widget/TreeLoadingControllerV3.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.widget.TreeLoadingControllerV3");
dojo.require("dojo.widget.TreeBasicControllerV3");
dojo.require("dojo.event.*");
dojo.require("dojo.json");
dojo.require("dojo.io.*");
dojo.require("dojo.Deferred");
dojo.require("dojo.DeferredList");
dojo.declare("dojo.Error", Error, function (message, extra) {
	this.message = message;
	this.extra = extra;
	this.stack = (new Error()).stack;
});
dojo.declare("dojo.CommunicationError", dojo.Error, function () {
	this.name = "CommunicationError";
});
dojo.declare("dojo.LockedError", dojo.Error, function () {
	this.name = "LockedError";
});
dojo.declare("dojo.FormatError", dojo.Error, function () {
	this.name = "FormatError";
});
dojo.declare("dojo.RpcError", dojo.Error, function () {
	this.name = "RpcError";
});
dojo.widget.defineWidget("dojo.widget.TreeLoadingControllerV3", dojo.widget.TreeBasicControllerV3, {RpcUrl:"", RpcActionParam:"action", preventCache:true, checkValidRpcResponse:function (type, obj) {
	if (type != "load") {
		var extra = {};
		for (var i = 1; i < arguments.length; i++) {
			dojo.lang.mixin(extra, arguments[i]);
		}
		return new dojo.CommunicationError(obj, extra);
	}
	if (typeof obj != "object") {
		return new dojo.FormatError("Wrong server answer format " + (obj && obj.toSource ? obj.toSource() : obj) + " type " + (typeof obj), obj);
	}
	if (!dojo.lang.isUndefined(obj.error)) {
		return new dojo.RpcError(obj.error, obj);
	}
	return false;
}, getDeferredBindHandler:function (deferred) {
	return dojo.lang.hitch(this, function (type, obj) {
		var error = this.checkValidRpcResponse.apply(this, arguments);
		if (error) {
			deferred.errback(error);
			return;
		}
		deferred.callback(obj);
	});
}, getRpcUrl:function (action) {
	if (this.RpcUrl == "local") {
		var dir = document.location.href.substr(0, document.location.href.lastIndexOf("/"));
		var localUrl = dir + "/local/" + action;
		return localUrl;
	}
	if (!this.RpcUrl) {
		dojo.raise("Empty RpcUrl: can't load");
	}
	var url = this.RpcUrl;
	if (url.indexOf("/") != 0) {
		var protocol = document.location.href.replace(/:\/\/.*/, "");
		var prefix = document.location.href.substring(protocol.length + 3);
		if (prefix.lastIndexOf("/") != prefix.length - 1) {
			prefix = prefix.replace(/\/[^\/]+$/, "/");
		}
		if (prefix.lastIndexOf("/") != prefix.length - 1) {
			prefix = prefix + "/";
		}
		url = protocol + "://" + prefix + url;
	}
	return url + (url.indexOf("?") > -1 ? "&" : "?") + this.RpcActionParam + "=" + action;
}, loadProcessResponse:function (node, result) {
	if (!dojo.lang.isArray(result)) {
		throw new dojo.FormatError("loadProcessResponse: Not array loaded: " + result);
	}
	node.setChildren(result);
}, runRpc:function (kw) {
	var _this = this;
	var deferred = new dojo.Deferred();
	dojo.io.bind({url:kw.url, handle:this.getDeferredBindHandler(deferred), mimetype:"text/javascript", preventCache:this.preventCache, sync:kw.sync, content:{data:dojo.json.serialize(kw.params)}});
	return deferred;
}, loadRemote:function (node, sync) {
	var _this = this;
	var params = {node:this.getInfo(node), tree:this.getInfo(node.tree)};
	var deferred = this.runRpc({url:this.getRpcUrl("getChildren"), sync:sync, params:params});
	deferred.addCallback(function (res) {
		return _this.loadProcessResponse(node, res);
	});
	return deferred;
}, batchExpandTimeout:0, recurseToLevel:function (widget, level, callFunc, callObj, skipFirst, sync) {
	if (level == 0) {
		return;
	}
	if (!skipFirst) {
		var deferred = callFunc.call(callObj, widget, sync);
	} else {
		var deferred = dojo.Deferred.prototype.makeCalled();
	}
	var _this = this;
	var recurseOnExpand = function () {
		var children = widget.children;
		var deferreds = [];
		for (var i = 0; i < children.length; i++) {
			deferreds.push(_this.recurseToLevel(children[i], level - 1, callFunc, callObj, sync));
		}
		return new dojo.DeferredList(deferreds);
	};
	deferred.addCallback(recurseOnExpand);
	return deferred;
}, expandToLevel:function (nodeOrTree, level, sync) {
	return this.recurseToLevel(nodeOrTree, nodeOrTree.isTree ? level + 1 : level, this.expand, this, nodeOrTree.isTree, sync);
}, loadToLevel:function (nodeOrTree, level, sync) {
	return this.recurseToLevel(nodeOrTree, nodeOrTree.isTree ? level + 1 : level, this.loadIfNeeded, this, nodeOrTree.isTree, sync);
}, loadAll:function (nodeOrTree, sync) {
	return this.loadToLevel(nodeOrTree, Number.POSITIVE_INFINITY, sync);
}, expand:function (node, sync) {
	var _this = this;
	var deferred = this.startProcessing(node);
	deferred.addCallback(function () {
		return _this.loadIfNeeded(node, sync);
	});
	deferred.addCallback(function (res) {
		dojo.widget.TreeBasicControllerV3.prototype.expand(node);
		return res;
	});
	deferred.addBoth(function (res) {
		_this.finishProcessing(node);
		return res;
	});
	return deferred;
}, loadIfNeeded:function (node, sync) {
	var deferred;
	if (node.state == node.loadStates.UNCHECKED && node.isFolder && !node.children.length) {
		deferred = this.loadRemote(node, sync);
	} else {
		deferred = new dojo.Deferred();
		deferred.callback();
	}
	return deferred;
}, runStages:function (check, prepare, make, finalize, expose, args) {
	var _this = this;
	if (check && !check.apply(this, args)) {
		return false;
	}
	var deferred = dojo.Deferred.prototype.makeCalled();
	if (prepare) {
		deferred.addCallback(function () {
			return prepare.apply(_this, args);
		});
	}
	if (make) {
		deferred.addCallback(function () {
			var res = make.apply(_this, args);
			return res;
		});
	}
	if (finalize) {
		deferred.addBoth(function (res) {
			finalize.apply(_this, args);
			return res;
		});
	}
	if (expose) {
		deferred.addCallback(function (res) {
			expose.apply(_this, args);
			return res;
		});
	}
	return deferred;
}, startProcessing:function (nodesArray) {
	var deferred = new dojo.Deferred();
	var nodes = dojo.lang.isArray(nodesArray) ? nodesArray : arguments;
	for (var i = 0; i < nodes.length; i++) {
		if (nodes[i].isLocked()) {
			deferred.errback(new dojo.LockedError("item locked " + nodes[i], nodes[i]));
			return deferred;
		}
		if (nodes[i].isTreeNode) {
			nodes[i].markProcessing();
		}
		nodes[i].lock();
	}
	deferred.callback();
	return deferred;
}, finishProcessing:function (nodesArray) {
	var nodes = dojo.lang.isArray(nodesArray) ? nodesArray : arguments;
	for (var i = 0; i < nodes.length; i++) {
		if (!nodes[i].hasLock()) {
			continue;
		}
		nodes[i].unlock();
		if (nodes[i].isTreeNode) {
			nodes[i].unmarkProcessing();
		}
	}
}, refreshChildren:function (nodeOrTree, sync) {
	return this.runStages(null, this.prepareRefreshChildren, this.doRefreshChildren, this.finalizeRefreshChildren, this.exposeRefreshChildren, arguments);
}, prepareRefreshChildren:function (nodeOrTree, sync) {
	var deferred = this.startProcessing(nodeOrTree);
	nodeOrTree.destroyChildren();
	nodeOrTree.state = nodeOrTree.loadStates.UNCHECKED;
	return deferred;
}, doRefreshChildren:function (nodeOrTree, sync) {
	return this.loadRemote(nodeOrTree, sync);
}, finalizeRefreshChildren:function (nodeOrTree, sync) {
	this.finishProcessing(nodeOrTree);
}, exposeRefreshChildren:function (nodeOrTree, sync) {
	nodeOrTree.expand();
}, move:function (child, newParent, index) {
	return this.runStages(this.canMove, this.prepareMove, this.doMove, this.finalizeMove, this.exposeMove, arguments);
}, doMove:function (child, newParent, index) {
	child.tree.move(child, newParent, index);
	return true;
}, prepareMove:function (child, newParent, index, sync) {
	var deferred = this.startProcessing(newParent);
	deferred.addCallback(dojo.lang.hitch(this, function () {
		return this.loadIfNeeded(newParent, sync);
	}));
	return deferred;
}, finalizeMove:function (child, newParent) {
	this.finishProcessing(newParent);
}, prepareCreateChild:function (parent, index, data, sync) {
	var deferred = this.startProcessing(parent);
	deferred.addCallback(dojo.lang.hitch(this, function () {
		return this.loadIfNeeded(parent, sync);
	}));
	return deferred;
}, finalizeCreateChild:function (parent) {
	this.finishProcessing(parent);
}, prepareClone:function (child, newParent, index, deep, sync) {
	var deferred = this.startProcessing(child, newParent);
	deferred.addCallback(dojo.lang.hitch(this, function () {
		return this.loadIfNeeded(newParent, sync);
	}));
	return deferred;
}, finalizeClone:function (child, newParent) {
	this.finishProcessing(child, newParent);
}});


__CPAN_FILE__ src/widget/HtmlWidget.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.hostenv.packageLoaded({depends:[["provide", "dojo.widget.HtmlWidget"], ["require", "dojo.widget.DomWidget"], ["require", "dojo.html.util"], ["require", "dojo.html.display"], ["require", "dojo.html.layout"], ["require", "dojo.lang.extras"], ["require", "dojo.lang.func"], ["require", "dojo.lfx.toggle"]], definePackage:function (dojo) {
	dojo.provide("dojo.widget.HtmlWidget");
	dojo.require("dojo.widget.DomWidget");
	dojo.require("dojo.html.util");
	dojo.require("dojo.html.display");
	dojo.require("dojo.html.layout");
	dojo.require("dojo.lang.extras");
	dojo.require("dojo.lang.func");
	dojo.require("dojo.lfx.toggle");
	dojo.declare("dojo.widget.HtmlWidget", dojo.widget.DomWidget, {templateCssPath:null, templatePath:null, lang:"", toggle:"plain", toggleDuration:150, initialize:function (args, frag) {
	}, postMixInProperties:function (args, frag) {
		if (this.lang === "") {
			this.lang = null;
		}
		this.toggleObj = dojo.lfx.toggle[this.toggle.toLowerCase()] || dojo.lfx.toggle.plain;
	}, createNodesFromText:function (txt, wrap) {
		return dojo.html.createNodesFromText(txt, wrap);
	}, destroyRendering:function (finalize) {
		try {
			if (this.bgIframe) {
				this.bgIframe.remove();
				delete this.bgIframe;
			}
			if (!finalize && this.domNode) {
				dojo.event.browser.clean(this.domNode);
			}
			dojo.widget.HtmlWidget.superclass.destroyRendering.call(this);
		}
		catch (e) {
		}
	}, isShowing:function () {
		return dojo.html.isShowing(this.domNode);
	}, toggleShowing:function () {
		if (this.isShowing()) {
			this.hide();
		} else {
			this.show();
		}
	}, show:function () {
		if (this.isShowing()) {
			return;
		}
		this.animationInProgress = true;
		this.toggleObj.show(this.domNode, this.toggleDuration, null, dojo.lang.hitch(this, this.onShow), this.explodeSrc);
	}, onShow:function () {
		this.animationInProgress = false;
		this.checkSize();
	}, hide:function () {
		if (!this.isShowing()) {
			return;
		}
		this.animationInProgress = true;
		this.toggleObj.hide(this.domNode, this.toggleDuration, null, dojo.lang.hitch(this, this.onHide), this.explodeSrc);
	}, onHide:function () {
		this.animationInProgress = false;
	}, _isResized:function (w, h) {
		if (!this.isShowing()) {
			return false;
		}
		var wh = dojo.html.getMarginBox(this.domNode);
		var width = w || wh.width;
		var height = h || wh.height;
		if (this.width == width && this.height == height) {
			return false;
		}
		this.width = width;
		this.height = height;
		return true;
	}, checkSize:function () {
		if (!this._isResized()) {
			return;
		}
		this.onResized();
	}, resizeTo:function (w, h) {
		dojo.html.setMarginBox(this.domNode, {width:w, height:h});
		if (this.isShowing()) {
			this.onResized();
		}
	}, resizeSoon:function () {
		if (this.isShowing()) {
			dojo.lang.setTimeout(this, this.onResized, 0);
		}
	}, onResized:function () {
		dojo.lang.forEach(this.children, function (child) {
			if (child.checkSize) {
				child.checkSize();
			}
		});
	}});
}});


__CPAN_FILE__ src/widget/Tooltip.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.widget.Tooltip");
dojo.require("dojo.widget.ContentPane");
dojo.require("dojo.widget.PopupContainer");
dojo.require("dojo.uri.Uri");
dojo.require("dojo.widget.*");
dojo.require("dojo.event.*");
dojo.require("dojo.html.style");
dojo.require("dojo.html.util");
dojo.widget.defineWidget("dojo.widget.Tooltip", [dojo.widget.ContentPane, dojo.widget.PopupContainerBase], {caption:"", showDelay:500, hideDelay:100, connectId:"", templateCssString:".dojoTooltip {\n\tborder: solid black 1px;\n\tbackground: beige;\n\tcolor: black;\n\tposition: absolute;\n\tfont-size: small;\n\tpadding: 2px 2px 2px 2px;\n\tz-index: 10;\n\tdisplay: block;\n}\n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/TooltipTemplate.css"), fillInTemplate:function (args, frag) {
	if (this.caption != "") {
		this.domNode.appendChild(document.createTextNode(this.caption));
	}
	this._connectNode = dojo.byId(this.connectId);
	dojo.widget.Tooltip.superclass.fillInTemplate.call(this, args, frag);
	this.addOnLoad(this, "_loadedContent");
	dojo.html.addClass(this.domNode, "dojoTooltip");
	var source = this.getFragNodeRef(frag);
	dojo.html.copyStyle(this.domNode, source);
	this.applyPopupBasicStyle();
}, postCreate:function (args, frag) {
	dojo.event.connect(this._connectNode, "onmouseover", this, "_onMouseOver");
	dojo.widget.Tooltip.superclass.postCreate.call(this, args, frag);
}, _onMouseOver:function (e) {
	this._mouse = {x:e.pageX, y:e.pageY};
	if (!this._tracking) {
		dojo.event.connect(document.documentElement, "onmousemove", this, "_onMouseMove");
		this._tracking = true;
	}
	this._onHover(e);
}, _onMouseMove:function (e) {
	this._mouse = {x:e.pageX, y:e.pageY};
	if (dojo.html.overElement(this._connectNode, e) || dojo.html.overElement(this.domNode, e)) {
		this._onHover(e);
	} else {
		this._onUnHover(e);
	}
}, _onHover:function (e) {
	if (this._hover) {
		return;
	}
	this._hover = true;
	if (this._hideTimer) {
		clearTimeout(this._hideTimer);
		delete this._hideTimer;
	}
	if (!this.isShowingNow && !this._showTimer) {
		this._showTimer = setTimeout(dojo.lang.hitch(this, "open"), this.showDelay);
	}
}, _onUnHover:function (e) {
	if (!this._hover) {
		return;
	}
	this._hover = false;
	if (this._showTimer) {
		clearTimeout(this._showTimer);
		delete this._showTimer;
	}
	if (this.isShowingNow && !this._hideTimer) {
		this._hideTimer = setTimeout(dojo.lang.hitch(this, "close"), this.hideDelay);
	}
	if (!this.isShowingNow) {
		dojo.event.disconnect(document.documentElement, "onmousemove", this, "_onMouseMove");
		this._tracking = false;
	}
}, open:function () {
	if (this.isShowingNow) {
		return;
	}
	dojo.widget.PopupContainerBase.prototype.open.call(this, this._mouse.x, this._mouse.y, null, [this._mouse.x, this._mouse.y], "TL,TR,BL,BR", [10, 15]);
}, close:function () {
	if (this.isShowingNow) {
		if (this._showTimer) {
			clearTimeout(this._showTimer);
			delete this._showTimer;
		}
		if (this._hideTimer) {
			clearTimeout(this._hideTimer);
			delete this._hideTimer;
		}
		dojo.event.disconnect(document.documentElement, "onmousemove", this, "_onMouseMove");
		this._tracking = false;
		dojo.widget.PopupContainerBase.prototype.close.call(this);
	}
}, _position:function () {
	this.move(this._mouse.x, this._mouse.y, [10, 15], "TL,TR,BL,BR");
}, _loadedContent:function () {
	if (this.isShowingNow) {
		this._position();
	}
}, checkSize:function () {
}, uninitialize:function () {
	this.close();
	dojo.event.disconnect(this._connectNode, "onmouseover", this, "_onMouseOver");
}});


__CPAN_FILE__ src/widget/TreeLinkExtension.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.widget.TreeLinkExtension");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.widget.TreeExtension");
dojo.widget.defineWidget("dojo.widget.TreeLinkExtension", dojo.widget.TreeExtension, function () {
	this.params = {};
}, {listenTreeEvents:["afterChangeTree"], listenTree:function (tree) {
	dojo.widget.TreeCommon.prototype.listenTree.call(this, tree);
	var labelNode = tree.labelNodeTemplate;
	var newLabel = this.makeALabel();
	dojo.html.setClass(newLabel, dojo.html.getClass(labelNode));
	labelNode.parentNode.replaceChild(newLabel, labelNode);
}, makeALabel:function () {
	var newLabel = document.createElement("a");
	for (var key in this.params) {
		if (key in {}) {
			continue;
		}
		newLabel.setAttribute(key, this.params[key]);
	}
	return newLabel;
}, onAfterChangeTree:function (message) {
	var _this = this;
	if (!message.oldTree) {
		this.listenNode(message.node);
	}
}, listenNode:function (node) {
	for (var key in node.object) {
		if (key in {}) {
			continue;
		}
		node.labelNode.setAttribute(key, node.object[key]);
	}
}});


__CPAN_FILE__ src/widget/TreeContextMenuV3.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.widget.TreeContextMenuV3");
dojo.require("dojo.event.*");
dojo.require("dojo.io.*");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.Menu2");
dojo.require("dojo.widget.TreeCommon");
dojo.widget.defineWidget("dojo.widget.TreeContextMenuV3", [dojo.widget.PopupMenu2, dojo.widget.TreeCommon], function () {
	this.listenedTrees = {};
}, {listenTreeEvents:["afterTreeCreate", "beforeTreeDestroy"], listenNodeFilter:function (elem) {
	return elem instanceof dojo.widget.Widget;
}, onAfterTreeCreate:function (message) {
	var tree = message.source;
	this.bindDomNode(tree.domNode);
}, onBeforeTreeDestroy:function (message) {
	this.unBindDomNode(message.source.domNode);
}, getTreeNode:function () {
	var source = this.getTopOpenEvent().target;
	var treeNode = this.domElement2TreeNode(source);
	return treeNode;
}, open:function () {
	var result = dojo.widget.PopupMenu2.prototype.open.apply(this, arguments);
	for (var i = 0; i < this.children.length; i++) {
		if (this.children[i].menuOpen) {
			this.children[i].menuOpen(this.getTreeNode());
		}
	}
	return result;
}, close:function () {
	for (var i = 0; i < this.children.length; i++) {
		if (this.children[i].menuClose) {
			this.children[i].menuClose(this.getTreeNode());
		}
	}
	var result = dojo.widget.PopupMenu2.prototype.close.apply(this, arguments);
	return result;
}});
dojo.widget.defineWidget("dojo.widget.TreeMenuItemV3", [dojo.widget.MenuItem2, dojo.widget.TreeCommon], function () {
	this.treeActions = [];
}, {treeActions:"", initialize:function (args, frag) {
	for (var i = 0; i < this.treeActions.length; i++) {
		this.treeActions[i] = this.treeActions[i].toUpperCase();
	}
}, getTreeNode:function () {
	var menu = this;
	while (!(menu instanceof dojo.widget.TreeContextMenuV3)) {
		menu = menu.parent;
	}
	var treeNode = menu.getTreeNode();
	return treeNode;
}, menuOpen:function (treeNode) {
	treeNode.viewEmphasize();
	this.setDisabled(false);
	var _this = this;
	dojo.lang.forEach(_this.treeActions, function (action) {
		_this.setDisabled(treeNode.actionIsDisabledNow(action));
	});
}, menuClose:function (treeNode) {
	treeNode.viewUnemphasize();
}, toString:function () {
	return "[" + this.widgetType + " node " + this.getTreeNode() + "]";
}});


__CPAN_FILE__ src/widget/TreeCommon.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.widget.TreeCommon");
dojo.require("dojo.widget.*");
dojo.declare("dojo.widget.TreeCommon", null, {listenTreeEvents:[], listenedTrees:{}, listenNodeFilter:null, listenTree:function (tree) {
	var _this = this;
	if (this.listenedTrees[tree.widgetId]) {
		return;
	}
	dojo.lang.forEach(this.listenTreeEvents, function (event) {
		var eventHandler = "on" + event.charAt(0).toUpperCase() + event.substr(1);
		dojo.event.topic.subscribe(tree.eventNames[event], _this, eventHandler);
	});
	var filter;
	if (this.listenNodeFilter) {
		this.processDescendants(tree, this.listenNodeFilter, this.listenNode, true);
	}
	this.listenedTrees[tree.widgetId] = true;
}, listenNode:function () {
}, unlistenNode:function () {
}, unlistenTree:function (tree, nodeFilter) {
	var _this = this;
	if (!this.listenedTrees[tree.widgetId]) {
		return;
	}
	dojo.lang.forEach(this.listenTreeEvents, function (event) {
		var eventHandler = "on" + event.charAt(0).toUpperCase() + event.substr(1);
		dojo.event.topic.unsubscribe(tree.eventNames[event], _this, eventHandler);
	});
	if (this.listenNodeFilter) {
		this.processDescendants(tree, this.listenNodeFilter, this.unlistenNode, true);
	}
	delete this.listenedTrees[tree.widgetId];
}, checkPathCondition:function (domElement, condition) {
	while (domElement && !domElement.widgetId) {
		if (condition.call(null, domElement)) {
			return true;
		}
		domElement = domElement.parentNode;
	}
	return false;
}, domElement2TreeNode:function (domElement) {
	while (domElement && !domElement.widgetId) {
		domElement = domElement.parentNode;
	}
	if (!domElement) {
		return null;
	}
	var widget = dojo.widget.byId(domElement.widgetId);
	if (!widget.isTreeNode) {
		return null;
	}
	return widget;
}, processDescendants:function (elem, filter, func, skipFirst) {
	var _this = this;
	if (!skipFirst) {
		if (!filter.call(_this, elem)) {
			return;
		}
		func.call(_this, elem);
	}
	var stack = [elem];
	while (elem = stack.pop()) {
		dojo.lang.forEach(elem.children, function (elem) {
			if (filter.call(_this, elem)) {
				func.call(_this, elem);
				stack.push(elem);
			}
		});
	}
}});


__CPAN_FILE__ src/widget/Toaster.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.widget.Toaster");
dojo.require("dojo.widget.*");
dojo.require("dojo.lfx.*");
dojo.require("dojo.html.iframe");
dojo.widget.defineWidget("dojo.widget.Toaster", dojo.widget.HtmlWidget, {templateString:"<div dojoAttachPoint=\"clipNode\"><div dojoAttachPoint=\"containerNode\" dojoAttachEvent=\"onClick:onSelect\"><div dojoAttachPoint=\"contentNode\"></div></div></div>", templateCssString:".dojoToasterClip {\n\tposition: absolute;\n\toverflow: hidden;\n}\n\n.dojoToasterContainer {\n\tdisplay: block;\n\tposition: absolute;\n\twidth: 17.5em;\n\tz-index: 5000;\n\tmargin: 0px;\n\tfont:0.75em Tahoma, Helvetica, Verdana, Arial;\n}\n\n.dojoToasterContent{\n\tpadding:1em;\n\tpadding-top:0.25em;\n\tbackground:#73c74a;\n}\n\n.dojoToasterMessage{ \n\tcolor:#fff;\n}\n.dojoToasterWarning{ }\n.dojoToasterError,\n.dojoToasterFatal{\n\tfont-weight:bold;\n\tcolor:#fff;\n}\n\n\n.dojoToasterWarning .dojoToasterContent{\n\tpadding:1em;\n\tpadding-top:0.25em;\n\tbackground:#d4d943;\n} \n\n.dojoToasterError .dojoToasterContent{\n\tpadding:1em;\n\tpadding-top:0.25em;\n\tbackground:#c46600;\n} \n", templateCssPath:dojo.uri.moduleUri("dojo.widget", "templates/Toaster.css"), messageTopic:"", messageTypes:{MESSAGE:"MESSAGE", WARNING:"WARNING", ERROR:"ERROR", FATAL:"FATAL"}, defaultType:"MESSAGE", clipCssClass:"dojoToasterClip", containerCssClass:"dojoToasterContainer", contentCssClass:"dojoToasterContent", messageCssClass:"dojoToasterMessage", warningCssClass:"dojoToasterWarning", errorCssClass:"dojoToasterError", fatalCssClass:"dojoToasterFatal", positionDirection:"br-up", positionDirectionTypes:["br-up", "br-left", "bl-up", "bl-right", "tr-down", "tr-left", "tl-down", "tl-right"], showDelay:2000, postCreate:function () {
	this.hide();
	dojo.html.setClass(this.clipNode, this.clipCssClass);
	dojo.html.addClass(this.containerNode, this.containerCssClass);
	dojo.html.setClass(this.contentNode, this.contentCssClass);
	if (this.messageTopic) {
		dojo.event.topic.subscribe(this.messageTopic, this, "_handleMessage");
	}
	if (!this.positionDirection || !dojo.lang.inArray(this.positionDirectionTypes, this.positionDirection)) {
		this.positionDirection = this.positionDirectionTypes.BRU;
	}
}, _handleMessage:function (msg) {
	if (dojo.lang.isString(msg)) {
		this.setContent(msg);
	} else {
		this.setContent(msg["message"], msg["type"], msg["delay"]);
	}
}, setContent:function (msg, messageType, delay) {
	var delay = delay || this.showDelay;
	if (this.slideAnim && this.slideAnim.status() == "playing") {
		dojo.lang.setTimeout(50, dojo.lang.hitch(this, function () {
			this.setContent(msg, messageType);
		}));
		return;
	} else {
		if (this.slideAnim) {
			this.slideAnim.stop();
			if (this.fadeAnim) {
				this.fadeAnim.stop();
			}
		}
	}
	if (!msg) {
		dojo.debug(this.widgetId + ".setContent() incoming content was null, ignoring.");
		return;
	}
	if (!this.positionDirection || !dojo.lang.inArray(this.positionDirectionTypes, this.positionDirection)) {
		dojo.raise(this.widgetId + ".positionDirection is an invalid value: " + this.positionDirection);
	}
	dojo.html.removeClass(this.containerNode, this.messageCssClass);
	dojo.html.removeClass(this.containerNode, this.warningCssClass);
	dojo.html.removeClass(this.containerNode, this.errorCssClass);
	dojo.html.removeClass(this.containerNode, this.fatalCssClass);
	dojo.html.clearOpacity(this.containerNode);
	if (msg instanceof String || typeof msg == "string") {
		this.contentNode.innerHTML = msg;
	} else {
		if (dojo.html.isNode(msg)) {
			this.contentNode.innerHTML = dojo.html.getContentAsString(msg);
		} else {
			dojo.raise("Toaster.setContent(): msg is of unknown type:" + msg);
		}
	}
	switch (messageType) {
	  case this.messageTypes.WARNING:
		dojo.html.addClass(this.containerNode, this.warningCssClass);
		break;
	  case this.messageTypes.ERROR:
		dojo.html.addClass(this.containerNode, this.errorCssClass);
		break;
	  case this.messageTypes.FATAL:
		dojo.html.addClass(this.containerNode, this.fatalCssClass);
		break;
	  case this.messageTypes.MESSAGE:
	  default:
		dojo.html.addClass(this.containerNode, this.messageCssClass);
		break;
	}
	this.show();
	var nodeSize = dojo.html.getMarginBox(this.containerNode);
	if (this.positionDirection.indexOf("-up") >= 0) {
		this.containerNode.style.left = 0 + "px";
		this.containerNode.style.top = nodeSize.height + 10 + "px";
	} else {
		if (this.positionDirection.indexOf("-left") >= 0) {
			this.containerNode.style.left = nodeSize.width + 10 + "px";
			this.containerNode.style.top = 0 + "px";
		} else {
			if (this.positionDirection.indexOf("-right") >= 0) {
				this.containerNode.style.left = 0 - nodeSize.width - 10 + "px";
				this.containerNode.style.top = 0 + "px";
			} else {
				if (this.positionDirection.indexOf("-down") >= 0) {
					this.containerNode.style.left = 0 + "px";
					this.containerNode.style.top = 0 - nodeSize.height - 10 + "px";
				} else {
					dojo.raise(this.widgetId + ".positionDirection is an invalid value: " + this.positionDirection);
				}
			}
		}
	}
	this.slideAnim = dojo.lfx.html.slideTo(this.containerNode, {top:0, left:0}, 450, null, dojo.lang.hitch(this, function (nodes, anim) {
		dojo.lang.setTimeout(dojo.lang.hitch(this, function (evt) {
			if (this.bgIframe) {
				this.bgIframe.hide();
			}
			this.fadeAnim = dojo.lfx.html.fadeOut(this.containerNode, 1000, null, dojo.lang.hitch(this, function (evt) {
				this.hide();
			})).play();
		}), delay);
	})).play();
}, _placeClip:function () {
	var scroll = dojo.html.getScroll();
	var view = dojo.html.getViewport();
	var nodeSize = dojo.html.getMarginBox(this.containerNode);
	this.clipNode.style.height = nodeSize.height + "px";
	this.clipNode.style.width = nodeSize.width + "px";
	if (this.positionDirection.match(/^t/)) {
		this.clipNode.style.top = scroll.top + "px";
	} else {
		if (this.positionDirection.match(/^b/)) {
			this.clipNode.style.top = (view.height - nodeSize.height - 2 + scroll.top) + "px";
		}
	}
	if (this.positionDirection.match(/^[tb]r-/)) {
		this.clipNode.style.left = (view.width - nodeSize.width - 1 - scroll.left) + "px";
	} else {
		if (this.positionDirection.match(/^[tb]l-/)) {
			this.clipNode.style.left = 0 + "px";
		}
	}
	this.clipNode.style.clip = "rect(0px, " + nodeSize.width + "px, " + nodeSize.height + "px, 0px)";
	if (dojo.render.html.ie) {
		if (!this.bgIframe) {
			this.bgIframe = new dojo.html.BackgroundIframe(this.containerNode);
			this.bgIframe.setZIndex(this.containerNode);
		}
		this.bgIframe.onResized();
		this.bgIframe.show();
	}
}, onSelect:function (e) {
}, show:function () {
	dojo.widget.Toaster.superclass.show.call(this);
	this._placeClip();
	if (!this._scrollConnected) {
		this._scrollConnected = true;
		dojo.event.connect(window, "onscroll", this, "_placeClip");
	}
}, hide:function () {
	dojo.widget.Toaster.superclass.hide.call(this);
	if (this._scrollConnected) {
		this._scrollConnected = false;
		dojo.event.disconnect(window, "onscroll", this, "_placeClip");
	}
	dojo.html.setOpacity(this.containerNode, 1);
}});


__CPAN_FILE__ src/widget/ContentPane.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/



dojo.provide("dojo.widget.ContentPane");
dojo.require("dojo.widget.*");
dojo.require("dojo.io.*");
dojo.require("dojo.widget.HtmlWidget");
dojo.require("dojo.string");
dojo.require("dojo.string.extras");
dojo.require("dojo.html.style");
dojo.widget.defineWidget("dojo.widget.ContentPane", dojo.widget.HtmlWidget, function () {
	this._styleNodes = [];
	this._onLoadStack = [];
	this._onUnloadStack = [];
	this._callOnUnload = false;
	this._ioBindObj;
	this.scriptScope;
	this.bindArgs = {};
}, {isContainer:true, adjustPaths:true, href:"", extractContent:true, parseContent:true, cacheContent:true, preload:false, refreshOnShow:false, handler:"", executeScripts:false, scriptSeparation:true, loadingMessage:"Loading...", isLoaded:false, postCreate:function (args, frag, parentComp) {
	if (this.handler !== "") {
		this.setHandler(this.handler);
	}
	if (this.isShowing() || this.preload) {
		this.loadContents();
	}
}, show:function () {
	if (this.refreshOnShow) {
		this.refresh();
	} else {
		this.loadContents();
	}
	dojo.widget.ContentPane.superclass.show.call(this);
}, refresh:function () {
	this.isLoaded = false;
	this.loadContents();
}, loadContents:function () {
	if (this.isLoaded) {
		return;
	}
	if (dojo.lang.isFunction(this.handler)) {
		this._runHandler();
	} else {
		if (this.href != "") {
			this._downloadExternalContent(this.href, this.cacheContent && !this.refreshOnShow);
		}
	}
}, setUrl:function (url) {
	this.href = url;
	this.isLoaded = false;
	if (this.preload || this.isShowing()) {
		this.loadContents();
	}
}, abort:function () {
	var bind = this._ioBindObj;
	if (!bind || !bind.abort) {
		return;
	}
	bind.abort();
	delete this._ioBindObj;
}, _downloadExternalContent:function (url, useCache) {
	this.abort();
	this._handleDefaults(this.loadingMessage, "onDownloadStart");
	var self = this;
	this._ioBindObj = dojo.io.bind(this._cacheSetting({url:url, mimetype:"text/html", handler:function (type, data, xhr) {
		delete self._ioBindObj;
		if (type == "load") {
			self.onDownloadEnd.call(self, url, data);
		} else {
			var e = {responseText:xhr.responseText, status:xhr.status, statusText:xhr.statusText, responseHeaders:xhr.getAllResponseHeaders(), text:"Error loading '" + url + "' (" + xhr.status + " " + xhr.statusText + ")"};
			self._handleDefaults.call(self, e, "onDownloadError");
			self.onLoad();
		}
	}}, useCache));
}, _cacheSetting:function (bindObj, useCache) {
	for (var x in this.bindArgs) {
		if (dojo.lang.isUndefined(bindObj[x])) {
			bindObj[x] = this.bindArgs[x];
		}
	}
	if (dojo.lang.isUndefined(bindObj.useCache)) {
		bindObj.useCache = useCache;
	}
	if (dojo.lang.isUndefined(bindObj.preventCache)) {
		bindObj.preventCache = !useCache;
	}
	if (dojo.lang.isUndefined(bindObj.mimetype)) {
		bindObj.mimetype = "text/html";
	}
	return bindObj;
}, onLoad:function (e) {
	this._runStack("_onLoadStack");
	this.isLoaded = true;
}, onUnLoad:function (e) {
	dojo.deprecated(this.widgetType + ".onUnLoad, use .onUnload (lowercased load)", 0.5);
}, onUnload:function (e) {
	this._runStack("_onUnloadStack");
	delete this.scriptScope;
	if (this.onUnLoad !== dojo.widget.ContentPane.prototype.onUnLoad) {
		this.onUnLoad.apply(this, arguments);
	}
}, _runStack:function (stName) {
	var st = this[stName];
	var err = "";
	var scope = this.scriptScope || window;
	for (var i = 0; i < st.length; i++) {
		try {
			st[i].call(scope);
		}
		catch (e) {
			err += "\n" + st[i] + " failed: " + e.description;
		}
	}
	this[stName] = [];
	if (err.length) {
		var name = (stName == "_onLoadStack") ? "addOnLoad" : "addOnUnLoad";
		this._handleDefaults(name + " failure\n " + err, "onExecError", "debug");
	}
}, addOnLoad:function (obj, func) {
	this._pushOnStack(this._onLoadStack, obj, func);
}, addOnUnload:function (obj, func) {
	this._pushOnStack(this._onUnloadStack, obj, func);
}, addOnUnLoad:function () {
	dojo.deprecated(this.widgetType + ".addOnUnLoad, use addOnUnload instead. (lowercased Load)", 0.5);
	this.addOnUnload.apply(this, arguments);
}, _pushOnStack:function (stack, obj, func) {
	if (typeof func == "undefined") {
		stack.push(obj);
	} else {
		stack.push(function () {
			obj[func]();
		});
	}
}, destroy:function () {
	this.onUnload();
	dojo.widget.ContentPane.superclass.destroy.call(this);
}, onExecError:function (e) {
}, onContentError:function (e) {
}, onDownloadError:function (e) {
}, onDownloadStart:function (e) {
}, onDownloadEnd:function (url, data) {
	data = this.splitAndFixPaths(data, url);
	this.setContent(data);
}, _handleDefaults:function (e, handler, messType) {
	if (!handler) {
		handler = "onContentError";
	}
	if (dojo.lang.isString(e)) {
		e = {text:e};
	}
	if (!e.text) {
		e.text = e.toString();
	}
	e.toString = function () {
		return this.text;
	};
	if (typeof e.returnValue != "boolean") {
		e.returnValue = true;
	}
	if (typeof e.preventDefault != "function") {
		e.preventDefault = function () {
			this.returnValue = false;
		};
	}
	this[handler](e);
	if (e.returnValue) {
		switch (messType) {
		  case true:
		  case "alert":
			alert(e.toString());
			break;
		  case "debug":
			dojo.debug(e.toString());
			break;
		  default:
			if (this._callOnUnload) {
				this.onUnload();
			}
			this._callOnUnload = false;
			if (arguments.callee._loopStop) {
				dojo.debug(e.toString());
			} else {
				arguments.callee._loopStop = true;
				this._setContent(e.toString());
			}
		}
	}
	arguments.callee._loopStop = false;
}, splitAndFixPaths:function (s, url) {
	var titles = [], scripts = [], tmp = [];
	var match = [], requires = [], attr = [], styles = [];
	var str = "", path = "", fix = "", tagFix = "", tag = "", origPath = "";
	if (!url) {
		url = "./";
	}
	if (s) {
		var regex = /<title[^>]*>([\s\S]*?)<\/title>/i;
		while (match = regex.exec(s)) {
			titles.push(match[1]);
			s = s.substring(0, match.index) + s.substr(match.index + match[0].length);
		}
		if (this.adjustPaths) {
			var regexFindTag = /<[a-z][a-z0-9]*[^>]*\s(?:(?:src|href|style)=[^>])+[^>]*>/i;
			var regexFindAttr = /\s(src|href|style)=(['"]?)([\w()\[\]\/.,\\'"-:;#=&?\s@]+?)\2/i;
			var regexProtocols = /^(?:[#]|(?:(?:https?|ftps?|file|javascript|mailto|news):))/;
			while (tag = regexFindTag.exec(s)) {
				str += s.substring(0, tag.index);
				s = s.substring((tag.index + tag[0].length), s.length);
				tag = tag[0];
				tagFix = "";
				while (attr = regexFindAttr.exec(tag)) {
					path = "";
					origPath = attr[3];
					switch (attr[1].toLowerCase()) {
					  case "src":
					  case "href":
						if (regexProtocols.exec(origPath)) {
							path = origPath;
						} else {
							path = (new dojo.uri.Uri(url, origPath).toString());
						}
						break;
					  case "style":
						path = dojo.html.fixPathsInCssText(origPath, url);
						break;
					  default:
						path = origPath;
					}
					fix = " " + attr[1] + "=" + attr[2] + path + attr[2];
					tagFix += tag.substring(0, attr.index) + fix;
					tag = tag.substring((attr.index + attr[0].length), tag.length);
				}
				str += tagFix + tag;
			}
			s = str + s;
		}
		regex = /(?:<(style)[^>]*>([\s\S]*?)<\/style>|<link ([^>]*rel=['"]?stylesheet['"]?[^>]*)>)/i;
		while (match = regex.exec(s)) {
			if (match[1] && match[1].toLowerCase() == "style") {
				styles.push(dojo.html.fixPathsInCssText(match[2], url));
			} else {
				if (attr = match[3].match(/href=(['"]?)([^'">]*)\1/i)) {
					styles.push({path:attr[2]});
				}
			}
			s = s.substring(0, match.index) + s.substr(match.index + match[0].length);
		}
		var regex = /<script([^>]*)>([\s\S]*?)<\/script>/i;
		var regexSrc = /src=(['"]?)([^"']*)\1/i;
		var regexDojoJs = /.*(\bdojo\b\.js(?:\.uncompressed\.js)?)$/;
		var regexInvalid = /(?:var )?\bdjConfig\b(?:[\s]*=[\s]*\{[^}]+\}|\.[\w]*[\s]*=[\s]*[^;\n]*)?;?|dojo\.hostenv\.writeIncludes\(\s*\);?/g;
		var regexRequires = /dojo\.(?:(?:require(?:After)?(?:If)?)|(?:widget\.(?:manager\.)?registerWidgetPackage)|(?:(?:hostenv\.)?setModulePrefix|registerModulePath)|defineNamespace)\((['"]).*?\1\)\s*;?/;
		while (match = regex.exec(s)) {
			if (this.executeScripts && match[1]) {
				if (attr = regexSrc.exec(match[1])) {
					if (regexDojoJs.exec(attr[2])) {
						dojo.debug("Security note! inhibit:" + attr[2] + " from  being loaded again.");
					} else {
						scripts.push({path:attr[2]});
					}
				}
			}
			if (match[2]) {
				var sc = match[2].replace(regexInvalid, "");
				if (!sc) {
					continue;
				}
				while (tmp = regexRequires.exec(sc)) {
					requires.push(tmp[0]);
					sc = sc.substring(0, tmp.index) + sc.substr(tmp.index + tmp[0].length);
				}
				if (this.executeScripts) {
					scripts.push(sc);
				}
			}
			s = s.substr(0, match.index) + s.substr(match.index + match[0].length);
		}
		if (this.extractContent) {
			match = s.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
			if (match) {
				s = match[1];
			}
		}
		if (this.executeScripts && this.scriptSeparation) {
			var regex = /(<[a-zA-Z][a-zA-Z0-9]*\s[^>]*?\S=)((['"])[^>]*scriptScope[^>]*>)/;
			var regexAttr = /([\s'";:\(])scriptScope(.*)/;
			str = "";
			while (tag = regex.exec(s)) {
				tmp = ((tag[3] == "'") ? "\"" : "'");
				fix = "";
				str += s.substring(0, tag.index) + tag[1];
				while (attr = regexAttr.exec(tag[2])) {
					tag[2] = tag[2].substring(0, attr.index) + attr[1] + "dojo.widget.byId(" + tmp + this.widgetId + tmp + ").scriptScope" + attr[2];
				}
				str += tag[2];
				s = s.substr(tag.index + tag[0].length);
			}
			s = str + s;
		}
	}
	return {"xml":s, "styles":styles, "titles":titles, "requires":requires, "scripts":scripts, "url":url};
}, _setContent:function (cont) {
	this.destroyChildren();
	for (var i = 0; i < this._styleNodes.length; i++) {
		if (this._styleNodes[i] && this._styleNodes[i].parentNode) {
			this._styleNodes[i].parentNode.removeChild(this._styleNodes[i]);
		}
	}
	this._styleNodes = [];
	try {
		var node = this.containerNode || this.domNode;
		while (node.firstChild) {
			dojo.html.destroyNode(node.firstChild);
		}
		if (typeof cont != "string") {
			node.appendChild(cont);
		} else {
			node.innerHTML = cont;
		}
	}
	catch (e) {
		e.text = "Couldn't load content:" + e.description;
		this._handleDefaults(e, "onContentError");
	}
}, setContent:function (data) {
	this.abort();
	if (this._callOnUnload) {
		this.onUnload();
	}
	this._callOnUnload = true;
	if (!data || dojo.html.isNode(data)) {
		this._setContent(data);
		this.onResized();
		this.onLoad();
	} else {
		if (typeof data.xml != "string") {
			this.href = "";
			data = this.splitAndFixPaths(data);
		}
		this._setContent(data.xml);
		for (var i = 0; i < data.styles.length; i++) {
			if (data.styles[i].path) {
				this._styleNodes.push(dojo.html.insertCssFile(data.styles[i].path, dojo.doc(), false, true));
			} else {
				this._styleNodes.push(dojo.html.insertCssText(data.styles[i]));
			}
		}
		if (this.parseContent) {
			for (var i = 0; i < data.requires.length; i++) {
				try {
					eval(data.requires[i]);
				}
				catch (e) {
					e.text = "ContentPane: error in package loading calls, " + (e.description || e);
					this._handleDefaults(e, "onContentError", "debug");
				}
			}
		}
		var _self = this;
		function asyncParse() {
			if (_self.executeScripts) {
				_self._executeScripts(data.scripts);
			}
			if (_self.parseContent) {
				var node = _self.containerNode || _self.domNode;
				var parser = new dojo.xml.Parse();
				var frag = parser.parseElement(node, null, true);
				dojo.widget.getParser().createSubComponents(frag, _self);
			}
			_self.onResized();
			_self.onLoad();
		}
		if (dojo.hostenv.isXDomain && data.requires.length) {
			dojo.addOnLoad(asyncParse);
		} else {
			asyncParse();
		}
	}
}, setHandler:function (handler) {
	var fcn = dojo.lang.isFunction(handler) ? handler : window[handler];
	if (!dojo.lang.isFunction(fcn)) {
		this._handleDefaults("Unable to set handler, '" + handler + "' not a function.", "onExecError", true);
		return;
	}
	this.handler = function () {
		return fcn.apply(this, arguments);
	};
}, _runHandler:function () {
	var ret = true;
	if (dojo.lang.isFunction(this.handler)) {
		this.handler(this, this.domNode);
		ret = false;
	}
	this.onLoad();
	return ret;
}, _executeScripts:function (scripts) {
	var self = this;
	var tmp = "", code = "";
	for (var i = 0; i < scripts.length; i++) {
		if (scripts[i].path) {
			dojo.io.bind(this._cacheSetting({"url":scripts[i].path, "load":function (type, scriptStr) {
				dojo.lang.hitch(self, tmp = ";" + scriptStr);
			}, "error":function (type, error) {
				error.text = type + " downloading remote script";
				self._handleDefaults.call(self, error, "onExecError", "debug");
			}, "mimetype":"text/plain", "sync":true}, this.cacheContent));
			code += tmp;
		} else {
			code += scripts[i];
		}
	}
	try {
		if (this.scriptSeparation) {
			delete this.scriptScope;
			this.scriptScope = new (new Function("_container_", code + "; return this;"))(self);
		} else {
			var djg = dojo.global();
			if (djg.execScript) {
				djg.execScript(code);
			} else {
				var djd = dojo.doc();
				var sc = djd.createElement("script");
				sc.appendChild(djd.createTextNode(code));
				(this.containerNode || this.domNode).appendChild(sc);
			}
		}
	}
	catch (e) {
		e.text = "Error running scripts from content:\n" + e.description;
		this._handleDefaults(e, "onExecError", "debug");
	}
}});


__CPAN_FILE__ src/widget/MonthlyCalendar.xd.js
/*
	Copyright (c) 2004-2006, The Dojo Foundati