# Generated by default/object.tt
package Paws::ComputeOptimizer::LambdaFunctionRecommendationFilter;
  use Moose;
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has Values => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'values', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ComputeOptimizer::LambdaFunctionRecommendationFilter

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ComputeOptimizer::LambdaFunctionRecommendationFilter object:

  $service_obj->Method(Att1 => { Name => $value, ..., Values => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ComputeOptimizer::LambdaFunctionRecommendationFilter object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

Describes a filter that returns a more specific list of AWS Lambda
function recommendations. Use this filter with the
C<GetLambdaFunctionRecommendations> action.

You can use C<EBSFilter> with the C<GetEBSVolumeRecommendations>
action, C<JobFilter> with the C<DescribeRecommendationExportJobs>
action, and C<Filter> with the C<GetAutoScalingGroupRecommendations>
and C<GetEC2InstanceRecommendations> actions.

=head1 ATTRIBUTES


=head2 Name => Str

The name of the filter.

Specify C<Finding> to return recommendations with a specific finding
classification (e.g., C<NotOptimized>).

Specify C<FindingReasonCode> to return recommendations with a specific
finding reason code (e.g., C<MemoryUnderprovisioned>).


=head2 Values => ArrayRef[Str|Undef]

The value of the filter.

The valid values for this parameter are as follows, depending on what
you specify for the C<name> parameter:

=over

=item *

Specify C<Optimized>, C<NotOptimized>, or C<Unavailable> if you specify
the C<name> parameter as C<Finding>.

=item *

Specify C<MemoryOverprovisioned>, C<MemoryUnderprovisioned>,
C<InsufficientData>, or C<Inconclusive> if you specify the C<name>
parameter as C<FindingReasonCode>.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ComputeOptimizer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

