# Generated by default/object.tt
package Paws::Route53Resolver::ResolverEndpoint;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str');
  has CreationTime => (is => 'ro', isa => 'Str');
  has CreatorRequestId => (is => 'ro', isa => 'Str');
  has Direction => (is => 'ro', isa => 'Str');
  has HostVPCId => (is => 'ro', isa => 'Str');
  has Id => (is => 'ro', isa => 'Str');
  has IpAddressCount => (is => 'ro', isa => 'Int');
  has ModificationTime => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has SecurityGroupIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Status => (is => 'ro', isa => 'Str');
  has StatusMessage => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Route53Resolver::ResolverEndpoint

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Route53Resolver::ResolverEndpoint object:

  $service_obj->Method(Att1 => { Arn => $value, ..., StatusMessage => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Route53Resolver::ResolverEndpoint object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

In the response to a CreateResolverEndpoint
(https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html),
DeleteResolverEndpoint
(https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverEndpoint.html),
GetResolverEndpoint
(https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html),
ListResolverEndpoints
(https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html),
or UpdateResolverEndpoint
(https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverEndpoint.html)
request, a complex type that contains settings for an existing inbound
or outbound Resolver endpoint.

=head1 ATTRIBUTES


=head2 Arn => Str

The ARN (Amazon Resource Name) for the Resolver endpoint.


=head2 CreationTime => Str

The date and time that the endpoint was created, in Unix time format
and Coordinated Universal Time (UTC).


=head2 CreatorRequestId => Str

A unique string that identifies the request that created the Resolver
endpoint. The C<CreatorRequestId> allows failed requests to be retried
without the risk of running the operation twice.


=head2 Direction => Str

Indicates whether the Resolver endpoint allows inbound or outbound DNS
queries:

=over

=item *

C<INBOUND>: allows DNS queries to your VPC from your network

=item *

C<OUTBOUND>: allows DNS queries from your VPC to your network

=back



=head2 HostVPCId => Str

The ID of the VPC that you want to create the Resolver endpoint in.


=head2 Id => Str

The ID of the Resolver endpoint.


=head2 IpAddressCount => Int

The number of IP addresses that the Resolver endpoint can use for DNS
queries.


=head2 ModificationTime => Str

The date and time that the endpoint was last modified, in Unix time
format and Coordinated Universal Time (UTC).


=head2 Name => Str

The name that you assigned to the Resolver endpoint when you submitted
a CreateResolverEndpoint
(https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html)
request.


=head2 SecurityGroupIds => ArrayRef[Str|Undef]

The ID of one or more security groups that control access to this VPC.
The security group must include one or more inbound rules (for inbound
endpoints) or outbound rules (for outbound endpoints). Inbound and
outbound rules must allow TCP and UDP access. For inbound access, open
port 53. For outbound access, open the port that you're using for DNS
queries on your network.


=head2 Status => Str

A code that specifies the current status of the Resolver endpoint.
Valid values include the following:

=over

=item *

C<CREATING>: Resolver is creating and configuring one or more Amazon
VPC network interfaces for this endpoint.

=item *

C<OPERATIONAL>: The Amazon VPC network interfaces for this endpoint are
correctly configured and able to pass inbound or outbound DNS queries
between your network and Resolver.

=item *

C<UPDATING>: Resolver is associating or disassociating one or more
network interfaces with this endpoint.

=item *

C<AUTO_RECOVERING>: Resolver is trying to recover one or more of the
network interfaces that are associated with this endpoint. During the
recovery process, the endpoint functions with limited capacity because
of the limit on the number of DNS queries per IP address (per network
interface). For the current limit, see Limits on Route 53 Resolver
(https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html#limits-api-entities-resolver).

=item *

C<ACTION_NEEDED>: This endpoint is unhealthy, and Resolver can't
automatically recover it. To resolve the problem, we recommend that you
check each IP address that you associated with the endpoint. For each
IP address that isn't available, add another IP address and then delete
the IP address that isn't available. (An endpoint must always include
at least two IP addresses.) A status of C<ACTION_NEEDED> can have a
variety of causes. Here are two common causes:

=over

=item *

One or more of the network interfaces that are associated with the
endpoint were deleted using Amazon VPC.

=item *

The network interface couldn't be created for some reason that's
outside the control of Resolver.

=back

=item *

C<DELETING>: Resolver is deleting this endpoint and the associated
network interfaces.

=back



=head2 StatusMessage => Str

A detailed description of the status of the Resolver endpoint.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Route53Resolver>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

