# Generated by default/object.tt
package Paws::SecurityHub::AwsElbLoadBalancerAttributes;
  use Moose;
  has AccessLog => (is => 'ro', isa => 'Paws::SecurityHub::AwsElbLoadBalancerAccessLog');
  has ConnectionDraining => (is => 'ro', isa => 'Paws::SecurityHub::AwsElbLoadBalancerConnectionDraining');
  has ConnectionSettings => (is => 'ro', isa => 'Paws::SecurityHub::AwsElbLoadBalancerConnectionSettings');
  has CrossZoneLoadBalancing => (is => 'ro', isa => 'Paws::SecurityHub::AwsElbLoadBalancerCrossZoneLoadBalancing');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsElbLoadBalancerAttributes

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsElbLoadBalancerAttributes object:

  $service_obj->Method(Att1 => { AccessLog => $value, ..., CrossZoneLoadBalancing => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsElbLoadBalancerAttributes object:

  $result = $service_obj->Method(...);
  $result->Att1->AccessLog

=head1 DESCRIPTION

Contains attributes for the load balancer.

=head1 ATTRIBUTES


=head2 AccessLog => L<Paws::SecurityHub::AwsElbLoadBalancerAccessLog>

Information about the access log configuration for the load balancer.

If the access log is enabled, the load balancer captures detailed
information about all requests. It delivers the information to a
specified S3 bucket.


=head2 ConnectionDraining => L<Paws::SecurityHub::AwsElbLoadBalancerConnectionDraining>

Information about the connection draining configuration for the load
balancer.

If connection draining is enabled, the load balancer allows existing
requests to complete before it shifts traffic away from a deregistered
or unhealthy instance.


=head2 ConnectionSettings => L<Paws::SecurityHub::AwsElbLoadBalancerConnectionSettings>

Connection settings for the load balancer.

If an idle timeout is configured, the load balancer allows connections
to remain idle for the specified duration. When a connection is idle,
no data is sent over the connection.


=head2 CrossZoneLoadBalancing => L<Paws::SecurityHub::AwsElbLoadBalancerCrossZoneLoadBalancing>

Cross-zone load balancing settings for the load balancer.

If cross-zone load balancing is enabled, the load balancer routes the
request traffic evenly across all instances regardless of the
Availability Zones.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

