package IO::K8s::Api::Storagemigration::V1alpha1::StorageVersionMigrationStatus;
# ABSTRACT: Status of the storage version migration.
our $VERSION = '1.001';
use IO::K8s::Resource;

k8s conditions => ['Storagemigration::V1alpha1::MigrationCondition'];


k8s resourceVersion => Str;


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

IO::K8s::Api::Storagemigration::V1alpha1::StorageVersionMigrationStatus - Status of the storage version migration.

=head1 VERSION

version 1.001

=head2 conditions

The latest available observations of the migration's current state.

=head2 resourceVersion

ResourceVersion to compare with the GC cache for performing the migration. This is the current resource version of given group, version and resource when kube-controller-manager first observes this StorageVersionMigration resource.

=head1 SUPPORT

=head2 Issues

Please report bugs and feature requests on GitHub at
L<https://github.com/pplu/io-k8s-p5/issues>.

=head2 IRC

Join C<#kubernetes> on C<irc.perl.org> or message Getty directly.

=head1 CONTRIBUTING

Contributions are welcome! Please fork the repository and submit a pull request.

=head1 AUTHORS

=over 4

=item *

Torsten Raudssus <torsten@raudssus.de>

=item *

Jose Luis Martinez <jlmartin@cpan.org> (original author, inactive)

=back

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by Jose Luis Martinez.

This is free software, licensed under:

  The Apache License, Version 2.0, January 2004

=cut
