# Generated by default/object.tt
package Paws::Kendra::WebCrawlerConfiguration;
  use Moose;
  has AuthenticationConfiguration => (is => 'ro', isa => 'Paws::Kendra::AuthenticationConfiguration');
  has CrawlDepth => (is => 'ro', isa => 'Int');
  has MaxContentSizePerPageInMegaBytes => (is => 'ro', isa => 'Num');
  has MaxLinksPerPage => (is => 'ro', isa => 'Int');
  has MaxUrlsPerMinuteCrawlRate => (is => 'ro', isa => 'Int');
  has ProxyConfiguration => (is => 'ro', isa => 'Paws::Kendra::ProxyConfiguration');
  has UrlExclusionPatterns => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has UrlInclusionPatterns => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Urls => (is => 'ro', isa => 'Paws::Kendra::Urls', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::WebCrawlerConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::WebCrawlerConfiguration object:

  $service_obj->Method(Att1 => { AuthenticationConfiguration => $value, ..., Urls => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::WebCrawlerConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AuthenticationConfiguration

=head1 DESCRIPTION

Provides the configuration information required for Amazon Kendra web
crawler.

=head1 ATTRIBUTES


=head2 AuthenticationConfiguration => L<Paws::Kendra::AuthenticationConfiguration>

Provides configuration information required to connect to websites
using authentication.

You can connect to websites using basic authentication of user name and
password.

You must provide the website host name and port number. For example,
the host name of https://a.example.com/page1.html is "a.example.com"
and the port is 443, the standard port for HTTPS. You use a secret in
AWS Secrets Manager
(https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html)
to store your authentication credentials.


=head2 CrawlDepth => Int

Specifies the number of levels in a website that you want to crawl.

The first level begins from the website seed or starting point URL. For
example, if a website has 3 levels E<ndash> index level (i.e. seed in
this example), sections level, and subsections level E<ndash> and you
are only interested in crawling information up to the sections level
(i.e. levels 0-1), you can set your depth to 1.

The default crawl depth is set to 2.


=head2 MaxContentSizePerPageInMegaBytes => Num

The maximum size (in MB) of a webpage or attachment to crawl.

Files larger than this size (in MB) are skipped/not crawled.

The default maximum size of a webpage or attachment is set to 50 MB.


=head2 MaxLinksPerPage => Int

The maximum number of URLs on a webpage to include when crawling a
website. This number is per webpage.

As a websiteE<rsquo>s webpages are crawled, any URLs the webpages link
to are also crawled. URLs on a webpage are crawled in order of
appearance.

The default maximum links per page is 100.


=head2 MaxUrlsPerMinuteCrawlRate => Int

The maximum number of URLs crawled per website host per minute.

A minimum of one URL is required.

The default maximum number of URLs crawled per website host per minute
is 300.


=head2 ProxyConfiguration => L<Paws::Kendra::ProxyConfiguration>

Provides configuration information required to connect to your internal
websites via a web proxy.

You must provide the website host name and port number. For example,
the host name of https://a.example.com/page1.html is "a.example.com"
and the port is 443, the standard port for HTTPS.

Web proxy credentials are optional and you can use them to connect to a
web proxy server that requires basic authentication. To store web proxy
credentials, you use a secret in AWS Secrets Manager
(https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html).


=head2 UrlExclusionPatterns => ArrayRef[Str|Undef]

The regular expression pattern to exclude certain URLs to crawl.

If there is a regular expression pattern to include certain URLs that
conflicts with the exclude pattern, the exclude pattern takes
precedence.


=head2 UrlInclusionPatterns => ArrayRef[Str|Undef]

The regular expression pattern to include certain URLs to crawl.

If there is a regular expression pattern to exclude certain URLs that
conflicts with the include pattern, the exclude pattern takes
precedence.


=head2 B<REQUIRED> Urls => L<Paws::Kendra::Urls>

Specifies the seed or starting point URLs of the websites or the
sitemap URLs of the websites you want to crawl.

You can include website subdomains. You can list up to 100 seed URLs
and up to three sitemap URLs.

I<When selecting websites to index, you must adhere to the Amazon
Acceptable Use Policy (https://aws.amazon.com/aup/) and all other
Amazon terms. Remember that you must only use the Amazon Kendra web
crawler to index your own webpages, or webpages that you have
authorization to index.>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

