# Generated by default/object.tt
package Paws::CodeArtifact::PackageSummary;
  use Moose;
  has Format => (is => 'ro', isa => 'Str', request_name => 'format', traits => ['NameInRequest']);
  has Namespace => (is => 'ro', isa => 'Str', request_name => 'namespace', traits => ['NameInRequest']);
  has Package => (is => 'ro', isa => 'Str', request_name => 'package', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeArtifact::PackageSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeArtifact::PackageSummary object:

  $service_obj->Method(Att1 => { Format => $value, ..., Package => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeArtifact::PackageSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Format

=head1 DESCRIPTION

Details about a package, including its format, namespace, and name. The
ListPackages
(https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackages.html)
operation returns a list of C<PackageSummary> objects.

=head1 ATTRIBUTES


=head2 Format => Str

The format of the package. Valid values are:

=over

=item *

C<npm>

=item *

C<pypi>

=item *

C<maven>

=back



=head2 Namespace => Str

The namespace of the package. The package component that specifies its
namespace depends on its type. For example:

=over

=item *

The namespace of a Maven package is its C<groupId>.

=item *

The namespace of an npm package is its C<scope>.

=item *

A Python package does not contain a corresponding component, so Python
packages do not have a namespace.

=back



=head2 Package => Str

The name of the package.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeArtifact>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

