# Generated by default/object.tt
package Paws::Appflow::PrefixConfig;
  use Moose;
  has PrefixFormat => (is => 'ro', isa => 'Str', request_name => 'prefixFormat', traits => ['NameInRequest']);
  has PrefixType => (is => 'ro', isa => 'Str', request_name => 'prefixType', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Appflow::PrefixConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Appflow::PrefixConfig object:

  $service_obj->Method(Att1 => { PrefixFormat => $value, ..., PrefixType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Appflow::PrefixConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->PrefixFormat

=head1 DESCRIPTION

Determines the prefix that Amazon AppFlow applies to the destination
folder name. You can name your destination folders according to the
flow frequency and date.

=head1 ATTRIBUTES


=head2 PrefixFormat => Str

Determines the level of granularity that's included in the prefix.


=head2 PrefixType => Str

Determines the format of the prefix, and whether it applies to the file
name, file path, or both.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Appflow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

