/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.store.access.SpaceInfo;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.BasePage;

public abstract class BaseContainer
implements Lockable {
    protected ContainerKey identity;
    protected boolean isDropped;
    protected boolean isCommittedDrop;
    protected boolean isReusableRecordId = false;

    protected BaseContainer() {
    }

    protected void fillInIdentity(ContainerKey containerKey) {
        this.identity = containerKey;
    }

    public void clearIdentity() {
        this.identity = null;
    }

    public Object getIdentity() {
        return this.identity;
    }

    public void lockEvent(Latch latch) {
    }

    public boolean requestCompatible(Object object, Object object2) {
        return false;
    }

    public boolean lockerAlwaysCompatible() {
        return false;
    }

    public void unlockEvent(Latch latch) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compressContainer(BaseContainerHandle baseContainerHandle) throws StandardException {
        BaseContainerHandle baseContainerHandle2;
        RawTransaction rawTransaction = baseContainerHandle.getTransaction().startNestedTopTransaction();
        int n = baseContainerHandle.getMode();
        if ((n & 2) == 0 && (n & 1) == 1) {
            n &= 0xFFFFFFFE;
        }
        if ((baseContainerHandle2 = (BaseContainerHandle)rawTransaction.openContainer(this.identity, null, n)) == null) {
            throw StandardException.newException("XSDAG.S", new Long(this.getSegmentId()), (Object)new Long(this.getContainerId()));
        }
        rawTransaction.getLockFactory().lockObject((Object)rawTransaction, rawTransaction, this, null, -1);
        try {
            this.compressContainer(rawTransaction, baseContainerHandle2);
        }
        finally {
            rawTransaction.commit();
            rawTransaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Page addPage(BaseContainerHandle baseContainerHandle, boolean bl) throws StandardException {
        BasePage basePage;
        RawTransaction rawTransaction;
        block8: {
            block7: {
                BaseContainerHandle baseContainerHandle2;
                rawTransaction = baseContainerHandle.getTransaction().startNestedTopTransaction();
                int n = baseContainerHandle.getMode();
                if ((n & 2) == 0 && (n & 1) == 1) {
                    n &= 0xFFFFFFFE;
                }
                if ((baseContainerHandle2 = (BaseContainerHandle)rawTransaction.openContainer(this.identity, null, n)) == null) {
                    throw StandardException.newException("XSDAG.S", new Long(this.getSegmentId()), (Object)new Long(this.getContainerId()));
                }
                rawTransaction.getLockFactory().lockObject((Object)rawTransaction, rawTransaction, this, null, -1);
                basePage = null;
                try {
                    basePage = this.newPage(baseContainerHandle, rawTransaction, baseContainerHandle2, bl);
                    Object var8_7 = null;
                    if (basePage == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (basePage != null) {
                        rawTransaction.commitNoSync(1);
                    } else {
                        rawTransaction.abort();
                    }
                    rawTransaction.close();
                    throw throwable;
                }
                rawTransaction.commitNoSync(1);
                break block8;
            }
            rawTransaction.abort();
        }
        rawTransaction.close();
        if (!this.identity.equals(basePage.getPageId().getContainerId())) {
            throw StandardException.newException("XSDAC.S", this.identity, (Object)basePage.getPageId().getContainerId());
        }
        return basePage;
    }

    public abstract void getContainerProperties(Properties var1) throws StandardException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePage(BaseContainerHandle baseContainerHandle, BasePage basePage) throws StandardException {
        try {
            RecordHandle recordHandle = basePage.makeRecordHandle(2);
            if (!this.getDeallocLock(baseContainerHandle, recordHandle, false, false)) {
                throw StandardException.newException("XSDAI.S", basePage.getIdentity());
            }
            this.deallocatePage(baseContainerHandle, basePage);
        }
        finally {
            if (basePage != null) {
                basePage.unlatch();
            }
        }
    }

    protected boolean getDeallocLock(BaseContainerHandle baseContainerHandle, RecordHandle recordHandle, boolean bl, boolean bl2) throws StandardException {
        RawTransaction rawTransaction = baseContainerHandle.getTransaction();
        LockingPolicy lockingPolicy = rawTransaction.newLockingPolicy(1, 4, true);
        PageKey pageKey = new PageKey(this.identity, recordHandle.getPageNumber());
        if (lockingPolicy != null) {
            if (bl2) {
                return lockingPolicy.zeroDurationLockRecordForWrite(rawTransaction, recordHandle, false, bl);
            }
            return lockingPolicy.lockRecordForWrite(rawTransaction, recordHandle, false, bl);
        }
        throw StandardException.newException("XSDAI.S", pageKey);
    }

    protected Page getAllocPage(BaseContainerHandle baseContainerHandle, long l, boolean bl) throws StandardException {
        return this.latchPage(baseContainerHandle, this.getAllocPage(l), bl);
    }

    protected Page getAnyPage(BaseContainerHandle baseContainerHandle, long l, boolean bl) throws StandardException {
        return this.latchPage(baseContainerHandle, this.getAnyPage(baseContainerHandle, l), bl);
    }

    protected Page getFirstPage(BaseContainerHandle baseContainerHandle) throws StandardException {
        return this.getFirstHeadPage(baseContainerHandle, true);
    }

    protected Page getNextPage(BaseContainerHandle baseContainerHandle, long l) throws StandardException {
        return this.getNextHeadPage(baseContainerHandle, l, true);
    }

    protected BasePage latchPage(BaseContainerHandle baseContainerHandle, BasePage basePage, boolean bl) throws StandardException {
        if (basePage != null) {
            if (bl) {
                basePage.setExclusive(baseContainerHandle);
            } else if (!basePage.setExclusiveNoWait(baseContainerHandle)) {
                return null;
            }
        }
        return basePage;
    }

    protected boolean use(BaseContainerHandle baseContainerHandle, boolean bl, boolean bl2) throws StandardException {
        if (bl && !this.canUpdate()) {
            throw StandardException.newException("40XD1");
        }
        return bl2 || !this.getDroppedState() && !this.getCommittedDropState();
    }

    protected void letGo(BaseContainerHandle baseContainerHandle) {
        RawTransaction rawTransaction = baseContainerHandle.getTransaction();
        baseContainerHandle.getLockingPolicy().unlockContainer(rawTransaction, baseContainerHandle);
    }

    protected boolean getDroppedState() {
        return this.isDropped;
    }

    protected boolean getCommittedDropState() {
        return this.isCommittedDrop;
    }

    protected boolean isReusableRecordId() {
        return this.isReusableRecordId;
    }

    public int getContainerStatus() {
        if (this.getCommittedDropState()) {
            return 4;
        }
        if (this.getDroppedState()) {
            return 2;
        }
        return 1;
    }

    public long getContainerId() {
        return this.identity.getContainerId();
    }

    public long getSegmentId() {
        return this.identity.getSegmentId();
    }

    protected abstract SpaceInfo getSpaceInfo(BaseContainerHandle var1) throws StandardException;

    protected abstract boolean canUpdate();

    protected abstract void preDirty(boolean var1);

    protected abstract BasePage getPage(BaseContainerHandle var1, long var2, boolean var4) throws StandardException;

    protected abstract BasePage getAllocPage(long var1) throws StandardException;

    protected abstract BasePage getAnyPage(BaseContainerHandle var1, long var2) throws StandardException;

    protected abstract BasePage reCreatePageForLoadTran(BaseContainerHandle var1, int var2, long var3, long var5) throws StandardException;

    protected abstract ByteArray logCreateContainerInfo() throws StandardException;

    protected abstract BasePage getHeadPage(BaseContainerHandle var1, long var2, boolean var4) throws StandardException;

    protected abstract BasePage getFirstHeadPage(BaseContainerHandle var1, boolean var2) throws StandardException;

    protected abstract BasePage getNextHeadPage(BaseContainerHandle var1, long var2, boolean var4) throws StandardException;

    protected abstract BasePage getPageForInsert(BaseContainerHandle var1, int var2) throws StandardException;

    protected abstract BasePage getPageForCompress(BaseContainerHandle var1, int var2, long var3) throws StandardException;

    protected abstract void truncatePages(long var1) throws StandardException;

    protected abstract BasePage newPage(BaseContainerHandle var1, RawTransaction var2, BaseContainerHandle var3, boolean var4) throws StandardException;

    protected abstract void compressContainer(RawTransaction var1, BaseContainerHandle var2) throws StandardException;

    protected abstract void deallocatePage(BaseContainerHandle var1, BasePage var2) throws StandardException;

    protected void truncate(BaseContainerHandle baseContainerHandle) throws StandardException {
    }

    protected abstract void dropContainer(LogInstant var1, boolean var2);

    protected abstract void removeContainer(LogInstant var1, boolean var2) throws StandardException;

    protected abstract long getContainerVersion() throws StandardException;

    protected abstract void flushAll() throws StandardException;

    protected abstract void prepareForBulkLoad(BaseContainerHandle var1, int var2);

    protected abstract void clearPreallocThreshold();

    public abstract long getEstimatedRowCount(int var1) throws StandardException;

    public abstract void setEstimatedRowCount(long var1, int var3) throws StandardException;

    public abstract long getEstimatedPageCount(BaseContainerHandle var1, int var2) throws StandardException;

    protected void setDroppedState(boolean bl) {
        this.isDropped = bl;
    }

    protected void setCommittedDropState(boolean bl) {
        this.isCommittedDrop = bl;
    }

    protected void setReusableRecordIdState(boolean bl) {
        this.isReusableRecordId = bl;
    }

    public boolean lockAttributes(int n, Hashtable hashtable) {
        return false;
    }
}

