# $Id: Makefile.PL,v 1.00 2001/05/13 14:11:35 ams Exp $
# Copyright 2001 Abhijit Menon-Sen <ams@wiw.org>

use Config;
use File::Spec;
use ExtUtils::MakeMaker;

($stdint = <<"TEST") =~ s/^\| {0,3}//gm;
|   #include <stdint.h>
|   int main(void) {
|       printf("%d%d", sizeof(uint16_t), sizeof(uint32_t));
|       return 0;
|   }
TEST
($inttypes = $stdint) =~ s/stdint/inttypes/;

print "Searching for uint*_t... ";

if (ftest($inttypes) eq "24") {
    print "inttypes.h";
    $def = "#include <inttypes.h>";
} elsif (ftest($stdint) eq "24") {
    print "stdint.h";
    $def = "#include <stdint.h>";
} else {
    print "no";
    foreach (qw(short int long)) {
        my $size = $Config{"${_}size"};
        $sixteen   ||= "unsigned $_" if ($size == 2);
        $thirtytwo ||= "unsigned $_" if ($size == 4);
    }
    $def = "typedef $sixteen uint16_t;\ntypedef $thirtytwo uint32_t;";
}

print "\n";

($text = <<"PLATFORM") =~ s/^\| {0,3}//gm;
|   /* Automatically generated by "perl Makefile.PL" */
|
|   #ifndef _PLATFORM_H_
|   #define _PLATFORM_H_
|
|   $def
|
|   #endif
PLATFORM

open(F, ">platform.h") || die "platform.h: $!\n";
print F $text;
close F;

WriteMakefile(
    NAME          => 'Crypt::GOST',
    OBJECT        => 'GOST.o _gost.o',
    VERSION_FROM  => 'GOST.pm',
    ABSTRACT_FROM => 'GOST.pm',
);

# Compile and run a program to test for a particular feature.
sub ftest
{
    my $null = File::Spec->devnull;
    my $result = 0;

    open(F, ">ftest.c") || die "ftest.c: $!\n";
    print F $_[0];
    close F;

    unlink("ftest");
    open OLDERR, ">&STDERR" || die;
    open OLDOUT, ">&STDOUT" || die;
    open STDOUT, ">$null" || die;
    open STDERR, ">$null" || die;

    if (system("$Config{cc} $Config{ccflags} -o ftest ftest.c") == 0) {
        open STDOUT, ">&OLDOUT" || die;
        open (F, "./ftest |") && do {
            local $/;
            $result = <F>;
        };
    }

    open STDERR, ">&OLDERR" || die;
    open STDOUT, ">&OLDOUT" || die;
    unlink("ftest", "ftest.c");

    return $result;
}
