package App::prefixcat;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-08-09'; # DATE
our $DIST = 'App-prefixcat'; # DIST
our $VERSION = '0.001'; # VERSION

sub run {
    my %opts = @_;

    my @ifh; # input handles
    my @ifnames;;
    if (@ARGV) {
        for (@ARGV) {
            my $ifh;
            if ($_ eq '-') {
                $ifh = *STDIN;
            } else {
                die "Is a directory: $_\n" if -d $_;
                open $ifh, "<", $_ or die "Can't open input file $_: $!\n";
            }
            push @ifh, $ifh;
            push @ifnames, $_;
        }
    } else {
        push @ifh, *STDIN;
        push @ifnames, "-";
    }

    for my $filenum (1 .. @ifh) {
        my $ifh = $ifh[$filenum-1];
        my $ifname = $ifnames[$filenum-1];
        local $main::filename = $ifname;
        local $main::filenum = $filenum;
        my $linenum = 0;
        while (defined(my $line = <$ifh>)) {
            $linenum++;
            local $main::linenum = $linenum;
            if ($opts{eval}) {
                {
                    local $_ = $line;
                    my $res = $opts{eval}->($_);
                    print $res // $_;
                }
            } else {
                print sprintf($opts{format}, $ifname) . $opts{separator} . $line;
            }
        }
    }
}


1;
# ABSTRACT: Like Unix `cat` but by default prefix each line with filename

__END__

=pod

=encoding UTF-8

=head1 NAME

App::prefixcat - Like Unix `cat` but by default prefix each line with filename

=head1 VERSION

This document describes version 0.001 of App::prefixcat (from Perl distribution App-prefixcat), released on 2024-08-09.

=head1 SYNOPSIS

See the command-line script L<prefixcat>.

=for Pod::Coverage ^(.+)$

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-prefixcat>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-prefixcat>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-prefixcat>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
