/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ExportResultSetForObject;
import org.apache.derby.impl.load.ExportWriteDataAbstract;

abstract class ExportAbstract {
    protected ControlInfo controlFileReader;
    protected ExportResultSetForObject exportResultSetForObject;
    protected ExportWriteDataAbstract exportWriteData;
    protected Connection con;
    protected String entityName;
    protected String schemaName;
    protected String selectStatement;

    ExportAbstract() {
    }

    protected ResultSet resultSetForEntity() throws Exception {
        this.exportResultSetForObject = new ExportResultSetForObject(this.con, this.schemaName, this.entityName, this.selectStatement);
        ResultSet resultSet = this.exportResultSetForObject.getResultSet();
        return resultSet;
    }

    public String[] getOneRowAtATime(ResultSet resultSet) throws Exception {
        int n = this.exportResultSetForObject.getColumnCount();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (resultSet.next()) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                if (resultSet.getObject(i + 1) == null) continue;
                stringArray[i] = resultSet.getString(i + 1);
            }
            return stringArray;
        }
        resultSet.close();
        this.exportResultSetForObject.close();
        return null;
    }

    protected ControlInfo getControlFileReader() {
        return this.controlFileReader;
    }

    protected abstract ExportWriteDataAbstract getExportWriteData() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAllTheWork() throws Exception {
        ResultSet resultSet;
        block8: {
            resultSet = null;
            try {
                resultSet = this.resultSetForEntity();
                if (resultSet != null) {
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n = resultSetMetaData.getColumnCount();
                    boolean[] blArray = new boolean[n];
                    for (int i = 0; i < n; ++i) {
                        int n2 = resultSetMetaData.getColumnType(i + 1);
                        blArray[i] = n2 == -5 || n2 == 3 || n2 == 8 || n2 == 6 || n2 == 4 || n2 == 2 || n2 == 7 || n2 == 5 || n2 == -6;
                    }
                    this.exportWriteData = this.getExportWriteData();
                    this.exportWriteData.writeColumnDefinitionOptionally(this.exportResultSetForObject.getColumnDefinition(), this.exportResultSetForObject.getColumnTypes());
                    this.exportWriteData.setColumnLengths(this.controlFileReader.getColumnWidths());
                    String[] stringArray = this.getOneRowAtATime(resultSet);
                    while (stringArray != null) {
                        this.exportWriteData.writeData(stringArray, blArray);
                        stringArray = this.getOneRowAtATime(resultSet);
                    }
                }
                Object var8_8 = null;
                if (this.exportWriteData == null) break block8;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (this.exportWriteData != null) {
                    this.exportWriteData.noMoreRows();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                throw throwable;
            }
            this.exportWriteData.noMoreRows();
        }
        if (resultSet != null) {
            resultSet.close();
        }
    }
}

