# Generated by default/object.tt
package Paws::SageMaker::ProductionVariantCoreDumpConfig;
  use Moose;
  has DestinationS3Uri => (is => 'ro', isa => 'Str', required => 1);
  has KmsKeyId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ProductionVariantCoreDumpConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ProductionVariantCoreDumpConfig object:

  $service_obj->Method(Att1 => { DestinationS3Uri => $value, ..., KmsKeyId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ProductionVariantCoreDumpConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->DestinationS3Uri

=head1 DESCRIPTION

Specifies configuration for a core dump from the model container when
the process crashes.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DestinationS3Uri => Str

The Amazon S3 bucket to send the core dump to.


=head2 KmsKeyId => Str

The Amazon Web Services Key Management Service (Amazon Web Services
KMS) key that Amazon SageMaker uses to encrypt the core dump data at
rest using Amazon S3 server-side encryption. The C<KmsKeyId> can be any
of the following formats:

=over

=item *

// KMS Key ID

C<"1234abcd-12ab-34cd-56ef-1234567890ab">

=item *

// Amazon Resource Name (ARN) of a KMS Key

C<"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab">

=item *

// KMS Key Alias

C<"alias/ExampleAlias">

=item *

// Amazon Resource Name (ARN) of a KMS Key Alias

C<"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias">

=back

If you use a KMS key ID or an alias of your master key, the Amazon
SageMaker execution role must include permissions to call
C<kms:Encrypt>. If you don't provide a KMS key ID, Amazon SageMaker
uses the default KMS key for Amazon S3 for your role's account. Amazon
SageMaker uses server-side encryption with KMS-managed keys for
C<OutputDataConfig>. If you use a bucket policy with an C<s3:PutObject>
permission that only allows objects with server-side encryption, set
the condition key of C<s3:x-amz-server-side-encryption> to
C<"aws:kms">. For more information, see KMS-Managed Encryption Keys
(https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html)
in the I<Amazon Simple Storage Service Developer Guide.>

The KMS key policy must grant permission to the IAM role that you
specify in your C<CreateEndpoint> and C<UpdateEndpoint> requests. For
more information, see Using Key Policies in Amazon Web Services KMS
(https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
in the I<Amazon Web Services Key Management Service Developer Guide>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

