// Populate the sidebar
//
// This is a script, and not included directly in the page, to control the total size of the book.
// The TOC contains an entry for each page, so if each page includes a copy of the TOC,
// the total size of the page becomes O(n**2).
class MDBookSidebarScrollbox extends HTMLElement {
    constructor() {
        super();
    }
    connectedCallback() {
        this.innerHTML = '<ol class="chapter"><li class="chapter-item affix "><a href="index.html">はじめに</a></li><li class="chapter-item "><a href="hello.html"><strong aria-hidden="true">1.</strong> Hello World</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="hello/comment.html"><strong aria-hidden="true">1.1.</strong> コメント</a></li><li class="chapter-item "><a href="hello/print.html"><strong aria-hidden="true">1.2.</strong> フォーマットして出力</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="hello/print/print_debug.html"><strong aria-hidden="true">1.2.1.</strong> Debug</a></li><li class="chapter-item "><a href="hello/print/print_display.html"><strong aria-hidden="true">1.2.2.</strong> Display</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="hello/print/print_display/testcase_list.html"><strong aria-hidden="true">1.2.2.1.</strong> テストケース：リスト</a></li></ol></li><li class="chapter-item "><a href="hello/print/fmt.html"><strong aria-hidden="true">1.2.3.</strong> フォーマット</a></li></ol></li></ol></li><li class="chapter-item "><a href="primitives.html"><strong aria-hidden="true">2.</strong> 基本データ型</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="primitives/literals.html"><strong aria-hidden="true">2.1.</strong> リテラルと演算子</a></li><li class="chapter-item "><a href="primitives/tuples.html"><strong aria-hidden="true">2.2.</strong> タプル</a></li><li class="chapter-item "><a href="primitives/array.html"><strong aria-hidden="true">2.3.</strong> 配列とスライス</a></li></ol></li><li class="chapter-item "><a href="custom_types.html"><strong aria-hidden="true">3.</strong> カスタム型</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="custom_types/structs.html"><strong aria-hidden="true">3.1.</strong> 構造体</a></li><li class="chapter-item "><a href="custom_types/enum.html"><strong aria-hidden="true">3.2.</strong> 列挙型</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="custom_types/enum/enum_use.html"><strong aria-hidden="true">3.2.1.</strong> use</a></li><li class="chapter-item "><a href="custom_types/enum/c_like.html"><strong aria-hidden="true">3.2.2.</strong> C言語ライクな列挙型</a></li><li class="chapter-item "><a href="custom_types/enum/testcase_linked_list.html"><strong aria-hidden="true">3.2.3.</strong> テストケース：連結リスト</a></li></ol></li><li class="chapter-item "><a href="custom_types/constants.html"><strong aria-hidden="true">3.3.</strong> 定数</a></li></ol></li><li class="chapter-item "><a href="variable_bindings.html"><strong aria-hidden="true">4.</strong> 変数束縛</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="variable_bindings/mut.html"><strong aria-hidden="true">4.1.</strong> ミュータビリティ</a></li><li class="chapter-item "><a href="variable_bindings/scope.html"><strong aria-hidden="true">4.2.</strong> スコープとシャドーイング</a></li><li class="chapter-item "><a href="variable_bindings/declare.html"><strong aria-hidden="true">4.3.</strong> 前方宣言</a></li><li class="chapter-item "><a href="variable_bindings/freeze.html"><strong aria-hidden="true">4.4.</strong> 値の凍結</a></li></ol></li><li class="chapter-item "><a href="types.html"><strong aria-hidden="true">5.</strong> 型</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="types/cast.html"><strong aria-hidden="true">5.1.</strong> 型キャスト</a></li><li class="chapter-item "><a href="types/literals.html"><strong aria-hidden="true">5.2.</strong> リテラル</a></li><li class="chapter-item "><a href="types/inference.html"><strong aria-hidden="true">5.3.</strong> 型推論</a></li><li class="chapter-item "><a href="types/alias.html"><strong aria-hidden="true">5.4.</strong> エイリアス</a></li></ol></li><li class="chapter-item "><a href="conversion.html"><strong aria-hidden="true">6.</strong> 型変換</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="conversion/from_into.html"><strong aria-hidden="true">6.1.</strong> FromとInto</a></li><li class="chapter-item "><a href="conversion/try_from_try_into.html"><strong aria-hidden="true">6.2.</strong> TryFromとTryInto</a></li><li class="chapter-item "><a href="conversion/string.html"><strong aria-hidden="true">6.3.</strong> Stringとの型変換</a></li></ol></li><li class="chapter-item "><a href="expression.html"><strong aria-hidden="true">7.</strong> 式</a></li><li class="chapter-item "><a href="flow_control.html"><strong aria-hidden="true">8.</strong> 制御フロー</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="flow_control/if_else.html"><strong aria-hidden="true">8.1.</strong> if/else</a></li><li class="chapter-item "><a href="flow_control/loop.html"><strong aria-hidden="true">8.2.</strong> loop</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="flow_control/loop/nested.html"><strong aria-hidden="true">8.2.1.</strong> ネストとラベル</a></li><li class="chapter-item "><a href="flow_control/loop/return.html"><strong aria-hidden="true">8.2.2.</strong> loopが返す値</a></li></ol></li><li class="chapter-item "><a href="flow_control/while.html"><strong aria-hidden="true">8.3.</strong> while</a></li><li class="chapter-item "><a href="flow_control/for.html"><strong aria-hidden="true">8.4.</strong> for と range</a></li><li class="chapter-item "><a href="flow_control/match.html"><strong aria-hidden="true">8.5.</strong> match</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="flow_control/match/destructuring.html"><strong aria-hidden="true">8.5.1.</strong> デストラクト</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="flow_control/match/destructuring/destructure_tuple.html"><strong aria-hidden="true">8.5.1.1.</strong> タプル</a></li><li class="chapter-item "><a href="flow_control/match/destructuring/destructure_slice.html"><strong aria-hidden="true">8.5.1.2.</strong> 配列とスライス</a></li><li class="chapter-item "><a href="flow_control/match/destructuring/destructure_enum.html"><strong aria-hidden="true">8.5.1.3.</strong> 列挙型</a></li><li class="chapter-item "><a href="flow_control/match/destructuring/destructure_pointers.html"><strong aria-hidden="true">8.5.1.4.</strong> ポインタとref</a></li><li class="chapter-item "><a href="flow_control/match/destructuring/destructure_structures.html"><strong aria-hidden="true">8.5.1.5.</strong> 構造体</a></li></ol></li><li class="chapter-item "><a href="flow_control/match/guard.html"><strong aria-hidden="true">8.5.2.</strong> ガード</a></li><li class="chapter-item "><a href="flow_control/match/binding.html"><strong aria-hidden="true">8.5.3.</strong> 束縛</a></li></ol></li><li class="chapter-item "><a href="flow_control/if_let.html"><strong aria-hidden="true">8.6.</strong> if let</a></li><li class="chapter-item "><a href="flow_control/let_else.html"><strong aria-hidden="true">8.7.</strong> let-else</a></li><li class="chapter-item "><a href="flow_control/while_let.html"><strong aria-hidden="true">8.8.</strong> while let</a></li></ol></li><li class="chapter-item "><a href="fn.html"><strong aria-hidden="true">9.</strong> 関数</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="fn/methods.html"><strong aria-hidden="true">9.1.</strong> メソッド</a></li><li class="chapter-item "><a href="fn/closures.html"><strong aria-hidden="true">9.2.</strong> クロージャ</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="fn/closures/capture.html"><strong aria-hidden="true">9.2.1.</strong> 要素の捕捉</a></li><li class="chapter-item "><a href="fn/closures/input_parameters.html"><strong aria-hidden="true">9.2.2.</strong> 捕捉時の型推論</a></li><li class="chapter-item "><a href="fn/closures/anonymity.html"><strong aria-hidden="true">9.2.3.</strong> 匿名型</a></li><li class="chapter-item "><a href="fn/closures/input_functions.html"><strong aria-hidden="true">9.2.4.</strong> 関数を受け取る関数</a></li><li class="chapter-item "><a href="fn/closures/output_parameters.html"><strong aria-hidden="true">9.2.5.</strong> クロージャを返す関数</a></li><li class="chapter-item "><a href="fn/closures/closure_examples.html"><strong aria-hidden="true">9.2.6.</strong> stdにおける使用例</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="fn/closures/closure_examples/iter_any.html"><strong aria-hidden="true">9.2.6.1.</strong> Iterator::any</a></li><li class="chapter-item "><a href="fn/closures/closure_examples/iter_find.html"><strong aria-hidden="true">9.2.6.2.</strong> イテレータによる検索</a></li></ol></li></ol></li><li class="chapter-item "><a href="fn/hof.html"><strong aria-hidden="true">9.3.</strong> 高階関数</a></li><li class="chapter-item "><a href="fn/diverging.html"><strong aria-hidden="true">9.4.</strong> 発散する関数</a></li></ol></li><li class="chapter-item "><a href="mod.html"><strong aria-hidden="true">10.</strong> モジュール</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="mod/visibility.html"><strong aria-hidden="true">10.1.</strong> 可視性</a></li><li class="chapter-item "><a href="mod/struct_visibility.html"><strong aria-hidden="true">10.2.</strong> 構造体の場合</a></li><li class="chapter-item "><a href="mod/use.html"><strong aria-hidden="true">10.3.</strong> use宣言</a></li><li class="chapter-item "><a href="mod/super.html"><strong aria-hidden="true">10.4.</strong> superとself</a></li><li class="chapter-item "><a href="mod/split.html"><strong aria-hidden="true">10.5.</strong> ファイルの階層構造</a></li></ol></li><li class="chapter-item "><a href="crates.html"><strong aria-hidden="true">11.</strong> クレート</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="crates/lib.html"><strong aria-hidden="true">11.1.</strong> ライブラリの作成</a></li><li class="chapter-item "><a href="crates/using_lib.html"><strong aria-hidden="true">11.2.</strong> ライブラリの利用</a></li></ol></li><li class="chapter-item "><a href="cargo.html"><strong aria-hidden="true">12.</strong> Cargo</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="cargo/deps.html"><strong aria-hidden="true">12.1.</strong> 依存関係</a></li><li class="chapter-item "><a href="cargo/conventions.html"><strong aria-hidden="true">12.2.</strong> 規約</a></li><li class="chapter-item "><a href="cargo/test.html"><strong aria-hidden="true">12.3.</strong> テスト</a></li><li class="chapter-item "><a href="cargo/build_scripts.html"><strong aria-hidden="true">12.4.</strong> ビルドスクリプト</a></li></ol></li><li class="chapter-item "><a href="attribute.html"><strong aria-hidden="true">13.</strong> アトリビュート</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="attribute/unused.html"><strong aria-hidden="true">13.1.</strong> dead_code</a></li><li class="chapter-item "><a href="attribute/crate.html"><strong aria-hidden="true">13.2.</strong> クレート</a></li><li class="chapter-item "><a href="attribute/cfg.html"><strong aria-hidden="true">13.3.</strong> cfg</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="attribute/cfg/custom.html"><strong aria-hidden="true">13.3.1.</strong> 条件の追加</a></li></ol></li></ol></li><li class="chapter-item "><a href="generics.html"><strong aria-hidden="true">14.</strong> ジェネリクス</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="generics/gen_fn.html"><strong aria-hidden="true">14.1.</strong> 関数</a></li><li class="chapter-item "><a href="generics/impl.html"><strong aria-hidden="true">14.2.</strong> 実装</a></li><li class="chapter-item "><a href="generics/gen_trait.html"><strong aria-hidden="true">14.3.</strong> トレイト</a></li><li class="chapter-item "><a href="generics/bounds.html"><strong aria-hidden="true">14.4.</strong> 境界</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="generics/bounds/testcase_empty.html"><strong aria-hidden="true">14.4.1.</strong> テストケース：空トレイト</a></li></ol></li><li class="chapter-item "><a href="generics/multi_bounds.html"><strong aria-hidden="true">14.5.</strong> 複数の境界</a></li><li class="chapter-item "><a href="generics/where.html"><strong aria-hidden="true">14.6.</strong> Where句</a></li><li class="chapter-item "><a href="generics/new_types.html"><strong aria-hidden="true">14.7.</strong> ニュータイプイディオム</a></li><li class="chapter-item "><a href="generics/assoc_items.html"><strong aria-hidden="true">14.8.</strong> 関連要素</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="generics/assoc_items/the_problem.html"><strong aria-hidden="true">14.8.1.</strong> 関連要素が必要になる状況</a></li><li class="chapter-item "><a href="generics/assoc_items/types.html"><strong aria-hidden="true">14.8.2.</strong> 関連型</a></li></ol></li><li class="chapter-item "><a href="generics/phantom.html"><strong aria-hidden="true">14.9.</strong> 幽霊型パラメータ</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="generics/phantom/testcase_units.html"><strong aria-hidden="true">14.9.1.</strong> テストケース：単位を扱う</a></li></ol></li></ol></li><li class="chapter-item "><a href="scope.html"><strong aria-hidden="true">15.</strong> スコープの規則</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="scope/raii.html"><strong aria-hidden="true">15.1.</strong> RAII</a></li><li class="chapter-item "><a href="scope/move.html"><strong aria-hidden="true">15.2.</strong> 所有権とムーブ</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="scope/move/mut.html"><strong aria-hidden="true">15.2.1.</strong> ミュータビリティ</a></li><li class="chapter-item "><a href="scope/move/partial_move.html"><strong aria-hidden="true">15.2.2.</strong> 部分的ムーブ</a></li></ol></li><li class="chapter-item "><a href="scope/borrow.html"><strong aria-hidden="true">15.3.</strong> 借用</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="scope/borrow/mut.html"><strong aria-hidden="true">15.3.1.</strong> ミュータビリティ</a></li><li class="chapter-item "><a href="scope/borrow/alias.html"><strong aria-hidden="true">15.3.2.</strong> エイリアス</a></li><li class="chapter-item "><a href="scope/borrow/ref.html"><strong aria-hidden="true">15.3.3.</strong> refパターン</a></li></ol></li><li class="chapter-item "><a href="scope/lifetime.html"><strong aria-hidden="true">15.4.</strong> ライフタイム</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="scope/lifetime/explicit.html"><strong aria-hidden="true">15.4.1.</strong> 明示的アノテーション</a></li><li class="chapter-item "><a href="scope/lifetime/fn.html"><strong aria-hidden="true">15.4.2.</strong> 関数</a></li><li class="chapter-item "><a href="scope/lifetime/methods.html"><strong aria-hidden="true">15.4.3.</strong> メソッド</a></li><li class="chapter-item "><a href="scope/lifetime/struct.html"><strong aria-hidden="true">15.4.4.</strong> 構造体</a></li><li class="chapter-item "><a href="scope/lifetime/trait.html"><strong aria-hidden="true">15.4.5.</strong> トレイト</a></li><li class="chapter-item "><a href="scope/lifetime/lifetime_bounds.html"><strong aria-hidden="true">15.4.6.</strong> 境界</a></li><li class="chapter-item "><a href="scope/lifetime/lifetime_coercion.html"><strong aria-hidden="true">15.4.7.</strong> 強制</a></li><li class="chapter-item "><a href="scope/lifetime/static_lifetime.html"><strong aria-hidden="true">15.4.8.</strong> スタティックライフタイム</a></li><li class="chapter-item "><a href="scope/lifetime/elision.html"><strong aria-hidden="true">15.4.9.</strong> 省略</a></li></ol></li></ol></li><li class="chapter-item "><a href="trait.html"><strong aria-hidden="true">16.</strong> トレイト</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="trait/derive.html"><strong aria-hidden="true">16.1.</strong> 導出(Derive)</a></li><li class="chapter-item "><a href="trait/dyn.html"><strong aria-hidden="true">16.2.</strong> dynを利用してトレイトを返す</a></li><li class="chapter-item "><a href="trait/ops.html"><strong aria-hidden="true">16.3.</strong> 演算子のオーバーロード</a></li><li class="chapter-item "><a href="trait/drop.html"><strong aria-hidden="true">16.4.</strong> ドロップ</a></li><li class="chapter-item "><a href="trait/iter.html"><strong aria-hidden="true">16.5.</strong> イテレータ</a></li><li class="chapter-item "><a href="trait/impl_trait.html"><strong aria-hidden="true">16.6.</strong> impl Trait</a></li><li class="chapter-item "><a href="trait/clone.html"><strong aria-hidden="true">16.7.</strong> クローン</a></li><li class="chapter-item "><a href="trait/supertraits.html"><strong aria-hidden="true">16.8.</strong> スーパートレイト</a></li><li class="chapter-item "><a href="trait/disambiguating.html"><strong aria-hidden="true">16.9.</strong> トレイトの曖昧性解決</a></li></ol></li><li class="chapter-item "><a href="macros.html"><strong aria-hidden="true">17.</strong> macro_rules!</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="macros/syntax.html"><strong aria-hidden="true">17.1.</strong> 構文</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="macros/designators.html"><strong aria-hidden="true">17.1.1.</strong> 識別子</a></li><li class="chapter-item "><a href="macros/overload.html"><strong aria-hidden="true">17.1.2.</strong> オーバーロード</a></li><li class="chapter-item "><a href="macros/repeat.html"><strong aria-hidden="true">17.1.3.</strong> 繰り返し</a></li></ol></li><li class="chapter-item "><a href="macros/dry.html"><strong aria-hidden="true">17.2.</strong> DRY (Don&#39;t Repeat Yourself)</a></li><li class="chapter-item "><a href="macros/dsl.html"><strong aria-hidden="true">17.3.</strong> Domain Specific Languages (ドメイン特化言語、DSLs)</a></li><li class="chapter-item "><a href="macros/variadics.html"><strong aria-hidden="true">17.4.</strong> 可変個引数</a></li></ol></li><li class="chapter-item "><a href="error.html"><strong aria-hidden="true">18.</strong> エラーハンドリング</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="error/panic.html"><strong aria-hidden="true">18.1.</strong> panic</a></li><li class="chapter-item "><a href="error/abort_unwind.html"><strong aria-hidden="true">18.2.</strong> abortとunwind</a></li><li class="chapter-item "><a href="error/option_unwrap.html"><strong aria-hidden="true">18.3.</strong> Optionとunwrap</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="error/option_unwrap/question_mark.html"><strong aria-hidden="true">18.3.1.</strong> ?によるOptionのアンパック</a></li><li class="chapter-item "><a href="error/option_unwrap/map.html"><strong aria-hidden="true">18.3.2.</strong> コンビネータ：map</a></li><li class="chapter-item "><a href="error/option_unwrap/and_then.html"><strong aria-hidden="true">18.3.3.</strong> コンビネータ：and_then</a></li><li class="chapter-item "><a href="error/option_unwrap/defaults.html"><strong aria-hidden="true">18.3.4.</strong> Defaults: or, or_else, get_or_insert, get_or_insert_with</a></li></ol></li><li class="chapter-item "><a href="error/result.html"><strong aria-hidden="true">18.4.</strong> Result</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="error/result/result_map.html"><strong aria-hidden="true">18.4.1.</strong> Resultのmap</a></li><li class="chapter-item "><a href="error/result/result_alias.html"><strong aria-hidden="true">18.4.2.</strong> Resultに対するエイリアス</a></li><li class="chapter-item "><a href="error/result/early_returns.html"><strong aria-hidden="true">18.4.3.</strong> 早期リターン</a></li><li class="chapter-item "><a href="error/result/enter_question_mark.html"><strong aria-hidden="true">18.4.4.</strong> ?の導入</a></li></ol></li><li class="chapter-item "><a href="error/multiple_error_types.html"><strong aria-hidden="true">18.5.</strong> 複数のエラー型</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="error/multiple_error_types/option_result.html"><strong aria-hidden="true">18.5.1.</strong> OptionからResultを取り出す</a></li><li class="chapter-item "><a href="error/multiple_error_types/define_error_type.html"><strong aria-hidden="true">18.5.2.</strong> エラー型を定義する</a></li><li class="chapter-item "><a href="error/multiple_error_types/boxing_errors.html"><strong aria-hidden="true">18.5.3.</strong> エラーをBoxする</a></li><li class="chapter-item "><a href="error/multiple_error_types/reenter_question_mark.html"><strong aria-hidden="true">18.5.4.</strong> ?の他の活用法</a></li><li class="chapter-item "><a href="error/multiple_error_types/wrap_error.html"><strong aria-hidden="true">18.5.5.</strong> エラーをラップする</a></li></ol></li><li class="chapter-item "><a href="error/iter_result.html"><strong aria-hidden="true">18.6.</strong> Resultをイテレートする</a></li></ol></li><li class="chapter-item "><a href="std.html"><strong aria-hidden="true">19.</strong> 標準ライブラリの型</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="std/box.html"><strong aria-hidden="true">19.1.</strong> Box、スタックとヒープ</a></li><li class="chapter-item "><a href="std/vec.html"><strong aria-hidden="true">19.2.</strong> ベクタ型</a></li><li class="chapter-item "><a href="std/str.html"><strong aria-hidden="true">19.3.</strong> 文字列</a></li><li class="chapter-item "><a href="std/option.html"><strong aria-hidden="true">19.4.</strong> Option</a></li><li class="chapter-item "><a href="std/result.html"><strong aria-hidden="true">19.5.</strong> Result</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="std/result/question_mark.html"><strong aria-hidden="true">19.5.1.</strong> ?</a></li></ol></li><li class="chapter-item "><a href="std/panic.html"><strong aria-hidden="true">19.6.</strong> panic!</a></li><li class="chapter-item "><a href="std/hash.html"><strong aria-hidden="true">19.7.</strong> ハッシュマップ</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="std/hash/alt_key_types.html"><strong aria-hidden="true">19.7.1.</strong> キー型の変種</a></li><li class="chapter-item "><a href="std/hash/hashset.html"><strong aria-hidden="true">19.7.2.</strong> ハッシュ集合</a></li></ol></li><li class="chapter-item "><a href="std/rc.html"><strong aria-hidden="true">19.8.</strong> Rc</a></li><li class="chapter-item "><a href="std/arc.html"><strong aria-hidden="true">19.9.</strong> Arc</a></li></ol></li><li class="chapter-item "><a href="std_misc.html"><strong aria-hidden="true">20.</strong> 標準ライブラリのその他</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="std_misc/threads.html"><strong aria-hidden="true">20.1.</strong> スレッド</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="std_misc/threads/testcase_mapreduce.html"><strong aria-hidden="true">20.1.1.</strong> テストケース：map-reduce</a></li></ol></li><li class="chapter-item "><a href="std_misc/channels.html"><strong aria-hidden="true">20.2.</strong> チャネル</a></li><li class="chapter-item "><a href="std_misc/path.html"><strong aria-hidden="true">20.3.</strong> ファイルパス</a></li><li class="chapter-item "><a href="std_misc/file.html"><strong aria-hidden="true">20.4.</strong> ファイル I/O</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="std_misc/file/open.html"><strong aria-hidden="true">20.4.1.</strong> open</a></li><li class="chapter-item "><a href="std_misc/file/create.html"><strong aria-hidden="true">20.4.2.</strong> create</a></li><li class="chapter-item "><a href="std_misc/file/read_lines.html"><strong aria-hidden="true">20.4.3.</strong> read lines</a></li></ol></li><li class="chapter-item "><a href="std_misc/process.html"><strong aria-hidden="true">20.5.</strong> 子プロセス</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="std_misc/process/pipe.html"><strong aria-hidden="true">20.5.1.</strong> パイプ</a></li><li class="chapter-item "><a href="std_misc/process/wait.html"><strong aria-hidden="true">20.5.2.</strong> ドロップの延期</a></li></ol></li><li class="chapter-item "><a href="std_misc/fs.html"><strong aria-hidden="true">20.6.</strong> ファイルシステムとのやり取り</a></li><li class="chapter-item "><a href="std_misc/arg.html"><strong aria-hidden="true">20.7.</strong> 引数処理</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="std_misc/arg/matching.html"><strong aria-hidden="true">20.7.1.</strong> 引数のパース</a></li></ol></li><li class="chapter-item "><a href="std_misc/ffi.html"><strong aria-hidden="true">20.8.</strong> 他言語関数インターフェイス</a></li></ol></li><li class="chapter-item "><a href="testing.html"><strong aria-hidden="true">21.</strong> テスト</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="testing/unit_testing.html"><strong aria-hidden="true">21.1.</strong> ユニットテスト</a></li><li class="chapter-item "><a href="testing/doc_testing.html"><strong aria-hidden="true">21.2.</strong> ドキュメンテーションテスト</a></li><li class="chapter-item "><a href="testing/integration_testing.html"><strong aria-hidden="true">21.3.</strong> 統合テスト</a></li><li class="chapter-item "><a href="testing/dev_dependencies.html"><strong aria-hidden="true">21.4.</strong> 開発中の依存関係</a></li></ol></li><li class="chapter-item "><a href="unsafe.html"><strong aria-hidden="true">22.</strong> 安全でない操作</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="unsafe/asm.html"><strong aria-hidden="true">22.1.</strong> インラインアセンブリ</a></li></ol></li><li class="chapter-item "><a href="compatibility.html"><strong aria-hidden="true">23.</strong> 互換性</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="compatibility/raw_identifiers.html"><strong aria-hidden="true">23.1.</strong> 生識別子</a></li></ol></li><li class="chapter-item "><a href="meta.html"><strong aria-hidden="true">24.</strong> 周辺情報</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="meta/doc.html"><strong aria-hidden="true">24.1.</strong> ドキュメンテーション</a></li><li class="chapter-item "><a href="meta/playground.html"><strong aria-hidden="true">24.2.</strong> プレイグラウンド</a></li></ol></li></ol>';
        // Set the current, active page, and reveal it if it's hidden
        let current_page = document.location.href.toString().split("#")[0];
        if (current_page.endsWith("/")) {
            current_page += "index.html";
        }
        var links = Array.prototype.slice.call(this.querySelectorAll("a"));
        var l = links.length;
        for (var i = 0; i < l; ++i) {
            var link = links[i];
            var href = link.getAttribute("href");
            if (href && !href.startsWith("#") && !/^(?:[a-z+]+:)?\/\//.test(href)) {
                link.href = path_to_root + href;
            }
            // The "index" page is supposed to alias the first chapter in the book.
            if (link.href === current_page || (i === 0 && path_to_root === "" && current_page.endsWith("/index.html"))) {
                link.classList.add("active");
                var parent = link.parentElement;
                if (parent && parent.classList.contains("chapter-item")) {
                    parent.classList.add("expanded");
                }
                while (parent) {
                    if (parent.tagName === "LI" && parent.previousElementSibling) {
                        if (parent.previousElementSibling.classList.contains("chapter-item")) {
                            parent.previousElementSibling.classList.add("expanded");
                        }
                    }
                    parent = parent.parentElement;
                }
            }
        }
        // Track and set sidebar scroll position
        this.addEventListener('click', function(e) {
            if (e.target.tagName === 'A') {
                sessionStorage.setItem('sidebar-scroll', this.scrollTop);
            }
        }, { passive: true });
        var sidebarScrollTop = sessionStorage.getItem('sidebar-scroll');
        sessionStorage.removeItem('sidebar-scroll');
        if (sidebarScrollTop) {
            // preserve sidebar scroll position when navigating via links within sidebar
            this.scrollTop = sidebarScrollTop;
        } else {
            // scroll sidebar to current active section when navigating via "next/previous chapter" buttons
            var activeSection = document.querySelector('#sidebar .active');
            if (activeSection) {
                activeSection.scrollIntoView({ block: 'center' });
            }
        }
        // Toggle buttons
        var sidebarAnchorToggles = document.querySelectorAll('#sidebar a.toggle');
        function toggleSection(ev) {
            ev.currentTarget.parentElement.classList.toggle('expanded');
        }
        Array.from(sidebarAnchorToggles).forEach(function (el) {
            el.addEventListener('click', toggleSection);
        });
    }
}
window.customElements.define("mdbook-sidebar-scrollbox", MDBookSidebarScrollbox);
