// generated by diplomat-tool
import type { CodePointSetData } from "./CodePointSetData"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * See the [Rust documentation for `CodePointInversionListBuilder`](https://docs.rs/icu/latest/icu/collections/codepointinvlist/struct.CodePointInversionListBuilder.html) for more information.
 */


export class CodePointSetBuilder {
    get ffiValue(): pointer;


    /**
     * Build this into a set
     *
     * This object is repopulated with an empty builder
     *
     * See the [Rust documentation for `build`](https://docs.rs/icu/latest/icu/collections/codepointinvlist/struct.CodePointInversionListBuilder.html#method.build) for more information.
     */
    build(): CodePointSetData;

    /**
     * Complements this set
     *
     * (Elements in this set are removed and vice versa)
     *
     * See the [Rust documentation for `complement`](https://docs.rs/icu/latest/icu/collections/codepointinvlist/struct.CodePointInversionListBuilder.html#method.complement) for more information.
     */
    complement(): void;

    /**
     * Returns whether this set is empty
     *
     * See the [Rust documentation for `is_empty`](https://docs.rs/icu/latest/icu/collections/codepointinvlist/struct.CodePointInversionListBuilder.html#method.is_empty) for more information.
     */
    get isEmpty(): boolean;

    /**
     * Add a single character to the set
     *
     * See the [Rust documentation for `add_char`](https://docs.rs/icu/latest/icu/collections/codepointinvlist/struct.CodePointInversionListBuilder.html#method.add_char) for more information.
     */
    addChar(ch: codepoint): void;

    /**
     * Add an inclusive range of characters to the set
     *
     * See the [Rust documentation for `add_range`](https://docs.rs/icu/latest/icu/collections/codepointinvlist/struct.CodePointInversionListBuilder.html#method.add_range) for more information.
     */
    addInclusiveRange(start: codepoint, end: codepoint): void;

    /**
     * Add all elements that belong to the provided set to the set
     *
     * See the [Rust documentation for `add_set`](https://docs.rs/icu/latest/icu/collections/codepointinvlist/struct.CodePointInversionListBuilder.html#method.add_set) for more information.
     */
    addSet(data: CodePointSetData): void;

    /**
     * Remove a single character to the set
     *
     * See the [Rust documentation for `remove_char`](https://docs.rs/icu/latest/icu/collections/codepointinvlist/struct.CodePointInversionListBuilder.html#method.remove_char) for more information.
     */
    removeChar(ch: codepoint): void;

    /**
     * Remove an inclusive range of characters from the set
     *
     * See the [Rust documentation for `remove_range`](https://docs.rs/icu/latest/icu/collections/codepointinvlist/struct.CodePointInversionListBuilder.html#method.remove_range) for more information.
     */
    removeInclusiveRange(start: codepoint, end: codepoint): void;

    /**
     * Remove all elements that belong to the provided set from the set
     *
     * See the [Rust documentation for `remove_set`](https://docs.rs/icu/latest/icu/collections/codepointinvlist/struct.CodePointInversionListBuilder.html#method.remove_set) for more information.
     */
    removeSet(data: CodePointSetData): void;

    /**
     * Removes all elements from the set except a single character
     *
     * See the [Rust documentation for `retain_char`](https://docs.rs/icu/latest/icu/collections/codepointinvlist/struct.CodePointInversionListBuilder.html#method.retain_char) for more information.
     */
    retainChar(ch: codepoint): void;

    /**
     * Removes all elements from the set except an inclusive range of characters f
     *
     * See the [Rust documentation for `retain_range`](https://docs.rs/icu/latest/icu/collections/codepointinvlist/struct.CodePointInversionListBuilder.html#method.retain_range) for more information.
     */
    retainInclusiveRange(start: codepoint, end: codepoint): void;

    /**
     * Removes all elements from the set except all elements in the provided set
     *
     * See the [Rust documentation for `retain_set`](https://docs.rs/icu/latest/icu/collections/codepointinvlist/struct.CodePointInversionListBuilder.html#method.retain_set) for more information.
     */
    retainSet(data: CodePointSetData): void;

    /**
     * Complement a single character to the set
     *
     * (Characters which are in this set are removed and vice versa)
     *
     * See the [Rust documentation for `complement_char`](https://docs.rs/icu/latest/icu/collections/codepointinvlist/struct.CodePointInversionListBuilder.html#method.complement_char) for more information.
     */
    complementChar(ch: codepoint): void;

    /**
     * Complement an inclusive range of characters from the set
     *
     * (Characters which are in this set are removed and vice versa)
     *
     * See the [Rust documentation for `complement_range`](https://docs.rs/icu/latest/icu/collections/codepointinvlist/struct.CodePointInversionListBuilder.html#method.complement_range) for more information.
     */
    complementInclusiveRange(start: codepoint, end: codepoint): void;

    /**
     * Complement all elements that belong to the provided set from the set
     *
     * (Characters which are in this set are removed and vice versa)
     *
     * See the [Rust documentation for `complement_set`](https://docs.rs/icu/latest/icu/collections/codepointinvlist/struct.CodePointInversionListBuilder.html#method.complement_set) for more information.
     */
    complementSet(data: CodePointSetData): void;

    constructor();
}