// Code generated by mockery; DO NOT EDIT.
// github.com/vektra/mockery
// template: testify

/*
** Copyright (C) 2001-2025 Zabbix SIA
**
** This program is free software: you can redistribute it and/or modify it under the terms of
** the GNU Affero General Public License as published by the Free Software Foundation, version 3.
**
** This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
** without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** See the GNU Affero General Public License for more details.
**
** You should have received a copy of the GNU Affero General Public License along with this program.
** If not, see <https://www.gnu.org/licenses/>.
**/

package mockscheduler

import (
	"time"

	mock "github.com/stretchr/testify/mock"
	"golang.zabbix.com/agent2/internal/agent"
	"golang.zabbix.com/agent2/internal/agent/resultcache"
	"golang.zabbix.com/agent2/internal/agent/scheduler"
	"golang.zabbix.com/agent2/pkg/glexpr"
)

// NewScheduler creates a new instance of Scheduler. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewScheduler(t interface {
	mock.TestingT
	Cleanup(func())
}) *Scheduler {
	mock := &Scheduler{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// Scheduler is an autogenerated mock type for the Scheduler type
type Scheduler struct {
	mock.Mock
}

type Scheduler_Expecter struct {
	mock *mock.Mock
}

func (_m *Scheduler) EXPECT() *Scheduler_Expecter {
	return &Scheduler_Expecter{mock: &_m.Mock}
}

// FinishTask provides a mock function for the type Scheduler
func (_mock *Scheduler) FinishTask(task scheduler.Performer) {
	_mock.Called(task)
	return
}

// Scheduler_FinishTask_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'FinishTask'
type Scheduler_FinishTask_Call struct {
	*mock.Call
}

// FinishTask is a helper method to define mock.On call
//   - task
func (_e *Scheduler_Expecter) FinishTask(task interface{}) *Scheduler_FinishTask_Call {
	return &Scheduler_FinishTask_Call{Call: _e.mock.On("FinishTask", task)}
}

func (_c *Scheduler_FinishTask_Call) Run(run func(task scheduler.Performer)) *Scheduler_FinishTask_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(scheduler.Performer))
	})
	return _c
}

func (_c *Scheduler_FinishTask_Call) Return() *Scheduler_FinishTask_Call {
	_c.Call.Return()
	return _c
}

func (_c *Scheduler_FinishTask_Call) RunAndReturn(run func(task scheduler.Performer)) *Scheduler_FinishTask_Call {
	_c.Run(run)
	return _c
}

// PerformTask provides a mock function for the type Scheduler
func (_mock *Scheduler) PerformTask(key string, timeout time.Duration, clientID uint64) (*string, error) {
	ret := _mock.Called(key, timeout, clientID)

	if len(ret) == 0 {
		panic("no return value specified for PerformTask")
	}

	var r0 *string
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(string, time.Duration, uint64) (*string, error)); ok {
		return returnFunc(key, timeout, clientID)
	}
	if returnFunc, ok := ret.Get(0).(func(string, time.Duration, uint64) *string); ok {
		r0 = returnFunc(key, timeout, clientID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*string)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(string, time.Duration, uint64) error); ok {
		r1 = returnFunc(key, timeout, clientID)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// Scheduler_PerformTask_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'PerformTask'
type Scheduler_PerformTask_Call struct {
	*mock.Call
}

// PerformTask is a helper method to define mock.On call
//   - key
//   - timeout
//   - clientID
func (_e *Scheduler_Expecter) PerformTask(key interface{}, timeout interface{}, clientID interface{}) *Scheduler_PerformTask_Call {
	return &Scheduler_PerformTask_Call{Call: _e.mock.On("PerformTask", key, timeout, clientID)}
}

func (_c *Scheduler_PerformTask_Call) Run(run func(key string, timeout time.Duration, clientID uint64)) *Scheduler_PerformTask_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string), args[1].(time.Duration), args[2].(uint64))
	})
	return _c
}

func (_c *Scheduler_PerformTask_Call) Return(result *string, err error) *Scheduler_PerformTask_Call {
	_c.Call.Return(result, err)
	return _c
}

func (_c *Scheduler_PerformTask_Call) RunAndReturn(run func(key string, timeout time.Duration, clientID uint64) (*string, error)) *Scheduler_PerformTask_Call {
	_c.Call.Return(run)
	return _c
}

// Query provides a mock function for the type Scheduler
func (_mock *Scheduler) Query(command string) string {
	ret := _mock.Called(command)

	if len(ret) == 0 {
		panic("no return value specified for Query")
	}

	var r0 string
	if returnFunc, ok := ret.Get(0).(func(string) string); ok {
		r0 = returnFunc(command)
	} else {
		r0 = ret.Get(0).(string)
	}
	return r0
}

// Scheduler_Query_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Query'
type Scheduler_Query_Call struct {
	*mock.Call
}

// Query is a helper method to define mock.On call
//   - command
func (_e *Scheduler_Expecter) Query(command interface{}) *Scheduler_Query_Call {
	return &Scheduler_Query_Call{Call: _e.mock.On("Query", command)}
}

func (_c *Scheduler_Query_Call) Run(run func(command string)) *Scheduler_Query_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string))
	})
	return _c
}

func (_c *Scheduler_Query_Call) Return(status string) *Scheduler_Query_Call {
	_c.Call.Return(status)
	return _c
}

func (_c *Scheduler_Query_Call) RunAndReturn(run func(command string) string) *Scheduler_Query_Call {
	_c.Call.Return(run)
	return _c
}

// QueryUserParams provides a mock function for the type Scheduler
func (_mock *Scheduler) QueryUserParams() string {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for QueryUserParams")
	}

	var r0 string
	if returnFunc, ok := ret.Get(0).(func() string); ok {
		r0 = returnFunc()
	} else {
		r0 = ret.Get(0).(string)
	}
	return r0
}

// Scheduler_QueryUserParams_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'QueryUserParams'
type Scheduler_QueryUserParams_Call struct {
	*mock.Call
}

// QueryUserParams is a helper method to define mock.On call
func (_e *Scheduler_Expecter) QueryUserParams() *Scheduler_QueryUserParams_Call {
	return &Scheduler_QueryUserParams_Call{Call: _e.mock.On("QueryUserParams")}
}

func (_c *Scheduler_QueryUserParams_Call) Run(run func()) *Scheduler_QueryUserParams_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *Scheduler_QueryUserParams_Call) Return(status string) *Scheduler_QueryUserParams_Call {
	_c.Call.Return(status)
	return _c
}

func (_c *Scheduler_QueryUserParams_Call) RunAndReturn(run func() string) *Scheduler_QueryUserParams_Call {
	_c.Call.Return(run)
	return _c
}

// UpdateCommands provides a mock function for the type Scheduler
func (_mock *Scheduler) UpdateCommands(clientID uint64, writer resultcache.Writer, commands []*agent.RemoteCommand, now time.Time) {
	_mock.Called(clientID, writer, commands, now)
	return
}

// Scheduler_UpdateCommands_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdateCommands'
type Scheduler_UpdateCommands_Call struct {
	*mock.Call
}

// UpdateCommands is a helper method to define mock.On call
//   - clientID
//   - writer
//   - commands
//   - now
func (_e *Scheduler_Expecter) UpdateCommands(clientID interface{}, writer interface{}, commands interface{}, now interface{}) *Scheduler_UpdateCommands_Call {
	return &Scheduler_UpdateCommands_Call{Call: _e.mock.On("UpdateCommands", clientID, writer, commands, now)}
}

func (_c *Scheduler_UpdateCommands_Call) Run(run func(clientID uint64, writer resultcache.Writer, commands []*agent.RemoteCommand, now time.Time)) *Scheduler_UpdateCommands_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(uint64), args[1].(resultcache.Writer), args[2].([]*agent.RemoteCommand), args[3].(time.Time))
	})
	return _c
}

func (_c *Scheduler_UpdateCommands_Call) Return() *Scheduler_UpdateCommands_Call {
	_c.Call.Return()
	return _c
}

func (_c *Scheduler_UpdateCommands_Call) RunAndReturn(run func(clientID uint64, writer resultcache.Writer, commands []*agent.RemoteCommand, now time.Time)) *Scheduler_UpdateCommands_Call {
	_c.Run(run)
	return _c
}

// UpdateTasks provides a mock function for the type Scheduler
func (_mock *Scheduler) UpdateTasks(clientID uint64, writer resultcache.Writer, firstActiveChecksRefreshed bool, expressions []*glexpr.Expression, requests []*scheduler.Request, now time.Time) {
	_mock.Called(clientID, writer, firstActiveChecksRefreshed, expressions, requests, now)
	return
}

// Scheduler_UpdateTasks_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdateTasks'
type Scheduler_UpdateTasks_Call struct {
	*mock.Call
}

// UpdateTasks is a helper method to define mock.On call
//   - clientID
//   - writer
//   - firstActiveChecksRefreshed
//   - expressions
//   - requests
//   - now
func (_e *Scheduler_Expecter) UpdateTasks(clientID interface{}, writer interface{}, firstActiveChecksRefreshed interface{}, expressions interface{}, requests interface{}, now interface{}) *Scheduler_UpdateTasks_Call {
	return &Scheduler_UpdateTasks_Call{Call: _e.mock.On("UpdateTasks", clientID, writer, firstActiveChecksRefreshed, expressions, requests, now)}
}

func (_c *Scheduler_UpdateTasks_Call) Run(run func(clientID uint64, writer resultcache.Writer, firstActiveChecksRefreshed bool, expressions []*glexpr.Expression, requests []*scheduler.Request, now time.Time)) *Scheduler_UpdateTasks_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(uint64), args[1].(resultcache.Writer), args[2].(bool), args[3].([]*glexpr.Expression), args[4].([]*scheduler.Request), args[5].(time.Time))
	})
	return _c
}

func (_c *Scheduler_UpdateTasks_Call) Return() *Scheduler_UpdateTasks_Call {
	_c.Call.Return()
	return _c
}

func (_c *Scheduler_UpdateTasks_Call) RunAndReturn(run func(clientID uint64, writer resultcache.Writer, firstActiveChecksRefreshed bool, expressions []*glexpr.Expression, requests []*scheduler.Request, now time.Time)) *Scheduler_UpdateTasks_Call {
	_c.Run(run)
	return _c
}
