/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.RunnableLock;

public class Synchronizer {
    Display display;
    final ConcurrentLinkedQueue<RunnableLock> messages = new ConcurrentLinkedQueue();
    Thread syncThread;
    static final int GROW_SIZE = 4;
    static final int MESSAGE_LIMIT = 64;
    static final boolean IS_COCOA = "cocoa".equals(SWT.getPlatform());
    static final boolean IS_GTK = "gtk".equals(SWT.getPlatform());

    public Synchronizer(Display display) {
        this.display = display;
    }

    void moveAllEventsTo(Synchronizer toReceiveTheEvents) {
        ArrayList tail = new ArrayList();
        toReceiveTheEvents.messages.removeIf(tail::add);
        this.messages.removeIf(toReceiveTheEvents.messages::add);
        toReceiveTheEvents.messages.addAll(tail);
    }

    void addLast(RunnableLock lock) {
        boolean wake = this.messages.isEmpty();
        this.messages.add(lock);
        if (wake) {
            this.display.wakeThread();
        }
    }

    protected void asyncExec(Runnable runnable) {
        if (runnable == null && !IS_GTK && !IS_COCOA) {
            this.display.wake();
            return;
        }
        this.addLast(new RunnableLock(runnable));
    }

    boolean isMessagesEmpty() {
        return this.messages.isEmpty();
    }

    void releaseSynchronizer() {
        this.display = null;
        this.messages.clear();
        this.syncThread = null;
    }

    RunnableLock removeFirst() {
        return this.messages.poll();
    }

    boolean runAsyncMessages() {
        return this.runAsyncMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean runAsyncMessages(boolean all) {
        boolean run = false;
        do {
            RunnableLock lock;
            if ((lock = this.removeFirst()) == null) {
                return run;
            }
            run = true;
            RunnableLock runnableLock = lock;
            synchronized (runnableLock) {
                block13: {
                    this.syncThread = lock.thread;
                    this.display.sendPreEvent(0);
                    try {
                        try {
                            lock.run(this.display);
                        }
                        catch (Throwable t) {
                            lock.throwable = t;
                            SWT.error(46, t);
                            if (this.display != null && !this.display.isDisposed()) {
                                this.display.sendPostEvent(0);
                            }
                            this.syncThread = null;
                            lock.notifyAll();
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        if (this.display != null && !this.display.isDisposed()) {
                            this.display.sendPostEvent(0);
                        }
                        this.syncThread = null;
                        lock.notifyAll();
                        throw throwable;
                    }
                    if (this.display != null && !this.display.isDisposed()) {
                        this.display.sendPostEvent(0);
                    }
                    this.syncThread = null;
                    lock.notifyAll();
                }
            }
        } while (all);
        return run;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncExec(Runnable runnable) {
        RunnableLock lock = null;
        Object object = Device.class;
        synchronized (Device.class) {
            if (this.display == null || this.display.isDisposed()) {
                SWT.error(45);
            }
            if (!this.display.isValidThread()) {
                if (runnable == null) {
                    this.display.wake();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                lock = new RunnableLock(runnable);
                lock.thread = Thread.currentThread();
                this.addLast(lock);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (lock == null) {
                if (runnable != null) {
                    this.display.sendPreEvent(0);
                    try {
                        try {
                            runnable.run();
                        }
                        catch (RuntimeException exception) {
                            this.display.getRuntimeExceptionHandler().accept(exception);
                            if (this.display != null && !this.display.isDisposed()) {
                                this.display.sendPostEvent(0);
                            }
                        }
                        catch (Error error) {
                            this.display.getErrorHandler().accept(error);
                            if (this.display != null && !this.display.isDisposed()) {
                                this.display.sendPostEvent(0);
                            }
                        }
                    }
                    finally {
                        if (this.display != null && !this.display.isDisposed()) {
                            this.display.sendPostEvent(0);
                        }
                    }
                }
                return;
            }
            object = lock;
            synchronized (object) {
                boolean interrupted = false;
                while (!lock.done()) {
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                if (lock.throwable != null) {
                    SWT.error(46, lock.throwable);
                }
            }
            return;
        }
    }
}

