"use strict";
// Copyright 2021-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.createJsDocBlock = exports.makeJsDoc = exports.findCustomEnumOption = exports.findCustomMessageOption = exports.findCustomScalarOption = exports.literalString = exports.getFieldTyping = exports.getFieldIntrinsicDefaultValue = exports.getFieldExplicitDefaultValue = exports.localName = exports.createImportSymbol = exports.reifyWkt = void 0;
const protobuf_1 = require("@bufbuild/protobuf");
const jsdoc_js_1 = require("./jsdoc.js");
var reify_wkt_js_1 = require("./reify-wkt.js");
Object.defineProperty(exports, "reifyWkt", { enumerable: true, get: function () { return reify_wkt_js_1.reifyWkt; } });
var import_symbol_js_1 = require("./import-symbol.js");
Object.defineProperty(exports, "createImportSymbol", { enumerable: true, get: function () { return import_symbol_js_1.createImportSymbol; } });
exports.localName = protobuf_1.codegenInfo.localName;
var legacy_gencommon_js_1 = require("./legacy-gencommon.js");
Object.defineProperty(exports, "getFieldExplicitDefaultValue", { enumerable: true, get: function () { return legacy_gencommon_js_1.getFieldExplicitDefaultValue; } });
Object.defineProperty(exports, "getFieldIntrinsicDefaultValue", { enumerable: true, get: function () { return legacy_gencommon_js_1.getFieldIntrinsicDefaultValue; } });
Object.defineProperty(exports, "getFieldTyping", { enumerable: true, get: function () { return legacy_gencommon_js_1.getFieldTyping; } });
Object.defineProperty(exports, "literalString", { enumerable: true, get: function () { return legacy_gencommon_js_1.literalString; } });
var legacy_custom_options_js_1 = require("./legacy-custom-options.js");
Object.defineProperty(exports, "findCustomScalarOption", { enumerable: true, get: function () { return legacy_custom_options_js_1.findCustomScalarOption; } });
Object.defineProperty(exports, "findCustomMessageOption", { enumerable: true, get: function () { return legacy_custom_options_js_1.findCustomMessageOption; } });
Object.defineProperty(exports, "findCustomEnumOption", { enumerable: true, get: function () { return legacy_custom_options_js_1.findCustomEnumOption; } });
/**
 * @deprecated Please use GeneratedFile.jsDoc() instead
 */
function makeJsDoc(desc, indentation = "") {
    return (0, jsdoc_js_1.createJsDocBlock)(desc, indentation).toString();
}
exports.makeJsDoc = makeJsDoc;
/**
 * @deprecated Please use GeneratedFile.jsDoc() instead
 */
function createJsDocBlock(text, indentation = "") {
    return (0, jsdoc_js_1.createJsDocBlock)(text, indentation).toString();
}
exports.createJsDocBlock = createJsDocBlock;
