# <img width="22px" src="https://github.com/martinrotter/rssguard/blob/master/resources/graphics/rssguard.png?raw=true" /> RSS Guard

[![Total downloads](https://img.shields.io/github/downloads/martinrotter/rssguard/total.svg?maxAge=360)](https://somsubhra.github.io/github-release-stats/?username=martinrotter&repository=rssguard&search=0)
[![Version](https://img.shields.io/github/release/martinrotter/rssguard.svg?maxAge=360)](https://raw.githubusercontent.com/martinrotter/rssguard/master/resources/text/CHANGELOG)
[![Packaging status](https://repology.org/badge/tiny-repos/rssguard.svg)](https://repology.org/project/rssguard/versions)
[![Documentation status](https://readthedocs.org/projects/rssguard/badge/?version=latest)](https://rssguard.readthedocs.io)
[![GitHub issues](https://img.shields.io/github/issues/martinrotter/rssguard.svg?maxAge=360)](https://github.com/martinrotter/rssguard/issues)
[![License](https://img.shields.io/github/license/martinrotter/rssguard.svg?maxAge=360000)](https://github.com/martinrotter/rssguard/blob/master/LICENSE.md)

### [Discord server](https://discord.gg/7xbVMPPNqH) | [Downloads](https://github.com/martinrotter/rssguard/releases) | [Development builds](https://github.com/martinrotter/rssguard/releases/tag/devbuild5) | [Documentation](https://rssguard.readthedocs.io) | [Translations](https://rssguard.readthedocs.io/en/stable/contrib/localization.html)

**RSS Guard** is a fast, lightweight, and customizable feed reader designed for modern users.  
It runs on **Windows**, **Linux**, **BSD**, **OS/2**, and **macOS**, and supports a wide range of feed formats including **RSS**, **ATOM**, **JSON**, **iCalendar**, and **Sitemap**.

Beyond standard feeds, RSS Guard integrates seamlessly with many popular **online feed services**, such as:

* [Feedly](https://feedly.com)
* [Gmail](https://developers.google.com/gmail/api)
* Google Reader API services — [Bazqux](https://bazqux.com), [FreshRSS](https://freshrss.org), [Inoreader](https://www.inoreader.com), [Miniflux](https://miniflux.app), [Reedah](http://reedah.com), [The Old Reader](https://theoldreader.com), and others
* [Nextcloud News](https://apps.nextcloud.com/apps/news)
* [Tiny Tiny RSS](https://tt-rss.org)

---

### 🎧 Podcasts and Media Playback

RSS Guard is also a capable **podcast player**.
It can play both audio and video directly using its built-in **mpv**-based (or alternatively **ffmpeg**-based) media player — no external applications required.

---

### 🌐 Gemini Protocol Support

RSS Guard includes native support for the [Gemini](https://geminiprotocol.net) protocol, allowing it to fetch and display feeds securely over Gemini connections.

---

![RSS Guard Screenshot](https://raw.githubusercontent.com/martinrotter/rssguard/d1198081416301868b91cfb1e9159962f758b6c6/resources/graphics/official_pictures/main-window-linux.png)

---

## 🤝 Contributing to RSS Guard

We welcome all contributions — whether it’s fixing a typo, improving translations, or implementing new features.  
To get started, please read the [CONTRIBUTING.md](CONTRIBUTING.md) guide.  
Every contribution helps make RSS Guard better for everyone.

---

## 🙏 Acknowledgments

**Contributed graphics:**  
* Flag icons — [IconDrawer](http://www.icondrawer.com)

---

© 2011–2026 Martin Rotter. RSS Guard is open-source software licensed under the [GNU GPLv3](LICENSE.md).



