/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolUtils;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.ldif.LDIFDeleteChangeRecord;
import com.unboundid.ldif.LDIFMessages;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.PassphraseEncryptedOutputStream;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.FilterArgument;
import com.unboundid.util.args.StringArgument;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPOutputStream;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDIFDiff
extends CommandLineTool {
    @Nullable
    private static final File PING_SERVER_ROOT = InternalSDKHelper.getPingIdentityServerRoot();
    private static final boolean PING_SERVER_AVAILABLE = PING_SERVER_ROOT != null;
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    @NotNull
    private static final String CHANGE_TYPE_ADD = "add";
    @NotNull
    private static final String CHANGE_TYPE_DELETE = "delete";
    @NotNull
    private static final String CHANGE_TYPE_MODIFY = "modify";
    @NotNull
    private final AtomicReference<String> completionMessage;
    @NotNull
    private final List<char[]> encryptionPassphrases = new ArrayList<char[]>(5);
    @Nullable
    private BooleanArgument compressOutput = null;
    @Nullable
    private BooleanArgument encryptOutput = null;
    @Nullable
    private BooleanArgument excludeNoUserModificationAttributes = null;
    @Nullable
    private BooleanArgument includeOperationalAttributes = null;
    @Nullable
    private BooleanArgument nonReversibleModifications = null;
    @Nullable
    private BooleanArgument overwriteExistingOutputLDIF = null;
    @Nullable
    private BooleanArgument singleValueChanges = null;
    @Nullable
    private BooleanArgument stripTrailingSpaces = null;
    @Nullable
    private FileArgument outputEncryptionPassphraseFile = null;
    @Nullable
    private FileArgument outputLDIF = null;
    @Nullable
    private FileArgument schemaPath = null;
    @Nullable
    private FileArgument sourceEncryptionPassphraseFile = null;
    @Nullable
    private FileArgument sourceLDIF = null;
    @Nullable
    private FileArgument targetEncryptionPassphraseFile = null;
    @Nullable
    private FileArgument targetLDIF = null;
    @Nullable
    private FilterArgument excludeFilter = null;
    @Nullable
    private FilterArgument includeFilter = null;
    @Nullable
    private StringArgument changeType = null;
    @Nullable
    private StringArgument excludeAttribute = null;
    @Nullable
    private StringArgument includeAttribute = null;

    public static void main(String ... args) {
        ResultCode resultCode = LDIFDiff.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@Nullable OutputStream out, @Nullable OutputStream err, String ... args) {
        LDIFDiff tool = new LDIFDiff(out, err);
        return tool.runTool(args);
    }

    public LDIFDiff(@Nullable OutputStream out, @Nullable OutputStream err) {
        super(out, err);
        this.completionMessage = new AtomicReference();
    }

    @Override
    @NotNull
    public String getToolName() {
        return "ldif-diff";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return LDIFMessages.INFO_LDIF_DIFF_TOOL_DESCRIPTION_1.get();
    }

    @Override
    @NotNull
    public List<String> getAdditionalDescriptionParagraphs() {
        ArrayList<String> messages = new ArrayList<String>(3);
        messages.add(LDIFMessages.INFO_LDIF_DIFF_TOOL_DESCRIPTION_2.get());
        messages.add(LDIFMessages.INFO_LDIF_DIFF_TOOL_DESCRIPTION_3.get());
        if (PING_SERVER_AVAILABLE) {
            messages.add(LDIFMessages.INFO_LDIF_DIFF_TOOL_DESCRIPTION_4_PING_SERVER.get(this.getToolName()));
        } else {
            messages.add(LDIFMessages.INFO_LDIF_DIFF_TOOL_DESCRIPTION_4_STANDALONE.get(this.getToolName()));
        }
        return messages;
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "6.0.8";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    @Nullable
    protected String getToolCompletionMessage() {
        return this.completionMessage.get();
    }

    @Override
    public void addToolArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        this.sourceLDIF = new FileArgument(Character.valueOf('s'), "sourceLDIF", true, 1, null, LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_SOURCE_LDIF.get(), true, true, true, false);
        this.sourceLDIF.addLongIdentifier("source-ldif", true);
        this.sourceLDIF.addLongIdentifier("source", true);
        this.sourceLDIF.addLongIdentifier("sourceFile", true);
        this.sourceLDIF.addLongIdentifier("source-file", true);
        this.sourceLDIF.addLongIdentifier("sourceLDIFFile", true);
        this.sourceLDIF.addLongIdentifier("source-ldif-file", true);
        this.sourceLDIF.setArgumentGroupName(LDIFMessages.INFO_LDIF_DIFF_ARG_GROUP_SOURCE.get());
        parser.addArgument(this.sourceLDIF);
        String sourcePWDesc = PING_SERVER_AVAILABLE ? LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_SOURCE_PW_FILE_PING_SERVER.get() : LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_SOURCE_PW_FILE_STANDALONE.get();
        this.sourceEncryptionPassphraseFile = new FileArgument(null, "sourceEncryptionPassphraseFile", false, 1, null, sourcePWDesc, true, true, true, false);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("source-encryption-passphrase-file", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("sourcePassphraseFile", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("source-passphrase-file", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("sourceEncryptionPasswordFile", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("source-encryption-password-file", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("sourcePasswordFile", true);
        this.sourceEncryptionPassphraseFile.addLongIdentifier("source-password-file", true);
        this.sourceEncryptionPassphraseFile.setArgumentGroupName(LDIFMessages.INFO_LDIF_DIFF_ARG_GROUP_SOURCE.get());
        parser.addArgument(this.sourceEncryptionPassphraseFile);
        this.targetLDIF = new FileArgument(Character.valueOf('t'), "targetLDIF", true, 1, null, LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_TARGET_LDIF.get(), true, true, true, false);
        this.targetLDIF.addLongIdentifier("target-ldif", true);
        this.targetLDIF.addLongIdentifier("target", true);
        this.targetLDIF.addLongIdentifier("targetFile", true);
        this.targetLDIF.addLongIdentifier("target-file", true);
        this.targetLDIF.addLongIdentifier("targetLDIFFile", true);
        this.targetLDIF.addLongIdentifier("target-ldif-file", true);
        this.targetLDIF.setArgumentGroupName(LDIFMessages.INFO_LDIF_DIFF_ARG_GROUP_TARGET.get());
        parser.addArgument(this.targetLDIF);
        String targetPWDesc = PING_SERVER_AVAILABLE ? LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_TARGET_PW_FILE_PING_SERVER.get() : LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_TARGET_PW_FILE_STANDALONE.get();
        this.targetEncryptionPassphraseFile = new FileArgument(null, "targetEncryptionPassphraseFile", false, 1, null, targetPWDesc, true, true, true, false);
        this.targetEncryptionPassphraseFile.addLongIdentifier("target-encryption-passphrase-file", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("targetPassphraseFile", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("target-passphrase-file", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("targetEncryptionPasswordFile", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("target-encryption-password-file", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("targetPasswordFile", true);
        this.targetEncryptionPassphraseFile.addLongIdentifier("target-password-file", true);
        this.targetEncryptionPassphraseFile.setArgumentGroupName(LDIFMessages.INFO_LDIF_DIFF_ARG_GROUP_TARGET.get());
        parser.addArgument(this.targetEncryptionPassphraseFile);
        this.outputLDIF = new FileArgument(Character.valueOf('o'), "outputLDIF", false, 1, null, LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_OUTPUT_LDIF.get(), false, true, true, false);
        this.outputLDIF.addLongIdentifier("output-ldif", true);
        this.outputLDIF.addLongIdentifier("output", true);
        this.outputLDIF.addLongIdentifier("outputFile", true);
        this.outputLDIF.addLongIdentifier("output-file", true);
        this.outputLDIF.addLongIdentifier("outputLDIFFile", true);
        this.outputLDIF.addLongIdentifier("output-ldif-file", true);
        this.outputLDIF.setArgumentGroupName(LDIFMessages.INFO_LDIF_DIFF_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.outputLDIF);
        this.compressOutput = new BooleanArgument(null, "compressOutput", 1, LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_COMPRESS_OUTPUT.get());
        this.compressOutput.addLongIdentifier("compress-output", true);
        this.compressOutput.addLongIdentifier("compress", true);
        this.compressOutput.setArgumentGroupName(LDIFMessages.INFO_LDIF_DIFF_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.compressOutput);
        this.encryptOutput = new BooleanArgument(null, "encryptOutput", 1, LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_ENCRYPT_OUTPUT.get());
        this.encryptOutput.addLongIdentifier("encrypt-output", true);
        this.encryptOutput.addLongIdentifier("encrypt", true);
        this.encryptOutput.setArgumentGroupName(LDIFMessages.INFO_LDIF_DIFF_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.encryptOutput);
        this.outputEncryptionPassphraseFile = new FileArgument(null, "outputEncryptionPassphraseFile", false, 1, null, LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_OUTPUT_PW_FILE.get(), true, true, true, false);
        this.outputEncryptionPassphraseFile.addLongIdentifier("output-encryption-passphrase-file", true);
        this.outputEncryptionPassphraseFile.addLongIdentifier("outputPassphraseFile", true);
        this.outputEncryptionPassphraseFile.addLongIdentifier("output-passphrase-file", true);
        this.outputEncryptionPassphraseFile.addLongIdentifier("outputEncryptionPasswordFile", true);
        this.outputEncryptionPassphraseFile.addLongIdentifier("output-encryption-password-file", true);
        this.outputEncryptionPassphraseFile.addLongIdentifier("outputPasswordFile", true);
        this.outputEncryptionPassphraseFile.addLongIdentifier("output-password-file", true);
        this.outputEncryptionPassphraseFile.setArgumentGroupName(LDIFMessages.INFO_LDIF_DIFF_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.outputEncryptionPassphraseFile);
        this.overwriteExistingOutputLDIF = new BooleanArgument(Character.valueOf('O'), "overwriteExistingOutputLDIF", 1, LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_OVERWRITE_EXISTING.get());
        this.overwriteExistingOutputLDIF.addLongIdentifier("overwrite-existing-output-ldif", true);
        this.overwriteExistingOutputLDIF.addLongIdentifier("overwriteExistingOutputFile", true);
        this.overwriteExistingOutputLDIF.addLongIdentifier("overwrite-existing-output-file", true);
        this.overwriteExistingOutputLDIF.addLongIdentifier("overwriteExistingOutput", true);
        this.overwriteExistingOutputLDIF.addLongIdentifier("overwrite-existing-output", true);
        this.overwriteExistingOutputLDIF.addLongIdentifier("overwriteExisting", true);
        this.overwriteExistingOutputLDIF.addLongIdentifier("overwrite-existing", true);
        this.overwriteExistingOutputLDIF.addLongIdentifier("overwriteOutputLDIF", true);
        this.overwriteExistingOutputLDIF.addLongIdentifier("overwrite-output-ldif", true);
        this.overwriteExistingOutputLDIF.addLongIdentifier("overwriteOutputFile", true);
        this.overwriteExistingOutputLDIF.addLongIdentifier("overwrite-output-file", true);
        this.overwriteExistingOutputLDIF.addLongIdentifier("overwriteOutput", true);
        this.overwriteExistingOutputLDIF.addLongIdentifier("overwrite-output", true);
        this.overwriteExistingOutputLDIF.addLongIdentifier("overwrite", true);
        this.overwriteExistingOutputLDIF.setArgumentGroupName(LDIFMessages.INFO_LDIF_DIFF_ARG_GROUP_OUTPUT.get());
        parser.addArgument(this.overwriteExistingOutputLDIF);
        this.changeType = new StringArgument(null, "changeType", false, 0, LDIFMessages.INFO_LDIF_DIFF_ARG_PLACEHOLDER_CHANGE_TYPE.get(), LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_CHANGE_TYPE.get(), StaticUtils.setOf(CHANGE_TYPE_ADD, CHANGE_TYPE_DELETE, CHANGE_TYPE_MODIFY), Collections.unmodifiableList(Arrays.asList(CHANGE_TYPE_ADD, CHANGE_TYPE_DELETE, CHANGE_TYPE_MODIFY)));
        this.changeType.addLongIdentifier("change-type", true);
        this.changeType.addLongIdentifier("operationType", true);
        this.changeType.addLongIdentifier("operation-type", true);
        this.changeType.setArgumentGroupName(LDIFMessages.INFO_LDIF_DIFF_ARG_GROUP_CONTENT.get());
        parser.addArgument(this.changeType);
        this.includeFilter = new FilterArgument(null, "includeFilter", false, 0, null, LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_INCLUDE_FILTER.get());
        this.includeFilter.addLongIdentifier("include-filter", true);
        this.includeFilter.setArgumentGroupName(LDIFMessages.INFO_LDIF_DIFF_ARG_GROUP_CONTENT.get());
        parser.addArgument(this.includeFilter);
        this.excludeFilter = new FilterArgument(null, "excludeFilter", false, 0, null, LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_EXCLUDE_FILTER.get());
        this.excludeFilter.addLongIdentifier("exclude-filter", true);
        this.excludeFilter.setArgumentGroupName(LDIFMessages.INFO_LDIF_DIFF_ARG_GROUP_CONTENT.get());
        parser.addArgument(this.excludeFilter);
        this.includeAttribute = new StringArgument(null, "includeAttribute", false, 0, LDIFMessages.INFO_LDIF_DIFF_ARG_PLACEHOLDER_ATTRIBUTE.get(), LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_INCLUDE_ATTRIBUTE.get());
        this.includeAttribute.addLongIdentifier("include-attribute", true);
        this.includeAttribute.addLongIdentifier("includeAttr", true);
        this.includeAttribute.addLongIdentifier("include-attr", true);
        this.includeAttribute.setArgumentGroupName(LDIFMessages.INFO_LDIF_DIFF_ARG_GROUP_CONTENT.get());
        parser.addArgument(this.includeAttribute);
        this.excludeAttribute = new StringArgument(null, "excludeAttribute", false, 0, LDIFMessages.INFO_LDIF_DIFF_ARG_PLACEHOLDER_ATTRIBUTE.get(), LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_EXCLUDE_ATTRIBUTE.get());
        this.excludeAttribute.addLongIdentifier("exclude-attribute", true);
        this.excludeAttribute.addLongIdentifier("excludeAttr", true);
        this.excludeAttribute.addLongIdentifier("exclude-attr", true);
        this.excludeAttribute.setArgumentGroupName(LDIFMessages.INFO_LDIF_DIFF_ARG_GROUP_CONTENT.get());
        parser.addArgument(this.excludeAttribute);
        this.includeOperationalAttributes = new BooleanArgument(Character.valueOf('i'), "includeOperationalAttributes", 1, LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_INCLUDE_OPERATIONAL.get());
        this.includeOperationalAttributes.addLongIdentifier("include-operational-attributes", true);
        this.includeOperationalAttributes.addLongIdentifier("includeOperational", true);
        this.includeOperationalAttributes.addLongIdentifier("include-operational", true);
        this.includeOperationalAttributes.setArgumentGroupName(LDIFMessages.INFO_LDIF_DIFF_ARG_GROUP_CONTENT.get());
        parser.addArgument(this.includeOperationalAttributes);
        this.excludeNoUserModificationAttributes = new BooleanArgument(Character.valueOf('e'), "excludeNoUserModificationAttributes", 1, LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_EXCLUDE_NO_USER_MOD.get());
        this.excludeNoUserModificationAttributes.addLongIdentifier("exclude-no-user-modification-attributes", true);
        this.excludeNoUserModificationAttributes.addLongIdentifier("excludeNoUserModAttributes", true);
        this.excludeNoUserModificationAttributes.addLongIdentifier("exclude-no-user-mod-attributes", true);
        this.excludeNoUserModificationAttributes.addLongIdentifier("excludeNoUserModification", true);
        this.excludeNoUserModificationAttributes.addLongIdentifier("exclude-no-user-modification", true);
        this.excludeNoUserModificationAttributes.addLongIdentifier("excludeNoUserMod", true);
        this.excludeNoUserModificationAttributes.addLongIdentifier("exclude-no-user-mod", true);
        this.excludeNoUserModificationAttributes.setArgumentGroupName(LDIFMessages.INFO_LDIF_DIFF_ARG_GROUP_CONTENT.get());
        parser.addArgument(this.excludeNoUserModificationAttributes);
        this.nonReversibleModifications = new BooleanArgument(null, "nonReversibleModifications", 1, LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_NON_REVERSIBLE_MODS.get());
        this.nonReversibleModifications.addLongIdentifier("non-reversible-modifications", true);
        this.nonReversibleModifications.addLongIdentifier("nonReversibleMods", true);
        this.nonReversibleModifications.addLongIdentifier("non-reversible-mods", true);
        this.nonReversibleModifications.addLongIdentifier("nonReversible", true);
        this.nonReversibleModifications.addLongIdentifier("non-reversible", true);
        this.nonReversibleModifications.setArgumentGroupName(LDIFMessages.INFO_LDIF_DIFF_ARG_GROUP_CONTENT.get());
        parser.addArgument(this.nonReversibleModifications);
        this.singleValueChanges = new BooleanArgument(Character.valueOf('S'), "singleValueChanges", 1, LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_SINGLE_VALUE_CHANGES.get());
        this.singleValueChanges.addLongIdentifier("single-value-changes", true);
        parser.addArgument(this.singleValueChanges);
        this.stripTrailingSpaces = new BooleanArgument(null, "stripTrailingSpaces", 1, LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_STRIP_TRAILING_SPACES.get());
        this.stripTrailingSpaces.addLongIdentifier("strip-trailing-spaces", true);
        this.stripTrailingSpaces.addLongIdentifier("ignoreTrailingSpaces", true);
        this.stripTrailingSpaces.addLongIdentifier("ignore-trailing-spaces", true);
        this.stripTrailingSpaces.setArgumentGroupName(LDIFMessages.INFO_LDIF_DIFF_ARG_GROUP_CONTENT.get());
        parser.addArgument(this.stripTrailingSpaces);
        String schemaPathDesc = PING_SERVER_AVAILABLE ? LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_SCHEMA_PATH_PING_SERVER.get() : LDIFMessages.INFO_LDIF_DIFF_ARG_DESC_SCHEMA_PATH_STANDALONE.get();
        this.schemaPath = new FileArgument(null, "schemaPath", false, 0, null, schemaPathDesc, true, true, false, false);
        this.schemaPath.addLongIdentifier("schema-path", true);
        this.schemaPath.addLongIdentifier("schemaFile", true);
        this.schemaPath.addLongIdentifier("schema-file", true);
        this.schemaPath.addLongIdentifier("schemaDirectory", true);
        this.schemaPath.addLongIdentifier("schema-directory", true);
        this.schemaPath.addLongIdentifier("schema", true);
        parser.addArgument(this.schemaPath);
        parser.addDependentArgumentSet(this.compressOutput, this.outputLDIF, new Argument[0]);
        parser.addDependentArgumentSet(this.encryptOutput, this.outputLDIF, new Argument[0]);
        parser.addDependentArgumentSet(this.outputEncryptionPassphraseFile, this.outputLDIF, new Argument[0]);
        parser.addDependentArgumentSet(this.overwriteExistingOutputLDIF, this.outputLDIF, new Argument[0]);
        parser.addDependentArgumentSet(this.outputEncryptionPassphraseFile, this.encryptOutput, new Argument[0]);
        parser.addExclusiveArgumentSet(this.includeAttribute, this.excludeAttribute, new Argument[0]);
        parser.addExclusiveArgumentSet(this.includeAttribute, this.includeOperationalAttributes, new Argument[0]);
        parser.addExclusiveArgumentSet(this.includeFilter, this.excludeFilter, new Argument[0]);
        parser.addDependentArgumentSet(this.excludeNoUserModificationAttributes, this.includeOperationalAttributes, new Argument[0]);
        parser.addExclusiveArgumentSet(this.nonReversibleModifications, this.singleValueChanges, new Argument[0]);
    }

    @Override
    public void doExtendedArgumentValidation() throws ArgumentException {
        File outputFile = this.outputLDIF.getValue();
        if (outputFile != null && outputFile.exists() && (this.compressOutput.isPresent() || this.encryptOutput.isPresent()) && !this.overwriteExistingOutputLDIF.isPresent()) {
            throw new ArgumentException(LDIFMessages.ERR_LDIF_DIFF_APPEND_WITH_COMPRESSION_OR_ENCRYPTION.get(this.compressOutput.getIdentifierString(), this.encryptOutput.getIdentifierString(), this.overwriteExistingOutputLDIF.getIdentifierString()));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private static Schema getSchema(@NotNull List<File> paths) throws Exception {
        LinkedHashSet<File> schemaFiles = new LinkedHashSet<File>();
        for (File f : paths) {
            if (!f.exists()) continue;
            if (f.isFile()) {
                schemaFiles.add(f);
                continue;
            }
            if (!f.isDirectory()) continue;
            TreeMap<String, File> sortedFiles = new TreeMap<String, File>();
            for (File fileInDir : f.listFiles()) {
                if (!fileInDir.isFile()) continue;
                sortedFiles.put(fileInDir.getName(), fileInDir);
            }
            schemaFiles.addAll(sortedFiles.values());
        }
        return Schema.getSchema(new ArrayList<File>(schemaFiles));
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private TreeMap<DN, Entry> readEntries(@NotNull File ldifFile, @Nullable File encPWFile, @NotNull Schema schema) throws LDAPException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addPassphrase(@Nullable char[] passphrase) {
        if (passphrase == null) {
            return;
        }
        for (char[] existingPassphrase : this.encryptionPassphrases) {
            if (!Arrays.equals(existingPassphrase, passphrase)) continue;
            return;
        }
        this.encryptionPassphrases.add(passphrase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private OutputStream openOutputStream() throws LDAPException {
        if (!this.outputLDIF.isPresent()) {
            return this.getOut();
        }
        OutputStream outputStream = null;
        boolean closeOutputStream = true;
        try {
            try {
                outputStream = new FileOutputStream(this.outputLDIF.getValue(), !this.overwriteExistingOutputLDIF.isPresent());
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDIFMessages.ERR_LDIF_DIFF_CANNOT_OPEN_OUTPUT_FILE.get(StaticUtils.getExceptionMessage(e)), e);
            }
            if (this.encryptOutput.isPresent()) {
                try {
                    char[] passphrase = this.outputEncryptionPassphraseFile.isPresent() ? this.getPasswordFileReader().readPassword(this.outputEncryptionPassphraseFile.getValue()) : ToolUtils.promptForEncryptionPassphrase(false, true, LDIFMessages.INFO_LDIF_DIFF_PROMPT_OUTPUT_FILE_ENC_PW.get(), LDIFMessages.INFO_LDIF_DIFF_CONFIRM_OUTPUT_FILE_ENC_PW.get(), this.getOut(), this.getErr()).toCharArray();
                    outputStream = new PassphraseEncryptedOutputStream(passphrase, outputStream, null, true, true);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDIFMessages.ERR_LDIF_DIFF_CANNOT_ENCRYPT_OUTPUT_FILE.get(StaticUtils.getExceptionMessage(e)), e);
                }
            }
            if (this.compressOutput.isPresent()) {
                try {
                    outputStream = new GZIPOutputStream(outputStream);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDIFMessages.ERR_LDIF_DIFF_CANNOT_COMPRESS_OUTPUT_FILE.get(StaticUtils.getExceptionMessage(e)), e);
                }
            }
            closeOutputStream = false;
            OutputStream outputStream2 = outputStream;
            return outputStream2;
        }
        finally {
            if (closeOutputStream && outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
    }

    private long writeAdds(@NotNull TreeMap<DN, Entry> sourceEntries, @NotNull TreeMap<DN, Entry> targetEntries, @NotNull LDIFWriter writer, @NotNull Schema schema, @NotNull Set<String> includeAttrs, @NotNull Set<String> excludeAttrs) throws LDAPException {
        long addCount = 0L;
        for (Map.Entry<DN, Entry> e : targetEntries.entrySet()) {
            Entry paredEntry;
            DN entryDN = e.getKey();
            Entry entry = e.getValue();
            if (sourceEntries.containsKey(entryDN) || !this.includeEntryByFilter(schema, entry) || (paredEntry = this.pareEntry(entry, schema, includeAttrs, excludeAttrs)) == null) continue;
            try {
                writer.writeChangeRecord(new LDIFAddChangeRecord(paredEntry), LDIFMessages.INFO_LDIF_DIFF_ADD_COMMENT.get());
                ++addCount;
            }
            catch (Exception ex) {
                Debug.debugException(ex);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDIFMessages.ERR_LDIF_DIFF_CANNOT_WRITE_ADD_FOR_ENTRY.get(entry.getDN(), StaticUtils.getExceptionMessage(ex)), ex);
            }
        }
        return addCount;
    }

    private boolean includeEntryByFilter(@NotNull Schema schema, Entry ... entries) {
        for (Entry entry : entries) {
            for (Filter f : this.excludeFilter.getValues()) {
                try {
                    if (!f.matchesEntry(entry, schema)) continue;
                    return false;
                }
                catch (Exception ex) {
                    Debug.debugException(ex);
                }
            }
        }
        if (this.includeFilter.isPresent()) {
            for (Entry entry : entries) {
                for (Filter f : this.includeFilter.getValues()) {
                    try {
                        if (!f.matchesEntry(entry, schema)) continue;
                        return true;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                }
            }
            return false;
        }
        return true;
    }

    @Nullable
    private Entry pareEntry(@NotNull Entry entry, @NotNull Schema schema, @NotNull Set<String> includeAttrs, @NotNull Set<String> excludeAttrs) {
        ArrayList<Attribute> paredAttributeList = new ArrayList<Attribute>();
        for (Attribute a : entry.getAttributes()) {
            AttributeTypeDefinition at;
            String baseName = StaticUtils.toLowerCase(a.getBaseName());
            if (excludeAttrs.contains(baseName) || !includeAttrs.isEmpty() && !includeAttrs.contains(baseName) || (at = schema.getAttributeType(baseName)) != null && at.isOperational() && (!this.includeOperationalAttributes.isPresent() || at.isNoUserModification() && this.excludeNoUserModificationAttributes.isPresent())) continue;
            paredAttributeList.add(a);
        }
        if (paredAttributeList.isEmpty()) {
            return null;
        }
        return new Entry(entry.getDN(), paredAttributeList);
    }

    private long writeModifications(@NotNull TreeMap<DN, Entry> sourceEntries, @NotNull TreeMap<DN, Entry> targetEntries, @NotNull LDIFWriter writer, @NotNull Schema schema, @NotNull Set<String> includeAttrs, @NotNull Set<String> excludeAttrs) throws LDAPException {
        long modCount = 0L;
        for (Map.Entry<DN, Entry> sourceMapEntry : sourceEntries.entrySet()) {
            List<Modification> mods;
            Entry sourceEntry;
            DN sourceDN = sourceMapEntry.getKey();
            Entry targetEntry = targetEntries.get(sourceDN);
            if (targetEntry == null || !this.includeEntryByFilter(schema, sourceEntry = sourceMapEntry.getValue(), targetEntry) || !this.writeModifiedEntry(sourceDN, mods = Entry.diff(sourceEntry, targetEntry, false, !this.nonReversibleModifications.isPresent(), true, new String[0]), writer, schema, includeAttrs, excludeAttrs)) continue;
            ++modCount;
        }
        return modCount;
    }

    private boolean writeModifiedEntry(@NotNull DN dn, @NotNull List<Modification> mods, @NotNull LDIFWriter writer, @NotNull Schema schema, @NotNull Set<String> includeAttrs, @NotNull Set<String> excludeAttrs) throws LDAPException {
        block11: {
            Attribute a;
            if (mods.isEmpty()) {
                return false;
            }
            ArrayList<Modification> paredMods = new ArrayList<Modification>(mods.size());
            for (Modification m : mods) {
                a = m.getAttribute();
                String baseName = StaticUtils.toLowerCase(a.getBaseName());
                if (excludeAttrs.contains(baseName) || !includeAttrs.isEmpty() && !includeAttrs.contains(baseName)) continue;
                AttributeTypeDefinition at = schema.getAttributeType(a.getBaseName());
                if (at != null && at.isOperational()) {
                    if (!this.includeOperationalAttributes.isPresent()) continue;
                    if (at.isNoUserModification()) {
                        if (this.excludeNoUserModificationAttributes.isPresent()) continue;
                        paredMods.add(m);
                        continue;
                    }
                    paredMods.add(m);
                    continue;
                }
                paredMods.add(m);
            }
            if (paredMods.isEmpty()) {
                return false;
            }
            try {
                if (this.singleValueChanges.isPresent()) {
                    for (Modification m : paredMods) {
                        a = m.getAttribute();
                        if (a.size() > 1) {
                            for (byte[] value : a.getValueByteArrays()) {
                                writer.writeChangeRecord(new LDIFModifyChangeRecord(dn.toString(), new Modification(m.getModificationType(), m.getAttributeName(), value)));
                            }
                            continue;
                        }
                        writer.writeChangeRecord(new LDIFModifyChangeRecord(dn.toString(), m));
                    }
                    break block11;
                }
                writer.writeChangeRecord(new LDIFModifyChangeRecord(dn.toString(), (List<Modification>)paredMods), LDIFMessages.INFO_LDIF_DIFF_MODIFY_COMMENT.get());
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDIFMessages.ERR_LDIF_DIFF_CANNOT_WRITE_MODS_TO_ENTRY.get(dn.toString(), StaticUtils.getExceptionMessage(e)), e);
            }
        }
        return true;
    }

    private long writeDeletes(@NotNull TreeMap<DN, Entry> sourceEntries, @NotNull TreeMap<DN, Entry> targetEntries, @NotNull LDIFWriter writer, @NotNull Schema schema, @NotNull Set<String> includeAttrs, @NotNull Set<String> excludeAttrs) throws LDAPException {
        long deleteCount = 0L;
        for (Map.Entry e : sourceEntries.descendingMap().entrySet()) {
            Entry paredEntry;
            DN entryDN = (DN)e.getKey();
            Entry entry = (Entry)e.getValue();
            if (targetEntries.containsKey(entryDN) || !this.includeEntryByFilter(schema, entry) || (paredEntry = this.pareEntry(entry, schema, includeAttrs, excludeAttrs)) == null) continue;
            try {
                String comment = LDIFMessages.INFO_LDIF_DIFF_DELETE_COMMENT.get() + StaticUtils.EOL + paredEntry.toLDIFString(75);
                writer.writeChangeRecord(new LDIFDeleteChangeRecord(paredEntry.getDN()), comment);
                ++deleteCount;
            }
            catch (Exception ex) {
                Debug.debugException(ex);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDIFMessages.ERR_LDIF_DIFF_CANNOT_WRITE_DELETE_FOR_ENTRY.get(entry.getDN(), StaticUtils.getExceptionMessage(ex)), ex);
            }
        }
        return deleteCount;
    }

    private void logCompletionMessage(boolean isError, @NotNull String message) {
        this.completionMessage.compareAndSet(null, message);
        if (isError) {
            this.wrapErr(0, WRAP_COLUMN, message);
        } else {
            this.wrapOut(0, WRAP_COLUMN, message);
        }
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>();
        examples.put(new String[]{"--sourceLDIF", "actual.ldif", "--targetLDIF", "desired.ldif", "--outputLDIF", "diff.ldif"}, LDIFMessages.INFO_LDIF_DIFF_EXAMPLE_1.get());
        examples.put(new String[]{"--sourceLDIF", "actual.ldif", "--targetLDIF", "desired.ldif", "--outputLDIF", "diff.ldif", "--includeOperationalAttributes", "--excludeNoUserModificationAttributes", "--nonReversibleModifications"}, LDIFMessages.INFO_LDIF_DIFF_EXAMPLE_2.get());
        return examples;
    }
}

