import { createContext, useContext } from 'react';
import { rbdInvariant } from '../drag-drop-context/rbd-invariant';
const DroppableContext = /*#__PURE__*/createContext(null);
export const DroppableContextProvider = DroppableContext.Provider;

/**
 * Intended for use by `<Draggable>` instances.
 */
export function useDroppableContext() {
  const value = useContext(DroppableContext);
  rbdInvariant(value, 'Missing <Droppable /> parent');
  return value;
}

/**
 * Returns the `droppableId` of the parent droppable, if there is one.
 *
 * Intended for use only by `<Droppable>` instances.
 */
export function useParentDroppableId() {
  const parentDroppable = useContext(DroppableContext);
  if (!parentDroppable) {
    return null;
  }
  return parentDroppable.droppableId;
}