"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withResolvers = withResolvers;
var _tinyInvariant = _interopRequireDefault(require("tiny-invariant"));
/**
 * Same API as `Promise.withResolvers()` which allows us to get the same
 * outcomes before including `"ES2024.Promise"` in `tsconfig.json: "lib"`
 *
 * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise/withResolvers.
 *
 * Does not support `.call()` on `withResolvers` with non-promise constructors
 *
 * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise/withResolvers#calling_withresolvers_on_a_non-promise_constructor
 */
function withResolvers() {
  var resolve;
  var reject;
  var promise = new Promise(function (res, rej) {
    // Promise constructors run synchronously,
    // so `resolve` and `reject` will be set before the
    // invariants run
    resolve = res;
    reject = rej;
  });

  // to make sure types are correctly narrowed
  (0, _tinyInvariant.default)(resolve);
  (0, _tinyInvariant.default)(reject);
  return {
    resolve: resolve,
    reject: reject,
    promise: promise
  };
}