/* show.tsx generated by @compiled/babel-plugin v0.36.1 */
import "./show.compiled.css";
import * as React from 'react';
import { ax, ix } from "@compiled/react/runtime";
const styles = {
  default: "_1e0cglyw",
  'above.xs': "_114b19ly",
  'above.sm': "_181n19ly",
  'above.md': "_dm2519ly",
  'above.lg': "_je3o19ly",
  'above.xl': "_1uxv19ly",
  'below.xs': "_1m0a19ly",
  'below.sm': "_suga19ly",
  'below.md': "_1mjb19ly",
  'below.lg': "_liwc19ly",
  'below.xl': "_14wz19ly"
};
/**
 * Shows the content at a given breakpoint.  By default, content is hidden.  The primary use case is for visual presentation.
 * Mix `<Show above="md">` with `<Hide above="md">` to achieve content that shifts at a breakpoint.
 *
 * Please note:
 * - This only uses `display: none` and `display: revert` to show/hide, it does not skip rendering of children trees.
 * - As this is rendered at all times, there is little performance savings here (just that this is not painted).
 */
export const Show = ({
  above,
  below,
  children,
  as: AsElement = 'div',
  xcss
}) => {
  return /*#__PURE__*/React.createElement(AsElement, {
    className: ax([styles.default, above && styles[`above.${above}`], below && styles[`below.${below}`], xcss])
  }, children);
};