/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import proguard.analysis.cpa.domain.taint.TaintSink;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.analysis.cpa.jvm.witness.JvmStackLocation;
import proguard.analysis.cpa.jvm.witness.JvmStaticFieldLocation;
import proguard.classfile.util.ClassUtil;

public class JvmTaintSink
extends TaintSink {
    public JvmTaintSink(String fqn, boolean takesInstance, Set<Integer> takesArgs, Set<String> takesGlobals) {
        super(fqn, takesInstance, takesArgs, takesGlobals);
    }

    public Set<JvmMemoryLocation> getMemoryLocations() {
        HashSet<JvmMemoryLocation> result = new HashSet<JvmMemoryLocation>();
        String descriptor = this.fqn.substring(this.fqn.indexOf("("));
        int parameterSize = ClassUtil.internalMethodParameterSize(descriptor);
        if (this.takesInstance) {
            result.add(new JvmStackLocation(parameterSize));
        }
        this.takesArgs.forEach(i -> result.add(new JvmStackLocation(parameterSize - ClassUtil.internalMethodVariableIndex(descriptor, true, (int)i))));
        this.takesGlobals.forEach(fqn -> result.add(new JvmStaticFieldLocation((String)fqn)));
        return result;
    }

    public static Map<String, Set<JvmMemoryLocation>> convertSinksToMemoryLocations(Collection<? extends JvmTaintSink> taintSinks) {
        HashMap<String, Set<JvmMemoryLocation>> result = new HashMap<String, Set<JvmMemoryLocation>>();
        for (JvmTaintSink jvmTaintSink : taintSinks) {
            Set<JvmMemoryLocation> memoryLocations = jvmTaintSink.getMemoryLocations();
            result.merge(jvmTaintSink.fqn, memoryLocations, (fqn, ls) -> {
                ls.addAll(memoryLocations);
                return ls;
            });
        }
        return result;
    }
}

