/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

final class ShortestUsageMark {
    private final boolean certain;
    private final String reason;
    private final int depth;
    private Clazz clazz;
    private Member member;

    public ShortestUsageMark(String reason) {
        this.certain = true;
        this.reason = reason;
        this.depth = 0;
    }

    public ShortestUsageMark(ShortestUsageMark previousUsageMark, String reason, int cost, Clazz clazz) {
        this(previousUsageMark, reason, cost, clazz, null);
    }

    public ShortestUsageMark(ShortestUsageMark previousUsageMark, String reason, int cost, Clazz clazz, Member member) {
        this.certain = true;
        this.reason = reason;
        this.depth = previousUsageMark.depth + cost;
        this.clazz = clazz;
        this.member = member;
    }

    public ShortestUsageMark(ShortestUsageMark otherUsageMark, boolean certain) {
        this.certain = certain;
        this.reason = otherUsageMark.reason;
        this.depth = otherUsageMark.depth;
        this.clazz = otherUsageMark.clazz;
        this.member = otherUsageMark.member;
    }

    public boolean isCertain() {
        return this.certain;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean isShorter(ShortestUsageMark otherUsageMark) {
        return this.depth < otherUsageMark.depth;
    }

    public boolean isCausedBy(Clazz clazz) {
        return clazz.equals(this.clazz);
    }

    public boolean isCausedByMember(Clazz clazz) {
        return clazz.equals(this.clazz) && this.member != null;
    }

    public boolean isCausedBy(Clazz clazz, Member member) {
        return clazz.equals(this.clazz) && member.equals(this.member);
    }

    public void acceptClassVisitor(ClassVisitor classVisitor) {
        if (this.clazz != null && this.member == null) {
            this.clazz.accept(classVisitor);
        }
    }

    public void acceptMemberVisitor(MemberVisitor memberVisitor) {
        if (this.clazz != null && this.member != null) {
            this.member.accept(this.clazz, memberVisitor);
        }
    }

    public String toString() {
        return "certain=" + this.certain + ", depth=" + this.depth + ": " + this.reason + (this.clazz != null ? this.clazz.getName() : "(none)") + ": " + (this.member != null ? this.member.getName(this.clazz) : "(none)");
    }
}

