/*
 * Decompiled with CFR 0.152.
 */
package com.eed3si9n.jarjar;

import com.eed3si9n.jarjar.PatternElement;
import com.eed3si9n.jarjar.Rule;
import com.eed3si9n.jarjar.TracingRemapper;
import com.eed3si9n.jarjar.Wildcard;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

class PackageRemapper
extends TracingRemapper {
    private static final String RESOURCE_SUFFIX = "RESOURCE";
    private static final Pattern ARRAY_FOR_NAME_PATTERN = Pattern.compile("\\[L[\\p{javaJavaIdentifierPart}\\.]+?;");
    private final List<Wildcard> wildcards;
    private final List<Rule> ruleList;
    private final Map<String, String> typeCache = new HashMap<String, String>();
    private final Map<String, String> pathCache = new HashMap<String, String>();
    private final Map<Object, String> valueCache = new HashMap<Object, String>();
    private final boolean verbose;
    private boolean modified = false;

    public PackageRemapper(List<Rule> list2, boolean bl) {
        this.verbose = bl;
        this.ruleList = list2;
        this.wildcards = PatternElement.createWildcards(list2);
    }

    @Override
    public TracingRemapper copy() {
        return new PackageRemapper(this.ruleList, this.verbose);
    }

    static boolean isArrayForName(String string) {
        return ARRAY_FOR_NAME_PATTERN.matcher(string).matches();
    }

    @Override
    public String map(String string) {
        String string2 = this.typeCache.get(string);
        if (string2 == null) {
            string2 = this.replaceHelper(string);
            if (string.equals(string2)) {
                string2 = null;
            }
            this.typeCache.put(string, string2);
        }
        return string2;
    }

    public String mapPath(String string) {
        String string2 = this.pathCache.get(string);
        if (string2 == null) {
            String string3;
            string2 = string;
            int n = string2.lastIndexOf(47);
            if (n < 0) {
                string3 = string2;
                string2 = RESOURCE_SUFFIX;
            } else {
                string3 = string2.substring(n + 1);
                string2 = string2.substring(0, n + 1) + RESOURCE_SUFFIX;
            }
            boolean bl = string2.startsWith("/");
            if (bl) {
                string2 = string2.substring(1);
            }
            string2 = this.replaceHelper(string2);
            if (bl) {
                string2 = "/" + string2;
            }
            if (string2.indexOf(RESOURCE_SUFFIX) < 0) {
                return string;
            }
            string2 = string2.substring(0, string2.length() - RESOURCE_SUFFIX.length()) + string3;
            this.pathCache.put(string, string2);
        }
        return string2;
    }

    @Override
    public Object mapValue(Object object) {
        if (object instanceof String) {
            String string = this.valueCache.get(object);
            if (string == null) {
                string = (String)object;
                if (PackageRemapper.isArrayForName(string)) {
                    String string2 = string.replace('.', '/');
                    String string3 = this.mapDesc(string2);
                    if (!string3.equals(string2)) {
                        return string3.replace('/', '.');
                    }
                } else if ((string = this.mapPath(string)).equals(object)) {
                    boolean bl;
                    boolean bl2 = string.indexOf(46) >= 0;
                    boolean bl3 = bl = string.indexOf(47) >= 0;
                    if (!bl2 || !bl) {
                        string = bl2 ? this.replaceHelper(string.replace('.', '/')).replace('/', '.') : this.replaceHelper(string);
                    }
                }
                this.valueCache.put(object, string);
            }
            if (this.verbose && !string.equals(object)) {
                System.err.println("Changed \"" + object + "\" -> \"" + string + "\"");
            }
            return string;
        }
        return super.mapValue(object);
    }

    @Override
    public String mapInnerClassName(String string, String string2, String string3) {
        return string3;
    }

    private String replaceHelper(String string) {
        for (Wildcard wildcard : this.wildcards) {
            String string2 = wildcard.replace(string);
            if (string2 == null) continue;
            if (!string2.equals(string)) {
                this.modified = true;
            }
            return string2;
        }
        return string;
    }

    @Override
    public boolean hasChanges() {
        return this.modified;
    }
}

