/// \file
/// \ingroup tutorial_tree
/// \notebook -nodraw
/// Copy a subset of a Tree to a new Tree, one branch in a separate file.
///
/// One branch of the new Tree is written to a separate file
/// The input file has been generated by the program in `$ROOTSYS/test/Event`
/// with the command `Event 1000 1 1 1`
///
/// \macro_code
///
/// \author Rene Brun

// Load the library at macro parsing time: we need this to use its content in the code
#ifdef R__WIN32
R__LOAD_LIBRARY($ROOTSYS/test/libEvent.dll)
#else
R__LOAD_LIBRARY($ROOTSYS/test/libEvent.so)
#endif

void tree111_copy()
{

   TString dir = "$ROOTSYS/test/Event.root";
   gSystem->ExpandPathName(dir);
   const auto filename = gSystem->AccessPathName(dir) ? "./Event.root" : "$ROOTSYS/test/Event.root";

   TFile oldfile(filename);
   TTree *oldtree;
   oldfile.GetObject("T", oldtree);

   // Activate only four of them
   for (auto activeBranchName : {"event", "fNtrack", "fNseg", "fH"}) {
      oldtree->SetBranchStatus(activeBranchName, 1);
   }

   // Create a new file + a clone of old tree header. Do not copy events
   TFile newfile("small.root", "recreate");
   auto newtree = oldtree->CloneTree(0);

   // Divert branch fH to a separate file and copy all events
   newtree->GetBranch("fH")->SetFile("small_fH.root");
   newtree->CopyEntries(oldtree);

   newtree->Print();
   newfile.Write();
}
