/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build.event.types;

import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.ProblemLocator;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.tooling.internal.protocol.InternalBasicProblemDetailsVersion3;
import org.gradle.tooling.internal.protocol.InternalFailure;

public class DefaultFailure
implements Serializable,
InternalFailure {
    private final String message;
    private final String description;
    private final List<? extends InternalFailure> causes;
    private final List<InternalBasicProblemDetailsVersion3> problems;

    DefaultFailure(String message, String description, List<? extends InternalFailure> causes) {
        this(message, description, causes, Collections.emptyList());
    }

    DefaultFailure(String message, String description, List<? extends InternalFailure> causes, List<InternalBasicProblemDetailsVersion3> problems) {
        this.message = message;
        this.description = description;
        this.causes = causes;
        this.problems = problems;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDescription() {
        return this.description;
    }

    public List<? extends InternalFailure> getCauses() {
        return this.causes;
    }

    public List<InternalBasicProblemDetailsVersion3> getProblems() {
        return this.problems;
    }

    public static InternalFailure fromThrowable(Throwable throwable) {
        return DefaultFailure.fromThrowable(throwable, t -> ImmutableList.of(), p -> null);
    }

    public static InternalFailure fromThrowable(Throwable t, ProblemLocator problemLocator, Function<InternalProblem, InternalBasicProblemDetailsVersion3> mapper) {
        StringWriter out = new StringWriter();
        PrintWriter wrt = new PrintWriter(out);
        t.printStackTrace(wrt);
        Throwable cause = t.getCause();
        List<InternalFailure> causeFailures = DefaultFailure.getCauseFailures(problemLocator, mapper, cause);
        List<InternalBasicProblemDetailsVersion3> problemMapping = problemLocator.findAll(t).stream().filter(Objects::nonNull).map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
        return new DefaultFailure(t.getMessage(), out.toString(), causeFailures, problemMapping);
    }

    @Nonnull
    private static List<InternalFailure> getCauseFailures(ProblemLocator problemLocator, Function<InternalProblem, InternalBasicProblemDetailsVersion3> mapper, Throwable cause) {
        if (cause == null) {
            return Collections.emptyList();
        }
        if (cause instanceof MultiCauseException) {
            MultiCauseException multiCause = (MultiCauseException)cause;
            return multiCause.getCauses().stream().map(f -> DefaultFailure.fromThrowable(f, problemLocator, mapper)).collect(Collectors.toList());
        }
        return Collections.singletonList(DefaultFailure.fromThrowable(cause, problemLocator, mapper));
    }
}

