// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_after_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllHTTPAfterResponseRuleFrontendOKCode is the HTTP code returned for type GetAllHTTPAfterResponseRuleFrontendOK
const GetAllHTTPAfterResponseRuleFrontendOKCode int = 200

/*
GetAllHTTPAfterResponseRuleFrontendOK Successful operation

swagger:response getAllHttpAfterResponseRuleFrontendOK
*/
type GetAllHTTPAfterResponseRuleFrontendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.HTTPAfterResponseRules `json:"body,omitempty"`
}

// NewGetAllHTTPAfterResponseRuleFrontendOK creates GetAllHTTPAfterResponseRuleFrontendOK with default headers values
func NewGetAllHTTPAfterResponseRuleFrontendOK() *GetAllHTTPAfterResponseRuleFrontendOK {

	return &GetAllHTTPAfterResponseRuleFrontendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all Http after response rule frontend o k response
func (o *GetAllHTTPAfterResponseRuleFrontendOK) WithConfigurationVersion(configurationVersion string) *GetAllHTTPAfterResponseRuleFrontendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all Http after response rule frontend o k response
func (o *GetAllHTTPAfterResponseRuleFrontendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all Http after response rule frontend o k response
func (o *GetAllHTTPAfterResponseRuleFrontendOK) WithPayload(payload models.HTTPAfterResponseRules) *GetAllHTTPAfterResponseRuleFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all Http after response rule frontend o k response
func (o *GetAllHTTPAfterResponseRuleFrontendOK) SetPayload(payload models.HTTPAfterResponseRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllHTTPAfterResponseRuleFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPAfterResponseRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllHTTPAfterResponseRuleFrontendDefault General Error

swagger:response getAllHttpAfterResponseRuleFrontendDefault
*/
type GetAllHTTPAfterResponseRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllHTTPAfterResponseRuleFrontendDefault creates GetAllHTTPAfterResponseRuleFrontendDefault with default headers values
func NewGetAllHTTPAfterResponseRuleFrontendDefault(code int) *GetAllHTTPAfterResponseRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllHTTPAfterResponseRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all HTTP after response rule frontend default response
func (o *GetAllHTTPAfterResponseRuleFrontendDefault) WithStatusCode(code int) *GetAllHTTPAfterResponseRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all HTTP after response rule frontend default response
func (o *GetAllHTTPAfterResponseRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all HTTP after response rule frontend default response
func (o *GetAllHTTPAfterResponseRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *GetAllHTTPAfterResponseRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all HTTP after response rule frontend default response
func (o *GetAllHTTPAfterResponseRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all HTTP after response rule frontend default response
func (o *GetAllHTTPAfterResponseRuleFrontendDefault) WithPayload(payload *models.Error) *GetAllHTTPAfterResponseRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all HTTP after response rule frontend default response
func (o *GetAllHTTPAfterResponseRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllHTTPAfterResponseRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
