// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package maps

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ClearRuntimeMapNoContentCode is the HTTP code returned for type ClearRuntimeMapNoContent
const ClearRuntimeMapNoContentCode int = 204

/*
ClearRuntimeMapNoContent All map entries deleted

swagger:response clearRuntimeMapNoContent
*/
type ClearRuntimeMapNoContent struct {
}

// NewClearRuntimeMapNoContent creates ClearRuntimeMapNoContent with default headers values
func NewClearRuntimeMapNoContent() *ClearRuntimeMapNoContent {

	return &ClearRuntimeMapNoContent{}
}

// WriteResponse to the client
func (o *ClearRuntimeMapNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// ClearRuntimeMapNotFoundCode is the HTTP code returned for type ClearRuntimeMapNotFound
const ClearRuntimeMapNotFoundCode int = 404

/*
ClearRuntimeMapNotFound The specified resource was not found

swagger:response clearRuntimeMapNotFound
*/
type ClearRuntimeMapNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewClearRuntimeMapNotFound creates ClearRuntimeMapNotFound with default headers values
func NewClearRuntimeMapNotFound() *ClearRuntimeMapNotFound {

	return &ClearRuntimeMapNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the clear runtime map not found response
func (o *ClearRuntimeMapNotFound) WithConfigurationVersion(configurationVersion string) *ClearRuntimeMapNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the clear runtime map not found response
func (o *ClearRuntimeMapNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the clear runtime map not found response
func (o *ClearRuntimeMapNotFound) WithPayload(payload *models.Error) *ClearRuntimeMapNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the clear runtime map not found response
func (o *ClearRuntimeMapNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ClearRuntimeMapNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ClearRuntimeMapDefault General Error

swagger:response clearRuntimeMapDefault
*/
type ClearRuntimeMapDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewClearRuntimeMapDefault creates ClearRuntimeMapDefault with default headers values
func NewClearRuntimeMapDefault(code int) *ClearRuntimeMapDefault {
	if code <= 0 {
		code = 500
	}

	return &ClearRuntimeMapDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the clear runtime map default response
func (o *ClearRuntimeMapDefault) WithStatusCode(code int) *ClearRuntimeMapDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the clear runtime map default response
func (o *ClearRuntimeMapDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the clear runtime map default response
func (o *ClearRuntimeMapDefault) WithConfigurationVersion(configurationVersion string) *ClearRuntimeMapDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the clear runtime map default response
func (o *ClearRuntimeMapDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the clear runtime map default response
func (o *ClearRuntimeMapDefault) WithPayload(payload *models.Error) *ClearRuntimeMapDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the clear runtime map default response
func (o *ClearRuntimeMapDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ClearRuntimeMapDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
