'use client';
import { useRef, useEffect, useCallback } from 'react';
import { useCallbackRef } from '../use-callback-ref/use-callback-ref.mjs';

function useDebouncedCallback(callback, delay) {
  const handleCallback = useCallbackRef(callback);
  const debounceTimerRef = useRef(0);
  useEffect(() => () => window.clearTimeout(debounceTimerRef.current), []);
  return useCallback(
    (...args) => {
      window.clearTimeout(debounceTimerRef.current);
      debounceTimerRef.current = window.setTimeout(() => handleCallback(...args), delay);
    },
    [handleCallback, delay]
  );
}

export { useDebouncedCallback };
//# sourceMappingURL=use-debounced-callback.mjs.map
