/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.ins.internal;

import com.vladsch.flexmark.ext.ins.Ins;
import com.vladsch.flexmark.ext.ins.InsExtension;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class InsNodeRenderer
implements NodeRenderer {
    private final String insStyleHtmlOpen;
    private final String insStyleHtmlClose;

    public InsNodeRenderer(DataHolder options) {
        this.insStyleHtmlOpen = (String)InsExtension.INS_STYLE_HTML_OPEN.get(options);
        this.insStyleHtmlClose = (String)InsExtension.INS_STYLE_HTML_CLOSE.get(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(Ins.class, this::render));
        return set;
    }

    private void render(Ins node, NodeRendererContext context, HtmlWriter html) {
        if (this.insStyleHtmlOpen == null || this.insStyleHtmlClose == null) {
            if (context.getHtmlOptions().sourcePositionParagraphLines) {
                html.withAttr().tag((CharSequence)"ins");
            } else {
                html.srcPos(node.getText()).withAttr().tag((CharSequence)"ins");
            }
            context.renderChildren((Node)node);
            html.tag((CharSequence)"/ins");
        } else {
            html.raw((CharSequence)this.insStyleHtmlOpen);
            context.renderChildren((Node)node);
            html.raw((CharSequence)this.insStyleHtmlClose);
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new InsNodeRenderer(options);
        }
    }
}

