/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.attributes;

import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import org.jetbrains.annotations.NotNull;

public enum AttributeValueQuotes {
    AS_IS,
    NO_QUOTES_SINGLE_PREFERRED,
    NO_QUOTES_DOUBLE_PREFERRED,
    SINGLE_PREFERRED,
    DOUBLE_PREFERRED,
    SINGLE_QUOTES,
    DOUBLE_QUOTES;

    static final CharPredicate P_SPACES_OR_QUOTES;
    static final CharPredicate P_SINGLE_QUOTES;
    static final CharPredicate P_DOUBLE_QUOTES;

    @NotNull
    public String quotesFor(@NotNull CharSequence text, @NotNull CharSequence defaultQuotes) {
        switch (this) {
            case NO_QUOTES_SINGLE_PREFERRED: {
                if (!SequenceUtils.containsAny((CharSequence)text, (CharPredicate)P_SPACES_OR_QUOTES)) {
                    return "";
                }
                if (!SequenceUtils.containsAny((CharSequence)text, (CharPredicate)P_SINGLE_QUOTES) || SequenceUtils.containsAny((CharSequence)text, (CharPredicate)P_DOUBLE_QUOTES)) {
                    return "'";
                }
                return "\"";
            }
            case NO_QUOTES_DOUBLE_PREFERRED: {
                if (!SequenceUtils.containsAny((CharSequence)text, (CharPredicate)P_SPACES_OR_QUOTES)) {
                    return "";
                }
                if (!SequenceUtils.containsAny((CharSequence)text, (CharPredicate)P_DOUBLE_QUOTES) || SequenceUtils.containsAny((CharSequence)text, (CharPredicate)P_SINGLE_QUOTES)) {
                    return "\"";
                }
                return "'";
            }
            case SINGLE_PREFERRED: {
                if (!SequenceUtils.containsAny((CharSequence)text, (CharPredicate)P_SINGLE_QUOTES) || SequenceUtils.containsAny((CharSequence)text, (CharPredicate)P_DOUBLE_QUOTES)) {
                    return "'";
                }
                return "\"";
            }
            case DOUBLE_PREFERRED: {
                if (!SequenceUtils.containsAny((CharSequence)text, (CharPredicate)P_DOUBLE_QUOTES) || SequenceUtils.containsAny((CharSequence)text, (CharPredicate)P_SINGLE_QUOTES)) {
                    return "\"";
                }
                return "'";
            }
            case SINGLE_QUOTES: {
                return "'";
            }
            case DOUBLE_QUOTES: {
                return "\"";
            }
        }
        return defaultQuotes.toString();
    }

    static {
        P_SPACES_OR_QUOTES = CharPredicate.anyOf((CharSequence)" \t\n'\"");
        P_SINGLE_QUOTES = CharPredicate.anyOf((CharSequence)"'");
        P_DOUBLE_QUOTES = CharPredicate.anyOf((CharSequence)"\"");
    }
}

