// Class: ReadMLP
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : MLP::MLP
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.07/07       [395015]
Creator        : qati
Date           : Fri Sep 16 08:58:26 2016
Host           : Linux Q 4.4.0-34-generic #53-Ubuntu SMP Wed Jul 27 16:06:39 UTC 2016 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /media/share/code/GSOC/wd/notebooks
Training events: 6000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
NCycles: "600" [Number of training cycles]
HiddenLayers: "N+5" [Specification of hidden layer architecture]
NeuronType: "tanh" [Neuron activation function type]
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
VarTransform: "N" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
H: "False" [Print method-specific help message]
TestRate: "5" [Test for overtraining performed at each #th epochs]
UseRegulator: "False" [Use regulator to avoid over-training]
# Default:
RandomSeed: "1" [Random seed for initial synapse weights (0 means unique seed for each run; default value '1')]
EstimatorType: "CE" [MSE (Mean Square Estimator) for Gaussian Likelihood or CE(Cross-Entropy) for Bernoulli Likelihood]
NeuronInputType: "sum" [Neuron input function type]
VerbosityLevel: "Default" [Verbosity level]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
TrainingMethod: "BP" [Train with Back-Propagation (BP), BFGS Algorithm (BFGS), or Genetic Algorithm (GA - slower and worse)]
LearningRate: "2.000000e-02" [ANN learning rate parameter]
DecayRate: "1.000000e-02" [Decay rate for learning parameter]
EpochMonitoring: "False" [Provide epoch-wise monitoring plots according to TestRate (caution: causes big ROOT output file!)]
Sampling: "1.000000e+00" [Only 'Sampling' (randomly selected) events are trained each epoch]
SamplingEpoch: "1.000000e+00" [Sampling is used for the first 'SamplingEpoch' epochs, afterwards, all events are taken for training]
SamplingImportance: "1.000000e+00" [ The sampling weights of events in epochs which successful (worse estimator than before) are multiplied with SamplingImportance, else they are divided.]
SamplingTraining: "True" [The training sample is sampled]
SamplingTesting: "False" [The testing sample is sampled]
ResetStep: "50" [How often BFGS should reset history]
Tau: "3.000000e+00" [LineSearch "size step"]
BPMode: "sequential" [Back-propagation learning mode: sequential or batch]
BatchSize: "-1" [Batch size: number of events/batch, only set if in Batch Mode, -1 for BatchSize=number_of_events]
ConvergenceImprove: "1.000000e-30" [Minimum improvement which counts as improvement (<0 means automatic convergence check is turned off)]
ConvergenceTests: "-1" [Number of steps (without improvement) required for convergence (<0 means automatic convergence check is turned off)]
UpdateLimit: "10000" [Maximum times of regulator update]
CalculateErrors: "False" [Calculates inverse Hessian matrix at the end of the training to be able to calculate the uncertainties of an MVA value]
WeightRange: "1.000000e+00" [Take the events for the estimator calculations from small deviations from the desired value to large deviations only over the weight range]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1+var2                     myvar1                        myvar1                        myvar1                                                          'F'    [-8.96602058411,7.69307804108]
var1-var2                     myvar2                        myvar2                        Expression 2                  F                                 'F'    [-4.08540010452,4.0258936882]
var3                          var3                          var3                          Variable 3                    F                                 'F'    [-5.05078554153,4.35967063904]
var4                          var4                          var4                          Variable 4                    F                                 'F'    [-5.95050764084,4.92254400253]
NSpec 2
var1*2                        spec1                         spec1                         Spectator 1                   F                                 'F'    [-9.91655540466,9.52782058716]
var1*3                        spec2                         spec2                         Spectator 2                   F                                 'F'    [-14.874833107,14.2917308807]


============================================================================ */

#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadMLP : public IClassifierReader {

 public:

   // constructor
   ReadMLP( std::vector<std::string>& theInputVars ) 
      : IClassifierReader(),
        fClassName( "ReadMLP" ),
        fNvars( 4 ),
        fIsNormalised( false )
   {      
      // the training input variables
      const char* inputVars[] = { "var1+var2", "var1-var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = -1;
      fVmax[0] = 1;
      fVmin[1] = -1;
      fVmax[1] = 1;
      fVmin[2] = -1;
      fVmax[2] = 1;
      fVmin[3] = -1;
      fVmax[3] = 1;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

      // initialize transformation
      InitTransform();
   }

   // destructor
   virtual ~ReadMLP() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the 
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const;

 private:

   // method-specific destructor
   void Clear();

   // input variable transformation

   double fMin_1[3][4];
   double fMax_1[3][4];
   void InitTransform_1();
   void Transform_1( std::vector<double> & iv, int sigOrBgd ) const;
   void InitTransform();
   void Transform( std::vector<double> & iv, int sigOrBgd ) const;

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   const bool fIsNormalised;
   bool IsNormalised() const { return fIsNormalised; }
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)

   double ActivationFnc(double x) const;
   double OutputActivationFnc(double x) const;

   int fLayers;
   int fLayerSize[3];
   double fWeightMatrix0to1[10][5];   // weight matrix from layer 0 to 1
   double fWeightMatrix1to2[1][10];   // weight matrix from layer 1 to 2

   double * fWeights[3];
};

inline void ReadMLP::Initialize()
{
   // build network structure
   fLayers = 3;
   fLayerSize[0] = 5; fWeights[0] = new double[5]; 
   fLayerSize[1] = 10; fWeights[1] = new double[10]; 
   fLayerSize[2] = 1; fWeights[2] = new double[1]; 
   // weight matrix from layer 0 to 1
   fWeightMatrix0to1[0][0] = 1.42159045213605;
   fWeightMatrix0to1[1][0] = 1.80779567708684;
   fWeightMatrix0to1[2][0] = 0.743323333480785;
   fWeightMatrix0to1[3][0] = 0.27582290757759;
   fWeightMatrix0to1[4][0] = -6.72214857703873;
   fWeightMatrix0to1[5][0] = -3.09472000959699;
   fWeightMatrix0to1[6][0] = -2.86681096456951;
   fWeightMatrix0to1[7][0] = 2.16188217091973;
   fWeightMatrix0to1[8][0] = -2.40429884164089;
   fWeightMatrix0to1[0][1] = -1.11429528021031;
   fWeightMatrix0to1[1][1] = -1.63592569066279;
   fWeightMatrix0to1[2][1] = -0.800791806212094;
   fWeightMatrix0to1[3][1] = -1.0685895589216;
   fWeightMatrix0to1[4][1] = -0.903900955115274;
   fWeightMatrix0to1[5][1] = -0.610625644195665;
   fWeightMatrix0to1[6][1] = -0.642791346720653;
   fWeightMatrix0to1[7][1] = 1.24796742494604;
   fWeightMatrix0to1[8][1] = 1.63270549746975;
   fWeightMatrix0to1[0][2] = 0.742136402883373;
   fWeightMatrix0to1[1][2] = 1.0844322358026;
   fWeightMatrix0to1[2][2] = -0.523516662014627;
   fWeightMatrix0to1[3][2] = -0.499857244164466;
   fWeightMatrix0to1[4][2] = -0.860134050447209;
   fWeightMatrix0to1[5][2] = -2.54843510483665;
   fWeightMatrix0to1[6][2] = -1.78363012761536;
   fWeightMatrix0to1[7][2] = 0.775684084121952;
   fWeightMatrix0to1[8][2] = 1.2420536755335;
   fWeightMatrix0to1[0][3] = -5.06138751521405;
   fWeightMatrix0to1[1][3] = -2.26776462699369;
   fWeightMatrix0to1[2][3] = 0.709193120046989;
   fWeightMatrix0to1[3][3] = 3.34341530580108;
   fWeightMatrix0to1[4][3] = 7.69339043307828;
   fWeightMatrix0to1[5][3] = 3.00004060494428;
   fWeightMatrix0to1[6][3] = -1.24415763562343;
   fWeightMatrix0to1[7][3] = -2.26875071377117;
   fWeightMatrix0to1[8][3] = 0.577027936171751;
   fWeightMatrix0to1[0][4] = -0.712380958911639;
   fWeightMatrix0to1[1][4] = 0.80023406199082;
   fWeightMatrix0to1[2][4] = -0.151653519712645;
   fWeightMatrix0to1[3][4] = 1.21220032457997;
   fWeightMatrix0to1[4][4] = -0.288899126391223;
   fWeightMatrix0to1[5][4] = 0.326165117568634;
   fWeightMatrix0to1[6][4] = 3.44350126968832;
   fWeightMatrix0to1[7][4] = 1.1657822670313;
   fWeightMatrix0to1[8][4] = -1.43597897887725;
   // weight matrix from layer 1 to 2
   fWeightMatrix1to2[0][0] = -2.44393740933108;
   fWeightMatrix1to2[0][1] = -0.381729819297147;
   fWeightMatrix1to2[0][2] = 0.470503958381278;
   fWeightMatrix1to2[0][3] = 2.83543124148423;
   fWeightMatrix1to2[0][4] = 2.12797426815875;
   fWeightMatrix1to2[0][5] = 1.47178935199083;
   fWeightMatrix1to2[0][6] = 2.13076231787223;
   fWeightMatrix1to2[0][7] = -2.28311233584532;
   fWeightMatrix1to2[0][8] = 1.26319721791977;
   fWeightMatrix1to2[0][9] = -2.87865295034694;
}

inline double ReadMLP::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   if (inputValues.size() != (unsigned int)fLayerSize[0]-1) {
      std::cout << "Input vector needs to be of size " << fLayerSize[0]-1 << std::endl;
      return 0;
   }

   for (int l=0; l<fLayers; l++)
      for (int i=0; i<fLayerSize[l]; i++) fWeights[l][i]=0;

   for (int l=0; l<fLayers-1; l++)
      fWeights[l][fLayerSize[l]-1]=1;

   for (int i=0; i<fLayerSize[0]-1; i++)
      fWeights[0][i]=inputValues[i];

   // layer 0 to 1
   for (int o=0; o<fLayerSize[1]-1; o++) {
      for (int i=0; i<fLayerSize[0]; i++) {
         double inputVal = fWeightMatrix0to1[o][i] * fWeights[0][i];
         fWeights[1][o] += inputVal;
      }
      fWeights[1][o] = ActivationFnc(fWeights[1][o]);
   }
   // layer 1 to 2
   for (int o=0; o<fLayerSize[2]; o++) {
      for (int i=0; i<fLayerSize[1]; i++) {
         double inputVal = fWeightMatrix1to2[o][i] * fWeights[1][i];
         fWeights[2][o] += inputVal;
      }
      fWeights[2][o] = OutputActivationFnc(fWeights[2][o]);
   }

   return fWeights[2][0];
}

double ReadMLP::ActivationFnc(double x) const {
   // hyperbolic tan
   return tanh(x);
}
double ReadMLP::OutputActivationFnc(double x) const {
   // sigmoid
   return 1.0/(1.0+exp(-x));
}
   
// Clean up
inline void ReadMLP::Clear() 
{
   // clean up the arrays
   for (int lIdx = 0; lIdx < 3; lIdx++) {
      delete[] fWeights[lIdx];
   }
}
   inline double ReadMLP::GetMvaValue( const std::vector<double>& inputValues ) const
   {
      // classifier response value
      double retval = 0;

      // classifier response, sanity check first
      if (!IsStatusClean()) {
         std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                   << " because status is dirty" << std::endl;
         retval = 0;
      }
      else {
         if (IsNormalised()) {
            // normalise variables
            std::vector<double> iV;
            iV.reserve(inputValues.size());
            int ivar = 0;
            for (std::vector<double>::const_iterator varIt = inputValues.begin();
                 varIt != inputValues.end(); varIt++, ivar++) {
               iV.push_back(NormVariable( *varIt, fVmin[ivar], fVmax[ivar] ));
            }
            Transform( iV, -1 );
            retval = GetMvaValue__( iV );
         }
         else {
            std::vector<double> iV;
            int ivar = 0;
            for (std::vector<double>::const_iterator varIt = inputValues.begin();
                 varIt != inputValues.end(); varIt++, ivar++) {
               iV.push_back(*varIt);
            }
            Transform( iV, -1 );
            retval = GetMvaValue__( iV );
         }
      }

      return retval;
   }

//_______________________________________________________________________
inline void ReadMLP::InitTransform_1()
{
   // Normalization transformation, initialisation
   fMin_1[0][0] = -5.05625915527;
   fMax_1[0][0] = 6.3994679451;
   fMin_1[1][0] = -8.96602058411;
   fMax_1[1][0] = 7.69307804108;
   fMin_1[2][0] = -8.96602058411;
   fMax_1[2][0] = 7.69307804108;
   fMin_1[0][1] = -4.08540010452;
   fMax_1[0][1] = 3.40126919746;
   fMin_1[1][1] = -3.67916750908;
   fMax_1[1][1] = 4.0258936882;
   fMin_1[2][1] = -4.08540010452;
   fMax_1[2][1] = 4.0258936882;
   fMin_1[0][2] = -3.18263268471;
   fMax_1[0][2] = 3.84756541252;
   fMin_1[1][2] = -5.05078554153;
   fMax_1[1][2] = 4.35967063904;
   fMin_1[2][2] = -5.05078554153;
   fMax_1[2][2] = 4.35967063904;
   fMin_1[0][3] = -2.99590206146;
   fMax_1[0][3] = 4.5351858139;
   fMin_1[1][3] = -5.95050764084;
   fMax_1[1][3] = 4.92254400253;
   fMin_1[2][3] = -5.95050764084;
   fMax_1[2][3] = 4.92254400253;
}

//_______________________________________________________________________
inline void ReadMLP::Transform_1( std::vector<double>& iv, int cls) const
{
   // Normalization transformation
   if (cls < 0 || cls > 2) {
   if (2 > 1 ) cls = 2;
      else cls = 2;
   }
   const int nVar = 4;

   // get indices of used variables

   // define the indices of the variables which are transformed by this transformation
   static std::vector<int> indicesGet;
   static std::vector<int> indicesPut;

   if ( indicesGet.empty() ) { 
      indicesGet.reserve(fNvars);
      indicesGet.push_back( 0);
      indicesGet.push_back( 1);
      indicesGet.push_back( 2);
      indicesGet.push_back( 3);
   } 
   if ( indicesPut.empty() ) { 
      indicesPut.reserve(fNvars);
      indicesPut.push_back( 0);
      indicesPut.push_back( 1);
      indicesPut.push_back( 2);
      indicesPut.push_back( 3);
   } 

   static std::vector<double> dv;
   dv.resize(nVar);
   for (int ivar=0; ivar<nVar; ivar++) dv[ivar] = iv[indicesGet.at(ivar)];
   for (int ivar=0;ivar<4;ivar++) {
      double offset = fMin_1[cls][ivar];
      double scale  = 1.0/(fMax_1[cls][ivar]-fMin_1[cls][ivar]);
      iv[indicesPut.at(ivar)] = (dv[ivar]-offset)*scale * 2 - 1;
   }
}

//_______________________________________________________________________
inline void ReadMLP::InitTransform()
{
   InitTransform_1();
}

//_______________________________________________________________________
inline void ReadMLP::Transform( std::vector<double>& iv, int sigOrBgd ) const
{
   Transform_1( iv, sigOrBgd );
}
