/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.loader.CollectionInitializer;
import net.sf.hibernate.loader.OuterJoinLoader;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.sql.ConditionFragment;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.sql.Select;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.Type;

public class OneToManyLoader
extends OuterJoinLoader
implements CollectionInitializer {
    private final CollectionPersister collectionPersister;
    private final Type idType;

    protected boolean enableJoinedFetch(boolean mappingDefault, String path, String table, String[] foreignKeyColumns) {
        return mappingDefault && (!table.equals(this.collectionPersister.getQualifiedTableName()) || !Arrays.equals(foreignKeyColumns, this.collectionPersister.getKeyColumnNames()));
    }

    public OneToManyLoader(CollectionPersister collPersister, SessionFactoryImplementor session) throws MappingException {
        super(session.getDialect());
        this.collectionPersister = collPersister;
        this.idType = collPersister.getKeyType();
        Loadable persister = (Loadable)session.getPersister(((EntityType)collPersister.getElementType()).getPersistentClass());
        String alias = OuterJoinLoader.alias(this.collectionPersister.getQualifiedTableName(), 0);
        String whereString = "";
        if (collPersister.hasWhere()) {
            whereString = " and " + collPersister.getSQLWhereString(alias);
        }
        List associations = this.walkTree(persister, alias, session);
        int joins = associations.size();
        this.suffixes = new String[joins + 1];
        int i = 0;
        while (i <= joins) {
            this.suffixes[i] = joins == 0 ? "" : Integer.toString(i) + '_';
            ++i;
        }
        JoinFragment ojf = this.outerJoins(associations);
        Select select = new Select().setSelectClause(collPersister.selectClauseFragment(alias) + (joins == 0 ? "" : ", " + this.selectString(associations)) + ", " + OuterJoinLoader.selectString(persister, alias, this.suffixes[joins])).setFromClause(persister.fromTableFragment(alias) + persister.fromJoinFragment(alias, true, true)).setWhereClause(new ConditionFragment().setTableAlias(alias).setCondition(collPersister.getKeyColumnNames(), "?").toFragmentString() + whereString).setOuterJoins(ojf.toFromFragmentString(), ojf.toWhereFragmentString() + persister.whereJoinFragment(alias, true, true));
        if (collPersister.hasOrdering()) {
            select.setOrderByClause(collPersister.getSQLOrderByString(alias));
        }
        this.sql = select.toStatementString();
        this.classPersisters = new Loadable[joins + 1];
        this.lockModeArray = this.createLockModeArray(joins + 1, LockMode.NONE);
        int i2 = 0;
        while (i2 < joins) {
            this.classPersisters[i2] = ((OuterJoinLoader.OuterJoinableAssociation)associations.get((int)i2)).subpersister;
            ++i2;
        }
        this.classPersisters[joins] = persister;
        this.postInstantiate();
    }

    protected CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    public void initialize(Serializable id, PersistentCollection collection, Object owner, SessionImplementor session) throws SQLException, HibernateException {
        this.loadCollection(session, id, this.idType, owner, collection);
    }
}

