//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// G4GPILSelection
//
// Description:
//
// This enumeration is used to control whether a AlongStepProcess
// can be a winner of the GPIL race or not.

// Authors:
//   Katsuya Amako  (e-mail: Katsuya.Amako@kek.jp)
//   Takashi Sasaki (e-mail: Takashi.Sasaki@kek.jp)
// --------------------------------------------------------------------
#ifndef G4GPILSelection_hh
#define G4GPILSelection_hh 1

enum G4GPILSelection
{
  CandidateForSelection,
  // This AlongStep process participates in the process selection
  // mechanism, i.e. it can be the winner of the GPIL race.
  // (this case is the default)

  NotCandidateForSelection
  // This AlongStep process does not partecipate in the
  // process selection mechanism even when it limits the Step.
};

#endif
