/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __lr10_dev_nport_ip_h__
#define __lr10_dev_nport_ip_h__
/* This file is autogenerated.  Do not edit */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_0                      0x0000010c      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_0_LIMIT                23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_0_LIMIT_INIT           0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_0_LIMIT__PROD          0x000000c0      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_0                   0x00000110      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_0_LIMIT             23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_0_LIMIT_INIT        0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_0_LIMIT__PROD       0x00000140      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_0                     0x00000114      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_0_LIMIT               23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_0_LIMIT_INIT          0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_0_LIMIT__PROD         0x00000680      /* RW--V */
#define NV_NPORT_CTRL_SLCG                                 0x00000050      /* RW-4R */
#define NV_NPORT_CTRL_SLCG_DIS_CG_INGRESS                  0:0             /* RWEVF */
#define NV_NPORT_CTRL_SLCG_DIS_CG_INGRESS_ENABLE           0x00000001      /* RWE-V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_INGRESS_DISABLE          0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_INGRESS__PROD            0x00000001      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_ROUTE                    1:1             /* RWEVF */
#define NV_NPORT_CTRL_SLCG_DIS_CG_ROUTE_ENABLE             0x00000001      /* RWE-V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_ROUTE_DISABLE            0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_ROUTE__PROD              0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_EGRESS                   2:2             /* RWEVF */
#define NV_NPORT_CTRL_SLCG_DIS_CG_EGRESS_ENABLE            0x00000001      /* RWE-V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_EGRESS_DISABLE           0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_EGRESS__PROD             0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_STRACK                   3:3             /* RWEVF */
#define NV_NPORT_CTRL_SLCG_DIS_CG_STRACK_ENABLE            0x00000001      /* RWE-V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_STRACK_DISABLE           0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_STRACK__PROD             0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_TAGSTATE                 4:4             /* RWEVF */
#define NV_NPORT_CTRL_SLCG_DIS_CG_TAGSTATE_ENABLE          0x00000001      /* RWE-V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_TAGSTATE_DISABLE         0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_TAGSTATE__PROD           0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_TREX                     5:5             /* RWEVF */
#define NV_NPORT_CTRL_SLCG_DIS_CG_TREX_ENABLE              0x00000001      /* RWE-V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_TREX_DISABLE             0x00000000      /* RW--V */
#define NV_NPORT_CTRL_SLCG_DIS_CG_TREX__PROD               0x00000000      /* RW--V */
#define NV_NPORT_PORTSTAT_COUNT_LOW_0_0                    0x00000120      /* R--4R */
#define NV_NPORT_PORTSTAT_COUNT_LOW_0_0_PACKETCOUNT        31:0            /* R-EVF */
#define NV_NPORT_PORTSTAT_COUNT_LOW_0_0_PACKETCOUNT_INIT   0x00000000      /* R-E-V */
#define NV_NPORT_PORTSTAT_COUNT_LOW_0_1                    0x00000124      /* R--4R */
#define NV_NPORT_PORTSTAT_COUNT_LOW_0_1_PACKETCOUNT        15:0            /* R-EVF */
#define NV_NPORT_PORTSTAT_COUNT_LOW_0_1_PACKETCOUNT_INIT   0x00000000      /* R-E-V */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_0_0                 0x00000128      /* R--4R */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_0_0_PACKETCOUNT     31:0            /* R-EVF */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_0_0_PACKETCOUNT_INIT 0x00000000     /* R-E-V */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_0_1                 0x0000012c      /* R--4R */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_0_1_PACKETCOUNT     15:0            /* R-EVF */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_0_1_PACKETCOUNT_INIT 0x00000000     /* R-E-V */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_0_0                   0x00000130      /* R--4R */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_0_0_PACKETCOUNT       31:0            /* R-EVF */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_0_0_PACKETCOUNT_INIT  0x00000000      /* R-E-V */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_0_1                   0x00000134      /* R--4R */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_0_1_PACKETCOUNT       15:0            /* R-EVF */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_0_1_PACKETCOUNT_INIT  0x00000000      /* R-E-V */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_0_0                  0x00000138      /* R--4R */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_0_0_PACKETCOUNT      31:0            /* R-EVF */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_0_0_PACKETCOUNT_INIT 0x00000000      /* R-E-V */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_0_1                  0x0000013c      /* R--4R */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_0_1_PACKETCOUNT      15:0            /* R-EVF */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_0_1_PACKETCOUNT_INIT 0x00000000      /* R-E-V */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_0_0                 0x00000118      /* R--4R */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_0_0_PACKETCOUNT     31:0            /* R-EVF */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_0_0_PACKETCOUNT_INIT 0x00000000     /* R-E-V */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_0_1                 0x0000011c      /* R--4R */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_0_1_PACKETCOUNT     15:0            /* R-EVF */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_0_1_PACKETCOUNT_INIT 0x00000000     /* R-E-V */
#define NV_NPORT_PORTSTAT_CONTROL                          0x00000100      /* RW-4R */
#define NV_NPORT_PORTSTAT_CONTROL_SWEEPMODE                1:0             /* RWEVF */
#define NV_NPORT_PORTSTAT_CONTROL_SWEEPMODE_SINGLE         0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_CONTROL_SWEEPMODE_CONTINUOUS     0x00000001      /* RW--V */
#define NV_NPORT_PORTSTAT_CONTROL_SWEEPMODE_SWONDEMAND     0x00000002      /* RW--V */
#define NV_NPORT_PORTSTAT_CONTROL_RANGESELECT              7:4             /* RWEVF */
#define NV_NPORT_PORTSTAT_CONTROL_RANGESELECT_BITS13TO0    0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_CONTROL_RANGESELECT_BITS15TO2    0x00000001      /* RW--V */
#define NV_NPORT_PORTSTAT_CONTROL_RANGESELECT_BITS17TO4    0x00000002      /* RW--V */
#define NV_NPORT_PORTSTAT_CONTROL_RANGESELECT_BITS19TO6    0x00000003      /* RW--V */
#define NV_NPORT_PORTSTAT_CONTROL_RANGESELECT_BITS21TO8    0x00000004      /* RW--V */
#define NV_NPORT_PORTSTAT_CONTROL_RANGESELECT_BITS23TO10   0x00000005      /* RW--V */
#define NV_NPORT_PORTSTAT_SOURCE_FILTER_0                  0x000002ac      /* RW-4R */
#define NV_NPORT_PORTSTAT_SOURCE_FILTER_0_SRCFILTERBIT     31:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_SOURCE_FILTER_0_SRCFILTERBIT_INIT 0x00000000     /* RWE-V */
#define NV_NPORT_PORTSTAT_SOURCE_FILTER_1                  0x000002b0      /* RW-4R */
#define NV_NPORT_PORTSTAT_SOURCE_FILTER_1_SRCFILTERBIT     3:0             /* RWEVF */
#define NV_NPORT_PORTSTAT_SOURCE_FILTER_1_SRCFILTERBIT_INIT 0x00000000     /* RWE-V */
#define NV_NPORT_PORTSTAT_WINDOW_LIMIT                     0x00000108      /* RW-4R */
#define NV_NPORT_PORTSTAT_WINDOW_LIMIT_WINDOWLIMIT         31:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_WINDOW_LIMIT_WINDOWLIMIT_INIT    0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_SNAP_CONTROL                     0x00000104      /* RW-4R */
#define NV_NPORT_PORTSTAT_SNAP_CONTROL_STARTCOUNTER        0:0             /* RWEVF */
#define NV_NPORT_PORTSTAT_SNAP_CONTROL_STARTCOUNTER_ENABLE 0x00000001      /* RW--V */
#define NV_NPORT_PORTSTAT_SNAP_CONTROL_STARTCOUNTER_DISABLE 0x00000000     /* RWE-V */
#define NV_NPORT_PORTSTAT_SNAP_CONTROL_SNAPONDEMAND        4:4             /* RWEVF */
#define NV_NPORT_PORTSTAT_SNAP_CONTROL_SNAPONDEMAND_ENABLE 0x00000001      /* RW--V */
#define NV_NPORT_PORTSTAT_SNAP_CONTROL_SNAPONDEMAND_DISABLE 0x00000000     /* RWE-V */
#define NV_NPORT_CTRL_BUFFER_READY                         0x00000044      /* RW-4R */
#define NV_NPORT_CTRL_BUFFER_READY_BUFFERRDY               0:0             /* RWEVF */
#define NV_NPORT_CTRL_BUFFER_READY_BUFFERRDY_ENABLE        0x00000001      /* RW--V */
#define NV_NPORT_CTRL_BUFFER_READY_BUFFERRDY_DISABLE       0x00000000      /* RWE-V */
#define NV_NPORT_REQLINKID                                 0x00000054      /* RW-4R */
#define NV_NPORT_REQLINKID_REQROUTINGID                    8:0             /* RWEVF */
#define NV_NPORT_REQLINKID_REQROUTINGID_INIT               0x00000000      /* RWE-V */
#define NV_NPORT_REQLINKID_REQROUTINGLAN                   18:15           /* RWEVF */
#define NV_NPORT_REQLINKID_REQROUTINGLAN_INIT              0x00000000      /* RWE-V */
#define NV_NPORT_REQLINKID_REQROUTINGIDREMAP               21:21           /* RWEVF */
#define NV_NPORT_REQLINKID_REQROUTINGIDREMAP_ENABLE        0x00000001      /* RW--V */
#define NV_NPORT_REQLINKID_REQROUTINGIDREMAP_DISABLE       0x00000000      /* RWE-V */
#define NV_NPORT_REQLINKID_REQROUTINGLANREMAP              22:22           /* RWEVF */
#define NV_NPORT_REQLINKID_REQROUTINGLANREMAP_ENABLE       0x00000001      /* RW--V */
#define NV_NPORT_REQLINKID_REQROUTINGLANREMAP_DISABLE      0x00000000      /* RWE-V */
#define NV_NPORT_REQLINKID_MASKS                           0x00000058      /* RW-4R */
#define NV_NPORT_REQLINKID_MASKS_REQROUTINGID_MASK         8:0             /* RWEVF */
#define NV_NPORT_REQLINKID_MASKS_REQROUTINGID_MASK_INIT    0x000001ff      /* RWE-V */
#define NV_NPORT_REQLINKID_MASKS_REQROUTINGLAN_MASK        18:15           /* RWEVF */
#define NV_NPORT_REQLINKID_MASKS_REQROUTINGLAN_MASK_INIT   0x0000000f      /* RWE-V */
#define NV_NPORT_CTRL                                      0x00000040      /* RW-4R */
#define NV_NPORT_CTRL_TRUNKLINKENB                         0:0             /* RWEVF */
#define NV_NPORT_CTRL_TRUNKLINKENB_TRUNKLINK               0x00000001      /* RW--V */
#define NV_NPORT_CTRL_TRUNKLINKENB_ACCESSLINK              0x00000000      /* RWE-V */
#define NV_NPORT_CTRL_EGDRAINENB                           1:1             /* RWEVF */
#define NV_NPORT_CTRL_EGDRAINENB_ENABLE                    0x00000001      /* RW--V */
#define NV_NPORT_CTRL_EGDRAINENB_DISABLE                   0x00000000      /* RWE-V */
#define NV_NPORT_CTRL_RTDRAINENB                           2:2             /* RWEVF */
#define NV_NPORT_CTRL_RTDRAINENB_ENABLE                    0x00000001      /* RW--V */
#define NV_NPORT_CTRL_RTDRAINENB_DISABLE                   0x00000000      /* RWE-V */
#define NV_NPORT_CTRL_ENDPOINT_COUNT                       5:4             /* RWEVF */
#define NV_NPORT_CTRL_ENDPOINT_COUNT_512                   0x00000000      /* RWE-V */
#define NV_NPORT_CTRL_ENDPOINT_COUNT_1024                  0x00000001      /* RW--V */
#define NV_NPORT_CTRL_ENDPOINT_COUNT_2048                  0x00000003      /* RW--V */
#define NV_NPORT_CTRL_INHIBITRAMLOAD                       8:8             /* RWEVF */
#define NV_NPORT_CTRL_INHIBITRAMLOAD_INIT                  0x00000000      /* RWE-V */
#define NV_NPORT_CTRL_SPARE                                13:9            /* RWEVF */
#define NV_NPORT_CTRL_SPARE_INIT                           0x00000000      /* RWE-V */
#define NV_NPORT_CTRL_ENROUTEDBI                           16:16           /* RWEVF */
#define NV_NPORT_CTRL_ENROUTEDBI_ENABLE                    0x00000001      /* RWE-V */
#define NV_NPORT_CTRL_ENROUTEDBI_DISABLE                   0x00000000      /* RW--V */
#define NV_NPORT_CTRL_ENEGRESSDBI                          17:17           /* RWEVF */
#define NV_NPORT_CTRL_ENEGRESSDBI_ENABLE                   0x00000001      /* RWE-V */
#define NV_NPORT_CTRL_ENEGRESSDBI_DISABLE                  0x00000000      /* RW--V */
#define NV_NPORT_ERR_CONTROL_COMMON_NPORT                  0x00000470      /* RW-4R */
#define NV_NPORT_ERR_CONTROL_COMMON_NPORT_CORRECTABLEENABLE 0:0            /* RWEVF */
#define NV_NPORT_ERR_CONTROL_COMMON_NPORT_CORRECTABLEENABLE_INIT 0x00000001 /* RWE-V */
#define NV_NPORT_ERR_CONTROL_COMMON_NPORT_FATALENABLE      1:1             /* RWEVF */
#define NV_NPORT_ERR_CONTROL_COMMON_NPORT_FATALENABLE_INIT 0x00000001      /* RWE-V */
#define NV_NPORT_ERR_CONTROL_COMMON_NPORT_NONFATALENABLE   2:2             /* RWEVF */
#define NV_NPORT_ERR_CONTROL_COMMON_NPORT_NONFATALENABLE_INIT 0x00000001   /* RWE-V */
#define NV_NPORT_CTRL_STOP                                 0x00000048      /* RW-4R */
#define NV_NPORT_CTRL_STOP_INGRESS_STOP                    0:0             /* RWEVF */
#define NV_NPORT_CTRL_STOP_INGRESS_STOP_STOP               0x00000001      /* RW--V */
#define NV_NPORT_CTRL_STOP_INGRESS_STOP_ALLOWTRAFFIC       0x00000000      /* RWE-V */
#define NV_NPORT_CTRL_STOP_EGRESS_STOP                     8:8             /* RWEVF */
#define NV_NPORT_CTRL_STOP_EGRESS_STOP_STOP                0x00000001      /* RW--V */
#define NV_NPORT_CTRL_STOP_EGRESS_STOP_ALLOWTRAFFIC        0x00000000      /* RWE-V */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC                   23:16           /* RWEVF */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC_ALLOWTRAFFIC      0x00000000      /* RWE-V */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC_STOPVC0           0x00000001      /* RW--V */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC_STOPVC1           0x00000002      /* RW--V */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC_STOPVC2           0x00000004      /* RW--V */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC_STOPVC3           0x00000008      /* RW--V */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC_STOPVC4           0x00000010      /* RW--V */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC_STOPVC5           0x00000020      /* RW--V */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC_STOPVC6           0x00000040      /* RW--V */
#define NV_NPORT_CTRL_STOP_ROUTE_STOP_VC_STOPVC7           0x00000080      /* RW--V */
#define NV_NPORT_CONTAIN_AND_DRAIN                         0x0000005c      /* RW-4R */
#define NV_NPORT_CONTAIN_AND_DRAIN_CLEAR                   18:18           /* RWIVF */
#define NV_NPORT_CONTAIN_AND_DRAIN_CLEAR_ENABLE            0x00000001      /* RW--V */
#define NV_NPORT_CONTAIN_AND_DRAIN_CLEAR_DISABLE           0x00000000      /* RWI-V */
#define NV_NPORT_INITIALIZATION                            0x0000004c      /* RW-4R */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_0              0:0             /* RWEVF */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_0_INIT         0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_0_HWINIT       0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_1              1:1             /* RWEVF */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_1_INIT         0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_1_HWINIT       0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_2              2:2             /* RWEVF */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_2_INIT         0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_2_HWINIT       0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_3              3:3             /* RWEVF */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_3_INIT         0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_3_HWINIT       0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_4              4:4             /* RWEVF */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_4_INIT         0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_4_HWINIT       0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_5              5:5             /* RWEVF */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_5_INIT         0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_5_HWINIT       0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_6              6:6             /* RWEVF */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_6_INIT         0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_TAGPOOLINIT_6_HWINIT       0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_LINKTABLEINIT              8:8             /* RWEVF */
#define NV_NPORT_INITIALIZATION_LINKTABLEINIT_INIT         0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_LINKTABLEINIT_HWINIT       0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_REMAPTABINIT               9:9             /* RWEVF */
#define NV_NPORT_INITIALIZATION_REMAPTABINIT_INIT          0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_REMAPTABINIT_HWINIT        0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_RIDTABINIT                 10:10           /* RWEVF */
#define NV_NPORT_INITIALIZATION_RIDTABINIT_INIT            0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_RIDTABINIT_HWINIT          0x00000001      /* RW--V */
#define NV_NPORT_INITIALIZATION_RLANTABINIT                11:11           /* RWEVF */
#define NV_NPORT_INITIALIZATION_RLANTABINIT_INIT           0x00000000      /* RWE-V */
#define NV_NPORT_INITIALIZATION_RLANTABINIT_HWINIT         0x00000001      /* RW--V */
#define NV_NPORT_SCRATCH_WARM                              0x00000fc0      /* RW-4R */
#define NV_NPORT_SCRATCH_WARM_DATA                         31:0            /* RWEVF */
#define NV_NPORT_SCRATCH_WARM_DATA_INIT                    0xdeadbaad      /* RWE-V */
#define NV_NPORT_PORTSTAT_COUNT_LOW_1_0                    0x00000154      /* R--4R */
#define NV_NPORT_PORTSTAT_COUNT_LOW_1_0_PACKETCOUNT        31:0            /* R-EVF */
#define NV_NPORT_PORTSTAT_COUNT_LOW_1_0_PACKETCOUNT_INIT   0x00000000      /* R-E-V */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_1_0                 0x0000015c      /* R--4R */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_1_0_PACKETCOUNT     31:0            /* R-EVF */
#define NV_NPORT_PORTSTAT_COUNT_MEDIUM_1_0_PACKETCOUNT_INIT 0x00000000     /* R-E-V */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_1_0                   0x00000164      /* R--4R */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_1_0_PACKETCOUNT       31:0            /* R-EVF */
#define NV_NPORT_PORTSTAT_COUNT_HIGH_1_0_PACKETCOUNT_INIT  0x00000000      /* R-E-V */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_1_0                  0x0000016c      /* R--4R */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_1_0_PACKETCOUNT      31:0            /* R-EVF */
#define NV_NPORT_PORTSTAT_COUNT_PANIC_1_0_PACKETCOUNT_INIT 0x00000000      /* R-E-V */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_1_0                 0x0000014c      /* R--4R */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_1_0_PACKETCOUNT     31:0            /* R-EVF */
#define NV_NPORT_PORTSTAT_PACKET_COUNT_1_0_PACKETCOUNT_INIT 0x00000000     /* R-E-V */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_1                      0x00000140      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_1_LIMIT                23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_1_LIMIT_INIT           0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_1_LIMIT__PROD          0x000000c0      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_1                   0x00000144      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_1_LIMIT             23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_1_LIMIT_INIT        0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_1_LIMIT__PROD       0x00000140      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_1                     0x00000148      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_1_LIMIT               23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_1_LIMIT_INIT          0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_1_LIMIT__PROD         0x00000680      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_1                      0x00000140      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_1_LIMIT                23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_1_LIMIT_INIT           0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_1_LIMIT__PROD          0x000000c0      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_1                   0x00000144      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_1_LIMIT             23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_1_LIMIT_INIT        0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_1_LIMIT__PROD       0x00000140      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_1                     0x00000148      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_1_LIMIT               23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_1_LIMIT_INIT          0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_1_LIMIT__PROD         0x00000680      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_2                      0x00000174      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_2_LIMIT                23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_2_LIMIT_INIT           0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_2_LIMIT__PROD          0x000000c0      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_2                   0x00000178      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_2_LIMIT             23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_2_LIMIT_INIT        0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_2_LIMIT__PROD       0x00000140      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_2                     0x0000017c      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_2_LIMIT               23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_2_LIMIT_INIT          0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_2_LIMIT__PROD         0x00000680      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_3                      0x000001a8      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_3_LIMIT                23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_3_LIMIT_INIT           0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_3_LIMIT__PROD          0x000000c0      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_3                   0x000001ac      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_3_LIMIT             23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_3_LIMIT_INIT        0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_3_LIMIT__PROD       0x00000140      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_3                     0x000001b0      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_3_LIMIT               23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_3_LIMIT_INIT          0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_3_LIMIT__PROD         0x00000680      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_4                      0x000001dc      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_4_LIMIT                23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_4_LIMIT_INIT           0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_4_LIMIT__PROD          0x000000c0      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_4                   0x000001e0      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_4_LIMIT             23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_4_LIMIT_INIT        0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_4_LIMIT__PROD       0x00000140      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_4                     0x000001e4      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_4_LIMIT               23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_4_LIMIT_INIT          0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_4_LIMIT__PROD         0x00000680      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_5                      0x00000210      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_5_LIMIT                23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_5_LIMIT_INIT           0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_5_LIMIT__PROD          0x000000c0      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_5                   0x00000214      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_5_LIMIT             23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_5_LIMIT_INIT        0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_5_LIMIT__PROD       0x00000140      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_5                     0x00000218      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_5_LIMIT               23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_5_LIMIT_INIT          0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_5_LIMIT__PROD         0x00000680      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_6                      0x00000244      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_6_LIMIT                23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_6_LIMIT_INIT           0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_6_LIMIT__PROD          0x000000c0      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_6                   0x00000248      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_6_LIMIT             23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_6_LIMIT_INIT        0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_6_LIMIT__PROD       0x00000140      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_6                     0x0000024c      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_6_LIMIT               23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_6_LIMIT_INIT          0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_6_LIMIT__PROD         0x00000680      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_7                      0x00000278      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_7_LIMIT                23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_7_LIMIT_INIT           0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_LOW_7_LIMIT__PROD          0x000000c0      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_7                   0x0000027c      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_7_LIMIT             23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_7_LIMIT_INIT        0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_MEDIUM_7_LIMIT__PROD       0x00000140      /* RW--V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_7                     0x00000280      /* RW-4R */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_7_LIMIT               23:0            /* RWEVF */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_7_LIMIT_INIT          0x00000000      /* RWE-V */
#define NV_NPORT_PORTSTAT_LIMIT_HIGH_7_LIMIT__PROD         0x00000680      /* RW--V */
#endif // __lr10_dev_nport_ip_h__
