﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/backup/model/UpdateRestoreTestingPlanResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::Backup::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

UpdateRestoreTestingPlanResult::UpdateRestoreTestingPlanResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

UpdateRestoreTestingPlanResult& UpdateRestoreTestingPlanResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("CreationTime")) {
    m_creationTime = jsonValue.GetDouble("CreationTime");
    m_creationTimeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("RestoreTestingPlanArn")) {
    m_restoreTestingPlanArn = jsonValue.GetString("RestoreTestingPlanArn");
    m_restoreTestingPlanArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("RestoreTestingPlanName")) {
    m_restoreTestingPlanName = jsonValue.GetString("RestoreTestingPlanName");
    m_restoreTestingPlanNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("UpdateTime")) {
    m_updateTime = jsonValue.GetDouble("UpdateTime");
    m_updateTimeHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
