﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cleanroomsml/model/ListConfiguredModelAlgorithmAssociationsResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::CleanRoomsML::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListConfiguredModelAlgorithmAssociationsResult::ListConfiguredModelAlgorithmAssociationsResult(
    const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

ListConfiguredModelAlgorithmAssociationsResult& ListConfiguredModelAlgorithmAssociationsResult::operator=(
    const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }
  if (jsonValue.ValueExists("configuredModelAlgorithmAssociations")) {
    Aws::Utils::Array<JsonView> configuredModelAlgorithmAssociationsJsonList = jsonValue.GetArray("configuredModelAlgorithmAssociations");
    for (unsigned configuredModelAlgorithmAssociationsIndex = 0;
         configuredModelAlgorithmAssociationsIndex < configuredModelAlgorithmAssociationsJsonList.GetLength();
         ++configuredModelAlgorithmAssociationsIndex) {
      m_configuredModelAlgorithmAssociations.push_back(
          configuredModelAlgorithmAssociationsJsonList[configuredModelAlgorithmAssociationsIndex].AsObject());
    }
    m_configuredModelAlgorithmAssociationsHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
