﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/clouddirectory/model/BatchGetObjectInformation.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace CloudDirectory {
namespace Model {

BatchGetObjectInformation::BatchGetObjectInformation(JsonView jsonValue) { *this = jsonValue; }

BatchGetObjectInformation& BatchGetObjectInformation::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("ObjectReference")) {
    m_objectReference = jsonValue.GetObject("ObjectReference");
    m_objectReferenceHasBeenSet = true;
  }
  return *this;
}

JsonValue BatchGetObjectInformation::Jsonize() const {
  JsonValue payload;

  if (m_objectReferenceHasBeenSet) {
    payload.WithObject("ObjectReference", m_objectReference.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace CloudDirectory
}  // namespace Aws
