﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/connect/model/UpdateQueueOutboundEmailConfigRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Connect::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateQueueOutboundEmailConfigRequest::SerializePayload() const {
  JsonValue payload;

  if (m_outboundEmailConfigHasBeenSet) {
    payload.WithObject("OutboundEmailConfig", m_outboundEmailConfig.Jsonize());
  }

  return payload.View().WriteReadable();
}
