// |jit-test| skip-if: !wasmSimdEnabled()

/* Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// ./test/core/simd/simd_i8x16_arith2.wast

// ./test/core/simd/simd_i8x16_arith2.wast:3
let $0 = instantiate(`(module
  (func (export "i8x16.min_s") (param v128 v128) (result v128) (i8x16.min_s (local.get 0) (local.get 1)))
  (func (export "i8x16.min_u") (param v128 v128) (result v128) (i8x16.min_u (local.get 0) (local.get 1)))
  (func (export "i8x16.max_s") (param v128 v128) (result v128) (i8x16.max_s (local.get 0) (local.get 1)))
  (func (export "i8x16.max_u") (param v128 v128) (result v128) (i8x16.max_u (local.get 0) (local.get 1)))
  (func (export "i8x16.avgr_u") (param v128 v128) (result v128) (i8x16.avgr_u (local.get 0) (local.get 1)))
  (func (export "i8x16.abs") (param v128) (result v128) (i8x16.abs (local.get 0)))
  (func (export "i8x16.popcnt") (param v128) (result v128) (i8x16.popcnt (local.get 0)))
  (func (export "i8x16.min_s_with_const_0") (result v128) (i8x16.min_s (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255) (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128)))
  (func (export "i8x16.min_s_with_const_1") (result v128) (i8x16.min_s (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3) (v128.const i8x16 3 3 3 3 2 2 2 2 1 1 1 1 0 0 0 0)))
  (func (export "i8x16.min_u_with_const_2") (result v128) (i8x16.min_u (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255) (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128)))
  (func (export "i8x16.min_u_with_const_3") (result v128) (i8x16.min_u (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3) (v128.const i8x16 3 3 3 3 2 2 2 2 1 1 1 1 0 0 0 0)))
  (func (export "i8x16.max_s_with_const_4") (result v128) (i8x16.max_s (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255) (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128)))
  (func (export "i8x16.max_s_with_const_5") (result v128) (i8x16.max_s (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3) (v128.const i8x16 3 3 3 3 2 2 2 2 1 1 1 1 0 0 0 0)))
  (func (export "i8x16.max_u_with_const_6") (result v128) (i8x16.max_u (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255) (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128)))
  (func (export "i8x16.max_u_with_const_7") (result v128) (i8x16.max_u (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3) (v128.const i8x16 3 3 3 3 2 2 2 2 1 1 1 1 0 0 0 0)))
  (func (export "i8x16.avgr_u_with_const_8") (result v128) (i8x16.avgr_u (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255) (v128.const i8x16 255 255 255 255 64 64 64 64 127 127 127 127 -128 -128 -128 -128)))
  (func (export "i8x16.avgr_u_with_const_9") (result v128) (i8x16.avgr_u (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3) (v128.const i8x16 3 3 3 3 2 2 2 2 1 1 1 1 0 0 0 0)))
  (func (export "i8x16.abs_with_const_10") (result v128) (i8x16.abs (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255)))
  (func (export "i8x16.popcnt_with_const_11") (result v128) (i8x16.popcnt (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255)))
  (func (export "i8x16.min_s_with_const_12") (param v128) (result v128) (i8x16.min_s (local.get 0) (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255)))
  (func (export "i8x16.min_s_with_const_13") (param v128) (result v128) (i8x16.min_s (local.get 0) (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3)))
  (func (export "i8x16.min_u_with_const_14") (param v128) (result v128) (i8x16.min_u (local.get 0) (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255)))
  (func (export "i8x16.min_u_with_const_15") (param v128) (result v128) (i8x16.min_u (local.get 0) (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3)))
  (func (export "i8x16.max_s_with_const_16") (param v128) (result v128) (i8x16.max_s (local.get 0) (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255)))
  (func (export "i8x16.max_s_with_const_17") (param v128) (result v128) (i8x16.max_s (local.get 0) (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3)))
  (func (export "i8x16.max_u_with_const_18") (param v128) (result v128) (i8x16.max_u (local.get 0) (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255)))
  (func (export "i8x16.max_u_with_const_19") (param v128) (result v128) (i8x16.max_u (local.get 0) (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3)))
  (func (export "i8x16.avgr_u_with_const_20") (param v128) (result v128) (i8x16.avgr_u (local.get 0) (v128.const i8x16 -128 -128 -128 -128 127 127 127 127 64 64 64 64 255 255 255 255)))
  (func (export "i8x16.avgr_u_with_const_21") (param v128) (result v128) (i8x16.avgr_u (local.get 0) (v128.const i8x16 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3)))
)`);

// ./test/core/simd/simd_i8x16_arith2.wast:35
assert_return(
  () => invoke($0, `i8x16.min_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:38
assert_return(
  () => invoke($0, `i8x16.min_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:41
assert_return(
  () => invoke($0, `i8x16.min_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:44
assert_return(
  () => invoke($0, `i8x16.min_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:47
assert_return(
  () => invoke($0, `i8x16.min_s`, [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:50
assert_return(
  () => invoke($0, `i8x16.min_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:53
assert_return(
  () => invoke($0, `i8x16.min_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:56
assert_return(
  () => invoke($0, `i8x16.min_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:59
assert_return(
  () => invoke($0, `i8x16.min_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:62
assert_return(
  () => invoke($0, `i8x16.min_s`, [
    i8x16([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
    i8x16([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
  ]),
  [
    i8x16([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:65
assert_return(
  () => invoke($0, `i8x16.min_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:68
assert_return(
  () => invoke($0, `i8x16.min_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:71
assert_return(
  () => invoke($0, `i8x16.min_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:74
assert_return(
  () => invoke($0, `i8x16.min_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:77
assert_return(
  () => invoke($0, `i8x16.min_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:80
assert_return(
  () => invoke($0, `i8x16.min_u`, [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:83
assert_return(
  () => invoke($0, `i8x16.min_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:86
assert_return(
  () => invoke($0, `i8x16.min_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:89
assert_return(
  () => invoke($0, `i8x16.min_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:92
assert_return(
  () => invoke($0, `i8x16.min_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:95
assert_return(
  () => invoke($0, `i8x16.min_u`, [
    i8x16([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
    i8x16([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
  ]),
  [
    i8x16([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:98
assert_return(
  () => invoke($0, `i8x16.min_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:101
assert_return(
  () => invoke($0, `i8x16.max_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:104
assert_return(
  () => invoke($0, `i8x16.max_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:107
assert_return(
  () => invoke($0, `i8x16.max_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:110
assert_return(
  () => invoke($0, `i8x16.max_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:113
assert_return(
  () => invoke($0, `i8x16.max_s`, [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:116
assert_return(
  () => invoke($0, `i8x16.max_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:119
assert_return(
  () => invoke($0, `i8x16.max_s`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:122
assert_return(
  () => invoke($0, `i8x16.max_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:125
assert_return(
  () => invoke($0, `i8x16.max_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:128
assert_return(
  () => invoke($0, `i8x16.max_s`, [
    i8x16([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
    i8x16([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
  ]),
  [
    i8x16([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:131
assert_return(
  () => invoke($0, `i8x16.max_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:134
assert_return(
  () => invoke($0, `i8x16.max_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:137
assert_return(
  () => invoke($0, `i8x16.max_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:140
assert_return(
  () => invoke($0, `i8x16.max_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:143
assert_return(
  () => invoke($0, `i8x16.max_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:146
assert_return(
  () => invoke($0, `i8x16.max_u`, [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:149
assert_return(
  () => invoke($0, `i8x16.max_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:152
assert_return(
  () => invoke($0, `i8x16.max_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:155
assert_return(
  () => invoke($0, `i8x16.max_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:158
assert_return(
  () => invoke($0, `i8x16.max_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:161
assert_return(
  () => invoke($0, `i8x16.max_u`, [
    i8x16([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
    i8x16([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
  ]),
  [
    i8x16([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:164
assert_return(
  () => invoke($0, `i8x16.max_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:167
assert_return(
  () => invoke($0, `i8x16.avgr_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:170
assert_return(
  () => invoke($0, `i8x16.avgr_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:173
assert_return(
  () => invoke($0, `i8x16.avgr_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:176
assert_return(
  () => invoke($0, `i8x16.avgr_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:179
assert_return(
  () => invoke($0, `i8x16.avgr_u`, [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:182
assert_return(
  () => invoke($0, `i8x16.avgr_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:185
assert_return(
  () => invoke($0, `i8x16.avgr_u`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:188
assert_return(
  () => invoke($0, `i8x16.avgr_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:191
assert_return(
  () => invoke($0, `i8x16.avgr_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:194
assert_return(
  () => invoke($0, `i8x16.avgr_u`, [
    i8x16([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
    i8x16([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
  ]),
  [
    i8x16([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:197
assert_return(
  () => invoke($0, `i8x16.avgr_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:200
assert_return(
  () => invoke($0, `i8x16.abs`, [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:202
assert_return(
  () => invoke($0, `i8x16.abs`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:204
assert_return(
  () => invoke($0, `i8x16.abs`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:206
assert_return(
  () => invoke($0, `i8x16.abs`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:208
assert_return(
  () => invoke($0, `i8x16.abs`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:210
assert_return(
  () => invoke($0, `i8x16.abs`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:212
assert_return(
  () => invoke($0, `i8x16.abs`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:214
assert_return(
  () => invoke($0, `i8x16.abs`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:216
assert_return(
  () => invoke($0, `i8x16.abs`, [
    i8x16([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
  ]),
  [
    i8x16([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:218
assert_return(
  () => invoke($0, `i8x16.abs`, [
    i8x16([0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85]),
  ]),
  [
    i8x16([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:220
assert_return(
  () => invoke($0, `i8x16.abs`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:222
assert_return(
  () => invoke($0, `i8x16.abs`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:224
assert_return(
  () => invoke($0, `i8x16.abs`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:226
assert_return(
  () => invoke($0, `i8x16.abs`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:228
assert_return(
  () => invoke($0, `i8x16.popcnt`, [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:230
assert_return(
  () => invoke($0, `i8x16.popcnt`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:232
assert_return(
  () => invoke($0, `i8x16.popcnt`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:234
assert_return(
  () => invoke($0, `i8x16.popcnt`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:236
assert_return(
  () => invoke($0, `i8x16.popcnt`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:238
assert_return(
  () => invoke($0, `i8x16.popcnt`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:240
assert_return(
  () => invoke($0, `i8x16.popcnt`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:242
assert_return(
  () => invoke($0, `i8x16.popcnt`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:244
assert_return(
  () => invoke($0, `i8x16.popcnt`, [
    i8x16([0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b]),
  ]),
  [
    i8x16([0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:246
assert_return(
  () => invoke($0, `i8x16.popcnt`, [
    i8x16([0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85]),
  ]),
  [
    i8x16([0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:248
assert_return(
  () => invoke($0, `i8x16.popcnt`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:250
assert_return(
  () => invoke($0, `i8x16.popcnt`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:252
assert_return(
  () => invoke($0, `i8x16.popcnt`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:254
assert_return(
  () => invoke($0, `i8x16.popcnt`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:258
assert_return(
  () => invoke($0, `i8x16.min_s_with_const_0`, []),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:259
assert_return(
  () => invoke($0, `i8x16.min_s_with_const_1`, []),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:260
assert_return(
  () => invoke($0, `i8x16.min_u_with_const_2`, []),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:261
assert_return(
  () => invoke($0, `i8x16.min_u_with_const_3`, []),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:262
assert_return(
  () => invoke($0, `i8x16.max_s_with_const_4`, []),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:263
assert_return(
  () => invoke($0, `i8x16.max_s_with_const_5`, []),
  [
    i8x16([0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:264
assert_return(
  () => invoke($0, `i8x16.max_u_with_const_6`, []),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:265
assert_return(
  () => invoke($0, `i8x16.max_u_with_const_7`, []),
  [
    i8x16([0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:266
assert_return(
  () => invoke($0, `i8x16.avgr_u_with_const_8`, []),
  [
    i8x16([0xc0, 0xc0, 0xc0, 0xc0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0xc0, 0xc0, 0xc0, 0xc0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:267
assert_return(
  () => invoke($0, `i8x16.avgr_u_with_const_9`, []),
  [
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:268
assert_return(
  () => invoke($0, `i8x16.abs_with_const_10`, []),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x40, 0x40, 0x40, 0x40, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:269
assert_return(
  () => invoke($0, `i8x16.popcnt_with_const_11`, []),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x7, 0x7, 0x7, 0x7, 0x1, 0x1, 0x1, 0x1, 0x8, 0x8, 0x8, 0x8]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:272
assert_return(
  () => invoke($0, `i8x16.min_s_with_const_12`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0x40, 0x40, 0x40, 0x40, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:274
assert_return(
  () => invoke($0, `i8x16.min_s_with_const_13`, [
    i8x16([0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:276
assert_return(
  () => invoke($0, `i8x16.min_u_with_const_14`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0x40, 0x40, 0x40, 0x40, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:278
assert_return(
  () => invoke($0, `i8x16.min_u_with_const_15`, [
    i8x16([0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:280
assert_return(
  () => invoke($0, `i8x16.max_s_with_const_16`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0x40, 0x40, 0x40, 0x40, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:282
assert_return(
  () => invoke($0, `i8x16.max_s_with_const_17`, [
    i8x16([0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:284
assert_return(
  () => invoke($0, `i8x16.max_u_with_const_18`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0x40, 0x40, 0x40, 0x40, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:286
assert_return(
  () => invoke($0, `i8x16.max_u_with_const_19`, [
    i8x16([0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:288
assert_return(
  () => invoke($0, `i8x16.avgr_u_with_const_20`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0x40, 0x40, 0x40, 0x40, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0xc0, 0xc0, 0xc0, 0xc0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0xc0, 0xc0, 0xc0, 0xc0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:290
assert_return(
  () => invoke($0, `i8x16.avgr_u_with_const_21`, [
    i8x16([0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:294
assert_return(
  () => invoke($0, `i8x16.min_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x40, 0x40, 0x40, 0x40, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0x40, 0x40, 0x40, 0x40, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:297
assert_return(
  () => invoke($0, `i8x16.min_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:300
assert_return(
  () => invoke($0, `i8x16.min_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x40, 0x40, 0x40, 0x40, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0x40, 0x40, 0x40, 0x40, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:303
assert_return(
  () => invoke($0, `i8x16.min_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:306
assert_return(
  () => invoke($0, `i8x16.max_s`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x40, 0x40, 0x40, 0x40, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0x40, 0x40, 0x40, 0x40, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:309
assert_return(
  () => invoke($0, `i8x16.max_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:312
assert_return(
  () => invoke($0, `i8x16.max_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x40, 0x40, 0x40, 0x40, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0x40, 0x40, 0x40, 0x40, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0xff, 0xff, 0xff, 0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0xff, 0xff, 0xff, 0xff]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:315
assert_return(
  () => invoke($0, `i8x16.max_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:318
assert_return(
  () => invoke($0, `i8x16.avgr_u`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x40, 0x40, 0x40, 0x40, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0x40, 0x40, 0x40, 0x40, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0xc0, 0xc0, 0xc0, 0xc0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0xc0, 0xc0, 0xc0, 0xc0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:321
assert_return(
  () => invoke($0, `i8x16.avgr_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x80, 0x80, 0x80, 0x80]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x80, 0x80, 0x80, 0x80]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:324
assert_return(
  () => invoke($0, `i8x16.abs`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x40, 0x40, 0x40, 0x40, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x40, 0x40, 0x40, 0x40, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:326
assert_return(
  () => invoke($0, `i8x16.popcnt`, [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x40, 0x40, 0x40, 0x40, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x7, 0x7, 0x7, 0x7, 0x1, 0x1, 0x1, 0x1, 0x8, 0x8, 0x8, 0x8]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:330
assert_return(
  () => invoke($0, `i8x16.min_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:333
assert_return(
  () => invoke($0, `i8x16.min_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:336
assert_return(
  () => invoke($0, `i8x16.min_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:339
assert_return(
  () => invoke($0, `i8x16.min_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:342
assert_return(
  () => invoke($0, `i8x16.max_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:345
assert_return(
  () => invoke($0, `i8x16.max_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:348
assert_return(
  () => invoke($0, `i8x16.max_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:351
assert_return(
  () => invoke($0, `i8x16.max_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:354
assert_return(
  () => invoke($0, `i8x16.avgr_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:357
assert_return(
  () => invoke($0, `i8x16.avgr_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:360
assert_return(
  () => invoke($0, `i8x16.abs`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:362
assert_return(
  () => invoke($0, `i8x16.abs`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:364
assert_return(
  () => invoke($0, `i8x16.abs`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:366
assert_return(
  () => invoke($0, `i8x16.abs`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:368
assert_return(
  () => invoke($0, `i8x16.popcnt`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:370
assert_return(
  () => invoke($0, `i8x16.popcnt`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:372
assert_return(
  () => invoke($0, `i8x16.popcnt`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:374
assert_return(
  () => invoke($0, `i8x16.popcnt`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:378
assert_malformed(
  () => instantiate(`(memory 1) (func (result v128) (i32x4.avgr_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))) `),
  `unknown operator`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:379
assert_malformed(
  () => instantiate(`(memory 1) (func (result v128) (f32x4.avgr_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))) `),
  `unknown operator`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:380
assert_malformed(
  () => instantiate(`(memory 1) (func (result v128) (i64x2.avgr_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))) `),
  `unknown operator`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:381
assert_malformed(
  () => instantiate(`(memory 1) (func (result v128) (f64x2.avgr_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))) `),
  `unknown operator`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:382
assert_malformed(
  () => instantiate(`(memory 1) (func (result v128) (i8x16.avgr (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))) `),
  `unknown operator`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:383
assert_malformed(
  () => instantiate(`(memory 1) (func (result v128) (i8x16.avgr_s (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))) `),
  `unknown operator`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:386
assert_invalid(
  () => instantiate(`(module (func (result v128) (i8x16.min_s (i32.const 0) (f32.const 0.0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:387
assert_invalid(
  () => instantiate(`(module (func (result v128) (i8x16.min_u (i32.const 0) (f32.const 0.0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:388
assert_invalid(
  () => instantiate(`(module (func (result v128) (i8x16.max_s (i32.const 0) (f32.const 0.0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:389
assert_invalid(
  () => instantiate(`(module (func (result v128) (i8x16.max_u (i32.const 0) (f32.const 0.0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:390
assert_invalid(
  () => instantiate(`(module (func (result v128) (i8x16.avgr_u (i32.const 0) (f32.const 0.0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:391
assert_invalid(
  () => instantiate(`(module (func (result v128) (i8x16.abs (f32.const 0.0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:392
assert_invalid(
  () => instantiate(`(module (func (result v128) (i8x16.popcnt (f32.const 0.0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:396
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.min_s-1st-arg-empty (result v128)
      (i8x16.min_s (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:404
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.min_s-arg-empty (result v128)
      (i8x16.min_s)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:412
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.min_u-1st-arg-empty (result v128)
      (i8x16.min_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:420
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.min_u-arg-empty (result v128)
      (i8x16.min_u)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:428
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.max_s-1st-arg-empty (result v128)
      (i8x16.max_s (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:436
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.max_s-arg-empty (result v128)
      (i8x16.max_s)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:444
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.max_u-1st-arg-empty (result v128)
      (i8x16.max_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:452
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.max_u-arg-empty (result v128)
      (i8x16.max_u)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:460
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.avgr_u-1st-arg-empty (result v128)
      (i8x16.avgr_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:468
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.avgr_u-arg-empty (result v128)
      (i8x16.avgr_u)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:476
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.abs-arg-empty (result v128)
      (i8x16.abs)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:484
assert_invalid(
  () => instantiate(`(module
    (func \$i8x16.popcnt-arg-empty (result v128)
      (i8x16.popcnt)
    )
  )`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith2.wast:494
let $1 = instantiate(`(module
  (func (export "i8x16.min_s-i8x16.avgr_u") (param v128 v128 v128) (result v128) (i8x16.min_s (i8x16.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_s-i8x16.max_u") (param v128 v128 v128) (result v128) (i8x16.min_s (i8x16.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_s-i8x16.max_s") (param v128 v128 v128) (result v128) (i8x16.min_s (i8x16.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_s-i8x16.min_u") (param v128 v128 v128) (result v128) (i8x16.min_s (i8x16.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_s-i8x16.min_s") (param v128 v128 v128) (result v128) (i8x16.min_s (i8x16.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_s-i8x16.abs") (param v128 v128) (result v128) (i8x16.min_s (i8x16.abs (local.get 0))(local.get 1)))
  (func (export "i8x16.abs-i8x16.min_s") (param v128 v128) (result v128) (i8x16.abs (i8x16.min_s (local.get 0) (local.get 1))))
  (func (export "i8x16.min_s-i8x16.popcnt") (param v128 v128) (result v128) (i8x16.min_s (i8x16.popcnt (local.get 0))(local.get 1)))
  (func (export "i8x16.popcnt-i8x16.min_s") (param v128 v128) (result v128) (i8x16.popcnt (i8x16.min_s (local.get 0) (local.get 1))))
  (func (export "i8x16.min_u-i8x16.avgr_u") (param v128 v128 v128) (result v128) (i8x16.min_u (i8x16.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_u-i8x16.max_u") (param v128 v128 v128) (result v128) (i8x16.min_u (i8x16.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_u-i8x16.max_s") (param v128 v128 v128) (result v128) (i8x16.min_u (i8x16.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_u-i8x16.min_u") (param v128 v128 v128) (result v128) (i8x16.min_u (i8x16.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_u-i8x16.min_s") (param v128 v128 v128) (result v128) (i8x16.min_u (i8x16.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.min_u-i8x16.abs") (param v128 v128) (result v128) (i8x16.min_u (i8x16.abs (local.get 0))(local.get 1)))
  (func (export "i8x16.abs-i8x16.min_u") (param v128 v128) (result v128) (i8x16.abs (i8x16.min_u (local.get 0) (local.get 1))))
  (func (export "i8x16.min_u-i8x16.popcnt") (param v128 v128) (result v128) (i8x16.min_u (i8x16.popcnt (local.get 0))(local.get 1)))
  (func (export "i8x16.popcnt-i8x16.min_u") (param v128 v128) (result v128) (i8x16.popcnt (i8x16.min_u (local.get 0) (local.get 1))))
  (func (export "i8x16.max_s-i8x16.avgr_u") (param v128 v128 v128) (result v128) (i8x16.max_s (i8x16.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_s-i8x16.max_u") (param v128 v128 v128) (result v128) (i8x16.max_s (i8x16.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_s-i8x16.max_s") (param v128 v128 v128) (result v128) (i8x16.max_s (i8x16.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_s-i8x16.min_u") (param v128 v128 v128) (result v128) (i8x16.max_s (i8x16.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_s-i8x16.min_s") (param v128 v128 v128) (result v128) (i8x16.max_s (i8x16.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_s-i8x16.abs") (param v128 v128) (result v128) (i8x16.max_s (i8x16.abs (local.get 0))(local.get 1)))
  (func (export "i8x16.abs-i8x16.max_s") (param v128 v128) (result v128) (i8x16.abs (i8x16.max_s (local.get 0) (local.get 1))))
  (func (export "i8x16.max_s-i8x16.popcnt") (param v128 v128) (result v128) (i8x16.max_s (i8x16.popcnt (local.get 0))(local.get 1)))
  (func (export "i8x16.popcnt-i8x16.max_s") (param v128 v128) (result v128) (i8x16.popcnt (i8x16.max_s (local.get 0) (local.get 1))))
  (func (export "i8x16.max_u-i8x16.avgr_u") (param v128 v128 v128) (result v128) (i8x16.max_u (i8x16.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_u-i8x16.max_u") (param v128 v128 v128) (result v128) (i8x16.max_u (i8x16.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_u-i8x16.max_s") (param v128 v128 v128) (result v128) (i8x16.max_u (i8x16.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_u-i8x16.min_u") (param v128 v128 v128) (result v128) (i8x16.max_u (i8x16.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_u-i8x16.min_s") (param v128 v128 v128) (result v128) (i8x16.max_u (i8x16.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.max_u-i8x16.abs") (param v128 v128) (result v128) (i8x16.max_u (i8x16.abs (local.get 0))(local.get 1)))
  (func (export "i8x16.abs-i8x16.max_u") (param v128 v128) (result v128) (i8x16.abs (i8x16.max_u (local.get 0) (local.get 1))))
  (func (export "i8x16.max_u-i8x16.popcnt") (param v128 v128) (result v128) (i8x16.max_u (i8x16.popcnt (local.get 0))(local.get 1)))
  (func (export "i8x16.popcnt-i8x16.max_u") (param v128 v128) (result v128) (i8x16.popcnt (i8x16.max_u (local.get 0) (local.get 1))))
  (func (export "i8x16.avgr_u-i8x16.avgr_u") (param v128 v128 v128) (result v128) (i8x16.avgr_u (i8x16.avgr_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.avgr_u-i8x16.max_u") (param v128 v128 v128) (result v128) (i8x16.avgr_u (i8x16.max_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.avgr_u-i8x16.max_s") (param v128 v128 v128) (result v128) (i8x16.avgr_u (i8x16.max_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.avgr_u-i8x16.min_u") (param v128 v128 v128) (result v128) (i8x16.avgr_u (i8x16.min_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.avgr_u-i8x16.min_s") (param v128 v128 v128) (result v128) (i8x16.avgr_u (i8x16.min_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "i8x16.avgr_u-i8x16.abs") (param v128 v128) (result v128) (i8x16.avgr_u (i8x16.abs (local.get 0))(local.get 1)))
  (func (export "i8x16.abs-i8x16.avgr_u") (param v128 v128) (result v128) (i8x16.abs (i8x16.avgr_u (local.get 0) (local.get 1))))
  (func (export "i8x16.avgr_u-i8x16.popcnt") (param v128 v128) (result v128) (i8x16.avgr_u (i8x16.popcnt (local.get 0))(local.get 1)))
  (func (export "i8x16.popcnt-i8x16.avgr_u") (param v128 v128) (result v128) (i8x16.popcnt (i8x16.avgr_u (local.get 0) (local.get 1))))
  (func (export "i8x16.abs-i8x16.popcnt") (param v128) (result v128) (i8x16.abs (i8x16.popcnt (local.get 0))))
  (func (export "i8x16.abs-i8x16.abs") (param v128) (result v128) (i8x16.abs (i8x16.abs (local.get 0))))
  (func (export "i8x16.popcnt-i8x16.popcnt") (param v128) (result v128) (i8x16.popcnt (i8x16.popcnt (local.get 0))))
  (func (export "i8x16.popcnt-i8x16.abs") (param v128) (result v128) (i8x16.popcnt (i8x16.abs (local.get 0))))
)`);

// ./test/core/simd/simd_i8x16_arith2.wast:546
assert_return(
  () => invoke($1, `i8x16.min_s-i8x16.avgr_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:550
assert_return(
  () => invoke($1, `i8x16.min_s-i8x16.max_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:554
assert_return(
  () => invoke($1, `i8x16.min_s-i8x16.max_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:558
assert_return(
  () => invoke($1, `i8x16.min_s-i8x16.min_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:562
assert_return(
  () => invoke($1, `i8x16.min_s-i8x16.min_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:566
assert_return(
  () => invoke($1, `i8x16.min_s-i8x16.abs`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:569
assert_return(
  () => invoke($1, `i8x16.abs-i8x16.min_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:572
assert_return(
  () => invoke($1, `i8x16.min_s-i8x16.popcnt`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:575
assert_return(
  () => invoke($1, `i8x16.popcnt-i8x16.min_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:578
assert_return(
  () => invoke($1, `i8x16.min_u-i8x16.avgr_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:582
assert_return(
  () => invoke($1, `i8x16.min_u-i8x16.max_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:586
assert_return(
  () => invoke($1, `i8x16.min_u-i8x16.max_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:590
assert_return(
  () => invoke($1, `i8x16.min_u-i8x16.min_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:594
assert_return(
  () => invoke($1, `i8x16.min_u-i8x16.min_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:598
assert_return(
  () => invoke($1, `i8x16.min_u-i8x16.abs`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:601
assert_return(
  () => invoke($1, `i8x16.abs-i8x16.min_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:604
assert_return(
  () => invoke($1, `i8x16.min_u-i8x16.popcnt`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:607
assert_return(
  () => invoke($1, `i8x16.popcnt-i8x16.min_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:610
assert_return(
  () => invoke($1, `i8x16.max_s-i8x16.avgr_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:614
assert_return(
  () => invoke($1, `i8x16.max_s-i8x16.max_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:618
assert_return(
  () => invoke($1, `i8x16.max_s-i8x16.max_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:622
assert_return(
  () => invoke($1, `i8x16.max_s-i8x16.min_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:626
assert_return(
  () => invoke($1, `i8x16.max_s-i8x16.min_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:630
assert_return(
  () => invoke($1, `i8x16.max_s-i8x16.abs`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:633
assert_return(
  () => invoke($1, `i8x16.abs-i8x16.max_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:636
assert_return(
  () => invoke($1, `i8x16.max_s-i8x16.popcnt`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:639
assert_return(
  () => invoke($1, `i8x16.popcnt-i8x16.max_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:642
assert_return(
  () => invoke($1, `i8x16.max_u-i8x16.avgr_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:646
assert_return(
  () => invoke($1, `i8x16.max_u-i8x16.max_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:650
assert_return(
  () => invoke($1, `i8x16.max_u-i8x16.max_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:654
assert_return(
  () => invoke($1, `i8x16.max_u-i8x16.min_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:658
assert_return(
  () => invoke($1, `i8x16.max_u-i8x16.min_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:662
assert_return(
  () => invoke($1, `i8x16.max_u-i8x16.abs`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:665
assert_return(
  () => invoke($1, `i8x16.abs-i8x16.max_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:668
assert_return(
  () => invoke($1, `i8x16.max_u-i8x16.popcnt`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:671
assert_return(
  () => invoke($1, `i8x16.popcnt-i8x16.max_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:674
assert_return(
  () => invoke($1, `i8x16.avgr_u-i8x16.avgr_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:678
assert_return(
  () => invoke($1, `i8x16.avgr_u-i8x16.max_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:682
assert_return(
  () => invoke($1, `i8x16.avgr_u-i8x16.max_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:686
assert_return(
  () => invoke($1, `i8x16.avgr_u-i8x16.min_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:690
assert_return(
  () => invoke($1, `i8x16.avgr_u-i8x16.min_s`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    i8x16([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:694
assert_return(
  () => invoke($1, `i8x16.avgr_u-i8x16.abs`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:697
assert_return(
  () => invoke($1, `i8x16.abs-i8x16.avgr_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:700
assert_return(
  () => invoke($1, `i8x16.avgr_u-i8x16.popcnt`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
  ]),
  [
    i8x16([0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:703
assert_return(
  () => invoke($1, `i8x16.popcnt-i8x16.avgr_u`, [
    i8x16([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:706
assert_return(
  () => invoke($1, `i8x16.abs-i8x16.popcnt`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:708
assert_return(
  () => invoke($1, `i8x16.abs-i8x16.abs`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:710
assert_return(
  () => invoke($1, `i8x16.popcnt-i8x16.popcnt`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);

// ./test/core/simd/simd_i8x16_arith2.wast:712
assert_return(
  () => invoke($1, `i8x16.popcnt-i8x16.abs`, [
    i8x16([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]),
  ]),
  [
    i8x16([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
  ],
);
