// Copyright © Advanced Micro Devices, Inc., or its affiliates.
// SPDX-License-Identifier: MIT

#pragma once

#include "HipdnnBackendAttributeName.h"
#include "HipdnnBackendAttributeType.h"
#include "HipdnnBackendDescriptorType.h"
#include "HipdnnBackendPluginLoadingMode.h"
#include "HipdnnStatus.h"

namespace hipdnn_backend
{

inline const char* hipdnnGetStatusString(hipdnnStatus_t status)
{
    switch(status)
    {
    case HIPDNN_STATUS_SUCCESS:
        return "HIPDNN_STATUS_SUCCESS";
    case HIPDNN_STATUS_NOT_INITIALIZED:
        return "HIPDNN_STATUS_NOT_INITIALIZED";
    case HIPDNN_STATUS_BAD_PARAM:
        return "HIPDNN_STATUS_BAD_PARAM";
    case HIPDNN_STATUS_BAD_PARAM_NULL_POINTER:
        return "HIPDNN_STATUS_BAD_PARAM_NULL_POINTER";
    case HIPDNN_STATUS_BAD_PARAM_NOT_FINALIZED:
        return "HIPDNN_STATUS_BAD_PARAM_NOT_FINALIZED";
    case HIPDNN_STATUS_BAD_PARAM_OUT_OF_BOUND:
        return "HIPDNN_STATUS_BAD_PARAM_OUT_OF_BOUND";
    case HIPDNN_STATUS_BAD_PARAM_SIZE_INSUFFICIENT:
        return "HIPDNN_STATUS_BAD_PARAM_SIZE_INSUFFICIENT";
    case HIPDNN_STATUS_BAD_PARAM_STREAM_MISMATCH:
        return "HIPDNN_STATUS_BAD_PARAM_STREAM_MISMATCH";
    case HIPDNN_STATUS_NOT_SUPPORTED:
        return "HIPDNN_STATUS_NOT_SUPPORTED";
    case HIPDNN_STATUS_INTERNAL_ERROR:
        return "HIPDNN_STATUS_INTERNAL_ERROR";
    case HIPDNN_STATUS_ALLOC_FAILED:
        return "HIPDNN_STATUS_ALLOC_FAILED";
    case HIPDNN_STATUS_INTERNAL_ERROR_HOST_ALLOCATION_FAILED:
        return "HIPDNN_STATUS_INTERNAL_ERROR_HOST_ALLOCATION_FAILED";
    case HIPDNN_STATUS_INTERNAL_ERROR_DEVICE_ALLOCATION_FAILED:
        return "HIPDNN_STATUS_INTERNAL_ERROR_DEVICE_ALLOCATION_FAILED";
    case HIPDNN_STATUS_EXECUTION_FAILED:
        return "HIPDNN_STATUS_EXECUTION_FAILED";
    default:
        return "HIPDNN_STATUS_UNKNOWN";
    }
}

inline const char* hipdnnGetAttributeTypeString(hipdnnBackendAttributeType_t type)
{
    switch(type)
    {
    case HIPDNN_TYPE_HANDLE:
        return "HIPDNN_TYPE_HANDLE";
    case HIPDNN_TYPE_DATA_TYPE:
        return "HIPDNN_TYPE_DATA_TYPE";
    case HIPDNN_TYPE_BOOLEAN:
        return "HIPDNN_TYPE_BOOLEAN";
    case HIPDNN_TYPE_INT64:
        return "HIPDNN_TYPE_INT64";
    case HIPDNN_TYPE_FLOAT:
        return "HIPDNN_TYPE_FLOAT";
    case HIPDNN_TYPE_DOUBLE:
        return "HIPDNN_TYPE_DOUBLE";
    case HIPDNN_TYPE_VOID_PTR:
        return "HIPDNN_TYPE_VOID_PTR";
    case HIPDNN_TYPE_HEUR_MODE:
        return "HIPDNN_TYPE_HEUR_MODE";
    case HIPDNN_TYPE_KNOB_TYPE:
        return "HIPDNN_TYPE_KNOB_TYPE";
    case HIPDNN_TYPE_NAN_PROPOGATION:
        return "HIPDNN_TYPE_NAN_PROPOGATION";
    case HIPDNN_TYPE_NUMERICAL_NOTE:
        return "HIPDNN_TYPE_NUMERICAL_NOTE";
    case HIPDNN_TYPE_LAYOUT_TYPE:
        return "HIPDNN_TYPE_LAYOUT_TYPE";
    case HIPDNN_TYPE_ATTRIB_NAME:
        return "HIPDNN_TYPE_ATTRIB_NAME";
    case HIPDNN_TYPE_BACKEND_DESCRIPTOR:
        return "HIPDNN_TYPE_BACKEND_DESCRIPTOR";
    case HIPDNN_TYPE_GENSTATS_MODE:
        return "HIPDNN_TYPE_GENSTATS_MODE";
    case HIPDNN_TYPE_BN_FINALIZE_STATS_MODE:
        return "HIPDNN_TYPE_BN_FINALIZE_STATS_MODE";
    case HIPDNN_TYPE_BEHAVIOR_NOTE:
        return "HIPDNN_TYPE_BEHAVIOR_NOTE";
    case HIPDNN_TYPE_TENSOR_REORDERING_MODE:
        return "HIPDNN_TYPE_TENSOR_REORDERING_MODE";
    case HIPDNN_TYPE_INT32:
        return "HIPDNN_TYPE_INT32";
    case HIPDNN_TYPE_CHAR:
        return "HIPDNN_TYPE_CHAR";
    case HIPDNN_TYPE_SIGNAL_MODE:
        return "HIPDNN_TYPE_SIGNAL_MODE";
    case HIPDNN_TYPE_FRACTION:
        return "HIPDNN_TYPE_FRACTION";
    case HIPDNN_TYPE_NORM_FWD_PHASE:
        return "HIPDNN_TYPE_NORM_FWD_PHASE";
    case HIPDNN_TYPE_RNG_DISTRIBUTION:
        return "HIPDNN_TYPE_RNG_DISTRIBUTION";
    default:
        return "HIPDNN_ATTRIBUTE_UNKNOWN";
    }
}

inline const char* hipdnnGetBackendDescriptorTypeName(hipdnnBackendDescriptorType_t type)
{
    switch(type)
    {
    case HIPDNN_BACKEND_ENGINE_DESCRIPTOR:
        return "HIPDNN_BACKEND_ENGINE_DESCRIPTOR";
    case HIPDNN_BACKEND_ENGINECFG_DESCRIPTOR:
        return "HIPDNN_BACKEND_ENGINECFG_DESCRIPTOR";
    case HIPDNN_BACKEND_ENGINEHEUR_DESCRIPTOR:
        return "HIPDNN_BACKEND_ENGINEHEUR_DESCRIPTOR";
    case HIPDNN_BACKEND_EXECUTION_PLAN_DESCRIPTOR:
        return "HIPDNN_BACKEND_EXECUTION_PLAN_DESCRIPTOR";
    case HIPDNN_BACKEND_INTERMEDIATE_INFO_DESCRIPTOR:
        return "HIPDNN_BACKEND_INTERMEDIATE_INFO_DESCRIPTOR";
    case HIPDNN_BACKEND_KNOB_CHOICE_DESCRIPTOR:
        return "HIPDNN_BACKEND_KNOB_CHOICE_DESCRIPTOR";
    case HIPDNN_BACKEND_KNOB_INFO_DESCRIPTOR:
        return "HIPDNN_BACKEND_KNOB_INFO_DESCRIPTOR";
    case HIPDNN_BACKEND_LAYOUT_INFO_DESCRIPTOR:
        return "HIPDNN_BACKEND_LAYOUT_INFO_DESCRIPTOR";
    case HIPDNN_BACKEND_OPERATION_GEN_STATS_DESCRIPTOR:
        return "HIPDNN_BACKEND_OPERATION_GEN_STATS_DESCRIPTOR";
    case HIPDNN_BACKEND_OPERATIONGRAPH_DESCRIPTOR:
        return "HIPDNN_BACKEND_OPERATIONGRAPH_DESCRIPTOR";
    case HIPDNN_BACKEND_VARIANT_PACK_DESCRIPTOR:
        return "HIPDNN_BACKEND_VARIANT_PACK_DESCRIPTOR";
    case HIPDNN_BACKEND_KERNEL_CACHE_DESCRIPTOR:
        return "HIPDNN_BACKEND_KERNEL_CACHE_DESCRIPTOR";
    case HIPDNN_BACKEND_OPERATION_PAGED_CACHE_LOAD_DESCRIPTOR:
        return "HIPDNN_BACKEND_OPERATION_PAGED_CACHE_LOAD_DESCRIPTOR";
    default:
        return "UNKNOWN_TYPE";
    }
}

inline const char* hipdnnGetAttributeNameString(hipdnnBackendAttributeName_t attr)
{
    switch(attr)
    {
    case HIPDNN_ATTR_ENGINEHEUR_MODE:
        return "HIPDNN_ATTR_ENGINEHEUR_MODE";
    case HIPDNN_ATTR_ENGINEHEUR_OPERATION_GRAPH:
        return "HIPDNN_ATTR_ENGINEHEUR_OPERATION_GRAPH";
    case HIPDNN_ATTR_ENGINEHEUR_RESULTS:
        return "HIPDNN_ATTR_ENGINEHEUR_RESULTS";
    case HIPDNN_ATTR_ENGINEHEUR_SM_COUNT_TARGET:
        return "HIPDNN_ATTR_ENGINEHEUR_SM_COUNT_TARGET";
    case HIPDNN_ATTR_ENGINEHEUR_DEVICEPROP:
        return "HIPDNN_ATTR_ENGINEHEUR_DEVICEPROP";

    case HIPDNN_ATTR_ENGINECFG_ENGINE:
        return "HIPDNN_ATTR_ENGINECFG_ENGINE";
    case HIPDNN_ATTR_ENGINECFG_INTERMEDIATE_INFO:
        return "HIPDNN_ATTR_ENGINECFG_INTERMEDIATE_INFO";
    case HIPDNN_ATTR_ENGINECFG_KNOB_CHOICES:
        return "HIPDNN_ATTR_ENGINECFG_KNOB_CHOICES";
    case HIPDNN_ATTR_ENGINECFG_WORKSPACE_SIZE:
        return "HIPDNN_ATTR_ENGINECFG_WORKSPACE_SIZE";

    case HIPDNN_ATTR_EXECUTION_PLAN_HANDLE:
        return "HIPDNN_ATTR_EXECUTION_PLAN_HANDLE";
    case HIPDNN_ATTR_EXECUTION_PLAN_ENGINE_CONFIG:
        return "HIPDNN_ATTR_EXECUTION_PLAN_ENGINE_CONFIG";
    case HIPDNN_ATTR_EXECUTION_PLAN_WORKSPACE_SIZE:
        return "HIPDNN_ATTR_EXECUTION_PLAN_WORKSPACE_SIZE";
    case HIPDNN_ATTR_EXECUTION_PLAN_COMPUTED_INTERMEDIATE_UIDS:
        return "HIPDNN_ATTR_EXECUTION_PLAN_COMPUTED_INTERMEDIATE_UIDS";
    case HIPDNN_ATTR_EXECUTION_PLAN_RUN_ONLY_INTERMEDIATE_UIDS:
        return "HIPDNN_ATTR_EXECUTION_PLAN_RUN_ONLY_INTERMEDIATE_UIDS";
    case HIPDNN_ATTR_EXECUTION_PLAN_JSON_REPRESENTATION:
        return "HIPDNN_ATTR_EXECUTION_PLAN_JSON_REPRESENTATION";
    case HIPDNN_ATTR_EXECUTION_PLAN_KERNEL_CACHE:
        return "HIPDNN_ATTR_EXECUTION_PLAN_KERNEL_CACHE";
    case HIPDNN_ATTR_EXECUTION_PLAN_DEVICEPROP:
        return "HIPDNN_ATTR_EXECUTION_PLAN_DEVICEPROP";

    case HIPDNN_ATTR_INTERMEDIATE_INFO_UNIQUE_ID:
        return "HIPDNN_ATTR_INTERMEDIATE_INFO_UNIQUE_ID";
    case HIPDNN_ATTR_INTERMEDIATE_INFO_SIZE:
        return "HIPDNN_ATTR_INTERMEDIATE_INFO_SIZE";
    case HIPDNN_ATTR_INTERMEDIATE_INFO_DEPENDENT_DATA_UIDS:
        return "HIPDNN_ATTR_INTERMEDIATE_INFO_DEPENDENT_DATA_UIDS";
    case HIPDNN_ATTR_INTERMEDIATE_INFO_DEPENDENT_ATTRIBUTES:
        return "HIPDNN_ATTR_INTERMEDIATE_INFO_DEPENDENT_ATTRIBUTES";

    case HIPDNN_ATTR_KNOB_CHOICE_KNOB_TYPE:
        return "HIPDNN_ATTR_KNOB_CHOICE_KNOB_TYPE";
    case HIPDNN_ATTR_KNOB_CHOICE_KNOB_VALUE:
        return "HIPDNN_ATTR_KNOB_CHOICE_KNOB_VALUE";

    case HIPDNN_ATTR_OPERATIONGRAPH_HANDLE:
        return "HIPDNN_ATTR_OPERATIONGRAPH_HANDLE";
    case HIPDNN_ATTR_OPERATIONGRAPH_OPS:
        return "HIPDNN_ATTR_OPERATIONGRAPH_OPS";
    case HIPDNN_ATTR_OPERATIONGRAPH_ENGINE_GLOBAL_COUNT:
        return "HIPDNN_ATTR_OPERATIONGRAPH_ENGINE_GLOBAL_COUNT";
    case HIPDNN_ATTR_OPERATIONGRAPH_IS_DYNAMIC_SHAPE_ENABLED:
        return "HIPDNN_ATTR_OPERATIONGRAPH_IS_DYNAMIC_SHAPE_ENABLED";

    case HIPDNN_ATTR_VARIANT_PACK_UNIQUE_IDS:
        return "HIPDNN_ATTR_VARIANT_PACK_UNIQUE_IDS";
    case HIPDNN_ATTR_VARIANT_PACK_DATA_POINTERS:
        return "HIPDNN_ATTR_VARIANT_PACK_DATA_POINTERS";
    case HIPDNN_ATTR_VARIANT_PACK_INTERMEDIATES:
        return "HIPDNN_ATTR_VARIANT_PACK_INTERMEDIATES";
    case HIPDNN_ATTR_VARIANT_PACK_WORKSPACE:
        return "HIPDNN_ATTR_VARIANT_PACK_WORKSPACE";

    case HIPDNN_ATTR_LAYOUT_INFO_TENSOR_UID:
        return "HIPDNN_ATTR_LAYOUT_INFO_TENSOR_UID";
    case HIPDNN_ATTR_LAYOUT_INFO_TYPES:
        return "HIPDNN_ATTR_LAYOUT_INFO_TYPES";

    case HIPDNN_ATTR_KNOB_INFO_TYPE:
        return "HIPDNN_ATTR_KNOB_INFO_TYPE";
    case HIPDNN_ATTR_KNOB_INFO_MAXIMUM_VALUE:
        return "HIPDNN_ATTR_KNOB_INFO_MAXIMUM_VALUE";
    case HIPDNN_ATTR_KNOB_INFO_MINIMUM_VALUE:
        return "HIPDNN_ATTR_KNOB_INFO_MINIMUM_VALUE";
    case HIPDNN_ATTR_KNOB_INFO_STRIDE:
        return "HIPDNN_ATTR_KNOB_INFO_STRIDE";

    case HIPDNN_ATTR_ENGINE_OPERATION_GRAPH:
        return "HIPDNN_ATTR_ENGINE_OPERATION_GRAPH";
    case HIPDNN_ATTR_ENGINE_GLOBAL_INDEX:
        return "HIPDNN_ATTR_ENGINE_GLOBAL_INDEX";
    case HIPDNN_ATTR_ENGINE_KNOB_INFO:
        return "HIPDNN_ATTR_ENGINE_KNOB_INFO";
    case HIPDNN_ATTR_ENGINE_NUMERICAL_NOTE:
        return "HIPDNN_ATTR_ENGINE_NUMERICAL_NOTE";
    case HIPDNN_ATTR_ENGINE_LAYOUT_INFO:
        return "HIPDNN_ATTR_ENGINE_LAYOUT_INFO";
    case HIPDNN_ATTR_ENGINE_BEHAVIOR_NOTE:
        return "HIPDNN_ATTR_ENGINE_BEHAVIOR_NOTE";
    case HIPDNN_ATTR_ENGINE_SM_COUNT_TARGET:
        return "HIPDNN_ATTR_ENGINE_SM_COUNT_TARGET";
    case HIPDNN_ATTR_ENGINE_DEVICEPROP:
        return "HIPDNN_ATTR_ENGINE_DEVICEPROP";

    case HIPDNN_ATTR_KERNEL_CACHE_IS_ENGINECFG_KERNEL_CACHED:
        return "HIPDNN_ATTR_KERNEL_CACHE_IS_ENGINECFG_KERNEL_CACHED";

    case HIPDNN_ATTR_DEVICEPROP_DEVICE_ID:
        return "HIPDNN_ATTR_DEVICEPROP_DEVICE_ID";
    case HIPDNN_ATTR_DEVICEPROP_HANDLE:
        return "HIPDNN_ATTR_DEVICEPROP_HANDLE";
    case HIPDNN_ATTR_DEVICEPROP_JSON_REPRESENTATION:
        return "HIPDNN_ATTR_DEVICEPROP_JSON_REPRESENTATION";
    default:
        return "HIPDNN_ATTR_UNKNOWN";
    }
}

inline const char* hipdnnGetPluginLoadingModeString(hipdnnPluginLoadingMode_ext_t mode)
{
    switch(mode)
    {
    case HIPDNN_PLUGIN_LOADING_ADDITIVE:
        return "HIPDNN_PLUGIN_LOADING_ADDITIVE";
    case HIPDNN_PLUGIN_LOADING_ABSOLUTE:
        return "HIPDNN_PLUGIN_LOADING_ABSOLUTE";
    default:
        return "HIPDNN_PLUGIN_LOADING_UNKNOWN";
    }
}

} // namespace hipdnn_backend
